/******/ (function() { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 6411:
/***/ (function(module, exports) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
	autosize 4.0.2
	license: MIT
	http://www.jacklmoore.com/autosize
*/
(function (global, factory) {
	if (true) {
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	} else { var mod; }
})(this, function (module, exports) {
	'use strict';

	var map = typeof Map === "function" ? new Map() : function () {
		var keys = [];
		var values = [];

		return {
			has: function has(key) {
				return keys.indexOf(key) > -1;
			},
			get: function get(key) {
				return values[keys.indexOf(key)];
			},
			set: function set(key, value) {
				if (keys.indexOf(key) === -1) {
					keys.push(key);
					values.push(value);
				}
			},
			delete: function _delete(key) {
				var index = keys.indexOf(key);
				if (index > -1) {
					keys.splice(index, 1);
					values.splice(index, 1);
				}
			}
		};
	}();

	var createEvent = function createEvent(name) {
		return new Event(name, { bubbles: true });
	};
	try {
		new Event('test');
	} catch (e) {
		// IE does not support `new Event()`
		createEvent = function createEvent(name) {
			var evt = document.createEvent('Event');
			evt.initEvent(name, true, false);
			return evt;
		};
	}

	function assign(ta) {
		if (!ta || !ta.nodeName || ta.nodeName !== 'TEXTAREA' || map.has(ta)) return;

		var heightOffset = null;
		var clientWidth = null;
		var cachedHeight = null;

		function init() {
			var style = window.getComputedStyle(ta, null);

			if (style.resize === 'vertical') {
				ta.style.resize = 'none';
			} else if (style.resize === 'both') {
				ta.style.resize = 'horizontal';
			}

			if (style.boxSizing === 'content-box') {
				heightOffset = -(parseFloat(style.paddingTop) + parseFloat(style.paddingBottom));
			} else {
				heightOffset = parseFloat(style.borderTopWidth) + parseFloat(style.borderBottomWidth);
			}
			// Fix when a textarea is not on document body and heightOffset is Not a Number
			if (isNaN(heightOffset)) {
				heightOffset = 0;
			}

			update();
		}

		function changeOverflow(value) {
			{
				// Chrome/Safari-specific fix:
				// When the textarea y-overflow is hidden, Chrome/Safari do not reflow the text to account for the space
				// made available by removing the scrollbar. The following forces the necessary text reflow.
				var width = ta.style.width;
				ta.style.width = '0px';
				// Force reflow:
				/* jshint ignore:start */
				ta.offsetWidth;
				/* jshint ignore:end */
				ta.style.width = width;
			}

			ta.style.overflowY = value;
		}

		function getParentOverflows(el) {
			var arr = [];

			while (el && el.parentNode && el.parentNode instanceof Element) {
				if (el.parentNode.scrollTop) {
					arr.push({
						node: el.parentNode,
						scrollTop: el.parentNode.scrollTop
					});
				}
				el = el.parentNode;
			}

			return arr;
		}

		function resize() {
			if (ta.scrollHeight === 0) {
				// If the scrollHeight is 0, then the element probably has display:none or is detached from the DOM.
				return;
			}

			var overflows = getParentOverflows(ta);
			var docTop = document.documentElement && document.documentElement.scrollTop; // Needed for Mobile IE (ticket #240)

			ta.style.height = '';
			ta.style.height = ta.scrollHeight + heightOffset + 'px';

			// used to check if an update is actually necessary on window.resize
			clientWidth = ta.clientWidth;

			// prevents scroll-position jumping
			overflows.forEach(function (el) {
				el.node.scrollTop = el.scrollTop;
			});

			if (docTop) {
				document.documentElement.scrollTop = docTop;
			}
		}

		function update() {
			resize();

			var styleHeight = Math.round(parseFloat(ta.style.height));
			var computed = window.getComputedStyle(ta, null);

			// Using offsetHeight as a replacement for computed.height in IE, because IE does not account use of border-box
			var actualHeight = computed.boxSizing === 'content-box' ? Math.round(parseFloat(computed.height)) : ta.offsetHeight;

			// The actual height not matching the style height (set via the resize method) indicates that 
			// the max-height has been exceeded, in which case the overflow should be allowed.
			if (actualHeight < styleHeight) {
				if (computed.overflowY === 'hidden') {
					changeOverflow('scroll');
					resize();
					actualHeight = computed.boxSizing === 'content-box' ? Math.round(parseFloat(window.getComputedStyle(ta, null).height)) : ta.offsetHeight;
				}
			} else {
				// Normally keep overflow set to hidden, to avoid flash of scrollbar as the textarea expands.
				if (computed.overflowY !== 'hidden') {
					changeOverflow('hidden');
					resize();
					actualHeight = computed.boxSizing === 'content-box' ? Math.round(parseFloat(window.getComputedStyle(ta, null).height)) : ta.offsetHeight;
				}
			}

			if (cachedHeight !== actualHeight) {
				cachedHeight = actualHeight;
				var evt = createEvent('autosize:resized');
				try {
					ta.dispatchEvent(evt);
				} catch (err) {
					// Firefox will throw an error on dispatchEvent for a detached element
					// https://bugzilla.mozilla.org/show_bug.cgi?id=889376
				}
			}
		}

		var pageResize = function pageResize() {
			if (ta.clientWidth !== clientWidth) {
				update();
			}
		};

		var destroy = function (style) {
			window.removeEventListener('resize', pageResize, false);
			ta.removeEventListener('input', update, false);
			ta.removeEventListener('keyup', update, false);
			ta.removeEventListener('autosize:destroy', destroy, false);
			ta.removeEventListener('autosize:update', update, false);

			Object.keys(style).forEach(function (key) {
				ta.style[key] = style[key];
			});

			map.delete(ta);
		}.bind(ta, {
			height: ta.style.height,
			resize: ta.style.resize,
			overflowY: ta.style.overflowY,
			overflowX: ta.style.overflowX,
			wordWrap: ta.style.wordWrap
		});

		ta.addEventListener('autosize:destroy', destroy, false);

		// IE9 does not fire onpropertychange or oninput for deletions,
		// so binding to onkeyup to catch most of those events.
		// There is no way that I know of to detect something like 'cut' in IE9.
		if ('onpropertychange' in ta && 'oninput' in ta) {
			ta.addEventListener('keyup', update, false);
		}

		window.addEventListener('resize', pageResize, false);
		ta.addEventListener('input', update, false);
		ta.addEventListener('autosize:update', update, false);
		ta.style.overflowX = 'hidden';
		ta.style.wordWrap = 'break-word';

		map.set(ta, {
			destroy: destroy,
			update: update
		});

		init();
	}

	function destroy(ta) {
		var methods = map.get(ta);
		if (methods) {
			methods.destroy();
		}
	}

	function update(ta) {
		var methods = map.get(ta);
		if (methods) {
			methods.update();
		}
	}

	var autosize = null;

	// Do nothing in Node.js environment and IE8 (or lower)
	if (typeof window === 'undefined' || typeof window.getComputedStyle !== 'function') {
		autosize = function autosize(el) {
			return el;
		};
		autosize.destroy = function (el) {
			return el;
		};
		autosize.update = function (el) {
			return el;
		};
	} else {
		autosize = function autosize(el, options) {
			if (el) {
				Array.prototype.forEach.call(el.length ? el : [el], function (x) {
					return assign(x, options);
				});
			}
			return el;
		};
		autosize.destroy = function (el) {
			if (el) {
				Array.prototype.forEach.call(el.length ? el : [el], destroy);
			}
			return el;
		};
		autosize.update = function (el) {
			if (el) {
				Array.prototype.forEach.call(el.length ? el : [el], update);
			}
			return el;
		};
	}

	exports.default = autosize;
	module.exports = exports['default'];
});

/***/ }),

/***/ 4403:
/***/ (function(module, exports) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
  Copyright (c) 2018 Jed Watson.
  Licensed under the MIT License (MIT), see
  http://jedwatson.github.io/classnames
*/
/* global define */

(function () {
	'use strict';

	var hasOwn = {}.hasOwnProperty;

	function classNames() {
		var classes = [];

		for (var i = 0; i < arguments.length; i++) {
			var arg = arguments[i];
			if (!arg) continue;

			var argType = typeof arg;

			if (argType === 'string' || argType === 'number') {
				classes.push(arg);
			} else if (Array.isArray(arg)) {
				if (arg.length) {
					var inner = classNames.apply(null, arg);
					if (inner) {
						classes.push(inner);
					}
				}
			} else if (argType === 'object') {
				if (arg.toString === Object.prototype.toString) {
					for (var key in arg) {
						if (hasOwn.call(arg, key) && arg[key]) {
							classes.push(key);
						}
					}
				} else {
					classes.push(arg.toString());
				}
			}
		}

		return classes.join(' ');
	}

	if ( true && module.exports) {
		classNames.default = classNames;
		module.exports = classNames;
	} else if (true) {
		// register as 'classnames', consistent with npm package name
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function () {
			return classNames;
		}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	} else {}
}());


/***/ }),

/***/ 4827:
/***/ (function(module) {

// This code has been refactored for 140 bytes
// You can see the original here: https://github.com/twolfson/computedStyle/blob/04cd1da2e30fa45844f95f5cb1ac898e9b9ef050/lib/computedStyle.js
var computedStyle = function (el, prop, getComputedStyle) {
  getComputedStyle = window.getComputedStyle;

  // In one fell swoop
  return (
    // If we have getComputedStyle
    getComputedStyle ?
      // Query it
      // TODO: From CSS-Query notes, we might need (node, null) for FF
      getComputedStyle(el) :

    // Otherwise, we are in IE and use currentStyle
      el.currentStyle
  )[
    // Switch to camelCase for CSSOM
    // DEV: Grabbed from jQuery
    // https://github.com/jquery/jquery/blob/1.9-stable/src/css.js#L191-L194
    // https://github.com/jquery/jquery/blob/1.9-stable/src/core.js#L593-L597
    prop.replace(/-(\w)/gi, function (word, letter) {
      return letter.toUpperCase();
    })
  ];
};

module.exports = computedStyle;


/***/ }),

/***/ 1198:
/***/ (function(__unused_webpack_module, exports) {

"use strict";
/*istanbul ignore start*/


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = Diff;

/*istanbul ignore end*/
function Diff() {}

Diff.prototype = {
  /*istanbul ignore start*/

  /*istanbul ignore end*/
  diff: function diff(oldString, newString) {
    /*istanbul ignore start*/
    var
    /*istanbul ignore end*/
    options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var callback = options.callback;

    if (typeof options === 'function') {
      callback = options;
      options = {};
    }

    this.options = options;
    var self = this;

    function done(value) {
      if (callback) {
        setTimeout(function () {
          callback(undefined, value);
        }, 0);
        return true;
      } else {
        return value;
      }
    } // Allow subclasses to massage the input prior to running


    oldString = this.castInput(oldString);
    newString = this.castInput(newString);
    oldString = this.removeEmpty(this.tokenize(oldString));
    newString = this.removeEmpty(this.tokenize(newString));
    var newLen = newString.length,
        oldLen = oldString.length;
    var editLength = 1;
    var maxEditLength = newLen + oldLen;
    var bestPath = [{
      newPos: -1,
      components: []
    }]; // Seed editLength = 0, i.e. the content starts with the same values

    var oldPos = this.extractCommon(bestPath[0], newString, oldString, 0);

    if (bestPath[0].newPos + 1 >= newLen && oldPos + 1 >= oldLen) {
      // Identity per the equality and tokenizer
      return done([{
        value: this.join(newString),
        count: newString.length
      }]);
    } // Main worker method. checks all permutations of a given edit length for acceptance.


    function execEditLength() {
      for (var diagonalPath = -1 * editLength; diagonalPath <= editLength; diagonalPath += 2) {
        var basePath =
        /*istanbul ignore start*/
        void 0
        /*istanbul ignore end*/
        ;

        var addPath = bestPath[diagonalPath - 1],
            removePath = bestPath[diagonalPath + 1],
            _oldPos = (removePath ? removePath.newPos : 0) - diagonalPath;

        if (addPath) {
          // No one else is going to attempt to use this value, clear it
          bestPath[diagonalPath - 1] = undefined;
        }

        var canAdd = addPath && addPath.newPos + 1 < newLen,
            canRemove = removePath && 0 <= _oldPos && _oldPos < oldLen;

        if (!canAdd && !canRemove) {
          // If this path is a terminal then prune
          bestPath[diagonalPath] = undefined;
          continue;
        } // Select the diagonal that we want to branch from. We select the prior
        // path whose position in the new string is the farthest from the origin
        // and does not pass the bounds of the diff graph


        if (!canAdd || canRemove && addPath.newPos < removePath.newPos) {
          basePath = clonePath(removePath);
          self.pushComponent(basePath.components, undefined, true);
        } else {
          basePath = addPath; // No need to clone, we've pulled it from the list

          basePath.newPos++;
          self.pushComponent(basePath.components, true, undefined);
        }

        _oldPos = self.extractCommon(basePath, newString, oldString, diagonalPath); // If we have hit the end of both strings, then we are done

        if (basePath.newPos + 1 >= newLen && _oldPos + 1 >= oldLen) {
          return done(buildValues(self, basePath.components, newString, oldString, self.useLongestToken));
        } else {
          // Otherwise track this path as a potential candidate and continue.
          bestPath[diagonalPath] = basePath;
        }
      }

      editLength++;
    } // Performs the length of edit iteration. Is a bit fugly as this has to support the
    // sync and async mode which is never fun. Loops over execEditLength until a value
    // is produced.


    if (callback) {
      (function exec() {
        setTimeout(function () {
          // This should not happen, but we want to be safe.

          /* istanbul ignore next */
          if (editLength > maxEditLength) {
            return callback();
          }

          if (!execEditLength()) {
            exec();
          }
        }, 0);
      })();
    } else {
      while (editLength <= maxEditLength) {
        var ret = execEditLength();

        if (ret) {
          return ret;
        }
      }
    }
  },

  /*istanbul ignore start*/

  /*istanbul ignore end*/
  pushComponent: function pushComponent(components, added, removed) {
    var last = components[components.length - 1];

    if (last && last.added === added && last.removed === removed) {
      // We need to clone here as the component clone operation is just
      // as shallow array clone
      components[components.length - 1] = {
        count: last.count + 1,
        added: added,
        removed: removed
      };
    } else {
      components.push({
        count: 1,
        added: added,
        removed: removed
      });
    }
  },

  /*istanbul ignore start*/

  /*istanbul ignore end*/
  extractCommon: function extractCommon(basePath, newString, oldString, diagonalPath) {
    var newLen = newString.length,
        oldLen = oldString.length,
        newPos = basePath.newPos,
        oldPos = newPos - diagonalPath,
        commonCount = 0;

    while (newPos + 1 < newLen && oldPos + 1 < oldLen && this.equals(newString[newPos + 1], oldString[oldPos + 1])) {
      newPos++;
      oldPos++;
      commonCount++;
    }

    if (commonCount) {
      basePath.components.push({
        count: commonCount
      });
    }

    basePath.newPos = newPos;
    return oldPos;
  },

  /*istanbul ignore start*/

  /*istanbul ignore end*/
  equals: function equals(left, right) {
    if (this.options.comparator) {
      return this.options.comparator(left, right);
    } else {
      return left === right || this.options.ignoreCase && left.toLowerCase() === right.toLowerCase();
    }
  },

  /*istanbul ignore start*/

  /*istanbul ignore end*/
  removeEmpty: function removeEmpty(array) {
    var ret = [];

    for (var i = 0; i < array.length; i++) {
      if (array[i]) {
        ret.push(array[i]);
      }
    }

    return ret;
  },

  /*istanbul ignore start*/

  /*istanbul ignore end*/
  castInput: function castInput(value) {
    return value;
  },

  /*istanbul ignore start*/

  /*istanbul ignore end*/
  tokenize: function tokenize(value) {
    return value.split('');
  },

  /*istanbul ignore start*/

  /*istanbul ignore end*/
  join: function join(chars) {
    return chars.join('');
  }
};

function buildValues(diff, components, newString, oldString, useLongestToken) {
  var componentPos = 0,
      componentLen = components.length,
      newPos = 0,
      oldPos = 0;

  for (; componentPos < componentLen; componentPos++) {
    var component = components[componentPos];

    if (!component.removed) {
      if (!component.added && useLongestToken) {
        var value = newString.slice(newPos, newPos + component.count);
        value = value.map(function (value, i) {
          var oldValue = oldString[oldPos + i];
          return oldValue.length > value.length ? oldValue : value;
        });
        component.value = diff.join(value);
      } else {
        component.value = diff.join(newString.slice(newPos, newPos + component.count));
      }

      newPos += component.count; // Common case

      if (!component.added) {
        oldPos += component.count;
      }
    } else {
      component.value = diff.join(oldString.slice(oldPos, oldPos + component.count));
      oldPos += component.count; // Reverse add and remove so removes are output first to match common convention
      // The diffing algorithm is tied to add then remove output and this is the simplest
      // route to get the desired output with minimal overhead.

      if (componentPos && components[componentPos - 1].added) {
        var tmp = components[componentPos - 1];
        components[componentPos - 1] = components[componentPos];
        components[componentPos] = tmp;
      }
    }
  } // Special case handle for when one terminal is ignored (i.e. whitespace).
  // For this case we merge the terminal into the prior string and drop the change.
  // This is only available for string mode.


  var lastComponent = components[componentLen - 1];

  if (componentLen > 1 && typeof lastComponent.value === 'string' && (lastComponent.added || lastComponent.removed) && diff.equals('', lastComponent.value)) {
    components[componentLen - 2].value += lastComponent.value;
    components.pop();
  }

  return components;
}

function clonePath(path) {
  return {
    newPos: path.newPos,
    components: path.components.slice(0)
  };
}


/***/ }),

/***/ 1973:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
var __webpack_unused_export__;
/*istanbul ignore start*/


__webpack_unused_export__ = ({
  value: true
});
exports.Kx = diffChars;
__webpack_unused_export__ = void 0;

/*istanbul ignore end*/
var
/*istanbul ignore start*/
_base = _interopRequireDefault(__webpack_require__(1198))
/*istanbul ignore end*/
;

/*istanbul ignore start*/ function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*istanbul ignore end*/
var characterDiff = new
/*istanbul ignore start*/
_base
/*istanbul ignore end*/
.
/*istanbul ignore start*/
default
/*istanbul ignore end*/
();

/*istanbul ignore start*/
__webpack_unused_export__ = characterDiff;

/*istanbul ignore end*/
function diffChars(oldStr, newStr, options) {
  return characterDiff.diff(oldStr, newStr, options);
}


/***/ }),

/***/ 1345:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var util = __webpack_require__(5022);

function scrollIntoView(elem, container, config) {
  config = config || {};
  // document 归一化到 window
  if (container.nodeType === 9) {
    container = util.getWindow(container);
  }

  var allowHorizontalScroll = config.allowHorizontalScroll;
  var onlyScrollIfNeeded = config.onlyScrollIfNeeded;
  var alignWithTop = config.alignWithTop;
  var alignWithLeft = config.alignWithLeft;
  var offsetTop = config.offsetTop || 0;
  var offsetLeft = config.offsetLeft || 0;
  var offsetBottom = config.offsetBottom || 0;
  var offsetRight = config.offsetRight || 0;

  allowHorizontalScroll = allowHorizontalScroll === undefined ? true : allowHorizontalScroll;

  var isWin = util.isWindow(container);
  var isFramed = !!(isWin && container.frameElement);
  var elemOffset = util.offset(elem);
  var eh = util.outerHeight(elem);
  var ew = util.outerWidth(elem);
  var containerOffset = undefined;
  var ch = undefined;
  var cw = undefined;
  var containerScroll = undefined;
  var diffTop = undefined;
  var diffBottom = undefined;
  var win = undefined;
  var winScroll = undefined;
  var ww = undefined;
  var wh = undefined;

  if (isFramed) {
    container = container.document.scrollingElement || container.document.body;
  }

  if (isWin || isFramed) {
    win = container;
    wh = util.height(win);
    ww = util.width(win);
    winScroll = {
      left: util.scrollLeft(win),
      top: util.scrollTop(win)
    };
    // elem 相对 container 可视视窗的距离
    diffTop = {
      left: elemOffset.left - winScroll.left - offsetLeft,
      top: elemOffset.top - winScroll.top - offsetTop
    };
    diffBottom = {
      left: elemOffset.left + ew - (winScroll.left + ww) + offsetRight,
      top: elemOffset.top + eh - (winScroll.top + wh) + offsetBottom
    };
    containerScroll = winScroll;
  } else {
    containerOffset = util.offset(container);
    ch = container.clientHeight;
    cw = container.clientWidth;
    containerScroll = {
      left: container.scrollLeft,
      top: container.scrollTop
    };
    // elem 相对 container 可视视窗的距离
    // 注意边框, offset 是边框到根节点
    diffTop = {
      left: elemOffset.left - (containerOffset.left + (parseFloat(util.css(container, 'borderLeftWidth')) || 0)) - offsetLeft,
      top: elemOffset.top - (containerOffset.top + (parseFloat(util.css(container, 'borderTopWidth')) || 0)) - offsetTop
    };
    diffBottom = {
      left: elemOffset.left + ew - (containerOffset.left + cw + (parseFloat(util.css(container, 'borderRightWidth')) || 0)) + offsetRight,
      top: elemOffset.top + eh - (containerOffset.top + ch + (parseFloat(util.css(container, 'borderBottomWidth')) || 0)) + offsetBottom
    };
  }

  if (diffTop.top < 0 || diffBottom.top > 0) {
    // 强制向上
    if (alignWithTop === true) {
      util.scrollTop(container, containerScroll.top + diffTop.top);
    } else if (alignWithTop === false) {
      util.scrollTop(container, containerScroll.top + diffBottom.top);
    } else {
      // 自动调整
      if (diffTop.top < 0) {
        util.scrollTop(container, containerScroll.top + diffTop.top);
      } else {
        util.scrollTop(container, containerScroll.top + diffBottom.top);
      }
    }
  } else {
    if (!onlyScrollIfNeeded) {
      alignWithTop = alignWithTop === undefined ? true : !!alignWithTop;
      if (alignWithTop) {
        util.scrollTop(container, containerScroll.top + diffTop.top);
      } else {
        util.scrollTop(container, containerScroll.top + diffBottom.top);
      }
    }
  }

  if (allowHorizontalScroll) {
    if (diffTop.left < 0 || diffBottom.left > 0) {
      // 强制向上
      if (alignWithLeft === true) {
        util.scrollLeft(container, containerScroll.left + diffTop.left);
      } else if (alignWithLeft === false) {
        util.scrollLeft(container, containerScroll.left + diffBottom.left);
      } else {
        // 自动调整
        if (diffTop.left < 0) {
          util.scrollLeft(container, containerScroll.left + diffTop.left);
        } else {
          util.scrollLeft(container, containerScroll.left + diffBottom.left);
        }
      }
    } else {
      if (!onlyScrollIfNeeded) {
        alignWithLeft = alignWithLeft === undefined ? true : !!alignWithLeft;
        if (alignWithLeft) {
          util.scrollLeft(container, containerScroll.left + diffTop.left);
        } else {
          util.scrollLeft(container, containerScroll.left + diffBottom.left);
        }
      }
    }
  }
}

module.exports = scrollIntoView;

/***/ }),

/***/ 5425:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


module.exports = __webpack_require__(1345);

/***/ }),

/***/ 5022:
/***/ (function(module) {

"use strict";


var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj; };

var RE_NUM = /[\-+]?(?:\d*\.|)\d+(?:[eE][\-+]?\d+|)/.source;

function getClientPosition(elem) {
  var box = undefined;
  var x = undefined;
  var y = undefined;
  var doc = elem.ownerDocument;
  var body = doc.body;
  var docElem = doc && doc.documentElement;
  // 根据 GBS 最新数据，A-Grade Browsers 都已支持 getBoundingClientRect 方法，不用再考虑传统的实现方式
  box = elem.getBoundingClientRect();

  // 注：jQuery 还考虑减去 docElem.clientLeft/clientTop
  // 但测试发现，这样反而会导致当 html 和 body 有边距/边框样式时，获取的值不正确
  // 此外，ie6 会忽略 html 的 margin 值，幸运地是没有谁会去设置 html 的 margin

  x = box.left;
  y = box.top;

  // In IE, most of the time, 2 extra pixels are added to the top and left
  // due to the implicit 2-pixel inset border.  In IE6/7 quirks mode and
  // IE6 standards mode, this border can be overridden by setting the
  // document element's border to zero -- thus, we cannot rely on the
  // offset always being 2 pixels.

  // In quirks mode, the offset can be determined by querying the body's
  // clientLeft/clientTop, but in standards mode, it is found by querying
  // the document element's clientLeft/clientTop.  Since we already called
  // getClientBoundingRect we have already forced a reflow, so it is not
  // too expensive just to query them all.

  // ie 下应该减去窗口的边框吧，毕竟默认 absolute 都是相对窗口定位的
  // 窗口边框标准是设 documentElement ,quirks 时设置 body
  // 最好禁止在 body 和 html 上边框 ，但 ie < 9 html 默认有 2px ，减去
  // 但是非 ie 不可能设置窗口边框，body html 也不是窗口 ,ie 可以通过 html,body 设置
  // 标准 ie 下 docElem.clientTop 就是 border-top
  // ie7 html 即窗口边框改变不了。永远为 2
  // 但标准 firefox/chrome/ie9 下 docElem.clientTop 是窗口边框，即使设了 border-top 也为 0

  x -= docElem.clientLeft || body.clientLeft || 0;
  y -= docElem.clientTop || body.clientTop || 0;

  return {
    left: x,
    top: y
  };
}

function getScroll(w, top) {
  var ret = w['page' + (top ? 'Y' : 'X') + 'Offset'];
  var method = 'scroll' + (top ? 'Top' : 'Left');
  if (typeof ret !== 'number') {
    var d = w.document;
    // ie6,7,8 standard mode
    ret = d.documentElement[method];
    if (typeof ret !== 'number') {
      // quirks mode
      ret = d.body[method];
    }
  }
  return ret;
}

function getScrollLeft(w) {
  return getScroll(w);
}

function getScrollTop(w) {
  return getScroll(w, true);
}

function getOffset(el) {
  var pos = getClientPosition(el);
  var doc = el.ownerDocument;
  var w = doc.defaultView || doc.parentWindow;
  pos.left += getScrollLeft(w);
  pos.top += getScrollTop(w);
  return pos;
}
function _getComputedStyle(elem, name, computedStyle_) {
  var val = '';
  var d = elem.ownerDocument;
  var computedStyle = computedStyle_ || d.defaultView.getComputedStyle(elem, null);

  // https://github.com/kissyteam/kissy/issues/61
  if (computedStyle) {
    val = computedStyle.getPropertyValue(name) || computedStyle[name];
  }

  return val;
}

var _RE_NUM_NO_PX = new RegExp('^(' + RE_NUM + ')(?!px)[a-z%]+$', 'i');
var RE_POS = /^(top|right|bottom|left)$/;
var CURRENT_STYLE = 'currentStyle';
var RUNTIME_STYLE = 'runtimeStyle';
var LEFT = 'left';
var PX = 'px';

function _getComputedStyleIE(elem, name) {
  // currentStyle maybe null
  // http://msdn.microsoft.com/en-us/library/ms535231.aspx
  var ret = elem[CURRENT_STYLE] && elem[CURRENT_STYLE][name];

  // 当 width/height 设置为百分比时，通过 pixelLeft 方式转换的 width/height 值
  // 一开始就处理了! CUSTOM_STYLE.height,CUSTOM_STYLE.width ,cssHook 解决@2011-08-19
  // 在 ie 下不对，需要直接用 offset 方式
  // borderWidth 等值也有问题，但考虑到 borderWidth 设为百分比的概率很小，这里就不考虑了

  // From the awesome hack by Dean Edwards
  // http://erik.eae.net/archives/2007/07/27/18.54.15/#comment-102291
  // If we're not dealing with a regular pixel number
  // but a number that has a weird ending, we need to convert it to pixels
  // exclude left right for relativity
  if (_RE_NUM_NO_PX.test(ret) && !RE_POS.test(name)) {
    // Remember the original values
    var style = elem.style;
    var left = style[LEFT];
    var rsLeft = elem[RUNTIME_STYLE][LEFT];

    // prevent flashing of content
    elem[RUNTIME_STYLE][LEFT] = elem[CURRENT_STYLE][LEFT];

    // Put in the new values to get a computed value out
    style[LEFT] = name === 'fontSize' ? '1em' : ret || 0;
    ret = style.pixelLeft + PX;

    // Revert the changed values
    style[LEFT] = left;

    elem[RUNTIME_STYLE][LEFT] = rsLeft;
  }
  return ret === '' ? 'auto' : ret;
}

var getComputedStyleX = undefined;
if (typeof window !== 'undefined') {
  getComputedStyleX = window.getComputedStyle ? _getComputedStyle : _getComputedStyleIE;
}

function each(arr, fn) {
  for (var i = 0; i < arr.length; i++) {
    fn(arr[i]);
  }
}

function isBorderBoxFn(elem) {
  return getComputedStyleX(elem, 'boxSizing') === 'border-box';
}

var BOX_MODELS = ['margin', 'border', 'padding'];
var CONTENT_INDEX = -1;
var PADDING_INDEX = 2;
var BORDER_INDEX = 1;
var MARGIN_INDEX = 0;

function swap(elem, options, callback) {
  var old = {};
  var style = elem.style;
  var name = undefined;

  // Remember the old values, and insert the new ones
  for (name in options) {
    if (options.hasOwnProperty(name)) {
      old[name] = style[name];
      style[name] = options[name];
    }
  }

  callback.call(elem);

  // Revert the old values
  for (name in options) {
    if (options.hasOwnProperty(name)) {
      style[name] = old[name];
    }
  }
}

function getPBMWidth(elem, props, which) {
  var value = 0;
  var prop = undefined;
  var j = undefined;
  var i = undefined;
  for (j = 0; j < props.length; j++) {
    prop = props[j];
    if (prop) {
      for (i = 0; i < which.length; i++) {
        var cssProp = undefined;
        if (prop === 'border') {
          cssProp = prop + which[i] + 'Width';
        } else {
          cssProp = prop + which[i];
        }
        value += parseFloat(getComputedStyleX(elem, cssProp)) || 0;
      }
    }
  }
  return value;
}

/**
 * A crude way of determining if an object is a window
 * @member util
 */
function isWindow(obj) {
  // must use == for ie8
  /* eslint eqeqeq:0 */
  return obj != null && obj == obj.window;
}

var domUtils = {};

each(['Width', 'Height'], function (name) {
  domUtils['doc' + name] = function (refWin) {
    var d = refWin.document;
    return Math.max(
    // firefox chrome documentElement.scrollHeight< body.scrollHeight
    // ie standard mode : documentElement.scrollHeight> body.scrollHeight
    d.documentElement['scroll' + name],
    // quirks : documentElement.scrollHeight 最大等于可视窗口多一点？
    d.body['scroll' + name], domUtils['viewport' + name](d));
  };

  domUtils['viewport' + name] = function (win) {
    // pc browser includes scrollbar in window.innerWidth
    var prop = 'client' + name;
    var doc = win.document;
    var body = doc.body;
    var documentElement = doc.documentElement;
    var documentElementProp = documentElement[prop];
    // 标准模式取 documentElement
    // backcompat 取 body
    return doc.compatMode === 'CSS1Compat' && documentElementProp || body && body[prop] || documentElementProp;
  };
});

/*
 得到元素的大小信息
 @param elem
 @param name
 @param {String} [extra]  'padding' : (css width) + padding
 'border' : (css width) + padding + border
 'margin' : (css width) + padding + border + margin
 */
function getWH(elem, name, extra) {
  if (isWindow(elem)) {
    return name === 'width' ? domUtils.viewportWidth(elem) : domUtils.viewportHeight(elem);
  } else if (elem.nodeType === 9) {
    return name === 'width' ? domUtils.docWidth(elem) : domUtils.docHeight(elem);
  }
  var which = name === 'width' ? ['Left', 'Right'] : ['Top', 'Bottom'];
  var borderBoxValue = name === 'width' ? elem.offsetWidth : elem.offsetHeight;
  var computedStyle = getComputedStyleX(elem);
  var isBorderBox = isBorderBoxFn(elem, computedStyle);
  var cssBoxValue = 0;
  if (borderBoxValue == null || borderBoxValue <= 0) {
    borderBoxValue = undefined;
    // Fall back to computed then un computed css if necessary
    cssBoxValue = getComputedStyleX(elem, name);
    if (cssBoxValue == null || Number(cssBoxValue) < 0) {
      cssBoxValue = elem.style[name] || 0;
    }
    // Normalize '', auto, and prepare for extra
    cssBoxValue = parseFloat(cssBoxValue) || 0;
  }
  if (extra === undefined) {
    extra = isBorderBox ? BORDER_INDEX : CONTENT_INDEX;
  }
  var borderBoxValueOrIsBorderBox = borderBoxValue !== undefined || isBorderBox;
  var val = borderBoxValue || cssBoxValue;
  if (extra === CONTENT_INDEX) {
    if (borderBoxValueOrIsBorderBox) {
      return val - getPBMWidth(elem, ['border', 'padding'], which, computedStyle);
    }
    return cssBoxValue;
  }
  if (borderBoxValueOrIsBorderBox) {
    var padding = extra === PADDING_INDEX ? -getPBMWidth(elem, ['border'], which, computedStyle) : getPBMWidth(elem, ['margin'], which, computedStyle);
    return val + (extra === BORDER_INDEX ? 0 : padding);
  }
  return cssBoxValue + getPBMWidth(elem, BOX_MODELS.slice(extra), which, computedStyle);
}

var cssShow = {
  position: 'absolute',
  visibility: 'hidden',
  display: 'block'
};

// fix #119 : https://github.com/kissyteam/kissy/issues/119
function getWHIgnoreDisplay(elem) {
  var val = undefined;
  var args = arguments;
  // in case elem is window
  // elem.offsetWidth === undefined
  if (elem.offsetWidth !== 0) {
    val = getWH.apply(undefined, args);
  } else {
    swap(elem, cssShow, function () {
      val = getWH.apply(undefined, args);
    });
  }
  return val;
}

function css(el, name, v) {
  var value = v;
  if ((typeof name === 'undefined' ? 'undefined' : _typeof(name)) === 'object') {
    for (var i in name) {
      if (name.hasOwnProperty(i)) {
        css(el, i, name[i]);
      }
    }
    return undefined;
  }
  if (typeof value !== 'undefined') {
    if (typeof value === 'number') {
      value += 'px';
    }
    el.style[name] = value;
    return undefined;
  }
  return getComputedStyleX(el, name);
}

each(['width', 'height'], function (name) {
  var first = name.charAt(0).toUpperCase() + name.slice(1);
  domUtils['outer' + first] = function (el, includeMargin) {
    return el && getWHIgnoreDisplay(el, name, includeMargin ? MARGIN_INDEX : BORDER_INDEX);
  };
  var which = name === 'width' ? ['Left', 'Right'] : ['Top', 'Bottom'];

  domUtils[name] = function (elem, val) {
    if (val !== undefined) {
      if (elem) {
        var computedStyle = getComputedStyleX(elem);
        var isBorderBox = isBorderBoxFn(elem);
        if (isBorderBox) {
          val += getPBMWidth(elem, ['padding', 'border'], which, computedStyle);
        }
        return css(elem, name, val);
      }
      return undefined;
    }
    return elem && getWHIgnoreDisplay(elem, name, CONTENT_INDEX);
  };
});

// 设置 elem 相对 elem.ownerDocument 的坐标
function setOffset(elem, offset) {
  // set position first, in-case top/left are set even on static elem
  if (css(elem, 'position') === 'static') {
    elem.style.position = 'relative';
  }

  var old = getOffset(elem);
  var ret = {};
  var current = undefined;
  var key = undefined;

  for (key in offset) {
    if (offset.hasOwnProperty(key)) {
      current = parseFloat(css(elem, key)) || 0;
      ret[key] = current + offset[key] - old[key];
    }
  }
  css(elem, ret);
}

module.exports = _extends({
  getWindow: function getWindow(node) {
    var doc = node.ownerDocument || node;
    return doc.defaultView || doc.parentWindow;
  },
  offset: function offset(el, value) {
    if (typeof value !== 'undefined') {
      setOffset(el, value);
    } else {
      return getOffset(el);
    }
  },

  isWindow: isWindow,
  each: each,
  css: css,
  clone: function clone(obj) {
    var ret = {};
    for (var i in obj) {
      if (obj.hasOwnProperty(i)) {
        ret[i] = obj[i];
      }
    }
    var overflow = obj.overflow;
    if (overflow) {
      for (var i in obj) {
        if (obj.hasOwnProperty(i)) {
          ret.overflow[i] = obj.overflow[i];
        }
      }
    }
    return ret;
  },
  scrollLeft: function scrollLeft(w, v) {
    if (isWindow(w)) {
      if (v === undefined) {
        return getScrollLeft(w);
      }
      window.scrollTo(v, getScrollTop(w));
    } else {
      if (v === undefined) {
        return w.scrollLeft;
      }
      w.scrollLeft = v;
    }
  },
  scrollTop: function scrollTop(w, v) {
    if (isWindow(w)) {
      if (v === undefined) {
        return getScrollTop(w);
      }
      window.scrollTo(getScrollLeft(w), v);
    } else {
      if (v === undefined) {
        return w.scrollTop;
      }
      w.scrollTop = v;
    }
  },

  viewportWidth: 0,
  viewportHeight: 0
}, domUtils);

/***/ }),

/***/ 8575:
/***/ (function(module) {

if (typeof Object.create === 'function') {
  // implementation from standard node.js 'util' module
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor
    ctor.prototype = Object.create(superCtor.prototype, {
      constructor: {
        value: ctor,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
  };
} else {
  // old school shim for old browsers
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor
    var TempCtor = function () {}
    TempCtor.prototype = superCtor.prototype
    ctor.prototype = new TempCtor()
    ctor.prototype.constructor = ctor
  }
}


/***/ }),

/***/ 9894:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

// Load in dependencies
var computedStyle = __webpack_require__(4827);

/**
 * Calculate the `line-height` of a given node
 * @param {HTMLElement} node Element to calculate line height of. Must be in the DOM.
 * @returns {Number} `line-height` of the element in pixels
 */
function lineHeight(node) {
  // Grab the line-height via style
  var lnHeightStr = computedStyle(node, 'line-height');
  var lnHeight = parseFloat(lnHeightStr, 10);

  // If the lineHeight did not contain a unit (i.e. it was numeric), convert it to ems (e.g. '2.3' === '2.3em')
  if (lnHeightStr === lnHeight + '') {
    // Save the old lineHeight style and update the em unit to the element
    var _lnHeightStyle = node.style.lineHeight;
    node.style.lineHeight = lnHeightStr + 'em';

    // Calculate the em based height
    lnHeightStr = computedStyle(node, 'line-height');
    lnHeight = parseFloat(lnHeightStr, 10);

    // Revert the lineHeight style
    if (_lnHeightStyle) {
      node.style.lineHeight = _lnHeightStyle;
    } else {
      delete node.style.lineHeight;
    }
  }

  // If the lineHeight is in `pt`, convert it to pixels (4px for 3pt)
  // DEV: `em` units are converted to `pt` in IE6
  // Conversion ratio from https://developer.mozilla.org/en-US/docs/Web/CSS/length
  if (lnHeightStr.indexOf('pt') !== -1) {
    lnHeight *= 4;
    lnHeight /= 3;
  // Otherwise, if the lineHeight is in `mm`, convert it to pixels (96px for 25.4mm)
  } else if (lnHeightStr.indexOf('mm') !== -1) {
    lnHeight *= 96;
    lnHeight /= 25.4;
  // Otherwise, if the lineHeight is in `cm`, convert it to pixels (96px for 2.54cm)
  } else if (lnHeightStr.indexOf('cm') !== -1) {
    lnHeight *= 96;
    lnHeight /= 2.54;
  // Otherwise, if the lineHeight is in `in`, convert it to pixels (96px for 1in)
  } else if (lnHeightStr.indexOf('in') !== -1) {
    lnHeight *= 96;
  // Otherwise, if the lineHeight is in `pc`, convert it to pixels (12pt for 1pc)
  } else if (lnHeightStr.indexOf('pc') !== -1) {
    lnHeight *= 16;
  }

  // Continue our computation
  lnHeight = Math.round(lnHeight);

  // If the line-height is "normal", calculate by font-size
  if (lnHeightStr === 'normal') {
    // Create a temporary node
    var nodeName = node.nodeName;
    var _node = document.createElement(nodeName);
    _node.innerHTML = '&nbsp;';

    // If we have a text area, reset it to only 1 row
    // https://github.com/twolfson/line-height/issues/4
    if (nodeName.toUpperCase() === 'TEXTAREA') {
      _node.setAttribute('rows', '1');
    }

    // Set the font-size of the element
    var fontSizeStr = computedStyle(node, 'font-size');
    _node.style.fontSize = fontSizeStr;

    // Remove default padding/border which can affect offset height
    // https://github.com/twolfson/line-height/issues/4
    // https://developer.mozilla.org/en-US/docs/Web/API/HTMLElement/offsetHeight
    _node.style.padding = '0px';
    _node.style.border = '0px';

    // Append it to the body
    var body = document.body;
    body.appendChild(_node);

    // Assume the line height of the element is the height
    var height = _node.offsetHeight;
    lnHeight = height;

    // Remove our child from the DOM
    body.removeChild(_node);
  }

  // Return the calculated height
  return lnHeight;
}

// Export lineHeight
module.exports = lineHeight;


/***/ }),

/***/ 5372:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */



var ReactPropTypesSecret = __webpack_require__(9567);

function emptyFunction() {}
function emptyFunctionWithReset() {}
emptyFunctionWithReset.resetWarningCache = emptyFunction;

module.exports = function() {
  function shim(props, propName, componentName, location, propFullName, secret) {
    if (secret === ReactPropTypesSecret) {
      // It is still safe when called from React.
      return;
    }
    var err = new Error(
      'Calling PropTypes validators directly is not supported by the `prop-types` package. ' +
      'Use PropTypes.checkPropTypes() to call them. ' +
      'Read more at http://fb.me/use-check-prop-types'
    );
    err.name = 'Invariant Violation';
    throw err;
  };
  shim.isRequired = shim;
  function getShim() {
    return shim;
  };
  // Important!
  // Keep this list in sync with production version in `./factoryWithTypeCheckers.js`.
  var ReactPropTypes = {
    array: shim,
    bool: shim,
    func: shim,
    number: shim,
    object: shim,
    string: shim,
    symbol: shim,

    any: shim,
    arrayOf: getShim,
    element: shim,
    elementType: shim,
    instanceOf: getShim,
    node: shim,
    objectOf: getShim,
    oneOf: getShim,
    oneOfType: getShim,
    shape: getShim,
    exact: getShim,

    checkPropTypes: emptyFunctionWithReset,
    resetWarningCache: emptyFunction
  };

  ReactPropTypes.PropTypes = ReactPropTypes;

  return ReactPropTypes;
};


/***/ }),

/***/ 2652:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

if (false) { var throwOnDirectAccess, ReactIs; } else {
  // By explicitly using `prop-types` you are opting into new production behavior.
  // http://fb.me/prop-types-in-prod
  module.exports = __webpack_require__(5372)();
}


/***/ }),

/***/ 9567:
/***/ (function(module) {

"use strict";
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */



var ReactPropTypesSecret = 'SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED';

module.exports = ReactPropTypesSecret;


/***/ }),

/***/ 5438:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
            t[p[i]] = s[p[i]];
    return t;
};
exports.__esModule = true;
var React = __webpack_require__(9196);
var PropTypes = __webpack_require__(2652);
var autosize = __webpack_require__(6411);
var _getLineHeight = __webpack_require__(9894);
var getLineHeight = _getLineHeight;
var RESIZED = "autosize:resized";
/**
 * A light replacement for built-in textarea component
 * which automaticaly adjusts its height to match the content
 */
var TextareaAutosizeClass = /** @class */ (function (_super) {
    __extends(TextareaAutosizeClass, _super);
    function TextareaAutosizeClass() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            lineHeight: null
        };
        _this.textarea = null;
        _this.onResize = function (e) {
            if (_this.props.onResize) {
                _this.props.onResize(e);
            }
        };
        _this.updateLineHeight = function () {
            if (_this.textarea) {
                _this.setState({
                    lineHeight: getLineHeight(_this.textarea)
                });
            }
        };
        _this.onChange = function (e) {
            var onChange = _this.props.onChange;
            _this.currentValue = e.currentTarget.value;
            onChange && onChange(e);
        };
        return _this;
    }
    TextareaAutosizeClass.prototype.componentDidMount = function () {
        var _this = this;
        var _a = this.props, maxRows = _a.maxRows, async = _a.async;
        if (typeof maxRows === "number") {
            this.updateLineHeight();
        }
        if (typeof maxRows === "number" || async) {
            /*
              the defer is needed to:
                - force "autosize" to activate the scrollbar when this.props.maxRows is passed
                - support StyledComponents (see #71)
            */
            setTimeout(function () { return _this.textarea && autosize(_this.textarea); });
        }
        else {
            this.textarea && autosize(this.textarea);
        }
        if (this.textarea) {
            this.textarea.addEventListener(RESIZED, this.onResize);
        }
    };
    TextareaAutosizeClass.prototype.componentWillUnmount = function () {
        if (this.textarea) {
            this.textarea.removeEventListener(RESIZED, this.onResize);
            autosize.destroy(this.textarea);
        }
    };
    TextareaAutosizeClass.prototype.render = function () {
        var _this = this;
        var _a = this, _b = _a.props, onResize = _b.onResize, maxRows = _b.maxRows, onChange = _b.onChange, style = _b.style, innerRef = _b.innerRef, children = _b.children, props = __rest(_b, ["onResize", "maxRows", "onChange", "style", "innerRef", "children"]), lineHeight = _a.state.lineHeight;
        var maxHeight = maxRows && lineHeight ? lineHeight * maxRows : null;
        return (React.createElement("textarea", __assign({}, props, { onChange: this.onChange, style: maxHeight ? __assign({}, style, { maxHeight: maxHeight }) : style, ref: function (element) {
                _this.textarea = element;
                if (typeof _this.props.innerRef === 'function') {
                    _this.props.innerRef(element);
                }
                else if (_this.props.innerRef) {
                    _this.props.innerRef.current = element;
                }
            } }), children));
    };
    TextareaAutosizeClass.prototype.componentDidUpdate = function () {
        this.textarea && autosize.update(this.textarea);
    };
    TextareaAutosizeClass.defaultProps = {
        rows: 1,
        async: false
    };
    TextareaAutosizeClass.propTypes = {
        rows: PropTypes.number,
        maxRows: PropTypes.number,
        onResize: PropTypes.func,
        innerRef: PropTypes.any,
        async: PropTypes.bool
    };
    return TextareaAutosizeClass;
}(React.Component));
exports.TextareaAutosize = React.forwardRef(function (props, ref) {
    return React.createElement(TextareaAutosizeClass, __assign({}, props, { innerRef: ref }));
});


/***/ }),

/***/ 773:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
var __webpack_unused_export__;

__webpack_unused_export__ = true;
var TextareaAutosize_1 = __webpack_require__(5438);
exports.Z = TextareaAutosize_1.TextareaAutosize;


/***/ }),

/***/ 3124:
/***/ (function(module) {

var traverse = module.exports = function (obj) {
    return new Traverse(obj);
};

function Traverse (obj) {
    this.value = obj;
}

Traverse.prototype.get = function (ps) {
    var node = this.value;
    for (var i = 0; i < ps.length; i ++) {
        var key = ps[i];
        if (!node || !hasOwnProperty.call(node, key)) {
            node = undefined;
            break;
        }
        node = node[key];
    }
    return node;
};

Traverse.prototype.has = function (ps) {
    var node = this.value;
    for (var i = 0; i < ps.length; i ++) {
        var key = ps[i];
        if (!node || !hasOwnProperty.call(node, key)) {
            return false;
        }
        node = node[key];
    }
    return true;
};

Traverse.prototype.set = function (ps, value) {
    var node = this.value;
    for (var i = 0; i < ps.length - 1; i ++) {
        var key = ps[i];
        if (!hasOwnProperty.call(node, key)) node[key] = {};
        node = node[key];
    }
    node[ps[i]] = value;
    return value;
};

Traverse.prototype.map = function (cb) {
    return walk(this.value, cb, true);
};

Traverse.prototype.forEach = function (cb) {
    this.value = walk(this.value, cb, false);
    return this.value;
};

Traverse.prototype.reduce = function (cb, init) {
    var skip = arguments.length === 1;
    var acc = skip ? this.value : init;
    this.forEach(function (x) {
        if (!this.isRoot || !skip) {
            acc = cb.call(this, acc, x);
        }
    });
    return acc;
};

Traverse.prototype.paths = function () {
    var acc = [];
    this.forEach(function (x) {
        acc.push(this.path); 
    });
    return acc;
};

Traverse.prototype.nodes = function () {
    var acc = [];
    this.forEach(function (x) {
        acc.push(this.node);
    });
    return acc;
};

Traverse.prototype.clone = function () {
    var parents = [], nodes = [];
    
    return (function clone (src) {
        for (var i = 0; i < parents.length; i++) {
            if (parents[i] === src) {
                return nodes[i];
            }
        }
        
        if (typeof src === 'object' && src !== null) {
            var dst = copy(src);
            
            parents.push(src);
            nodes.push(dst);
            
            forEach(objectKeys(src), function (key) {
                dst[key] = clone(src[key]);
            });
            
            parents.pop();
            nodes.pop();
            return dst;
        }
        else {
            return src;
        }
    })(this.value);
};

function walk (root, cb, immutable) {
    var path = [];
    var parents = [];
    var alive = true;
    
    return (function walker (node_) {
        var node = immutable ? copy(node_) : node_;
        var modifiers = {};
        
        var keepGoing = true;
        
        var state = {
            node : node,
            node_ : node_,
            path : [].concat(path),
            parent : parents[parents.length - 1],
            parents : parents,
            key : path.slice(-1)[0],
            isRoot : path.length === 0,
            level : path.length,
            circular : null,
            update : function (x, stopHere) {
                if (!state.isRoot) {
                    state.parent.node[state.key] = x;
                }
                state.node = x;
                if (stopHere) keepGoing = false;
            },
            'delete' : function (stopHere) {
                delete state.parent.node[state.key];
                if (stopHere) keepGoing = false;
            },
            remove : function (stopHere) {
                if (isArray(state.parent.node)) {
                    state.parent.node.splice(state.key, 1);
                }
                else {
                    delete state.parent.node[state.key];
                }
                if (stopHere) keepGoing = false;
            },
            keys : null,
            before : function (f) { modifiers.before = f },
            after : function (f) { modifiers.after = f },
            pre : function (f) { modifiers.pre = f },
            post : function (f) { modifiers.post = f },
            stop : function () { alive = false },
            block : function () { keepGoing = false }
        };
        
        if (!alive) return state;
        
        function updateState() {
            if (typeof state.node === 'object' && state.node !== null) {
                if (!state.keys || state.node_ !== state.node) {
                    state.keys = objectKeys(state.node)
                }
                
                state.isLeaf = state.keys.length == 0;
                
                for (var i = 0; i < parents.length; i++) {
                    if (parents[i].node_ === node_) {
                        state.circular = parents[i];
                        break;
                    }
                }
            }
            else {
                state.isLeaf = true;
                state.keys = null;
            }
            
            state.notLeaf = !state.isLeaf;
            state.notRoot = !state.isRoot;
        }
        
        updateState();
        
        // use return values to update if defined
        var ret = cb.call(state, state.node);
        if (ret !== undefined && state.update) state.update(ret);
        
        if (modifiers.before) modifiers.before.call(state, state.node);
        
        if (!keepGoing) return state;
        
        if (typeof state.node == 'object'
        && state.node !== null && !state.circular) {
            parents.push(state);
            
            updateState();
            
            forEach(state.keys, function (key, i) {
                path.push(key);
                
                if (modifiers.pre) modifiers.pre.call(state, state.node[key], key);
                
                var child = walker(state.node[key]);
                if (immutable && hasOwnProperty.call(state.node, key)) {
                    state.node[key] = child.node;
                }
                
                child.isLast = i == state.keys.length - 1;
                child.isFirst = i == 0;
                
                if (modifiers.post) modifiers.post.call(state, child);
                
                path.pop();
            });
            parents.pop();
        }
        
        if (modifiers.after) modifiers.after.call(state, state.node);
        
        return state;
    })(root).node;
}

function copy (src) {
    if (typeof src === 'object' && src !== null) {
        var dst;
        
        if (isArray(src)) {
            dst = [];
        }
        else if (isDate(src)) {
            dst = new Date(src.getTime ? src.getTime() : src);
        }
        else if (isRegExp(src)) {
            dst = new RegExp(src);
        }
        else if (isError(src)) {
            dst = { message: src.message };
        }
        else if (isBoolean(src)) {
            dst = new Boolean(src);
        }
        else if (isNumber(src)) {
            dst = new Number(src);
        }
        else if (isString(src)) {
            dst = new String(src);
        }
        else if (Object.create && Object.getPrototypeOf) {
            dst = Object.create(Object.getPrototypeOf(src));
        }
        else if (src.constructor === Object) {
            dst = {};
        }
        else {
            var proto =
                (src.constructor && src.constructor.prototype)
                || src.__proto__
                || {}
            ;
            var T = function () {};
            T.prototype = proto;
            dst = new T;
        }
        
        forEach(objectKeys(src), function (key) {
            dst[key] = src[key];
        });
        return dst;
    }
    else return src;
}

var objectKeys = Object.keys || function keys (obj) {
    var res = [];
    for (var key in obj) res.push(key)
    return res;
};

function toS (obj) { return Object.prototype.toString.call(obj) }
function isDate (obj) { return toS(obj) === '[object Date]' }
function isRegExp (obj) { return toS(obj) === '[object RegExp]' }
function isError (obj) { return toS(obj) === '[object Error]' }
function isBoolean (obj) { return toS(obj) === '[object Boolean]' }
function isNumber (obj) { return toS(obj) === '[object Number]' }
function isString (obj) { return toS(obj) === '[object String]' }

var isArray = Array.isArray || function isArray (xs) {
    return Object.prototype.toString.call(xs) === '[object Array]';
};

var forEach = function (xs, fn) {
    if (xs.forEach) return xs.forEach(fn)
    else for (var i = 0; i < xs.length; i++) {
        fn(xs[i], i, xs);
    }
};

forEach(objectKeys(Traverse.prototype), function (key) {
    traverse[key] = function (obj) {
        var args = [].slice.call(arguments, 1);
        var t = new Traverse(obj);
        return t[key].apply(t, args);
    };
});

var hasOwnProperty = Object.hasOwnProperty || function (obj, key) {
    return key in obj;
};


/***/ }),

/***/ 9196:
/***/ (function(module) {

"use strict";
module.exports = window["React"];

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	!function() {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = function(module) {
/******/ 			var getter = module && module.__esModule ?
/******/ 				function() { return module['default']; } :
/******/ 				function() { return module; };
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be in strict mode.
!function() {
"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "AlignmentControl": function() { return /* reexport */ AlignmentControl; },
  "AlignmentToolbar": function() { return /* reexport */ AlignmentToolbar; },
  "Autocomplete": function() { return /* reexport */ autocomplete; },
  "BlockAlignmentControl": function() { return /* reexport */ BlockAlignmentControl; },
  "BlockAlignmentToolbar": function() { return /* reexport */ BlockAlignmentToolbar; },
  "BlockBreadcrumb": function() { return /* reexport */ block_breadcrumb; },
  "BlockColorsStyleSelector": function() { return /* reexport */ color_style_selector; },
  "BlockContextProvider": function() { return /* reexport */ BlockContextProvider; },
  "BlockControls": function() { return /* reexport */ block_controls; },
  "BlockEdit": function() { return /* reexport */ BlockEdit; },
  "BlockEditorKeyboardShortcuts": function() { return /* reexport */ keyboard_shortcuts; },
  "BlockEditorProvider": function() { return /* reexport */ provider; },
  "BlockFormatControls": function() { return /* reexport */ BlockFormatControls; },
  "BlockIcon": function() { return /* reexport */ block_icon; },
  "BlockInspector": function() { return /* reexport */ block_inspector; },
  "BlockList": function() { return /* reexport */ BlockList; },
  "BlockMover": function() { return /* reexport */ block_mover; },
  "BlockNavigationDropdown": function() { return /* reexport */ dropdown; },
  "BlockPreview": function() { return /* reexport */ block_preview; },
  "BlockSelectionClearer": function() { return /* reexport */ BlockSelectionClearer; },
  "BlockSettingsMenu": function() { return /* reexport */ block_settings_menu; },
  "BlockSettingsMenuControls": function() { return /* reexport */ block_settings_menu_controls; },
  "BlockStyles": function() { return /* reexport */ block_styles; },
  "BlockTitle": function() { return /* reexport */ BlockTitle; },
  "BlockToolbar": function() { return /* reexport */ BlockToolbar; },
  "BlockTools": function() { return /* reexport */ BlockTools; },
  "BlockVerticalAlignmentControl": function() { return /* reexport */ BlockVerticalAlignmentControl; },
  "BlockVerticalAlignmentToolbar": function() { return /* reexport */ BlockVerticalAlignmentToolbar; },
  "ButtonBlockAppender": function() { return /* reexport */ button_block_appender; },
  "ButtonBlockerAppender": function() { return /* reexport */ ButtonBlockerAppender; },
  "ColorPalette": function() { return /* reexport */ color_palette; },
  "ColorPaletteControl": function() { return /* reexport */ ColorPaletteControl; },
  "ContrastChecker": function() { return /* reexport */ contrast_checker; },
  "CopyHandler": function() { return /* reexport */ copy_handler; },
  "DefaultBlockAppender": function() { return /* reexport */ default_block_appender; },
  "FontSizePicker": function() { return /* reexport */ font_size_picker; },
  "InnerBlocks": function() { return /* reexport */ inner_blocks; },
  "Inserter": function() { return /* reexport */ inserter; },
  "InspectorAdvancedControls": function() { return /* reexport */ InspectorAdvancedControls; },
  "InspectorControls": function() { return /* reexport */ inspector_controls; },
  "JustifyContentControl": function() { return /* reexport */ JustifyContentControl; },
  "JustifyToolbar": function() { return /* reexport */ JustifyToolbar; },
  "LineHeightControl": function() { return /* reexport */ LineHeightControl; },
  "MediaPlaceholder": function() { return /* reexport */ media_placeholder; },
  "MediaReplaceFlow": function() { return /* reexport */ media_replace_flow; },
  "MediaUpload": function() { return /* reexport */ media_upload; },
  "MediaUploadCheck": function() { return /* reexport */ media_upload_check; },
  "MultiSelectScrollIntoView": function() { return /* reexport */ MultiSelectScrollIntoView; },
  "NavigableToolbar": function() { return /* reexport */ navigable_toolbar; },
  "ObserveTyping": function() { return /* reexport */ observe_typing; },
  "PanelColorSettings": function() { return /* reexport */ panel_color_settings; },
  "PlainText": function() { return /* reexport */ plain_text; },
  "RichText": function() { return /* reexport */ rich_text; },
  "RichTextShortcut": function() { return /* reexport */ RichTextShortcut; },
  "RichTextToolbarButton": function() { return /* reexport */ RichTextToolbarButton; },
  "SETTINGS_DEFAULTS": function() { return /* reexport */ SETTINGS_DEFAULTS; },
  "SkipToSelectedBlock": function() { return /* reexport */ skip_to_selected_block; },
  "ToolSelector": function() { return /* reexport */ tool_selector; },
  "Typewriter": function() { return /* reexport */ typewriter; },
  "URLInput": function() { return /* reexport */ url_input; },
  "URLInputButton": function() { return /* reexport */ url_input_button; },
  "URLPopover": function() { return /* reexport */ url_popover; },
  "Warning": function() { return /* reexport */ warning; },
  "WritingFlow": function() { return /* reexport */ writing_flow; },
  "__experimentalBlockAlignmentMatrixControl": function() { return /* reexport */ block_alignment_matrix_control; },
  "__experimentalBlockContentOverlay": function() { return /* reexport */ BlockContentOverlay; },
  "__experimentalBlockFullHeightAligmentControl": function() { return /* reexport */ block_full_height_alignment_control; },
  "__experimentalBlockPatternSetup": function() { return /* reexport */ block_pattern_setup; },
  "__experimentalBlockPatternsList": function() { return /* reexport */ block_patterns_list; },
  "__experimentalBlockVariationPicker": function() { return /* reexport */ block_variation_picker; },
  "__experimentalBlockVariationTransforms": function() { return /* reexport */ block_variation_transforms; },
  "__experimentalBorderRadiusControl": function() { return /* reexport */ BorderRadiusControl; },
  "__experimentalBorderStyleControl": function() { return /* reexport */ BorderStyleControl; },
  "__experimentalColorGradientControl": function() { return /* reexport */ control; },
  "__experimentalColorGradientSettingsDropdown": function() { return /* reexport */ ColorGradientSettingsDropdown; },
  "__experimentalDuotoneControl": function() { return /* reexport */ duotone_control; },
  "__experimentalFontAppearanceControl": function() { return /* reexport */ FontAppearanceControl; },
  "__experimentalFontFamilyControl": function() { return /* reexport */ FontFamilyControl; },
  "__experimentalGetBorderClassesAndStyles": function() { return /* reexport */ getBorderClassesAndStyles; },
  "__experimentalGetColorClassesAndStyles": function() { return /* reexport */ getColorClassesAndStyles; },
  "__experimentalGetGradientClass": function() { return /* reexport */ __experimentalGetGradientClass; },
  "__experimentalGetGradientObjectByGradientValue": function() { return /* reexport */ __experimentalGetGradientObjectByGradientValue; },
  "__experimentalGetMatchingVariation": function() { return /* reexport */ __experimentalGetMatchingVariation; },
  "__experimentalGetSpacingClassesAndStyles": function() { return /* reexport */ getSpacingClassesAndStyles; },
  "__experimentalImageEditingProvider": function() { return /* reexport */ ImageEditingProvider; },
  "__experimentalImageEditor": function() { return /* reexport */ ImageEditor; },
  "__experimentalImageSizeControl": function() { return /* reexport */ ImageSizeControl; },
  "__experimentalImageURLInputUI": function() { return /* reexport */ ImageURLInputUI; },
  "__experimentalLayoutStyle": function() { return /* reexport */ LayoutStyle; },
  "__experimentalLetterSpacingControl": function() { return /* reexport */ LetterSpacingControl; },
  "__experimentalLibrary": function() { return /* reexport */ library; },
  "__experimentalLinkControl": function() { return /* reexport */ link_control; },
  "__experimentalLinkControlSearchInput": function() { return /* reexport */ search_input; },
  "__experimentalLinkControlSearchItem": function() { return /* reexport */ search_item; },
  "__experimentalLinkControlSearchResults": function() { return /* reexport */ LinkControlSearchResults; },
  "__experimentalListView": function() { return /* reexport */ components_list_view; },
  "__experimentalPanelColorGradientSettings": function() { return /* reexport */ panel_color_gradient_settings; },
  "__experimentalPreviewOptions": function() { return /* reexport */ PreviewOptions; },
  "__experimentalResponsiveBlockControl": function() { return /* reexport */ responsive_block_control; },
  "__experimentalTextDecorationControl": function() { return /* reexport */ TextDecorationControl; },
  "__experimentalTextTransformControl": function() { return /* reexport */ TextTransformControl; },
  "__experimentalToolsPanelColorDropdown": function() { return /* reexport */ ToolsPanelColorDropdown; },
  "__experimentalUnitControl": function() { return /* reexport */ UnitControl; },
  "__experimentalUseBlockPreview": function() { return /* reexport */ useBlockPreview; },
  "__experimentalUseBorderProps": function() { return /* reexport */ useBorderProps; },
  "__experimentalUseColorProps": function() { return /* reexport */ useColorProps; },
  "__experimentalUseCustomSides": function() { return /* reexport */ useCustomSides; },
  "__experimentalUseGradient": function() { return /* reexport */ __experimentalUseGradient; },
  "__experimentalUseNoRecursiveRenders": function() { return /* reexport */ useNoRecursiveRenders; },
  "__experimentalUseResizeCanvas": function() { return /* reexport */ useResizeCanvas; },
  "__unstableBlockSettingsMenuFirstItem": function() { return /* reexport */ block_settings_menu_first_item; },
  "__unstableEditorStyles": function() { return /* reexport */ EditorStyles; },
  "__unstableIframe": function() { return /* reexport */ iframe; },
  "__unstableInserterMenuExtension": function() { return /* reexport */ inserter_menu_extension; },
  "__unstableRichTextInputEvent": function() { return /* reexport */ __unstableRichTextInputEvent; },
  "__unstableUseBlockSelectionClearer": function() { return /* reexport */ useBlockSelectionClearer; },
  "__unstableUseClipboardHandler": function() { return /* reexport */ useClipboardHandler; },
  "__unstableUseMouseMoveTypingReset": function() { return /* reexport */ useMouseMoveTypingReset; },
  "__unstableUseTypewriter": function() { return /* reexport */ useTypewriter; },
  "__unstableUseTypingObserver": function() { return /* reexport */ useTypingObserver; },
  "createCustomColorsHOC": function() { return /* reexport */ createCustomColorsHOC; },
  "getColorClassName": function() { return /* reexport */ getColorClassName; },
  "getColorObjectByAttributeValues": function() { return /* reexport */ getColorObjectByAttributeValues; },
  "getColorObjectByColorValue": function() { return /* reexport */ getColorObjectByColorValue; },
  "getFontSize": function() { return /* reexport */ getFontSize; },
  "getFontSizeClass": function() { return /* reexport */ getFontSizeClass; },
  "getFontSizeObjectByValue": function() { return /* reexport */ getFontSizeObjectByValue; },
  "getGradientSlugByValue": function() { return /* reexport */ getGradientSlugByValue; },
  "getGradientValueBySlug": function() { return /* reexport */ getGradientValueBySlug; },
  "getPxFromCssUnit": function() { return /* reexport */ parse_css_unit_to_px; },
  "store": function() { return /* reexport */ store; },
  "storeConfig": function() { return /* reexport */ storeConfig; },
  "transformStyles": function() { return /* reexport */ transform_styles; },
  "useBlockDisplayInformation": function() { return /* reexport */ useBlockDisplayInformation; },
  "useBlockEditContext": function() { return /* reexport */ useBlockEditContext; },
  "useBlockProps": function() { return /* reexport */ useBlockProps; },
  "useCachedTruthy": function() { return /* reexport */ useCachedTruthy; },
  "useInnerBlocksProps": function() { return /* reexport */ useInnerBlocksProps; },
  "useSetting": function() { return /* reexport */ useSetting; },
  "withColorContext": function() { return /* reexport */ with_color_context; },
  "withColors": function() { return /* reexport */ withColors; },
  "withFontSizes": function() { return /* reexport */ with_font_sizes; }
});

// NAMESPACE OBJECT: ./packages/block-editor/build-module/store/selectors.js
var selectors_namespaceObject = {};
__webpack_require__.r(selectors_namespaceObject);
__webpack_require__.d(selectors_namespaceObject, {
  "__experimentalGetActiveBlockIdByBlockNames": function() { return __experimentalGetActiveBlockIdByBlockNames; },
  "__experimentalGetAllowedBlocks": function() { return __experimentalGetAllowedBlocks; },
  "__experimentalGetAllowedPatterns": function() { return __experimentalGetAllowedPatterns; },
  "__experimentalGetBlockListSettingsForBlocks": function() { return __experimentalGetBlockListSettingsForBlocks; },
  "__experimentalGetDirectInsertBlock": function() { return __experimentalGetDirectInsertBlock; },
  "__experimentalGetLastBlockAttributeChanges": function() { return __experimentalGetLastBlockAttributeChanges; },
  "__experimentalGetParsedPattern": function() { return __experimentalGetParsedPattern; },
  "__experimentalGetPatternTransformItems": function() { return __experimentalGetPatternTransformItems; },
  "__experimentalGetPatternsByBlockTypes": function() { return __experimentalGetPatternsByBlockTypes; },
  "__experimentalGetReusableBlockTitle": function() { return __experimentalGetReusableBlockTitle; },
  "__unstableGetBlockWithoutInnerBlocks": function() { return __unstableGetBlockWithoutInnerBlocks; },
  "__unstableGetClientIdWithClientIdsTree": function() { return __unstableGetClientIdWithClientIdsTree; },
  "__unstableGetClientIdsTree": function() { return __unstableGetClientIdsTree; },
  "__unstableIsLastBlockChangeIgnored": function() { return __unstableIsLastBlockChangeIgnored; },
  "areInnerBlocksControlled": function() { return areInnerBlocksControlled; },
  "canInsertBlockType": function() { return canInsertBlockType; },
  "canInsertBlocks": function() { return canInsertBlocks; },
  "canMoveBlock": function() { return canMoveBlock; },
  "canMoveBlocks": function() { return canMoveBlocks; },
  "canRemoveBlock": function() { return canRemoveBlock; },
  "canRemoveBlocks": function() { return canRemoveBlocks; },
  "didAutomaticChange": function() { return didAutomaticChange; },
  "getAdjacentBlockClientId": function() { return getAdjacentBlockClientId; },
  "getBlock": function() { return getBlock; },
  "getBlockAttributes": function() { return getBlockAttributes; },
  "getBlockCount": function() { return getBlockCount; },
  "getBlockHierarchyRootClientId": function() { return getBlockHierarchyRootClientId; },
  "getBlockIndex": function() { return getBlockIndex; },
  "getBlockInsertionPoint": function() { return getBlockInsertionPoint; },
  "getBlockListSettings": function() { return getBlockListSettings; },
  "getBlockMode": function() { return getBlockMode; },
  "getBlockName": function() { return getBlockName; },
  "getBlockOrder": function() { return getBlockOrder; },
  "getBlockParents": function() { return getBlockParents; },
  "getBlockParentsByBlockName": function() { return getBlockParentsByBlockName; },
  "getBlockRootClientId": function() { return getBlockRootClientId; },
  "getBlockSelectionEnd": function() { return getBlockSelectionEnd; },
  "getBlockSelectionStart": function() { return getBlockSelectionStart; },
  "getBlockTransformItems": function() { return getBlockTransformItems; },
  "getBlocks": function() { return getBlocks; },
  "getBlocksByClientId": function() { return getBlocksByClientId; },
  "getClientIdsOfDescendants": function() { return getClientIdsOfDescendants; },
  "getClientIdsWithDescendants": function() { return getClientIdsWithDescendants; },
  "getDraggedBlockClientIds": function() { return getDraggedBlockClientIds; },
  "getFirstMultiSelectedBlockClientId": function() { return getFirstMultiSelectedBlockClientId; },
  "getGlobalBlockCount": function() { return getGlobalBlockCount; },
  "getInserterItems": function() { return getInserterItems; },
  "getLastMultiSelectedBlockClientId": function() { return getLastMultiSelectedBlockClientId; },
  "getLowestCommonAncestorWithSelectedBlock": function() { return getLowestCommonAncestorWithSelectedBlock; },
  "getMultiSelectedBlockClientIds": function() { return getMultiSelectedBlockClientIds; },
  "getMultiSelectedBlocks": function() { return getMultiSelectedBlocks; },
  "getMultiSelectedBlocksEndClientId": function() { return getMultiSelectedBlocksEndClientId; },
  "getMultiSelectedBlocksStartClientId": function() { return getMultiSelectedBlocksStartClientId; },
  "getNextBlockClientId": function() { return getNextBlockClientId; },
  "getPreviousBlockClientId": function() { return getPreviousBlockClientId; },
  "getSelectedBlock": function() { return getSelectedBlock; },
  "getSelectedBlockClientId": function() { return getSelectedBlockClientId; },
  "getSelectedBlockClientIds": function() { return getSelectedBlockClientIds; },
  "getSelectedBlockCount": function() { return getSelectedBlockCount; },
  "getSelectedBlocksInitialCaretPosition": function() { return getSelectedBlocksInitialCaretPosition; },
  "getSelectionEnd": function() { return getSelectionEnd; },
  "getSelectionStart": function() { return getSelectionStart; },
  "getSettings": function() { return getSettings; },
  "getTemplate": function() { return getTemplate; },
  "getTemplateLock": function() { return getTemplateLock; },
  "hasBlockMovingClientId": function() { return selectors_hasBlockMovingClientId; },
  "hasInserterItems": function() { return hasInserterItems; },
  "hasMultiSelection": function() { return hasMultiSelection; },
  "hasSelectedBlock": function() { return hasSelectedBlock; },
  "hasSelectedInnerBlock": function() { return hasSelectedInnerBlock; },
  "isAncestorBeingDragged": function() { return isAncestorBeingDragged; },
  "isAncestorMultiSelected": function() { return isAncestorMultiSelected; },
  "isBlockBeingDragged": function() { return isBlockBeingDragged; },
  "isBlockHighlighted": function() { return isBlockHighlighted; },
  "isBlockInsertionPointVisible": function() { return isBlockInsertionPointVisible; },
  "isBlockMultiSelected": function() { return isBlockMultiSelected; },
  "isBlockSelected": function() { return isBlockSelected; },
  "isBlockValid": function() { return isBlockValid; },
  "isBlockWithinSelection": function() { return isBlockWithinSelection; },
  "isCaretWithinFormattedText": function() { return selectors_isCaretWithinFormattedText; },
  "isDraggingBlocks": function() { return isDraggingBlocks; },
  "isFirstMultiSelectedBlock": function() { return isFirstMultiSelectedBlock; },
  "isLastBlockChangePersistent": function() { return isLastBlockChangePersistent; },
  "isMultiSelecting": function() { return selectors_isMultiSelecting; },
  "isNavigationMode": function() { return selectors_isNavigationMode; },
  "isSelectionEnabled": function() { return selectors_isSelectionEnabled; },
  "isTyping": function() { return selectors_isTyping; },
  "isValidTemplate": function() { return isValidTemplate; },
  "wasBlockJustInserted": function() { return wasBlockJustInserted; }
});

// NAMESPACE OBJECT: ./packages/block-editor/build-module/store/actions.js
var actions_namespaceObject = {};
__webpack_require__.r(actions_namespaceObject);
__webpack_require__.d(actions_namespaceObject, {
  "__unstableMarkAutomaticChange": function() { return __unstableMarkAutomaticChange; },
  "__unstableMarkLastChangeAsPersistent": function() { return __unstableMarkLastChangeAsPersistent; },
  "__unstableMarkNextChangeAsNotPersistent": function() { return __unstableMarkNextChangeAsNotPersistent; },
  "__unstableSaveReusableBlock": function() { return __unstableSaveReusableBlock; },
  "clearSelectedBlock": function() { return clearSelectedBlock; },
  "duplicateBlocks": function() { return duplicateBlocks; },
  "enterFormattedText": function() { return enterFormattedText; },
  "exitFormattedText": function() { return exitFormattedText; },
  "flashBlock": function() { return flashBlock; },
  "hideInsertionPoint": function() { return hideInsertionPoint; },
  "insertAfterBlock": function() { return insertAfterBlock; },
  "insertBeforeBlock": function() { return insertBeforeBlock; },
  "insertBlock": function() { return insertBlock; },
  "insertBlocks": function() { return insertBlocks; },
  "insertDefaultBlock": function() { return insertDefaultBlock; },
  "mergeBlocks": function() { return mergeBlocks; },
  "moveBlockToPosition": function() { return moveBlockToPosition; },
  "moveBlocksDown": function() { return moveBlocksDown; },
  "moveBlocksToPosition": function() { return moveBlocksToPosition; },
  "moveBlocksUp": function() { return moveBlocksUp; },
  "multiSelect": function() { return multiSelect; },
  "receiveBlocks": function() { return receiveBlocks; },
  "removeBlock": function() { return removeBlock; },
  "removeBlocks": function() { return removeBlocks; },
  "replaceBlock": function() { return replaceBlock; },
  "replaceBlocks": function() { return replaceBlocks; },
  "replaceInnerBlocks": function() { return replaceInnerBlocks; },
  "resetBlocks": function() { return resetBlocks; },
  "resetSelection": function() { return resetSelection; },
  "selectBlock": function() { return selectBlock; },
  "selectNextBlock": function() { return selectNextBlock; },
  "selectPreviousBlock": function() { return selectPreviousBlock; },
  "selectionChange": function() { return selectionChange; },
  "setBlockMovingClientId": function() { return setBlockMovingClientId; },
  "setHasControlledInnerBlocks": function() { return setHasControlledInnerBlocks; },
  "setNavigationMode": function() { return setNavigationMode; },
  "setTemplateValidity": function() { return setTemplateValidity; },
  "showInsertionPoint": function() { return showInsertionPoint; },
  "startDraggingBlocks": function() { return startDraggingBlocks; },
  "startMultiSelect": function() { return startMultiSelect; },
  "startTyping": function() { return startTyping; },
  "stopDraggingBlocks": function() { return stopDraggingBlocks; },
  "stopMultiSelect": function() { return stopMultiSelect; },
  "stopTyping": function() { return stopTyping; },
  "synchronizeTemplate": function() { return synchronizeTemplate; },
  "toggleBlockHighlight": function() { return toggleBlockHighlight; },
  "toggleBlockMode": function() { return toggleBlockMode; },
  "toggleSelection": function() { return toggleSelection; },
  "updateBlock": function() { return updateBlock; },
  "updateBlockAttributes": function() { return updateBlockAttributes; },
  "updateBlockListSettings": function() { return updateBlockListSettings; },
  "updateSettings": function() { return updateSettings; },
  "validateBlocksToTemplate": function() { return validateBlocksToTemplate; }
});

;// CONCATENATED MODULE: external ["wp","blocks"]
var external_wp_blocks_namespaceObject = window["wp"]["blocks"];
;// CONCATENATED MODULE: external ["wp","hooks"]
var external_wp_hooks_namespaceObject = window["wp"]["hooks"];
;// CONCATENATED MODULE: ./packages/block-editor/build-module/hooks/compat.js
/**
 * WordPress dependencies
 */



function migrateLightBlockWrapper(settings) {
  const {
    apiVersion = 1
  } = settings;

  if (apiVersion < 2 && (0,external_wp_blocks_namespaceObject.hasBlockSupport)(settings, 'lightBlockWrapper', false)) {
    settings.apiVersion = 2;
  }

  return settings;
}

(0,external_wp_hooks_namespaceObject.addFilter)('blocks.registerBlockType', 'core/compat/migrateLightBlockWrapper', migrateLightBlockWrapper);

;// CONCATENATED MODULE: ./node_modules/@babel/runtime/helpers/esm/extends.js
function _extends() {
  _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  return _extends.apply(this, arguments);
}
;// CONCATENATED MODULE: external ["wp","element"]
var external_wp_element_namespaceObject = window["wp"]["element"];
// EXTERNAL MODULE: ./node_modules/classnames/index.js
var classnames = __webpack_require__(4403);
var classnames_default = /*#__PURE__*/__webpack_require__.n(classnames);
;// CONCATENATED MODULE: external "lodash"
var external_lodash_namespaceObject = window["lodash"];
;// CONCATENATED MODULE: external ["wp","compose"]
var external_wp_compose_namespaceObject = window["wp"]["compose"];
;// CONCATENATED MODULE: external ["wp","components"]
var external_wp_components_namespaceObject = window["wp"]["components"];
;// CONCATENATED MODULE: external ["wp","data"]
var external_wp_data_namespaceObject = window["wp"]["data"];
;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-controls/groups.js
/**
 * WordPress dependencies
 */

const BlockControlsDefault = (0,external_wp_components_namespaceObject.createSlotFill)('BlockControls');
const BlockControlsBlock = (0,external_wp_components_namespaceObject.createSlotFill)('BlockControlsBlock');
const BlockControlsInline = (0,external_wp_components_namespaceObject.createSlotFill)('BlockFormatControls');
const BlockControlsOther = (0,external_wp_components_namespaceObject.createSlotFill)('BlockControlsOther');
const BlockControlsParent = (0,external_wp_components_namespaceObject.createSlotFill)('BlockControlsParent');
const groups = {
  default: BlockControlsDefault,
  block: BlockControlsBlock,
  inline: BlockControlsInline,
  other: BlockControlsOther,
  parent: BlockControlsParent
};
/* harmony default export */ var block_controls_groups = (groups);

;// CONCATENATED MODULE: external ["wp","i18n"]
var external_wp_i18n_namespaceObject = window["wp"]["i18n"];
;// CONCATENATED MODULE: ./packages/block-editor/build-module/store/defaults.js
/**
 * WordPress dependencies
 */

const PREFERENCES_DEFAULTS = {
  insertUsage: {}
};
/**
 * The default editor settings
 *
 * @typedef {Object} SETTINGS_DEFAULT
 * @property {boolean}       alignWide                              Enable/Disable Wide/Full Alignments
 * @property {boolean}       supportsLayout                         Enable/disable layouts support in container blocks.
 * @property {boolean}       imageEditing                           Image Editing settings set to false to disable.
 * @property {Array}         imageSizes                             Available image sizes
 * @property {number}        maxWidth                               Max width to constraint resizing
 * @property {boolean|Array} allowedBlockTypes                      Allowed block types
 * @property {boolean}       hasFixedToolbar                        Whether or not the editor toolbar is fixed
 * @property {boolean}       focusMode                              Whether the focus mode is enabled or not
 * @property {Array}         styles                                 Editor Styles
 * @property {boolean}       keepCaretInsideBlock                   Whether caret should move between blocks in edit mode
 * @property {string}        bodyPlaceholder                        Empty post placeholder
 * @property {string}        titlePlaceholder                       Empty title placeholder
 * @property {boolean}       codeEditingEnabled                     Whether or not the user can switch to the code editor
 * @property {boolean}       __experimentalCanUserUseUnfilteredHTML Whether the user should be able to use unfiltered HTML or the HTML should be filtered e.g., to remove elements considered insecure like iframes.
 * @property {boolean}       __experimentalBlockDirectory           Whether the user has enabled the Block Directory
 * @property {Array}         __experimentalBlockPatterns            Array of objects representing the block patterns
 * @property {Array}         __experimentalBlockPatternCategories   Array of objects representing the block pattern categories
 * @property {boolean}       __unstableGalleryWithImageBlocks       Whether the user has enabled the refactored gallery block which uses InnerBlocks
 */

const SETTINGS_DEFAULTS = {
  alignWide: false,
  supportsLayout: true,
  // colors setting is not used anymore now defaults are passed from theme.json on the server and core has its own defaults.
  // The setting is only kept for backward compatibility purposes.
  colors: [{
    name: (0,external_wp_i18n_namespaceObject.__)('Black'),
    slug: 'black',
    color: '#000000'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Cyan bluish gray'),
    slug: 'cyan-bluish-gray',
    color: '#abb8c3'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('White'),
    slug: 'white',
    color: '#ffffff'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Pale pink'),
    slug: 'pale-pink',
    color: '#f78da7'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Vivid red'),
    slug: 'vivid-red',
    color: '#cf2e2e'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Luminous vivid orange'),
    slug: 'luminous-vivid-orange',
    color: '#ff6900'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Luminous vivid amber'),
    slug: 'luminous-vivid-amber',
    color: '#fcb900'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Light green cyan'),
    slug: 'light-green-cyan',
    color: '#7bdcb5'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Vivid green cyan'),
    slug: 'vivid-green-cyan',
    color: '#00d084'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Pale cyan blue'),
    slug: 'pale-cyan-blue',
    color: '#8ed1fc'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Vivid cyan blue'),
    slug: 'vivid-cyan-blue',
    color: '#0693e3'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Vivid purple'),
    slug: 'vivid-purple',
    color: '#9b51e0'
  }],
  // fontSizes setting is not used anymore now defaults are passed from theme.json on the server and core has its own defaults.
  // The setting is only kept for backward compatibility purposes.
  fontSizes: [{
    name: (0,external_wp_i18n_namespaceObject._x)('Small', 'font size name'),
    size: 13,
    slug: 'small'
  }, {
    name: (0,external_wp_i18n_namespaceObject._x)('Normal', 'font size name'),
    size: 16,
    slug: 'normal'
  }, {
    name: (0,external_wp_i18n_namespaceObject._x)('Medium', 'font size name'),
    size: 20,
    slug: 'medium'
  }, {
    name: (0,external_wp_i18n_namespaceObject._x)('Large', 'font size name'),
    size: 36,
    slug: 'large'
  }, {
    name: (0,external_wp_i18n_namespaceObject._x)('Huge', 'font size name'),
    size: 42,
    slug: 'huge'
  }],
  // Image default size slug.
  imageDefaultSize: 'large',
  imageSizes: [{
    slug: 'thumbnail',
    name: (0,external_wp_i18n_namespaceObject.__)('Thumbnail')
  }, {
    slug: 'medium',
    name: (0,external_wp_i18n_namespaceObject.__)('Medium')
  }, {
    slug: 'large',
    name: (0,external_wp_i18n_namespaceObject.__)('Large')
  }, {
    slug: 'full',
    name: (0,external_wp_i18n_namespaceObject.__)('Full Size')
  }],
  // Allow plugin to disable Image Editor if need be.
  imageEditing: true,
  // This is current max width of the block inner area
  // It's used to constraint image resizing and this value could be overridden later by themes
  maxWidth: 580,
  // Allowed block types for the editor, defaulting to true (all supported).
  allowedBlockTypes: true,
  // Maximum upload size in bytes allowed for the site.
  maxUploadFileSize: 0,
  // List of allowed mime types and file extensions.
  allowedMimeTypes: null,
  __experimentalCanUserUseUnfilteredHTML: false,
  __experimentalBlockDirectory: false,
  __mobileEnablePageTemplates: false,
  __experimentalBlockPatterns: [],
  __experimentalBlockPatternCategories: [],
  __experimentalSpotlightEntityBlocks: [],
  __experimentalGenerateAnchors: false,
  __unstableGalleryWithImageBlocks: false,
  // gradients setting is not used anymore now defaults are passed from theme.json on the server and core has its own defaults.
  // The setting is only kept for backward compatibility purposes.
  gradients: [{
    name: (0,external_wp_i18n_namespaceObject.__)('Vivid cyan blue to vivid purple'),
    gradient: 'linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)',
    slug: 'vivid-cyan-blue-to-vivid-purple'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Light green cyan to vivid green cyan'),
    gradient: 'linear-gradient(135deg,rgb(122,220,180) 0%,rgb(0,208,130) 100%)',
    slug: 'light-green-cyan-to-vivid-green-cyan'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Luminous vivid amber to luminous vivid orange'),
    gradient: 'linear-gradient(135deg,rgba(252,185,0,1) 0%,rgba(255,105,0,1) 100%)',
    slug: 'luminous-vivid-amber-to-luminous-vivid-orange'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Luminous vivid orange to vivid red'),
    gradient: 'linear-gradient(135deg,rgba(255,105,0,1) 0%,rgb(207,46,46) 100%)',
    slug: 'luminous-vivid-orange-to-vivid-red'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Very light gray to cyan bluish gray'),
    gradient: 'linear-gradient(135deg,rgb(238,238,238) 0%,rgb(169,184,195) 100%)',
    slug: 'very-light-gray-to-cyan-bluish-gray'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Cool to warm spectrum'),
    gradient: 'linear-gradient(135deg,rgb(74,234,220) 0%,rgb(151,120,209) 20%,rgb(207,42,186) 40%,rgb(238,44,130) 60%,rgb(251,105,98) 80%,rgb(254,248,76) 100%)',
    slug: 'cool-to-warm-spectrum'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Blush light purple'),
    gradient: 'linear-gradient(135deg,rgb(255,206,236) 0%,rgb(152,150,240) 100%)',
    slug: 'blush-light-purple'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Blush bordeaux'),
    gradient: 'linear-gradient(135deg,rgb(254,205,165) 0%,rgb(254,45,45) 50%,rgb(107,0,62) 100%)',
    slug: 'blush-bordeaux'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Luminous dusk'),
    gradient: 'linear-gradient(135deg,rgb(255,203,112) 0%,rgb(199,81,192) 50%,rgb(65,88,208) 100%)',
    slug: 'luminous-dusk'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Pale ocean'),
    gradient: 'linear-gradient(135deg,rgb(255,245,203) 0%,rgb(182,227,212) 50%,rgb(51,167,181) 100%)',
    slug: 'pale-ocean'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Electric grass'),
    gradient: 'linear-gradient(135deg,rgb(202,248,128) 0%,rgb(113,206,126) 100%)',
    slug: 'electric-grass'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Midnight'),
    gradient: 'linear-gradient(135deg,rgb(2,3,129) 0%,rgb(40,116,252) 100%)',
    slug: 'midnight'
  }],
  __unstableResolvedAssets: {
    styles: [],
    scripts: []
  }
};

;// CONCATENATED MODULE: ./packages/block-editor/build-module/store/array.js
/**
 * External dependencies
 */

/**
 * Insert one or multiple elements into a given position of an array.
 *
 * @param {Array}  array    Source array.
 * @param {*}      elements Elements to insert.
 * @param {number} index    Insert Position.
 *
 * @return {Array} Result.
 */

function insertAt(array, elements, index) {
  return [...array.slice(0, index), ...(0,external_lodash_namespaceObject.castArray)(elements), ...array.slice(index)];
}
/**
 * Moves an element in an array.
 *
 * @param {Array}  array Source array.
 * @param {number} from  Source index.
 * @param {number} to    Destination index.
 * @param {number} count Number of elements to move.
 *
 * @return {Array} Result.
 */

function moveTo(array, from, to) {
  let count = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;
  const withoutMovedElements = [...array];
  withoutMovedElements.splice(from, count);
  return insertAt(withoutMovedElements, array.slice(from, from + count), to);
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/store/reducer.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



/**
 * Given an array of blocks, returns an object where each key is a nesting
 * context, the value of which is an array of block client IDs existing within
 * that nesting context.
 *
 * @param {Array}   blocks       Blocks to map.
 * @param {?string} rootClientId Assumed root client ID.
 *
 * @return {Object} Block order map object.
 */

function mapBlockOrder(blocks) {
  let rootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  const result = {
    [rootClientId]: []
  };
  blocks.forEach(block => {
    const {
      clientId,
      innerBlocks
    } = block;
    result[rootClientId].push(clientId);
    Object.assign(result, mapBlockOrder(innerBlocks, clientId));
  });
  return result;
}
/**
 * Given an array of blocks, returns an object where each key contains
 * the clientId of the block and the value is the parent of the block.
 *
 * @param {Array}   blocks       Blocks to map.
 * @param {?string} rootClientId Assumed root client ID.
 *
 * @return {Object} Block order map object.
 */


function mapBlockParents(blocks) {
  let rootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  return blocks.reduce((result, block) => Object.assign(result, {
    [block.clientId]: rootClientId
  }, mapBlockParents(block.innerBlocks, block.clientId)), {});
}
/**
 * Helper method to iterate through all blocks, recursing into inner blocks,
 * applying a transformation function to each one.
 * Returns a flattened object with the transformed blocks.
 *
 * @param {Array}    blocks    Blocks to flatten.
 * @param {Function} transform Transforming function to be applied to each block.
 *
 * @return {Object} Flattened object.
 */


function flattenBlocks(blocks) {
  let transform = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : external_lodash_namespaceObject.identity;
  const result = {};
  const stack = [...blocks];

  while (stack.length) {
    const {
      innerBlocks,
      ...block
    } = stack.shift();
    stack.push(...innerBlocks);
    result[block.clientId] = transform(block);
  }

  return result;
}
/**
 * Given an array of blocks, returns an object containing all blocks, without
 * attributes, recursing into inner blocks. Keys correspond to the block client
 * ID, the value of which is the attributes object.
 *
 * @param {Array} blocks Blocks to flatten.
 *
 * @return {Object} Flattened block attributes object.
 */


function getFlattenedBlocksWithoutAttributes(blocks) {
  return flattenBlocks(blocks, block => (0,external_lodash_namespaceObject.omit)(block, 'attributes'));
}
/**
 * Given an array of blocks, returns an object containing all block attributes,
 * recursing into inner blocks. Keys correspond to the block client ID, the
 * value of which is the attributes object.
 *
 * @param {Array} blocks Blocks to flatten.
 *
 * @return {Object} Flattened block attributes object.
 */


function getFlattenedBlockAttributes(blocks) {
  return flattenBlocks(blocks, block => block.attributes);
}
/**
 * Returns an object against which it is safe to perform mutating operations,
 * given the original object and its current working copy.
 *
 * @param {Object} original Original object.
 * @param {Object} working  Working object.
 *
 * @return {Object} Mutation-safe object.
 */


function getMutateSafeObject(original, working) {
  if (original === working) {
    return { ...original
    };
  }

  return working;
}
/**
 * Returns true if the two object arguments have the same keys, or false
 * otherwise.
 *
 * @param {Object} a First object.
 * @param {Object} b Second object.
 *
 * @return {boolean} Whether the two objects have the same keys.
 */


function hasSameKeys(a, b) {
  return (0,external_lodash_namespaceObject.isEqual)((0,external_lodash_namespaceObject.keys)(a), (0,external_lodash_namespaceObject.keys)(b));
}
/**
 * Returns true if, given the currently dispatching action and the previously
 * dispatched action, the two actions are updating the same block attribute, or
 * false otherwise.
 *
 * @param {Object} action     Currently dispatching action.
 * @param {Object} lastAction Previously dispatched action.
 *
 * @return {boolean} Whether actions are updating the same block attribute.
 */

function isUpdatingSameBlockAttribute(action, lastAction) {
  return action.type === 'UPDATE_BLOCK_ATTRIBUTES' && lastAction !== undefined && lastAction.type === 'UPDATE_BLOCK_ATTRIBUTES' && (0,external_lodash_namespaceObject.isEqual)(action.clientIds, lastAction.clientIds) && hasSameKeys(action.attributes, lastAction.attributes);
}

function buildBlockTree(state, blocks) {
  const result = {};
  const stack = [...blocks];
  const flattenedBlocks = [...blocks];

  while (stack.length) {
    const block = stack.shift();
    stack.push(...block.innerBlocks);
    flattenedBlocks.push(...block.innerBlocks);
  } // Create objects before mutating them, that way it's always defined.


  for (const block of flattenedBlocks) {
    result[block.clientId] = {};
  }

  for (const block of flattenedBlocks) {
    result[block.clientId] = Object.assign(result[block.clientId], { ...state.byClientId[block.clientId],
      attributes: state.attributes[block.clientId],
      innerBlocks: block.innerBlocks.map(subBlock => result[subBlock.clientId])
    });
  }

  return result;
}

function updateParentInnerBlocksInTree(state, tree, updatedClientIds) {
  let updateChildrenOfUpdatedClientIds = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
  const uncontrolledParents = new Set([]);
  const controlledParents = new Set();

  for (const clientId of updatedClientIds) {
    let current = updateChildrenOfUpdatedClientIds ? clientId : state.parents[clientId];

    do {
      if (state.controlledInnerBlocks[current]) {
        // Should stop on controlled blocks.
        // If we reach a controlled parent, break out of the loop.
        controlledParents.add(current);
        break;
      } else {
        // Else continue traversing up through parents.
        uncontrolledParents.add(current);
        current = state.parents[current];
      }
    } while (current !== undefined);
  } // To make sure the order of assignments doesn't matter,
  // we first create empty objects and mutates the inner blocks later.


  for (const clientId of uncontrolledParents) {
    tree[clientId] = { ...tree[clientId]
    };
  }

  for (const clientId of uncontrolledParents) {
    tree[clientId].innerBlocks = (state.order[clientId] || []).map(subClientId => tree[subClientId]);
  } // Controlled parent blocks, need a dedicated key for their inner blocks
  // to be used when doing getBlocks( controlledBlockClientId ).


  for (const clientId of controlledParents) {
    tree['controlled||' + clientId] = {
      innerBlocks: (state.order[clientId] || []).map(subClientId => tree[subClientId])
    };
  }

  return tree;
}
/**
 * Higher-order reducer intended to compute full block objects key for each block in the post.
 * This is a denormalization to optimize the performance of the getBlock selectors and avoid
 * recomputing the block objects and avoid heavy memoization.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */


const withBlockTree = reducer => function () {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  let action = arguments.length > 1 ? arguments[1] : undefined;
  const newState = reducer(state, action);

  if (newState === state) {
    return state;
  }

  newState.tree = state.tree ? state.tree : {};

  switch (action.type) {
    case 'RECEIVE_BLOCKS':
    case 'INSERT_BLOCKS':
      {
        const subTree = buildBlockTree(newState, action.blocks);
        newState.tree = updateParentInnerBlocksInTree(newState, { ...newState.tree,
          ...subTree
        }, action.rootClientId ? [action.rootClientId] : [''], true);
        break;
      }

    case 'UPDATE_BLOCK':
      newState.tree = updateParentInnerBlocksInTree(newState, { ...newState.tree,
        [action.clientId]: { ...newState.tree[action.clientId],
          ...newState.byClientId[action.clientId],
          attributes: newState.attributes[action.clientId]
        }
      }, [action.clientId], false);
      break;

    case 'UPDATE_BLOCK_ATTRIBUTES':
      {
        const newSubTree = action.clientIds.reduce((result, clientId) => {
          result[clientId] = { ...newState.tree[clientId],
            attributes: newState.attributes[clientId]
          };
          return result;
        }, {});
        newState.tree = updateParentInnerBlocksInTree(newState, { ...newState.tree,
          ...newSubTree
        }, action.clientIds, false);
        break;
      }

    case 'REPLACE_BLOCKS_AUGMENTED_WITH_CHILDREN':
      {
        const subTree = buildBlockTree(newState, action.blocks);
        newState.tree = updateParentInnerBlocksInTree(newState, { ...(0,external_lodash_namespaceObject.omit)(newState.tree, action.replacedClientIds.concat( // Controlled inner blocks are only removed
          // if the block doesn't move to another position
          // otherwise their content will be lost.
          action.replacedClientIds.filter(clientId => !subTree[clientId]).map(clientId => 'controlled||' + clientId))),
          ...subTree
        }, action.blocks.map(b => b.clientId), false); // If there are no replaced blocks, it means we're removing blocks so we need to update their parent.

        const parentsOfRemovedBlocks = [];

        for (const clientId of action.clientIds) {
          if (state.parents[clientId] !== undefined && (state.parents[clientId] === '' || newState.byClientId[state.parents[clientId]])) {
            parentsOfRemovedBlocks.push(state.parents[clientId]);
          }
        }

        newState.tree = updateParentInnerBlocksInTree(newState, newState.tree, parentsOfRemovedBlocks, true);
        break;
      }

    case 'REMOVE_BLOCKS_AUGMENTED_WITH_CHILDREN':
      const parentsOfRemovedBlocks = [];

      for (const clientId of action.clientIds) {
        if (state.parents[clientId] !== undefined && (state.parents[clientId] === '' || newState.byClientId[state.parents[clientId]])) {
          parentsOfRemovedBlocks.push(state.parents[clientId]);
        }
      }

      newState.tree = updateParentInnerBlocksInTree(newState, (0,external_lodash_namespaceObject.omit)(newState.tree, action.removedClientIds.concat(action.removedClientIds.map(clientId => 'controlled||' + clientId))), parentsOfRemovedBlocks, true);
      break;

    case 'MOVE_BLOCKS_TO_POSITION':
      {
        const updatedBlockUids = [];

        if (action.fromRootClientId) {
          updatedBlockUids.push(action.fromRootClientId);
        }

        if (action.toRootClientId) {
          updatedBlockUids.push(action.toRootClientId);
        }

        if (!action.fromRootClientId || !action.fromRootClientId) {
          updatedBlockUids.push('');
        }

        newState.tree = updateParentInnerBlocksInTree(newState, newState.tree, updatedBlockUids, true);
        break;
      }

    case 'MOVE_BLOCKS_UP':
    case 'MOVE_BLOCKS_DOWN':
      {
        const updatedBlockUids = [action.rootClientId ? action.rootClientId : ''];
        newState.tree = updateParentInnerBlocksInTree(newState, newState.tree, updatedBlockUids, true);
        break;
      }

    case 'SAVE_REUSABLE_BLOCK_SUCCESS':
      {
        const updatedBlockUids = (0,external_lodash_namespaceObject.keys)((0,external_lodash_namespaceObject.omitBy)(newState.attributes, (attributes, clientId) => {
          return newState.byClientId[clientId].name !== 'core/block' || attributes.ref !== action.updatedId;
        }));
        newState.tree = updateParentInnerBlocksInTree(newState, { ...newState.tree,
          ...updatedBlockUids.reduce((result, clientId) => {
            result[clientId] = { ...newState.byClientId[clientId],
              attributes: newState.attributes[clientId],
              innerBlocks: newState.tree[clientId].innerBlocks
            };
            return result;
          }, {})
        }, updatedBlockUids, false);
      }
  }

  return newState;
};
/**
 * Higher-order reducer intended to augment the blocks reducer, assigning an
 * `isPersistentChange` property value corresponding to whether a change in
 * state can be considered as persistent. All changes are considered persistent
 * except when updating the same block attribute as in the previous action.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */


function withPersistentBlockChange(reducer) {
  let lastAction;
  let markNextChangeAsNotPersistent = false;
  return (state, action) => {
    let nextState = reducer(state, action);
    const isExplicitPersistentChange = action.type === 'MARK_LAST_CHANGE_AS_PERSISTENT' || markNextChangeAsNotPersistent; // Defer to previous state value (or default) unless changing or
    // explicitly marking as persistent.

    if (state === nextState && !isExplicitPersistentChange) {
      var _state$isPersistentCh;

      markNextChangeAsNotPersistent = action.type === 'MARK_NEXT_CHANGE_AS_NOT_PERSISTENT';
      const nextIsPersistentChange = (_state$isPersistentCh = state === null || state === void 0 ? void 0 : state.isPersistentChange) !== null && _state$isPersistentCh !== void 0 ? _state$isPersistentCh : true;

      if (state.isPersistentChange === nextIsPersistentChange) {
        return state;
      }

      return { ...nextState,
        isPersistentChange: nextIsPersistentChange
      };
    }

    nextState = { ...nextState,
      isPersistentChange: isExplicitPersistentChange ? !markNextChangeAsNotPersistent : !isUpdatingSameBlockAttribute(action, lastAction)
    }; // In comparing against the previous action, consider only those which
    // would have qualified as one which would have been ignored or not
    // have resulted in a changed state.

    lastAction = action;
    markNextChangeAsNotPersistent = action.type === 'MARK_NEXT_CHANGE_AS_NOT_PERSISTENT';
    return nextState;
  };
}
/**
 * Higher-order reducer intended to augment the blocks reducer, assigning an
 * `isIgnoredChange` property value corresponding to whether a change in state
 * can be considered as ignored. A change is considered ignored when the result
 * of an action not incurred by direct user interaction.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */


function withIgnoredBlockChange(reducer) {
  /**
   * Set of action types for which a blocks state change should be ignored.
   *
   * @type {Set}
   */
  const IGNORED_ACTION_TYPES = new Set(['RECEIVE_BLOCKS']);
  return (state, action) => {
    const nextState = reducer(state, action);

    if (nextState !== state) {
      nextState.isIgnoredChange = IGNORED_ACTION_TYPES.has(action.type);
    }

    return nextState;
  };
}
/**
 * Higher-order reducer targeting the combined blocks reducer, augmenting
 * block client IDs in remove action to include cascade of inner blocks.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */


const withInnerBlocksRemoveCascade = reducer => (state, action) => {
  // Gets all children which need to be removed.
  const getAllChildren = clientIds => {
    let result = clientIds;

    for (let i = 0; i < result.length; i++) {
      if (!state.order[result[i]] || action.keepControlledInnerBlocks && action.keepControlledInnerBlocks[result[i]]) {
        continue;
      }

      if (result === clientIds) {
        result = [...result];
      }

      result.push(...state.order[result[i]]);
    }

    return result;
  };

  if (state) {
    switch (action.type) {
      case 'REMOVE_BLOCKS':
        action = { ...action,
          type: 'REMOVE_BLOCKS_AUGMENTED_WITH_CHILDREN',
          removedClientIds: getAllChildren(action.clientIds)
        };
        break;

      case 'REPLACE_BLOCKS':
        action = { ...action,
          type: 'REPLACE_BLOCKS_AUGMENTED_WITH_CHILDREN',
          replacedClientIds: getAllChildren(action.clientIds)
        };
        break;
    }
  }

  return reducer(state, action);
};
/**
 * Higher-order reducer which targets the combined blocks reducer and handles
 * the `RESET_BLOCKS` action. When dispatched, this action will replace all
 * blocks that exist in the post, leaving blocks that exist only in state (e.g.
 * reusable blocks and blocks controlled by inner blocks controllers) alone.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */


const withBlockReset = reducer => (state, action) => {
  if (action.type === 'RESET_BLOCKS') {
    const newState = { ...state,
      byClientId: getFlattenedBlocksWithoutAttributes(action.blocks),
      attributes: getFlattenedBlockAttributes(action.blocks),
      order: mapBlockOrder(action.blocks),
      parents: mapBlockParents(action.blocks),
      controlledInnerBlocks: {}
    };
    const subTree = buildBlockTree(newState, action.blocks);
    newState.tree = { ...subTree,
      // Root.
      '': {
        innerBlocks: action.blocks.map(subBlock => subTree[subBlock.clientId])
      }
    };
    return newState;
  }

  return reducer(state, action);
};
/**
 * Higher-order reducer which targets the combined blocks reducer and handles
 * the `REPLACE_INNER_BLOCKS` action. When dispatched, this action the state
 * should become equivalent to the execution of a `REMOVE_BLOCKS` action
 * containing all the child's of the root block followed by the execution of
 * `INSERT_BLOCKS` with the new blocks.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */


const withReplaceInnerBlocks = reducer => (state, action) => {
  if (action.type !== 'REPLACE_INNER_BLOCKS') {
    return reducer(state, action);
  } // Finds every nested inner block controller. We must check the action blocks
  // and not just the block parent state because some inner block controllers
  // should be deleted if specified, whereas others should not be deleted. If
  // a controlled should not be deleted, then we need to avoid deleting its
  // inner blocks from the block state because its inner blocks will not be
  // attached to the block in the action.


  const nestedControllers = {};

  if (Object.keys(state.controlledInnerBlocks).length) {
    const stack = [...action.blocks];

    while (stack.length) {
      const {
        innerBlocks,
        ...block
      } = stack.shift();
      stack.push(...innerBlocks);

      if (!!state.controlledInnerBlocks[block.clientId]) {
        nestedControllers[block.clientId] = true;
      }
    }
  } // The `keepControlledInnerBlocks` prop will keep the inner blocks of the
  // marked block in the block state so that they can be reattached to the
  // marked block when we re-insert everything a few lines below.


  let stateAfterBlocksRemoval = state;

  if (state.order[action.rootClientId]) {
    stateAfterBlocksRemoval = reducer(stateAfterBlocksRemoval, {
      type: 'REMOVE_BLOCKS',
      keepControlledInnerBlocks: nestedControllers,
      clientIds: state.order[action.rootClientId]
    });
  }

  let stateAfterInsert = stateAfterBlocksRemoval;

  if (action.blocks.length) {
    stateAfterInsert = reducer(stateAfterInsert, { ...action,
      type: 'INSERT_BLOCKS',
      index: 0
    }); // We need to re-attach the block order of the controlled inner blocks.
    // Otherwise, an inner block controller's blocks will be deleted entirely
    // from its entity..

    stateAfterInsert.order = { ...stateAfterInsert.order,
      ...(0,external_lodash_namespaceObject.reduce)(nestedControllers, (result, value, key) => {
        if (state.order[key]) {
          result[key] = state.order[key];
        }

        return result;
      }, {})
    };
  }

  return stateAfterInsert;
};
/**
 * Higher-order reducer which targets the combined blocks reducer and handles
 * the `SAVE_REUSABLE_BLOCK_SUCCESS` action. This action can't be handled by
 * regular reducers and needs a higher-order reducer since it needs access to
 * both `byClientId` and `attributes` simultaneously.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */


const withSaveReusableBlock = reducer => (state, action) => {
  if (state && action.type === 'SAVE_REUSABLE_BLOCK_SUCCESS') {
    const {
      id,
      updatedId
    } = action; // If a temporary reusable block is saved, we swap the temporary id with the final one.

    if (id === updatedId) {
      return state;
    }

    state = { ...state
    };
    state.attributes = (0,external_lodash_namespaceObject.mapValues)(state.attributes, (attributes, clientId) => {
      const {
        name
      } = state.byClientId[clientId];

      if (name === 'core/block' && attributes.ref === id) {
        return { ...attributes,
          ref: updatedId
        };
      }

      return attributes;
    });
  }

  return reducer(state, action);
};
/**
 * Higher-order reducer which removes blocks from state when switching parent block controlled state.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */


const withResetControlledBlocks = reducer => (state, action) => {
  if (action.type === 'SET_HAS_CONTROLLED_INNER_BLOCKS') {
    // when switching a block from controlled to uncontrolled or inverse,
    // we need to remove its content first.
    const tempState = reducer(state, {
      type: 'REPLACE_INNER_BLOCKS',
      rootClientId: action.clientId,
      blocks: []
    });
    return reducer(tempState, action);
  }

  return reducer(state, action);
};
/**
 * Reducer returning the blocks state.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */


const blocks = (0,external_lodash_namespaceObject.flow)(external_wp_data_namespaceObject.combineReducers, withSaveReusableBlock, // Needs to be before withBlockCache.
withBlockTree, // Needs to be before withInnerBlocksRemoveCascade.
withInnerBlocksRemoveCascade, withReplaceInnerBlocks, // Needs to be after withInnerBlocksRemoveCascade.
withBlockReset, withPersistentBlockChange, withIgnoredBlockChange, withResetControlledBlocks)({
  byClientId() {
    let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    let action = arguments.length > 1 ? arguments[1] : undefined;

    switch (action.type) {
      case 'RECEIVE_BLOCKS':
      case 'INSERT_BLOCKS':
        return { ...state,
          ...getFlattenedBlocksWithoutAttributes(action.blocks)
        };

      case 'UPDATE_BLOCK':
        // Ignore updates if block isn't known.
        if (!state[action.clientId]) {
          return state;
        } // Do nothing if only attributes change.


        const changes = (0,external_lodash_namespaceObject.omit)(action.updates, 'attributes');

        if ((0,external_lodash_namespaceObject.isEmpty)(changes)) {
          return state;
        }

        return { ...state,
          [action.clientId]: { ...state[action.clientId],
            ...changes
          }
        };

      case 'REPLACE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        if (!action.blocks) {
          return state;
        }

        return { ...(0,external_lodash_namespaceObject.omit)(state, action.replacedClientIds),
          ...getFlattenedBlocksWithoutAttributes(action.blocks)
        };

      case 'REMOVE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        return (0,external_lodash_namespaceObject.omit)(state, action.removedClientIds);
    }

    return state;
  },

  attributes() {
    let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    let action = arguments.length > 1 ? arguments[1] : undefined;

    switch (action.type) {
      case 'RECEIVE_BLOCKS':
      case 'INSERT_BLOCKS':
        return { ...state,
          ...getFlattenedBlockAttributes(action.blocks)
        };

      case 'UPDATE_BLOCK':
        // Ignore updates if block isn't known or there are no attribute changes.
        if (!state[action.clientId] || !action.updates.attributes) {
          return state;
        }

        return { ...state,
          [action.clientId]: { ...state[action.clientId],
            ...action.updates.attributes
          }
        };

      case 'UPDATE_BLOCK_ATTRIBUTES':
        {
          // Avoid a state change if none of the block IDs are known.
          if (action.clientIds.every(id => !state[id])) {
            return state;
          }

          const next = action.clientIds.reduce((accumulator, id) => ({ ...accumulator,
            [id]: (0,external_lodash_namespaceObject.reduce)(action.uniqueByBlock ? action.attributes[id] : action.attributes, (result, value, key) => {
              // Consider as updates only changed values.
              if (value !== result[key]) {
                result = getMutateSafeObject(state[id], result);
                result[key] = value;
              }

              return result;
            }, state[id])
          }), {});

          if (action.clientIds.every(id => next[id] === state[id])) {
            return state;
          }

          return { ...state,
            ...next
          };
        }

      case 'REPLACE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        if (!action.blocks) {
          return state;
        }

        return { ...(0,external_lodash_namespaceObject.omit)(state, action.replacedClientIds),
          ...getFlattenedBlockAttributes(action.blocks)
        };

      case 'REMOVE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        return (0,external_lodash_namespaceObject.omit)(state, action.removedClientIds);
    }

    return state;
  },

  order() {
    let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    let action = arguments.length > 1 ? arguments[1] : undefined;

    switch (action.type) {
      case 'RECEIVE_BLOCKS':
        {
          const blockOrder = mapBlockOrder(action.blocks);
          return { ...state,
            ...(0,external_lodash_namespaceObject.omit)(blockOrder, ''),
            '': ((state === null || state === void 0 ? void 0 : state['']) || []).concat(blockOrder[''])
          };
        }

      case 'INSERT_BLOCKS':
        {
          const {
            rootClientId = ''
          } = action;
          const subState = state[rootClientId] || [];
          const mappedBlocks = mapBlockOrder(action.blocks, rootClientId);
          const {
            index = subState.length
          } = action;
          return { ...state,
            ...mappedBlocks,
            [rootClientId]: insertAt(subState, mappedBlocks[rootClientId], index)
          };
        }

      case 'MOVE_BLOCKS_TO_POSITION':
        {
          const {
            fromRootClientId = '',
            toRootClientId = '',
            clientIds
          } = action;
          const {
            index = state[toRootClientId].length
          } = action; // Moving inside the same parent block.

          if (fromRootClientId === toRootClientId) {
            const subState = state[toRootClientId];
            const fromIndex = subState.indexOf(clientIds[0]);
            return { ...state,
              [toRootClientId]: moveTo(state[toRootClientId], fromIndex, index, clientIds.length)
            };
          } // Moving from a parent block to another.


          return { ...state,
            [fromRootClientId]: (0,external_lodash_namespaceObject.without)(state[fromRootClientId], ...clientIds),
            [toRootClientId]: insertAt(state[toRootClientId], clientIds, index)
          };
        }

      case 'MOVE_BLOCKS_UP':
        {
          const {
            clientIds,
            rootClientId = ''
          } = action;
          const firstClientId = (0,external_lodash_namespaceObject.first)(clientIds);
          const subState = state[rootClientId];

          if (!subState.length || firstClientId === (0,external_lodash_namespaceObject.first)(subState)) {
            return state;
          }

          const firstIndex = subState.indexOf(firstClientId);
          return { ...state,
            [rootClientId]: moveTo(subState, firstIndex, firstIndex - 1, clientIds.length)
          };
        }

      case 'MOVE_BLOCKS_DOWN':
        {
          const {
            clientIds,
            rootClientId = ''
          } = action;
          const firstClientId = (0,external_lodash_namespaceObject.first)(clientIds);
          const lastClientId = (0,external_lodash_namespaceObject.last)(clientIds);
          const subState = state[rootClientId];

          if (!subState.length || lastClientId === (0,external_lodash_namespaceObject.last)(subState)) {
            return state;
          }

          const firstIndex = subState.indexOf(firstClientId);
          return { ...state,
            [rootClientId]: moveTo(subState, firstIndex, firstIndex + 1, clientIds.length)
          };
        }

      case 'REPLACE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        {
          const {
            clientIds
          } = action;

          if (!action.blocks) {
            return state;
          }

          const mappedBlocks = mapBlockOrder(action.blocks);
          return (0,external_lodash_namespaceObject.flow)([nextState => (0,external_lodash_namespaceObject.omit)(nextState, action.replacedClientIds), nextState => ({ ...nextState,
            ...(0,external_lodash_namespaceObject.omit)(mappedBlocks, '')
          }), nextState => (0,external_lodash_namespaceObject.mapValues)(nextState, subState => (0,external_lodash_namespaceObject.reduce)(subState, (result, clientId) => {
            if (clientId === clientIds[0]) {
              return [...result, ...mappedBlocks['']];
            }

            if (clientIds.indexOf(clientId) === -1) {
              result.push(clientId);
            }

            return result;
          }, []))])(state);
        }

      case 'REMOVE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        return (0,external_lodash_namespaceObject.flow)([// Remove inner block ordering for removed blocks.
        nextState => (0,external_lodash_namespaceObject.omit)(nextState, action.removedClientIds), // Remove deleted blocks from other blocks' orderings.
        nextState => (0,external_lodash_namespaceObject.mapValues)(nextState, subState => (0,external_lodash_namespaceObject.without)(subState, ...action.removedClientIds))])(state);
    }

    return state;
  },

  // While technically redundant data as the inverse of `order`, it serves as
  // an optimization for the selectors which derive the ancestry of a block.
  parents() {
    let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    let action = arguments.length > 1 ? arguments[1] : undefined;

    switch (action.type) {
      case 'RECEIVE_BLOCKS':
        return { ...state,
          ...mapBlockParents(action.blocks)
        };

      case 'INSERT_BLOCKS':
        return { ...state,
          ...mapBlockParents(action.blocks, action.rootClientId || '')
        };

      case 'MOVE_BLOCKS_TO_POSITION':
        {
          return { ...state,
            ...action.clientIds.reduce((accumulator, id) => {
              accumulator[id] = action.toRootClientId || '';
              return accumulator;
            }, {})
          };
        }

      case 'REPLACE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        return { ...(0,external_lodash_namespaceObject.omit)(state, action.replacedClientIds),
          ...mapBlockParents(action.blocks, state[action.clientIds[0]])
        };

      case 'REMOVE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        return (0,external_lodash_namespaceObject.omit)(state, action.removedClientIds);
    }

    return state;
  },

  controlledInnerBlocks() {
    let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    let {
      type,
      clientId,
      hasControlledInnerBlocks
    } = arguments.length > 1 ? arguments[1] : undefined;

    if (type === 'SET_HAS_CONTROLLED_INNER_BLOCKS') {
      return { ...state,
        [clientId]: hasControlledInnerBlocks
      };
    }

    return state;
  }

});
/**
 * Reducer returning typing state.
 *
 * @param {boolean} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {boolean} Updated state.
 */

function isTyping() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'START_TYPING':
      return true;

    case 'STOP_TYPING':
      return false;
  }

  return state;
}
/**
 * Reducer returning dragged block client id.
 *
 * @param {string[]} state  Current state.
 * @param {Object}   action Dispatched action.
 *
 * @return {string[]} Updated state.
 */

function draggedBlocks() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'START_DRAGGING_BLOCKS':
      return action.clientIds;

    case 'STOP_DRAGGING_BLOCKS':
      return [];
  }

  return state;
}
/**
 * Reducer returning whether the caret is within formatted text.
 *
 * @param {boolean} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {boolean} Updated state.
 */

function isCaretWithinFormattedText() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'ENTER_FORMATTED_TEXT':
      return true;

    case 'EXIT_FORMATTED_TEXT':
      return false;
  }

  return state;
}
/**
 * Internal helper reducer for selectionStart and selectionEnd. Can hold a block
 * selection, represented by an object with property clientId.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */

function selectionHelper() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'CLEAR_SELECTED_BLOCK':
      {
        if (state.clientId) {
          return {};
        }

        return state;
      }

    case 'SELECT_BLOCK':
      if (action.clientId === state.clientId) {
        return state;
      }

      return {
        clientId: action.clientId
      };

    case 'REPLACE_INNER_BLOCKS':
    case 'INSERT_BLOCKS':
      {
        if (!action.updateSelection || !action.blocks.length) {
          return state;
        }

        return {
          clientId: action.blocks[0].clientId
        };
      }

    case 'REMOVE_BLOCKS':
      if (!action.clientIds || !action.clientIds.length || action.clientIds.indexOf(state.clientId) === -1) {
        return state;
      }

      return {};

    case 'REPLACE_BLOCKS':
      {
        if (action.clientIds.indexOf(state.clientId) === -1) {
          return state;
        }

        const blockToSelect = action.blocks[action.indexToSelect] || action.blocks[action.blocks.length - 1];

        if (!blockToSelect) {
          return {};
        }

        if (blockToSelect.clientId === state.clientId) {
          return state;
        }

        return {
          clientId: blockToSelect.clientId
        };
      }
  }

  return state;
}
/**
 * Reducer returning the selection state.
 *
 * @param {boolean} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {boolean} Updated state.
 */


function selection() {
  var _state$selectionStart, _state$selectionEnd;

  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'SELECTION_CHANGE':
      return {
        selectionStart: {
          clientId: action.clientId,
          attributeKey: action.attributeKey,
          offset: action.startOffset
        },
        selectionEnd: {
          clientId: action.clientId,
          attributeKey: action.attributeKey,
          offset: action.endOffset
        }
      };

    case 'RESET_SELECTION':
      const {
        selectionStart,
        selectionEnd
      } = action;
      return {
        selectionStart,
        selectionEnd
      };

    case 'MULTI_SELECT':
      const {
        start,
        end
      } = action;
      return {
        selectionStart: {
          clientId: start
        },
        selectionEnd: {
          clientId: end
        }
      };

    case 'RESET_BLOCKS':
      const startClientId = state === null || state === void 0 ? void 0 : (_state$selectionStart = state.selectionStart) === null || _state$selectionStart === void 0 ? void 0 : _state$selectionStart.clientId;
      const endClientId = state === null || state === void 0 ? void 0 : (_state$selectionEnd = state.selectionEnd) === null || _state$selectionEnd === void 0 ? void 0 : _state$selectionEnd.clientId; // Do nothing if there's no selected block.

      if (!startClientId && !endClientId) {
        return state;
      } // If the start of the selection won't exist after reset, remove selection.


      if (!action.blocks.some(block => block.clientId === startClientId)) {
        return {
          selectionStart: {},
          selectionEnd: {}
        };
      } // If the end of the selection won't exist after reset, collapse selection.


      if (!action.blocks.some(block => block.clientId === endClientId)) {
        return { ...state,
          selectionEnd: state.selectionStart
        };
      }

  }

  return {
    selectionStart: selectionHelper(state.selectionStart, action),
    selectionEnd: selectionHelper(state.selectionEnd, action)
  };
}
/**
 * Reducer returning whether the user is multi-selecting.
 *
 * @param {boolean} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {boolean} Updated state.
 */

function isMultiSelecting() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'START_MULTI_SELECT':
      return true;

    case 'STOP_MULTI_SELECT':
      return false;
  }

  return state;
}
/**
 * Reducer returning whether selection is enabled.
 *
 * @param {boolean} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {boolean} Updated state.
 */

function isSelectionEnabled() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'TOGGLE_SELECTION':
      return action.isSelectionEnabled;
  }

  return state;
}
/**
 * Reducer returning the initial block selection.
 *
 * Currently this in only used to restore the selection after block deletion and
 * pasting new content.This reducer should eventually be removed in favour of setting
 * selection directly.
 *
 * @param {boolean} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {number|null} Initial position: 0, -1 or null.
 */

function initialPosition() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  if (action.type === 'REPLACE_BLOCKS' && action.initialPosition !== undefined) {
    return action.initialPosition;
  } else if (['MULTI_SELECT', 'SELECT_BLOCK', 'RESET_SELECTION', 'INSERT_BLOCKS', 'REPLACE_INNER_BLOCKS'].includes(action.type)) {
    return action.initialPosition;
  }

  return state;
}
function blocksMode() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  let action = arguments.length > 1 ? arguments[1] : undefined;

  if (action.type === 'TOGGLE_BLOCK_MODE') {
    const {
      clientId
    } = action;
    return { ...state,
      [clientId]: state[clientId] && state[clientId] === 'html' ? 'visual' : 'html'
    };
  }

  return state;
}
/**
 * Reducer returning the block insertion point visibility, either null if there
 * is not an explicit insertion point assigned, or an object of its `index` and
 * `rootClientId`.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */

function insertionPoint() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'SHOW_INSERTION_POINT':
      const {
        rootClientId,
        index,
        __unstableWithInserter
      } = action;
      return {
        rootClientId,
        index,
        __unstableWithInserter
      };

    case 'HIDE_INSERTION_POINT':
      return null;
  }

  return state;
}
/**
 * Reducer returning whether the post blocks match the defined template or not.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {boolean} Updated state.
 */

function template() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {
    isValid: true
  };
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'SET_TEMPLATE_VALIDITY':
      return { ...state,
        isValid: action.isValid
      };
  }

  return state;
}
/**
 * Reducer returning the editor setting.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */

function settings() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : SETTINGS_DEFAULTS;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'UPDATE_SETTINGS':
      return { ...state,
        ...action.settings
      };
  }

  return state;
}
/**
 * Reducer returning the user preferences.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {string} Updated state.
 */

function preferences() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : PREFERENCES_DEFAULTS;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'INSERT_BLOCKS':
    case 'REPLACE_BLOCKS':
      return action.blocks.reduce((prevState, block) => {
        const {
          attributes,
          name: blockName
        } = block;
        const match = (0,external_wp_data_namespaceObject.select)(external_wp_blocks_namespaceObject.store).getActiveBlockVariation(blockName, attributes); // If a block variation match is found change the name to be the same with the
        // one that is used for block variations in the Inserter (`getItemFromVariation`).

        let id = match !== null && match !== void 0 && match.name ? `${blockName}/${match.name}` : blockName;
        const insert = {
          name: id
        };

        if (blockName === 'core/block') {
          insert.ref = attributes.ref;
          id += '/' + attributes.ref;
        }

        return { ...prevState,
          insertUsage: { ...prevState.insertUsage,
            [id]: {
              time: action.time,
              count: prevState.insertUsage[id] ? prevState.insertUsage[id].count + 1 : 1,
              insert
            }
          }
        };
      }, state);
  }

  return state;
}
/**
 * Reducer returning an object where each key is a block client ID, its value
 * representing the settings for its nested blocks.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */

const blockListSettings = function () {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    // Even if the replaced blocks have the same client ID, our logic
    // should correct the state.
    case 'REPLACE_BLOCKS':
    case 'REMOVE_BLOCKS':
      {
        return (0,external_lodash_namespaceObject.omit)(state, action.clientIds);
      }

    case 'UPDATE_BLOCK_LIST_SETTINGS':
      {
        const {
          clientId
        } = action;

        if (!action.settings) {
          if (state.hasOwnProperty(clientId)) {
            return (0,external_lodash_namespaceObject.omit)(state, clientId);
          }

          return state;
        }

        if ((0,external_lodash_namespaceObject.isEqual)(state[clientId], action.settings)) {
          return state;
        }

        return { ...state,
          [clientId]: action.settings
        };
      }
  }

  return state;
};
/**
 * Reducer returning whether the navigation mode is enabled or not.
 *
 * @param {string} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {string} Updated state.
 */

function isNavigationMode() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  // Let inserting block always trigger Edit mode.
  if (action.type === 'INSERT_BLOCKS') {
    return false;
  }

  if (action.type === 'SET_NAVIGATION_MODE') {
    return action.isNavigationMode;
  }

  return state;
}
/**
 * Reducer returning whether the block moving mode is enabled or not.
 *
 * @param {string|null} state  Current state.
 * @param {Object}      action Dispatched action.
 *
 * @return {string|null} Updated state.
 */

function hasBlockMovingClientId() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  // Let inserting block always trigger Edit mode.
  if (action.type === 'SET_BLOCK_MOVING_MODE') {
    return action.hasBlockMovingClientId;
  }

  if (action.type === 'SET_NAVIGATION_MODE') {
    return null;
  }

  return state;
}
/**
 * Reducer return an updated state representing the most recent block attribute
 * update. The state is structured as an object where the keys represent the
 * client IDs of blocks, the values a subset of attributes from the most recent
 * block update. The state is always reset to null if the last action is
 * anything other than an attributes update.
 *
 * @param {Object<string,Object>} state  Current state.
 * @param {Object}                action Action object.
 *
 * @return {[string,Object]} Updated state.
 */

function lastBlockAttributesChange(state, action) {
  switch (action.type) {
    case 'UPDATE_BLOCK':
      if (!action.updates.attributes) {
        break;
      }

      return {
        [action.clientId]: action.updates.attributes
      };

    case 'UPDATE_BLOCK_ATTRIBUTES':
      return action.clientIds.reduce((accumulator, id) => ({ ...accumulator,
        [id]: action.uniqueByBlock ? action.attributes[id] : action.attributes
      }), {});
  }

  return null;
}
/**
 * Reducer returning automatic change state.
 *
 * @param {boolean} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {string} Updated state.
 */

function automaticChangeStatus(state, action) {
  switch (action.type) {
    case 'MARK_AUTOMATIC_CHANGE':
      return 'pending';

    case 'MARK_AUTOMATIC_CHANGE_FINAL':
      if (state === 'pending') {
        return 'final';
      }

      return;

    case 'SELECTION_CHANGE':
      // As long as the state is not final, ignore any selection changes.
      if (state !== 'final') {
        return state;
      }

      return;
    // Undoing an automatic change should still be possible after mouse
    // move.

    case 'START_TYPING':
    case 'STOP_TYPING':
      return state;
  } // Reset the state by default (for any action not handled).

}
/**
 * Reducer returning current highlighted block.
 *
 * @param {boolean} state  Current highlighted block.
 * @param {Object}  action Dispatched action.
 *
 * @return {string} Updated state.
 */

function highlightedBlock(state, action) {
  switch (action.type) {
    case 'TOGGLE_BLOCK_HIGHLIGHT':
      const {
        clientId,
        isHighlighted
      } = action;

      if (isHighlighted) {
        return clientId;
      } else if (state === clientId) {
        return null;
      }

      return state;

    case 'SELECT_BLOCK':
      if (action.clientId !== state) {
        return null;
      }

  }

  return state;
}
/**
 * Reducer returning the block insertion event list state.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */

function lastBlockInserted() {
  var _action$meta;

  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'INSERT_BLOCKS':
      if (!action.blocks.length) {
        return state;
      }

      const clientId = action.blocks[0].clientId;
      const source = (_action$meta = action.meta) === null || _action$meta === void 0 ? void 0 : _action$meta.source;
      return {
        clientId,
        source
      };

    case 'RESET_BLOCKS':
      return {};
  }

  return state;
}
/* harmony default export */ var reducer = ((0,external_wp_data_namespaceObject.combineReducers)({
  blocks,
  isTyping,
  draggedBlocks,
  isCaretWithinFormattedText,
  selection,
  isMultiSelecting,
  isSelectionEnabled,
  initialPosition,
  blocksMode,
  blockListSettings,
  insertionPoint,
  template,
  settings,
  preferences,
  lastBlockAttributesChange,
  isNavigationMode,
  hasBlockMovingClientId,
  automaticChangeStatus,
  highlightedBlock,
  lastBlockInserted
}));

;// CONCATENATED MODULE: ./node_modules/rememo/es/rememo.js


var LEAF_KEY, hasWeakMap;

/**
 * Arbitrary value used as key for referencing cache object in WeakMap tree.
 *
 * @type {Object}
 */
LEAF_KEY = {};

/**
 * Whether environment supports WeakMap.
 *
 * @type {boolean}
 */
hasWeakMap = typeof WeakMap !== 'undefined';

/**
 * Returns the first argument as the sole entry in an array.
 *
 * @param {*} value Value to return.
 *
 * @return {Array} Value returned as entry in array.
 */
function arrayOf( value ) {
	return [ value ];
}

/**
 * Returns true if the value passed is object-like, or false otherwise. A value
 * is object-like if it can support property assignment, e.g. object or array.
 *
 * @param {*} value Value to test.
 *
 * @return {boolean} Whether value is object-like.
 */
function isObjectLike( value ) {
	return !! value && 'object' === typeof value;
}

/**
 * Creates and returns a new cache object.
 *
 * @return {Object} Cache object.
 */
function createCache() {
	var cache = {
		clear: function() {
			cache.head = null;
		},
	};

	return cache;
}

/**
 * Returns true if entries within the two arrays are strictly equal by
 * reference from a starting index.
 *
 * @param {Array}  a         First array.
 * @param {Array}  b         Second array.
 * @param {number} fromIndex Index from which to start comparison.
 *
 * @return {boolean} Whether arrays are shallowly equal.
 */
function isShallowEqual( a, b, fromIndex ) {
	var i;

	if ( a.length !== b.length ) {
		return false;
	}

	for ( i = fromIndex; i < a.length; i++ ) {
		if ( a[ i ] !== b[ i ] ) {
			return false;
		}
	}

	return true;
}

/**
 * Returns a memoized selector function. The getDependants function argument is
 * called before the memoized selector and is expected to return an immutable
 * reference or array of references on which the selector depends for computing
 * its own return value. The memoize cache is preserved only as long as those
 * dependant references remain the same. If getDependants returns a different
 * reference(s), the cache is cleared and the selector value regenerated.
 *
 * @param {Function} selector      Selector function.
 * @param {Function} getDependants Dependant getter returning an immutable
 *                                 reference or array of reference used in
 *                                 cache bust consideration.
 *
 * @return {Function} Memoized selector.
 */
/* harmony default export */ function rememo(selector, getDependants ) {
	var rootCache, getCache;

	// Use object source as dependant if getter not provided
	if ( ! getDependants ) {
		getDependants = arrayOf;
	}

	/**
	 * Returns the root cache. If WeakMap is supported, this is assigned to the
	 * root WeakMap cache set, otherwise it is a shared instance of the default
	 * cache object.
	 *
	 * @return {(WeakMap|Object)} Root cache object.
	 */
	function getRootCache() {
		return rootCache;
	}

	/**
	 * Returns the cache for a given dependants array. When possible, a WeakMap
	 * will be used to create a unique cache for each set of dependants. This
	 * is feasible due to the nature of WeakMap in allowing garbage collection
	 * to occur on entries where the key object is no longer referenced. Since
	 * WeakMap requires the key to be an object, this is only possible when the
	 * dependant is object-like. The root cache is created as a hierarchy where
	 * each top-level key is the first entry in a dependants set, the value a
	 * WeakMap where each key is the next dependant, and so on. This continues
	 * so long as the dependants are object-like. If no dependants are object-
	 * like, then the cache is shared across all invocations.
	 *
	 * @see isObjectLike
	 *
	 * @param {Array} dependants Selector dependants.
	 *
	 * @return {Object} Cache object.
	 */
	function getWeakMapCache( dependants ) {
		var caches = rootCache,
			isUniqueByDependants = true,
			i, dependant, map, cache;

		for ( i = 0; i < dependants.length; i++ ) {
			dependant = dependants[ i ];

			// Can only compose WeakMap from object-like key.
			if ( ! isObjectLike( dependant ) ) {
				isUniqueByDependants = false;
				break;
			}

			// Does current segment of cache already have a WeakMap?
			if ( caches.has( dependant ) ) {
				// Traverse into nested WeakMap.
				caches = caches.get( dependant );
			} else {
				// Create, set, and traverse into a new one.
				map = new WeakMap();
				caches.set( dependant, map );
				caches = map;
			}
		}

		// We use an arbitrary (but consistent) object as key for the last item
		// in the WeakMap to serve as our running cache.
		if ( ! caches.has( LEAF_KEY ) ) {
			cache = createCache();
			cache.isUniqueByDependants = isUniqueByDependants;
			caches.set( LEAF_KEY, cache );
		}

		return caches.get( LEAF_KEY );
	}

	// Assign cache handler by availability of WeakMap
	getCache = hasWeakMap ? getWeakMapCache : getRootCache;

	/**
	 * Resets root memoization cache.
	 */
	function clear() {
		rootCache = hasWeakMap ? new WeakMap() : createCache();
	}

	// eslint-disable-next-line jsdoc/check-param-names
	/**
	 * The augmented selector call, considering first whether dependants have
	 * changed before passing it to underlying memoize function.
	 *
	 * @param {Object} source    Source object for derivation.
	 * @param {...*}   extraArgs Additional arguments to pass to selector.
	 *
	 * @return {*} Selector result.
	 */
	function callSelector( /* source, ...extraArgs */ ) {
		var len = arguments.length,
			cache, node, i, args, dependants;

		// Create copy of arguments (avoid leaking deoptimization).
		args = new Array( len );
		for ( i = 0; i < len; i++ ) {
			args[ i ] = arguments[ i ];
		}

		dependants = getDependants.apply( null, args );
		cache = getCache( dependants );

		// If not guaranteed uniqueness by dependants (primitive type or lack
		// of WeakMap support), shallow compare against last dependants and, if
		// references have changed, destroy cache to recalculate result.
		if ( ! cache.isUniqueByDependants ) {
			if ( cache.lastDependants && ! isShallowEqual( dependants, cache.lastDependants, 0 ) ) {
				cache.clear();
			}

			cache.lastDependants = dependants;
		}

		node = cache.head;
		while ( node ) {
			// Check whether node arguments match arguments
			if ( ! isShallowEqual( node.args, args, 1 ) ) {
				node = node.next;
				continue;
			}

			// At this point we can assume we've found a match

			// Surface matched node to head if not already
			if ( node !== cache.head ) {
				// Adjust siblings to point to each other.
				node.prev.next = node.next;
				if ( node.next ) {
					node.next.prev = node.prev;
				}

				node.next = cache.head;
				node.prev = null;
				cache.head.prev = node;
				cache.head = node;
			}

			// Return immediately
			return node.val;
		}

		// No cached value found. Continue to insertion phase:

		node = {
			// Generate the result from original function
			val: selector.apply( null, args ),
		};

		// Avoid including the source object in the cache.
		args[ 0 ] = null;
		node.args = args;

		// Don't need to check whether node is already head, since it would
		// have been returned above already if it was

		// Shift existing head down list
		if ( cache.head ) {
			cache.head.prev = node;
			node.next = cache.head;
		}

		cache.head = node;

		return node.val;
	}

	callSelector.getDependants = getDependants;
	callSelector.clear = clear;
	clear();

	return callSelector;
}

;// CONCATENATED MODULE: external ["wp","primitives"]
var external_wp_primitives_namespaceObject = window["wp"]["primitives"];
;// CONCATENATED MODULE: ./packages/icons/build-module/library/symbol.js


/**
 * WordPress dependencies
 */

const symbol = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M21.3 10.8l-5.6-5.6c-.7-.7-1.8-.7-2.5 0l-5.6 5.6c-.7.7-.7 1.8 0 2.5l5.6 5.6c.3.3.8.5 1.2.5s.9-.2 1.2-.5l5.6-5.6c.8-.7.8-1.9.1-2.5zm-1 1.4l-5.6 5.6c-.1.1-.3.1-.4 0l-5.6-5.6c-.1-.1-.1-.3 0-.4l5.6-5.6s.1-.1.2-.1.1 0 .2.1l5.6 5.6c.1.1.1.3 0 .4zm-16.6-.4L10 5.5l-1-1-6.3 6.3c-.7.7-.7 1.8 0 2.5L9 19.5l1.1-1.1-6.3-6.3c-.2 0-.2-.2-.1-.3z"
}));
/* harmony default export */ var library_symbol = (symbol);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/store/selectors.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */





/**
 * A block selection object.
 *
 * @typedef {Object} WPBlockSelection
 *
 * @property {string} clientId     A block client ID.
 * @property {string} attributeKey A block attribute key.
 * @property {number} offset       An attribute value offset, based on the rich
 *                                 text value. See `wp.richText.create`.
 */
// Module constants.

const MILLISECONDS_PER_HOUR = 3600 * 1000;
const MILLISECONDS_PER_DAY = 24 * 3600 * 1000;
const MILLISECONDS_PER_WEEK = 7 * 24 * 3600 * 1000;
/**
 * Shared reference to an empty array for cases where it is important to avoid
 * returning a new array reference on every invocation, as in a connected or
 * other pure component which performs `shouldComponentUpdate` check on props.
 * This should be used as a last resort, since the normalized data should be
 * maintained by the reducer result in state.
 *
 * @type {Array}
 */

const EMPTY_ARRAY = [];
/**
 * Returns a block's name given its client ID, or null if no block exists with
 * the client ID.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {string} Block name.
 */

function getBlockName(state, clientId) {
  const block = state.blocks.byClientId[clientId];
  const socialLinkName = 'core/social-link';

  if (external_wp_element_namespaceObject.Platform.OS !== 'web' && (block === null || block === void 0 ? void 0 : block.name) === socialLinkName) {
    const attributes = state.blocks.attributes[clientId];
    const {
      service
    } = attributes;
    return service ? `${socialLinkName}-${service}` : socialLinkName;
  }

  return block ? block.name : null;
}
/**
 * Returns whether a block is valid or not.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {boolean} Is Valid.
 */

function isBlockValid(state, clientId) {
  const block = state.blocks.byClientId[clientId];
  return !!block && block.isValid;
}
/**
 * Returns a block's attributes given its client ID, or null if no block exists with
 * the client ID.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {Object?} Block attributes.
 */

function getBlockAttributes(state, clientId) {
  const block = state.blocks.byClientId[clientId];

  if (!block) {
    return null;
  }

  return state.blocks.attributes[clientId];
}
/**
 * Returns a block given its client ID. This is a parsed copy of the block,
 * containing its `blockName`, `clientId`, and current `attributes` state. This
 * is not the block's registration settings, which must be retrieved from the
 * blocks module registration store.
 *
 * getBlock recurses through its inner blocks until all its children blocks have
 * been retrieved. Note that getBlock will not return the child inner blocks of
 * an inner block controller. This is because an inner block controller syncs
 * itself with its own entity, and should therefore not be included with the
 * blocks of a different entity. For example, say you call `getBlocks( TP )` to
 * get the blocks of a template part. If another template part is a child of TP,
 * then the nested template part's child blocks will not be returned. This way,
 * the template block itself is considered part of the parent, but the children
 * are not.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {Object} Parsed block object.
 */

function getBlock(state, clientId) {
  const block = state.blocks.byClientId[clientId];

  if (!block) {
    return null;
  }

  return state.blocks.tree[clientId];
}
const __unstableGetBlockWithoutInnerBlocks = rememo((state, clientId) => {
  const block = state.blocks.byClientId[clientId];

  if (!block) {
    return null;
  }

  return { ...block,
    attributes: getBlockAttributes(state, clientId)
  };
}, (state, clientId) => [state.blocks.byClientId[clientId], state.blocks.attributes[clientId]]);
/**
 * Returns all block objects for the current post being edited as an array in
 * the order they appear in the post. Note that this will exclude child blocks
 * of nested inner block controllers.
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {Object[]} Post blocks.
 */

function getBlocks(state, rootClientId) {
  var _state$blocks$tree$tr;

  const treeKey = !rootClientId || !areInnerBlocksControlled(state, rootClientId) ? rootClientId || '' : 'controlled||' + rootClientId;
  return ((_state$blocks$tree$tr = state.blocks.tree[treeKey]) === null || _state$blocks$tree$tr === void 0 ? void 0 : _state$blocks$tree$tr.innerBlocks) || EMPTY_ARRAY;
}
/**
 * Returns a stripped down block object containing only its client ID,
 * and its inner blocks' client IDs.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Client ID of the block to get.
 *
 * @return {Object} Client IDs of the post blocks.
 */

const __unstableGetClientIdWithClientIdsTree = rememo((state, clientId) => ({
  clientId,
  innerBlocks: __unstableGetClientIdsTree(state, clientId)
}), state => [state.blocks.order]);
/**
 * Returns the block tree represented in the block-editor store from the
 * given root, consisting of stripped down block objects containing only
 * their client IDs, and their inner blocks' client IDs.
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {Object[]} Client IDs of the post blocks.
 */

const __unstableGetClientIdsTree = rememo(function (state) {
  let rootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  return (0,external_lodash_namespaceObject.map)(getBlockOrder(state, rootClientId), clientId => __unstableGetClientIdWithClientIdsTree(state, clientId));
}, state => [state.blocks.order]);
/**
 * Returns an array containing the clientIds of all descendants
 * of the blocks given.
 *
 * @param {Object} state     Global application state.
 * @param {Array}  clientIds Array of blocks to inspect.
 *
 * @return {Array} ids of descendants.
 */

const getClientIdsOfDescendants = (state, clientIds) => (0,external_lodash_namespaceObject.flatMap)(clientIds, clientId => {
  const descendants = getBlockOrder(state, clientId);
  return [...descendants, ...getClientIdsOfDescendants(state, descendants)];
});
/**
 * Returns an array containing the clientIds of the top-level blocks
 * and their descendants of any depth (for nested blocks).
 *
 * @param {Object} state Global application state.
 *
 * @return {Array} ids of top-level and descendant blocks.
 */

const getClientIdsWithDescendants = rememo(state => {
  const topLevelIds = getBlockOrder(state);
  return [...topLevelIds, ...getClientIdsOfDescendants(state, topLevelIds)];
}, state => [state.blocks.order]);
/**
 * Returns the total number of blocks, or the total number of blocks with a specific name in a post.
 * The number returned includes nested blocks.
 *
 * @param {Object}  state     Global application state.
 * @param {?string} blockName Optional block name, if specified only blocks of that type will be counted.
 *
 * @return {number} Number of blocks in the post, or number of blocks with name equal to blockName.
 */

const getGlobalBlockCount = rememo((state, blockName) => {
  const clientIds = getClientIdsWithDescendants(state);

  if (!blockName) {
    return clientIds.length;
  }

  return (0,external_lodash_namespaceObject.reduce)(clientIds, (accumulator, clientId) => {
    const block = state.blocks.byClientId[clientId];
    return block.name === blockName ? accumulator + 1 : accumulator;
  }, 0);
}, state => [state.blocks.order, state.blocks.byClientId]);
/**
 * Given an array of block client IDs, returns the corresponding array of block
 * objects.
 *
 * @param {Object}   state     Editor state.
 * @param {string[]} clientIds Client IDs for which blocks are to be returned.
 *
 * @return {WPBlock[]} Block objects.
 */

const getBlocksByClientId = rememo((state, clientIds) => (0,external_lodash_namespaceObject.map)((0,external_lodash_namespaceObject.castArray)(clientIds), clientId => getBlock(state, clientId)), (state, clientIds) => (0,external_lodash_namespaceObject.map)((0,external_lodash_namespaceObject.castArray)(clientIds), clientId => state.blocks.tree[clientId]));
/**
 * Returns the number of blocks currently present in the post.
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {number} Number of blocks in the post.
 */

function getBlockCount(state, rootClientId) {
  return getBlockOrder(state, rootClientId).length;
}
/**
 * Returns the current selection start block client ID, attribute key and text
 * offset.
 *
 * @param {Object} state Block editor state.
 *
 * @return {WPBlockSelection} Selection start information.
 */

function getSelectionStart(state) {
  return state.selection.selectionStart;
}
/**
 * Returns the current selection end block client ID, attribute key and text
 * offset.
 *
 * @param {Object} state Block editor state.
 *
 * @return {WPBlockSelection} Selection end information.
 */

function getSelectionEnd(state) {
  return state.selection.selectionEnd;
}
/**
 * Returns the current block selection start. This value may be null, and it
 * may represent either a singular block selection or multi-selection start.
 * A selection is singular if its start and end match.
 *
 * @param {Object} state Global application state.
 *
 * @return {?string} Client ID of block selection start.
 */

function getBlockSelectionStart(state) {
  return state.selection.selectionStart.clientId;
}
/**
 * Returns the current block selection end. This value may be null, and it
 * may represent either a singular block selection or multi-selection end.
 * A selection is singular if its start and end match.
 *
 * @param {Object} state Global application state.
 *
 * @return {?string} Client ID of block selection end.
 */

function getBlockSelectionEnd(state) {
  return state.selection.selectionEnd.clientId;
}
/**
 * Returns the number of blocks currently selected in the post.
 *
 * @param {Object} state Global application state.
 *
 * @return {number} Number of blocks selected in the post.
 */

function getSelectedBlockCount(state) {
  const multiSelectedBlockCount = getMultiSelectedBlockClientIds(state).length;

  if (multiSelectedBlockCount) {
    return multiSelectedBlockCount;
  }

  return state.selection.selectionStart.clientId ? 1 : 0;
}
/**
 * Returns true if there is a single selected block, or false otherwise.
 *
 * @param {Object} state Editor state.
 *
 * @return {boolean} Whether a single block is selected.
 */

function hasSelectedBlock(state) {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;
  return !!selectionStart.clientId && selectionStart.clientId === selectionEnd.clientId;
}
/**
 * Returns the currently selected block client ID, or null if there is no
 * selected block.
 *
 * @param {Object} state Editor state.
 *
 * @return {?string} Selected block client ID.
 */

function getSelectedBlockClientId(state) {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;
  const {
    clientId
  } = selectionStart;

  if (!clientId || clientId !== selectionEnd.clientId) {
    return null;
  }

  return clientId;
}
/**
 * Returns the currently selected block, or null if there is no selected block.
 *
 * @param {Object} state Global application state.
 *
 * @return {?Object} Selected block.
 */

function getSelectedBlock(state) {
  const clientId = getSelectedBlockClientId(state);
  return clientId ? getBlock(state, clientId) : null;
}
/**
 * Given a block client ID, returns the root block from which the block is
 * nested, an empty string for top-level blocks, or null if the block does not
 * exist.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block from which to find root client ID.
 *
 * @return {?string} Root client ID, if exists
 */

function getBlockRootClientId(state, clientId) {
  return state.blocks.parents[clientId] !== undefined ? state.blocks.parents[clientId] : null;
}
/**
 * Given a block client ID, returns the list of all its parents from top to bottom.
 *
 * @param {Object}  state     Editor state.
 * @param {string}  clientId  Block from which to find root client ID.
 * @param {boolean} ascending Order results from bottom to top (true) or top to bottom (false).
 *
 * @return {Array} ClientIDs of the parent blocks.
 */

const getBlockParents = rememo(function (state, clientId) {
  let ascending = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  const parents = [];
  let current = clientId;

  while (!!state.blocks.parents[current]) {
    current = state.blocks.parents[current];
    parents.push(current);
  }

  return ascending ? parents : parents.reverse();
}, state => [state.blocks.parents]);
/**
 * Given a block client ID and a block name, returns the list of all its parents
 * from top to bottom, filtered by the given name(s). For example, if passed
 * 'core/group' as the blockName, it will only return parents which are group
 * blocks. If passed `[ 'core/group', 'core/cover']`, as the blockName, it will
 * return parents which are group blocks and parents which are cover blocks.
 *
 * @param {Object}          state     Editor state.
 * @param {string}          clientId  Block from which to find root client ID.
 * @param {string|string[]} blockName Block name(s) to filter.
 * @param {boolean}         ascending Order results from bottom to top (true) or top to bottom (false).
 *
 * @return {Array} ClientIDs of the parent blocks.
 */

const getBlockParentsByBlockName = rememo(function (state, clientId, blockName) {
  let ascending = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
  const parents = getBlockParents(state, clientId, ascending);
  return (0,external_lodash_namespaceObject.map)((0,external_lodash_namespaceObject.filter)((0,external_lodash_namespaceObject.map)(parents, id => ({
    id,
    name: getBlockName(state, id)
  })), _ref => {
    let {
      name
    } = _ref;

    if (Array.isArray(blockName)) {
      return blockName.includes(name);
    }

    return name === blockName;
  }), _ref2 => {
    let {
      id
    } = _ref2;
    return id;
  });
}, state => [state.blocks.parents]);
/**
 * Given a block client ID, returns the root of the hierarchy from which the block is nested, return the block itself for root level blocks.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block from which to find root client ID.
 *
 * @return {string} Root client ID
 */

function getBlockHierarchyRootClientId(state, clientId) {
  let current = clientId;
  let parent;

  do {
    parent = current;
    current = state.blocks.parents[current];
  } while (current);

  return parent;
}
/**
 * Given a block client ID, returns the lowest common ancestor with selected client ID.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block from which to find common ancestor client ID.
 *
 * @return {string} Common ancestor client ID or undefined
 */

function getLowestCommonAncestorWithSelectedBlock(state, clientId) {
  const selectedId = getSelectedBlockClientId(state);
  const clientParents = [...getBlockParents(state, clientId), clientId];
  const selectedParents = [...getBlockParents(state, selectedId), selectedId];
  let lowestCommonAncestor;
  const maxDepth = Math.min(clientParents.length, selectedParents.length);

  for (let index = 0; index < maxDepth; index++) {
    if (clientParents[index] === selectedParents[index]) {
      lowestCommonAncestor = clientParents[index];
    } else {
      break;
    }
  }

  return lowestCommonAncestor;
}
/**
 * Returns the client ID of the block adjacent one at the given reference
 * startClientId and modifier directionality. Defaults start startClientId to
 * the selected block, and direction as next block. Returns null if there is no
 * adjacent block.
 *
 * @param {Object}  state         Editor state.
 * @param {?string} startClientId Optional client ID of block from which to
 *                                search.
 * @param {?number} modifier      Directionality multiplier (1 next, -1
 *                                previous).
 *
 * @return {?string} Return the client ID of the block, or null if none exists.
 */

function getAdjacentBlockClientId(state, startClientId) {
  let modifier = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1;

  // Default to selected block.
  if (startClientId === undefined) {
    startClientId = getSelectedBlockClientId(state);
  } // Try multi-selection starting at extent based on modifier.


  if (startClientId === undefined) {
    if (modifier < 0) {
      startClientId = getFirstMultiSelectedBlockClientId(state);
    } else {
      startClientId = getLastMultiSelectedBlockClientId(state);
    }
  } // Validate working start client ID.


  if (!startClientId) {
    return null;
  } // Retrieve start block root client ID, being careful to allow the falsey
  // empty string top-level root by explicitly testing against null.


  const rootClientId = getBlockRootClientId(state, startClientId);

  if (rootClientId === null) {
    return null;
  }

  const {
    order
  } = state.blocks;
  const orderSet = order[rootClientId];
  const index = orderSet.indexOf(startClientId);
  const nextIndex = index + 1 * modifier; // Block was first in set and we're attempting to get previous.

  if (nextIndex < 0) {
    return null;
  } // Block was last in set and we're attempting to get next.


  if (nextIndex === orderSet.length) {
    return null;
  } // Assume incremented index is within the set.


  return orderSet[nextIndex];
}
/**
 * Returns the previous block's client ID from the given reference start ID.
 * Defaults start to the selected block. Returns null if there is no previous
 * block.
 *
 * @param {Object}  state         Editor state.
 * @param {?string} startClientId Optional client ID of block from which to
 *                                search.
 *
 * @return {?string} Adjacent block's client ID, or null if none exists.
 */

function getPreviousBlockClientId(state, startClientId) {
  return getAdjacentBlockClientId(state, startClientId, -1);
}
/**
 * Returns the next block's client ID from the given reference start ID.
 * Defaults start to the selected block. Returns null if there is no next
 * block.
 *
 * @param {Object}  state         Editor state.
 * @param {?string} startClientId Optional client ID of block from which to
 *                                search.
 *
 * @return {?string} Adjacent block's client ID, or null if none exists.
 */

function getNextBlockClientId(state, startClientId) {
  return getAdjacentBlockClientId(state, startClientId, 1);
}
/* eslint-disable jsdoc/valid-types */

/**
 * Returns the initial caret position for the selected block.
 * This position is to used to position the caret properly when the selected block changes.
 * If the current block is not a RichText, having initial position set to 0 means "focus block"
 *
 * @param {Object} state Global application state.
 *
 * @return {0|-1|null} Initial position.
 */

function getSelectedBlocksInitialCaretPosition(state) {
  /* eslint-enable jsdoc/valid-types */
  return state.initialPosition;
}
/**
 * Returns the current selection set of block client IDs (multiselection or single selection).
 *
 * @param {Object} state Editor state.
 *
 * @return {Array} Multi-selected block client IDs.
 */

const getSelectedBlockClientIds = rememo(state => {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;

  if (selectionStart.clientId === undefined || selectionEnd.clientId === undefined) {
    return EMPTY_ARRAY;
  }

  if (selectionStart.clientId === selectionEnd.clientId) {
    return [selectionStart.clientId];
  } // Retrieve root client ID to aid in retrieving relevant nested block
  // order, being careful to allow the falsey empty string top-level root
  // by explicitly testing against null.


  const rootClientId = getBlockRootClientId(state, selectionStart.clientId);

  if (rootClientId === null) {
    return EMPTY_ARRAY;
  }

  const blockOrder = getBlockOrder(state, rootClientId);
  const startIndex = blockOrder.indexOf(selectionStart.clientId);
  const endIndex = blockOrder.indexOf(selectionEnd.clientId);

  if (startIndex > endIndex) {
    return blockOrder.slice(endIndex, startIndex + 1);
  }

  return blockOrder.slice(startIndex, endIndex + 1);
}, state => [state.blocks.order, state.selection.selectionStart.clientId, state.selection.selectionEnd.clientId]);
/**
 * Returns the current multi-selection set of block client IDs, or an empty
 * array if there is no multi-selection.
 *
 * @param {Object} state Editor state.
 *
 * @return {Array} Multi-selected block client IDs.
 */

function getMultiSelectedBlockClientIds(state) {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;

  if (selectionStart.clientId === selectionEnd.clientId) {
    return EMPTY_ARRAY;
  }

  return getSelectedBlockClientIds(state);
}
/**
 * Returns the current multi-selection set of blocks, or an empty array if
 * there is no multi-selection.
 *
 * @param {Object} state Editor state.
 *
 * @return {Array} Multi-selected block objects.
 */

const getMultiSelectedBlocks = rememo(state => {
  const multiSelectedBlockClientIds = getMultiSelectedBlockClientIds(state);

  if (!multiSelectedBlockClientIds.length) {
    return EMPTY_ARRAY;
  }

  return multiSelectedBlockClientIds.map(clientId => getBlock(state, clientId));
}, state => [...getSelectedBlockClientIds.getDependants(state), state.blocks.byClientId, state.blocks.order, state.blocks.attributes]);
/**
 * Returns the client ID of the first block in the multi-selection set, or null
 * if there is no multi-selection.
 *
 * @param {Object} state Editor state.
 *
 * @return {?string} First block client ID in the multi-selection set.
 */

function getFirstMultiSelectedBlockClientId(state) {
  return (0,external_lodash_namespaceObject.first)(getMultiSelectedBlockClientIds(state)) || null;
}
/**
 * Returns the client ID of the last block in the multi-selection set, or null
 * if there is no multi-selection.
 *
 * @param {Object} state Editor state.
 *
 * @return {?string} Last block client ID in the multi-selection set.
 */

function getLastMultiSelectedBlockClientId(state) {
  return (0,external_lodash_namespaceObject.last)(getMultiSelectedBlockClientIds(state)) || null;
}
/**
 * Returns true if a multi-selection exists, and the block corresponding to the
 * specified client ID is the first block of the multi-selection set, or false
 * otherwise.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {boolean} Whether block is first in multi-selection.
 */

function isFirstMultiSelectedBlock(state, clientId) {
  return getFirstMultiSelectedBlockClientId(state) === clientId;
}
/**
 * Returns true if the client ID occurs within the block multi-selection, or
 * false otherwise.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {boolean} Whether block is in multi-selection set.
 */

function isBlockMultiSelected(state, clientId) {
  return getMultiSelectedBlockClientIds(state).indexOf(clientId) !== -1;
}
/**
 * Returns true if an ancestor of the block is multi-selected, or false
 * otherwise.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {boolean} Whether an ancestor of the block is in multi-selection
 *                   set.
 */

const isAncestorMultiSelected = rememo((state, clientId) => {
  let ancestorClientId = clientId;
  let isMultiSelected = false;

  while (ancestorClientId && !isMultiSelected) {
    ancestorClientId = getBlockRootClientId(state, ancestorClientId);
    isMultiSelected = isBlockMultiSelected(state, ancestorClientId);
  }

  return isMultiSelected;
}, state => [state.blocks.order, state.selection.selectionStart.clientId, state.selection.selectionEnd.clientId]);
/**
 * Returns the client ID of the block which begins the multi-selection set, or
 * null if there is no multi-selection.
 *
 * This is not necessarily the first client ID in the selection.
 *
 * @see getFirstMultiSelectedBlockClientId
 *
 * @param {Object} state Editor state.
 *
 * @return {?string} Client ID of block beginning multi-selection.
 */

function getMultiSelectedBlocksStartClientId(state) {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;

  if (selectionStart.clientId === selectionEnd.clientId) {
    return null;
  }

  return selectionStart.clientId || null;
}
/**
 * Returns the client ID of the block which ends the multi-selection set, or
 * null if there is no multi-selection.
 *
 * This is not necessarily the last client ID in the selection.
 *
 * @see getLastMultiSelectedBlockClientId
 *
 * @param {Object} state Editor state.
 *
 * @return {?string} Client ID of block ending multi-selection.
 */

function getMultiSelectedBlocksEndClientId(state) {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;

  if (selectionStart.clientId === selectionEnd.clientId) {
    return null;
  }

  return selectionEnd.clientId || null;
}
/**
 * Returns an array containing all block client IDs in the editor in the order
 * they appear. Optionally accepts a root client ID of the block list for which
 * the order should be returned, defaulting to the top-level block order.
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {Array} Ordered client IDs of editor blocks.
 */

function getBlockOrder(state, rootClientId) {
  return state.blocks.order[rootClientId || ''] || EMPTY_ARRAY;
}
/**
 * Returns the index at which the block corresponding to the specified client
 * ID occurs within the block order, or `-1` if the block does not exist.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {number} Index at which block exists in order.
 */

function getBlockIndex(state, clientId) {
  const rootClientId = getBlockRootClientId(state, clientId);
  return getBlockOrder(state, rootClientId).indexOf(clientId);
}
/**
 * Returns true if the block corresponding to the specified client ID is
 * currently selected and no multi-selection exists, or false otherwise.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {boolean} Whether block is selected and multi-selection exists.
 */

function isBlockSelected(state, clientId) {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;

  if (selectionStart.clientId !== selectionEnd.clientId) {
    return false;
  }

  return selectionStart.clientId === clientId;
}
/**
 * Returns true if one of the block's inner blocks is selected.
 *
 * @param {Object}  state    Editor state.
 * @param {string}  clientId Block client ID.
 * @param {boolean} deep     Perform a deep check.
 *
 * @return {boolean} Whether the block as an inner block selected
 */

function hasSelectedInnerBlock(state, clientId) {
  let deep = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  return (0,external_lodash_namespaceObject.some)(getBlockOrder(state, clientId), innerClientId => isBlockSelected(state, innerClientId) || isBlockMultiSelected(state, innerClientId) || deep && hasSelectedInnerBlock(state, innerClientId, deep));
}
/**
 * Returns true if the block corresponding to the specified client ID is
 * currently selected but isn't the last of the selected blocks. Here "last"
 * refers to the block sequence in the document, _not_ the sequence of
 * multi-selection, which is why `state.selectionEnd` isn't used.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {boolean} Whether block is selected and not the last in the
 *                   selection.
 */

function isBlockWithinSelection(state, clientId) {
  if (!clientId) {
    return false;
  }

  const clientIds = getMultiSelectedBlockClientIds(state);
  const index = clientIds.indexOf(clientId);
  return index > -1 && index < clientIds.length - 1;
}
/**
 * Returns true if a multi-selection has been made, or false otherwise.
 *
 * @param {Object} state Editor state.
 *
 * @return {boolean} Whether multi-selection has been made.
 */

function hasMultiSelection(state) {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;
  return selectionStart.clientId !== selectionEnd.clientId;
}
/**
 * Whether in the process of multi-selecting or not. This flag is only true
 * while the multi-selection is being selected (by mouse move), and is false
 * once the multi-selection has been settled.
 *
 * @see hasMultiSelection
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} True if multi-selecting, false if not.
 */

function selectors_isMultiSelecting(state) {
  return state.isMultiSelecting;
}
/**
 * Selector that returns if multi-selection is enabled or not.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} True if it should be possible to multi-select blocks, false if multi-selection is disabled.
 */

function selectors_isSelectionEnabled(state) {
  return state.isSelectionEnabled;
}
/**
 * Returns the block's editing mode, defaulting to "visual" if not explicitly
 * assigned.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {Object} Block editing mode.
 */

function getBlockMode(state, clientId) {
  return state.blocksMode[clientId] || 'visual';
}
/**
 * Returns true if the user is typing, or false otherwise.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether user is typing.
 */

function selectors_isTyping(state) {
  return state.isTyping;
}
/**
 * Returns true if the user is dragging blocks, or false otherwise.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether user is dragging blocks.
 */

function isDraggingBlocks(state) {
  return !!state.draggedBlocks.length;
}
/**
 * Returns the client ids of any blocks being directly dragged.
 *
 * This does not include children of a parent being dragged.
 *
 * @param {Object} state Global application state.
 *
 * @return {string[]} Array of dragged block client ids.
 */

function getDraggedBlockClientIds(state) {
  return state.draggedBlocks;
}
/**
 * Returns whether the block is being dragged.
 *
 * Only returns true if the block is being directly dragged,
 * not if the block is a child of a parent being dragged.
 * See `isAncestorBeingDragged` for child blocks.
 *
 * @param {Object} state    Global application state.
 * @param {string} clientId Client id for block to check.
 *
 * @return {boolean} Whether the block is being dragged.
 */

function isBlockBeingDragged(state, clientId) {
  return state.draggedBlocks.includes(clientId);
}
/**
 * Returns whether a parent/ancestor of the block is being dragged.
 *
 * @param {Object} state    Global application state.
 * @param {string} clientId Client id for block to check.
 *
 * @return {boolean} Whether the block's ancestor is being dragged.
 */

function isAncestorBeingDragged(state, clientId) {
  // Return early if no blocks are being dragged rather than
  // the more expensive check for parents.
  if (!isDraggingBlocks(state)) {
    return false;
  }

  const parents = getBlockParents(state, clientId);
  return (0,external_lodash_namespaceObject.some)(parents, parentClientId => isBlockBeingDragged(state, parentClientId));
}
/**
 * Returns true if the caret is within formatted text, or false otherwise.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether the caret is within formatted text.
 */

function selectors_isCaretWithinFormattedText(state) {
  return state.isCaretWithinFormattedText;
}
/**
 * Returns the insertion point, the index at which the new inserted block would
 * be placed. Defaults to the last index.
 *
 * @param {Object} state Editor state.
 *
 * @return {Object} Insertion point object with `rootClientId`, `index`.
 */

function getBlockInsertionPoint(state) {
  let rootClientId, index;
  const {
    insertionPoint,
    selection: {
      selectionEnd
    }
  } = state;

  if (insertionPoint !== null) {
    return insertionPoint;
  }

  const {
    clientId
  } = selectionEnd;

  if (clientId) {
    rootClientId = getBlockRootClientId(state, clientId) || undefined;
    index = getBlockIndex(state, selectionEnd.clientId, rootClientId) + 1;
  } else {
    index = getBlockOrder(state).length;
  }

  return {
    rootClientId,
    index
  };
}
/**
 * Returns true if we should show the block insertion point.
 *
 * @param {Object} state Global application state.
 *
 * @return {?boolean} Whether the insertion point is visible or not.
 */

function isBlockInsertionPointVisible(state) {
  return state.insertionPoint !== null;
}
/**
 * Returns whether the blocks matches the template or not.
 *
 * @param {boolean} state
 * @return {?boolean} Whether the template is valid or not.
 */

function isValidTemplate(state) {
  return state.template.isValid;
}
/**
 * Returns the defined block template
 *
 * @param {boolean} state
 *
 * @return {?Array} Block Template.
 */

function getTemplate(state) {
  return state.settings.template;
}
/**
 * Returns the defined block template lock. Optionally accepts a root block
 * client ID as context, otherwise defaulting to the global context.
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional block root client ID.
 *
 * @return {?string} Block Template Lock
 */

function getTemplateLock(state, rootClientId) {
  if (!rootClientId) {
    return state.settings.templateLock;
  }

  const blockListSettings = getBlockListSettings(state, rootClientId);

  if (!blockListSettings) {
    return null;
  }

  return blockListSettings.templateLock;
}

const checkAllowList = function (list, item) {
  let defaultResult = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

  if ((0,external_lodash_namespaceObject.isBoolean)(list)) {
    return list;
  }

  if ((0,external_lodash_namespaceObject.isArray)(list)) {
    // TODO: when there is a canonical way to detect that we are editing a post
    // the following check should be changed to something like:
    // if ( list.includes( 'core/post-content' ) && getEditorMode() === 'post-content' && item === null )
    if (list.includes('core/post-content') && item === null) {
      return true;
    }

    return list.includes(item);
  }

  return defaultResult;
};
/**
 * Determines if the given block type is allowed to be inserted into the block list.
 * This function is not exported and not memoized because using a memoized selector
 * inside another memoized selector is just a waste of time.
 *
 * @param {Object}        state        Editor state.
 * @param {string|Object} blockName    The block type object, e.g., the response
 *                                     from the block directory; or a string name of
 *                                     an installed block type, e.g.' core/paragraph'.
 * @param {?string}       rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Whether the given block type is allowed to be inserted.
 */


const canInsertBlockTypeUnmemoized = function (state, blockName) {
  let rootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  let blockType;

  if (blockName && 'object' === typeof blockName) {
    blockType = blockName;
    blockName = blockType.name;
  } else {
    blockType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockName);
  }

  if (!blockType) {
    return false;
  }

  const {
    allowedBlockTypes
  } = getSettings(state);
  const isBlockAllowedInEditor = checkAllowList(allowedBlockTypes, blockName, true);

  if (!isBlockAllowedInEditor) {
    return false;
  }

  const isLocked = !!getTemplateLock(state, rootClientId);

  if (isLocked) {
    return false;
  }

  const parentBlockListSettings = getBlockListSettings(state, rootClientId); // The parent block doesn't have settings indicating it doesn't support
  // inner blocks, return false.

  if (rootClientId && parentBlockListSettings === undefined) {
    return false;
  }

  const parentAllowedBlocks = parentBlockListSettings === null || parentBlockListSettings === void 0 ? void 0 : parentBlockListSettings.allowedBlocks;
  const hasParentAllowedBlock = checkAllowList(parentAllowedBlocks, blockName);
  const blockAllowedParentBlocks = blockType.parent;
  const parentName = getBlockName(state, rootClientId);
  const hasBlockAllowedParent = checkAllowList(blockAllowedParentBlocks, parentName);
  const canInsert = hasParentAllowedBlock === null && hasBlockAllowedParent === null || hasParentAllowedBlock === true || hasBlockAllowedParent === true;

  if (!canInsert) {
    return canInsert;
  }
  /**
   * This filter is an ad-hoc solution to prevent adding template parts inside post content.
   * Conceptually, having a filter inside a selector is bad pattern so this code will be
   * replaced by a declarative API that doesn't the following drawbacks:
   *
   * Filters are not reactive: Upon switching between "template mode" and non "template mode",
   * the filter and selector won't necessarily be executed again. For now, it doesn't matter much
   * because you can't switch between the two modes while the inserter stays open.
   *
   * Filters are global: Once they're defined, they will affect all editor instances and all registries.
   * An ideal API would only affect specific editor instances.
   */


  return (0,external_wp_hooks_namespaceObject.applyFilters)('blockEditor.__unstableCanInsertBlockType', canInsert, blockType, rootClientId, {
    // Pass bound selectors of the current registry. If we're in a nested
    // context, the data will differ from the one selected from the root
    // registry.
    getBlock: getBlock.bind(null, state),
    getBlockParentsByBlockName: getBlockParentsByBlockName.bind(null, state)
  });
};
/**
 * Determines if the given block type is allowed to be inserted into the block list.
 *
 * @param {Object}  state        Editor state.
 * @param {string}  blockName    The name of the block type, e.g.' core/paragraph'.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Whether the given block type is allowed to be inserted.
 */


const canInsertBlockType = rememo(canInsertBlockTypeUnmemoized, (state, blockName, rootClientId) => [state.blockListSettings[rootClientId], state.blocks.byClientId[rootClientId], state.settings.allowedBlockTypes, state.settings.templateLock]);
/**
 * Determines if the given blocks are allowed to be inserted into the block
 * list.
 *
 * @param {Object}  state        Editor state.
 * @param {string}  clientIds    The block client IDs to be inserted.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Whether the given blocks are allowed to be inserted.
 */

function canInsertBlocks(state, clientIds) {
  let rootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  return clientIds.every(id => canInsertBlockType(state, getBlockName(state, id), rootClientId));
}
/**
 * Determines if the given block is allowed to be deleted.
 *
 * @param {Object}  state        Editor state.
 * @param {string}  clientId     The block client Id.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Whether the given block is allowed to be removed.
 */

function canRemoveBlock(state, clientId) {
  let rootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  const attributes = getBlockAttributes(state, clientId); // attributes can be null if the block is already deleted.

  if (attributes === null) {
    return true;
  }

  const {
    lock
  } = attributes;
  const parentIsLocked = !!getTemplateLock(state, rootClientId); // If we don't have a lock on the blockType level, we differ to the parent templateLock.

  if (lock === undefined || (lock === null || lock === void 0 ? void 0 : lock.remove) === undefined) {
    return !parentIsLocked;
  } // When remove is true, it means we cannot remove it.


  return !(lock !== null && lock !== void 0 && lock.remove);
}
/**
 * Determines if the given blocks are allowed to be removed.
 *
 * @param {Object}  state        Editor state.
 * @param {string}  clientIds    The block client IDs to be removed.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Whether the given blocks are allowed to be removed.
 */

function canRemoveBlocks(state, clientIds) {
  let rootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  return clientIds.every(clientId => canRemoveBlock(state, clientId, rootClientId));
}
/**
 * Determines if the given block is allowed to be moved.
 *
 * @param {Object}  state        Editor state.
 * @param {string}  clientId     The block client Id.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Whether the given block is allowed to be moved.
 */

function canMoveBlock(state, clientId) {
  let rootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  const attributes = getBlockAttributes(state, clientId);

  if (attributes === null) {
    return;
  }

  const {
    lock
  } = attributes;
  const parentIsLocked = getTemplateLock(state, rootClientId) === 'all'; // If we don't have a lock on the blockType level, we differ to the parent templateLock.

  if (lock === undefined || (lock === null || lock === void 0 ? void 0 : lock.move) === undefined) {
    return !parentIsLocked;
  } // When move is true, it means we cannot move it.


  return !(lock !== null && lock !== void 0 && lock.move);
}
/**
 * Determines if the given blocks are allowed to be moved.
 *
 * @param {Object}  state        Editor state.
 * @param {string}  clientIds    The block client IDs to be moved.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Whether the given blocks are allowed to be moved.
 */

function canMoveBlocks(state, clientIds) {
  let rootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  return clientIds.every(clientId => canMoveBlock(state, clientId, rootClientId));
}
/**
 * Returns information about how recently and frequently a block has been inserted.
 *
 * @param {Object} state Global application state.
 * @param {string} id    A string which identifies the insert, e.g. 'core/block/12'
 *
 * @return {?{ time: number, count: number }} An object containing `time` which is when the last
 *                                            insert occurred as a UNIX epoch, and `count` which is
 *                                            the number of inserts that have occurred.
 */

function getInsertUsage(state, id) {
  var _state$preferences$in, _state$preferences$in2;

  return (_state$preferences$in = (_state$preferences$in2 = state.preferences.insertUsage) === null || _state$preferences$in2 === void 0 ? void 0 : _state$preferences$in2[id]) !== null && _state$preferences$in !== void 0 ? _state$preferences$in : null;
}
/**
 * Returns whether we can show a block type in the inserter
 *
 * @param {Object}  state        Global State
 * @param {Object}  blockType    BlockType
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Whether the given block type is allowed to be shown in the inserter.
 */


const canIncludeBlockTypeInInserter = (state, blockType, rootClientId) => {
  if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, 'inserter', true)) {
    return false;
  }

  return canInsertBlockTypeUnmemoized(state, blockType.name, rootClientId);
};
/**
 * Return a function to be used to tranform a block variation to an inserter item
 *
 * @param {Object} state Global State
 * @param {Object} item  Denormalized inserter item
 * @return {Function} Function to transform a block variation to inserter item
 */


const getItemFromVariation = (state, item) => variation => {
  const variationId = `${item.id}/${variation.name}`;
  const {
    time,
    count = 0
  } = getInsertUsage(state, variationId) || {};
  return { ...item,
    id: variationId,
    icon: variation.icon || item.icon,
    title: variation.title || item.title,
    description: variation.description || item.description,
    category: variation.category || item.category,
    // If `example` is explicitly undefined for the variation, the preview will not be shown.
    example: variation.hasOwnProperty('example') ? variation.example : item.example,
    initialAttributes: { ...item.initialAttributes,
      ...variation.attributes
    },
    innerBlocks: variation.innerBlocks,
    keywords: variation.keywords || item.keywords,
    frecency: calculateFrecency(time, count)
  };
};
/**
 * Returns the calculated frecency.
 *
 * 'frecency' is a heuristic (https://en.wikipedia.org/wiki/Frecency)
 * that combines block usage frequenty and recency.
 *
 * @param {number} time  When the last insert occurred as a UNIX epoch
 * @param {number} count The number of inserts that have occurred.
 *
 * @return {number} The calculated frecency.
 */


const calculateFrecency = (time, count) => {
  if (!time) {
    return count;
  } // The selector is cached, which means Date.now() is the last time that the
  // relevant state changed. This suits our needs.


  const duration = Date.now() - time;

  switch (true) {
    case duration < MILLISECONDS_PER_HOUR:
      return count * 4;

    case duration < MILLISECONDS_PER_DAY:
      return count * 2;

    case duration < MILLISECONDS_PER_WEEK:
      return count / 2;

    default:
      return count / 4;
  }
};
/**
 * Returns a function that accepts a block type and builds an item to be shown
 * in a specific context. It's used for building items for Inserter and available
 * block Transfroms list.
 *
 * @param {Object} state              Editor state.
 * @param {Object} options            Options object for handling the building of a block type.
 * @param {string} options.buildScope The scope for which the item is going to be used.
 * @return {Function} Function returns an item to be shown in a specific context (Inserter|Transforms list).
 */


const buildBlockTypeItem = (state, _ref3) => {
  let {
    buildScope = 'inserter'
  } = _ref3;
  return blockType => {
    const id = blockType.name;
    let isDisabled = false;

    if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType.name, 'multiple', true)) {
      isDisabled = (0,external_lodash_namespaceObject.some)(getBlocksByClientId(state, getClientIdsWithDescendants(state)), {
        name: blockType.name
      });
    }

    const {
      time,
      count = 0
    } = getInsertUsage(state, id) || {};
    const blockItemBase = {
      id,
      name: blockType.name,
      title: blockType.title,
      icon: blockType.icon,
      isDisabled,
      frecency: calculateFrecency(time, count)
    };
    if (buildScope === 'transform') return blockItemBase;
    const inserterVariations = (0,external_wp_blocks_namespaceObject.getBlockVariations)(blockType.name, 'inserter');
    return { ...blockItemBase,
      initialAttributes: {},
      description: blockType.description,
      category: blockType.category,
      keywords: blockType.keywords,
      variations: inserterVariations,
      example: blockType.example,
      utility: 1 // Deprecated.

    };
  };
};
/**
 * Determines the items that appear in the inserter. Includes both static
 * items (e.g. a regular block type) and dynamic items (e.g. a reusable block).
 *
 * Each item object contains what's necessary to display a button in the
 * inserter and handle its selection.
 *
 * The 'frecency' property is a heuristic (https://en.wikipedia.org/wiki/Frecency)
 * that combines block usage frequenty and recency.
 *
 * Items are returned ordered descendingly by their 'utility' and 'frecency'.
 *
 * @param    {Object}   state             Editor state.
 * @param    {?string}  rootClientId      Optional root client ID of block list.
 *
 * @return {WPEditorInserterItem[]} Items that appear in inserter.
 *
 * @typedef {Object} WPEditorInserterItem
 * @property {string}   id                Unique identifier for the item.
 * @property {string}   name              The type of block to create.
 * @property {Object}   initialAttributes Attributes to pass to the newly created block.
 * @property {string}   title             Title of the item, as it appears in the inserter.
 * @property {string}   icon              Dashicon for the item, as it appears in the inserter.
 * @property {string}   category          Block category that the item is associated with.
 * @property {string[]} keywords          Keywords that can be searched to find this item.
 * @property {boolean}  isDisabled        Whether or not the user should be prevented from inserting
 *                                        this item.
 * @property {number}   frecency          Heuristic that combines frequency and recency.
 */


const getInserterItems = rememo(function (state) {
  let rootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
  const buildBlockTypeInserterItem = buildBlockTypeItem(state, {
    buildScope: 'inserter'
  });
  /*
   * Matches block comment delimiters amid serialized content.
   *
   * @see `tokenizer` in `@wordpress/block-serialization-default-parser`
   * package
   *
   * blockParserTokenizer differs from the original tokenizer in the
   * following ways:
   *
   * - removed global flag (/g)
   * - prepended ^\s*
   *
   */

  const blockParserTokenizer = /^\s*<!--\s+(\/)?wp:([a-z][a-z0-9_-]*\/)?([a-z][a-z0-9_-]*)\s+({(?:(?=([^}]+|}+(?=})|(?!}\s+\/?-->)[^])*)\5|[^]*?)}\s+)?(\/)?-->/;

  const buildReusableBlockInserterItem = reusableBlock => {
    let icon = library_symbol;
    /*
     * Instead of always displaying a generic "symbol" icon for every
     * reusable block, try to use an icon that represents the first
     * outermost block contained in the reusable block. This requires
     * scanning the serialized form of the reusable block to find its
     * first block delimiter, then looking up the corresponding block
     * type, if available.
     */

    if (external_wp_element_namespaceObject.Platform.OS === 'web') {
      const content = typeof reusableBlock.content.raw === 'string' ? reusableBlock.content.raw : reusableBlock.content;
      const rawBlockMatch = content.match(blockParserTokenizer);

      if (rawBlockMatch) {
        const [,, namespace = 'core/', blockName] = rawBlockMatch;
        const referencedBlockType = (0,external_wp_blocks_namespaceObject.getBlockType)(namespace + blockName);

        if (referencedBlockType) {
          icon = referencedBlockType.icon;
        }
      }
    }

    const id = `core/block/${reusableBlock.id}`;
    const {
      time,
      count = 0
    } = getInsertUsage(state, id) || {};
    const frecency = calculateFrecency(time, count);
    return {
      id,
      name: 'core/block',
      initialAttributes: {
        ref: reusableBlock.id
      },
      title: reusableBlock.title.raw,
      icon,
      category: 'reusable',
      keywords: [],
      isDisabled: false,
      utility: 1,
      // Deprecated.
      frecency
    };
  };

  const blockTypeInserterItems = (0,external_wp_blocks_namespaceObject.getBlockTypes)().filter(blockType => canIncludeBlockTypeInInserter(state, blockType, rootClientId)).map(buildBlockTypeInserterItem);
  const reusableBlockInserterItems = canInsertBlockTypeUnmemoized(state, 'core/block', rootClientId) ? getReusableBlocks(state).map(buildReusableBlockInserterItem) : [];
  const items = blockTypeInserterItems.reduce((accumulator, item) => {
    const {
      variations = []
    } = item; // Exclude any block type item that is to be replaced by a default variation.

    if (!variations.some(_ref4 => {
      let {
        isDefault
      } = _ref4;
      return isDefault;
    })) {
      accumulator.push(item);
    }

    if (variations.length) {
      const variationMapper = getItemFromVariation(state, item);
      accumulator.push(...variations.map(variationMapper));
    }

    return accumulator;
  }, []); // Ensure core blocks are prioritized in the returned results,
  // because third party blocks can be registered earlier than
  // the core blocks (usually by using the `init` action),
  // thus affecting the display order.
  // We don't sort reusable blocks as they are handled differently.

  const groupByType = (blocks, block) => {
    const {
      core,
      noncore
    } = blocks;
    const type = block.name.startsWith('core/') ? core : noncore;
    type.push(block);
    return blocks;
  };

  const {
    core: coreItems,
    noncore: nonCoreItems
  } = items.reduce(groupByType, {
    core: [],
    noncore: []
  });
  const sortedBlockTypes = [...coreItems, ...nonCoreItems];
  return [...sortedBlockTypes, ...reusableBlockInserterItems];
}, (state, rootClientId) => [state.blockListSettings[rootClientId], state.blocks.byClientId, state.blocks.order, state.preferences.insertUsage, state.settings.allowedBlockTypes, state.settings.templateLock, getReusableBlocks(state), (0,external_wp_blocks_namespaceObject.getBlockTypes)()]);
/**
 * Determines the items that appear in the available block transforms list.
 *
 * Each item object contains what's necessary to display a menu item in the
 * transform list and handle its selection.
 *
 * The 'frecency' property is a heuristic (https://en.wikipedia.org/wiki/Frecency)
 * that combines block usage frequenty and recency.
 *
 * Items are returned ordered descendingly by their 'frecency'.
 *
 * @param    {Object}  state        Editor state.
 * @param    {?string} rootClientId Optional root client ID of block list.
 *
 * @return {WPEditorTransformItem[]} Items that appear in inserter.
 *
 * @typedef {Object} WPEditorTransformItem
 * @property {string}  id           Unique identifier for the item.
 * @property {string}  name         The type of block to create.
 * @property {string}  title        Title of the item, as it appears in the inserter.
 * @property {string}  icon         Dashicon for the item, as it appears in the inserter.
 * @property {boolean} isDisabled   Whether or not the user should be prevented from inserting
 *                                  this item.
 * @property {number}  frecency     Heuristic that combines frequency and recency.
 */

const getBlockTransformItems = rememo(function (state, blocks) {
  let rootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  const buildBlockTypeTransformItem = buildBlockTypeItem(state, {
    buildScope: 'transform'
  });
  const blockTypeTransformItems = (0,external_wp_blocks_namespaceObject.getBlockTypes)().filter(blockType => canIncludeBlockTypeInInserter(state, blockType, rootClientId)).map(buildBlockTypeTransformItem);
  const itemsByName = (0,external_lodash_namespaceObject.mapKeys)(blockTypeTransformItems, _ref5 => {
    let {
      name
    } = _ref5;
    return name;
  });
  const possibleTransforms = (0,external_wp_blocks_namespaceObject.getPossibleBlockTransformations)(blocks).reduce((accumulator, block) => {
    if (itemsByName[block === null || block === void 0 ? void 0 : block.name]) {
      accumulator.push(itemsByName[block.name]);
    }

    return accumulator;
  }, []);
  const possibleBlockTransformations = (0,external_lodash_namespaceObject.orderBy)(possibleTransforms, block => itemsByName[block.name].frecency, 'desc');
  return possibleBlockTransformations;
}, (state, rootClientId) => [state.blockListSettings[rootClientId], state.blocks.byClientId, state.preferences.insertUsage, state.settings.allowedBlockTypes, state.settings.templateLock, (0,external_wp_blocks_namespaceObject.getBlockTypes)()]);
/**
 * Determines whether there are items to show in the inserter.
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Items that appear in inserter.
 */

const hasInserterItems = rememo(function (state) {
  let rootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
  const hasBlockType = (0,external_lodash_namespaceObject.some)((0,external_wp_blocks_namespaceObject.getBlockTypes)(), blockType => canIncludeBlockTypeInInserter(state, blockType, rootClientId));

  if (hasBlockType) {
    return true;
  }

  const hasReusableBlock = canInsertBlockTypeUnmemoized(state, 'core/block', rootClientId) && getReusableBlocks(state).length > 0;
  return hasReusableBlock;
}, (state, rootClientId) => [state.blockListSettings[rootClientId], state.blocks.byClientId, state.settings.allowedBlockTypes, state.settings.templateLock, getReusableBlocks(state), (0,external_wp_blocks_namespaceObject.getBlockTypes)()]);
/**
 * Returns the list of allowed inserter blocks for inner blocks children
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {Array?} The list of allowed block types.
 */

const __experimentalGetAllowedBlocks = rememo(function (state) {
  let rootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

  if (!rootClientId) {
    return;
  }

  return (0,external_lodash_namespaceObject.filter)((0,external_wp_blocks_namespaceObject.getBlockTypes)(), blockType => canIncludeBlockTypeInInserter(state, blockType, rootClientId));
}, (state, rootClientId) => [state.blockListSettings[rootClientId], state.blocks.byClientId, state.settings.allowedBlockTypes, state.settings.templateLock, (0,external_wp_blocks_namespaceObject.getBlockTypes)()]);
/**
 * Returns the block to be directly inserted by the block appender.
 *
 * @param    {Object}         state            Editor state.
 * @param    {?string}        rootClientId     Optional root client ID of block list.
 *
 * @return {?WPDirectInsertBlock}              The block type to be directly inserted.
 *
 * @typedef {Object} WPDirectInsertBlock
 * @property {string}         name             The type of block.
 * @property {?Object}        attributes       Attributes to pass to the newly created block.
 * @property {?Array<string>} attributesToCopy Attributes to be copied from adjecent blocks when inserted.
 */

const __experimentalGetDirectInsertBlock = rememo(function (state) {
  var _state$blockListSetti, _state$blockListSetti2;

  let rootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

  if (!rootClientId) {
    return;
  }

  const defaultBlock = (_state$blockListSetti = state.blockListSettings[rootClientId]) === null || _state$blockListSetti === void 0 ? void 0 : _state$blockListSetti.__experimentalDefaultBlock;
  const directInsert = (_state$blockListSetti2 = state.blockListSettings[rootClientId]) === null || _state$blockListSetti2 === void 0 ? void 0 : _state$blockListSetti2.__experimentalDirectInsert;

  if (!defaultBlock || !directInsert) {
    return;
  }

  if (typeof directInsert === 'function') {
    return directInsert(getBlock(state, rootClientId)) ? defaultBlock : null;
  }

  return defaultBlock;
}, (state, rootClientId) => [state.blockListSettings[rootClientId], state.blocks.tree[rootClientId]]);

const checkAllowListRecursive = (blocks, allowedBlockTypes) => {
  if ((0,external_lodash_namespaceObject.isBoolean)(allowedBlockTypes)) {
    return allowedBlockTypes;
  }

  const blocksQueue = [...blocks];

  while (blocksQueue.length > 0) {
    var _block$innerBlocks;

    const block = blocksQueue.shift();
    const isAllowed = checkAllowList(allowedBlockTypes, block.name || block.blockName, true);

    if (!isAllowed) {
      return false;
    }

    (_block$innerBlocks = block.innerBlocks) === null || _block$innerBlocks === void 0 ? void 0 : _block$innerBlocks.forEach(innerBlock => {
      blocksQueue.push(innerBlock);
    });
  }

  return true;
};

const __experimentalGetParsedPattern = rememo((state, patternName) => {
  const patterns = state.settings.__experimentalBlockPatterns;
  const pattern = patterns.find(_ref6 => {
    let {
      name
    } = _ref6;
    return name === patternName;
  });

  if (!pattern) {
    return null;
  }

  return { ...pattern,
    blocks: (0,external_wp_blocks_namespaceObject.parse)(pattern.content)
  };
}, state => [state.settings.__experimentalBlockPatterns]);
const getAllAllowedPatterns = rememo(state => {
  const patterns = state.settings.__experimentalBlockPatterns;
  const {
    allowedBlockTypes
  } = getSettings(state);
  const parsedPatterns = patterns.filter(_ref7 => {
    let {
      inserter = true
    } = _ref7;
    return !!inserter;
  }).map(_ref8 => {
    let {
      name
    } = _ref8;
    return __experimentalGetParsedPattern(state, name);
  });
  const allowedPatterns = parsedPatterns.filter(_ref9 => {
    let {
      blocks
    } = _ref9;
    return checkAllowListRecursive(blocks, allowedBlockTypes);
  });
  return allowedPatterns;
}, state => [state.settings.__experimentalBlockPatterns, state.settings.allowedBlockTypes]);
/**
 * Returns the list of allowed patterns for inner blocks children.
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional target root client ID.
 *
 * @return {Array?} The list of allowed patterns.
 */

const __experimentalGetAllowedPatterns = rememo(function (state) {
  let rootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
  const availableParsedPatterns = getAllAllowedPatterns(state);
  const patternsAllowed = (0,external_lodash_namespaceObject.filter)(availableParsedPatterns, _ref10 => {
    let {
      blocks
    } = _ref10;
    return blocks.every(_ref11 => {
      let {
        name
      } = _ref11;
      return canInsertBlockType(state, name, rootClientId);
    });
  });
  return patternsAllowed;
}, (state, rootClientId) => [state.settings.__experimentalBlockPatterns, state.settings.allowedBlockTypes, state.settings.templateLock, state.blockListSettings[rootClientId], state.blocks.byClientId[rootClientId]]);
/**
 * Returns the list of patterns based on their declared `blockTypes`
 * and a block's name.
 * Patterns can use `blockTypes` to integrate in work flows like
 * suggesting appropriate patterns in a Placeholder state(during insertion)
 * or blocks transformations.
 *
 * @param {Object}          state        Editor state.
 * @param {string|string[]} blockNames   Block's name or array of block names to find matching pattens.
 * @param {?string}         rootClientId Optional target root client ID.
 *
 * @return {Array} The list of matched block patterns based on declared `blockTypes` and block name.
 */

const __experimentalGetPatternsByBlockTypes = rememo(function (state, blockNames) {
  let rootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  if (!blockNames) return EMPTY_ARRAY;

  const patterns = __experimentalGetAllowedPatterns(state, rootClientId);

  const normalizedBlockNames = Array.isArray(blockNames) ? blockNames : [blockNames];
  return patterns.filter(pattern => {
    var _pattern$blockTypes, _pattern$blockTypes$s;

    return pattern === null || pattern === void 0 ? void 0 : (_pattern$blockTypes = pattern.blockTypes) === null || _pattern$blockTypes === void 0 ? void 0 : (_pattern$blockTypes$s = _pattern$blockTypes.some) === null || _pattern$blockTypes$s === void 0 ? void 0 : _pattern$blockTypes$s.call(_pattern$blockTypes, blockName => normalizedBlockNames.includes(blockName));
  });
}, (state, rootClientId) => [...__experimentalGetAllowedPatterns.getDependants(state, rootClientId)]);
/**
 * Determines the items that appear in the available pattern transforms list.
 *
 * For now we only handle blocks without InnerBlocks and take into account
 * the `__experimentalRole` property of blocks' attributes for the transformation.
 *
 * We return the first set of possible eligible block patterns,
 * by checking the `blockTypes` property. We still have to recurse through
 * block pattern's blocks and try to find matches from the selected blocks.
 * Now this happens in the consumer to avoid heavy operations in the selector.
 *
 * @param {Object}   state        Editor state.
 * @param {Object[]} blocks       The selected blocks.
 * @param {?string}  rootClientId Optional root client ID of block list.
 *
 * @return {WPBlockPattern[]} Items that are eligible for a pattern transformation.
 */

const __experimentalGetPatternTransformItems = rememo(function (state, blocks) {
  let rootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  if (!blocks) return EMPTY_ARRAY;
  /**
   * For now we only handle blocks without InnerBlocks and take into account
   * the `__experimentalRole` property of blocks' attributes for the transformation.
   * Note that the blocks have been retrieved through `getBlock`, which doesn't
   * return the inner blocks of an inner block controller, so we still need
   * to check for this case too.
   */

  if (blocks.some(_ref12 => {
    let {
      clientId,
      innerBlocks
    } = _ref12;
    return innerBlocks.length || areInnerBlocksControlled(state, clientId);
  })) {
    return EMPTY_ARRAY;
  } // Create a Set of the selected block names that is used in patterns filtering.


  const selectedBlockNames = Array.from(new Set(blocks.map(_ref13 => {
    let {
      name
    } = _ref13;
    return name;
  })));
  /**
   * Here we will return first set of possible eligible block patterns,
   * by checking the `blockTypes` property. We still have to recurse through
   * block pattern's blocks and try to find matches from the selected blocks.
   * Now this happens in the consumer to avoid heavy operations in the selector.
   */

  return __experimentalGetPatternsByBlockTypes(state, selectedBlockNames, rootClientId);
}, (state, rootClientId) => [...__experimentalGetPatternsByBlockTypes.getDependants(state, rootClientId)]);
/**
 * Returns the Block List settings of a block, if any exist.
 *
 * @param {Object}  state    Editor state.
 * @param {?string} clientId Block client ID.
 *
 * @return {?Object} Block settings of the block if set.
 */

function getBlockListSettings(state, clientId) {
  return state.blockListSettings[clientId];
}
/**
 * Returns the editor settings.
 *
 * @param {Object} state Editor state.
 *
 * @return {Object} The editor settings object.
 */

function getSettings(state) {
  return state.settings;
}
/**
 * Returns true if the most recent block change is be considered persistent, or
 * false otherwise. A persistent change is one committed by BlockEditorProvider
 * via its `onChange` callback, in addition to `onInput`.
 *
 * @param {Object} state Block editor state.
 *
 * @return {boolean} Whether the most recent block change was persistent.
 */

function isLastBlockChangePersistent(state) {
  return state.blocks.isPersistentChange;
}
/**
 * Returns the block list settings for an array of blocks, if any exist.
 *
 * @param {Object} state     Editor state.
 * @param {Array}  clientIds Block client IDs.
 *
 * @return {Object} An object where the keys are client ids and the values are
 *                  a block list setting object.
 */

const __experimentalGetBlockListSettingsForBlocks = rememo(function (state) {
  let clientIds = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
  return clientIds.reduce((blockListSettingsForBlocks, clientId) => {
    if (!state.blockListSettings[clientId]) {
      return blockListSettingsForBlocks;
    }

    return { ...blockListSettingsForBlocks,
      [clientId]: state.blockListSettings[clientId]
    };
  }, {});
}, state => [state.blockListSettings]);
/**
 * Returns the title of a given reusable block
 *
 * @param {Object}        state Global application state.
 * @param {number|string} ref   The shared block's ID.
 *
 * @return {string} The reusable block saved title.
 */

const __experimentalGetReusableBlockTitle = rememo((state, ref) => {
  var _reusableBlock$title;

  const reusableBlock = (0,external_lodash_namespaceObject.find)(getReusableBlocks(state), block => block.id === ref);

  if (!reusableBlock) {
    return null;
  }

  return (_reusableBlock$title = reusableBlock.title) === null || _reusableBlock$title === void 0 ? void 0 : _reusableBlock$title.raw;
}, state => [getReusableBlocks(state)]);
/**
 * Returns true if the most recent block change is be considered ignored, or
 * false otherwise. An ignored change is one not to be committed by
 * BlockEditorProvider, neither via `onChange` nor `onInput`.
 *
 * @param {Object} state Block editor state.
 *
 * @return {boolean} Whether the most recent block change was ignored.
 */

function __unstableIsLastBlockChangeIgnored(state) {
  // TODO: Removal Plan: Changes incurred by RECEIVE_BLOCKS should not be
  // ignored if in-fact they result in a change in blocks state. The current
  // need to ignore changes not a result of user interaction should be
  // accounted for in the refactoring of reusable blocks as occurring within
  // their own separate block editor / state (#7119).
  return state.blocks.isIgnoredChange;
}
/**
 * Returns the block attributes changed as a result of the last dispatched
 * action.
 *
 * @param {Object} state Block editor state.
 *
 * @return {Object<string,Object>} Subsets of block attributes changed, keyed
 *                                 by block client ID.
 */

function __experimentalGetLastBlockAttributeChanges(state) {
  return state.lastBlockAttributesChange;
}
/**
 * Returns the available reusable blocks
 *
 * @param {Object} state Global application state.
 *
 * @return {Array} Reusable blocks
 */

function getReusableBlocks(state) {
  var _state$settings$__exp, _state$settings;

  return (_state$settings$__exp = state === null || state === void 0 ? void 0 : (_state$settings = state.settings) === null || _state$settings === void 0 ? void 0 : _state$settings.__experimentalReusableBlocks) !== null && _state$settings$__exp !== void 0 ? _state$settings$__exp : EMPTY_ARRAY;
}
/**
 * Returns whether the navigation mode is enabled.
 *
 * @param {Object} state Editor state.
 *
 * @return {boolean} Is navigation mode enabled.
 */


function selectors_isNavigationMode(state) {
  return state.isNavigationMode;
}
/**
 * Returns whether block moving mode is enabled.
 *
 * @param {Object} state Editor state.
 *
 * @return {string} Client Id of moving block.
 */

function selectors_hasBlockMovingClientId(state) {
  return state.hasBlockMovingClientId;
}
/**
 * Returns true if the last change was an automatic change, false otherwise.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether the last change was automatic.
 */

function didAutomaticChange(state) {
  return !!state.automaticChangeStatus;
}
/**
 * Returns true if the current highlighted block matches the block clientId.
 *
 * @param {Object} state    Global application state.
 * @param {string} clientId The block to check.
 *
 * @return {boolean} Whether the block is currently highlighted.
 */

function isBlockHighlighted(state, clientId) {
  return state.highlightedBlock === clientId;
}
/**
 * Checks if a given block has controlled inner blocks.
 *
 * @param {Object} state    Global application state.
 * @param {string} clientId The block to check.
 *
 * @return {boolean} True if the block has controlled inner blocks.
 */

function areInnerBlocksControlled(state, clientId) {
  return !!state.blocks.controlledInnerBlocks[clientId];
}
/**
 * Returns the clientId for the first 'active' block of a given array of block names.
 * A block is 'active' if it (or a child) is the selected block.
 * Returns the first match moving up the DOM from the selected block.
 *
 * @param {Object}   state            Global application state.
 * @param {string[]} validBlocksNames The names of block types to check for.
 *
 * @return {string} The matching block's clientId.
 */

const __experimentalGetActiveBlockIdByBlockNames = rememo((state, validBlockNames) => {
  if (!validBlockNames.length) {
    return null;
  } // Check if selected block is a valid entity area.


  const selectedBlockClientId = getSelectedBlockClientId(state);

  if (validBlockNames.includes(getBlockName(state, selectedBlockClientId))) {
    return selectedBlockClientId;
  } // Check if first selected block is a child of a valid entity area.


  const multiSelectedBlockClientIds = getMultiSelectedBlockClientIds(state);
  const entityAreaParents = getBlockParentsByBlockName(state, selectedBlockClientId || multiSelectedBlockClientIds[0], validBlockNames);

  if (entityAreaParents) {
    // Last parent closest/most interior.
    return (0,external_lodash_namespaceObject.last)(entityAreaParents);
  }

  return null;
}, (state, validBlockNames) => [state.selection.selectionStart.clientId, state.selection.selectionEnd.clientId, validBlockNames]);
/**
 * Tells if the block with the passed clientId was just inserted.
 *
 * @param {Object}  state    Global application state.
 * @param {Object}  clientId Client Id of the block.
 * @param {?string} source   Optional insertion source of the block.
 * @return {boolean} True if the block matches the last block inserted from the specified source.
 */

function wasBlockJustInserted(state, clientId, source) {
  const {
    lastBlockInserted
  } = state;
  return lastBlockInserted.clientId === clientId && lastBlockInserted.source === source;
}

;// CONCATENATED MODULE: external ["wp","a11y"]
var external_wp_a11y_namespaceObject = window["wp"]["a11y"];
;// CONCATENATED MODULE: external ["wp","richText"]
var external_wp_richText_namespaceObject = window["wp"]["richText"];
;// CONCATENATED MODULE: external ["wp","deprecated"]
var external_wp_deprecated_namespaceObject = window["wp"]["deprecated"];
var external_wp_deprecated_default = /*#__PURE__*/__webpack_require__.n(external_wp_deprecated_namespaceObject);
;// CONCATENATED MODULE: ./packages/block-editor/build-module/store/actions.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






/**
 * Action which will insert a default block insert action if there
 * are no other blocks at the root of the editor. This action should be used
 * in actions which may result in no blocks remaining in the editor (removal,
 * replacement, etc).
 */

const ensureDefaultBlock = () => _ref => {
  let {
    select,
    dispatch
  } = _ref;
  // To avoid a focus loss when removing the last block, assure there is
  // always a default block if the last of the blocks have been removed.
  const count = select.getBlockCount();

  if (count > 0) {
    return;
  } // If there's an custom appender, don't insert default block.
  // We have to remember to manually move the focus elsewhere to
  // prevent it from being lost though.


  const {
    __unstableHasCustomAppender
  } = select.getSettings();

  if (__unstableHasCustomAppender) {
    return;
  }

  dispatch.insertDefaultBlock();
};
/**
 * Action that resets blocks state to the specified array of blocks, taking precedence
 * over any other content reflected as an edit in state.
 *
 * @param {Array} blocks Array of blocks.
 */


const resetBlocks = blocks => _ref2 => {
  let {
    dispatch
  } = _ref2;
  dispatch({
    type: 'RESET_BLOCKS',
    blocks
  });
  dispatch(validateBlocksToTemplate(blocks));
};
/**
 * Block validity is a function of blocks state (at the point of a
 * reset) and the template setting. As a compromise to its placement
 * across distinct parts of state, it is implemented here as a side-
 * effect of the block reset action.
 *
 * @param {Array} blocks Array of blocks.
 */

const validateBlocksToTemplate = blocks => _ref3 => {
  let {
    select,
    dispatch
  } = _ref3;
  const template = select.getTemplate();
  const templateLock = select.getTemplateLock(); // Unlocked templates are considered always valid because they act
  // as default values only.

  const isBlocksValidToTemplate = !template || templateLock !== 'all' || (0,external_wp_blocks_namespaceObject.doBlocksMatchTemplate)(blocks, template); // Update if validity has changed.

  const isValidTemplate = select.isValidTemplate();

  if (isBlocksValidToTemplate !== isValidTemplate) {
    dispatch.setTemplateValidity(isBlocksValidToTemplate);
    return isBlocksValidToTemplate;
  }
};
/**
 * A block selection object.
 *
 * @typedef {Object} WPBlockSelection
 *
 * @property {string} clientId     A block client ID.
 * @property {string} attributeKey A block attribute key.
 * @property {number} offset       An attribute value offset, based on the rich
 *                                 text value. See `wp.richText.create`.
 */

/* eslint-disable jsdoc/valid-types */

/**
 * Returns an action object used in signalling that selection state should be
 * reset to the specified selection.
 *
 * @param {WPBlockSelection} selectionStart  The selection start.
 * @param {WPBlockSelection} selectionEnd    The selection end.
 * @param {0|-1|null}        initialPosition Initial block position.
 *
 * @return {Object} Action object.
 */

function resetSelection(selectionStart, selectionEnd, initialPosition) {
  /* eslint-enable jsdoc/valid-types */
  return {
    type: 'RESET_SELECTION',
    selectionStart,
    selectionEnd,
    initialPosition
  };
}
/**
 * Returns an action object used in signalling that blocks have been received.
 * Unlike resetBlocks, these should be appended to the existing known set, not
 * replacing.
 *
 * @deprecated
 *
 * @param {Object[]} blocks Array of block objects.
 *
 * @return {Object} Action object.
 */

function receiveBlocks(blocks) {
  external_wp_deprecated_default()('wp.data.dispatch( "core/block-editor" ).receiveBlocks', {
    since: '5.9',
    alternative: 'resetBlocks or insertBlocks'
  });
  return {
    type: 'RECEIVE_BLOCKS',
    blocks
  };
}
/**
 * Action that updates attributes of multiple blocks with the specified client IDs.
 *
 * @param {string|string[]} clientIds     Block client IDs.
 * @param {Object}          attributes    Block attributes to be merged. Should be keyed by clientIds if
 *                                        uniqueByBlock is true.
 * @param {boolean}         uniqueByBlock true if each block in clientIds array has a unique set of attributes
 * @return {Object} Action object.
 */

function updateBlockAttributes(clientIds, attributes) {
  let uniqueByBlock = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  return {
    type: 'UPDATE_BLOCK_ATTRIBUTES',
    clientIds: (0,external_lodash_namespaceObject.castArray)(clientIds),
    attributes,
    uniqueByBlock
  };
}
/**
 * Action that updates the block with the specified client ID.
 *
 * @param {string} clientId Block client ID.
 * @param {Object} updates  Block attributes to be merged.
 *
 * @return {Object} Action object.
 */

function updateBlock(clientId, updates) {
  return {
    type: 'UPDATE_BLOCK',
    clientId,
    updates
  };
}
/* eslint-disable jsdoc/valid-types */

/**
 * Returns an action object used in signalling that the block with the
 * specified client ID has been selected, optionally accepting a position
 * value reflecting its selection directionality. An initialPosition of -1
 * reflects a reverse selection.
 *
 * @param {string}    clientId        Block client ID.
 * @param {0|-1|null} initialPosition Optional initial position. Pass as -1 to
 *                                    reflect reverse selection.
 *
 * @return {Object} Action object.
 */

function selectBlock(clientId) {
  let initialPosition = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

  /* eslint-enable jsdoc/valid-types */
  return {
    type: 'SELECT_BLOCK',
    initialPosition,
    clientId
  };
}
/**
 * Yields action objects used in signalling that the block preceding the given
 * clientId should be selected.
 *
 * @param {string} clientId Block client ID.
 */

const selectPreviousBlock = clientId => _ref4 => {
  let {
    select,
    dispatch
  } = _ref4;
  const previousBlockClientId = select.getPreviousBlockClientId(clientId);

  if (previousBlockClientId) {
    dispatch.selectBlock(previousBlockClientId, -1);
  }
};
/**
 * Yields action objects used in signalling that the block following the given
 * clientId should be selected.
 *
 * @param {string} clientId Block client ID.
 */

const selectNextBlock = clientId => _ref5 => {
  let {
    select,
    dispatch
  } = _ref5;
  const nextBlockClientId = select.getNextBlockClientId(clientId);

  if (nextBlockClientId) {
    dispatch.selectBlock(nextBlockClientId);
  }
};
/**
 * Action that starts block multi-selection.
 *
 * @return {Object} Action object.
 */

function startMultiSelect() {
  return {
    type: 'START_MULTI_SELECT'
  };
}
/**
 * Action that stops block multi-selection.
 *
 * @return {Object} Action object.
 */

function stopMultiSelect() {
  return {
    type: 'STOP_MULTI_SELECT'
  };
}
/**
 * Action that changes block multi-selection.
 *
 * @param {string}      start                         First block of the multi selection.
 * @param {string}      end                           Last block of the multiselection.
 * @param {number|null} __experimentalInitialPosition Optional initial position. Pass as null to skip focus within editor canvas.
 */

const multiSelect = function (start, end) {
  let __experimentalInitialPosition = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;

  return _ref6 => {
    let {
      select,
      dispatch
    } = _ref6;
    const startBlockRootClientId = select.getBlockRootClientId(start);
    const endBlockRootClientId = select.getBlockRootClientId(end); // Only allow block multi-selections at the same level.

    if (startBlockRootClientId !== endBlockRootClientId) {
      return;
    }

    dispatch({
      type: 'MULTI_SELECT',
      start,
      end,
      initialPosition: __experimentalInitialPosition
    });
    const blockCount = select.getSelectedBlockCount();
    (0,external_wp_a11y_namespaceObject.speak)((0,external_wp_i18n_namespaceObject.sprintf)(
    /* translators: %s: number of selected blocks */
    (0,external_wp_i18n_namespaceObject._n)('%s block selected.', '%s blocks selected.', blockCount), blockCount), 'assertive');
  };
};
/**
 * Action that clears the block selection.
 *
 * @return {Object} Action object.
 */

function clearSelectedBlock() {
  return {
    type: 'CLEAR_SELECTED_BLOCK'
  };
}
/**
 * Action that enables or disables block selection.
 *
 * @param {boolean} [isSelectionEnabled=true] Whether block selection should
 *                                            be enabled.
 *
 * @return {Object} Action object.
 */

function toggleSelection() {
  let isSelectionEnabled = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
  return {
    type: 'TOGGLE_SELECTION',
    isSelectionEnabled
  };
}

function getBlocksWithDefaultStylesApplied(blocks, blockEditorSettings) {
  var _blockEditorSettings$, _blockEditorSettings$2;

  const preferredStyleVariations = (_blockEditorSettings$ = blockEditorSettings === null || blockEditorSettings === void 0 ? void 0 : (_blockEditorSettings$2 = blockEditorSettings.__experimentalPreferredStyleVariations) === null || _blockEditorSettings$2 === void 0 ? void 0 : _blockEditorSettings$2.value) !== null && _blockEditorSettings$ !== void 0 ? _blockEditorSettings$ : {};
  return blocks.map(block => {
    var _block$attributes;

    const blockName = block.name;

    if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockName, 'defaultStylePicker', true)) {
      return block;
    }

    if (!preferredStyleVariations[blockName]) {
      return block;
    }

    const className = (_block$attributes = block.attributes) === null || _block$attributes === void 0 ? void 0 : _block$attributes.className;

    if (className !== null && className !== void 0 && className.includes('is-style-')) {
      return block;
    }

    const {
      attributes = {}
    } = block;
    const blockStyle = preferredStyleVariations[blockName];
    return { ...block,
      attributes: { ...attributes,
        className: `${className || ''} is-style-${blockStyle}`.trim()
      }
    };
  });
}
/* eslint-disable jsdoc/valid-types */

/**
 * Action that replaces given blocks with one or more replacement blocks.
 *
 * @param {(string|string[])} clientIds       Block client ID(s) to replace.
 * @param {(Object|Object[])} blocks          Replacement block(s).
 * @param {number}            indexToSelect   Index of replacement block to select.
 * @param {0|-1|null}         initialPosition Index of caret after in the selected block after the operation.
 * @param {?Object}           meta            Optional Meta values to be passed to the action object.
 *
 * @return {Object} Action object.
 */


const replaceBlocks = function (clientIds, blocks, indexToSelect) {
  let initialPosition = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
  let meta = arguments.length > 4 ? arguments[4] : undefined;
  return _ref7 => {
    let {
      select,
      dispatch
    } = _ref7;

    /* eslint-enable jsdoc/valid-types */
    clientIds = (0,external_lodash_namespaceObject.castArray)(clientIds);
    blocks = getBlocksWithDefaultStylesApplied((0,external_lodash_namespaceObject.castArray)(blocks), select.getSettings());
    const rootClientId = select.getBlockRootClientId((0,external_lodash_namespaceObject.first)(clientIds)); // Replace is valid if the new blocks can be inserted in the root block.

    for (let index = 0; index < blocks.length; index++) {
      const block = blocks[index];
      const canInsertBlock = select.canInsertBlockType(block.name, rootClientId);

      if (!canInsertBlock) {
        return;
      }
    }

    dispatch({
      type: 'REPLACE_BLOCKS',
      clientIds,
      blocks,
      time: Date.now(),
      indexToSelect,
      initialPosition,
      meta
    });
    dispatch(ensureDefaultBlock());
  };
};
/**
 * Action that replaces a single block with one or more replacement blocks.
 *
 * @param {(string|string[])} clientId Block client ID to replace.
 * @param {(Object|Object[])} block    Replacement block(s).
 *
 * @return {Object} Action object.
 */

function replaceBlock(clientId, block) {
  return replaceBlocks(clientId, block);
}
/**
 * Higher-order action creator which, given the action type to dispatch creates
 * an action creator for managing block movement.
 *
 * @param {string} type Action type to dispatch.
 *
 * @return {Function} Action creator.
 */

const createOnMove = type => (clientIds, rootClientId) => _ref8 => {
  let {
    select,
    dispatch
  } = _ref8;
  // If one of the blocks is locked or the parent is locked, we cannot move any block.
  const canMoveBlocks = select.canMoveBlocks(clientIds, rootClientId);

  if (!canMoveBlocks) {
    return;
  }

  dispatch({
    type,
    clientIds: (0,external_lodash_namespaceObject.castArray)(clientIds),
    rootClientId
  });
};

const moveBlocksDown = createOnMove('MOVE_BLOCKS_DOWN');
const moveBlocksUp = createOnMove('MOVE_BLOCKS_UP');
/**
 * Action that moves given blocks to a new position.
 *
 * @param {?string} clientIds        The client IDs of the blocks.
 * @param {?string} fromRootClientId Root client ID source.
 * @param {?string} toRootClientId   Root client ID destination.
 * @param {number}  index            The index to move the blocks to.
 */

const moveBlocksToPosition = function (clientIds) {
  let fromRootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  let toRootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
  let index = arguments.length > 3 ? arguments[3] : undefined;
  return _ref9 => {
    let {
      select,
      dispatch
    } = _ref9;
    const canMoveBlocks = select.canMoveBlocks(clientIds, fromRootClientId); // If one of the blocks is locked or the parent is locked, we cannot move any block.

    if (!canMoveBlocks) {
      return;
    } // If moving inside the same root block the move is always possible.


    if (fromRootClientId !== toRootClientId) {
      const canRemoveBlocks = select.canRemoveBlocks(clientIds, fromRootClientId); // If we're moving to another block, it means we're deleting blocks from
      // the original block, so we need to check if removing is possible.

      if (!canRemoveBlocks) {
        return;
      }

      const canInsertBlocks = select.canInsertBlocks(clientIds, toRootClientId); // If moving to other parent block, the move is possible if we can insert a block of the same type inside the new parent block.

      if (!canInsertBlocks) {
        return;
      }
    }

    dispatch({
      type: 'MOVE_BLOCKS_TO_POSITION',
      fromRootClientId,
      toRootClientId,
      clientIds,
      index
    });
  };
};
/**
 * Action that moves given block to a new position.
 *
 * @param {?string} clientId         The client ID of the block.
 * @param {?string} fromRootClientId Root client ID source.
 * @param {?string} toRootClientId   Root client ID destination.
 * @param {number}  index            The index to move the block to.
 */

function moveBlockToPosition(clientId) {
  let fromRootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  let toRootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
  let index = arguments.length > 3 ? arguments[3] : undefined;
  return moveBlocksToPosition([clientId], fromRootClientId, toRootClientId, index);
}
/**
 * Action that inserts a single block, optionally at a specific index respective a root block list.
 *
 * @param {Object}   block           Block object to insert.
 * @param {?number}  index           Index at which block should be inserted.
 * @param {?string}  rootClientId    Optional root client ID of block list on which to insert.
 * @param {?boolean} updateSelection If true block selection will be updated. If false, block selection will not change. Defaults to true.
 * @param {?Object}  meta            Optional Meta values to be passed to the action object.
 *
 * @return {Object} Action object.
 */

function insertBlock(block, index, rootClientId, updateSelection, meta) {
  return insertBlocks([block], index, rootClientId, updateSelection, 0, meta);
}
/* eslint-disable jsdoc/valid-types */

/**
 * Action that inserts an array of blocks, optionally at a specific index respective a root block list.
 *
 * @param {Object[]}  blocks          Block objects to insert.
 * @param {?number}   index           Index at which block should be inserted.
 * @param {?string}   rootClientId    Optional root client ID of block list on which to insert.
 * @param {?boolean}  updateSelection If true block selection will be updated.  If false, block selection will not change. Defaults to true.
 * @param {0|-1|null} initialPosition Initial focus position. Setting it to null prevent focusing the inserted block.
 * @param {?Object}   meta            Optional Meta values to be passed to the action object.
 * @return {Object} Action object.
 */

const insertBlocks = function (blocks, index, rootClientId) {
  let updateSelection = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
  let initialPosition = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
  let meta = arguments.length > 5 ? arguments[5] : undefined;
  return _ref10 => {
    let {
      select,
      dispatch
    } = _ref10;

    /* eslint-enable jsdoc/valid-types */
    if ((0,external_lodash_namespaceObject.isObject)(initialPosition)) {
      meta = initialPosition;
      initialPosition = 0;
      external_wp_deprecated_default()("meta argument in wp.data.dispatch('core/block-editor')", {
        since: '5.8',
        hint: 'The meta argument is now the 6th argument of the function'
      });
    }

    blocks = getBlocksWithDefaultStylesApplied((0,external_lodash_namespaceObject.castArray)(blocks), select.getSettings());
    const allowedBlocks = [];

    for (const block of blocks) {
      const isValid = select.canInsertBlockType(block.name, rootClientId);

      if (isValid) {
        allowedBlocks.push(block);
      }
    }

    if (allowedBlocks.length) {
      dispatch({
        type: 'INSERT_BLOCKS',
        blocks: allowedBlocks,
        index,
        rootClientId,
        time: Date.now(),
        updateSelection,
        initialPosition: updateSelection ? initialPosition : null,
        meta
      });
    }
  };
};
/**
 * Action that shows the insertion point.
 *
 * @param {?string} rootClientId      Optional root client ID of block list on
 *                                    which to insert.
 * @param {?number} index             Index at which block should be inserted.
 * @param {Object}  __unstableOptions Wether or not to show an inserter button.
 *
 * @return {Object} Action object.
 */

function showInsertionPoint(rootClientId, index) {
  let __unstableOptions = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

  const {
    __unstableWithInserter
  } = __unstableOptions;
  return {
    type: 'SHOW_INSERTION_POINT',
    rootClientId,
    index,
    __unstableWithInserter
  };
}
/**
 * Action that hides the insertion point.
 *
 * @return {Object} Action object.
 */

function hideInsertionPoint() {
  return {
    type: 'HIDE_INSERTION_POINT'
  };
}
/**
 * Action that resets the template validity.
 *
 * @param {boolean} isValid template validity flag.
 *
 * @return {Object} Action object.
 */

function setTemplateValidity(isValid) {
  return {
    type: 'SET_TEMPLATE_VALIDITY',
    isValid
  };
}
/**
 * Action that synchronizes the template with the list of blocks.
 *
 * @return {Object} Action object.
 */

const synchronizeTemplate = () => _ref11 => {
  let {
    select,
    dispatch
  } = _ref11;
  dispatch({
    type: 'SYNCHRONIZE_TEMPLATE'
  });
  const blocks = select.getBlocks();
  const template = select.getTemplate();
  const updatedBlockList = (0,external_wp_blocks_namespaceObject.synchronizeBlocksWithTemplate)(blocks, template);
  dispatch.resetBlocks(updatedBlockList);
};
/**
 * Action that merges two blocks.
 *
 * @param {string} firstBlockClientId  Client ID of the first block to merge.
 * @param {string} secondBlockClientId Client ID of the second block to merge.
 */

const mergeBlocks = (firstBlockClientId, secondBlockClientId) => _ref12 => {
  let {
    select,
    dispatch
  } = _ref12;
  const blocks = [firstBlockClientId, secondBlockClientId];
  dispatch({
    type: 'MERGE_BLOCKS',
    blocks
  });
  const [clientIdA, clientIdB] = blocks;
  const blockA = select.getBlock(clientIdA);
  const blockAType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockA.name); // Only focus the previous block if it's not mergeable.

  if (blockAType && !blockAType.merge) {
    dispatch.selectBlock(blockA.clientId);
    return;
  }

  const blockB = select.getBlock(clientIdB);
  const blockBType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockB.name);
  const {
    clientId,
    attributeKey,
    offset
  } = select.getSelectionStart();
  const selectedBlockType = clientId === clientIdA ? blockAType : blockBType;
  const attributeDefinition = selectedBlockType.attributes[attributeKey];
  const canRestoreTextSelection = (clientId === clientIdA || clientId === clientIdB) && attributeKey !== undefined && offset !== undefined && // We cannot restore text selection if the RichText identifier
  // is not a defined block attribute key. This can be the case if the
  // fallback intance ID is used to store selection (and no RichText
  // identifier is set), or when the identifier is wrong.
  !!attributeDefinition;

  if (!attributeDefinition) {
    if (typeof attributeKey === 'number') {
      window.console.error(`RichText needs an identifier prop that is the block attribute key of the attribute it controls. Its type is expected to be a string, but was ${typeof attributeKey}`);
    } else {
      window.console.error('The RichText identifier prop does not match any attributes defined by the block.');
    }
  } // A robust way to retain selection position through various transforms
  // is to insert a special character at the position and then recover it.


  const START_OF_SELECTED_AREA = '\u0086'; // Clone the blocks so we don't insert the character in a "live" block.

  const cloneA = (0,external_wp_blocks_namespaceObject.cloneBlock)(blockA);
  const cloneB = (0,external_wp_blocks_namespaceObject.cloneBlock)(blockB);

  if (canRestoreTextSelection) {
    const selectedBlock = clientId === clientIdA ? cloneA : cloneB;
    const html = selectedBlock.attributes[attributeKey];
    const {
      multiline: multilineTag,
      __unstableMultilineWrapperTags: multilineWrapperTags,
      __unstablePreserveWhiteSpace: preserveWhiteSpace
    } = attributeDefinition;
    const value = (0,external_wp_richText_namespaceObject.insert)((0,external_wp_richText_namespaceObject.create)({
      html,
      multilineTag,
      multilineWrapperTags,
      preserveWhiteSpace
    }), START_OF_SELECTED_AREA, offset, offset);
    selectedBlock.attributes[attributeKey] = (0,external_wp_richText_namespaceObject.toHTMLString)({
      value,
      multilineTag,
      preserveWhiteSpace
    });
  } // We can only merge blocks with similar types
  // thus, we transform the block to merge first.


  const blocksWithTheSameType = blockA.name === blockB.name ? [cloneB] : (0,external_wp_blocks_namespaceObject.switchToBlockType)(cloneB, blockA.name); // If the block types can not match, do nothing.

  if (!blocksWithTheSameType || !blocksWithTheSameType.length) {
    return;
  } // Calling the merge to update the attributes and remove the block to be merged.


  const updatedAttributes = blockAType.merge(cloneA.attributes, blocksWithTheSameType[0].attributes);

  if (canRestoreTextSelection) {
    const newAttributeKey = (0,external_lodash_namespaceObject.findKey)(updatedAttributes, v => typeof v === 'string' && v.indexOf(START_OF_SELECTED_AREA) !== -1);
    const convertedHtml = updatedAttributes[newAttributeKey];
    const {
      multiline: multilineTag,
      __unstableMultilineWrapperTags: multilineWrapperTags,
      __unstablePreserveWhiteSpace: preserveWhiteSpace
    } = blockAType.attributes[newAttributeKey];
    const convertedValue = (0,external_wp_richText_namespaceObject.create)({
      html: convertedHtml,
      multilineTag,
      multilineWrapperTags,
      preserveWhiteSpace
    });
    const newOffset = convertedValue.text.indexOf(START_OF_SELECTED_AREA);
    const newValue = (0,external_wp_richText_namespaceObject.remove)(convertedValue, newOffset, newOffset + 1);
    const newHtml = (0,external_wp_richText_namespaceObject.toHTMLString)({
      value: newValue,
      multilineTag,
      preserveWhiteSpace
    });
    updatedAttributes[newAttributeKey] = newHtml;
    dispatch.selectionChange(blockA.clientId, newAttributeKey, newOffset, newOffset);
  }

  dispatch.replaceBlocks([blockA.clientId, blockB.clientId], [{ ...blockA,
    attributes: { ...blockA.attributes,
      ...updatedAttributes
    }
  }, ...blocksWithTheSameType.slice(1)], 0 // If we don't pass the `indexToSelect` it will default to the last block.
  );
};
/**
 * Yields action objects used in signalling that the blocks corresponding to
 * the set of specified client IDs are to be removed.
 *
 * @param {string|string[]} clientIds      Client IDs of blocks to remove.
 * @param {boolean}         selectPrevious True if the previous block should be
 *                                         selected when a block is removed.
 */

const removeBlocks = function (clientIds) {
  let selectPrevious = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
  return _ref13 => {
    let {
      select,
      dispatch
    } = _ref13;

    if (!clientIds || !clientIds.length) {
      return;
    }

    clientIds = (0,external_lodash_namespaceObject.castArray)(clientIds);
    const rootClientId = select.getBlockRootClientId(clientIds[0]);
    const canRemoveBlocks = select.canRemoveBlocks(clientIds, rootClientId);

    if (!canRemoveBlocks) {
      return;
    }

    if (selectPrevious) {
      dispatch.selectPreviousBlock(clientIds[0]);
    }

    dispatch({
      type: 'REMOVE_BLOCKS',
      clientIds
    }); // To avoid a focus loss when removing the last block, assure there is
    // always a default block if the last of the blocks have been removed.

    dispatch(ensureDefaultBlock());
  };
};
/**
 * Returns an action object used in signalling that the block with the
 * specified client ID is to be removed.
 *
 * @param {string}  clientId       Client ID of block to remove.
 * @param {boolean} selectPrevious True if the previous block should be
 *                                 selected when a block is removed.
 *
 * @return {Object} Action object.
 */

function removeBlock(clientId, selectPrevious) {
  return removeBlocks([clientId], selectPrevious);
}
/* eslint-disable jsdoc/valid-types */

/**
 * Returns an action object used in signalling that the inner blocks with the
 * specified client ID should be replaced.
 *
 * @param {string}    rootClientId    Client ID of the block whose InnerBlocks will re replaced.
 * @param {Object[]}  blocks          Block objects to insert as new InnerBlocks
 * @param {?boolean}  updateSelection If true block selection will be updated. If false, block selection will not change. Defaults to false.
 * @param {0|-1|null} initialPosition Initial block position.
 * @return {Object} Action object.
 */

function replaceInnerBlocks(rootClientId, blocks) {
  let updateSelection = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  let initialPosition = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;

  /* eslint-enable jsdoc/valid-types */
  return {
    type: 'REPLACE_INNER_BLOCKS',
    rootClientId,
    blocks,
    updateSelection,
    initialPosition: updateSelection ? initialPosition : null,
    time: Date.now()
  };
}
/**
 * Returns an action object used to toggle the block editing mode between
 * visual and HTML modes.
 *
 * @param {string} clientId Block client ID.
 *
 * @return {Object} Action object.
 */

function toggleBlockMode(clientId) {
  return {
    type: 'TOGGLE_BLOCK_MODE',
    clientId
  };
}
/**
 * Returns an action object used in signalling that the user has begun to type.
 *
 * @return {Object} Action object.
 */

function startTyping() {
  return {
    type: 'START_TYPING'
  };
}
/**
 * Returns an action object used in signalling that the user has stopped typing.
 *
 * @return {Object} Action object.
 */

function stopTyping() {
  return {
    type: 'STOP_TYPING'
  };
}
/**
 * Returns an action object used in signalling that the user has begun to drag blocks.
 *
 * @param {string[]} clientIds An array of client ids being dragged
 *
 * @return {Object} Action object.
 */

function startDraggingBlocks() {
  let clientIds = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  return {
    type: 'START_DRAGGING_BLOCKS',
    clientIds
  };
}
/**
 * Returns an action object used in signalling that the user has stopped dragging blocks.
 *
 * @return {Object} Action object.
 */

function stopDraggingBlocks() {
  return {
    type: 'STOP_DRAGGING_BLOCKS'
  };
}
/**
 * Returns an action object used in signalling that the caret has entered formatted text.
 *
 * @return {Object} Action object.
 */

function enterFormattedText() {
  return {
    type: 'ENTER_FORMATTED_TEXT'
  };
}
/**
 * Returns an action object used in signalling that the user caret has exited formatted text.
 *
 * @return {Object} Action object.
 */

function exitFormattedText() {
  return {
    type: 'EXIT_FORMATTED_TEXT'
  };
}
/**
 * Action that changes the position of the user caret.
 *
 * @param {string} clientId     The selected block client ID.
 * @param {string} attributeKey The selected block attribute key.
 * @param {number} startOffset  The start offset.
 * @param {number} endOffset    The end offset.
 *
 * @return {Object} Action object.
 */

function selectionChange(clientId, attributeKey, startOffset, endOffset) {
  return {
    type: 'SELECTION_CHANGE',
    clientId,
    attributeKey,
    startOffset,
    endOffset
  };
}
/**
 * Action that adds a new block of the default type to the block list.
 *
 * @param {?Object} attributes   Optional attributes of the block to assign.
 * @param {?string} rootClientId Optional root client ID of block list on which
 *                               to append.
 * @param {?number} index        Optional index where to insert the default block.
 */

const insertDefaultBlock = (attributes, rootClientId, index) => _ref14 => {
  let {
    dispatch
  } = _ref14;
  // Abort if there is no default block type (if it has been unregistered).
  const defaultBlockName = (0,external_wp_blocks_namespaceObject.getDefaultBlockName)();

  if (!defaultBlockName) {
    return;
  }

  const block = (0,external_wp_blocks_namespaceObject.createBlock)(defaultBlockName, attributes);
  return dispatch.insertBlock(block, index, rootClientId);
};
/**
 * Action that changes the nested settings of a given block.
 *
 * @param {string} clientId Client ID of the block whose nested setting are
 *                          being received.
 * @param {Object} settings Object with the new settings for the nested block.
 *
 * @return {Object} Action object
 */

function updateBlockListSettings(clientId, settings) {
  return {
    type: 'UPDATE_BLOCK_LIST_SETTINGS',
    clientId,
    settings
  };
}
/**
 * Action that updates the block editor settings.
 *
 * @param {Object} settings Updated settings
 *
 * @return {Object} Action object
 */

function updateSettings(settings) {
  return {
    type: 'UPDATE_SETTINGS',
    settings
  };
}
/**
 * Action that signals that a temporary reusable block has been saved
 * in order to switch its temporary id with the real id.
 *
 * @param {string} id        Reusable block's id.
 * @param {string} updatedId Updated block's id.
 *
 * @return {Object} Action object.
 */

function __unstableSaveReusableBlock(id, updatedId) {
  return {
    type: 'SAVE_REUSABLE_BLOCK_SUCCESS',
    id,
    updatedId
  };
}
/**
 * Action that marks the last block change explicitly as persistent.
 *
 * @return {Object} Action object.
 */

function __unstableMarkLastChangeAsPersistent() {
  return {
    type: 'MARK_LAST_CHANGE_AS_PERSISTENT'
  };
}
/**
 * Action that signals that the next block change should be marked explicitly as not persistent.
 *
 * @return {Object} Action object.
 */

function __unstableMarkNextChangeAsNotPersistent() {
  return {
    type: 'MARK_NEXT_CHANGE_AS_NOT_PERSISTENT'
  };
}
/**
 * Action that marks the last block change as an automatic change, meaning it was not
 * performed by the user, and can be undone using the `Escape` and `Backspace` keys.
 * This action must be called after the change was made, and any actions that are a
 * consequence of it, so it is recommended to be called at the next idle period to ensure all
 * selection changes have been recorded.
 */

const __unstableMarkAutomaticChange = () => _ref15 => {
  let {
    dispatch
  } = _ref15;
  dispatch({
    type: 'MARK_AUTOMATIC_CHANGE'
  });
  const {
    requestIdleCallback = cb => setTimeout(cb, 100)
  } = window;
  requestIdleCallback(() => {
    dispatch({
      type: 'MARK_AUTOMATIC_CHANGE_FINAL'
    });
  });
};
/**
 * Action that enables or disables the navigation mode.
 *
 * @param {string} isNavigationMode Enable/Disable navigation mode.
 */

const setNavigationMode = function () {
  let isNavigationMode = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
  return _ref16 => {
    let {
      dispatch
    } = _ref16;
    dispatch({
      type: 'SET_NAVIGATION_MODE',
      isNavigationMode
    });

    if (isNavigationMode) {
      (0,external_wp_a11y_namespaceObject.speak)((0,external_wp_i18n_namespaceObject.__)('You are currently in navigation mode. Navigate blocks using the Tab key and Arrow keys. Use Left and Right Arrow keys to move between nesting levels. To exit navigation mode and edit the selected block, press Enter.'));
    } else {
      (0,external_wp_a11y_namespaceObject.speak)((0,external_wp_i18n_namespaceObject.__)('You are currently in edit mode. To return to the navigation mode, press Escape.'));
    }
  };
};
/**
 * Action that enables or disables the block moving mode.
 *
 * @param {string|null} hasBlockMovingClientId Enable/Disable block moving mode.
 */

const setBlockMovingClientId = function () {
  let hasBlockMovingClientId = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
  return _ref17 => {
    let {
      dispatch
    } = _ref17;
    dispatch({
      type: 'SET_BLOCK_MOVING_MODE',
      hasBlockMovingClientId
    });

    if (hasBlockMovingClientId) {
      (0,external_wp_a11y_namespaceObject.speak)((0,external_wp_i18n_namespaceObject.__)('Use the Tab key and Arrow keys to choose new block location. Use Left and Right Arrow keys to move between nesting levels. Once location is selected press Enter or Space to move the block.'));
    }
  };
};
/**
 * Action that duplicates a list of blocks.
 *
 * @param {string[]} clientIds
 * @param {boolean}  updateSelection
 */

const duplicateBlocks = function (clientIds) {
  let updateSelection = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
  return _ref18 => {
    let {
      select,
      dispatch
    } = _ref18;

    if (!clientIds || !clientIds.length) {
      return;
    } // Return early if blocks don't exist.


    const blocks = select.getBlocksByClientId(clientIds);

    if ((0,external_lodash_namespaceObject.some)(blocks, block => !block)) {
      return;
    } // Return early if blocks don't support multiple usage.


    const blockNames = blocks.map(block => block.name);

    if (blockNames.some(blockName => !(0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockName, 'multiple', true))) {
      return;
    }

    const rootClientId = select.getBlockRootClientId(clientIds[0]);
    const lastSelectedIndex = select.getBlockIndex((0,external_lodash_namespaceObject.last)((0,external_lodash_namespaceObject.castArray)(clientIds)));
    const clonedBlocks = blocks.map(block => (0,external_wp_blocks_namespaceObject.__experimentalCloneSanitizedBlock)(block));
    dispatch.insertBlocks(clonedBlocks, lastSelectedIndex + 1, rootClientId, updateSelection);

    if (clonedBlocks.length > 1 && updateSelection) {
      dispatch.multiSelect((0,external_lodash_namespaceObject.first)(clonedBlocks).clientId, (0,external_lodash_namespaceObject.last)(clonedBlocks).clientId);
    }

    return clonedBlocks.map(block => block.clientId);
  };
};
/**
 * Action that inserts an empty block before a given block.
 *
 * @param {string} clientId
 */

const insertBeforeBlock = clientId => _ref19 => {
  let {
    select,
    dispatch
  } = _ref19;

  if (!clientId) {
    return;
  }

  const rootClientId = select.getBlockRootClientId(clientId);
  const isLocked = select.getTemplateLock(rootClientId);

  if (isLocked) {
    return;
  }

  const firstSelectedIndex = select.getBlockIndex(clientId);
  return dispatch.insertDefaultBlock({}, rootClientId, firstSelectedIndex);
};
/**
 * Action that inserts an empty block after a given block.
 *
 * @param {string} clientId
 */

const insertAfterBlock = clientId => _ref20 => {
  let {
    select,
    dispatch
  } = _ref20;

  if (!clientId) {
    return;
  }

  const rootClientId = select.getBlockRootClientId(clientId);
  const isLocked = select.getTemplateLock(rootClientId);

  if (isLocked) {
    return;
  }

  const firstSelectedIndex = select.getBlockIndex(clientId);
  return dispatch.insertDefaultBlock({}, rootClientId, firstSelectedIndex + 1);
};
/**
 * Action that toggles the highlighted block state.
 *
 * @param {string}  clientId      The block's clientId.
 * @param {boolean} isHighlighted The highlight state.
 */

function toggleBlockHighlight(clientId, isHighlighted) {
  return {
    type: 'TOGGLE_BLOCK_HIGHLIGHT',
    clientId,
    isHighlighted
  };
}
/**
 * Action that "flashes" the block with a given `clientId` by rhythmically highlighting it.
 *
 * @param {string} clientId Target block client ID.
 */

const flashBlock = clientId => async _ref21 => {
  let {
    dispatch
  } = _ref21;
  dispatch(toggleBlockHighlight(clientId, true));
  await new Promise(resolve => setTimeout(resolve, 150));
  dispatch(toggleBlockHighlight(clientId, false));
};
/**
 * Action that sets whether a block has controlled inner blocks.
 *
 * @param {string}  clientId                 The block's clientId.
 * @param {boolean} hasControlledInnerBlocks True if the block's inner blocks are controlled.
 */

function setHasControlledInnerBlocks(clientId, hasControlledInnerBlocks) {
  return {
    type: 'SET_HAS_CONTROLLED_INNER_BLOCKS',
    hasControlledInnerBlocks,
    clientId
  };
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/store/constants.js
const STORE_NAME = 'core/block-editor';

;// CONCATENATED MODULE: ./packages/block-editor/build-module/store/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */





/**
 * Block editor data store configuration.
 *
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/data/README.md#registerStore
 *
 * @type {Object}
 */

const storeConfig = {
  reducer: reducer,
  selectors: selectors_namespaceObject,
  actions: actions_namespaceObject
};
/**
 * Store definition for the block editor namespace.
 *
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/data/README.md#createReduxStore
 *
 * @type {Object}
 */

const store = (0,external_wp_data_namespaceObject.createReduxStore)(STORE_NAME, { ...storeConfig,
  persist: ['preferences']
}); // Ideally we'd use register instead of register stores.

(0,external_wp_data_namespaceObject.registerStore)(STORE_NAME, { ...storeConfig,
  persist: ['preferences']
});

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-edit/context.js
/**
 * WordPress dependencies
 */

const DEFAULT_BLOCK_EDIT_CONTEXT = {
  name: '',
  isSelected: false
};
const Context = (0,external_wp_element_namespaceObject.createContext)(DEFAULT_BLOCK_EDIT_CONTEXT);
const {
  Provider
} = Context;

/**
 * A hook that returns the block edit context.
 *
 * @return {Object} Block edit context
 */

function useBlockEditContext() {
  return (0,external_wp_element_namespaceObject.useContext)(Context);
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/use-display-block-controls/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */



function useDisplayBlockControls() {
  const {
    isSelected,
    clientId,
    name
  } = useBlockEditContext();
  return (0,external_wp_data_namespaceObject.useSelect)(select => {
    if (isSelected) {
      return true;
    }

    const {
      getBlockName,
      isFirstMultiSelectedBlock,
      getMultiSelectedBlockClientIds
    } = select(store);

    if (isFirstMultiSelectedBlock(clientId)) {
      return getMultiSelectedBlockClientIds().every(id => getBlockName(id) === name);
    }

    return false;
  }, [clientId, isSelected, name]);
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-controls/hook.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





function useBlockControlsFill(group, shareWithChildBlocks) {
  const isDisplayed = useDisplayBlockControls();
  const {
    clientId
  } = useBlockEditContext();
  const isParentDisplayed = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getBlockName,
      hasSelectedInnerBlock
    } = select(store);
    const {
      hasBlockSupport
    } = select(external_wp_blocks_namespaceObject.store);
    return shareWithChildBlocks && hasBlockSupport(getBlockName(clientId), '__experimentalExposeControlsToChildren', false) && hasSelectedInnerBlock(clientId);
  }, [shareWithChildBlocks, clientId]);

  if (isDisplayed) {
    var _groups$group;

    return (_groups$group = block_controls_groups[group]) === null || _groups$group === void 0 ? void 0 : _groups$group.Fill;
  }

  if (isParentDisplayed) {
    return block_controls_groups.parent.Fill;
  }

  return null;
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-controls/fill.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function BlockControlsFill(_ref) {
  let {
    group = 'default',
    controls,
    children,
    __experimentalShareWithChildBlocks = false
  } = _ref;
  const Fill = useBlockControlsFill(group, __experimentalShareWithChildBlocks);

  if (!Fill) {
    return null;
  }

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalStyleProvider, {
    document: document
  }, (0,external_wp_element_namespaceObject.createElement)(Fill, null, fillProps => {
    // Children passed to BlockControlsFill will not have access to any
    // React Context whose Provider is part of the BlockControlsSlot tree.
    // So we re-create the Provider in this subtree.
    const value = !(0,external_lodash_namespaceObject.isEmpty)(fillProps) ? fillProps : null;
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToolbarContext.Provider, {
      value: value
    }, group === 'default' && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarGroup, {
      controls: controls
    }), children);
  }));
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-controls/slot.js



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function BlockControlsSlot(_ref) {
  let {
    group = 'default',
    ...props
  } = _ref;
  const accessibleToolbarState = (0,external_wp_element_namespaceObject.useContext)(external_wp_components_namespaceObject.__experimentalToolbarContext);
  const Slot = block_controls_groups[group].Slot;
  const slot = (0,external_wp_components_namespaceObject.__experimentalUseSlot)(Slot.__unstableName);
  const hasFills = Boolean(slot.fills && slot.fills.length);

  if (!hasFills) {
    return null;
  }

  if (group === 'default') {
    return (0,external_wp_element_namespaceObject.createElement)(Slot, _extends({}, props, {
      bubblesVirtually: true,
      fillProps: accessibleToolbarState
    }));
  }

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarGroup, null, (0,external_wp_element_namespaceObject.createElement)(Slot, _extends({}, props, {
    bubblesVirtually: true,
    fillProps: accessibleToolbarState
  })));
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-controls/index.js



/**
 * Internal dependencies
 */


const BlockControls = BlockControlsFill;
BlockControls.Slot = BlockControlsSlot; // This is just here for backward compatibility.

const BlockFormatControls = props => {
  return (0,external_wp_element_namespaceObject.createElement)(BlockControlsFill, _extends({
    group: "inline"
  }, props));
};

BlockFormatControls.Slot = props => {
  return (0,external_wp_element_namespaceObject.createElement)(BlockControlsSlot, _extends({
    group: "inline"
  }, props));
};

/* harmony default export */ var block_controls = (BlockControls);

;// CONCATENATED MODULE: ./packages/icons/build-module/library/align-none.js


/**
 * WordPress dependencies
 */

const alignNone = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M5 15h14V9H5v6zm0 4.8h14v-1.5H5v1.5zM5 4.2v1.5h14V4.2H5z"
}));
/* harmony default export */ var align_none = (alignNone);

;// CONCATENATED MODULE: ./packages/icons/build-module/library/position-left.js


/**
 * WordPress dependencies
 */

const positionLeft = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M4 9v6h14V9H4zm8-4.8H4v1.5h8V4.2zM4 19.8h8v-1.5H4v1.5z"
}));
/* harmony default export */ var position_left = (positionLeft);

;// CONCATENATED MODULE: ./packages/icons/build-module/library/position-center.js


/**
 * WordPress dependencies
 */

const positionCenter = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M7 9v6h10V9H7zM5 19.8h14v-1.5H5v1.5zM5 4.3v1.5h14V4.3H5z"
}));
/* harmony default export */ var position_center = (positionCenter);

;// CONCATENATED MODULE: ./packages/icons/build-module/library/position-right.js


/**
 * WordPress dependencies
 */

const positionRight = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M6 15h14V9H6v6zm6-10.8v1.5h8V4.2h-8zm0 15.6h8v-1.5h-8v1.5z"
}));
/* harmony default export */ var position_right = (positionRight);

;// CONCATENATED MODULE: ./packages/icons/build-module/library/stretch-wide.js


/**
 * WordPress dependencies
 */

const stretchWide = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M5 9v6h14V9H5zm11-4.8H8v1.5h8V4.2zM8 19.8h8v-1.5H8v1.5z"
}));
/* harmony default export */ var stretch_wide = (stretchWide);

;// CONCATENATED MODULE: ./packages/icons/build-module/library/stretch-full-width.js


/**
 * WordPress dependencies
 */

const stretchFullWidth = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M5 4v11h14V4H5zm3 15.8h8v-1.5H8v1.5z"
}));
/* harmony default export */ var stretch_full_width = (stretchFullWidth);

;// CONCATENATED MODULE: ./packages/icons/build-module/library/justify-left.js


/**
 * WordPress dependencies
 */

const justifyLeft = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M9 9v6h11V9H9zM4 20h1.5V4H4v16z"
}));
/* harmony default export */ var justify_left = (justifyLeft);

;// CONCATENATED MODULE: ./packages/icons/build-module/library/justify-center.js


/**
 * WordPress dependencies
 */

const justifyCenter = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M20 9h-7.2V4h-1.6v5H4v6h7.2v5h1.6v-5H20z"
}));
/* harmony default export */ var justify_center = (justifyCenter);

;// CONCATENATED MODULE: ./packages/icons/build-module/library/justify-right.js


/**
 * WordPress dependencies
 */

const justifyRight = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M4 15h11V9H4v6zM18.5 4v16H20V4h-1.5z"
}));
/* harmony default export */ var justify_right = (justifyRight);

;// CONCATENATED MODULE: ./packages/icons/build-module/library/justify-space-between.js


/**
 * WordPress dependencies
 */

const justifySpaceBetween = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M9 15h6V9H9v6zm-5 5h1.5V4H4v16zM18.5 4v16H20V4h-1.5z"
}));
/* harmony default export */ var justify_space_between = (justifySpaceBetween);

;// CONCATENATED MODULE: ./packages/icons/build-module/library/arrow-right.js


/**
 * WordPress dependencies
 */

const arrowRight = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M14.3 6.7l-1.1 1.1 4 4H4v1.5h13.3l-4.1 4.4 1.1 1.1 5.8-6.3z"
}));
/* harmony default export */ var arrow_right = (arrowRight);

;// CONCATENATED MODULE: ./packages/icons/build-module/library/arrow-down.js


/**
 * WordPress dependencies
 */

const arrowDown = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M16.2 13.2l-4 4V4h-1.5v13.3l-4.5-4.1-1 1.1 6.2 5.8 5.8-5.8-1-1.1z"
}));
/* harmony default export */ var arrow_down = (arrowDown);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/layouts/utils.js
/**
 * Utility to generate the proper CSS selector for layout styles.
 *
 * @param {string|string[]} selectors - CSS selectors
 * @param {boolean}         append    - string to append.
 *
 * @return {string} - CSS selector.
 */
function appendSelectors(selectors) {
  let append = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  // Ideally we shouldn't need the `.editor-styles-wrapper` increased specificity here
  // The problem though is that we have a `.editor-styles-wrapper p { margin: reset; }` style
  // it's used to reset the default margin added by wp-admin to paragraphs
  // so we need this to be higher speficity otherwise, it won't be applied to paragraphs inside containers
  // When the post editor is fully iframed, this extra classname could be removed.
  return selectors.split(',').map(subselector => `.editor-styles-wrapper ${subselector} ${append}`).join(',');
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/use-setting/index.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



const blockedPaths = ['color', 'border', 'typography', 'spacing'];
const deprecatedFlags = {
  'color.palette': settings => settings.colors === undefined ? undefined : settings.colors,
  'color.gradients': settings => settings.gradients === undefined ? undefined : settings.gradients,
  'color.custom': settings => settings.disableCustomColors === undefined ? undefined : !settings.disableCustomColors,
  'color.customGradient': settings => settings.disableCustomGradients === undefined ? undefined : !settings.disableCustomGradients,
  'typography.fontSizes': settings => settings.fontSizes === undefined ? undefined : settings.fontSizes,
  'typography.customFontSize': settings => settings.disableCustomFontSizes === undefined ? undefined : !settings.disableCustomFontSizes,
  'typography.lineHeight': settings => settings.enableCustomLineHeight,
  'spacing.units': settings => {
    if (settings.enableCustomUnits === undefined) {
      return;
    }

    if (settings.enableCustomUnits === true) {
      return ['px', 'em', 'rem', 'vh', 'vw', '%'];
    }

    return settings.enableCustomUnits;
  },
  'spacing.padding': settings => settings.enableCustomSpacing
};
const prefixedFlags = {
  /*
   * These were only available in the plugin
   * and can be removed when the minimum WordPress version
   * for the plugin is 5.9.
   */
  'border.customColor': 'border.color',
  'border.customStyle': 'border.style',
  'border.customWidth': 'border.width',
  'typography.customFontStyle': 'typography.fontStyle',
  'typography.customFontWeight': 'typography.fontWeight',
  'typography.customLetterSpacing': 'typography.letterSpacing',
  'typography.customTextDecorations': 'typography.textDecoration',
  'typography.customTextTransforms': 'typography.textTransform',

  /*
   * These were part of WordPress 5.8 and we need to keep them.
   */
  'border.customRadius': 'border.radius',
  'spacing.customMargin': 'spacing.margin',
  'spacing.customPadding': 'spacing.padding',
  'typography.customLineHeight': 'typography.lineHeight'
};
/**
 * Remove `custom` prefixes for flags that did not land in 5.8.
 *
 * This provides continued support for `custom` prefixed properties. It will
 * be removed once third party devs have had sufficient time to update themes,
 * plugins, etc.
 *
 * @see https://github.com/WordPress/gutenberg/pull/34485
 *
 * @param {string} path Path to desired value in settings.
 * @return {string}     The value for defined setting.
 */

const removeCustomPrefixes = path => {
  return prefixedFlags[path] || path;
};
/**
 * Hook that retrieves the editor setting.
 * It works with nested objects using by finding the value at path.
 *
 * @param {string} path The path to the setting.
 * @return {any} Returns the value defined for the setting.
 * @example
 * ```js
 * const isEnabled = useSetting( 'typography.dropCap' );
 * ```
 */


function useSetting(path) {
  const {
    name: blockName
  } = useBlockEditContext();
  const setting = (0,external_wp_data_namespaceObject.useSelect)(select => {
    var _get;

    if (blockedPaths.includes(path)) {
      // eslint-disable-next-line no-console
      console.warn('Top level useSetting paths are disabled. Please use a subpath to query the information needed.');
      return undefined;
    }

    const settings = select(store).getSettings(); // 1 - Use __experimental features, if available.
    // We cascade to the all value if the block one is not available.

    const normalizedPath = removeCustomPrefixes(path);
    const defaultsPath = `__experimentalFeatures.${normalizedPath}`;
    const blockPath = `__experimentalFeatures.blocks.${blockName}.${normalizedPath}`;
    const experimentalFeaturesResult = (_get = (0,external_lodash_namespaceObject.get)(settings, blockPath)) !== null && _get !== void 0 ? _get : (0,external_lodash_namespaceObject.get)(settings, defaultsPath);

    if (experimentalFeaturesResult !== undefined) {
      if (external_wp_blocks_namespaceObject.__EXPERIMENTAL_PATHS_WITH_MERGE[normalizedPath]) {
        var _ref, _experimentalFeatures;

        return (_ref = (_experimentalFeatures = experimentalFeaturesResult.custom) !== null && _experimentalFeatures !== void 0 ? _experimentalFeatures : experimentalFeaturesResult.theme) !== null && _ref !== void 0 ? _ref : experimentalFeaturesResult.default;
      }

      return experimentalFeaturesResult;
    } // 2 - Use deprecated settings, otherwise.


    const deprecatedSettingsValue = deprecatedFlags[normalizedPath] ? deprecatedFlags[normalizedPath](settings) : undefined;

    if (deprecatedSettingsValue !== undefined) {
      return deprecatedSettingsValue;
    } // 3 - Fall back for typography.dropCap:
    // This is only necessary to support typography.dropCap.
    // when __experimentalFeatures are not present (core without plugin).
    // To remove when __experimentalFeatures are ported to core.


    return normalizedPath === 'typography.dropCap' ? true : undefined;
  }, [blockName, path]);
  return setting;
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/justify-content-control/ui.js



/**
 * WordPress dependencies
 */



const icons = {
  left: justify_left,
  center: justify_center,
  right: justify_right,
  'space-between': justify_space_between
};

function JustifyContentUI(_ref) {
  let {
    allowedControls = ['left', 'center', 'right', 'space-between'],
    isCollapsed = true,
    onChange,
    value,
    popoverProps,
    isToolbar
  } = _ref;

  // If the control is already selected we want a click
  // again on the control to deselect the item, so we
  // call onChange( undefined )
  const handleClick = next => {
    if (next === value) {
      onChange(undefined);
    } else {
      onChange(next);
    }
  };

  const icon = value ? icons[value] : icons.left;
  const allControls = [{
    name: 'left',
    icon: justify_left,
    title: (0,external_wp_i18n_namespaceObject.__)('Justify items left'),
    isActive: 'left' === value,
    onClick: () => handleClick('left')
  }, {
    name: 'center',
    icon: justify_center,
    title: (0,external_wp_i18n_namespaceObject.__)('Justify items center'),
    isActive: 'center' === value,
    onClick: () => handleClick('center')
  }, {
    name: 'right',
    icon: justify_right,
    title: (0,external_wp_i18n_namespaceObject.__)('Justify items right'),
    isActive: 'right' === value,
    onClick: () => handleClick('right')
  }, {
    name: 'space-between',
    icon: justify_space_between,
    title: (0,external_wp_i18n_namespaceObject.__)('Space between items'),
    isActive: 'space-between' === value,
    onClick: () => handleClick('space-between')
  }];
  const UIComponent = isToolbar ? external_wp_components_namespaceObject.ToolbarGroup : external_wp_components_namespaceObject.ToolbarDropdownMenu;
  const extraProps = isToolbar ? {
    isCollapsed
  } : {};
  return (0,external_wp_element_namespaceObject.createElement)(UIComponent, _extends({
    icon: icon,
    popoverProps: popoverProps,
    label: (0,external_wp_i18n_namespaceObject.__)('Change items justification'),
    controls: allControls.filter(elem => allowedControls.includes(elem.name))
  }, extraProps));
}

/* harmony default export */ var ui = (JustifyContentUI);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/justify-content-control/index.js



/**
 * Internal dependencies
 */

function JustifyContentControl(props) {
  return (0,external_wp_element_namespaceObject.createElement)(ui, _extends({}, props, {
    isToolbar: false
  }));
}
function JustifyToolbar(props) {
  return (0,external_wp_element_namespaceObject.createElement)(ui, _extends({}, props, {
    isToolbar: true
  }));
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/layouts/flex.js


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



 // Used with the default, horizontal flex orientation.

const justifyContentMap = {
  left: 'flex-start',
  right: 'flex-end',
  center: 'center',
  'space-between': 'space-between'
}; // Used with the vertical (column) flex orientation.

const alignItemsMap = {
  left: 'flex-start',
  right: 'flex-end',
  center: 'center'
};
const flexWrapOptions = ['wrap', 'nowrap'];
/* harmony default export */ var flex = ({
  name: 'flex',
  label: (0,external_wp_i18n_namespaceObject.__)('Flex'),
  inspectorControls: function FlexLayoutInspectorControls(_ref) {
    let {
      layout = {},
      onChange
    } = _ref;
    const {
      allowOrientation = true
    } = layout;
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Flex, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.FlexItem, null, (0,external_wp_element_namespaceObject.createElement)(FlexLayoutJustifyContentControl, {
      layout: layout,
      onChange: onChange
    })), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.FlexItem, null, allowOrientation && (0,external_wp_element_namespaceObject.createElement)(OrientationControl, {
      layout: layout,
      onChange: onChange
    }))), (0,external_wp_element_namespaceObject.createElement)(FlexWrapControl, {
      layout: layout,
      onChange: onChange
    }));
  },
  toolBarControls: function FlexLayoutToolbarControls(_ref2) {
    let {
      layout = {},
      onChange,
      layoutBlockSupport
    } = _ref2;

    if (layoutBlockSupport !== null && layoutBlockSupport !== void 0 && layoutBlockSupport.allowSwitching) {
      return null;
    }

    return (0,external_wp_element_namespaceObject.createElement)(block_controls, {
      group: "block",
      __experimentalShareWithChildBlocks: true
    }, (0,external_wp_element_namespaceObject.createElement)(FlexLayoutJustifyContentControl, {
      layout: layout,
      onChange: onChange,
      isToolbar: true
    }));
  },
  save: function FlexLayoutStyle(_ref3) {
    var _style$spacing$blockG, _style$spacing;

    let {
      selector,
      layout,
      style
    } = _ref3;
    const {
      orientation = 'horizontal'
    } = layout;
    const blockGapSupport = useSetting('spacing.blockGap');
    const hasBlockGapStylesSupport = blockGapSupport !== null;
    const blockGapValue = (_style$spacing$blockG = style === null || style === void 0 ? void 0 : (_style$spacing = style.spacing) === null || _style$spacing === void 0 ? void 0 : _style$spacing.blockGap) !== null && _style$spacing$blockG !== void 0 ? _style$spacing$blockG : 'var( --wp--style--block-gap, 0.5em )';
    const justifyContent = justifyContentMap[layout.justifyContent] || justifyContentMap.left;
    const flexWrap = flexWrapOptions.includes(layout.flexWrap) ? layout.flexWrap : 'wrap';
    const rowOrientation = `
		flex-direction: row;
		align-items: center;
		justify-content: ${justifyContent};
		`;
    const alignItems = alignItemsMap[layout.justifyContent] || alignItemsMap.left;
    const columnOrientation = `
		flex-direction: column;
		align-items: ${alignItems};
		`;
    return (0,external_wp_element_namespaceObject.createElement)("style", null, `
				${appendSelectors(selector)} {
					display: flex;
					gap: ${hasBlockGapStylesSupport ? blockGapValue : '0.5em'};
					flex-wrap: ${flexWrap};
					${orientation === 'horizontal' ? rowOrientation : columnOrientation}
				}

				${appendSelectors(selector, '> *')} {
					margin: 0;
				}
			`);
  },

  getOrientation(layout) {
    const {
      orientation = 'horizontal'
    } = layout;
    return orientation;
  },

  getAlignments() {
    return [];
  }

});

function FlexLayoutJustifyContentControl(_ref4) {
  let {
    layout,
    onChange,
    isToolbar = false
  } = _ref4;
  const {
    justifyContent = 'left',
    orientation = 'horizontal'
  } = layout;

  const onJustificationChange = value => {
    onChange({ ...layout,
      justifyContent: value
    });
  };

  const allowedControls = ['left', 'center', 'right'];

  if (orientation === 'horizontal') {
    allowedControls.push('space-between');
  }

  if (isToolbar) {
    return (0,external_wp_element_namespaceObject.createElement)(JustifyContentControl, {
      allowedControls: allowedControls,
      value: justifyContent,
      onChange: onJustificationChange,
      popoverProps: {
        position: 'bottom right',
        isAlternate: true
      }
    });
  }

  const justificationOptions = [{
    value: 'left',
    icon: justify_left,
    label: (0,external_wp_i18n_namespaceObject.__)('Justify items left')
  }, {
    value: 'center',
    icon: justify_center,
    label: (0,external_wp_i18n_namespaceObject.__)('Justify items center')
  }, {
    value: 'right',
    icon: justify_right,
    label: (0,external_wp_i18n_namespaceObject.__)('Justify items right')
  }];

  if (orientation === 'horizontal') {
    justificationOptions.push({
      value: 'space-between',
      icon: justify_space_between,
      label: (0,external_wp_i18n_namespaceObject.__)('Space between items')
    });
  }

  return (0,external_wp_element_namespaceObject.createElement)("fieldset", {
    className: "block-editor-hooks__flex-layout-justification-controls"
  }, (0,external_wp_element_namespaceObject.createElement)("legend", null, (0,external_wp_i18n_namespaceObject.__)('Justification')), (0,external_wp_element_namespaceObject.createElement)("div", null, justificationOptions.map(_ref5 => {
    let {
      value,
      icon,
      label
    } = _ref5;
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
      key: value,
      label: label,
      icon: icon,
      isPressed: justifyContent === value,
      onClick: () => onJustificationChange(value)
    });
  })));
}

function FlexWrapControl(_ref6) {
  let {
    layout,
    onChange
  } = _ref6;
  const {
    flexWrap = 'wrap'
  } = layout;
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    label: (0,external_wp_i18n_namespaceObject.__)('Allow to wrap to multiple lines'),
    onChange: value => {
      onChange({ ...layout,
        flexWrap: value ? 'wrap' : 'nowrap'
      });
    },
    checked: flexWrap === 'wrap'
  });
}

function OrientationControl(_ref7) {
  let {
    layout,
    onChange
  } = _ref7;
  const {
    orientation = 'horizontal'
  } = layout;
  return (0,external_wp_element_namespaceObject.createElement)("fieldset", {
    className: "block-editor-hooks__flex-layout-orientation-controls"
  }, (0,external_wp_element_namespaceObject.createElement)("legend", null, (0,external_wp_i18n_namespaceObject.__)('Orientation')), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
    label: 'horizontal',
    icon: arrow_right,
    isPressed: orientation === 'horizontal',
    onClick: () => onChange({ ...layout,
      orientation: 'horizontal'
    })
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
    label: 'vertical',
    icon: arrow_down,
    isPressed: orientation === 'vertical',
    onClick: () => onChange({ ...layout,
      orientation: 'vertical'
    })
  }));
}

;// CONCATENATED MODULE: ./packages/icons/build-module/icon/index.js
/**
 * WordPress dependencies
 */

/** @typedef {{icon: JSX.Element, size?: number} & import('@wordpress/primitives').SVGProps} IconProps */

/**
 * Return an SVG icon.
 *
 * @param {IconProps} props icon is the SVG component to render
 *                          size is a number specifiying the icon size in pixels
 *                          Other props will be passed to wrapped SVG component
 *
 * @return {JSX.Element}  Icon component
 */

function Icon(_ref) {
  let {
    icon,
    size = 24,
    ...props
  } = _ref;
  return (0,external_wp_element_namespaceObject.cloneElement)(icon, {
    width: size,
    height: size,
    ...props
  });
}

/* harmony default export */ var build_module_icon = (Icon);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/layouts/flow.js


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



/* harmony default export */ var flow = ({
  name: 'default',
  label: (0,external_wp_i18n_namespaceObject.__)('Flow'),
  inspectorControls: function DefaultLayoutInspectorControls(_ref) {
    let {
      layout,
      onChange
    } = _ref;
    const {
      wideSize,
      contentSize
    } = layout;
    const units = (0,external_wp_components_namespaceObject.__experimentalUseCustomUnits)({
      availableUnits: useSetting('spacing.units') || ['%', 'px', 'em', 'rem', 'vw']
    });
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)("div", {
      className: "block-editor-hooks__layout-controls"
    }, (0,external_wp_element_namespaceObject.createElement)("div", {
      className: "block-editor-hooks__layout-controls-unit"
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalUnitControl, {
      label: (0,external_wp_i18n_namespaceObject.__)('Content'),
      labelPosition: "top",
      __unstableInputWidth: "80px",
      value: contentSize || wideSize || '',
      onChange: nextWidth => {
        nextWidth = 0 > parseFloat(nextWidth) ? '0' : nextWidth;
        onChange({ ...layout,
          contentSize: nextWidth
        });
      },
      units: units
    }), (0,external_wp_element_namespaceObject.createElement)(build_module_icon, {
      icon: position_center
    })), (0,external_wp_element_namespaceObject.createElement)("div", {
      className: "block-editor-hooks__layout-controls-unit"
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalUnitControl, {
      label: (0,external_wp_i18n_namespaceObject.__)('Wide'),
      labelPosition: "top",
      __unstableInputWidth: "80px",
      value: wideSize || contentSize || '',
      onChange: nextWidth => {
        nextWidth = 0 > parseFloat(nextWidth) ? '0' : nextWidth;
        onChange({ ...layout,
          wideSize: nextWidth
        });
      },
      units: units
    }), (0,external_wp_element_namespaceObject.createElement)(build_module_icon, {
      icon: stretch_wide
    }))), (0,external_wp_element_namespaceObject.createElement)("div", {
      className: "block-editor-hooks__layout-controls-reset"
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
      variant: "secondary",
      isSmall: true,
      disabled: !contentSize && !wideSize,
      onClick: () => onChange({
        contentSize: undefined,
        wideSize: undefined,
        inherit: false
      })
    }, (0,external_wp_i18n_namespaceObject.__)('Reset'))), (0,external_wp_element_namespaceObject.createElement)("p", {
      className: "block-editor-hooks__layout-controls-helptext"
    }, (0,external_wp_i18n_namespaceObject.__)('Customize the width for all elements that are assigned to the center or wide columns.')));
  },
  toolBarControls: function DefaultLayoutToolbarControls() {
    return null;
  },
  save: function DefaultLayoutStyle(_ref2) {
    var _style$spacing$blockG, _style$spacing;

    let {
      selector,
      layout = {},
      style
    } = _ref2;
    const {
      contentSize,
      wideSize
    } = layout;
    const blockGapSupport = useSetting('spacing.blockGap');
    const hasBlockGapStylesSupport = blockGapSupport !== null;
    const blockGapValue = (_style$spacing$blockG = style === null || style === void 0 ? void 0 : (_style$spacing = style.spacing) === null || _style$spacing === void 0 ? void 0 : _style$spacing.blockGap) !== null && _style$spacing$blockG !== void 0 ? _style$spacing$blockG : 'var( --wp--style--block-gap )';
    let output = !!contentSize || !!wideSize ? `
					${appendSelectors(selector, '> :where(:not(.alignleft):not(.alignright))')} {
						max-width: ${contentSize !== null && contentSize !== void 0 ? contentSize : wideSize};
						margin-left: auto !important;
						margin-right: auto !important;
					}

					${appendSelectors(selector, '> .alignwide')}  {
						max-width: ${wideSize !== null && wideSize !== void 0 ? wideSize : contentSize};
					}

					${appendSelectors(selector, '> .alignfull')} {
						max-width: none;
					}
				` : '';
    output += `
			${appendSelectors(selector, '> .alignleft')} {
				float: left;
				margin-right: 2em;
				margin-left: 0;
			}

			${appendSelectors(selector, '> .alignright')} {
				float: right;
				margin-left: 2em;
				margin-right: 0;
			}

		`;

    if (hasBlockGapStylesSupport) {
      output += `
				${appendSelectors(selector, '> *')} {
					margin-top: 0;
					margin-bottom: 0;
				}
				${appendSelectors(selector, '> * + *')} {
					margin-top: ${blockGapValue};
				}
			`;
    }

    return (0,external_wp_element_namespaceObject.createElement)("style", null, output);
  },

  getOrientation() {
    return 'vertical';
  },

  getAlignments(layout) {
    const alignmentInfo = getAlignmentsInfo(layout);

    if (layout.alignments !== undefined) {
      if (!layout.alignments.includes('none')) {
        layout.alignments.unshift('none');
      }

      return layout.alignments.map(alignment => ({
        name: alignment,
        info: alignmentInfo[alignment]
      }));
    }

    const {
      contentSize,
      wideSize
    } = layout;
    const alignments = [{
      name: 'left'
    }, {
      name: 'center'
    }, {
      name: 'right'
    }];

    if (contentSize) {
      alignments.unshift({
        name: 'full'
      });
    }

    if (wideSize) {
      alignments.unshift({
        name: 'wide',
        info: alignmentInfo.wide
      });
    }

    alignments.unshift({
      name: 'none',
      info: alignmentInfo.none
    });
    return alignments;
  }

});
/**
 * Helper method to assign contextual info to clarify
 * alignment settings.
 *
 * Besides checking if `contentSize` and `wideSize` have a
 * value, we now show this information only if their values
 * are not a `css var`. This needs to change when parsing
 * css variables land.
 *
 * @see https://github.com/WordPress/gutenberg/pull/34710#issuecomment-918000752
 *
 * @param {Object} layout The layout object.
 * @return {Object} An object with contextual info per alignment.
 */

function getAlignmentsInfo(layout) {
  const {
    contentSize,
    wideSize
  } = layout;
  const alignmentInfo = {};
  const sizeRegex = /^(?!0)\d+(px|em|rem|vw|vh|%)?$/i;

  if (sizeRegex.test(contentSize)) {
    // translators: %s: container size (i.e. 600px etc)
    alignmentInfo.none = (0,external_wp_i18n_namespaceObject.sprintf)((0,external_wp_i18n_namespaceObject.__)('Max %s wide'), contentSize);
  }

  if (sizeRegex.test(wideSize)) {
    // translators: %s: container size (i.e. 600px etc)
    alignmentInfo.wide = (0,external_wp_i18n_namespaceObject.sprintf)((0,external_wp_i18n_namespaceObject.__)('Max %s wide'), wideSize);
  }

  return alignmentInfo;
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/layouts/index.js
/**
 * Internal dependencies
 */


const layoutTypes = [flow, flex];
/**
 * Retrieves a layout type by name.
 *
 * @param {string} name - The name of the layout type.
 * @return {Object} Layout type.
 */

function getLayoutType() {
  let name = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'default';
  return layoutTypes.find(layoutType => layoutType.name === name);
}
/**
 * Retrieves the available layout types.
 *
 * @return {Array} Layout types.
 */

function getLayoutTypes() {
  return layoutTypes;
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-list/layout.js



/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


const defaultLayout = {
  type: 'default'
};
const Layout = (0,external_wp_element_namespaceObject.createContext)(defaultLayout);
/**
 * Allows to define the layout.
 */

const LayoutProvider = Layout.Provider;
/**
 * React hook used to retrieve the layout config.
 */

function useLayout() {
  return (0,external_wp_element_namespaceObject.useContext)(Layout);
}
function LayoutStyle(_ref) {
  let {
    layout = {},
    ...props
  } = _ref;
  const layoutType = getLayoutType(layout.type);

  if (layoutType) {
    return (0,external_wp_element_namespaceObject.createElement)(layoutType.save, _extends({
      layout: layout
    }, props));
  }

  return null;
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-alignment-control/use-available-alignments.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */




const DEFAULT_CONTROLS = ['none', 'left', 'center', 'right', 'wide', 'full'];
const WIDE_CONTROLS = ['wide', 'full'];
function useAvailableAlignments() {
  let controls = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : DEFAULT_CONTROLS;

  // Always add the `none` option if not exists.
  if (!controls.includes('none')) {
    controls = ['none', ...controls];
  }

  const {
    wideControlsEnabled = false,
    themeSupportsLayout
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getSettings
    } = select(store);
    const settings = getSettings();
    return {
      wideControlsEnabled: settings.alignWide,
      themeSupportsLayout: settings.supportsLayout
    };
  }, []);
  const layout = useLayout();
  const layoutType = getLayoutType(layout === null || layout === void 0 ? void 0 : layout.type);
  const layoutAlignments = layoutType.getAlignments(layout);

  if (themeSupportsLayout) {
    const alignments = layoutAlignments.filter(_ref => {
      let {
        name: alignmentName
      } = _ref;
      return controls.includes(alignmentName);
    }); // While we treat `none` as an alignment, we shouldn't return it if no
    // other alignments exist.

    if (alignments.length === 1 && alignments[0].name === 'none') {
      return [];
    }

    return alignments;
  } // Starting here, it's the fallback for themes not supporting the layout config.


  if (layoutType.name !== 'default') {
    return [];
  }

  const {
    alignments: availableAlignments = DEFAULT_CONTROLS
  } = layout;
  const enabledControls = controls.filter(control => (layout.alignments || // Ignore the global wideAlignment check if the layout explicitely defines alignments.
  wideControlsEnabled || !WIDE_CONTROLS.includes(control)) && availableAlignments.includes(control)).map(enabledControl => ({
    name: enabledControl
  })); // While we treat `none` as an alignment, we shouldn't return it if no
  // other alignments exist.

  if (enabledControls.length === 1 && enabledControls[0].name === 'none') {
    return [];
  }

  return enabledControls;
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-alignment-control/ui.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */


const BLOCK_ALIGNMENTS_CONTROLS = {
  none: {
    icon: align_none,
    title: (0,external_wp_i18n_namespaceObject.__)('None')
  },
  left: {
    icon: position_left,
    title: (0,external_wp_i18n_namespaceObject.__)('Align left')
  },
  center: {
    icon: position_center,
    title: (0,external_wp_i18n_namespaceObject.__)('Align center')
  },
  right: {
    icon: position_right,
    title: (0,external_wp_i18n_namespaceObject.__)('Align right')
  },
  wide: {
    icon: stretch_wide,
    title: (0,external_wp_i18n_namespaceObject.__)('Wide width')
  },
  full: {
    icon: stretch_full_width,
    title: (0,external_wp_i18n_namespaceObject.__)('Full width')
  }
};
const DEFAULT_CONTROL = 'none';
const POPOVER_PROPS = {
  isAlternate: true
};

function BlockAlignmentUI(_ref) {
  let {
    value,
    onChange,
    controls,
    isToolbar,
    isCollapsed = true
  } = _ref;
  const enabledControls = useAvailableAlignments(controls);
  const hasEnabledControls = !!enabledControls.length;

  if (!hasEnabledControls) {
    return null;
  }

  function onChangeAlignment(align) {
    onChange([value, 'none'].includes(align) ? undefined : align);
  }

  const activeAlignmentControl = BLOCK_ALIGNMENTS_CONTROLS[value];
  const defaultAlignmentControl = BLOCK_ALIGNMENTS_CONTROLS[DEFAULT_CONTROL];
  const UIComponent = isToolbar ? external_wp_components_namespaceObject.ToolbarGroup : external_wp_components_namespaceObject.ToolbarDropdownMenu;
  const commonProps = {
    popoverProps: POPOVER_PROPS,
    icon: activeAlignmentControl ? activeAlignmentControl.icon : defaultAlignmentControl.icon,
    label: (0,external_wp_i18n_namespaceObject.__)('Align'),
    toggleProps: {
      describedBy: (0,external_wp_i18n_namespaceObject.__)('Change alignment')
    }
  };
  const extraProps = isToolbar || external_wp_element_namespaceObject.Platform.isNative ? {
    isCollapsed: isToolbar ? isCollapsed : undefined,
    controls: enabledControls.map(_ref2 => {
      let {
        name: controlName
      } = _ref2;
      return { ...BLOCK_ALIGNMENTS_CONTROLS[controlName],
        isActive: value === controlName || !value && controlName === 'none',
        role: isCollapsed ? 'menuitemradio' : undefined,
        onClick: () => onChangeAlignment(controlName)
      };
    })
  } : {
    children: _ref3 => {
      let {
        onClose
      } = _ref3;
      return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuGroup, {
        className: "block-editor-block-alignment-control__menu-group"
      }, enabledControls.map(_ref4 => {
        let {
          name: controlName,
          info
        } = _ref4;
        const {
          icon,
          title
        } = BLOCK_ALIGNMENTS_CONTROLS[controlName]; // If no value is provided, mark as selected the `none` option.

        const isSelected = controlName === value || !value && controlName === 'none';
        return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuItem, {
          key: controlName,
          icon: icon,
          iconPosition: "left",
          className: classnames_default()('components-dropdown-menu__menu-item', {
            'is-active': isSelected
          }),
          isSelected: isSelected,
          onClick: () => {
            onChangeAlignment(controlName);
            onClose();
          },
          role: "menuitemradio",
          info: info
        }, title);
      })));
    }
  };
  return (0,external_wp_element_namespaceObject.createElement)(UIComponent, _extends({}, commonProps, extraProps));
}

/* harmony default export */ var block_alignment_control_ui = (BlockAlignmentUI);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-alignment-control/index.js



/**
 * Internal dependencies
 */

function BlockAlignmentControl(props) {
  return (0,external_wp_element_namespaceObject.createElement)(block_alignment_control_ui, _extends({}, props, {
    isToolbar: false
  }));
}
function BlockAlignmentToolbar(props) {
  return (0,external_wp_element_namespaceObject.createElement)(block_alignment_control_ui, _extends({}, props, {
    isToolbar: true
  }));
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/hooks/align.js



/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */



/**
 * An array which includes all possible valid alignments,
 * used to validate if an alignment is valid or not.
 *
 * @constant
 * @type {string[]}
 */

const ALL_ALIGNMENTS = ['left', 'center', 'right', 'wide', 'full'];
/**
 * An array which includes all wide alignments.
 * In order for this alignments to be valid they need to be supported by the block,
 * and by the theme.
 *
 * @constant
 * @type {string[]}
 */

const WIDE_ALIGNMENTS = ['wide', 'full'];
/**
 * Returns the valid alignments.
 * Takes into consideration the aligns supported by a block, if the block supports wide controls or not and if theme supports wide controls or not.
 * Exported just for testing purposes, not exported outside the module.
 *
 * @param {?boolean|string[]} blockAlign          Aligns supported by the block.
 * @param {?boolean}          hasWideBlockSupport True if block supports wide alignments. And False otherwise.
 * @param {?boolean}          hasWideEnabled      True if theme supports wide alignments. And False otherwise.
 *
 * @return {string[]} Valid alignments.
 */

function getValidAlignments(blockAlign) {
  let hasWideBlockSupport = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
  let hasWideEnabled = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
  let validAlignments;

  if (Array.isArray(blockAlign)) {
    validAlignments = ALL_ALIGNMENTS.filter(value => blockAlign.includes(value));
  } else if (blockAlign === true) {
    // `true` includes all alignments...
    validAlignments = [...ALL_ALIGNMENTS];
  } else {
    validAlignments = [];
  }

  if (!hasWideEnabled || blockAlign === true && !hasWideBlockSupport) {
    return (0,external_lodash_namespaceObject.without)(validAlignments, ...WIDE_ALIGNMENTS);
  }

  return validAlignments;
}
/**
 * Filters registered block settings, extending attributes to include `align`.
 *
 * @param {Object} settings Original block settings.
 *
 * @return {Object} Filtered block settings.
 */

function addAttribute(settings) {
  // Allow blocks to specify their own attribute definition with default values if needed.
  if ((0,external_lodash_namespaceObject.has)(settings.attributes, ['align', 'type'])) {
    return settings;
  }

  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(settings, 'align')) {
    // Gracefully handle if settings.attributes is undefined.
    settings.attributes = { ...settings.attributes,
      align: {
        type: 'string',
        // Allow for '' since it is used by updateAlignment function
        // in withToolbarControls for special cases with defined default values.
        enum: [...ALL_ALIGNMENTS, '']
      }
    };
  }

  return settings;
}
/**
 * Override the default edit UI to include new toolbar controls for block
 * alignment, if block defines support.
 *
 * @param {Function} BlockEdit Original component.
 *
 * @return {Function} Wrapped component.
 */

const withToolbarControls = (0,external_wp_compose_namespaceObject.createHigherOrderComponent)(BlockEdit => props => {
  const {
    name: blockName
  } = props; // Compute the block valid alignments by taking into account,
  // if the theme supports wide alignments or not and the layout's
  // availble alignments. We do that for conditionally rendering
  // Slot.

  const blockAllowedAlignments = getValidAlignments((0,external_wp_blocks_namespaceObject.getBlockSupport)(blockName, 'align'), (0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockName, 'alignWide', true));
  const validAlignments = useAvailableAlignments(blockAllowedAlignments).map(_ref => {
    let {
      name
    } = _ref;
    return name;
  });

  const updateAlignment = nextAlign => {
    if (!nextAlign) {
      var _blockType$attributes, _blockType$attributes2;

      const blockType = (0,external_wp_blocks_namespaceObject.getBlockType)(props.name);
      const blockDefaultAlign = blockType === null || blockType === void 0 ? void 0 : (_blockType$attributes = blockType.attributes) === null || _blockType$attributes === void 0 ? void 0 : (_blockType$attributes2 = _blockType$attributes.align) === null || _blockType$attributes2 === void 0 ? void 0 : _blockType$attributes2.default;

      if (blockDefaultAlign) {
        nextAlign = '';
      }
    }

    props.setAttributes({
      align: nextAlign
    });
  };

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, !!validAlignments.length && (0,external_wp_element_namespaceObject.createElement)(block_controls, {
    group: "block",
    __experimentalShareWithChildBlocks: true
  }, (0,external_wp_element_namespaceObject.createElement)(BlockAlignmentControl, {
    value: props.attributes.align,
    onChange: updateAlignment,
    controls: validAlignments
  })), (0,external_wp_element_namespaceObject.createElement)(BlockEdit, props));
}, 'withToolbarControls');
/**
 * Override the default block element to add alignment wrapper props.
 *
 * @param {Function} BlockListBlock Original component.
 *
 * @return {Function} Wrapped component.
 */

const withDataAlign = (0,external_wp_compose_namespaceObject.createHigherOrderComponent)(BlockListBlock => props => {
  const {
    name,
    attributes
  } = props;
  const {
    align
  } = attributes;
  const blockAllowedAlignments = getValidAlignments((0,external_wp_blocks_namespaceObject.getBlockSupport)(name, 'align'), (0,external_wp_blocks_namespaceObject.hasBlockSupport)(name, 'alignWide', true));
  const validAlignments = useAvailableAlignments(blockAllowedAlignments); // If an alignment is not assigned, there's no need to go through the
  // effort to validate or assign its value.

  if (align === undefined) {
    return (0,external_wp_element_namespaceObject.createElement)(BlockListBlock, props);
  }

  let wrapperProps = props.wrapperProps;

  if (validAlignments.some(alignment => alignment.name === align)) {
    wrapperProps = { ...wrapperProps,
      'data-align': align
    };
  }

  return (0,external_wp_element_namespaceObject.createElement)(BlockListBlock, _extends({}, props, {
    wrapperProps: wrapperProps
  }));
});
/**
 * Override props assigned to save component to inject alignment class name if
 * block supports it.
 *
 * @param {Object} props      Additional props applied to save element.
 * @param {Object} blockType  Block type.
 * @param {Object} attributes Block attributes.
 *
 * @return {Object} Filtered props applied to save element.
 */

function addAssignedAlign(props, blockType, attributes) {
  const {
    align
  } = attributes;
  const blockAlign = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockType, 'align');
  const hasWideBlockSupport = (0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, 'alignWide', true); // Compute valid alignments without taking into account if
  // the theme supports wide alignments or not.
  // This way changing themes does not impact the block save.

  const isAlignValid = getValidAlignments(blockAlign, hasWideBlockSupport).includes(align);

  if (isAlignValid) {
    props.className = classnames_default()(`align${align}`, props.className);
  }

  return props;
}
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.registerBlockType', 'core/align/addAttribute', addAttribute);
(0,external_wp_hooks_namespaceObject.addFilter)('editor.BlockListBlock', 'core/editor/align/with-data-align', withDataAlign);
(0,external_wp_hooks_namespaceObject.addFilter)('editor.BlockEdit', 'core/editor/align/with-toolbar-controls', withToolbarControls);
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.getSaveContent.extraProps', 'core/align/addAssignedAlign', addAssignedAlign);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/hooks/lock.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


/**
 * Filters registered block settings, extending attributes to include `lock`.
 *
 * @param {Object} settings Original block settings.
 *
 * @return {Object} Filtered block settings.
 */

function lock_addAttribute(settings) {
  // Allow blocks to specify their own attribute definition with default values if needed.
  if ((0,external_lodash_namespaceObject.has)(settings.attributes, ['lock', 'type'])) {
    return settings;
  } // Gracefully handle if settings.attributes is undefined.


  settings.attributes = { ...settings.attributes,
    lock: {
      type: 'object'
    }
  };
  return settings;
}
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.registerBlockType', 'core/lock/addAttribute', lock_addAttribute);

;// CONCATENATED MODULE: external ["wp","warning"]
var external_wp_warning_namespaceObject = window["wp"]["warning"];
;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inspector-controls/groups.js
/**
 * WordPress dependencies
 */

const InspectorControlsDefault = (0,external_wp_components_namespaceObject.createSlotFill)('InspectorControls');
const InspectorControlsAdvanced = (0,external_wp_components_namespaceObject.createSlotFill)('InspectorAdvancedControls');
const InspectorControlsBorder = (0,external_wp_components_namespaceObject.createSlotFill)('InspectorControlsBorder');
const InspectorControlsColor = (0,external_wp_components_namespaceObject.createSlotFill)('InspectorControlsColor');
const InspectorControlsDimensions = (0,external_wp_components_namespaceObject.createSlotFill)('InspectorControlsDimensions');
const InspectorControlsTypography = (0,external_wp_components_namespaceObject.createSlotFill)('InspectorControlsTypography');
const groups_groups = {
  default: InspectorControlsDefault,
  advanced: InspectorControlsAdvanced,
  border: InspectorControlsBorder,
  color: InspectorControlsColor,
  dimensions: InspectorControlsDimensions,
  typography: InspectorControlsTypography
};
/* harmony default export */ var inspector_controls_groups = (groups_groups);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inspector-controls/fill.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



function InspectorControlsFill(_ref) {
  var _groups$group;

  let {
    __experimentalGroup: group = 'default',
    children
  } = _ref;
  const isDisplayed = useDisplayBlockControls();
  const Fill = (_groups$group = inspector_controls_groups[group]) === null || _groups$group === void 0 ? void 0 : _groups$group.Fill;

  if (!Fill) {
    typeof process !== "undefined" && process.env && "production" !== "production" ? 0 : void 0;
    return null;
  }

  if (!isDisplayed) {
    return null;
  }

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalStyleProvider, {
    document: document
  }, (0,external_wp_element_namespaceObject.createElement)(Fill, null, fillProps => {
    // Children passed to InspectorControlsFill will not have
    // access to any React Context whose Provider is part of
    // the InspectorControlsSlot tree. So we re-create the
    // Provider in this subtree.
    const value = !(0,external_lodash_namespaceObject.isEmpty)(fillProps) ? fillProps : null;
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToolsPanelContext.Provider, {
      value: value
    }, children);
  }));
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/hooks/utils.js
/**
 * External dependencies
 */

/**
 * Removed falsy values from nested object.
 *
 * @param {*} object
 * @return {*} Object cleaned from falsy values
 */

const cleanEmptyObject = object => {
  if (!(0,external_lodash_namespaceObject.isObject)(object) || Array.isArray(object)) {
    return object;
  }

  const cleanedNestedObjects = (0,external_lodash_namespaceObject.pickBy)((0,external_lodash_namespaceObject.mapValues)(object, cleanEmptyObject), external_lodash_namespaceObject.identity);
  return (0,external_lodash_namespaceObject.isEmpty)(cleanedNestedObjects) ? undefined : cleanedNestedObjects;
};
function immutableSet(object, path, value) {
  return (0,external_lodash_namespaceObject.setWith)(object ? (0,external_lodash_namespaceObject.clone)(object) : {}, path, value, external_lodash_namespaceObject.clone);
}
function transformStyles(activeSupports, migrationPaths, result, source, index, results) {
  var _source$;

  // If there are no active supports return early.
  if ((0,external_lodash_namespaceObject.every)(activeSupports, isActive => !isActive)) {
    return result;
  } // If the condition verifies we are probably in the presence of a wrapping transform
  // e.g: nesting paragraphs in a group or columns and in that case the styles should not be transformed.


  if (results.length === 1 && result.innerBlocks.length === source.length) {
    return result;
  } // For cases where we have a transform from one block to multiple blocks
  // or multiple blocks to one block we apply the styles of the first source block
  // to the result(s).


  let referenceBlockAttributes = (_source$ = source[0]) === null || _source$ === void 0 ? void 0 : _source$.attributes; // If we are in presence of transform between more than one block in the source
  // that has more than one block in the result
  // we apply the styles on source N to the result N,
  // if source N does not exists we do nothing.

  if (results.length > 1 && source.length > 1) {
    if (source[index]) {
      var _source$index;

      referenceBlockAttributes = (_source$index = source[index]) === null || _source$index === void 0 ? void 0 : _source$index.attributes;
    } else {
      return result;
    }
  }

  let returnBlock = result;
  (0,external_lodash_namespaceObject.forEach)(activeSupports, (isActive, support) => {
    if (isActive) {
      migrationPaths[support].forEach(path => {
        const styleValue = (0,external_lodash_namespaceObject.get)(referenceBlockAttributes, path);

        if (styleValue) {
          returnBlock = { ...returnBlock,
            attributes: immutableSet(returnBlock.attributes, path, styleValue)
          };
        }
      });
    }
  });
  return returnBlock;
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inspector-controls/block-support-tools-panel.js


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



function BlockSupportToolsPanel(_ref) {
  let {
    children,
    group,
    label
  } = _ref;
  const {
    updateBlockAttributes
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const {
    getBlockAttributes,
    getMultiSelectedBlockClientIds,
    getSelectedBlockClientId,
    hasMultiSelection
  } = (0,external_wp_data_namespaceObject.useSelect)(store);
  const panelId = getSelectedBlockClientId();
  const resetAll = (0,external_wp_element_namespaceObject.useCallback)(function () {
    let resetFilters = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
    const newAttributes = {};
    const clientIds = hasMultiSelection() ? getMultiSelectedBlockClientIds() : [panelId];
    clientIds.forEach(clientId => {
      const {
        style
      } = getBlockAttributes(clientId);
      let newBlockAttributes = {
        style
      };
      resetFilters.forEach(resetFilter => {
        newBlockAttributes = { ...newBlockAttributes,
          ...resetFilter(newBlockAttributes)
        };
      }); // Enforce a cleaned style object.

      newBlockAttributes = { ...newBlockAttributes,
        style: cleanEmptyObject(newBlockAttributes.style)
      };
      newAttributes[clientId] = newBlockAttributes;
    });
    updateBlockAttributes(clientIds, newAttributes, true);
  }, [cleanEmptyObject, getBlockAttributes, getMultiSelectedBlockClientIds, hasMultiSelection, panelId, updateBlockAttributes]);
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToolsPanel, {
    className: `${group}-block-support-panel`,
    label: label,
    resetAll: resetAll,
    key: panelId,
    panelId: panelId,
    hasInnerWrapper: true,
    shouldRenderPlaceholderItems: true // Required to maintain fills ordering.
    ,
    __experimentalFirstVisibleItemClass: "first",
    __experimentalLastVisibleItemClass: "last"
  }, children);
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inspector-controls/block-support-slot-container.js



/**
 * WordPress dependencies
 */


function BlockSupportSlotContainer(_ref) {
  let {
    Slot,
    ...props
  } = _ref;
  const toolsPanelContext = (0,external_wp_element_namespaceObject.useContext)(external_wp_components_namespaceObject.__experimentalToolsPanelContext);
  return (0,external_wp_element_namespaceObject.createElement)(Slot, _extends({}, props, {
    fillProps: toolsPanelContext,
    bubblesVirtually: true
  }));
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inspector-controls/slot.js



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function InspectorControlsSlot(_ref) {
  var _groups$group;

  let {
    __experimentalGroup: group = 'default',
    label,
    ...props
  } = _ref;
  const Slot = (_groups$group = inspector_controls_groups[group]) === null || _groups$group === void 0 ? void 0 : _groups$group.Slot;
  const slot = (0,external_wp_components_namespaceObject.__experimentalUseSlot)(Slot === null || Slot === void 0 ? void 0 : Slot.__unstableName);

  if (!Slot || !slot) {
    typeof process !== "undefined" && process.env && "production" !== "production" ? 0 : void 0;
    return null;
  }

  const hasFills = Boolean(slot.fills && slot.fills.length);

  if (!hasFills) {
    return null;
  }

  if (label) {
    return (0,external_wp_element_namespaceObject.createElement)(BlockSupportToolsPanel, {
      group: group,
      label: label
    }, (0,external_wp_element_namespaceObject.createElement)(BlockSupportSlotContainer, _extends({}, props, {
      Slot: Slot
    })));
  }

  return (0,external_wp_element_namespaceObject.createElement)(Slot, _extends({}, props, {
    bubblesVirtually: true
  }));
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inspector-controls/index.js



/**
 * Internal dependencies
 */


const InspectorControls = InspectorControlsFill;
InspectorControls.Slot = InspectorControlsSlot; // This is just here for backward compatibility.

const InspectorAdvancedControls = props => {
  return (0,external_wp_element_namespaceObject.createElement)(InspectorControlsFill, _extends({}, props, {
    __experimentalGroup: "advanced"
  }));
};

InspectorAdvancedControls.Slot = props => {
  return (0,external_wp_element_namespaceObject.createElement)(InspectorControlsSlot, _extends({}, props, {
    __experimentalGroup: "advanced"
  }));
};

InspectorAdvancedControls.slotName = 'InspectorAdvancedControls';
/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/inspector-controls/README.md
 */

/* harmony default export */ var inspector_controls = (InspectorControls);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/hooks/anchor.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */







/**
 * Internal dependencies
 */


/**
 * Regular expression matching invalid anchor characters for replacement.
 *
 * @type {RegExp}
 */

const ANCHOR_REGEX = /[\s#]/g;
/**
 * Filters registered block settings, extending attributes with anchor using ID
 * of the first node.
 *
 * @param {Object} settings Original block settings.
 *
 * @return {Object} Filtered block settings.
 */

function anchor_addAttribute(settings) {
  // Allow blocks to specify their own attribute definition with default values if needed.
  if ((0,external_lodash_namespaceObject.has)(settings.attributes, ['anchor', 'type'])) {
    return settings;
  }

  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(settings, 'anchor')) {
    // Gracefully handle if settings.attributes is undefined.
    settings.attributes = { ...settings.attributes,
      anchor: {
        type: 'string',
        source: 'attribute',
        attribute: 'id',
        selector: '*'
      }
    };
  }

  return settings;
}
/**
 * Override the default edit UI to include a new block inspector control for
 * assigning the anchor ID, if block supports anchor.
 *
 * @param {WPComponent} BlockEdit Original component.
 *
 * @return {WPComponent} Wrapped component.
 */

const withInspectorControl = (0,external_wp_compose_namespaceObject.createHigherOrderComponent)(BlockEdit => {
  return props => {
    const hasAnchor = (0,external_wp_blocks_namespaceObject.hasBlockSupport)(props.name, 'anchor');

    if (hasAnchor && props.isSelected) {
      const isWeb = external_wp_element_namespaceObject.Platform.OS === 'web';
      const textControl = (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.TextControl, {
        className: "html-anchor-control",
        label: (0,external_wp_i18n_namespaceObject.__)('HTML anchor'),
        help: (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_i18n_namespaceObject.__)('Enter a word or two — without spaces — to make a unique web address just for this block, called an “anchor.” Then, you’ll be able to link directly to this section of your page.'), isWeb && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ExternalLink, {
          href: (0,external_wp_i18n_namespaceObject.__)('https://wordpress.org/support/article/page-jumps/')
        }, (0,external_wp_i18n_namespaceObject.__)('Learn more about anchors'))),
        value: props.attributes.anchor || '',
        placeholder: !isWeb ? (0,external_wp_i18n_namespaceObject.__)('Add an anchor') : null,
        onChange: nextValue => {
          nextValue = nextValue.replace(ANCHOR_REGEX, '-');
          props.setAttributes({
            anchor: nextValue
          });
        },
        autoCapitalize: "none",
        autoComplete: "off"
      });
      return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(BlockEdit, props), isWeb && (0,external_wp_element_namespaceObject.createElement)(inspector_controls, {
        __experimentalGroup: "advanced"
      }, textControl), !isWeb && props.name === 'core/heading' && (0,external_wp_element_namespaceObject.createElement)(inspector_controls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, {
        title: (0,external_wp_i18n_namespaceObject.__)('Heading settings')
      }, textControl)));
    }

    return (0,external_wp_element_namespaceObject.createElement)(BlockEdit, props);
  };
}, 'withInspectorControl');
/**
 * Override props assigned to save component to inject anchor ID, if block
 * supports anchor. This is only applied if the block's save result is an
 * element and not a markup string.
 *
 * @param {Object} extraProps Additional props applied to save element.
 * @param {Object} blockType  Block type.
 * @param {Object} attributes Current block attributes.
 *
 * @return {Object} Filtered props applied to save element.
 */

function addSaveProps(extraProps, blockType, attributes) {
  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, 'anchor')) {
    extraProps.id = attributes.anchor === '' ? null : attributes.anchor;
  }

  return extraProps;
}
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.registerBlockType', 'core/anchor/attribute', anchor_addAttribute);
(0,external_wp_hooks_namespaceObject.addFilter)('editor.BlockEdit', 'core/editor/anchor/with-inspector-control', withInspectorControl);
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.getSaveContent.extraProps', 'core/anchor/save-props', addSaveProps);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/hooks/custom-class-name.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */


/**
 * Filters registered block settings, extending attributes with anchor using ID
 * of the first node.
 *
 * @param {Object} settings Original block settings.
 *
 * @return {Object} Filtered block settings.
 */

function custom_class_name_addAttribute(settings) {
  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(settings, 'customClassName', true)) {
    // Gracefully handle if settings.attributes is undefined.
    settings.attributes = { ...settings.attributes,
      className: {
        type: 'string'
      }
    };
  }

  return settings;
}
/**
 * Override the default edit UI to include a new block inspector control for
 * assigning the custom class name, if block supports custom class name.
 *
 * @param {WPComponent} BlockEdit Original component.
 *
 * @return {WPComponent} Wrapped component.
 */

const custom_class_name_withInspectorControl = (0,external_wp_compose_namespaceObject.createHigherOrderComponent)(BlockEdit => {
  return props => {
    const hasCustomClassName = (0,external_wp_blocks_namespaceObject.hasBlockSupport)(props.name, 'customClassName', true);

    if (hasCustomClassName && props.isSelected) {
      return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(BlockEdit, props), (0,external_wp_element_namespaceObject.createElement)(inspector_controls, {
        __experimentalGroup: "advanced"
      }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.TextControl, {
        autoComplete: "off",
        label: (0,external_wp_i18n_namespaceObject.__)('Additional CSS class(es)'),
        value: props.attributes.className || '',
        onChange: nextValue => {
          props.setAttributes({
            className: nextValue !== '' ? nextValue : undefined
          });
        },
        help: (0,external_wp_i18n_namespaceObject.__)('Separate multiple classes with spaces.')
      })));
    }

    return (0,external_wp_element_namespaceObject.createElement)(BlockEdit, props);
  };
}, 'withInspectorControl');
/**
 * Override props assigned to save component to inject anchor ID, if block
 * supports anchor. This is only applied if the block's save result is an
 * element and not a markup string.
 *
 * @param {Object} extraProps Additional props applied to save element.
 * @param {Object} blockType  Block type.
 * @param {Object} attributes Current block attributes.
 *
 * @return {Object} Filtered props applied to save element.
 */

function custom_class_name_addSaveProps(extraProps, blockType, attributes) {
  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, 'customClassName', true) && attributes.className) {
    extraProps.className = classnames_default()(extraProps.className, attributes.className);
  }

  return extraProps;
}
function addTransforms(result, source, index, results) {
  if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(result.name, 'customClassName', true)) {
    return result;
  } // If the condition verifies we are probably in the presence of a wrapping transform
  // e.g: nesting paragraphs in a group or columns and in that case the class should not be kept.


  if (results.length === 1 && result.innerBlocks.length === source.length) {
    return result;
  } // If we are transforming one block to multiple blocks or multiple blocks to one block,
  // we ignore the class during the transform.


  if (results.length === 1 && source.length > 1 || results.length > 1 && source.length === 1) {
    return result;
  } // If we are in presence of transform between one or more block in the source
  // that have one or more blocks in the result
  // we apply the class on source N to the result N,
  // if source N does not exists we do nothing.


  if (source[index]) {
    var _source$index;

    const originClassName = (_source$index = source[index]) === null || _source$index === void 0 ? void 0 : _source$index.attributes.className;

    if (originClassName) {
      return { ...result,
        attributes: { ...result.attributes,
          className: originClassName
        }
      };
    }
  }

  return result;
}
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.registerBlockType', 'core/custom-class-name/attribute', custom_class_name_addAttribute);
(0,external_wp_hooks_namespaceObject.addFilter)('editor.BlockEdit', 'core/editor/custom-class-name/with-inspector-control', custom_class_name_withInspectorControl);
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.getSaveContent.extraProps', 'core/custom-class-name/save-props', custom_class_name_addSaveProps);
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.switchToBlockType.transformedBlock', 'core/color/addTransforms', addTransforms);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/hooks/generated-class-name.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Override props assigned to save component to inject generated className if
 * block supports it. This is only applied if the block's save result is an
 * element and not a markup string.
 *
 * @param {Object} extraProps Additional props applied to save element.
 * @param {Object} blockType  Block type.
 *
 * @return {Object} Filtered props applied to save element.
 */

function addGeneratedClassName(extraProps, blockType) {
  // Adding the generated className.
  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, 'className', true)) {
    if (typeof extraProps.className === 'string') {
      // We have some extra classes and want to add the default classname
      // We use uniq to prevent duplicate classnames.
      extraProps.className = (0,external_lodash_namespaceObject.uniq)([(0,external_wp_blocks_namespaceObject.getBlockDefaultClassName)(blockType.name), ...extraProps.className.split(' ')]).join(' ').trim();
    } else {
      // There is no string in the className variable,
      // so we just dump the default name in there.
      extraProps.className = (0,external_wp_blocks_namespaceObject.getBlockDefaultClassName)(blockType.name);
    }
  }

  return extraProps;
}
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.getSaveContent.extraProps', 'core/generated-class-name/save-props', addGeneratedClassName);

;// CONCATENATED MODULE: ./packages/style-engine/build-module/styles/utils.js
/**
 * External dependencies
 */

/**
 * Internal dependencies
 */

function generateBoxRules(style, options, path, ruleKey) {
  const boxStyle = (0,external_lodash_namespaceObject.get)(style, path);

  if (!boxStyle) {
    return [];
  }

  const rules = [];

  if (typeof boxStyle === 'string') {
    rules.push({
      selector: options.selector,
      key: ruleKey,
      value: boxStyle
    });
  } else {
    const sideRules = ['top', 'right', 'bottom', 'left'].reduce((acc, side) => {
      const value = (0,external_lodash_namespaceObject.get)(boxStyle, [side]);

      if (value) {
        acc.push({
          selector: options.selector,
          key: `${ruleKey}${(0,external_lodash_namespaceObject.upperFirst)(side)}`,
          value
        });
      }

      return acc;
    }, []);
    rules.push(...sideRules);
  }

  return rules;
}

;// CONCATENATED MODULE: ./packages/style-engine/build-module/styles/padding.js
/**
 * Internal dependencies
 */

const padding = {
  name: 'padding',
  generate: (style, options) => {
    return generateBoxRules(style, options, ['spacing', 'padding'], 'padding');
  }
};
/* harmony default export */ var styles_padding = (padding);

;// CONCATENATED MODULE: ./packages/style-engine/build-module/styles/index.js
/**
 * Internal dependencies
 */

const styleDefinitions = [styles_padding];

;// CONCATENATED MODULE: ./packages/style-engine/build-module/index.js
/**
 * External dependencies
 */

/**
 * Internal dependencies
 */


/**
 * Generates a stylesheet for a given style object and selector.
 *
 * @param  style   Style object.
 * @param  options Options object with settings to adjust how the styles are generated.
 *
 * @return generated stylesheet.
 */

function generate(style, options) {
  const rules = getCSSRules(style, options);
  const groupedRules = groupBy(rules, 'selector');
  const selectorRules = Object.keys(groupedRules).reduce((acc, subSelector) => {
    acc.push(`${subSelector} { ${groupedRules[subSelector].map(rule => `${kebabCase(rule.key)}: ${rule.value};`).join(' ')} }`);
    return acc;
  }, []);
  return selectorRules.join('\n');
}
/**
 * Returns a JSON representation of the generated CSS rules.
 *
 * @param  style   Style object.
 * @param  options Options object with settings to adjust how the styles are generated.
 *
 * @return generated styles.
 */

function getCSSRules(style, options) {
  const rules = [];
  styleDefinitions.forEach(definition => {
    rules.push(...definition.generate(style, options));
  });
  return rules;
}

;// CONCATENATED MODULE: external ["wp","dom"]
var external_wp_dom_namespaceObject = window["wp"]["dom"];
;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-context/index.js


/**
 * WordPress dependencies
 */

/** @typedef {import('react').ReactNode} ReactNode */

/**
 * @typedef BlockContextProviderProps
 *
 * @property {Record<string,*>} value    Context value to merge with current
 *                                       value.
 * @property {ReactNode}        children Component children.
 */

/** @type {import('react').Context<Record<string,*>>} */

const block_context_Context = (0,external_wp_element_namespaceObject.createContext)({});
/**
 * Component which merges passed value with current consumed block context.
 *
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/block-context/README.md
 *
 * @param {BlockContextProviderProps} props
 */

function BlockContextProvider(_ref) {
  let {
    value,
    children
  } = _ref;
  const context = (0,external_wp_element_namespaceObject.useContext)(block_context_Context);
  const nextValue = (0,external_wp_element_namespaceObject.useMemo)(() => ({ ...context,
    ...value
  }), [context, value]);
  return (0,external_wp_element_namespaceObject.createElement)(block_context_Context.Provider, {
    value: nextValue,
    children: children
  });
}
/* harmony default export */ var block_context = (block_context_Context);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-edit/edit.js



/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


/**
 * Default value used for blocks which do not define their own context needs,
 * used to guarantee that a block's `context` prop will always be an object. It
 * is assigned as a constant since it is always expected to be an empty object,
 * and in order to avoid unnecessary React reconciliations of a changing object.
 *
 * @type {{}}
 */

const DEFAULT_BLOCK_CONTEXT = {};
const Edit = props => {
  const {
    attributes = {},
    name
  } = props;
  const blockType = (0,external_wp_blocks_namespaceObject.getBlockType)(name);
  const blockContext = (0,external_wp_element_namespaceObject.useContext)(block_context); // Assign context values using the block type's declared context needs.

  const context = (0,external_wp_element_namespaceObject.useMemo)(() => {
    return blockType && blockType.usesContext ? (0,external_lodash_namespaceObject.pick)(blockContext, blockType.usesContext) : DEFAULT_BLOCK_CONTEXT;
  }, [blockType, blockContext]);

  if (!blockType) {
    return null;
  } // `edit` and `save` are functions or components describing the markup
  // with which a block is displayed. If `blockType` is valid, assign
  // them preferentially as the render value for the block.


  const Component = blockType.edit || blockType.save;

  if (blockType.apiVersion > 1) {
    return (0,external_wp_element_namespaceObject.createElement)(Component, _extends({}, props, {
      context: context
    }));
  } // Generate a class name for the block's editable form.


  const generatedClassName = (0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, 'className', true) ? (0,external_wp_blocks_namespaceObject.getBlockDefaultClassName)(name) : null;
  const className = classnames_default()(generatedClassName, attributes.className);
  return (0,external_wp_element_namespaceObject.createElement)(Component, _extends({}, props, {
    context: context,
    className: className
  }));
};
/* harmony default export */ var edit = ((0,external_wp_components_namespaceObject.withFilters)('editor.BlockEdit')(Edit));

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-edit/index.js


/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */



/**
 * The `useBlockEditContext` hook provides information about the block this hook is being used in.
 * It returns an object with the `name`, `isSelected` state, and the `clientId` of the block.
 * It is useful if you want to create custom hooks that need access to the current blocks clientId
 * but don't want to rely on the data getting passed in as a parameter.
 *
 * @return {Object} Block edit context
 */


function BlockEdit(props) {
  const {
    name,
    isSelected,
    clientId
  } = props;
  const context = {
    name,
    isSelected,
    clientId
  };
  return (0,external_wp_element_namespaceObject.createElement)(Provider // It is important to return the same object if props haven't
  // changed to avoid  unnecessary rerenders.
  // See https://reactjs.org/docs/context.html#caveats.
  , {
    value: (0,external_wp_element_namespaceObject.useMemo)(() => context, Object.values(context))
  }, (0,external_wp_element_namespaceObject.createElement)(edit, props));
}

;// CONCATENATED MODULE: ./packages/icons/build-module/library/more-horizontal.js


/**
 * WordPress dependencies
 */

const moreHorizontal = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M11 13h2v-2h-2v2zm-6 0h2v-2H5v2zm12-2v2h2v-2h-2z"
}));
/* harmony default export */ var more_horizontal = (moreHorizontal);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/warning/index.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






function Warning(_ref) {
  let {
    className,
    actions,
    children,
    secondaryActions
  } = _ref;
  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: classnames_default()(className, 'block-editor-warning')
  }, (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-warning__contents"
  }, (0,external_wp_element_namespaceObject.createElement)("p", {
    className: "block-editor-warning__message"
  }, children), (external_wp_element_namespaceObject.Children.count(actions) > 0 || secondaryActions) && (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-warning__actions"
  }, external_wp_element_namespaceObject.Children.count(actions) > 0 && external_wp_element_namespaceObject.Children.map(actions, (action, i) => (0,external_wp_element_namespaceObject.createElement)("span", {
    key: i,
    className: "block-editor-warning__action"
  }, action)), secondaryActions && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.DropdownMenu, {
    className: "block-editor-warning__secondary",
    icon: more_horizontal,
    label: (0,external_wp_i18n_namespaceObject.__)('More options'),
    popoverProps: {
      position: 'bottom left',
      className: 'block-editor-warning__dropdown'
    },
    noIcons: true
  }, () => (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuGroup, null, secondaryActions.map((item, pos) => (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuItem, {
    onClick: item.onClick,
    key: pos
  }, item.title)))))));
}
/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/warning/README.md
 */


/* harmony default export */ var warning = (Warning);

// EXTERNAL MODULE: ./node_modules/diff/lib/diff/character.js
var character = __webpack_require__(1973);
;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-compare/block-view.js


/**
 * WordPress dependencies
 */



function BlockView(_ref) {
  let {
    title,
    rawContent,
    renderedContent,
    action,
    actionText,
    className
  } = _ref;
  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: className
  }, (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-block-compare__content"
  }, (0,external_wp_element_namespaceObject.createElement)("h2", {
    className: "block-editor-block-compare__heading"
  }, title), (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-block-compare__html"
  }, rawContent), (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-block-compare__preview edit-post-visual-editor"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.RawHTML, null, (0,external_wp_dom_namespaceObject.safeHTML)(renderedContent)))), (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-block-compare__action"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
    variant: "secondary",
    tabIndex: "0",
    onClick: action
  }, actionText)));
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-compare/index.js


/**
 * External dependencies
 */

 // diff doesn't tree-shake correctly, so we import from the individual
// module here, to avoid including too much of the library


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



function BlockCompare(_ref) {
  let {
    block,
    onKeep,
    onConvert,
    convertor,
    convertButtonText
  } = _ref;

  function getDifference(originalContent, newContent) {
    const difference = (0,character/* diffChars */.Kx)(originalContent, newContent);
    return difference.map((item, pos) => {
      const classes = classnames_default()({
        'block-editor-block-compare__added': item.added,
        'block-editor-block-compare__removed': item.removed
      });
      return (0,external_wp_element_namespaceObject.createElement)("span", {
        key: pos,
        className: classes
      }, item.value);
    });
  }

  function getConvertedContent(convertedBlock) {
    // The convertor may return an array of items or a single item.
    const newBlocks = (0,external_lodash_namespaceObject.castArray)(convertedBlock); // Get converted block details.

    const newContent = newBlocks.map(item => (0,external_wp_blocks_namespaceObject.getSaveContent)(item.name, item.attributes, item.innerBlocks));
    return newContent.join('');
  }

  const converted = getConvertedContent(convertor(block));
  const difference = getDifference(block.originalContent, converted);
  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-block-compare__wrapper"
  }, (0,external_wp_element_namespaceObject.createElement)(BlockView, {
    title: (0,external_wp_i18n_namespaceObject.__)('Current'),
    className: "block-editor-block-compare__current",
    action: onKeep,
    actionText: (0,external_wp_i18n_namespaceObject.__)('Convert to HTML'),
    rawContent: block.originalContent,
    renderedContent: block.originalContent
  }), (0,external_wp_element_namespaceObject.createElement)(BlockView, {
    title: (0,external_wp_i18n_namespaceObject.__)('After Conversion'),
    className: "block-editor-block-compare__converted",
    action: onConvert,
    actionText: convertButtonText,
    rawContent: difference,
    renderedContent: converted
  }));
}

/* harmony default export */ var block_compare = (BlockCompare);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-list/block-invalid-warning.js


/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */




function BlockInvalidWarning(_ref) {
  let {
    convertToHTML,
    convertToBlocks,
    convertToClassic,
    attemptBlockRecovery,
    block
  } = _ref;
  const hasHTMLBlock = !!(0,external_wp_blocks_namespaceObject.getBlockType)('core/html');
  const [compare, setCompare] = (0,external_wp_element_namespaceObject.useState)(false);
  const onCompare = (0,external_wp_element_namespaceObject.useCallback)(() => setCompare(true), []);
  const onCompareClose = (0,external_wp_element_namespaceObject.useCallback)(() => setCompare(false), []); // We memo the array here to prevent the children components from being updated unexpectedly.

  const hiddenActions = (0,external_wp_element_namespaceObject.useMemo)(() => [{
    // translators: Button to fix block content
    title: (0,external_wp_i18n_namespaceObject._x)('Resolve', 'imperative verb'),
    onClick: onCompare
  }, hasHTMLBlock && {
    title: (0,external_wp_i18n_namespaceObject.__)('Convert to HTML'),
    onClick: convertToHTML
  }, {
    title: (0,external_wp_i18n_namespaceObject.__)('Convert to Classic Block'),
    onClick: convertToClassic
  }].filter(Boolean), [onCompare, convertToHTML, convertToClassic]);
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(warning, {
    actions: [(0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
      key: "recover",
      onClick: attemptBlockRecovery,
      variant: "primary"
    }, (0,external_wp_i18n_namespaceObject.__)('Attempt Block Recovery'))],
    secondaryActions: hiddenActions
  }, (0,external_wp_i18n_namespaceObject.__)('This block contains unexpected or invalid content.')), compare && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Modal, {
    title: // translators: Dialog title to fix block content
    (0,external_wp_i18n_namespaceObject.__)('Resolve Block'),
    onRequestClose: onCompareClose,
    className: "block-editor-block-compare"
  }, (0,external_wp_element_namespaceObject.createElement)(block_compare, {
    block: block,
    onKeep: convertToHTML,
    onConvert: convertToBlocks,
    convertor: blockToBlocks,
    convertButtonText: (0,external_wp_i18n_namespaceObject.__)('Convert to Blocks')
  })));
}

const blockToClassic = block => (0,external_wp_blocks_namespaceObject.createBlock)('core/freeform', {
  content: block.originalContent
});

const blockToHTML = block => (0,external_wp_blocks_namespaceObject.createBlock)('core/html', {
  content: block.originalContent
});

const blockToBlocks = block => (0,external_wp_blocks_namespaceObject.rawHandler)({
  HTML: block.originalContent
});

const recoverBlock = _ref2 => {
  let {
    name,
    attributes,
    innerBlocks
  } = _ref2;
  return (0,external_wp_blocks_namespaceObject.createBlock)(name, attributes, innerBlocks);
};

/* harmony default export */ var block_invalid_warning = ((0,external_wp_compose_namespaceObject.compose)([(0,external_wp_data_namespaceObject.withSelect)((select, _ref3) => {
  let {
    clientId
  } = _ref3;
  return {
    block: select(store).getBlock(clientId)
  };
}), (0,external_wp_data_namespaceObject.withDispatch)((dispatch, _ref4) => {
  let {
    block
  } = _ref4;
  const {
    replaceBlock
  } = dispatch(store);
  return {
    convertToClassic() {
      replaceBlock(block.clientId, blockToClassic(block));
    },

    convertToHTML() {
      replaceBlock(block.clientId, blockToHTML(block));
    },

    convertToBlocks() {
      replaceBlock(block.clientId, blockToBlocks(block));
    },

    attemptBlockRecovery() {
      replaceBlock(block.clientId, recoverBlock(block));
    }

  };
})])(BlockInvalidWarning));

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-list/block-crash-warning.js


/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


const block_crash_warning_warning = (0,external_wp_element_namespaceObject.createElement)(warning, {
  className: "block-editor-block-list__block-crash-warning"
}, (0,external_wp_i18n_namespaceObject.__)('This block has encountered an error and cannot be previewed.'));
/* harmony default export */ var block_crash_warning = (() => block_crash_warning_warning);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-list/block-crash-boundary.js
/**
 * WordPress dependencies
 */


class BlockCrashBoundary extends external_wp_element_namespaceObject.Component {
  constructor() {
    super(...arguments);
    this.state = {
      hasError: false
    };
  }

  componentDidCatch() {
    this.setState({
      hasError: true
    });
  }

  render() {
    if (this.state.hasError) {
      return this.props.fallback;
    }

    return this.props.children;
  }

}

/* harmony default export */ var block_crash_boundary = (BlockCrashBoundary);

// EXTERNAL MODULE: ./node_modules/react-autosize-textarea/lib/index.js
var lib = __webpack_require__(773);
;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-list/block-html.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */



function BlockHTML(_ref) {
  let {
    clientId
  } = _ref;
  const [html, setHtml] = (0,external_wp_element_namespaceObject.useState)('');
  const block = (0,external_wp_data_namespaceObject.useSelect)(select => select(store).getBlock(clientId), [clientId]);
  const {
    updateBlock
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);

  const onChange = () => {
    const blockType = (0,external_wp_blocks_namespaceObject.getBlockType)(block.name);

    if (!blockType) {
      return;
    }

    const attributes = (0,external_wp_blocks_namespaceObject.getBlockAttributes)(blockType, html, block.attributes); // If html is empty  we reset the block to the default HTML and mark it as valid to avoid triggering an error

    const content = html ? html : (0,external_wp_blocks_namespaceObject.getSaveContent)(blockType, attributes);
    const isValid = html ? (0,external_wp_blocks_namespaceObject.isValidBlockContent)(blockType, attributes, content) : true;
    updateBlock(clientId, {
      attributes,
      originalContent: content,
      isValid
    }); // Ensure the state is updated if we reset so it displays the default content.

    if (!html) {
      setHtml({
        content
      });
    }
  };

  (0,external_wp_element_namespaceObject.useEffect)(() => {
    setHtml((0,external_wp_blocks_namespaceObject.getBlockContent)(block));
  }, [block]);
  return (0,external_wp_element_namespaceObject.createElement)(lib/* default */.Z, {
    className: "block-editor-block-list__block-html-textarea",
    value: html,
    onBlur: onChange,
    onChange: event => setHtml(event.target.value)
  });
}

/* harmony default export */ var block_html = (BlockHTML);

;// CONCATENATED MODULE: ./node_modules/@react-spring/rafz/dist/react-spring-rafz.esm.js
let updateQueue = makeQueue();
const raf = fn => schedule(fn, updateQueue);
let writeQueue = makeQueue();

raf.write = fn => schedule(fn, writeQueue);

let onStartQueue = makeQueue();

raf.onStart = fn => schedule(fn, onStartQueue);

let onFrameQueue = makeQueue();

raf.onFrame = fn => schedule(fn, onFrameQueue);

let onFinishQueue = makeQueue();

raf.onFinish = fn => schedule(fn, onFinishQueue);

let timeouts = [];

raf.setTimeout = (handler, ms) => {
  let time = raf.now() + ms;

  let cancel = () => {
    let i = timeouts.findIndex(t => t.cancel == cancel);
    if (~i) timeouts.splice(i, 1);
    __raf.count -= ~i ? 1 : 0;
  };

  let timeout = {
    time,
    handler,
    cancel
  };
  timeouts.splice(findTimeout(time), 0, timeout);
  __raf.count += 1;
  start();
  return timeout;
};

let findTimeout = time => ~(~timeouts.findIndex(t => t.time > time) || ~timeouts.length);

raf.cancel = fn => {
  updateQueue.delete(fn);
  writeQueue.delete(fn);
};

raf.sync = fn => {
  sync = true;
  raf.batchedUpdates(fn);
  sync = false;
};

raf.throttle = fn => {
  let lastArgs;

  function queuedFn() {
    try {
      fn(...lastArgs);
    } finally {
      lastArgs = null;
    }
  }

  function throttled(...args) {
    lastArgs = args;
    raf.onStart(queuedFn);
  }

  throttled.handler = fn;

  throttled.cancel = () => {
    onStartQueue.delete(queuedFn);
    lastArgs = null;
  };

  return throttled;
};

let nativeRaf = typeof window != 'undefined' ? window.requestAnimationFrame : () => {};

raf.use = impl => nativeRaf = impl;

raf.now = typeof performance != 'undefined' ? () => performance.now() : Date.now;

raf.batchedUpdates = fn => fn();

raf.catch = console.error;
raf.frameLoop = 'always';

raf.advance = () => {
  if (raf.frameLoop !== 'demand') {
    console.warn('Cannot call the manual advancement of rafz whilst frameLoop is not set as demand');
  } else {
    update();
  }
};

let ts = -1;
let sync = false;

function schedule(fn, queue) {
  if (sync) {
    queue.delete(fn);
    fn(0);
  } else {
    queue.add(fn);
    start();
  }
}

function start() {
  if (ts < 0) {
    ts = 0;

    if (raf.frameLoop !== 'demand') {
      nativeRaf(loop);
    }
  }
}

function loop() {
  if (~ts) {
    nativeRaf(loop);
    raf.batchedUpdates(update);
  }
}

function update() {
  let prevTs = ts;
  ts = raf.now();
  let count = findTimeout(ts);

  if (count) {
    eachSafely(timeouts.splice(0, count), t => t.handler());
    __raf.count -= count;
  }

  onStartQueue.flush();
  updateQueue.flush(prevTs ? Math.min(64, ts - prevTs) : 16.667);
  onFrameQueue.flush();
  writeQueue.flush();
  onFinishQueue.flush();
}

function makeQueue() {
  let next = new Set();
  let current = next;
  return {
    add(fn) {
      __raf.count += current == next && !next.has(fn) ? 1 : 0;
      next.add(fn);
    },

    delete(fn) {
      __raf.count -= current == next && next.has(fn) ? 1 : 0;
      return next.delete(fn);
    },

    flush(arg) {
      if (current.size) {
        next = new Set();
        __raf.count -= current.size;
        eachSafely(current, fn => fn(arg) && next.add(fn));
        __raf.count += next.size;
        current = next;
      }
    }

  };
}

function eachSafely(values, each) {
  values.forEach(value => {
    try {
      each(value);
    } catch (e) {
      raf.catch(e);
    }
  });
}

const __raf = {
  count: 0,

  clear() {
    ts = -1;
    timeouts = [];
    onStartQueue = makeQueue();
    updateQueue = makeQueue();
    onFrameQueue = makeQueue();
    writeQueue = makeQueue();
    onFinishQueue = makeQueue();
    __raf.count = 0;
  }

};



// EXTERNAL MODULE: external "React"
var external_React_ = __webpack_require__(9196);
var external_React_default = /*#__PURE__*/__webpack_require__.n(external_React_);
;// CONCATENATED MODULE: ./node_modules/@react-spring/shared/dist/react-spring-shared.esm.js





function noop() {}
const defineHidden = (obj, key, value) => Object.defineProperty(obj, key, {
  value,
  writable: true,
  configurable: true
});
const react_spring_shared_esm_is = {
  arr: Array.isArray,
  obj: a => !!a && a.constructor.name === 'Object',
  fun: a => typeof a === 'function',
  str: a => typeof a === 'string',
  num: a => typeof a === 'number',
  und: a => a === undefined
};
function isEqual(a, b) {
  if (react_spring_shared_esm_is.arr(a)) {
    if (!react_spring_shared_esm_is.arr(b) || a.length !== b.length) return false;

    for (let i = 0; i < a.length; i++) {
      if (a[i] !== b[i]) return false;
    }

    return true;
  }

  return a === b;
}
const react_spring_shared_esm_each = (obj, fn) => obj.forEach(fn);
function eachProp(obj, fn, ctx) {
  for (const key in obj) {
    if (obj.hasOwnProperty(key)) {
      fn.call(ctx, obj[key], key);
    }
  }
}
const react_spring_shared_esm_toArray = a => react_spring_shared_esm_is.und(a) ? [] : react_spring_shared_esm_is.arr(a) ? a : [a];
function flush(queue, iterator) {
  if (queue.size) {
    const items = Array.from(queue);
    queue.clear();
    react_spring_shared_esm_each(items, iterator);
  }
}
const flushCalls = (queue, ...args) => flush(queue, fn => fn(...args));

let createStringInterpolator$1;
let to;
let colors$1 = null;
let skipAnimation = false;
let willAdvance = noop;
const react_spring_shared_esm_assign = globals => {
  if (globals.to) to = globals.to;
  if (globals.now) raf.now = globals.now;
  if (globals.colors !== undefined) colors$1 = globals.colors;
  if (globals.skipAnimation != null) skipAnimation = globals.skipAnimation;
  if (globals.createStringInterpolator) createStringInterpolator$1 = globals.createStringInterpolator;
  if (globals.requestAnimationFrame) raf.use(globals.requestAnimationFrame);
  if (globals.batchedUpdates) raf.batchedUpdates = globals.batchedUpdates;
  if (globals.willAdvance) willAdvance = globals.willAdvance;
  if (globals.frameLoop) raf.frameLoop = globals.frameLoop;
};

var globals = /*#__PURE__*/Object.freeze({
  __proto__: null,
  get createStringInterpolator () { return createStringInterpolator$1; },
  get to () { return to; },
  get colors () { return colors$1; },
  get skipAnimation () { return skipAnimation; },
  get willAdvance () { return willAdvance; },
  assign: react_spring_shared_esm_assign
});

const startQueue = new Set();
let currentFrame = [];
let prevFrame = [];
let priority = 0;
const frameLoop = {
  get idle() {
    return !startQueue.size && !currentFrame.length;
  },

  start(animation) {
    if (priority > animation.priority) {
      startQueue.add(animation);
      raf.onStart(flushStartQueue);
    } else {
      startSafely(animation);
      raf(advance);
    }
  },

  advance,

  sort(animation) {
    if (priority) {
      raf.onFrame(() => frameLoop.sort(animation));
    } else {
      const prevIndex = currentFrame.indexOf(animation);

      if (~prevIndex) {
        currentFrame.splice(prevIndex, 1);
        startUnsafely(animation);
      }
    }
  },

  clear() {
    currentFrame = [];
    startQueue.clear();
  }

};

function flushStartQueue() {
  startQueue.forEach(startSafely);
  startQueue.clear();
  raf(advance);
}

function startSafely(animation) {
  if (!currentFrame.includes(animation)) startUnsafely(animation);
}

function startUnsafely(animation) {
  currentFrame.splice(findIndex(currentFrame, other => other.priority > animation.priority), 0, animation);
}

function advance(dt) {
  const nextFrame = prevFrame;

  for (let i = 0; i < currentFrame.length; i++) {
    const animation = currentFrame[i];
    priority = animation.priority;

    if (!animation.idle) {
      willAdvance(animation);
      animation.advance(dt);

      if (!animation.idle) {
        nextFrame.push(animation);
      }
    }
  }

  priority = 0;
  prevFrame = currentFrame;
  prevFrame.length = 0;
  currentFrame = nextFrame;
  return currentFrame.length > 0;
}

function findIndex(arr, test) {
  const index = arr.findIndex(test);
  return index < 0 ? arr.length : index;
}

const colors = {
  transparent: 0x00000000,
  aliceblue: 0xf0f8ffff,
  antiquewhite: 0xfaebd7ff,
  aqua: 0x00ffffff,
  aquamarine: 0x7fffd4ff,
  azure: 0xf0ffffff,
  beige: 0xf5f5dcff,
  bisque: 0xffe4c4ff,
  black: 0x000000ff,
  blanchedalmond: 0xffebcdff,
  blue: 0x0000ffff,
  blueviolet: 0x8a2be2ff,
  brown: 0xa52a2aff,
  burlywood: 0xdeb887ff,
  burntsienna: 0xea7e5dff,
  cadetblue: 0x5f9ea0ff,
  chartreuse: 0x7fff00ff,
  chocolate: 0xd2691eff,
  coral: 0xff7f50ff,
  cornflowerblue: 0x6495edff,
  cornsilk: 0xfff8dcff,
  crimson: 0xdc143cff,
  cyan: 0x00ffffff,
  darkblue: 0x00008bff,
  darkcyan: 0x008b8bff,
  darkgoldenrod: 0xb8860bff,
  darkgray: 0xa9a9a9ff,
  darkgreen: 0x006400ff,
  darkgrey: 0xa9a9a9ff,
  darkkhaki: 0xbdb76bff,
  darkmagenta: 0x8b008bff,
  darkolivegreen: 0x556b2fff,
  darkorange: 0xff8c00ff,
  darkorchid: 0x9932ccff,
  darkred: 0x8b0000ff,
  darksalmon: 0xe9967aff,
  darkseagreen: 0x8fbc8fff,
  darkslateblue: 0x483d8bff,
  darkslategray: 0x2f4f4fff,
  darkslategrey: 0x2f4f4fff,
  darkturquoise: 0x00ced1ff,
  darkviolet: 0x9400d3ff,
  deeppink: 0xff1493ff,
  deepskyblue: 0x00bfffff,
  dimgray: 0x696969ff,
  dimgrey: 0x696969ff,
  dodgerblue: 0x1e90ffff,
  firebrick: 0xb22222ff,
  floralwhite: 0xfffaf0ff,
  forestgreen: 0x228b22ff,
  fuchsia: 0xff00ffff,
  gainsboro: 0xdcdcdcff,
  ghostwhite: 0xf8f8ffff,
  gold: 0xffd700ff,
  goldenrod: 0xdaa520ff,
  gray: 0x808080ff,
  green: 0x008000ff,
  greenyellow: 0xadff2fff,
  grey: 0x808080ff,
  honeydew: 0xf0fff0ff,
  hotpink: 0xff69b4ff,
  indianred: 0xcd5c5cff,
  indigo: 0x4b0082ff,
  ivory: 0xfffff0ff,
  khaki: 0xf0e68cff,
  lavender: 0xe6e6faff,
  lavenderblush: 0xfff0f5ff,
  lawngreen: 0x7cfc00ff,
  lemonchiffon: 0xfffacdff,
  lightblue: 0xadd8e6ff,
  lightcoral: 0xf08080ff,
  lightcyan: 0xe0ffffff,
  lightgoldenrodyellow: 0xfafad2ff,
  lightgray: 0xd3d3d3ff,
  lightgreen: 0x90ee90ff,
  lightgrey: 0xd3d3d3ff,
  lightpink: 0xffb6c1ff,
  lightsalmon: 0xffa07aff,
  lightseagreen: 0x20b2aaff,
  lightskyblue: 0x87cefaff,
  lightslategray: 0x778899ff,
  lightslategrey: 0x778899ff,
  lightsteelblue: 0xb0c4deff,
  lightyellow: 0xffffe0ff,
  lime: 0x00ff00ff,
  limegreen: 0x32cd32ff,
  linen: 0xfaf0e6ff,
  magenta: 0xff00ffff,
  maroon: 0x800000ff,
  mediumaquamarine: 0x66cdaaff,
  mediumblue: 0x0000cdff,
  mediumorchid: 0xba55d3ff,
  mediumpurple: 0x9370dbff,
  mediumseagreen: 0x3cb371ff,
  mediumslateblue: 0x7b68eeff,
  mediumspringgreen: 0x00fa9aff,
  mediumturquoise: 0x48d1ccff,
  mediumvioletred: 0xc71585ff,
  midnightblue: 0x191970ff,
  mintcream: 0xf5fffaff,
  mistyrose: 0xffe4e1ff,
  moccasin: 0xffe4b5ff,
  navajowhite: 0xffdeadff,
  navy: 0x000080ff,
  oldlace: 0xfdf5e6ff,
  olive: 0x808000ff,
  olivedrab: 0x6b8e23ff,
  orange: 0xffa500ff,
  orangered: 0xff4500ff,
  orchid: 0xda70d6ff,
  palegoldenrod: 0xeee8aaff,
  palegreen: 0x98fb98ff,
  paleturquoise: 0xafeeeeff,
  palevioletred: 0xdb7093ff,
  papayawhip: 0xffefd5ff,
  peachpuff: 0xffdab9ff,
  peru: 0xcd853fff,
  pink: 0xffc0cbff,
  plum: 0xdda0ddff,
  powderblue: 0xb0e0e6ff,
  purple: 0x800080ff,
  rebeccapurple: 0x663399ff,
  red: 0xff0000ff,
  rosybrown: 0xbc8f8fff,
  royalblue: 0x4169e1ff,
  saddlebrown: 0x8b4513ff,
  salmon: 0xfa8072ff,
  sandybrown: 0xf4a460ff,
  seagreen: 0x2e8b57ff,
  seashell: 0xfff5eeff,
  sienna: 0xa0522dff,
  silver: 0xc0c0c0ff,
  skyblue: 0x87ceebff,
  slateblue: 0x6a5acdff,
  slategray: 0x708090ff,
  slategrey: 0x708090ff,
  snow: 0xfffafaff,
  springgreen: 0x00ff7fff,
  steelblue: 0x4682b4ff,
  tan: 0xd2b48cff,
  teal: 0x008080ff,
  thistle: 0xd8bfd8ff,
  tomato: 0xff6347ff,
  turquoise: 0x40e0d0ff,
  violet: 0xee82eeff,
  wheat: 0xf5deb3ff,
  white: 0xffffffff,
  whitesmoke: 0xf5f5f5ff,
  yellow: 0xffff00ff,
  yellowgreen: 0x9acd32ff
};

const NUMBER = '[-+]?\\d*\\.?\\d+';
const PERCENTAGE = NUMBER + '%';

function call(...parts) {
  return '\\(\\s*(' + parts.join(')\\s*,\\s*(') + ')\\s*\\)';
}

const rgb = new RegExp('rgb' + call(NUMBER, NUMBER, NUMBER));
const rgba = new RegExp('rgba' + call(NUMBER, NUMBER, NUMBER, NUMBER));
const hsl = new RegExp('hsl' + call(NUMBER, PERCENTAGE, PERCENTAGE));
const hsla = new RegExp('hsla' + call(NUMBER, PERCENTAGE, PERCENTAGE, NUMBER));
const hex3 = /^#([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/;
const hex4 = /^#([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/;
const hex6 = /^#([0-9a-fA-F]{6})$/;
const hex8 = /^#([0-9a-fA-F]{8})$/;

function normalizeColor(color) {
  let match;

  if (typeof color === 'number') {
    return color >>> 0 === color && color >= 0 && color <= 0xffffffff ? color : null;
  }

  if (match = hex6.exec(color)) return parseInt(match[1] + 'ff', 16) >>> 0;

  if (colors$1 && colors$1[color] !== undefined) {
    return colors$1[color];
  }

  if (match = rgb.exec(color)) {
    return (parse255(match[1]) << 24 | parse255(match[2]) << 16 | parse255(match[3]) << 8 | 0x000000ff) >>> 0;
  }

  if (match = rgba.exec(color)) {
    return (parse255(match[1]) << 24 | parse255(match[2]) << 16 | parse255(match[3]) << 8 | parse1(match[4])) >>> 0;
  }

  if (match = hex3.exec(color)) {
    return parseInt(match[1] + match[1] + match[2] + match[2] + match[3] + match[3] + 'ff', 16) >>> 0;
  }

  if (match = hex8.exec(color)) return parseInt(match[1], 16) >>> 0;

  if (match = hex4.exec(color)) {
    return parseInt(match[1] + match[1] + match[2] + match[2] + match[3] + match[3] + match[4] + match[4], 16) >>> 0;
  }

  if (match = hsl.exec(color)) {
    return (hslToRgb(parse360(match[1]), parsePercentage(match[2]), parsePercentage(match[3])) | 0x000000ff) >>> 0;
  }

  if (match = hsla.exec(color)) {
    return (hslToRgb(parse360(match[1]), parsePercentage(match[2]), parsePercentage(match[3])) | parse1(match[4])) >>> 0;
  }

  return null;
}

function hue2rgb(p, q, t) {
  if (t < 0) t += 1;
  if (t > 1) t -= 1;
  if (t < 1 / 6) return p + (q - p) * 6 * t;
  if (t < 1 / 2) return q;
  if (t < 2 / 3) return p + (q - p) * (2 / 3 - t) * 6;
  return p;
}

function hslToRgb(h, s, l) {
  const q = l < 0.5 ? l * (1 + s) : l + s - l * s;
  const p = 2 * l - q;
  const r = hue2rgb(p, q, h + 1 / 3);
  const g = hue2rgb(p, q, h);
  const b = hue2rgb(p, q, h - 1 / 3);
  return Math.round(r * 255) << 24 | Math.round(g * 255) << 16 | Math.round(b * 255) << 8;
}

function parse255(str) {
  const int = parseInt(str, 10);
  if (int < 0) return 0;
  if (int > 255) return 255;
  return int;
}

function parse360(str) {
  const int = parseFloat(str);
  return (int % 360 + 360) % 360 / 360;
}

function parse1(str) {
  const num = parseFloat(str);
  if (num < 0) return 0;
  if (num > 1) return 255;
  return Math.round(num * 255);
}

function parsePercentage(str) {
  const int = parseFloat(str);
  if (int < 0) return 0;
  if (int > 100) return 1;
  return int / 100;
}

function colorToRgba(input) {
  let int32Color = normalizeColor(input);
  if (int32Color === null) return input;
  int32Color = int32Color || 0;
  let r = (int32Color & 0xff000000) >>> 24;
  let g = (int32Color & 0x00ff0000) >>> 16;
  let b = (int32Color & 0x0000ff00) >>> 8;
  let a = (int32Color & 0x000000ff) / 255;
  return `rgba(${r}, ${g}, ${b}, ${a})`;
}

const createInterpolator = (range, output, extrapolate) => {
  if (react_spring_shared_esm_is.fun(range)) {
    return range;
  }

  if (react_spring_shared_esm_is.arr(range)) {
    return createInterpolator({
      range,
      output: output,
      extrapolate
    });
  }

  if (react_spring_shared_esm_is.str(range.output[0])) {
    return createStringInterpolator$1(range);
  }

  const config = range;
  const outputRange = config.output;
  const inputRange = config.range || [0, 1];
  const extrapolateLeft = config.extrapolateLeft || config.extrapolate || 'extend';
  const extrapolateRight = config.extrapolateRight || config.extrapolate || 'extend';

  const easing = config.easing || (t => t);

  return input => {
    const range = findRange(input, inputRange);
    return interpolate(input, inputRange[range], inputRange[range + 1], outputRange[range], outputRange[range + 1], easing, extrapolateLeft, extrapolateRight, config.map);
  };
};

function interpolate(input, inputMin, inputMax, outputMin, outputMax, easing, extrapolateLeft, extrapolateRight, map) {
  let result = map ? map(input) : input;

  if (result < inputMin) {
    if (extrapolateLeft === 'identity') return result;else if (extrapolateLeft === 'clamp') result = inputMin;
  }

  if (result > inputMax) {
    if (extrapolateRight === 'identity') return result;else if (extrapolateRight === 'clamp') result = inputMax;
  }

  if (outputMin === outputMax) return outputMin;
  if (inputMin === inputMax) return input <= inputMin ? outputMin : outputMax;
  if (inputMin === -Infinity) result = -result;else if (inputMax === Infinity) result = result - inputMin;else result = (result - inputMin) / (inputMax - inputMin);
  result = easing(result);
  if (outputMin === -Infinity) result = -result;else if (outputMax === Infinity) result = result + outputMin;else result = result * (outputMax - outputMin) + outputMin;
  return result;
}

function findRange(input, inputRange) {
  for (var i = 1; i < inputRange.length - 1; ++i) if (inputRange[i] >= input) break;

  return i - 1;
}

function react_spring_shared_esm_extends() {
  react_spring_shared_esm_extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  return react_spring_shared_esm_extends.apply(this, arguments);
}

const $get = Symbol.for('FluidValue.get');
const $observers = Symbol.for('FluidValue.observers');

const hasFluidValue = arg => Boolean(arg && arg[$get]);

const getFluidValue = arg => arg && arg[$get] ? arg[$get]() : arg;

const getFluidObservers = target => target[$observers] || null;

function callFluidObserver(observer, event) {
  if (observer.eventObserved) {
    observer.eventObserved(event);
  } else {
    observer(event);
  }
}

function callFluidObservers(target, event) {
  let observers = target[$observers];

  if (observers) {
    observers.forEach(observer => {
      callFluidObserver(observer, event);
    });
  }
}

class FluidValue {
  constructor(get) {
    this[$get] = void 0;
    this[$observers] = void 0;

    if (!get && !(get = this.get)) {
      throw Error('Unknown getter');
    }

    setFluidGetter(this, get);
  }

}

const setFluidGetter = (target, get) => setHidden(target, $get, get);

function addFluidObserver(target, observer) {
  if (target[$get]) {
    let observers = target[$observers];

    if (!observers) {
      setHidden(target, $observers, observers = new Set());
    }

    if (!observers.has(observer)) {
      observers.add(observer);

      if (target.observerAdded) {
        target.observerAdded(observers.size, observer);
      }
    }
  }

  return observer;
}

function removeFluidObserver(target, observer) {
  let observers = target[$observers];

  if (observers && observers.has(observer)) {
    const count = observers.size - 1;

    if (count) {
      observers.delete(observer);
    } else {
      target[$observers] = null;
    }

    if (target.observerRemoved) {
      target.observerRemoved(count, observer);
    }
  }
}

const setHidden = (target, key, value) => Object.defineProperty(target, key, {
  value,
  writable: true,
  configurable: true
});

const numberRegex = /[+\-]?(?:0|[1-9]\d*)(?:\.\d*)?(?:[eE][+\-]?\d+)?/g;
const colorRegex = /(#(?:[0-9a-f]{2}){2,4}|(#[0-9a-f]{3})|(rgb|hsl)a?\((-?\d+%?[,\s]+){2,3}\s*[\d\.]+%?\))/gi;
let namedColorRegex;
const rgbaRegex = /rgba\(([0-9\.-]+), ([0-9\.-]+), ([0-9\.-]+), ([0-9\.-]+)\)/gi;

const rgbaRound = (_, p1, p2, p3, p4) => `rgba(${Math.round(p1)}, ${Math.round(p2)}, ${Math.round(p3)}, ${p4})`;

const createStringInterpolator = config => {
  if (!namedColorRegex) namedColorRegex = colors$1 ? new RegExp(`(${Object.keys(colors$1).join('|')})(?!\\w)`, 'g') : /^\b$/;
  const output = config.output.map(value => getFluidValue(value).replace(colorRegex, colorToRgba).replace(namedColorRegex, colorToRgba));
  const keyframes = output.map(value => value.match(numberRegex).map(Number));
  const outputRanges = keyframes[0].map((_, i) => keyframes.map(values => {
    if (!(i in values)) {
      throw Error('The arity of each "output" value must be equal');
    }

    return values[i];
  }));
  const interpolators = outputRanges.map(output => createInterpolator(react_spring_shared_esm_extends({}, config, {
    output
  })));
  return input => {
    let i = 0;
    return output[0].replace(numberRegex, () => String(interpolators[i++](input))).replace(rgbaRegex, rgbaRound);
  };
};

const prefix = 'react-spring: ';

const once = fn => {
  const func = fn;
  let called = false;

  if (typeof func != 'function') {
    throw new TypeError(`${prefix}once requires a function parameter`);
  }

  return (...args) => {
    if (!called) {
      func(...args);
      called = true;
    }
  };
};

const warnInterpolate = once(console.warn);
function react_spring_shared_esm_deprecateInterpolate() {
  warnInterpolate(`${prefix}The "interpolate" function is deprecated in v9 (use "to" instead)`);
}
const warnDirectCall = once(console.warn);
function deprecateDirectCall() {
  warnDirectCall(`${prefix}Directly calling start instead of using the api object is deprecated in v9 (use ".start" instead), this will be removed in later 0.X.0 versions`);
}

function isAnimatedString(value) {
  return react_spring_shared_esm_is.str(value) && (value[0] == '#' || /\d/.test(value) || value in (colors$1 || {}));
}

const react_spring_shared_esm_useOnce = effect => (0,external_React_.useEffect)(effect, emptyDeps);
const emptyDeps = [];

function react_spring_shared_esm_useForceUpdate() {
  const update = (0,external_React_.useState)()[1];
  const mounted = (0,external_React_.useState)(makeMountedRef)[0];
  react_spring_shared_esm_useOnce(mounted.unmount);
  return () => {
    if (mounted.current) {
      update({});
    }
  };
}

function makeMountedRef() {
  const mounted = {
    current: true,
    unmount: () => () => {
      mounted.current = false;
    }
  };
  return mounted;
}

function useMemoOne(getResult, inputs) {
  const [initial] = (0,external_React_.useState)(() => ({
    inputs,
    result: getResult()
  }));
  const committed = (0,external_React_.useRef)();
  const prevCache = committed.current;
  let cache = prevCache;

  if (cache) {
    const useCache = Boolean(inputs && cache.inputs && areInputsEqual(inputs, cache.inputs));

    if (!useCache) {
      cache = {
        inputs,
        result: getResult()
      };
    }
  } else {
    cache = initial;
  }

  (0,external_React_.useEffect)(() => {
    committed.current = cache;

    if (prevCache == initial) {
      initial.inputs = initial.result = undefined;
    }
  }, [cache]);
  return cache.result;
}

function areInputsEqual(next, prev) {
  if (next.length !== prev.length) {
    return false;
  }

  for (let i = 0; i < next.length; i++) {
    if (next[i] !== prev[i]) {
      return false;
    }
  }

  return true;
}

function react_spring_shared_esm_usePrev(value) {
  const prevRef = (0,external_React_.useRef)();
  (0,external_React_.useEffect)(() => {
    prevRef.current = value;
  });
  return prevRef.current;
}

const react_spring_shared_esm_useLayoutEffect = typeof window !== 'undefined' && window.document && window.document.createElement ? external_React_.useLayoutEffect : external_React_.useEffect;



;// CONCATENATED MODULE: ./node_modules/@react-spring/animated/dist/react-spring-animated.esm.js




const $node = Symbol.for('Animated:node');
const isAnimated = value => !!value && value[$node] === value;
const getAnimated = owner => owner && owner[$node];
const setAnimated = (owner, node) => defineHidden(owner, $node, node);
const getPayload = owner => owner && owner[$node] && owner[$node].getPayload();
class Animated {
  constructor() {
    this.payload = void 0;
    setAnimated(this, this);
  }

  getPayload() {
    return this.payload || [];
  }

}

class AnimatedValue extends Animated {
  constructor(_value) {
    super();
    this.done = true;
    this.elapsedTime = void 0;
    this.lastPosition = void 0;
    this.lastVelocity = void 0;
    this.v0 = void 0;
    this.durationProgress = 0;
    this._value = _value;

    if (react_spring_shared_esm_is.num(this._value)) {
      this.lastPosition = this._value;
    }
  }

  static create(value) {
    return new AnimatedValue(value);
  }

  getPayload() {
    return [this];
  }

  getValue() {
    return this._value;
  }

  setValue(value, step) {
    if (react_spring_shared_esm_is.num(value)) {
      this.lastPosition = value;

      if (step) {
        value = Math.round(value / step) * step;

        if (this.done) {
          this.lastPosition = value;
        }
      }
    }

    if (this._value === value) {
      return false;
    }

    this._value = value;
    return true;
  }

  reset() {
    const {
      done
    } = this;
    this.done = false;

    if (react_spring_shared_esm_is.num(this._value)) {
      this.elapsedTime = 0;
      this.durationProgress = 0;
      this.lastPosition = this._value;
      if (done) this.lastVelocity = null;
      this.v0 = null;
    }
  }

}

class AnimatedString extends AnimatedValue {
  constructor(value) {
    super(0);
    this._string = null;
    this._toString = void 0;
    this._toString = createInterpolator({
      output: [value, value]
    });
  }

  static create(value) {
    return new AnimatedString(value);
  }

  getValue() {
    let value = this._string;
    return value == null ? this._string = this._toString(this._value) : value;
  }

  setValue(value) {
    if (react_spring_shared_esm_is.str(value)) {
      if (value == this._string) {
        return false;
      }

      this._string = value;
      this._value = 1;
    } else if (super.setValue(value)) {
      this._string = null;
    } else {
      return false;
    }

    return true;
  }

  reset(goal) {
    if (goal) {
      this._toString = createInterpolator({
        output: [this.getValue(), goal]
      });
    }

    this._value = 0;
    super.reset();
  }

}

const TreeContext = {
  dependencies: null
};

class AnimatedObject extends Animated {
  constructor(source) {
    super();
    this.source = source;
    this.setValue(source);
  }

  getValue(animated) {
    const values = {};
    eachProp(this.source, (source, key) => {
      if (isAnimated(source)) {
        values[key] = source.getValue(animated);
      } else if (hasFluidValue(source)) {
        values[key] = getFluidValue(source);
      } else if (!animated) {
        values[key] = source;
      }
    });
    return values;
  }

  setValue(source) {
    this.source = source;
    this.payload = this._makePayload(source);
  }

  reset() {
    if (this.payload) {
      react_spring_shared_esm_each(this.payload, node => node.reset());
    }
  }

  _makePayload(source) {
    if (source) {
      const payload = new Set();
      eachProp(source, this._addToPayload, payload);
      return Array.from(payload);
    }
  }

  _addToPayload(source) {
    if (TreeContext.dependencies && hasFluidValue(source)) {
      TreeContext.dependencies.add(source);
    }

    const payload = getPayload(source);

    if (payload) {
      react_spring_shared_esm_each(payload, node => this.add(node));
    }
  }

}

class AnimatedArray extends AnimatedObject {
  constructor(source) {
    super(source);
  }

  static create(source) {
    return new AnimatedArray(source);
  }

  getValue() {
    return this.source.map(node => node.getValue());
  }

  setValue(source) {
    const payload = this.getPayload();

    if (source.length == payload.length) {
      return payload.map((node, i) => node.setValue(source[i])).some(Boolean);
    }

    super.setValue(source.map(makeAnimated));
    return true;
  }

}

function makeAnimated(value) {
  const nodeType = isAnimatedString(value) ? AnimatedString : AnimatedValue;
  return nodeType.create(value);
}

function getAnimatedType(value) {
  const parentNode = getAnimated(value);
  return parentNode ? parentNode.constructor : react_spring_shared_esm_is.arr(value) ? AnimatedArray : isAnimatedString(value) ? AnimatedString : AnimatedValue;
}

function react_spring_animated_esm_extends() {
  react_spring_animated_esm_extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  return react_spring_animated_esm_extends.apply(this, arguments);
}

const withAnimated = (Component, host) => {
  const hasInstance = !react_spring_shared_esm_is.fun(Component) || Component.prototype && Component.prototype.isReactComponent;
  return (0,external_React_.forwardRef)((givenProps, givenRef) => {
    const instanceRef = (0,external_React_.useRef)(null);
    const ref = hasInstance && (0,external_React_.useCallback)(value => {
      instanceRef.current = updateRef(givenRef, value);
    }, [givenRef]);
    const [props, deps] = getAnimatedState(givenProps, host);
    const forceUpdate = react_spring_shared_esm_useForceUpdate();

    const callback = () => {
      const instance = instanceRef.current;

      if (hasInstance && !instance) {
        return;
      }

      const didUpdate = instance ? host.applyAnimatedValues(instance, props.getValue(true)) : false;

      if (didUpdate === false) {
        forceUpdate();
      }
    };

    const observer = new PropsObserver(callback, deps);
    const observerRef = (0,external_React_.useRef)();
    react_spring_shared_esm_useLayoutEffect(() => {
      const lastObserver = observerRef.current;
      observerRef.current = observer;
      react_spring_shared_esm_each(deps, dep => addFluidObserver(dep, observer));

      if (lastObserver) {
        react_spring_shared_esm_each(lastObserver.deps, dep => removeFluidObserver(dep, lastObserver));
        raf.cancel(lastObserver.update);
      }
    });
    (0,external_React_.useEffect)(callback, []);
    react_spring_shared_esm_useOnce(() => () => {
      const observer = observerRef.current;
      react_spring_shared_esm_each(observer.deps, dep => removeFluidObserver(dep, observer));
    });
    const usedProps = host.getComponentProps(props.getValue());
    return external_React_.createElement(Component, react_spring_animated_esm_extends({}, usedProps, {
      ref: ref
    }));
  });
};

class PropsObserver {
  constructor(update, deps) {
    this.update = update;
    this.deps = deps;
  }

  eventObserved(event) {
    if (event.type == 'change') {
      raf.write(this.update);
    }
  }

}

function getAnimatedState(props, host) {
  const dependencies = new Set();
  TreeContext.dependencies = dependencies;
  if (props.style) props = react_spring_animated_esm_extends({}, props, {
    style: host.createAnimatedStyle(props.style)
  });
  props = new AnimatedObject(props);
  TreeContext.dependencies = null;
  return [props, dependencies];
}

function updateRef(ref, value) {
  if (ref) {
    if (react_spring_shared_esm_is.fun(ref)) ref(value);else ref.current = value;
  }

  return value;
}

const cacheKey = Symbol.for('AnimatedComponent');
const createHost = (components, {
  applyAnimatedValues: _applyAnimatedValues = () => false,
  createAnimatedStyle: _createAnimatedStyle = style => new AnimatedObject(style),
  getComponentProps: _getComponentProps = props => props
} = {}) => {
  const hostConfig = {
    applyAnimatedValues: _applyAnimatedValues,
    createAnimatedStyle: _createAnimatedStyle,
    getComponentProps: _getComponentProps
  };

  const animated = Component => {
    const displayName = getDisplayName(Component) || 'Anonymous';

    if (react_spring_shared_esm_is.str(Component)) {
      Component = animated[Component] || (animated[Component] = withAnimated(Component, hostConfig));
    } else {
      Component = Component[cacheKey] || (Component[cacheKey] = withAnimated(Component, hostConfig));
    }

    Component.displayName = `Animated(${displayName})`;
    return Component;
  };

  eachProp(components, (Component, key) => {
    if (react_spring_shared_esm_is.arr(components)) {
      key = getDisplayName(Component);
    }

    animated[key] = animated(Component);
  });
  return {
    animated
  };
};

const getDisplayName = arg => react_spring_shared_esm_is.str(arg) ? arg : arg && react_spring_shared_esm_is.str(arg.displayName) ? arg.displayName : react_spring_shared_esm_is.fun(arg) && arg.name || null;



;// CONCATENATED MODULE: ./node_modules/@react-spring/core/dist/react-spring-core.esm.js








function react_spring_core_esm_extends() {
  react_spring_core_esm_extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  return react_spring_core_esm_extends.apply(this, arguments);
}

function callProp(value, ...args) {
  return react_spring_shared_esm_is.fun(value) ? value(...args) : value;
}
const matchProp = (value, key) => value === true || !!(key && value && (react_spring_shared_esm_is.fun(value) ? value(key) : react_spring_shared_esm_toArray(value).includes(key)));
const resolveProp = (prop, key) => react_spring_shared_esm_is.obj(prop) ? key && prop[key] : prop;
const getDefaultProp = (props, key) => props.default === true ? props[key] : props.default ? props.default[key] : undefined;

const noopTransform = value => value;

const getDefaultProps = (props, transform = noopTransform) => {
  let keys = DEFAULT_PROPS;

  if (props.default && props.default !== true) {
    props = props.default;
    keys = Object.keys(props);
  }

  const defaults = {};

  for (const key of keys) {
    const value = transform(props[key], key);

    if (!react_spring_shared_esm_is.und(value)) {
      defaults[key] = value;
    }
  }

  return defaults;
};
const DEFAULT_PROPS = ['config', 'onProps', 'onStart', 'onChange', 'onPause', 'onResume', 'onRest'];
const RESERVED_PROPS = {
  config: 1,
  from: 1,
  to: 1,
  ref: 1,
  loop: 1,
  reset: 1,
  pause: 1,
  cancel: 1,
  reverse: 1,
  immediate: 1,
  default: 1,
  delay: 1,
  onProps: 1,
  onStart: 1,
  onChange: 1,
  onPause: 1,
  onResume: 1,
  onRest: 1,
  onResolve: 1,
  items: 1,
  trail: 1,
  sort: 1,
  expires: 1,
  initial: 1,
  enter: 1,
  update: 1,
  leave: 1,
  children: 1,
  onDestroyed: 1,
  keys: 1,
  callId: 1,
  parentId: 1
};

function getForwardProps(props) {
  const forward = {};
  let count = 0;
  eachProp(props, (value, prop) => {
    if (!RESERVED_PROPS[prop]) {
      forward[prop] = value;
      count++;
    }
  });

  if (count) {
    return forward;
  }
}

function inferTo(props) {
  const to = getForwardProps(props);

  if (to) {
    const out = {
      to
    };
    eachProp(props, (val, key) => key in to || (out[key] = val));
    return out;
  }

  return react_spring_core_esm_extends({}, props);
}
function computeGoal(value) {
  value = getFluidValue(value);
  return react_spring_shared_esm_is.arr(value) ? value.map(computeGoal) : isAnimatedString(value) ? globals.createStringInterpolator({
    range: [0, 1],
    output: [value, value]
  })(1) : value;
}
function hasProps(props) {
  for (const _ in props) return true;

  return false;
}
function isAsyncTo(to) {
  return react_spring_shared_esm_is.fun(to) || react_spring_shared_esm_is.arr(to) && react_spring_shared_esm_is.obj(to[0]);
}
function detachRefs(ctrl, ref) {
  var _ctrl$ref;

  (_ctrl$ref = ctrl.ref) == null ? void 0 : _ctrl$ref.delete(ctrl);
  ref == null ? void 0 : ref.delete(ctrl);
}
function replaceRef(ctrl, ref) {
  if (ref && ctrl.ref !== ref) {
    var _ctrl$ref2;

    (_ctrl$ref2 = ctrl.ref) == null ? void 0 : _ctrl$ref2.delete(ctrl);
    ref.add(ctrl);
    ctrl.ref = ref;
  }
}

function useChain(refs, timeSteps, timeFrame = 1000) {
  useLayoutEffect(() => {
    if (timeSteps) {
      let prevDelay = 0;
      each(refs, (ref, i) => {
        const controllers = ref.current;

        if (controllers.length) {
          let delay = timeFrame * timeSteps[i];
          if (isNaN(delay)) delay = prevDelay;else prevDelay = delay;
          each(controllers, ctrl => {
            each(ctrl.queue, props => {
              const memoizedDelayProp = props.delay;

              props.delay = key => delay + callProp(memoizedDelayProp || 0, key);
            });
            ctrl.start();
          });
        }
      });
    } else {
      let p = Promise.resolve();
      each(refs, ref => {
        const controllers = ref.current;

        if (controllers.length) {
          const queues = controllers.map(ctrl => {
            const q = ctrl.queue;
            ctrl.queue = [];
            return q;
          });
          p = p.then(() => {
            each(controllers, (ctrl, i) => each(queues[i] || [], update => ctrl.queue.push(update)));
            return ref.start();
          });
        }
      });
    }
  });
}

const config = {
  default: {
    tension: 170,
    friction: 26
  },
  gentle: {
    tension: 120,
    friction: 14
  },
  wobbly: {
    tension: 180,
    friction: 12
  },
  stiff: {
    tension: 210,
    friction: 20
  },
  slow: {
    tension: 280,
    friction: 60
  },
  molasses: {
    tension: 280,
    friction: 120
  }
};

const linear = t => t;

const defaults = react_spring_core_esm_extends({}, config.default, {
  mass: 1,
  damping: 1,
  easing: linear,
  clamp: false
});

class AnimationConfig {
  constructor() {
    this.tension = void 0;
    this.friction = void 0;
    this.frequency = void 0;
    this.damping = void 0;
    this.mass = void 0;
    this.velocity = 0;
    this.restVelocity = void 0;
    this.precision = void 0;
    this.progress = void 0;
    this.duration = void 0;
    this.easing = void 0;
    this.clamp = void 0;
    this.bounce = void 0;
    this.decay = void 0;
    this.round = void 0;
    Object.assign(this, defaults);
  }

}
function mergeConfig(config, newConfig, defaultConfig) {
  if (defaultConfig) {
    defaultConfig = react_spring_core_esm_extends({}, defaultConfig);
    sanitizeConfig(defaultConfig, newConfig);
    newConfig = react_spring_core_esm_extends({}, defaultConfig, newConfig);
  }

  sanitizeConfig(config, newConfig);
  Object.assign(config, newConfig);

  for (const key in defaults) {
    if (config[key] == null) {
      config[key] = defaults[key];
    }
  }

  let {
    mass,
    frequency,
    damping
  } = config;

  if (!react_spring_shared_esm_is.und(frequency)) {
    if (frequency < 0.01) frequency = 0.01;
    if (damping < 0) damping = 0;
    config.tension = Math.pow(2 * Math.PI / frequency, 2) * mass;
    config.friction = 4 * Math.PI * damping * mass / frequency;
  }

  return config;
}

function sanitizeConfig(config, props) {
  if (!react_spring_shared_esm_is.und(props.decay)) {
    config.duration = undefined;
  } else {
    const isTensionConfig = !react_spring_shared_esm_is.und(props.tension) || !react_spring_shared_esm_is.und(props.friction);

    if (isTensionConfig || !react_spring_shared_esm_is.und(props.frequency) || !react_spring_shared_esm_is.und(props.damping) || !react_spring_shared_esm_is.und(props.mass)) {
      config.duration = undefined;
      config.decay = undefined;
    }

    if (isTensionConfig) {
      config.frequency = undefined;
    }
  }
}

const emptyArray = [];
class Animation {
  constructor() {
    this.changed = false;
    this.values = emptyArray;
    this.toValues = null;
    this.fromValues = emptyArray;
    this.to = void 0;
    this.from = void 0;
    this.config = new AnimationConfig();
    this.immediate = false;
  }

}

function scheduleProps(callId, {
  key,
  props,
  defaultProps,
  state,
  actions
}) {
  return new Promise((resolve, reject) => {
    var _props$cancel;

    let delay;
    let timeout;
    let cancel = matchProp((_props$cancel = props.cancel) != null ? _props$cancel : defaultProps == null ? void 0 : defaultProps.cancel, key);

    if (cancel) {
      onStart();
    } else {
      if (!react_spring_shared_esm_is.und(props.pause)) {
        state.paused = matchProp(props.pause, key);
      }

      let pause = defaultProps == null ? void 0 : defaultProps.pause;

      if (pause !== true) {
        pause = state.paused || matchProp(pause, key);
      }

      delay = callProp(props.delay || 0, key);

      if (pause) {
        state.resumeQueue.add(onResume);
        actions.pause();
      } else {
        actions.resume();
        onResume();
      }
    }

    function onPause() {
      state.resumeQueue.add(onResume);
      state.timeouts.delete(timeout);
      timeout.cancel();
      delay = timeout.time - raf.now();
    }

    function onResume() {
      if (delay > 0) {
        timeout = raf.setTimeout(onStart, delay);
        state.pauseQueue.add(onPause);
        state.timeouts.add(timeout);
      } else {
        onStart();
      }
    }

    function onStart() {
      state.pauseQueue.delete(onPause);
      state.timeouts.delete(timeout);

      if (callId <= (state.cancelId || 0)) {
        cancel = true;
      }

      try {
        actions.start(react_spring_core_esm_extends({}, props, {
          callId,
          cancel
        }), resolve);
      } catch (err) {
        reject(err);
      }
    }
  });
}

const getCombinedResult = (target, results) => results.length == 1 ? results[0] : results.some(result => result.cancelled) ? getCancelledResult(target.get()) : results.every(result => result.noop) ? getNoopResult(target.get()) : getFinishedResult(target.get(), results.every(result => result.finished));
const getNoopResult = value => ({
  value,
  noop: true,
  finished: true,
  cancelled: false
});
const getFinishedResult = (value, finished, cancelled = false) => ({
  value,
  finished,
  cancelled
});
const getCancelledResult = value => ({
  value,
  cancelled: true,
  finished: false
});

function runAsync(to, props, state, target) {
  const {
    callId,
    parentId,
    onRest
  } = props;
  const {
    asyncTo: prevTo,
    promise: prevPromise
  } = state;

  if (!parentId && to === prevTo && !props.reset) {
    return prevPromise;
  }

  return state.promise = (async () => {
    state.asyncId = callId;
    state.asyncTo = to;
    const defaultProps = getDefaultProps(props, (value, key) => key === 'onRest' ? undefined : value);
    let preventBail;
    let bail;
    const bailPromise = new Promise((resolve, reject) => (preventBail = resolve, bail = reject));

    const bailIfEnded = bailSignal => {
      const bailResult = callId <= (state.cancelId || 0) && getCancelledResult(target) || callId !== state.asyncId && getFinishedResult(target, false);

      if (bailResult) {
        bailSignal.result = bailResult;
        bail(bailSignal);
        throw bailSignal;
      }
    };

    const animate = (arg1, arg2) => {
      const bailSignal = new BailSignal();
      const skipAnimationSignal = new SkipAniamtionSignal();
      return (async () => {
        if (globals.skipAnimation) {
          stopAsync(state);
          skipAnimationSignal.result = getFinishedResult(target, false);
          bail(skipAnimationSignal);
          throw skipAnimationSignal;
        }

        bailIfEnded(bailSignal);
        const props = react_spring_shared_esm_is.obj(arg1) ? react_spring_core_esm_extends({}, arg1) : react_spring_core_esm_extends({}, arg2, {
          to: arg1
        });
        props.parentId = callId;
        eachProp(defaultProps, (value, key) => {
          if (react_spring_shared_esm_is.und(props[key])) {
            props[key] = value;
          }
        });
        const result = await target.start(props);
        bailIfEnded(bailSignal);

        if (state.paused) {
          await new Promise(resume => {
            state.resumeQueue.add(resume);
          });
        }

        return result;
      })();
    };

    let result;

    if (globals.skipAnimation) {
      stopAsync(state);
      return getFinishedResult(target, false);
    }

    try {
      let animating;

      if (react_spring_shared_esm_is.arr(to)) {
        animating = (async queue => {
          for (const props of queue) {
            await animate(props);
          }
        })(to);
      } else {
          animating = Promise.resolve(to(animate, target.stop.bind(target)));
        }

      await Promise.all([animating.then(preventBail), bailPromise]);
      result = getFinishedResult(target.get(), true, false);
    } catch (err) {
      if (err instanceof BailSignal) {
        result = err.result;
      } else if (err instanceof SkipAniamtionSignal) {
        result = err.result;
      } else {
        throw err;
      }
    } finally {
      if (callId == state.asyncId) {
        state.asyncId = parentId;
        state.asyncTo = parentId ? prevTo : undefined;
        state.promise = parentId ? prevPromise : undefined;
      }
    }

    if (react_spring_shared_esm_is.fun(onRest)) {
      raf.batchedUpdates(() => {
        onRest(result, target, target.item);
      });
    }

    return result;
  })();
}
function stopAsync(state, cancelId) {
  flush(state.timeouts, t => t.cancel());
  state.pauseQueue.clear();
  state.resumeQueue.clear();
  state.asyncId = state.asyncTo = state.promise = undefined;
  if (cancelId) state.cancelId = cancelId;
}
class BailSignal extends Error {
  constructor() {
    super('An async animation has been interrupted. You see this error because you ' + 'forgot to use `await` or `.catch(...)` on its returned promise.');
    this.result = void 0;
  }

}
class SkipAniamtionSignal extends Error {
  constructor() {
    super('SkipAnimationSignal');
    this.result = void 0;
  }

}

const isFrameValue = value => value instanceof FrameValue;
let nextId$1 = 1;
class FrameValue extends FluidValue {
  constructor(...args) {
    super(...args);
    this.id = nextId$1++;
    this.key = void 0;
    this._priority = 0;
  }

  get priority() {
    return this._priority;
  }

  set priority(priority) {
    if (this._priority != priority) {
      this._priority = priority;

      this._onPriorityChange(priority);
    }
  }

  get() {
    const node = getAnimated(this);
    return node && node.getValue();
  }

  to(...args) {
    return globals.to(this, args);
  }

  interpolate(...args) {
    react_spring_shared_esm_deprecateInterpolate();
    return globals.to(this, args);
  }

  toJSON() {
    return this.get();
  }

  observerAdded(count) {
    if (count == 1) this._attach();
  }

  observerRemoved(count) {
    if (count == 0) this._detach();
  }

  _attach() {}

  _detach() {}

  _onChange(value, idle = false) {
    callFluidObservers(this, {
      type: 'change',
      parent: this,
      value,
      idle
    });
  }

  _onPriorityChange(priority) {
    if (!this.idle) {
      frameLoop.sort(this);
    }

    callFluidObservers(this, {
      type: 'priority',
      parent: this,
      priority
    });
  }

}

const $P = Symbol.for('SpringPhase');
const HAS_ANIMATED = 1;
const IS_ANIMATING = 2;
const IS_PAUSED = 4;
const hasAnimated = target => (target[$P] & HAS_ANIMATED) > 0;
const isAnimating = target => (target[$P] & IS_ANIMATING) > 0;
const isPaused = target => (target[$P] & IS_PAUSED) > 0;
const setActiveBit = (target, active) => active ? target[$P] |= IS_ANIMATING | HAS_ANIMATED : target[$P] &= ~IS_ANIMATING;
const setPausedBit = (target, paused) => paused ? target[$P] |= IS_PAUSED : target[$P] &= ~IS_PAUSED;

class SpringValue extends FrameValue {
  constructor(arg1, arg2) {
    super();
    this.key = void 0;
    this.animation = new Animation();
    this.queue = void 0;
    this.defaultProps = {};
    this._state = {
      paused: false,
      pauseQueue: new Set(),
      resumeQueue: new Set(),
      timeouts: new Set()
    };
    this._pendingCalls = new Set();
    this._lastCallId = 0;
    this._lastToId = 0;
    this._memoizedDuration = 0;

    if (!react_spring_shared_esm_is.und(arg1) || !react_spring_shared_esm_is.und(arg2)) {
      const props = react_spring_shared_esm_is.obj(arg1) ? react_spring_core_esm_extends({}, arg1) : react_spring_core_esm_extends({}, arg2, {
        from: arg1
      });

      if (react_spring_shared_esm_is.und(props.default)) {
        props.default = true;
      }

      this.start(props);
    }
  }

  get idle() {
    return !(isAnimating(this) || this._state.asyncTo) || isPaused(this);
  }

  get goal() {
    return getFluidValue(this.animation.to);
  }

  get velocity() {
    const node = getAnimated(this);
    return node instanceof AnimatedValue ? node.lastVelocity || 0 : node.getPayload().map(node => node.lastVelocity || 0);
  }

  get hasAnimated() {
    return hasAnimated(this);
  }

  get isAnimating() {
    return isAnimating(this);
  }

  get isPaused() {
    return isPaused(this);
  }

  advance(dt) {
    let idle = true;
    let changed = false;
    const anim = this.animation;
    let {
      config,
      toValues
    } = anim;
    const payload = getPayload(anim.to);

    if (!payload && hasFluidValue(anim.to)) {
      toValues = react_spring_shared_esm_toArray(getFluidValue(anim.to));
    }

    anim.values.forEach((node, i) => {
      if (node.done) return;
      const to = node.constructor == AnimatedString ? 1 : payload ? payload[i].lastPosition : toValues[i];
      let finished = anim.immediate;
      let position = to;

      if (!finished) {
        position = node.lastPosition;

        if (config.tension <= 0) {
          node.done = true;
          return;
        }

        let elapsed = node.elapsedTime += dt;
        const from = anim.fromValues[i];
        const v0 = node.v0 != null ? node.v0 : node.v0 = react_spring_shared_esm_is.arr(config.velocity) ? config.velocity[i] : config.velocity;
        let velocity;

        if (!react_spring_shared_esm_is.und(config.duration)) {
          let p = 1;

          if (config.duration > 0) {
            if (this._memoizedDuration !== config.duration) {
              this._memoizedDuration = config.duration;

              if (node.durationProgress > 0) {
                node.elapsedTime = config.duration * node.durationProgress;
                elapsed = node.elapsedTime += dt;
              }
            }

            p = (config.progress || 0) + elapsed / this._memoizedDuration;
            p = p > 1 ? 1 : p < 0 ? 0 : p;
            node.durationProgress = p;
          }

          position = from + config.easing(p) * (to - from);
          velocity = (position - node.lastPosition) / dt;
          finished = p == 1;
        } else if (config.decay) {
            const decay = config.decay === true ? 0.998 : config.decay;
            const e = Math.exp(-(1 - decay) * elapsed);
            position = from + v0 / (1 - decay) * (1 - e);
            finished = Math.abs(node.lastPosition - position) < 0.1;
            velocity = v0 * e;
          } else {
              velocity = node.lastVelocity == null ? v0 : node.lastVelocity;
              const precision = config.precision || (from == to ? 0.005 : Math.min(1, Math.abs(to - from) * 0.001));
              const restVelocity = config.restVelocity || precision / 10;
              const bounceFactor = config.clamp ? 0 : config.bounce;
              const canBounce = !react_spring_shared_esm_is.und(bounceFactor);
              const isGrowing = from == to ? node.v0 > 0 : from < to;
              let isMoving;
              let isBouncing = false;
              const step = 1;
              const numSteps = Math.ceil(dt / step);

              for (let n = 0; n < numSteps; ++n) {
                isMoving = Math.abs(velocity) > restVelocity;

                if (!isMoving) {
                  finished = Math.abs(to - position) <= precision;

                  if (finished) {
                    break;
                  }
                }

                if (canBounce) {
                  isBouncing = position == to || position > to == isGrowing;

                  if (isBouncing) {
                    velocity = -velocity * bounceFactor;
                    position = to;
                  }
                }

                const springForce = -config.tension * 0.000001 * (position - to);
                const dampingForce = -config.friction * 0.001 * velocity;
                const acceleration = (springForce + dampingForce) / config.mass;
                velocity = velocity + acceleration * step;
                position = position + velocity * step;
              }
            }

        node.lastVelocity = velocity;

        if (Number.isNaN(position)) {
          console.warn(`Got NaN while animating:`, this);
          finished = true;
        }
      }

      if (payload && !payload[i].done) {
        finished = false;
      }

      if (finished) {
        node.done = true;
      } else {
        idle = false;
      }

      if (node.setValue(position, config.round)) {
        changed = true;
      }
    });
    const node = getAnimated(this);
    const currVal = node.getValue();

    if (idle) {
      const finalVal = getFluidValue(anim.to);

      if ((currVal !== finalVal || changed) && !config.decay) {
        node.setValue(finalVal);

        this._onChange(finalVal);
      } else if (changed && config.decay) {
        this._onChange(currVal);
      }

      this._stop();
    } else if (changed) {
      this._onChange(currVal);
    }
  }

  set(value) {
    raf.batchedUpdates(() => {
      this._stop();

      this._focus(value);

      this._set(value);
    });
    return this;
  }

  pause() {
    this._update({
      pause: true
    });
  }

  resume() {
    this._update({
      pause: false
    });
  }

  finish() {
    if (isAnimating(this)) {
      const {
        to,
        config
      } = this.animation;
      raf.batchedUpdates(() => {
        this._onStart();

        if (!config.decay) {
          this._set(to, false);
        }

        this._stop();
      });
    }

    return this;
  }

  update(props) {
    const queue = this.queue || (this.queue = []);
    queue.push(props);
    return this;
  }

  start(to, arg2) {
    let queue;

    if (!react_spring_shared_esm_is.und(to)) {
      queue = [react_spring_shared_esm_is.obj(to) ? to : react_spring_core_esm_extends({}, arg2, {
        to
      })];
    } else {
      queue = this.queue || [];
      this.queue = [];
    }

    return Promise.all(queue.map(props => this._update(props))).then(results => getCombinedResult(this, results));
  }

  stop(cancel) {
    const {
      to
    } = this.animation;

    this._focus(this.get());

    stopAsync(this._state, cancel && this._lastCallId);
    raf.batchedUpdates(() => this._stop(to, cancel));
    return this;
  }

  reset() {
    this._update({
      reset: true
    });
  }

  eventObserved(event) {
    if (event.type == 'change') {
      this._start();
    } else if (event.type == 'priority') {
      this.priority = event.priority + 1;
    }
  }

  _prepareNode(props) {
    const key = this.key || '';
    let {
      to,
      from
    } = props;
    to = react_spring_shared_esm_is.obj(to) ? to[key] : to;

    if (to == null || isAsyncTo(to)) {
      to = undefined;
    }

    from = react_spring_shared_esm_is.obj(from) ? from[key] : from;

    if (from == null) {
      from = undefined;
    }

    const range = {
      to,
      from
    };

    if (!hasAnimated(this)) {
      if (props.reverse) [to, from] = [from, to];
      from = getFluidValue(from);

      if (!react_spring_shared_esm_is.und(from)) {
        this._set(from);
      } else if (!getAnimated(this)) {
          this._set(to);
        }
    }

    return range;
  }

  _update(_ref, isLoop) {
    let props = react_spring_core_esm_extends({}, _ref);

    const {
      key,
      defaultProps
    } = this;
    if (props.default) Object.assign(defaultProps, getDefaultProps(props, (value, prop) => /^on/.test(prop) ? resolveProp(value, key) : value));
    mergeActiveFn(this, props, 'onProps');
    sendEvent(this, 'onProps', props, this);

    const range = this._prepareNode(props);

    if (Object.isFrozen(this)) {
      throw Error('Cannot animate a `SpringValue` object that is frozen. ' + 'Did you forget to pass your component to `animated(...)` before animating its props?');
    }

    const state = this._state;
    return scheduleProps(++this._lastCallId, {
      key,
      props,
      defaultProps,
      state,
      actions: {
        pause: () => {
          if (!isPaused(this)) {
            setPausedBit(this, true);
            flushCalls(state.pauseQueue);
            sendEvent(this, 'onPause', getFinishedResult(this, checkFinished(this, this.animation.to)), this);
          }
        },
        resume: () => {
          if (isPaused(this)) {
            setPausedBit(this, false);

            if (isAnimating(this)) {
              this._resume();
            }

            flushCalls(state.resumeQueue);
            sendEvent(this, 'onResume', getFinishedResult(this, checkFinished(this, this.animation.to)), this);
          }
        },
        start: this._merge.bind(this, range)
      }
    }).then(result => {
      if (props.loop && result.finished && !(isLoop && result.noop)) {
        const nextProps = createLoopUpdate(props);

        if (nextProps) {
          return this._update(nextProps, true);
        }
      }

      return result;
    });
  }

  _merge(range, props, resolve) {
    if (props.cancel) {
      this.stop(true);
      return resolve(getCancelledResult(this));
    }

    const hasToProp = !react_spring_shared_esm_is.und(range.to);
    const hasFromProp = !react_spring_shared_esm_is.und(range.from);

    if (hasToProp || hasFromProp) {
      if (props.callId > this._lastToId) {
        this._lastToId = props.callId;
      } else {
        return resolve(getCancelledResult(this));
      }
    }

    const {
      key,
      defaultProps,
      animation: anim
    } = this;
    const {
      to: prevTo,
      from: prevFrom
    } = anim;
    let {
      to = prevTo,
      from = prevFrom
    } = range;

    if (hasFromProp && !hasToProp && (!props.default || react_spring_shared_esm_is.und(to))) {
      to = from;
    }

    if (props.reverse) [to, from] = [from, to];
    const hasFromChanged = !isEqual(from, prevFrom);

    if (hasFromChanged) {
      anim.from = from;
    }

    from = getFluidValue(from);
    const hasToChanged = !isEqual(to, prevTo);

    if (hasToChanged) {
      this._focus(to);
    }

    const hasAsyncTo = isAsyncTo(props.to);
    const {
      config
    } = anim;
    const {
      decay,
      velocity
    } = config;

    if (hasToProp || hasFromProp) {
      config.velocity = 0;
    }

    if (props.config && !hasAsyncTo) {
      mergeConfig(config, callProp(props.config, key), props.config !== defaultProps.config ? callProp(defaultProps.config, key) : void 0);
    }

    let node = getAnimated(this);

    if (!node || react_spring_shared_esm_is.und(to)) {
      return resolve(getFinishedResult(this, true));
    }

    const reset = react_spring_shared_esm_is.und(props.reset) ? hasFromProp && !props.default : !react_spring_shared_esm_is.und(from) && matchProp(props.reset, key);
    const value = reset ? from : this.get();
    const goal = computeGoal(to);
    const isAnimatable = react_spring_shared_esm_is.num(goal) || react_spring_shared_esm_is.arr(goal) || isAnimatedString(goal);
    const immediate = !hasAsyncTo && (!isAnimatable || matchProp(defaultProps.immediate || props.immediate, key));

    if (hasToChanged) {
      const nodeType = getAnimatedType(to);

      if (nodeType !== node.constructor) {
        if (immediate) {
          node = this._set(goal);
        } else throw Error(`Cannot animate between ${node.constructor.name} and ${nodeType.name}, as the "to" prop suggests`);
      }
    }

    const goalType = node.constructor;
    let started = hasFluidValue(to);
    let finished = false;

    if (!started) {
      const hasValueChanged = reset || !hasAnimated(this) && hasFromChanged;

      if (hasToChanged || hasValueChanged) {
        finished = isEqual(computeGoal(value), goal);
        started = !finished;
      }

      if (!isEqual(anim.immediate, immediate) && !immediate || !isEqual(config.decay, decay) || !isEqual(config.velocity, velocity)) {
        started = true;
      }
    }

    if (finished && isAnimating(this)) {
      if (anim.changed && !reset) {
        started = true;
      } else if (!started) {
          this._stop(prevTo);
        }
    }

    if (!hasAsyncTo) {
      if (started || hasFluidValue(prevTo)) {
        anim.values = node.getPayload();
        anim.toValues = hasFluidValue(to) ? null : goalType == AnimatedString ? [1] : react_spring_shared_esm_toArray(goal);
      }

      if (anim.immediate != immediate) {
        anim.immediate = immediate;

        if (!immediate && !reset) {
          this._set(prevTo);
        }
      }

      if (started) {
        const {
          onRest
        } = anim;
        react_spring_shared_esm_each(ACTIVE_EVENTS, type => mergeActiveFn(this, props, type));
        const result = getFinishedResult(this, checkFinished(this, prevTo));
        flushCalls(this._pendingCalls, result);

        this._pendingCalls.add(resolve);

        if (anim.changed) raf.batchedUpdates(() => {
          anim.changed = !reset;
          onRest == null ? void 0 : onRest(result, this);

          if (reset) {
            callProp(defaultProps.onRest, result);
          } else {
              anim.onStart == null ? void 0 : anim.onStart(result, this);
            }
        });
      }
    }

    if (reset) {
      this._set(value);
    }

    if (hasAsyncTo) {
      resolve(runAsync(props.to, props, this._state, this));
    } else if (started) {
        this._start();
      } else if (isAnimating(this) && !hasToChanged) {
          this._pendingCalls.add(resolve);
        } else {
            resolve(getNoopResult(value));
          }
  }

  _focus(value) {
    const anim = this.animation;

    if (value !== anim.to) {
      if (getFluidObservers(this)) {
        this._detach();
      }

      anim.to = value;

      if (getFluidObservers(this)) {
        this._attach();
      }
    }
  }

  _attach() {
    let priority = 0;
    const {
      to
    } = this.animation;

    if (hasFluidValue(to)) {
      addFluidObserver(to, this);

      if (isFrameValue(to)) {
        priority = to.priority + 1;
      }
    }

    this.priority = priority;
  }

  _detach() {
    const {
      to
    } = this.animation;

    if (hasFluidValue(to)) {
      removeFluidObserver(to, this);
    }
  }

  _set(arg, idle = true) {
    const value = getFluidValue(arg);

    if (!react_spring_shared_esm_is.und(value)) {
      const oldNode = getAnimated(this);

      if (!oldNode || !isEqual(value, oldNode.getValue())) {
        const nodeType = getAnimatedType(value);

        if (!oldNode || oldNode.constructor != nodeType) {
          setAnimated(this, nodeType.create(value));
        } else {
          oldNode.setValue(value);
        }

        if (oldNode) {
          raf.batchedUpdates(() => {
            this._onChange(value, idle);
          });
        }
      }
    }

    return getAnimated(this);
  }

  _onStart() {
    const anim = this.animation;

    if (!anim.changed) {
      anim.changed = true;
      sendEvent(this, 'onStart', getFinishedResult(this, checkFinished(this, anim.to)), this);
    }
  }

  _onChange(value, idle) {
    if (!idle) {
      this._onStart();

      callProp(this.animation.onChange, value, this);
    }

    callProp(this.defaultProps.onChange, value, this);

    super._onChange(value, idle);
  }

  _start() {
    const anim = this.animation;
    getAnimated(this).reset(getFluidValue(anim.to));

    if (!anim.immediate) {
      anim.fromValues = anim.values.map(node => node.lastPosition);
    }

    if (!isAnimating(this)) {
      setActiveBit(this, true);

      if (!isPaused(this)) {
        this._resume();
      }
    }
  }

  _resume() {
    if (globals.skipAnimation) {
      this.finish();
    } else {
      frameLoop.start(this);
    }
  }

  _stop(goal, cancel) {
    if (isAnimating(this)) {
      setActiveBit(this, false);
      const anim = this.animation;
      react_spring_shared_esm_each(anim.values, node => {
        node.done = true;
      });

      if (anim.toValues) {
        anim.onChange = anim.onPause = anim.onResume = undefined;
      }

      callFluidObservers(this, {
        type: 'idle',
        parent: this
      });
      const result = cancel ? getCancelledResult(this.get()) : getFinishedResult(this.get(), checkFinished(this, goal != null ? goal : anim.to));
      flushCalls(this._pendingCalls, result);

      if (anim.changed) {
        anim.changed = false;
        sendEvent(this, 'onRest', result, this);
      }
    }
  }

}

function checkFinished(target, to) {
  const goal = computeGoal(to);
  const value = computeGoal(target.get());
  return isEqual(value, goal);
}

function createLoopUpdate(props, loop = props.loop, to = props.to) {
  let loopRet = callProp(loop);

  if (loopRet) {
    const overrides = loopRet !== true && inferTo(loopRet);
    const reverse = (overrides || props).reverse;
    const reset = !overrides || overrides.reset;
    return createUpdate(react_spring_core_esm_extends({}, props, {
      loop,
      default: false,
      pause: undefined,
      to: !reverse || isAsyncTo(to) ? to : undefined,
      from: reset ? props.from : undefined,
      reset
    }, overrides));
  }
}
function createUpdate(props) {
  const {
    to,
    from
  } = props = inferTo(props);
  const keys = new Set();
  if (react_spring_shared_esm_is.obj(to)) findDefined(to, keys);
  if (react_spring_shared_esm_is.obj(from)) findDefined(from, keys);
  props.keys = keys.size ? Array.from(keys) : null;
  return props;
}
function declareUpdate(props) {
  const update = createUpdate(props);

  if (react_spring_shared_esm_is.und(update.default)) {
    update.default = getDefaultProps(update);
  }

  return update;
}

function findDefined(values, keys) {
  eachProp(values, (value, key) => value != null && keys.add(key));
}

const ACTIVE_EVENTS = ['onStart', 'onRest', 'onChange', 'onPause', 'onResume'];

function mergeActiveFn(target, props, type) {
  target.animation[type] = props[type] !== getDefaultProp(props, type) ? resolveProp(props[type], target.key) : undefined;
}

function sendEvent(target, type, ...args) {
  var _target$animation$typ, _target$animation, _target$defaultProps$, _target$defaultProps;

  (_target$animation$typ = (_target$animation = target.animation)[type]) == null ? void 0 : _target$animation$typ.call(_target$animation, ...args);
  (_target$defaultProps$ = (_target$defaultProps = target.defaultProps)[type]) == null ? void 0 : _target$defaultProps$.call(_target$defaultProps, ...args);
}

const BATCHED_EVENTS = ['onStart', 'onChange', 'onRest'];
let nextId = 1;
class Controller {
  constructor(props, flush) {
    this.id = nextId++;
    this.springs = {};
    this.queue = [];
    this.ref = void 0;
    this._flush = void 0;
    this._initialProps = void 0;
    this._lastAsyncId = 0;
    this._active = new Set();
    this._changed = new Set();
    this._started = false;
    this._item = void 0;
    this._state = {
      paused: false,
      pauseQueue: new Set(),
      resumeQueue: new Set(),
      timeouts: new Set()
    };
    this._events = {
      onStart: new Map(),
      onChange: new Map(),
      onRest: new Map()
    };
    this._onFrame = this._onFrame.bind(this);

    if (flush) {
      this._flush = flush;
    }

    if (props) {
      this.start(react_spring_core_esm_extends({
        default: true
      }, props));
    }
  }

  get idle() {
    return !this._state.asyncTo && Object.values(this.springs).every(spring => spring.idle);
  }

  get item() {
    return this._item;
  }

  set item(item) {
    this._item = item;
  }

  get() {
    const values = {};
    this.each((spring, key) => values[key] = spring.get());
    return values;
  }

  set(values) {
    for (const key in values) {
      const value = values[key];

      if (!react_spring_shared_esm_is.und(value)) {
        this.springs[key].set(value);
      }
    }
  }

  update(props) {
    if (props) {
      this.queue.push(createUpdate(props));
    }

    return this;
  }

  start(props) {
    let {
      queue
    } = this;

    if (props) {
      queue = react_spring_shared_esm_toArray(props).map(createUpdate);
    } else {
      this.queue = [];
    }

    if (this._flush) {
      return this._flush(this, queue);
    }

    prepareKeys(this, queue);
    return flushUpdateQueue(this, queue);
  }

  stop(arg, keys) {
    if (arg !== !!arg) {
      keys = arg;
    }

    if (keys) {
      const springs = this.springs;
      react_spring_shared_esm_each(react_spring_shared_esm_toArray(keys), key => springs[key].stop(!!arg));
    } else {
      stopAsync(this._state, this._lastAsyncId);
      this.each(spring => spring.stop(!!arg));
    }

    return this;
  }

  pause(keys) {
    if (react_spring_shared_esm_is.und(keys)) {
      this.start({
        pause: true
      });
    } else {
      const springs = this.springs;
      react_spring_shared_esm_each(react_spring_shared_esm_toArray(keys), key => springs[key].pause());
    }

    return this;
  }

  resume(keys) {
    if (react_spring_shared_esm_is.und(keys)) {
      this.start({
        pause: false
      });
    } else {
      const springs = this.springs;
      react_spring_shared_esm_each(react_spring_shared_esm_toArray(keys), key => springs[key].resume());
    }

    return this;
  }

  each(iterator) {
    eachProp(this.springs, iterator);
  }

  _onFrame() {
    const {
      onStart,
      onChange,
      onRest
    } = this._events;
    const active = this._active.size > 0;
    const changed = this._changed.size > 0;

    if (active && !this._started || changed && !this._started) {
      this._started = true;
      flush(onStart, ([onStart, result]) => {
        result.value = this.get();
        onStart(result, this, this._item);
      });
    }

    const idle = !active && this._started;
    const values = changed || idle && onRest.size ? this.get() : null;

    if (changed && onChange.size) {
      flush(onChange, ([onChange, result]) => {
        result.value = values;
        onChange(result, this, this._item);
      });
    }

    if (idle) {
      this._started = false;
      flush(onRest, ([onRest, result]) => {
        result.value = values;
        onRest(result, this, this._item);
      });
    }
  }

  eventObserved(event) {
    if (event.type == 'change') {
      this._changed.add(event.parent);

      if (!event.idle) {
        this._active.add(event.parent);
      }
    } else if (event.type == 'idle') {
      this._active.delete(event.parent);
    } else return;

    raf.onFrame(this._onFrame);
  }

}
function flushUpdateQueue(ctrl, queue) {
  return Promise.all(queue.map(props => flushUpdate(ctrl, props))).then(results => getCombinedResult(ctrl, results));
}
async function flushUpdate(ctrl, props, isLoop) {
  const {
    keys,
    to,
    from,
    loop,
    onRest,
    onResolve
  } = props;
  const defaults = react_spring_shared_esm_is.obj(props.default) && props.default;

  if (loop) {
    props.loop = false;
  }

  if (to === false) props.to = null;
  if (from === false) props.from = null;
  const asyncTo = react_spring_shared_esm_is.arr(to) || react_spring_shared_esm_is.fun(to) ? to : undefined;

  if (asyncTo) {
    props.to = undefined;
    props.onRest = undefined;

    if (defaults) {
      defaults.onRest = undefined;
    }
  } else {
      react_spring_shared_esm_each(BATCHED_EVENTS, key => {
        const handler = props[key];

        if (react_spring_shared_esm_is.fun(handler)) {
          const queue = ctrl['_events'][key];

          props[key] = ({
            finished,
            cancelled
          }) => {
            const result = queue.get(handler);

            if (result) {
              if (!finished) result.finished = false;
              if (cancelled) result.cancelled = true;
            } else {
              queue.set(handler, {
                value: null,
                finished: finished || false,
                cancelled: cancelled || false
              });
            }
          };

          if (defaults) {
            defaults[key] = props[key];
          }
        }
      });
    }

  const state = ctrl['_state'];

  if (props.pause === !state.paused) {
    state.paused = props.pause;
    flushCalls(props.pause ? state.pauseQueue : state.resumeQueue);
  } else if (state.paused) {
      props.pause = true;
    }

  const promises = (keys || Object.keys(ctrl.springs)).map(key => ctrl.springs[key].start(props));
  const cancel = props.cancel === true || getDefaultProp(props, 'cancel') === true;

  if (asyncTo || cancel && state.asyncId) {
    promises.push(scheduleProps(++ctrl['_lastAsyncId'], {
      props,
      state,
      actions: {
        pause: noop,
        resume: noop,

        start(props, resolve) {
          if (cancel) {
            stopAsync(state, ctrl['_lastAsyncId']);
            resolve(getCancelledResult(ctrl));
          } else {
            props.onRest = onRest;
            resolve(runAsync(asyncTo, props, state, ctrl));
          }
        }

      }
    }));
  }

  if (state.paused) {
    await new Promise(resume => {
      state.resumeQueue.add(resume);
    });
  }

  const result = getCombinedResult(ctrl, await Promise.all(promises));

  if (loop && result.finished && !(isLoop && result.noop)) {
    const nextProps = createLoopUpdate(props, loop, to);

    if (nextProps) {
      prepareKeys(ctrl, [nextProps]);
      return flushUpdate(ctrl, nextProps, true);
    }
  }

  if (onResolve) {
    raf.batchedUpdates(() => onResolve(result, ctrl, ctrl.item));
  }

  return result;
}
function getSprings(ctrl, props) {
  const springs = react_spring_core_esm_extends({}, ctrl.springs);

  if (props) {
    react_spring_shared_esm_each(react_spring_shared_esm_toArray(props), props => {
      if (react_spring_shared_esm_is.und(props.keys)) {
        props = createUpdate(props);
      }

      if (!react_spring_shared_esm_is.obj(props.to)) {
        props = react_spring_core_esm_extends({}, props, {
          to: undefined
        });
      }

      prepareSprings(springs, props, key => {
        return createSpring(key);
      });
    });
  }

  setSprings(ctrl, springs);
  return springs;
}
function setSprings(ctrl, springs) {
  eachProp(springs, (spring, key) => {
    if (!ctrl.springs[key]) {
      ctrl.springs[key] = spring;
      addFluidObserver(spring, ctrl);
    }
  });
}

function createSpring(key, observer) {
  const spring = new SpringValue();
  spring.key = key;

  if (observer) {
    addFluidObserver(spring, observer);
  }

  return spring;
}

function prepareSprings(springs, props, create) {
  if (props.keys) {
    react_spring_shared_esm_each(props.keys, key => {
      const spring = springs[key] || (springs[key] = create(key));
      spring['_prepareNode'](props);
    });
  }
}

function prepareKeys(ctrl, queue) {
  react_spring_shared_esm_each(queue, props => {
    prepareSprings(ctrl.springs, props, key => {
      return createSpring(key, ctrl);
    });
  });
}

function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;

  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }

  return target;
}

const _excluded$3 = ["children"];
const SpringContext = _ref => {
  let {
    children
  } = _ref,
      props = _objectWithoutPropertiesLoose(_ref, _excluded$3);

  const inherited = (0,external_React_.useContext)(ctx);
  const pause = props.pause || !!inherited.pause,
        immediate = props.immediate || !!inherited.immediate;
  props = useMemoOne(() => ({
    pause,
    immediate
  }), [pause, immediate]);
  const {
    Provider
  } = ctx;
  return external_React_.createElement(Provider, {
    value: props
  }, children);
};
const ctx = makeContext(SpringContext, {});
SpringContext.Provider = ctx.Provider;
SpringContext.Consumer = ctx.Consumer;

function makeContext(target, init) {
  Object.assign(target, external_React_.createContext(init));
  target.Provider._context = target;
  target.Consumer._context = target;
  return target;
}

const SpringRef = () => {
  const current = [];

  const SpringRef = function SpringRef(props) {
    deprecateDirectCall();
    const results = [];
    react_spring_shared_esm_each(current, (ctrl, i) => {
      if (react_spring_shared_esm_is.und(props)) {
        results.push(ctrl.start());
      } else {
        const update = _getProps(props, ctrl, i);

        if (update) {
          results.push(ctrl.start(update));
        }
      }
    });
    return results;
  };

  SpringRef.current = current;

  SpringRef.add = function (ctrl) {
    if (!current.includes(ctrl)) {
      current.push(ctrl);
    }
  };

  SpringRef.delete = function (ctrl) {
    const i = current.indexOf(ctrl);
    if (~i) current.splice(i, 1);
  };

  SpringRef.pause = function () {
    react_spring_shared_esm_each(current, ctrl => ctrl.pause(...arguments));
    return this;
  };

  SpringRef.resume = function () {
    react_spring_shared_esm_each(current, ctrl => ctrl.resume(...arguments));
    return this;
  };

  SpringRef.set = function (values) {
    react_spring_shared_esm_each(current, ctrl => ctrl.set(values));
  };

  SpringRef.start = function (props) {
    const results = [];
    react_spring_shared_esm_each(current, (ctrl, i) => {
      if (react_spring_shared_esm_is.und(props)) {
        results.push(ctrl.start());
      } else {
        const update = this._getProps(props, ctrl, i);

        if (update) {
          results.push(ctrl.start(update));
        }
      }
    });
    return results;
  };

  SpringRef.stop = function () {
    react_spring_shared_esm_each(current, ctrl => ctrl.stop(...arguments));
    return this;
  };

  SpringRef.update = function (props) {
    react_spring_shared_esm_each(current, (ctrl, i) => ctrl.update(this._getProps(props, ctrl, i)));
    return this;
  };

  const _getProps = function _getProps(arg, ctrl, index) {
    return react_spring_shared_esm_is.fun(arg) ? arg(index, ctrl) : arg;
  };

  SpringRef._getProps = _getProps;
  return SpringRef;
};

function useSprings(length, props, deps) {
  const propsFn = react_spring_shared_esm_is.fun(props) && props;
  if (propsFn && !deps) deps = [];
  const ref = (0,external_React_.useMemo)(() => propsFn || arguments.length == 3 ? SpringRef() : void 0, []);
  const layoutId = (0,external_React_.useRef)(0);
  const forceUpdate = react_spring_shared_esm_useForceUpdate();
  const state = (0,external_React_.useMemo)(() => ({
    ctrls: [],
    queue: [],

    flush(ctrl, updates) {
      const springs = getSprings(ctrl, updates);
      const canFlushSync = layoutId.current > 0 && !state.queue.length && !Object.keys(springs).some(key => !ctrl.springs[key]);
      return canFlushSync ? flushUpdateQueue(ctrl, updates) : new Promise(resolve => {
        setSprings(ctrl, springs);
        state.queue.push(() => {
          resolve(flushUpdateQueue(ctrl, updates));
        });
        forceUpdate();
      });
    }

  }), []);
  const ctrls = (0,external_React_.useRef)([...state.ctrls]);
  const updates = [];
  const prevLength = react_spring_shared_esm_usePrev(length) || 0;
  (0,external_React_.useMemo)(() => {
    react_spring_shared_esm_each(ctrls.current.slice(length, prevLength), ctrl => {
      detachRefs(ctrl, ref);
      ctrl.stop(true);
    });
    ctrls.current.length = length;
    declareUpdates(prevLength, length);
  }, [length]);
  (0,external_React_.useMemo)(() => {
    declareUpdates(0, Math.min(prevLength, length));
  }, deps);

  function declareUpdates(startIndex, endIndex) {
    for (let i = startIndex; i < endIndex; i++) {
      const ctrl = ctrls.current[i] || (ctrls.current[i] = new Controller(null, state.flush));
      const update = propsFn ? propsFn(i, ctrl) : props[i];

      if (update) {
        updates[i] = declareUpdate(update);
      }
    }
  }

  const springs = ctrls.current.map((ctrl, i) => getSprings(ctrl, updates[i]));
  const context = (0,external_React_.useContext)(SpringContext);
  const prevContext = react_spring_shared_esm_usePrev(context);
  const hasContext = context !== prevContext && hasProps(context);
  react_spring_shared_esm_useLayoutEffect(() => {
    layoutId.current++;
    state.ctrls = ctrls.current;
    const {
      queue
    } = state;

    if (queue.length) {
      state.queue = [];
      react_spring_shared_esm_each(queue, cb => cb());
    }

    react_spring_shared_esm_each(ctrls.current, (ctrl, i) => {
      ref == null ? void 0 : ref.add(ctrl);

      if (hasContext) {
        ctrl.start({
          default: context
        });
      }

      const update = updates[i];

      if (update) {
        replaceRef(ctrl, update.ref);

        if (ctrl.ref) {
          ctrl.queue.push(update);
        } else {
          ctrl.start(update);
        }
      }
    });
  });
  react_spring_shared_esm_useOnce(() => () => {
    react_spring_shared_esm_each(state.ctrls, ctrl => ctrl.stop(true));
  });
  const values = springs.map(x => react_spring_core_esm_extends({}, x));
  return ref ? [values, ref] : values;
}

function useSpring(props, deps) {
  const isFn = react_spring_shared_esm_is.fun(props);
  const [[values], ref] = useSprings(1, isFn ? props : [props], isFn ? deps || [] : deps);
  return isFn || arguments.length == 2 ? [values, ref] : values;
}

const initSpringRef = () => SpringRef();

const useSpringRef = () => useState(initSpringRef)[0];

function useTrail(length, propsArg, deps) {
  const propsFn = is.fun(propsArg) && propsArg;
  if (propsFn && !deps) deps = [];
  let reverse = true;
  const result = useSprings(length, (i, ctrl) => {
    const props = propsFn ? propsFn(i, ctrl) : propsArg;
    reverse = reverse && props.reverse;
    return props;
  }, deps || [{}]);
  const ref = result[1];
  useLayoutEffect(() => {
    each(ref.current, (ctrl, i) => {
      const parent = ref.current[i + (reverse ? 1 : -1)];
      if (parent) ctrl.start({
        to: parent.springs
      });
    });
  }, deps);

  if (propsFn || arguments.length == 3) {
    ref['_getProps'] = (propsArg, ctrl, i) => {
      const props = is.fun(propsArg) ? propsArg(i, ctrl) : propsArg;

      if (props) {
        const parent = ref.current[i + (props.reverse ? 1 : -1)];
        if (parent) props.to = parent.springs;
        return props;
      }
    };

    return result;
  }

  return result[0];
}

let TransitionPhase;

(function (TransitionPhase) {
  TransitionPhase["MOUNT"] = "mount";
  TransitionPhase["ENTER"] = "enter";
  TransitionPhase["UPDATE"] = "update";
  TransitionPhase["LEAVE"] = "leave";
})(TransitionPhase || (TransitionPhase = {}));

function useTransition(data, props, deps) {
  const propsFn = is.fun(props) && props;
  const {
    reset,
    sort,
    trail = 0,
    expires = true,
    onDestroyed,
    ref: propsRef,
    config: propsConfig
  } = propsFn ? propsFn() : props;
  const ref = useMemo(() => propsFn || arguments.length == 3 ? SpringRef() : void 0, []);
  const items = toArray(data);
  const transitions = [];
  const usedTransitions = useRef(null);
  const prevTransitions = reset ? null : usedTransitions.current;
  useLayoutEffect(() => {
    usedTransitions.current = transitions;
  });
  useOnce(() => () => each(usedTransitions.current, t => {
    if (t.expired) {
      clearTimeout(t.expirationId);
    }

    detachRefs(t.ctrl, ref);
    t.ctrl.stop(true);
  }));
  const keys = getKeys(items, propsFn ? propsFn() : props, prevTransitions);
  const expired = reset && usedTransitions.current || [];
  useLayoutEffect(() => each(expired, ({
    ctrl,
    item,
    key
  }) => {
    detachRefs(ctrl, ref);
    callProp(onDestroyed, item, key);
  }));
  const reused = [];
  if (prevTransitions) each(prevTransitions, (t, i) => {
    if (t.expired) {
      clearTimeout(t.expirationId);
      expired.push(t);
    } else {
      i = reused[i] = keys.indexOf(t.key);
      if (~i) transitions[i] = t;
    }
  });
  each(items, (item, i) => {
    if (!transitions[i]) {
      transitions[i] = {
        key: keys[i],
        item,
        phase: TransitionPhase.MOUNT,
        ctrl: new Controller()
      };
      transitions[i].ctrl.item = item;
    }
  });

  if (reused.length) {
    let i = -1;
    const {
      leave
    } = propsFn ? propsFn() : props;
    each(reused, (keyIndex, prevIndex) => {
      const t = prevTransitions[prevIndex];

      if (~keyIndex) {
        i = transitions.indexOf(t);
        transitions[i] = react_spring_core_esm_extends({}, t, {
          item: items[keyIndex]
        });
      } else if (leave) {
        transitions.splice(++i, 0, t);
      }
    });
  }

  if (is.fun(sort)) {
    transitions.sort((a, b) => sort(a.item, b.item));
  }

  let delay = -trail;
  const forceUpdate = useForceUpdate();
  const defaultProps = getDefaultProps(props);
  const changes = new Map();
  each(transitions, (t, i) => {
    const key = t.key;
    const prevPhase = t.phase;
    const p = propsFn ? propsFn() : props;
    let to;
    let phase;
    let propsDelay = callProp(p.delay || 0, key);

    if (prevPhase == TransitionPhase.MOUNT) {
      to = p.enter;
      phase = TransitionPhase.ENTER;
    } else {
      const isLeave = keys.indexOf(key) < 0;

      if (prevPhase != TransitionPhase.LEAVE) {
        if (isLeave) {
          to = p.leave;
          phase = TransitionPhase.LEAVE;
        } else if (to = p.update) {
          phase = TransitionPhase.UPDATE;
        } else return;
      } else if (!isLeave) {
        to = p.enter;
        phase = TransitionPhase.ENTER;
      } else return;
    }

    to = callProp(to, t.item, i);
    to = is.obj(to) ? inferTo(to) : {
      to
    };

    if (!to.config) {
      const config = propsConfig || defaultProps.config;
      to.config = callProp(config, t.item, i, phase);
    }

    delay += trail;

    const payload = react_spring_core_esm_extends({}, defaultProps, {
      delay: propsDelay + delay,
      ref: propsRef,
      immediate: p.immediate,
      reset: false
    }, to);

    if (phase == TransitionPhase.ENTER && is.und(payload.from)) {
      const _p = propsFn ? propsFn() : props;

      const from = is.und(_p.initial) || prevTransitions ? _p.from : _p.initial;
      payload.from = callProp(from, t.item, i);
    }

    const {
      onResolve
    } = payload;

    payload.onResolve = result => {
      callProp(onResolve, result);
      const transitions = usedTransitions.current;
      const t = transitions.find(t => t.key === key);
      if (!t) return;

      if (result.cancelled && t.phase != TransitionPhase.UPDATE) {
        return;
      }

      if (t.ctrl.idle) {
        const idle = transitions.every(t => t.ctrl.idle);

        if (t.phase == TransitionPhase.LEAVE) {
          const expiry = callProp(expires, t.item);

          if (expiry !== false) {
            const expiryMs = expiry === true ? 0 : expiry;
            t.expired = true;

            if (!idle && expiryMs > 0) {
              if (expiryMs <= 0x7fffffff) t.expirationId = setTimeout(forceUpdate, expiryMs);
              return;
            }
          }
        }

        if (idle && transitions.some(t => t.expired)) {
          forceUpdate();
        }
      }
    };

    const springs = getSprings(t.ctrl, payload);
    changes.set(t, {
      phase,
      springs,
      payload
    });
  });
  const context = useContext(SpringContext);
  const prevContext = usePrev(context);
  const hasContext = context !== prevContext && hasProps(context);
  useLayoutEffect(() => {
    if (hasContext) each(transitions, t => {
      t.ctrl.start({
        default: context
      });
    });
  }, [context]);
  useLayoutEffect(() => {
    each(changes, ({
      phase,
      payload
    }, t) => {
      const {
        ctrl
      } = t;
      t.phase = phase;
      ref == null ? void 0 : ref.add(ctrl);

      if (hasContext && phase == TransitionPhase.ENTER) {
        ctrl.start({
          default: context
        });
      }

      if (payload) {
        replaceRef(ctrl, payload.ref);

        if (ctrl.ref) {
          ctrl.update(payload);
        } else {
          ctrl.start(payload);
        }
      }
    });
  }, reset ? void 0 : deps);

  const renderTransitions = render => React.createElement(React.Fragment, null, transitions.map((t, i) => {
    const {
      springs
    } = changes.get(t) || t.ctrl;
    const elem = render(react_spring_core_esm_extends({}, springs), t.item, t, i);
    return elem && elem.type ? React.createElement(elem.type, react_spring_core_esm_extends({}, elem.props, {
      key: is.str(t.key) || is.num(t.key) ? t.key : t.ctrl.id,
      ref: elem.ref
    })) : elem;
  }));

  return ref ? [renderTransitions, ref] : renderTransitions;
}
let nextKey = 1;

function getKeys(items, {
  key,
  keys = key
}, prevTransitions) {
  if (keys === null) {
    const reused = new Set();
    return items.map(item => {
      const t = prevTransitions && prevTransitions.find(t => t.item === item && t.phase !== TransitionPhase.LEAVE && !reused.has(t));

      if (t) {
        reused.add(t);
        return t.key;
      }

      return nextKey++;
    });
  }

  return is.und(keys) ? items : is.fun(keys) ? items.map(keys) : toArray(keys);
}

const _excluded$2 = (/* unused pure expression or super */ null && (["children"]));
function Spring(_ref) {
  let {
    children
  } = _ref,
      props = _objectWithoutPropertiesLoose(_ref, _excluded$2);

  return children(useSpring(props));
}

const _excluded$1 = (/* unused pure expression or super */ null && (["items", "children"]));
function Trail(_ref) {
  let {
    items,
    children
  } = _ref,
      props = _objectWithoutPropertiesLoose(_ref, _excluded$1);

  const trails = useTrail(items.length, props);
  return items.map((item, index) => {
    const result = children(item, index);
    return is.fun(result) ? result(trails[index]) : result;
  });
}

const _excluded = (/* unused pure expression or super */ null && (["items", "children"]));
function Transition(_ref) {
  let {
    items,
    children
  } = _ref,
      props = _objectWithoutPropertiesLoose(_ref, _excluded);

  return useTransition(items, props)(children);
}

class Interpolation extends FrameValue {
  constructor(source, args) {
    super();
    this.key = void 0;
    this.idle = true;
    this.calc = void 0;
    this._active = new Set();
    this.source = source;
    this.calc = createInterpolator(...args);

    const value = this._get();

    const nodeType = getAnimatedType(value);
    setAnimated(this, nodeType.create(value));
  }

  advance(_dt) {
    const value = this._get();

    const oldValue = this.get();

    if (!isEqual(value, oldValue)) {
      getAnimated(this).setValue(value);

      this._onChange(value, this.idle);
    }

    if (!this.idle && checkIdle(this._active)) {
      becomeIdle(this);
    }
  }

  _get() {
    const inputs = react_spring_shared_esm_is.arr(this.source) ? this.source.map(getFluidValue) : react_spring_shared_esm_toArray(getFluidValue(this.source));
    return this.calc(...inputs);
  }

  _start() {
    if (this.idle && !checkIdle(this._active)) {
      this.idle = false;
      react_spring_shared_esm_each(getPayload(this), node => {
        node.done = false;
      });

      if (globals.skipAnimation) {
        raf.batchedUpdates(() => this.advance());
        becomeIdle(this);
      } else {
        frameLoop.start(this);
      }
    }
  }

  _attach() {
    let priority = 1;
    react_spring_shared_esm_each(react_spring_shared_esm_toArray(this.source), source => {
      if (hasFluidValue(source)) {
        addFluidObserver(source, this);
      }

      if (isFrameValue(source)) {
        if (!source.idle) {
          this._active.add(source);
        }

        priority = Math.max(priority, source.priority + 1);
      }
    });
    this.priority = priority;

    this._start();
  }

  _detach() {
    react_spring_shared_esm_each(react_spring_shared_esm_toArray(this.source), source => {
      if (hasFluidValue(source)) {
        removeFluidObserver(source, this);
      }
    });

    this._active.clear();

    becomeIdle(this);
  }

  eventObserved(event) {
    if (event.type == 'change') {
      if (event.idle) {
        this.advance();
      } else {
        this._active.add(event.parent);

        this._start();
      }
    } else if (event.type == 'idle') {
        this._active.delete(event.parent);
      } else if (event.type == 'priority') {
          this.priority = react_spring_shared_esm_toArray(this.source).reduce((highest, parent) => Math.max(highest, (isFrameValue(parent) ? parent.priority : 0) + 1), 0);
        }
  }

}

function isIdle(source) {
  return source.idle !== false;
}

function checkIdle(active) {
  return !active.size || Array.from(active).every(isIdle);
}

function becomeIdle(self) {
  if (!self.idle) {
    self.idle = true;
    react_spring_shared_esm_each(getPayload(self), node => {
      node.done = true;
    });
    callFluidObservers(self, {
      type: 'idle',
      parent: self
    });
  }
}

const react_spring_core_esm_to = (source, ...args) => new Interpolation(source, args);
const react_spring_core_esm_interpolate = (source, ...args) => (deprecateInterpolate(), new Interpolation(source, args));

globals.assign({
  createStringInterpolator: createStringInterpolator,
  to: (source, args) => new Interpolation(source, args)
});
const react_spring_core_esm_update = frameLoop.advance;



;// CONCATENATED MODULE: external "ReactDOM"
var external_ReactDOM_namespaceObject = window["ReactDOM"];
;// CONCATENATED MODULE: ./node_modules/@react-spring/web/dist/react-spring-web.esm.js






function react_spring_web_esm_objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;

  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }

  return target;
}

const react_spring_web_esm_excluded$2 = ["style", "children", "scrollTop", "scrollLeft"];
const isCustomPropRE = /^--/;

function dangerousStyleValue(name, value) {
  if (value == null || typeof value === 'boolean' || value === '') return '';
  if (typeof value === 'number' && value !== 0 && !isCustomPropRE.test(name) && !(isUnitlessNumber.hasOwnProperty(name) && isUnitlessNumber[name])) return value + 'px';
  return ('' + value).trim();
}

const attributeCache = {};
function applyAnimatedValues(instance, props) {
  if (!instance.nodeType || !instance.setAttribute) {
    return false;
  }

  const isFilterElement = instance.nodeName === 'filter' || instance.parentNode && instance.parentNode.nodeName === 'filter';

  const _ref = props,
        {
    style,
    children,
    scrollTop,
    scrollLeft
  } = _ref,
        attributes = react_spring_web_esm_objectWithoutPropertiesLoose(_ref, react_spring_web_esm_excluded$2);

  const values = Object.values(attributes);
  const names = Object.keys(attributes).map(name => isFilterElement || instance.hasAttribute(name) ? name : attributeCache[name] || (attributeCache[name] = name.replace(/([A-Z])/g, n => '-' + n.toLowerCase())));

  if (children !== void 0) {
    instance.textContent = children;
  }

  for (let name in style) {
    if (style.hasOwnProperty(name)) {
      const value = dangerousStyleValue(name, style[name]);

      if (isCustomPropRE.test(name)) {
        instance.style.setProperty(name, value);
      } else {
        instance.style[name] = value;
      }
    }
  }

  names.forEach((name, i) => {
    instance.setAttribute(name, values[i]);
  });

  if (scrollTop !== void 0) {
    instance.scrollTop = scrollTop;
  }

  if (scrollLeft !== void 0) {
    instance.scrollLeft = scrollLeft;
  }
}
let isUnitlessNumber = {
  animationIterationCount: true,
  borderImageOutset: true,
  borderImageSlice: true,
  borderImageWidth: true,
  boxFlex: true,
  boxFlexGroup: true,
  boxOrdinalGroup: true,
  columnCount: true,
  columns: true,
  flex: true,
  flexGrow: true,
  flexPositive: true,
  flexShrink: true,
  flexNegative: true,
  flexOrder: true,
  gridRow: true,
  gridRowEnd: true,
  gridRowSpan: true,
  gridRowStart: true,
  gridColumn: true,
  gridColumnEnd: true,
  gridColumnSpan: true,
  gridColumnStart: true,
  fontWeight: true,
  lineClamp: true,
  lineHeight: true,
  opacity: true,
  order: true,
  orphans: true,
  tabSize: true,
  widows: true,
  zIndex: true,
  zoom: true,
  fillOpacity: true,
  floodOpacity: true,
  stopOpacity: true,
  strokeDasharray: true,
  strokeDashoffset: true,
  strokeMiterlimit: true,
  strokeOpacity: true,
  strokeWidth: true
};

const prefixKey = (prefix, key) => prefix + key.charAt(0).toUpperCase() + key.substring(1);

const prefixes = ['Webkit', 'Ms', 'Moz', 'O'];
isUnitlessNumber = Object.keys(isUnitlessNumber).reduce((acc, prop) => {
  prefixes.forEach(prefix => acc[prefixKey(prefix, prop)] = acc[prop]);
  return acc;
}, isUnitlessNumber);

const react_spring_web_esm_excluded$1 = ["x", "y", "z"];
const domTransforms = /^(matrix|translate|scale|rotate|skew)/;
const pxTransforms = /^(translate)/;
const degTransforms = /^(rotate|skew)/;

const addUnit = (value, unit) => react_spring_shared_esm_is.num(value) && value !== 0 ? value + unit : value;

const isValueIdentity = (value, id) => react_spring_shared_esm_is.arr(value) ? value.every(v => isValueIdentity(v, id)) : react_spring_shared_esm_is.num(value) ? value === id : parseFloat(value) === id;

class AnimatedStyle extends AnimatedObject {
  constructor(_ref) {
    let {
      x,
      y,
      z
    } = _ref,
        style = react_spring_web_esm_objectWithoutPropertiesLoose(_ref, react_spring_web_esm_excluded$1);

    const inputs = [];
    const transforms = [];

    if (x || y || z) {
      inputs.push([x || 0, y || 0, z || 0]);
      transforms.push(xyz => [`translate3d(${xyz.map(v => addUnit(v, 'px')).join(',')})`, isValueIdentity(xyz, 0)]);
    }

    eachProp(style, (value, key) => {
      if (key === 'transform') {
        inputs.push([value || '']);
        transforms.push(transform => [transform, transform === '']);
      } else if (domTransforms.test(key)) {
        delete style[key];
        if (react_spring_shared_esm_is.und(value)) return;
        const unit = pxTransforms.test(key) ? 'px' : degTransforms.test(key) ? 'deg' : '';
        inputs.push(react_spring_shared_esm_toArray(value));
        transforms.push(key === 'rotate3d' ? ([x, y, z, deg]) => [`rotate3d(${x},${y},${z},${addUnit(deg, unit)})`, isValueIdentity(deg, 0)] : input => [`${key}(${input.map(v => addUnit(v, unit)).join(',')})`, isValueIdentity(input, key.startsWith('scale') ? 1 : 0)]);
      }
    });

    if (inputs.length) {
      style.transform = new FluidTransform(inputs, transforms);
    }

    super(style);
  }

}

class FluidTransform extends FluidValue {
  constructor(inputs, transforms) {
    super();
    this._value = null;
    this.inputs = inputs;
    this.transforms = transforms;
  }

  get() {
    return this._value || (this._value = this._get());
  }

  _get() {
    let transform = '';
    let identity = true;
    react_spring_shared_esm_each(this.inputs, (input, i) => {
      const arg1 = getFluidValue(input[0]);
      const [t, id] = this.transforms[i](react_spring_shared_esm_is.arr(arg1) ? arg1 : input.map(getFluidValue));
      transform += ' ' + t;
      identity = identity && id;
    });
    return identity ? 'none' : transform;
  }

  observerAdded(count) {
    if (count == 1) react_spring_shared_esm_each(this.inputs, input => react_spring_shared_esm_each(input, value => hasFluidValue(value) && addFluidObserver(value, this)));
  }

  observerRemoved(count) {
    if (count == 0) react_spring_shared_esm_each(this.inputs, input => react_spring_shared_esm_each(input, value => hasFluidValue(value) && removeFluidObserver(value, this)));
  }

  eventObserved(event) {
    if (event.type == 'change') {
      this._value = null;
    }

    callFluidObservers(this, event);
  }

}

const primitives = ['a', 'abbr', 'address', 'area', 'article', 'aside', 'audio', 'b', 'base', 'bdi', 'bdo', 'big', 'blockquote', 'body', 'br', 'button', 'canvas', 'caption', 'cite', 'code', 'col', 'colgroup', 'data', 'datalist', 'dd', 'del', 'details', 'dfn', 'dialog', 'div', 'dl', 'dt', 'em', 'embed', 'fieldset', 'figcaption', 'figure', 'footer', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'head', 'header', 'hgroup', 'hr', 'html', 'i', 'iframe', 'img', 'input', 'ins', 'kbd', 'keygen', 'label', 'legend', 'li', 'link', 'main', 'map', 'mark', 'menu', 'menuitem', 'meta', 'meter', 'nav', 'noscript', 'object', 'ol', 'optgroup', 'option', 'output', 'p', 'param', 'picture', 'pre', 'progress', 'q', 'rp', 'rt', 'ruby', 's', 'samp', 'script', 'section', 'select', 'small', 'source', 'span', 'strong', 'style', 'sub', 'summary', 'sup', 'table', 'tbody', 'td', 'textarea', 'tfoot', 'th', 'thead', 'time', 'title', 'tr', 'track', 'u', 'ul', 'var', 'video', 'wbr', 'circle', 'clipPath', 'defs', 'ellipse', 'foreignObject', 'g', 'image', 'line', 'linearGradient', 'mask', 'path', 'pattern', 'polygon', 'polyline', 'radialGradient', 'rect', 'stop', 'svg', 'text', 'tspan'];

const react_spring_web_esm_excluded = ["scrollTop", "scrollLeft"];
globals.assign({
  batchedUpdates: external_ReactDOM_namespaceObject.unstable_batchedUpdates,
  createStringInterpolator: createStringInterpolator,
  colors: colors
});
const host = createHost(primitives, {
  applyAnimatedValues,
  createAnimatedStyle: style => new AnimatedStyle(style),
  getComponentProps: _ref => {
    let props = react_spring_web_esm_objectWithoutPropertiesLoose(_ref, react_spring_web_esm_excluded);

    return props;
  }
});
const animated = host.animated;



;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/use-moving-animation/index.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */




/**
 * Simple reducer used to increment a counter.
 *
 * @param {number} state Previous counter value.
 * @return {number} New state value.
 */

const counterReducer = state => state + 1;

const getAbsolutePosition = element => {
  return {
    top: element.offsetTop,
    left: element.offsetLeft
  };
};
/**
 * Hook used to compute the styles required to move a div into a new position.
 *
 * The way this animation works is the following:
 *  - It first renders the element as if there was no animation.
 *  - It takes a snapshot of the position of the block to use it
 *    as a destination point for the animation.
 *  - It restores the element to the previous position using a CSS transform
 *  - It uses the "resetAnimation" flag to reset the animation
 *    from the beginning in order to animate to the new destination point.
 *
 * @param {Object}  $1                          Options
 * @param {boolean} $1.isSelected               Whether it's the current block or not.
 * @param {boolean} $1.adjustScrolling          Adjust the scroll position to the current block.
 * @param {boolean} $1.enableAnimation          Enable/Disable animation.
 * @param {*}       $1.triggerAnimationOnChange Variable used to trigger the animation if it changes.
 */


function useMovingAnimation(_ref) {
  let {
    isSelected,
    adjustScrolling,
    enableAnimation,
    triggerAnimationOnChange
  } = _ref;
  const ref = (0,external_wp_element_namespaceObject.useRef)();
  const prefersReducedMotion = (0,external_wp_compose_namespaceObject.useReducedMotion)() || !enableAnimation;
  const [triggeredAnimation, triggerAnimation] = (0,external_wp_element_namespaceObject.useReducer)(counterReducer, 0);
  const [finishedAnimation, endAnimation] = (0,external_wp_element_namespaceObject.useReducer)(counterReducer, 0);
  const [transform, setTransform] = (0,external_wp_element_namespaceObject.useState)({
    x: 0,
    y: 0
  });
  const previous = (0,external_wp_element_namespaceObject.useMemo)(() => ref.current ? getAbsolutePosition(ref.current) : null, [triggerAnimationOnChange]); // Calculate the previous position of the block relative to the viewport and
  // return a function to maintain that position by scrolling.

  const preserveScrollPosition = (0,external_wp_element_namespaceObject.useMemo)(() => {
    if (!adjustScrolling || !ref.current) {
      return () => {};
    }

    const scrollContainer = (0,external_wp_dom_namespaceObject.getScrollContainer)(ref.current);

    if (!scrollContainer) {
      return () => {};
    }

    const prevRect = ref.current.getBoundingClientRect();
    return () => {
      const blockRect = ref.current.getBoundingClientRect();
      const diff = blockRect.top - prevRect.top;

      if (diff) {
        scrollContainer.scrollTop += diff;
      }
    };
  }, [triggerAnimationOnChange, adjustScrolling]);
  (0,external_wp_element_namespaceObject.useLayoutEffect)(() => {
    if (triggeredAnimation) {
      endAnimation();
    }
  }, [triggeredAnimation]);
  (0,external_wp_element_namespaceObject.useLayoutEffect)(() => {
    if (!previous) {
      return;
    }

    if (prefersReducedMotion) {
      // If the animation is disabled and the scroll needs to be adjusted,
      // just move directly to the final scroll position.
      preserveScrollPosition();
      return;
    }

    ref.current.style.transform = '';
    const destination = getAbsolutePosition(ref.current);
    triggerAnimation();
    setTransform({
      x: Math.round(previous.left - destination.left),
      y: Math.round(previous.top - destination.top)
    });
  }, [triggerAnimationOnChange]); // Only called when either the x or y value changes.

  function onFrameChange(_ref2) {
    let {
      x,
      y
    } = _ref2;

    if (!ref.current) {
      return;
    }

    const isMoving = x === 0 && y === 0;
    ref.current.style.transformOrigin = isMoving ? '' : 'center';
    ref.current.style.transform = isMoving ? '' : `translate3d(${x}px,${y}px,0)`;
    ref.current.style.zIndex = !isSelected || isMoving ? '' : '1';
    preserveScrollPosition();
  } // Called for every frame computed by useSpring.


  function onChange(_ref3) {
    let {
      value
    } = _ref3;
    let {
      x,
      y
    } = value;
    x = Math.round(x);
    y = Math.round(y);

    if (x !== onChange.x || y !== onChange.y) {
      onFrameChange({
        x,
        y
      });
      onChange.x = x;
      onChange.y = y;
    }
  }

  onChange.x = 0;
  onChange.y = 0;
  useSpring({
    from: {
      x: transform.x,
      y: transform.y
    },
    to: {
      x: 0,
      y: 0
    },
    reset: triggeredAnimation !== finishedAnimation,
    config: {
      mass: 5,
      tension: 2000,
      friction: 200
    },
    immediate: prefersReducedMotion,
    onChange
  });
  return ref;
}

/* harmony default export */ var use_moving_animation = (useMovingAnimation);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/utils/dom.js
const BLOCK_SELECTOR = '.block-editor-block-list__block';
const APPENDER_SELECTOR = '.block-list-appender';
/**
 * Returns true if two elements are contained within the same block.
 *
 * @param {Element} a First element.
 * @param {Element} b Second element.
 *
 * @return {boolean} Whether elements are in the same block.
 */

function isInSameBlock(a, b) {
  return a.closest(BLOCK_SELECTOR) === b.closest(BLOCK_SELECTOR);
}
/**
 * Returns true if an element is considered part of the block and not its inner
 * blocks or appender.
 *
 * @param {Element} blockElement Block container element.
 * @param {Element} element      Element.
 *
 * @return {boolean} Whether an element is considered part of the block and not
 *                   its inner blocks or appender.
 */

function isInsideRootBlock(blockElement, element) {
  const parentBlock = element.closest([BLOCK_SELECTOR, APPENDER_SELECTOR].join(','));
  return parentBlock === blockElement;
}
/**
 * Finds the block client ID given any DOM node inside the block.
 *
 * @param {Node?} node DOM node.
 *
 * @return {string|undefined} Client ID or undefined if the node is not part of
 *                            a block.
 */

function getBlockClientId(node) {
  while (node && node.nodeType !== node.ELEMENT_NODE) {
    node = node.parentNode;
  }

  if (!node) {
    return;
  }

  const elementNode =
  /** @type {Element} */
  node;
  const blockNode = elementNode.closest(BLOCK_SELECTOR);

  if (!blockNode) {
    return;
  }

  return blockNode.id.slice('block-'.length);
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-list/use-block-props/use-multi-selection.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



/**
 * Sets the `contenteditable` wrapper element to `value`.
 *
 * @param {HTMLElement} node  Block element.
 * @param {boolean}     value `contentEditable` value (true or false)
 */

function setContentEditableWrapper(node, value) {
  // Since `closest` considers `node` as a candidate, use `parentElement`.
  node.parentElement.closest('[contenteditable]').contentEditable = value;
}
/**
 * Sets a multi-selection based on the native selection across blocks.
 *
 * @param {string} clientId Block client ID.
 */

function useMultiSelection(clientId) {
  const {
    startMultiSelect,
    stopMultiSelect,
    multiSelect,
    selectBlock
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const {
    isSelectionEnabled,
    isBlockSelected,
    getBlockParents,
    getBlockSelectionStart,
    hasMultiSelection
  } = (0,external_wp_data_namespaceObject.useSelect)(store);
  return (0,external_wp_compose_namespaceObject.useRefEffect)(node => {
    const {
      ownerDocument
    } = node;
    const {
      defaultView
    } = ownerDocument;
    let anchorElement;
    let rafId;

    function onSelectionChange(_ref) {
      let {
        isSelectionEnd
      } = _ref;
      const selection = defaultView.getSelection(); // If no selection is found, end multi selection and disable the
      // contentEditable wrapper.

      if (!selection.rangeCount || selection.isCollapsed) {
        setContentEditableWrapper(node, false);
        return;
      }

      const endClientId = getBlockClientId(selection.focusNode);
      const isSingularSelection = clientId === endClientId;

      if (isSingularSelection) {
        selectBlock(clientId); // If the selection is complete (on mouse up), and no
        // multiple blocks have been selected, set focus back to the
        // anchor element. if the anchor element contains the
        // selection. Additionally, the contentEditable wrapper can
        // now be disabled again.

        if (isSelectionEnd) {
          setContentEditableWrapper(node, false);

          if (selection.rangeCount) {
            const {
              commonAncestorContainer
            } = selection.getRangeAt(0);

            if (anchorElement.contains(commonAncestorContainer)) {
              anchorElement.focus();
            }
          }
        }
      } else {
        const startPath = [...getBlockParents(clientId), clientId];
        const endPath = [...getBlockParents(endClientId), endClientId];
        const depth = Math.min(startPath.length, endPath.length) - 1;
        multiSelect(startPath[depth], endPath[depth]);
      }
    }

    function onSelectionEnd() {
      ownerDocument.removeEventListener('selectionchange', onSelectionChange); // Equivalent to attaching the listener once.

      defaultView.removeEventListener('mouseup', onSelectionEnd); // The browser selection won't have updated yet at this point,
      // so wait until the next animation frame to get the browser
      // selection.

      rafId = defaultView.requestAnimationFrame(() => {
        onSelectionChange({
          isSelectionEnd: true
        });
        stopMultiSelect();
      });
    }

    function onMouseLeave(_ref2) {
      let {
        buttons
      } = _ref2;

      // The primary button must be pressed to initiate selection.
      // See https://developer.mozilla.org/en-US/docs/Web/API/MouseEvent/buttons
      if (buttons !== 1) {
        return;
      }

      if (!isSelectionEnabled() || !isBlockSelected(clientId)) {
        return;
      }

      anchorElement = ownerDocument.activeElement;
      startMultiSelect(); // `onSelectionStart` is called after `mousedown` and
      // `mouseleave` (from a block). The selection ends when
      // `mouseup` happens anywhere in the window.

      ownerDocument.addEventListener('selectionchange', onSelectionChange);
      defaultView.addEventListener('mouseup', onSelectionEnd); // Allow cross contentEditable selection by temporarily making
      // all content editable. We can't rely on using the store and
      // React because re-rending happens too slowly. We need to be
      // able to select across instances immediately.

      setContentEditableWrapper(node, true);
    }

    function onMouseDown(event) {
      // The main button.
      // https://developer.mozilla.org/en-US/docs/Web/API/MouseEvent/button
      if (!isSelectionEnabled() || event.button !== 0) {
        return;
      }

      if (event.shiftKey) {
        const blockSelectionStart = getBlockSelectionStart(); // By checking `blockSelectionStart` to be set, we handle the
        // case where we select a single block. We also have to check
        // the selectionEnd (clientId) not to be included in the
        // `blockSelectionStart`'s parents because the click event is
        // propagated.

        const startParents = getBlockParents(blockSelectionStart);

        if (blockSelectionStart && blockSelectionStart !== clientId && !(startParents !== null && startParents !== void 0 && startParents.includes(clientId))) {
          const startPath = [...startParents, blockSelectionStart];
          const endPath = [...getBlockParents(clientId), clientId];
          const depth = Math.min(startPath.length, endPath.length) - 1;
          const start = startPath[depth];
          const end = endPath[depth]; // Handle the case of having selected a parent block and
          // then shift+click on a child.

          if (start !== end) {
            setContentEditableWrapper(node, true);
            multiSelect(start, end);
            event.preventDefault();
          }
        }
      } else if (hasMultiSelection()) {
        // Allow user to escape out of a multi-selection to a
        // singular selection of a block via click. This is handled
        // here since focus handling excludes blocks when there is
        // multiselection, as focus can be incurred by starting a
        // multiselection (focus moved to first block's multi-
        // controls).
        selectBlock(clientId);
      }
    }

    node.addEventListener('mousedown', onMouseDown);
    node.addEventListener('mouseleave', onMouseLeave);
    return () => {
      node.removeEventListener('mousedown', onMouseDown);
      node.removeEventListener('mouseleave', onMouseLeave);
      ownerDocument.removeEventListener('selectionchange', onSelectionChange);
      defaultView.removeEventListener('mouseup', onSelectionEnd);
      defaultView.cancelAnimationFrame(rafId);
    };
  }, [clientId, startMultiSelect, stopMultiSelect, multiSelect, selectBlock, isSelectionEnabled, isBlockSelected, getBlockParents]);
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-list/use-block-props/use-focus-first-element.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */




/** @typedef {import('@wordpress/element').RefObject} RefObject */

/**
 * Returns the initial position if the block needs to be focussed, `undefined`
 * otherwise. The initial position is either 0 (start) or -1 (end).
 *
 * @param {string} clientId Block client ID.
 *
 * @return {number} The initial position, either 0 (start) or -1 (end).
 */

function useInitialPosition(clientId) {
  return (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getSelectedBlocksInitialCaretPosition,
      isMultiSelecting,
      isNavigationMode,
      isBlockSelected
    } = select(store);

    if (!isBlockSelected(clientId)) {
      return;
    }

    if (isMultiSelecting() || isNavigationMode()) {
      return;
    } // If there's no initial position, return 0 to focus the start.


    return getSelectedBlocksInitialCaretPosition();
  }, [clientId]);
}
/**
 * Transitions focus to the block or inner tabbable when the block becomes
 * selected and an initial position is set.
 *
 * @param {string} clientId Block client ID.
 *
 * @return {RefObject} React ref with the block element.
 */


function useFocusFirstElement(clientId) {
  const ref = (0,external_wp_element_namespaceObject.useRef)();
  const initialPosition = useInitialPosition(clientId);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (initialPosition === undefined || initialPosition === null) {
      return;
    }

    if (!ref.current) {
      return;
    }

    const {
      ownerDocument
    } = ref.current; // Do not focus the block if it already contains the active element.

    if (ref.current.contains(ownerDocument.activeElement)) {
      return;
    } // Find all tabbables within node.


    const textInputs = external_wp_dom_namespaceObject.focus.tabbable.find(ref.current).filter(node => (0,external_wp_dom_namespaceObject.isTextField)(node)); // If reversed (e.g. merge via backspace), use the last in the set of
    // tabbables.

    const isReverse = -1 === initialPosition;
    const target = (isReverse ? external_lodash_namespaceObject.last : external_lodash_namespaceObject.first)(textInputs) || ref.current;

    if (!isInsideRootBlock(ref.current, target)) {
      ref.current.focus();
      return;
    }

    setContentEditableWrapper(ref.current, false);
    (0,external_wp_dom_namespaceObject.placeCaretAtHorizontalEdge)(target, isReverse);
  }, [initialPosition]);
  return ref;
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-list/use-block-props/use-is-hovered.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function listener(event) {
  if (event.defaultPrevented) {
    return;
  }

  const action = event.type === 'mouseover' ? 'add' : 'remove';
  event.preventDefault();
  event.currentTarget.classList[action]('is-hovered');
}
/**
 * Adds `is-hovered` class when the block is hovered and in navigation or
 * outline mode.
 */


function useIsHovered() {
  const isEnabled = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      isNavigationMode,
      getSettings
    } = select(store);
    return isNavigationMode() || getSettings().outlineMode;
  }, []);
  return (0,external_wp_compose_namespaceObject.useRefEffect)(node => {
    if (isEnabled) {
      node.addEventListener('mouseout', listener);
      node.addEventListener('mouseover', listener);
      return () => {
        node.removeEventListener('mouseout', listener);
        node.removeEventListener('mouseover', listener); // Remove class in case it lingers.

        node.classList.remove('is-hovered');
      };
    }
  }, [isEnabled]);
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-list/use-block-props/use-block-class-names.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


/**
 * Returns the class names used for the different states of the block.
 *
 * @param {string} clientId The block client ID.
 *
 * @return {string} The class names.
 */

function useBlockClassNames(clientId) {
  return (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      isBlockBeingDragged,
      isBlockHighlighted,
      isBlockSelected,
      isBlockMultiSelected,
      getBlockName,
      getSettings,
      hasSelectedInnerBlock,
      isTyping,
      __experimentalGetActiveBlockIdByBlockNames: getActiveBlockIdByBlockNames
    } = select(store);
    const {
      __experimentalSpotlightEntityBlocks: spotlightEntityBlocks,
      outlineMode
    } = getSettings();
    const isDragging = isBlockBeingDragged(clientId);
    const isSelected = isBlockSelected(clientId);
    const name = getBlockName(clientId);
    const checkDeep = true; // "ancestor" is the more appropriate label due to "deep" check.

    const isAncestorOfSelectedBlock = hasSelectedInnerBlock(clientId, checkDeep);
    const activeEntityBlockId = getActiveBlockIdByBlockNames(spotlightEntityBlocks);
    return classnames_default()({
      'is-selected': isSelected,
      'is-highlighted': isBlockHighlighted(clientId),
      'is-multi-selected': isBlockMultiSelected(clientId),
      'is-reusable': (0,external_wp_blocks_namespaceObject.isReusableBlock)((0,external_wp_blocks_namespaceObject.getBlockType)(name)),
      'is-dragging': isDragging,
      'has-child-selected': isAncestorOfSelectedBlock,
      'has-active-entity': activeEntityBlockId,
      // Determine if there is an active entity area to spotlight.
      'is-active-entity': activeEntityBlockId === clientId,
      'remove-outline': isSelected && outlineMode && isTyping()
    });
  }, [clientId]);
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-list/use-block-props/use-block-default-class-name.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Returns the default class name if the block is a light block and it supports
 * `className`.
 *
 * @param {string} clientId The block client ID.
 *
 * @return {string} The class name, e.g. `wp-block-paragraph`.
 */

function useBlockDefaultClassName(clientId) {
  return (0,external_wp_data_namespaceObject.useSelect)(select => {
    const name = select(store).getBlockName(clientId);
    const blockType = (0,external_wp_blocks_namespaceObject.getBlockType)(name);
    const hasLightBlockWrapper = (blockType === null || blockType === void 0 ? void 0 : blockType.apiVersion) > 1;

    if (!hasLightBlockWrapper) {
      return;
    }

    return (0,external_wp_blocks_namespaceObject.getBlockDefaultClassName)(name);
  }, [clientId]);
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-list/use-block-props/use-block-custom-class-name.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Returns the custom class name if the block is a light block.
 *
 * @param {string} clientId The block client ID.
 *
 * @return {string} The custom class name.
 */

function useBlockCustomClassName(clientId) {
  // It's good for this to be a separate selector because it will be executed
  // on every attribute change, while the other selectors are not re-evaluated
  // as much.
  return (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getBlockName,
      getBlockAttributes
    } = select(store);
    const attributes = getBlockAttributes(clientId);

    if (!(attributes !== null && attributes !== void 0 && attributes.className)) {
      return;
    }

    const blockType = (0,external_wp_blocks_namespaceObject.getBlockType)(getBlockName(clientId));
    const hasLightBlockWrapper = (blockType === null || blockType === void 0 ? void 0 : blockType.apiVersion) > 1;

    if (!hasLightBlockWrapper) {
      return;
    }

    return attributes.className;
  }, [clientId]);
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-list/use-block-props/use-block-moving-mode-class-names.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Returns the class names used for block moving mode.
 *
 * @param {string} clientId The block client ID to insert above.
 *
 * @return {string} The class names.
 */

function useBlockMovingModeClassNames(clientId) {
  return (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      hasBlockMovingClientId,
      canInsertBlockType,
      getBlockName,
      getBlockRootClientId,
      isBlockSelected
    } = select(store); // The classes are only relevant for the selected block. Avoid
    // re-rendering all blocks!

    if (!isBlockSelected(clientId)) {
      return;
    }

    const movingClientId = hasBlockMovingClientId();

    if (!movingClientId) {
      return;
    }

    return classnames_default()('is-block-moving-mode', {
      'can-insert-moving-block': canInsertBlockType(getBlockName(movingClientId), getBlockRootClientId(clientId))
    });
  }, [clientId]);
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-list/use-block-props/use-focus-handler.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



/**
 * Selects the block if it receives focus.
 *
 * @param {string} clientId Block client ID.
 */

function useFocusHandler(clientId) {
  const {
    isBlockSelected
  } = (0,external_wp_data_namespaceObject.useSelect)(store);
  const {
    selectBlock,
    selectionChange
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  return (0,external_wp_compose_namespaceObject.useRefEffect)(node => {
    /**
     * Marks the block as selected when focused and not already
     * selected. This specifically handles the case where block does not
     * set focus on its own (via `setFocus`), typically if there is no
     * focusable input in the block.
     *
     * @param {FocusEvent} event Focus event.
     */
    function onFocus(event) {
      // Check synchronously because a non-selected block might be
      // getting data through `useSelect` asynchronously.
      if (isBlockSelected(clientId)) {
        // Potentially change selection away from rich text.
        if (!event.target.isContentEditable) {
          selectionChange(clientId);
        }

        return;
      } // If an inner block is focussed, that block is resposible for
      // setting the selected block.


      if (!isInsideRootBlock(node, event.target)) {
        return;
      }

      selectBlock(clientId);
    }

    node.addEventListener('focusin', onFocus);
    return () => {
      node.removeEventListener('focusin', onFocus);
    };
  }, [isBlockSelected, selectBlock]);
}

;// CONCATENATED MODULE: external ["wp","keycodes"]
var external_wp_keycodes_namespaceObject = window["wp"]["keycodes"];
;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-list/use-block-props/use-selected-block-event-handlers.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


/**
 * Adds block behaviour:
 *   - Removes the block on BACKSPACE.
 *   - Inserts a default block on ENTER.
 *   - Disables dragging of block contents.
 *
 * @param {string} clientId Block client ID.
 */

function useEventHandlers(clientId) {
  const isSelected = (0,external_wp_data_namespaceObject.useSelect)(select => select(store).isBlockSelected(clientId), [clientId]);
  const {
    getBlockRootClientId,
    getBlockIndex
  } = (0,external_wp_data_namespaceObject.useSelect)(store);
  const {
    insertDefaultBlock,
    removeBlock
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  return (0,external_wp_compose_namespaceObject.useRefEffect)(node => {
    if (!isSelected) {
      return;
    }
    /**
     * Interprets keydown event intent to remove or insert after block if
     * key event occurs on wrapper node. This can occur when the block has
     * no text fields of its own, particularly after initial insertion, to
     * allow for easy deletion and continuous writing flow to add additional
     * content.
     *
     * @param {KeyboardEvent} event Keydown event.
     */


    function onKeyDown(event) {
      const {
        keyCode,
        target
      } = event;

      if (keyCode !== external_wp_keycodes_namespaceObject.ENTER && keyCode !== external_wp_keycodes_namespaceObject.BACKSPACE && keyCode !== external_wp_keycodes_namespaceObject.DELETE) {
        return;
      }

      if (target !== node || (0,external_wp_dom_namespaceObject.isTextField)(target)) {
        return;
      }

      event.preventDefault();

      if (keyCode === external_wp_keycodes_namespaceObject.ENTER) {
        insertDefaultBlock({}, getBlockRootClientId(clientId), getBlockIndex(clientId) + 1);
      } else {
        removeBlock(clientId);
      }
    }
    /**
     * Prevents default dragging behavior within a block. To do: we must
     * handle this in the future and clean up the drag target.
     *
     * @param {DragEvent} event Drag event.
     */


    function onDragStart(event) {
      event.preventDefault();
    }

    node.addEventListener('keydown', onKeyDown);
    node.addEventListener('dragstart', onDragStart);
    return () => {
      node.removeEventListener('keydown', onKeyDown);
      node.removeEventListener('dragstart', onDragStart);
    };
  }, [clientId, isSelected, getBlockRootClientId, getBlockIndex, insertDefaultBlock, removeBlock]);
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-list/use-block-props/use-nav-mode-exit.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Allows navigation mode to be exited by clicking in the selected block.
 *
 * @param {string} clientId Block client ID.
 */

function useNavModeExit(clientId) {
  const {
    isNavigationMode,
    isBlockSelected
  } = (0,external_wp_data_namespaceObject.useSelect)(store);
  const {
    setNavigationMode,
    selectBlock
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  return (0,external_wp_compose_namespaceObject.useRefEffect)(node => {
    function onMouseDown(event) {
      // Don't select a block if it's already handled by a child
      // block.
      if (isNavigationMode() && !event.defaultPrevented) {
        // Prevent focus from moving to the block.
        event.preventDefault(); // When clicking on a selected block, exit navigation mode.

        if (isBlockSelected(clientId)) {
          setNavigationMode(false);
        } else {
          selectBlock(clientId);
        }
      }
    }

    node.addEventListener('mousedown', onMouseDown);
    return () => {
      node.addEventListener('mousedown', onMouseDown);
    };
  }, [clientId, isNavigationMode, isBlockSelected, setNavigationMode]);
}

// EXTERNAL MODULE: ./node_modules/dom-scroll-into-view/lib/index.js
var dom_scroll_into_view_lib = __webpack_require__(5425);
var lib_default = /*#__PURE__*/__webpack_require__.n(dom_scroll_into_view_lib);
;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-list/use-block-props/use-scroll-into-view.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


function useScrollIntoView(clientId) {
  const ref = (0,external_wp_element_namespaceObject.useRef)();
  const isSelectionEnd = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      isBlockSelected,
      getBlockSelectionEnd
    } = select(store);
    return isBlockSelected(clientId) || getBlockSelectionEnd() === clientId;
  }, [clientId]); // Note that we can't use `useRefEffect` here, since an element change does
  // not mean we can scroll. `isSelectionEnd` should be the sole dependency,
  // while with `useRefEffect`, the element is a dependency as well.

  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (!isSelectionEnd) {
      return;
    }

    const extentNode = ref.current;

    if (!extentNode) {
      return;
    } // If the block is focused, the browser will already have scrolled into
    // view if necessary.


    if (extentNode.contains(extentNode.ownerDocument.activeElement)) {
      return;
    }

    const scrollContainer = (0,external_wp_dom_namespaceObject.getScrollContainer)(extentNode) || extentNode.ownerDocument.defaultView; // If there's no scroll container, it follows that there's no scrollbar
    // and thus there's no need to try to scroll into view.

    if (!scrollContainer) {
      return;
    }

    lib_default()(extentNode, scrollContainer, {
      onlyScrollIfNeeded: true
    });
  }, [isSelectionEnd]);
  return ref;
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/provider/block-refs-provider.js


/**
 * WordPress dependencies
 */

const BlockRefs = (0,external_wp_element_namespaceObject.createContext)({
  refs: new Map(),
  callbacks: new Map()
});
function BlockRefsProvider(_ref) {
  let {
    children
  } = _ref;
  const value = (0,external_wp_element_namespaceObject.useMemo)(() => ({
    refs: new Map(),
    callbacks: new Map()
  }), []);
  return (0,external_wp_element_namespaceObject.createElement)(BlockRefs.Provider, {
    value: value
  }, children);
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-list/use-block-props/use-block-refs.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/** @typedef {import('@wordpress/element').RefCallback} RefCallback */

/** @typedef {import('@wordpress/element').RefObject} RefObject */

/**
 * Provides a ref to the BlockRefs context.
 *
 * @param {string} clientId The client ID of the element ref.
 *
 * @return {RefCallback} Ref callback.
 */

function useBlockRefProvider(clientId) {
  const {
    refs,
    callbacks
  } = (0,external_wp_element_namespaceObject.useContext)(BlockRefs);
  const ref = (0,external_wp_element_namespaceObject.useRef)();
  (0,external_wp_element_namespaceObject.useLayoutEffect)(() => {
    refs.set(ref, clientId);
    return () => {
      refs.delete(ref);
    };
  }, [clientId]);
  return (0,external_wp_compose_namespaceObject.useRefEffect)(element => {
    // Update the ref in the provider.
    ref.current = element; // Call any update functions.

    callbacks.forEach((id, setElement) => {
      if (clientId === id) {
        setElement(element);
      }
    });
  }, [clientId]);
}
/**
 * Gets a ref pointing to the current block element. Continues to return a
 * stable ref even if the block client ID changes.
 *
 * @param {string} clientId The client ID to get a ref for.
 *
 * @return {RefObject} A ref containing the element.
 */

function useBlockRef(clientId) {
  const {
    refs
  } = (0,external_wp_element_namespaceObject.useContext)(BlockRefs);
  const freshClientId = (0,external_wp_element_namespaceObject.useRef)();
  freshClientId.current = clientId; // Always return an object, even if no ref exists for a given client ID, so
  // that `current` works at a later point.

  return (0,external_wp_element_namespaceObject.useMemo)(() => ({
    get current() {
      let element = null; // Multiple refs may be created for a single block. Find the
      // first that has an element set.

      for (const [ref, id] of refs.entries()) {
        if (id === freshClientId.current && ref.current) {
          element = ref.current;
        }
      }

      return element;
    }

  }), []);
}
/**
 * Return the element for a given client ID. Updates whenever the element
 * changes, becomes available, or disappears.
 *
 * @param {string} clientId The client ID to an element for.
 *
 * @return {Element|null} The block's wrapper element.
 */


function useBlockElement(clientId) {
  const {
    callbacks
  } = (0,external_wp_element_namespaceObject.useContext)(BlockRefs);
  const ref = useBlockRef(clientId);
  const [element, setElement] = (0,external_wp_element_namespaceObject.useState)(null);
  (0,external_wp_element_namespaceObject.useLayoutEffect)(() => {
    if (!clientId) {
      return;
    }

    callbacks.set(setElement, clientId);
    return () => {
      callbacks.delete(setElement);
    };
  }, [clientId]);
  return ref.current || element;
}




;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-list/use-block-props/use-intersection-observer.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function useIntersectionObserver() {
  const observer = (0,external_wp_element_namespaceObject.useContext)(IntersectionObserver);
  return (0,external_wp_compose_namespaceObject.useRefEffect)(node => {
    if (observer) {
      observer.observe(node);
      return () => {
        observer.unobserve(node);
      };
    }
  }, [observer]);
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-list/use-block-props/index.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */







/**
 * Internal dependencies
 */


















/**
 * If the block count exceeds the threshold, we disable the reordering animation
 * to avoid laginess.
 */

const BLOCK_ANIMATION_THRESHOLD = 200;
/**
 * This hook is used to lightly mark an element as a block element. The element
 * should be the outermost element of a block. Call this hook and pass the
 * returned props to the element to mark as a block. If you define a ref for the
 * element, it is important to pass the ref to this hook, which the hook in turn
 * will pass to the component through the props it returns. Optionally, you can
 * also pass any other props through this hook, and they will be merged and
 * returned.
 *
 * @param {Object}  props                    Optional. Props to pass to the element. Must contain
 *                                           the ref if one is defined.
 * @param {Object}  options                  Options for internal use only.
 * @param {boolean} options.__unstableIsHtml
 *
 * @return {Object} Props to pass to the element to mark as a block.
 */

function useBlockProps() {
  let props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  let {
    __unstableIsHtml
  } = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  const {
    clientId,
    className,
    wrapperProps = {},
    isAligned
  } = (0,external_wp_element_namespaceObject.useContext)(BlockListBlockContext);
  const {
    index,
    mode,
    name,
    blockApiVersion,
    blockTitle,
    isPartOfSelection,
    adjustScrolling,
    enableAnimation
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getBlockIndex,
      getBlockMode,
      getBlockName,
      isTyping,
      getGlobalBlockCount,
      isBlockSelected,
      isBlockMultiSelected,
      isAncestorMultiSelected,
      isFirstMultiSelectedBlock
    } = select(store);
    const isSelected = isBlockSelected(clientId);
    const isPartOfMultiSelection = isBlockMultiSelected(clientId) || isAncestorMultiSelected(clientId);
    const blockName = getBlockName(clientId);
    const blockType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockName);
    return {
      index: getBlockIndex(clientId),
      mode: getBlockMode(clientId),
      name: blockName,
      blockApiVersion: (blockType === null || blockType === void 0 ? void 0 : blockType.apiVersion) || 1,
      blockTitle: blockType === null || blockType === void 0 ? void 0 : blockType.title,
      isPartOfSelection: isSelected || isPartOfMultiSelection,
      adjustScrolling: isSelected || isFirstMultiSelectedBlock(clientId),
      enableAnimation: !isTyping() && getGlobalBlockCount() <= BLOCK_ANIMATION_THRESHOLD
    };
  }, [clientId]); // translators: %s: Type of block (i.e. Text, Image etc)

  const blockLabel = (0,external_wp_i18n_namespaceObject.sprintf)((0,external_wp_i18n_namespaceObject.__)('Block: %s'), blockTitle);
  const htmlSuffix = mode === 'html' && !__unstableIsHtml ? '-visual' : '';
  const mergedRefs = (0,external_wp_compose_namespaceObject.useMergeRefs)([props.ref, useFocusFirstElement(clientId), // Must happen after focus because we check for focus in the block.
  useScrollIntoView(clientId), useBlockRefProvider(clientId), useFocusHandler(clientId), useMultiSelection(clientId), useEventHandlers(clientId), useNavModeExit(clientId), useIsHovered(), useIntersectionObserver(), use_moving_animation({
    isSelected: isPartOfSelection,
    adjustScrolling,
    enableAnimation,
    triggerAnimationOnChange: index
  })]);
  const blockEditContext = useBlockEditContext(); // Ensures it warns only inside the `edit` implementation for the block.

  if (blockApiVersion < 2 && clientId === blockEditContext.clientId) {
    typeof process !== "undefined" && process.env && "production" !== "production" ? 0 : void 0;
  }

  return { ...wrapperProps,
    ...props,
    ref: mergedRefs,
    id: `block-${clientId}${htmlSuffix}`,
    tabIndex: 0,
    role: 'document',
    'aria-label': blockLabel,
    'data-block': clientId,
    'data-type': name,
    'data-title': blockTitle,
    className: classnames_default()( // The wp-block className is important for editor styles.
    classnames_default()('block-editor-block-list__block', {
      'wp-block': !isAligned
    }), className, props.className, wrapperProps.className, useBlockClassNames(clientId), useBlockDefaultClassName(clientId), useBlockCustomClassName(clientId), useBlockMovingModeClassNames(clientId)),
    style: { ...wrapperProps.style,
      ...props.style
    }
  };
}
/**
 * Call within a save function to get the props for the block wrapper.
 *
 * @param {Object} props Optional. Props to pass to the element.
 */

useBlockProps.save = external_wp_blocks_namespaceObject.__unstableGetBlockProps;

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-list/block.js


/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */







/**
 * Internal dependencies
 */








const BlockListBlockContext = (0,external_wp_element_namespaceObject.createContext)();
/**
 * Merges wrapper props with special handling for classNames and styles.
 *
 * @param {Object} propsA
 * @param {Object} propsB
 *
 * @return {Object} Merged props.
 */

function mergeWrapperProps(propsA, propsB) {
  const newProps = { ...propsA,
    ...propsB
  };

  if (propsA && propsB && propsA.className && propsB.className) {
    newProps.className = classnames_default()(propsA.className, propsB.className);
  }

  if (propsA && propsB && propsA.style && propsB.style) {
    newProps.style = { ...propsA.style,
      ...propsB.style
    };
  }

  return newProps;
}

function Block(_ref) {
  let {
    children,
    isHtml,
    ...props
  } = _ref;
  return (0,external_wp_element_namespaceObject.createElement)("div", useBlockProps(props, {
    __unstableIsHtml: isHtml
  }), children);
}

function BlockListBlock(_ref2) {
  var _wrapperProps;

  let {
    mode,
    isLocked,
    canRemove,
    clientId,
    isSelected,
    isSelectionEnabled,
    className,
    name,
    isValid,
    attributes,
    wrapperProps,
    setAttributes,
    onReplace,
    onInsertBlocksAfter,
    onMerge,
    toggleSelection
  } = _ref2;
  const themeSupportsLayout = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getSettings
    } = select(store);
    return getSettings().supportsLayout;
  }, []);
  const {
    removeBlock
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const onRemove = (0,external_wp_element_namespaceObject.useCallback)(() => removeBlock(clientId), [clientId]); // We wrap the BlockEdit component in a div that hides it when editing in
  // HTML mode. This allows us to render all of the ancillary pieces
  // (InspectorControls, etc.) which are inside `BlockEdit` but not
  // `BlockHTML`, even in HTML mode.

  let blockEdit = (0,external_wp_element_namespaceObject.createElement)(BlockEdit, {
    name: name,
    isSelected: isSelected,
    attributes: attributes,
    setAttributes: setAttributes,
    insertBlocksAfter: isLocked ? undefined : onInsertBlocksAfter,
    onReplace: canRemove ? onReplace : undefined,
    onRemove: canRemove ? onRemove : undefined,
    mergeBlocks: canRemove ? onMerge : undefined,
    clientId: clientId,
    isSelectionEnabled: isSelectionEnabled,
    toggleSelection: toggleSelection
  });
  const blockType = (0,external_wp_blocks_namespaceObject.getBlockType)(name); // Determine whether the block has props to apply to the wrapper.

  if (blockType !== null && blockType !== void 0 && blockType.getEditWrapperProps) {
    wrapperProps = mergeWrapperProps(wrapperProps, blockType.getEditWrapperProps(attributes));
  }

  const isAligned = wrapperProps && !!wrapperProps['data-align'] && !themeSupportsLayout; // For aligned blocks, provide a wrapper element so the block can be
  // positioned relative to the block column.
  // This is only kept for classic themes that don't support layout
  // Historically we used to rely on extra divs and data-align to
  // provide the alignments styles in the editor.
  // Due to the differences between frontend and backend, we migrated
  // to the layout feature, and we're now aligning the markup of frontend
  // and backend.

  if (isAligned) {
    blockEdit = (0,external_wp_element_namespaceObject.createElement)("div", {
      className: "wp-block",
      "data-align": wrapperProps['data-align']
    }, blockEdit);
  }

  let block;

  if (!isValid) {
    const saveContent = (0,external_wp_blocks_namespaceObject.getSaveContent)(blockType, attributes);
    block = (0,external_wp_element_namespaceObject.createElement)(Block, {
      className: "has-warning"
    }, (0,external_wp_element_namespaceObject.createElement)(block_invalid_warning, {
      clientId: clientId
    }), (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.RawHTML, null, (0,external_wp_dom_namespaceObject.safeHTML)(saveContent)));
  } else if (mode === 'html') {
    // Render blockEdit so the inspector controls don't disappear.
    // See #8969.
    block = (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)("div", {
      style: {
        display: 'none'
      }
    }, blockEdit), (0,external_wp_element_namespaceObject.createElement)(Block, {
      isHtml: true
    }, (0,external_wp_element_namespaceObject.createElement)(block_html, {
      clientId: clientId
    })));
  } else if ((blockType === null || blockType === void 0 ? void 0 : blockType.apiVersion) > 1) {
    block = blockEdit;
  } else {
    block = (0,external_wp_element_namespaceObject.createElement)(Block, wrapperProps, blockEdit);
  }

  const value = {
    clientId,
    className: (_wrapperProps = wrapperProps) !== null && _wrapperProps !== void 0 && _wrapperProps['data-align'] && themeSupportsLayout ? classnames_default()(className, `align${wrapperProps['data-align']}`) : className,
    wrapperProps: (0,external_lodash_namespaceObject.omit)(wrapperProps, ['data-align']),
    isAligned
  };
  const memoizedValue = (0,external_wp_element_namespaceObject.useMemo)(() => value, Object.values(value));
  return (0,external_wp_element_namespaceObject.createElement)(BlockListBlockContext.Provider, {
    value: memoizedValue
  }, (0,external_wp_element_namespaceObject.createElement)(block_crash_boundary, {
    fallback: (0,external_wp_element_namespaceObject.createElement)(Block, {
      className: "has-warning"
    }, (0,external_wp_element_namespaceObject.createElement)(block_crash_warning, null))
  }, block));
}

const applyWithSelect = (0,external_wp_data_namespaceObject.withSelect)((select, _ref3) => {
  let {
    clientId,
    rootClientId
  } = _ref3;
  const {
    isBlockSelected,
    getBlockMode,
    isSelectionEnabled,
    getTemplateLock,
    __unstableGetBlockWithoutInnerBlocks,
    canRemoveBlock,
    canMoveBlock
  } = select(store);

  const block = __unstableGetBlockWithoutInnerBlocks(clientId);

  const isSelected = isBlockSelected(clientId);
  const templateLock = getTemplateLock(rootClientId);
  const canRemove = canRemoveBlock(clientId, rootClientId);
  const canMove = canMoveBlock(clientId, rootClientId); // The fallback to `{}` is a temporary fix.
  // This function should never be called when a block is not present in
  // the state. It happens now because the order in withSelect rendering
  // is not correct.

  const {
    name,
    attributes,
    isValid
  } = block || {}; // Do not add new properties here, use `useSelect` instead to avoid
  // leaking new props to the public API (editor.BlockListBlock filter).

  return {
    mode: getBlockMode(clientId),
    isSelectionEnabled: isSelectionEnabled(),
    isLocked: !!templateLock,
    canRemove,
    canMove,
    // Users of the editor.BlockListBlock filter used to be able to
    // access the block prop.
    // Ideally these blocks would rely on the clientId prop only.
    // This is kept for backward compatibility reasons.
    block,
    name,
    attributes,
    isValid,
    isSelected
  };
});
const applyWithDispatch = (0,external_wp_data_namespaceObject.withDispatch)((dispatch, ownProps, _ref4) => {
  let {
    select
  } = _ref4;
  const {
    updateBlockAttributes,
    insertBlocks,
    mergeBlocks,
    replaceBlocks,
    toggleSelection,
    __unstableMarkLastChangeAsPersistent
  } = dispatch(store); // Do not add new properties here, use `useDispatch` instead to avoid
  // leaking new props to the public API (editor.BlockListBlock filter).

  return {
    setAttributes(newAttributes) {
      const {
        getMultiSelectedBlockClientIds
      } = select(store);
      const multiSelectedBlockClientIds = getMultiSelectedBlockClientIds();
      const {
        clientId
      } = ownProps;
      const clientIds = multiSelectedBlockClientIds.length ? multiSelectedBlockClientIds : [clientId];
      updateBlockAttributes(clientIds, newAttributes);
    },

    onInsertBlocks(blocks, index) {
      const {
        rootClientId
      } = ownProps;
      insertBlocks(blocks, index, rootClientId);
    },

    onInsertBlocksAfter(blocks) {
      const {
        clientId,
        rootClientId
      } = ownProps;
      const {
        getBlockIndex
      } = select(store);
      const index = getBlockIndex(clientId);
      insertBlocks(blocks, index + 1, rootClientId);
    },

    onMerge(forward) {
      const {
        clientId
      } = ownProps;
      const {
        getPreviousBlockClientId,
        getNextBlockClientId
      } = select(store);

      if (forward) {
        const nextBlockClientId = getNextBlockClientId(clientId);

        if (nextBlockClientId) {
          mergeBlocks(clientId, nextBlockClientId);
        }
      } else {
        const previousBlockClientId = getPreviousBlockClientId(clientId);

        if (previousBlockClientId) {
          mergeBlocks(previousBlockClientId, clientId);
        }
      }
    },

    onReplace(blocks, indexToSelect, initialPosition) {
      if (blocks.length && !(0,external_wp_blocks_namespaceObject.isUnmodifiedDefaultBlock)(blocks[blocks.length - 1])) {
        __unstableMarkLastChangeAsPersistent();
      }

      replaceBlocks([ownProps.clientId], blocks, indexToSelect, initialPosition);
    },

    toggleSelection(selectionEnabled) {
      toggleSelection(selectionEnabled);
    }

  };
});
/* harmony default export */ var block = ((0,external_wp_compose_namespaceObject.compose)(external_wp_compose_namespaceObject.pure, applyWithSelect, applyWithDispatch, // Block is sometimes not mounted at the right time, causing it be undefined
// see issue for more info
// https://github.com/WordPress/gutenberg/issues/17013
(0,external_wp_compose_namespaceObject.ifCondition)(_ref5 => {
  let {
    block
  } = _ref5;
  return !!block;
}), (0,external_wp_components_namespaceObject.withFilters)('editor.BlockListBlock'))(BlockListBlock));

;// CONCATENATED MODULE: external ["wp","htmlEntities"]
var external_wp_htmlEntities_namespaceObject = window["wp"]["htmlEntities"];
;// CONCATENATED MODULE: ./packages/icons/build-module/library/plus.js


/**
 * WordPress dependencies
 */

const plus = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M18 11.2h-5.2V6h-1.6v5.2H6v1.6h5.2V18h1.6v-5.2H18z"
}));
/* harmony default export */ var library_plus = (plus);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inserter/tips.js


/**
 * WordPress dependencies
 */



const globalTips = [(0,external_wp_element_namespaceObject.createInterpolateElement)((0,external_wp_i18n_namespaceObject.__)('While writing, you can press <kbd>/</kbd> to quickly insert new blocks.'), {
  kbd: (0,external_wp_element_namespaceObject.createElement)("kbd", null)
}), (0,external_wp_element_namespaceObject.createInterpolateElement)((0,external_wp_i18n_namespaceObject.__)('Indent a list by pressing <kbd>space</kbd> at the beginning of a line.'), {
  kbd: (0,external_wp_element_namespaceObject.createElement)("kbd", null)
}), (0,external_wp_element_namespaceObject.createInterpolateElement)((0,external_wp_i18n_namespaceObject.__)('Outdent a list by pressing <kbd>backspace</kbd> at the beginning of a line.'), {
  kbd: (0,external_wp_element_namespaceObject.createElement)("kbd", null)
}), (0,external_wp_i18n_namespaceObject.__)('Drag files into the editor to automatically insert media blocks.'), (0,external_wp_i18n_namespaceObject.__)("Change a block's type by pressing the block icon on the toolbar.")];

function Tips() {
  const [randomIndex] = (0,external_wp_element_namespaceObject.useState)( // Disable Reason: I'm not generating an HTML id.
  // eslint-disable-next-line no-restricted-syntax
  Math.floor(Math.random() * globalTips.length));
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Tip, null, globalTips[randomIndex]);
}

/* harmony default export */ var tips = (Tips);

;// CONCATENATED MODULE: ./packages/icons/build-module/library/block-default.js


/**
 * WordPress dependencies
 */

const blockDefault = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M19 8h-1V6h-5v2h-2V6H6v2H5c-1.1 0-2 .9-2 2v8c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2v-8c0-1.1-.9-2-2-2zm.5 10c0 .3-.2.5-.5.5H5c-.3 0-.5-.2-.5-.5v-8c0-.3.2-.5.5-.5h14c.3 0 .5.2.5.5v8z"
}));
/* harmony default export */ var block_default = (blockDefault);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-icon/index.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */





function BlockIcon(_ref) {
  var _icon;

  let {
    icon,
    showColors = false,
    className
  } = _ref;

  if (((_icon = icon) === null || _icon === void 0 ? void 0 : _icon.src) === 'block-default') {
    icon = {
      src: block_default
    };
  }

  const renderedIcon = (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Icon, {
    icon: icon && icon.src ? icon.src : icon
  });
  const style = showColors ? {
    backgroundColor: icon && icon.background,
    color: icon && icon.foreground
  } : {};
  return (0,external_wp_element_namespaceObject.createElement)("span", {
    style: style,
    className: classnames_default()('block-editor-block-icon', className, {
      'has-colors': showColors
    })
  }, renderedIcon);
}

/* harmony default export */ var block_icon = ((0,external_wp_element_namespaceObject.memo)(BlockIcon));

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-card/index.js


/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */



function BlockCard(_ref) {
  let {
    title,
    icon,
    description,
    blockType
  } = _ref;

  if (blockType) {
    external_wp_deprecated_default()('`blockType` property in `BlockCard component`', {
      since: '5.7',
      alternative: '`title, icon and description` properties'
    });
    ({
      title,
      icon,
      description
    } = blockType);
  }

  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-block-card"
  }, (0,external_wp_element_namespaceObject.createElement)(block_icon, {
    icon: icon,
    showColors: true
  }), (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-block-card__content"
  }, (0,external_wp_element_namespaceObject.createElement)("h2", {
    className: "block-editor-block-card__title"
  }, title), (0,external_wp_element_namespaceObject.createElement)("span", {
    className: "block-editor-block-card__description"
  }, description)));
}

/* harmony default export */ var block_card = (BlockCard);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/provider/with-registry-provider.js



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



const withRegistryProvider = (0,external_wp_compose_namespaceObject.createHigherOrderComponent)(WrappedComponent => {
  return (0,external_wp_data_namespaceObject.withRegistry)(_ref => {
    let {
      useSubRegistry = true,
      registry,
      ...props
    } = _ref;

    if (!useSubRegistry) {
      return (0,external_wp_element_namespaceObject.createElement)(WrappedComponent, _extends({
        registry: registry
      }, props));
    }

    const [subRegistry, setSubRegistry] = (0,external_wp_element_namespaceObject.useState)(null);
    (0,external_wp_element_namespaceObject.useEffect)(() => {
      const newRegistry = (0,external_wp_data_namespaceObject.createRegistry)({}, registry);
      newRegistry.registerStore(STORE_NAME, storeConfig);
      setSubRegistry(newRegistry);
    }, [registry]);

    if (!subRegistry) {
      return null;
    }

    return (0,external_wp_element_namespaceObject.createElement)(external_wp_data_namespaceObject.RegistryProvider, {
      value: subRegistry
    }, (0,external_wp_element_namespaceObject.createElement)(WrappedComponent, _extends({
      registry: subRegistry
    }, props)));
  });
}, 'withRegistryProvider');
/* harmony default export */ var with_registry_provider = (withRegistryProvider);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/provider/use-block-sync.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


/**
 * A function to call when the block value has been updated in the block-editor
 * store.
 *
 * @callback onBlockUpdate
 * @param {Object[]} blocks  The updated blocks.
 * @param {Object}   options The updated block options, such as selectionStart
 *                           and selectionEnd.
 */

/**
 * useBlockSync is a side effect which handles bidirectional sync between the
 * block-editor store and a controlling data source which provides blocks. This
 * is most commonly used by the BlockEditorProvider to synchronize the contents
 * of the block-editor store with the root entity, like a post.
 *
 * Another example would be the template part block, which provides blocks from
 * a separate entity data source than a root entity. This hook syncs edits to
 * the template part in the block editor back to the entity and vice-versa.
 *
 * Here are some of its basic functions:
 * - Initalizes the block-editor store for the given clientID to the blocks
 *   given via props.
 * - Adds incoming changes (like undo) to the block-editor store.
 * - Adds outgoing changes (like editing content) to the controlling entity,
 *   determining if a change should be considered persistent or not.
 * - Handles edge cases and race conditions which occur in those operations.
 * - Ignores changes which happen to other entities (like nested inner block
 *   controllers.
 * - Passes selection state from the block-editor store to the controlling entity.
 *
 * @param {Object}        props           Props for the block sync hook
 * @param {string}        props.clientId  The client ID of the inner block controller.
 *                                        If none is passed, then it is assumed to be a
 *                                        root controller rather than an inner block
 *                                        controller.
 * @param {Object[]}      props.value     The control value for the blocks. This value
 *                                        is used to initalize the block-editor store
 *                                        and for resetting the blocks to incoming
 *                                        changes like undo.
 * @param {Object}        props.selection The selection state responsible to restore the selection on undo/redo.
 * @param {onBlockUpdate} props.onChange  Function to call when a persistent
 *                                        change has been made in the block-editor blocks
 *                                        for the given clientId. For example, after
 *                                        this function is called, an entity is marked
 *                                        dirty because it has changes to save.
 * @param {onBlockUpdate} props.onInput   Function to call when a non-persistent
 *                                        change has been made in the block-editor blocks
 *                                        for the given clientId. When this is called,
 *                                        controlling sources do not become dirty.
 */

function useBlockSync(_ref) {
  let {
    clientId = null,
    value: controlledBlocks,
    selection: controlledSelection,
    onChange = external_lodash_namespaceObject.noop,
    onInput = external_lodash_namespaceObject.noop
  } = _ref;
  const registry = (0,external_wp_data_namespaceObject.useRegistry)();
  const {
    resetBlocks,
    resetSelection,
    replaceInnerBlocks,
    setHasControlledInnerBlocks,
    __unstableMarkNextChangeAsNotPersistent
  } = registry.dispatch(store);
  const {
    getBlockName,
    getBlocks
  } = registry.select(store);
  const isControlled = (0,external_wp_data_namespaceObject.useSelect)(select => {
    return !clientId || select(store).areInnerBlocksControlled(clientId);
  }, [clientId]);
  const pendingChanges = (0,external_wp_element_namespaceObject.useRef)({
    incoming: null,
    outgoing: []
  });
  const subscribed = (0,external_wp_element_namespaceObject.useRef)(false);

  const setControlledBlocks = () => {
    if (!controlledBlocks) {
      return;
    } // We don't need to persist this change because we only replace
    // controlled inner blocks when the change was caused by an entity,
    // and so it would already be persisted.


    __unstableMarkNextChangeAsNotPersistent();

    if (clientId) {
      // It is important to batch here because otherwise,
      // as soon as `setHasControlledInnerBlocks` is called
      // the effect to restore might be triggered
      // before the actual blocks get set properly in state.
      registry.batch(() => {
        setHasControlledInnerBlocks(clientId, true);
        const storeBlocks = controlledBlocks.map(block => (0,external_wp_blocks_namespaceObject.cloneBlock)(block));

        if (subscribed.current) {
          pendingChanges.current.incoming = storeBlocks;
        }

        __unstableMarkNextChangeAsNotPersistent();

        replaceInnerBlocks(clientId, storeBlocks);
      });
    } else {
      if (subscribed.current) {
        pendingChanges.current.incoming = controlledBlocks;
      }

      resetBlocks(controlledBlocks);
    }
  }; // Add a subscription to the block-editor registry to detect when changes
  // have been made. This lets us inform the data source of changes. This
  // is an effect so that the subscriber can run synchronously without
  // waiting for React renders for changes.


  const onInputRef = (0,external_wp_element_namespaceObject.useRef)(onInput);
  const onChangeRef = (0,external_wp_element_namespaceObject.useRef)(onChange);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    onInputRef.current = onInput;
    onChangeRef.current = onChange;
  }, [onInput, onChange]); // Determine if blocks need to be reset when they change.

  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (pendingChanges.current.outgoing.includes(controlledBlocks)) {
      // Skip block reset if the value matches expected outbound sync
      // triggered by this component by a preceding change detection.
      // Only skip if the value matches expectation, since a reset should
      // still occur if the value is modified (not equal by reference),
      // to allow that the consumer may apply modifications to reflect
      // back on the editor.
      if ((0,external_lodash_namespaceObject.last)(pendingChanges.current.outgoing) === controlledBlocks) {
        pendingChanges.current.outgoing = [];
      }
    } else if (getBlocks(clientId) !== controlledBlocks) {
      // Reset changing value in all other cases than the sync described
      // above. Since this can be reached in an update following an out-
      // bound sync, unset the outbound value to avoid considering it in
      // subsequent renders.
      pendingChanges.current.outgoing = [];
      setControlledBlocks();

      if (controlledSelection) {
        resetSelection(controlledSelection.selectionStart, controlledSelection.selectionEnd, controlledSelection.initialPosition);
      }
    }
  }, [controlledBlocks, clientId]);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    // When the block becomes uncontrolled, it means its inner state has been reset
    // we need to take the blocks again from the external value property.
    if (!isControlled) {
      pendingChanges.current.outgoing = [];
      setControlledBlocks();
    }
  }, [isControlled]);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    const {
      getSelectionStart,
      getSelectionEnd,
      getSelectedBlocksInitialCaretPosition,
      isLastBlockChangePersistent,
      __unstableIsLastBlockChangeIgnored,
      areInnerBlocksControlled
    } = registry.select(store);
    let blocks = getBlocks(clientId);
    let isPersistent = isLastBlockChangePersistent();
    let previousAreBlocksDifferent = false;
    subscribed.current = true;
    const unsubscribe = registry.subscribe(() => {
      // Sometimes, when changing block lists, lingering subscriptions
      // might trigger before they are cleaned up. If the block for which
      // the subscription runs is no longer in the store, this would clear
      // its parent entity's block list. To avoid this, we bail out if
      // the subscription is triggering for a block (`clientId !== null`)
      // and its block name can't be found because it's not on the list.
      // (`getBlockName( clientId ) === null`).
      if (clientId !== null && getBlockName(clientId) === null) return; // When RESET_BLOCKS on parent blocks get called, the controlled blocks
      // can reset to uncontrolled, in these situations, it means we need to populate
      // the blocks again from the external blocks (the value property here)
      // and we should stop triggering onChange

      const isStillControlled = !clientId || areInnerBlocksControlled(clientId);

      if (!isStillControlled) {
        return;
      }

      const newIsPersistent = isLastBlockChangePersistent();
      const newBlocks = getBlocks(clientId);
      const areBlocksDifferent = newBlocks !== blocks;
      blocks = newBlocks;

      if (areBlocksDifferent && (pendingChanges.current.incoming || __unstableIsLastBlockChangeIgnored())) {
        pendingChanges.current.incoming = null;
        isPersistent = newIsPersistent;
        return;
      } // Since we often dispatch an action to mark the previous action as
      // persistent, we need to make sure that the blocks changed on the
      // previous action before committing the change.


      const didPersistenceChange = previousAreBlocksDifferent && !areBlocksDifferent && newIsPersistent && !isPersistent;

      if (areBlocksDifferent || didPersistenceChange) {
        isPersistent = newIsPersistent; // We know that onChange/onInput will update controlledBlocks.
        // We need to be aware that it was caused by an outgoing change
        // so that we do not treat it as an incoming change later on,
        // which would cause a block reset.

        pendingChanges.current.outgoing.push(blocks); // Inform the controlling entity that changes have been made to
        // the block-editor store they should be aware about.

        const updateParent = isPersistent ? onChangeRef.current : onInputRef.current;
        updateParent(blocks, {
          selection: {
            selectionStart: getSelectionStart(),
            selectionEnd: getSelectionEnd(),
            initialPosition: getSelectedBlocksInitialCaretPosition()
          }
        });
      }

      previousAreBlocksDifferent = areBlocksDifferent;
    });
    return () => unsubscribe();
  }, [registry, clientId]);
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/provider/index.js


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





/** @typedef {import('@wordpress/data').WPDataRegistry} WPDataRegistry */

function BlockEditorProvider(props) {
  const {
    children,
    settings
  } = props;
  const {
    updateSettings
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    updateSettings(settings);
  }, [settings]); // Syncs the entity provider with changes in the block-editor store.

  useBlockSync(props);
  return (0,external_wp_element_namespaceObject.createElement)(BlockRefsProvider, null, children);
}

/* harmony default export */ var provider = (with_registry_provider(BlockEditorProvider));

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-preview/live.js


/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


function LiveBlockPreview(_ref) {
  let {
    onClick
  } = _ref;
  return (0,external_wp_element_namespaceObject.createElement)("div", {
    tabIndex: 0,
    role: "button",
    onClick: onClick,
    onKeyPress: onClick
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Disabled, null, (0,external_wp_element_namespaceObject.createElement)(BlockList, null)));
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-selection-clearer/index.js



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Pass the returned ref callback to an element that should clear block
 * selection. Selection will only be cleared if the element is clicked directly,
 * not if a child element is clicked.
 *
 * @return {import('react').RefCallback} Ref callback.
 */

function useBlockSelectionClearer() {
  const {
    hasSelectedBlock,
    hasMultiSelection
  } = (0,external_wp_data_namespaceObject.useSelect)(store);
  const {
    clearSelectedBlock
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  return (0,external_wp_compose_namespaceObject.useRefEffect)(node => {
    function onMouseDown(event) {
      if (!hasSelectedBlock() && !hasMultiSelection()) {
        return;
      } // Only handle clicks on the element, not the children.


      if (event.target !== node) {
        return;
      }

      clearSelectedBlock();
    }

    node.addEventListener('mousedown', onMouseDown);
    return () => {
      node.removeEventListener('mousedown', onMouseDown);
    };
  }, [hasSelectedBlock, hasMultiSelection, clearSelectedBlock]);
}
function BlockSelectionClearer(props) {
  return (0,external_wp_element_namespaceObject.createElement)("div", _extends({
    ref: useBlockSelectionClearer()
  }, props));
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/writing-flow/use-multi-selection.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



/**
 * Returns for the deepest node at the start or end of a container node. Ignores
 * any text nodes that only contain HTML formatting whitespace.
 *
 * @param {Element} node Container to search.
 * @param {string}  type 'start' or 'end'.
 */

function getDeepestNode(node, type) {
  const child = type === 'start' ? 'firstChild' : 'lastChild';
  const sibling = type === 'start' ? 'nextSibling' : 'previousSibling';

  while (node[child]) {
    node = node[child];

    while (node.nodeType === node.TEXT_NODE && /^[ \t\n]*$/.test(node.data) && node[sibling]) {
      node = node[sibling];
    }
  }

  return node;
}

function selector(select) {
  const {
    isMultiSelecting,
    getMultiSelectedBlockClientIds,
    hasMultiSelection,
    getSelectedBlockClientId,
    getSelectedBlocksInitialCaretPosition
  } = select(store);
  return {
    isMultiSelecting: isMultiSelecting(),
    multiSelectedBlockClientIds: getMultiSelectedBlockClientIds(),
    hasMultiSelection: hasMultiSelection(),
    selectedBlockClientId: getSelectedBlockClientId(),
    initialPosition: getSelectedBlocksInitialCaretPosition()
  };
}

function use_multi_selection_useMultiSelection() {
  const {
    initialPosition,
    isMultiSelecting,
    multiSelectedBlockClientIds,
    hasMultiSelection,
    selectedBlockClientId
  } = (0,external_wp_data_namespaceObject.useSelect)(selector, []);
  const selectedRef = useBlockRef(selectedBlockClientId); // These must be in the right DOM order.

  const startRef = useBlockRef((0,external_lodash_namespaceObject.first)(multiSelectedBlockClientIds));
  const endRef = useBlockRef((0,external_lodash_namespaceObject.last)(multiSelectedBlockClientIds));
  /**
   * When the component updates, and there is multi selection, we need to
   * select the entire block contents.
   */

  return (0,external_wp_compose_namespaceObject.useRefEffect)(node => {
    const {
      ownerDocument
    } = node;
    const {
      defaultView
    } = ownerDocument; // Allow initialPosition to bypass focus behavior. This is useful
    // for the list view or other areas where we don't want to transfer
    // focus to the editor canvas.

    if (initialPosition === undefined || initialPosition === null) {
      return;
    }

    if (!hasMultiSelection || isMultiSelecting) {
      if (!selectedBlockClientId || isMultiSelecting) {
        return;
      }

      const selection = defaultView.getSelection();

      if (selection.rangeCount && !selection.isCollapsed) {
        const blockNode = selectedRef.current;
        const {
          startContainer,
          endContainer
        } = selection.getRangeAt(0);

        if (!!blockNode && (!blockNode.contains(startContainer) || !blockNode.contains(endContainer))) {
          selection.removeAllRanges();
        }
      }

      return;
    }

    const {
      length
    } = multiSelectedBlockClientIds;

    if (length < 2) {
      return;
    } // The block refs might not be immediately available
    // when dragging blocks into another block.


    if (!startRef.current || !endRef.current) {
      return;
    } // Allow cross contentEditable selection by temporarily making
    // all content editable. We can't rely on using the store and
    // React because re-rending happens too slowly. We need to be
    // able to select across instances immediately.


    node.contentEditable = true; // For some browsers, like Safari, it is important that focus happens
    // BEFORE selection.

    node.focus();
    const selection = defaultView.getSelection();
    const range = ownerDocument.createRange(); // These must be in the right DOM order.
    // The most stable way to select the whole block contents is to start
    // and end at the deepest points.

    const startNode = getDeepestNode(startRef.current, 'start');
    const endNode = getDeepestNode(endRef.current, 'end');
    range.setStartBefore(startNode);
    range.setEndAfter(endNode);
    selection.removeAllRanges();
    selection.addRange(range);
  }, [hasMultiSelection, isMultiSelecting, multiSelectedBlockClientIds, selectedBlockClientId, initialPosition]);
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/writing-flow/use-tab-nav.js


/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */



function isFormElement(element) {
  const {
    tagName
  } = element;
  return tagName === 'INPUT' || tagName === 'BUTTON' || tagName === 'SELECT' || tagName === 'TEXTAREA';
}

function useTabNav() {
  const container = (0,external_wp_element_namespaceObject.useRef)();
  const focusCaptureBeforeRef = (0,external_wp_element_namespaceObject.useRef)();
  const focusCaptureAfterRef = (0,external_wp_element_namespaceObject.useRef)();
  const lastFocus = (0,external_wp_element_namespaceObject.useRef)();
  const {
    hasMultiSelection,
    getSelectedBlockClientId,
    getBlockCount
  } = (0,external_wp_data_namespaceObject.useSelect)(store);
  const {
    setNavigationMode
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const isNavigationMode = (0,external_wp_data_namespaceObject.useSelect)(select => select(store).isNavigationMode(), []); // Don't allow tabbing to this element in Navigation mode.

  const focusCaptureTabIndex = !isNavigationMode ? '0' : undefined; // Reference that holds the a flag for enabling or disabling
  // capturing on the focus capture elements.

  const noCapture = (0,external_wp_element_namespaceObject.useRef)();

  function onFocusCapture(event) {
    // Do not capture incoming focus if set by us in WritingFlow.
    if (noCapture.current) {
      noCapture.current = null;
    } else if (hasMultiSelection()) {
      container.current.focus();
    } else if (getSelectedBlockClientId()) {
      lastFocus.current.focus();
    } else {
      setNavigationMode(true);
      const isBefore = // eslint-disable-next-line no-bitwise
      event.target.compareDocumentPosition(container.current) & event.target.DOCUMENT_POSITION_FOLLOWING;
      const action = isBefore ? 'findNext' : 'findPrevious';
      external_wp_dom_namespaceObject.focus.tabbable[action](event.target).focus();
    }
  }

  const before = (0,external_wp_element_namespaceObject.createElement)("div", {
    ref: focusCaptureBeforeRef,
    tabIndex: focusCaptureTabIndex,
    onFocus: onFocusCapture
  });
  const after = (0,external_wp_element_namespaceObject.createElement)("div", {
    ref: focusCaptureAfterRef,
    tabIndex: focusCaptureTabIndex,
    onFocus: onFocusCapture
  });
  const ref = (0,external_wp_compose_namespaceObject.useRefEffect)(node => {
    function onKeyDown(event) {
      if (event.defaultPrevented) {
        return;
      }

      if (event.keyCode === external_wp_keycodes_namespaceObject.ESCAPE && !hasMultiSelection()) {
        event.preventDefault();
        setNavigationMode(true);
        return;
      } // In Edit mode, Tab should focus the first tabbable element after
      // the content, which is normally the sidebar (with block controls)
      // and Shift+Tab should focus the first tabbable element before the
      // content, which is normally the block toolbar.
      // Arrow keys can be used, and Tab and arrow keys can be used in
      // Navigation mode (press Esc), to navigate through blocks.


      if (event.keyCode !== external_wp_keycodes_namespaceObject.TAB) {
        return;
      }

      const isShift = event.shiftKey;
      const direction = isShift ? 'findPrevious' : 'findNext';

      if (!hasMultiSelection() && !getSelectedBlockClientId()) {
        // Preserve the behaviour of entering navigation mode when
        // tabbing into the content without a block selection.
        // `onFocusCapture` already did this previously, but we need to
        // do it again here because after clearing block selection,
        // focus land on the writing flow container and pressing Tab
        // will no longer send focus through the focus capture element.
        if (event.target === node) setNavigationMode(true);
        return;
      } // Allow tabbing from the block wrapper to a form element,
      // and between form elements rendered in a block,
      // such as inside a placeholder. Form elements are generally
      // meant to be UI rather than part of the content. Ideally
      // these are not rendered in the content and perhaps in the
      // future they can be rendered in an iframe or shadow DOM.


      if ((isFormElement(event.target) || event.target.getAttribute('data-block') === getSelectedBlockClientId()) && isFormElement(external_wp_dom_namespaceObject.focus.tabbable[direction](event.target))) {
        return;
      }

      const next = isShift ? focusCaptureBeforeRef : focusCaptureAfterRef; // Disable focus capturing on the focus capture element, so it
      // doesn't refocus this block and so it allows default behaviour
      // (moving focus to the next tabbable element).

      noCapture.current = true; // Focusing the focus capture element, which is located above and
      // below the editor, should not scroll the page all the way up or
      // down.

      next.current.focus({
        preventScroll: true
      });
    }

    function onFocusOut(event) {
      lastFocus.current = event.target;
      const {
        ownerDocument
      } = node; // If focus disappears due to there being no blocks, move focus to
      // the writing flow wrapper.

      if (!event.relatedTarget && ownerDocument.activeElement === ownerDocument.body && getBlockCount() === 0) {
        node.focus();
      }
    } // When tabbing back to an element in block list, this event handler prevents scrolling if the
    // focus capture divs (before/after) are outside of the viewport. (For example shift+tab back to a paragraph
    // when focus is on a sidebar element. This prevents the scrollable writing area from jumping either to the
    // top or bottom of the document.
    //
    // Note that it isn't possible to disable scrolling in the onFocus event. We need to intercept this
    // earlier in the keypress handler, and call focus( { preventScroll: true } ) instead.
    // https://developer.mozilla.org/en-US/docs/Web/API/HTMLOrForeignElement/focus#parameters


    function preventScrollOnTab(event) {
      var _event$target;

      if (event.keyCode !== external_wp_keycodes_namespaceObject.TAB) {
        return;
      }

      if (((_event$target = event.target) === null || _event$target === void 0 ? void 0 : _event$target.getAttribute('role')) === 'region') {
        return;
      }

      if (container.current === event.target) {
        return;
      }

      const isShift = event.shiftKey;
      const direction = isShift ? 'findPrevious' : 'findNext';
      const target = external_wp_dom_namespaceObject.focus.tabbable[direction](event.target); // Only do something when the next tabbable is a focus capture div (before/after)

      if (target === focusCaptureBeforeRef.current || target === focusCaptureAfterRef.current) {
        event.preventDefault();
        target.focus({
          preventScroll: true
        });
      }
    }

    const {
      ownerDocument
    } = node;
    const {
      defaultView
    } = ownerDocument;
    defaultView.addEventListener('keydown', preventScrollOnTab);
    node.addEventListener('keydown', onKeyDown);
    node.addEventListener('focusout', onFocusOut);
    return () => {
      defaultView.removeEventListener('keydown', preventScrollOnTab);
      node.removeEventListener('keydown', onKeyDown);
      node.removeEventListener('focusout', onFocusOut);
    };
  }, []);
  const mergedRefs = (0,external_wp_compose_namespaceObject.useMergeRefs)([container, ref]);
  return [before, mergedRefs, after];
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/writing-flow/use-arrow-nav.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */



/**
 * Returns true if the element should consider edge navigation upon a keyboard
 * event of the given directional key code, or false otherwise.
 *
 * @param {Element} element     HTML element to test.
 * @param {number}  keyCode     KeyboardEvent keyCode to test.
 * @param {boolean} hasModifier Whether a modifier is pressed.
 *
 * @return {boolean} Whether element should consider edge navigation.
 */

function isNavigationCandidate(element, keyCode, hasModifier) {
  const isVertical = keyCode === external_wp_keycodes_namespaceObject.UP || keyCode === external_wp_keycodes_namespaceObject.DOWN; // Currently, all elements support unmodified vertical navigation.

  if (isVertical && !hasModifier) {
    return true;
  } // Native inputs should not navigate horizontally.


  const {
    tagName
  } = element;
  return tagName !== 'INPUT' && tagName !== 'TEXTAREA';
}
/**
 * Returns the optimal tab target from the given focused element in the desired
 * direction. A preference is made toward text fields, falling back to the block
 * focus stop if no other candidates exist for the block.
 *
 * @param {Element} target           Currently focused text field.
 * @param {boolean} isReverse        True if considering as the first field.
 * @param {Element} containerElement Element containing all blocks.
 * @param {boolean} onlyVertical     Whether to only consider tabbable elements
 *                                   that are visually above or under the
 *                                   target.
 *
 * @return {?Element} Optimal tab target, if one exists.
 */

function getClosestTabbable(target, isReverse, containerElement, onlyVertical) {
  // Since the current focus target is not guaranteed to be a text field, find
  // all focusables. Tabbability is considered later.
  let focusableNodes = external_wp_dom_namespaceObject.focus.focusable.find(containerElement);

  if (isReverse) {
    focusableNodes = (0,external_lodash_namespaceObject.reverse)(focusableNodes);
  } // Consider as candidates those focusables after the current target. It's
  // assumed this can only be reached if the target is focusable (on its
  // keydown event), so no need to verify it exists in the set.


  focusableNodes = focusableNodes.slice(focusableNodes.indexOf(target) + 1);
  let targetRect;

  if (onlyVertical) {
    targetRect = target.getBoundingClientRect();
  }

  function isTabCandidate(node) {
    // Not a candidate if the node is not tabbable.
    if (!external_wp_dom_namespaceObject.focus.tabbable.isTabbableIndex(node)) {
      return false;
    } // Skip focusable elements such as links within content editable nodes.


    if (node.isContentEditable && node.contentEditable !== 'true') {
      return false;
    }

    if (onlyVertical) {
      const nodeRect = node.getBoundingClientRect();

      if (nodeRect.left >= targetRect.right || nodeRect.right <= targetRect.left) {
        return false;
      }
    }

    return true;
  }

  return (0,external_lodash_namespaceObject.find)(focusableNodes, isTabCandidate);
}
function useArrowNav() {
  const {
    getSelectedBlockClientId,
    getMultiSelectedBlocksStartClientId,
    getMultiSelectedBlocksEndClientId,
    getPreviousBlockClientId,
    getNextBlockClientId,
    getFirstMultiSelectedBlockClientId,
    getLastMultiSelectedBlockClientId,
    getSettings,
    hasMultiSelection
  } = (0,external_wp_data_namespaceObject.useSelect)(store);
  const {
    multiSelect,
    selectBlock
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  return (0,external_wp_compose_namespaceObject.useRefEffect)(node => {
    // Here a DOMRect is stored while moving the caret vertically so
    // vertical position of the start position can be restored. This is to
    // recreate browser behaviour across blocks.
    let verticalRect;

    function onMouseDown() {
      verticalRect = null;
    }

    function expandSelection(isReverse) {
      const selectedBlockClientId = getSelectedBlockClientId();
      const selectionStartClientId = getMultiSelectedBlocksStartClientId();
      const selectionEndClientId = getMultiSelectedBlocksEndClientId();
      const selectionBeforeEndClientId = getPreviousBlockClientId(selectionEndClientId || selectedBlockClientId);
      const selectionAfterEndClientId = getNextBlockClientId(selectionEndClientId || selectedBlockClientId);
      const nextSelectionEndClientId = isReverse ? selectionBeforeEndClientId : selectionAfterEndClientId;

      if (nextSelectionEndClientId) {
        if (selectionStartClientId === nextSelectionEndClientId) {
          selectBlock(nextSelectionEndClientId);
        } else {
          multiSelect(selectionStartClientId || selectedBlockClientId, nextSelectionEndClientId);
        }
      }
    }

    function moveSelection(isReverse) {
      const selectedFirstClientId = getFirstMultiSelectedBlockClientId();
      const selectedLastClientId = getLastMultiSelectedBlockClientId();
      const focusedBlockClientId = isReverse ? selectedFirstClientId : selectedLastClientId;

      if (focusedBlockClientId) {
        selectBlock(focusedBlockClientId);
      }
    }
    /**
     * Returns true if the given target field is the last in its block which
     * can be considered for tab transition. For example, in a block with
     * two text fields, this would return true when reversing from the first
     * of the two fields, but false when reversing from the second.
     *
     * @param {Element} target    Currently focused text field.
     * @param {boolean} isReverse True if considering as the first field.
     *
     * @return {boolean} Whether field is at edge for tab transition.
     */


    function isTabbableEdge(target, isReverse) {
      const closestTabbable = getClosestTabbable(target, isReverse, node);
      return !closestTabbable || !isInSameBlock(target, closestTabbable);
    }

    function onKeyDown(event) {
      const {
        keyCode,
        target
      } = event;
      const isUp = keyCode === external_wp_keycodes_namespaceObject.UP;
      const isDown = keyCode === external_wp_keycodes_namespaceObject.DOWN;
      const isLeft = keyCode === external_wp_keycodes_namespaceObject.LEFT;
      const isRight = keyCode === external_wp_keycodes_namespaceObject.RIGHT;
      const isReverse = isUp || isLeft;
      const isHorizontal = isLeft || isRight;
      const isVertical = isUp || isDown;
      const isNav = isHorizontal || isVertical;
      const isShift = event.shiftKey;
      const hasModifier = isShift || event.ctrlKey || event.altKey || event.metaKey;
      const isNavEdge = isVertical ? external_wp_dom_namespaceObject.isVerticalEdge : external_wp_dom_namespaceObject.isHorizontalEdge;
      const {
        ownerDocument
      } = node;
      const {
        defaultView
      } = ownerDocument;

      if (hasMultiSelection()) {
        if (isNav) {
          const action = isShift ? expandSelection : moveSelection;
          action(isReverse);
          event.preventDefault();
        }

        return;
      } // When presing any key other than up or down, the initial vertical
      // position must ALWAYS be reset. The vertical position is saved so
      // it can be restored as well as possible on sebsequent vertical
      // arrow key presses. It may not always be possible to restore the
      // exact same position (such as at an empty line), so it wouldn't be
      // good to compute the position right before any vertical arrow key
      // press.


      if (!isVertical) {
        verticalRect = null;
      } else if (!verticalRect) {
        verticalRect = (0,external_wp_dom_namespaceObject.computeCaretRect)(defaultView);
      } // Abort if navigation has already been handled (e.g. RichText
      // inline boundaries).


      if (event.defaultPrevented) {
        return;
      }

      if (!isNav) {
        return;
      } // Abort if our current target is not a candidate for navigation
      // (e.g. preserve native input behaviors).


      if (!isNavigationCandidate(target, keyCode, hasModifier)) {
        return;
      } // In the case of RTL scripts, right means previous and left means
      // next, which is the exact reverse of LTR.


      const isReverseDir = (0,external_wp_dom_namespaceObject.isRTL)(target) ? !isReverse : isReverse;
      const {
        keepCaretInsideBlock
      } = getSettings();
      const selectedBlockClientId = getSelectedBlockClientId();

      if (isShift) {
        const selectionEndClientId = getMultiSelectedBlocksEndClientId();
        const selectionBeforeEndClientId = getPreviousBlockClientId(selectionEndClientId || selectedBlockClientId);
        const selectionAfterEndClientId = getNextBlockClientId(selectionEndClientId || selectedBlockClientId);

        if ( // Ensure that there is a target block.
        (isReverse && selectionBeforeEndClientId || !isReverse && selectionAfterEndClientId) && isTabbableEdge(target, isReverse) && isNavEdge(target, isReverse)) {
          // Shift key is down, and there is multi selection or we're
          // at the end of the current block.
          expandSelection(isReverse);
          event.preventDefault();
        }
      } else if (isVertical && (0,external_wp_dom_namespaceObject.isVerticalEdge)(target, isReverse) && !keepCaretInsideBlock) {
        const closestTabbable = getClosestTabbable(target, isReverse, node, true);

        if (closestTabbable) {
          (0,external_wp_dom_namespaceObject.placeCaretAtVerticalEdge)(closestTabbable, isReverse, verticalRect);
          event.preventDefault();
        }
      } else if (isHorizontal && defaultView.getSelection().isCollapsed && (0,external_wp_dom_namespaceObject.isHorizontalEdge)(target, isReverseDir) && !keepCaretInsideBlock) {
        const closestTabbable = getClosestTabbable(target, isReverseDir, node);
        (0,external_wp_dom_namespaceObject.placeCaretAtHorizontalEdge)(closestTabbable, isReverse);
        event.preventDefault();
      }
    }

    node.addEventListener('mousedown', onMouseDown);
    node.addEventListener('keydown', onKeyDown);
    return () => {
      node.removeEventListener('mousedown', onMouseDown);
      node.removeEventListener('keydown', onKeyDown);
    };
  }, []);
}

;// CONCATENATED MODULE: external ["wp","keyboardShortcuts"]
var external_wp_keyboardShortcuts_namespaceObject = window["wp"]["keyboardShortcuts"];
;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/writing-flow/use-select-all.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */


function useSelectAll() {
  const {
    getBlockOrder,
    getSelectedBlockClientIds,
    getBlockRootClientId
  } = (0,external_wp_data_namespaceObject.useSelect)(store);
  const {
    multiSelect
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const isMatch = (0,external_wp_keyboardShortcuts_namespaceObject.__unstableUseShortcutEventMatch)();
  return (0,external_wp_compose_namespaceObject.useRefEffect)(node => {
    function onKeyDown(event) {
      if (!isMatch('core/block-editor/select-all', event)) {
        return;
      }

      const selectedClientIds = getSelectedBlockClientIds();

      if (selectedClientIds.length < 2 && !(0,external_wp_dom_namespaceObject.isEntirelySelected)(event.target)) {
        return;
      }

      const [firstSelectedClientId] = selectedClientIds;
      const rootClientId = getBlockRootClientId(firstSelectedClientId);
      let blockClientIds = getBlockOrder(rootClientId); // If we have selected all sibling nested blocks, try selecting up a
      // level. See: https://github.com/WordPress/gutenberg/pull/31859/

      if (selectedClientIds.length === blockClientIds.length) {
        blockClientIds = getBlockOrder(getBlockRootClientId(rootClientId));
      }

      const firstClientId = (0,external_lodash_namespaceObject.first)(blockClientIds);
      const lastClientId = (0,external_lodash_namespaceObject.last)(blockClientIds);

      if (firstClientId === lastClientId) {
        return;
      }

      multiSelect(firstClientId, lastClientId);
      event.preventDefault();
    }

    node.addEventListener('keydown', onKeyDown);
    return () => {
      node.removeEventListener('keydown', onKeyDown);
    };
  }, []);
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/writing-flow/index.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */






function useWritingFlow() {
  const [before, ref, after] = useTabNav();
  const hasMultiSelection = (0,external_wp_data_namespaceObject.useSelect)(select => select(store).hasMultiSelection(), []);
  return [before, (0,external_wp_compose_namespaceObject.useMergeRefs)([ref, use_multi_selection_useMultiSelection(), useSelectAll(), useArrowNav(), (0,external_wp_compose_namespaceObject.useRefEffect)(node => {
    node.tabIndex = -1;
    node.contentEditable = hasMultiSelection;

    if (!hasMultiSelection) {
      return;
    }

    node.setAttribute('aria-label', (0,external_wp_i18n_namespaceObject.__)('Multiple selected blocks'));
    return () => {
      node.removeAttribute('aria-label');
    };
  }, [hasMultiSelection])]), after];
}

function WritingFlow(_ref, forwardedRef) {
  let {
    children,
    ...props
  } = _ref;
  const [before, ref, after] = useWritingFlow();
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, before, (0,external_wp_element_namespaceObject.createElement)("div", _extends({}, props, {
    ref: (0,external_wp_compose_namespaceObject.useMergeRefs)([ref, forwardedRef]),
    className: classnames_default()(props.className, 'block-editor-writing-flow')
  }), children), after);
}
/**
 * Handles selection and navigation across blocks. This component should be
 * wrapped around BlockList.
 *
 * @param {Object}    props          Component properties.
 * @param {WPElement} props.children Children to be rendered.
 */


/* harmony default export */ var writing_flow = ((0,external_wp_element_namespaceObject.forwardRef)(WritingFlow));

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/iframe/index.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */



const BODY_CLASS_NAME = 'editor-styles-wrapper';
const BLOCK_PREFIX = 'wp-block';
/**
 * Clones stylesheets targetting the editor canvas to the given document. A
 * stylesheet is considered targetting the editor a canvas if it contains the
 * `editor-styles-wrapper`, `wp-block`, or `wp-block-*` class selectors.
 *
 * Ideally, this hook should be removed in the future and styles should be added
 * explicitly as editor styles.
 *
 * @param {Document} doc The document to append cloned stylesheets to.
 */

function styleSheetsCompat(doc) {
  // Search the document for stylesheets targetting the editor canvas.
  Array.from(document.styleSheets).forEach(styleSheet => {
    try {
      // May fail for external styles.
      // eslint-disable-next-line no-unused-expressions
      styleSheet.cssRules;
    } catch (e) {
      return;
    }

    const {
      ownerNode,
      cssRules
    } = styleSheet;

    if (!cssRules) {
      return;
    } // Generally, ignore inline styles. We add inline styles belonging to a
    // stylesheet later, which may or may not match the selectors.


    if (ownerNode.tagName !== 'LINK') {
      return;
    } // Don't try to add the reset styles, which were removed as a dependency
    // from `edit-blocks` for the iframe since we don't need to reset admin
    // styles.


    if (ownerNode.id === 'wp-reset-editor-styles-css') {
      return;
    }

    const isMatch = Array.from(cssRules).find(_ref => {
      let {
        selectorText
      } = _ref;
      return selectorText && (selectorText.includes(`.${BODY_CLASS_NAME}`) || selectorText.includes(`.${BLOCK_PREFIX}`));
    });

    if (isMatch && !doc.getElementById(ownerNode.id)) {
      // Display warning once we have a way to add style dependencies to the editor.
      // See: https://github.com/WordPress/gutenberg/pull/37466.
      doc.head.appendChild(ownerNode.cloneNode(true)); // Add inline styles belonging to the stylesheet.

      const inlineCssId = ownerNode.id.replace('-css', '-inline-css');
      const inlineCssElement = document.getElementById(inlineCssId);

      if (inlineCssElement) {
        doc.head.appendChild(inlineCssElement.cloneNode(true));
      }
    }
  });
}
/**
 * Bubbles some event types (keydown, keypress, and dragover) to parent document
 * document to ensure that the keyboard shortcuts and drag and drop work.
 *
 * Ideally, we should remove event bubbling in the future. Keyboard shortcuts
 * should be context dependent, e.g. actions on blocks like Cmd+A should not
 * work globally outside the block editor.
 *
 * @param {Document} doc Document to attach listeners to.
 */


function bubbleEvents(doc) {
  const {
    defaultView
  } = doc;
  const {
    frameElement
  } = defaultView;

  function bubbleEvent(event) {
    const prototype = Object.getPrototypeOf(event);
    const constructorName = prototype.constructor.name;
    const Constructor = window[constructorName];
    const init = {};

    for (const key in event) {
      init[key] = event[key];
    }

    if (event instanceof defaultView.MouseEvent) {
      const rect = frameElement.getBoundingClientRect();
      init.clientX += rect.left;
      init.clientY += rect.top;
    }

    const newEvent = new Constructor(event.type, init);
    const cancelled = !frameElement.dispatchEvent(newEvent);

    if (cancelled) {
      event.preventDefault();
    }
  }

  const eventTypes = ['dragover'];

  for (const name of eventTypes) {
    doc.addEventListener(name, bubbleEvent);
  }
}

function useParsedAssets(html) {
  return (0,external_wp_element_namespaceObject.useMemo)(() => {
    const doc = document.implementation.createHTMLDocument('');
    doc.body.innerHTML = html;
    return Array.from(doc.body.children);
  }, [html]);
}

async function loadScript(head, _ref2) {
  let {
    id,
    src
  } = _ref2;
  return new Promise((resolve, reject) => {
    const script = head.ownerDocument.createElement('script');
    script.id = id;

    if (src) {
      script.src = src;

      script.onload = () => resolve();

      script.onerror = () => reject();
    } else {
      resolve();
    }

    head.appendChild(script);
  });
}

function Iframe(_ref3, ref) {
  let {
    contentRef,
    children,
    head,
    tabIndex = 0,
    assets,
    ...props
  } = _ref3;
  const [, forceRender] = (0,external_wp_element_namespaceObject.useReducer)(() => ({}));
  const [iframeDocument, setIframeDocument] = (0,external_wp_element_namespaceObject.useState)();
  const [bodyClasses, setBodyClasses] = (0,external_wp_element_namespaceObject.useState)([]);
  const styles = useParsedAssets(assets === null || assets === void 0 ? void 0 : assets.styles);
  const scripts = useParsedAssets(assets === null || assets === void 0 ? void 0 : assets.scripts);
  const clearerRef = useBlockSelectionClearer();
  const [before, writingFlowRef, after] = useWritingFlow();
  const setRef = (0,external_wp_compose_namespaceObject.useRefEffect)(node => {
    function setDocumentIfReady() {
      const {
        contentDocument,
        ownerDocument
      } = node;
      const {
        readyState,
        documentElement
      } = contentDocument;

      if (readyState !== 'interactive' && readyState !== 'complete') {
        return false;
      }

      bubbleEvents(contentDocument);
      setIframeDocument(contentDocument);
      clearerRef(documentElement); // Ideally ALL classes that are added through get_body_class should
      // be added in the editor too, which we'll somehow have to get from
      // the server in the future (which will run the PHP filters).

      setBodyClasses(Array.from(ownerDocument.body.classList).filter(name => name.startsWith('admin-color-') || name.startsWith('post-type-') || name === 'wp-embed-responsive'));
      contentDocument.dir = ownerDocument.dir;
      documentElement.removeChild(contentDocument.head);
      documentElement.removeChild(contentDocument.body);
      return true;
    }

    if (setDocumentIfReady()) {
      return;
    } // Document is not immediately loaded in Firefox.


    node.addEventListener('load', () => {
      setDocumentIfReady();
    });
  }, []);
  const headRef = (0,external_wp_compose_namespaceObject.useRefEffect)(element => {
    scripts.reduce((promise, script) => promise.then(() => loadScript(element, script)), Promise.resolve()).finally(() => {
      // When script are loaded, re-render blocks to allow them
      // to initialise.
      forceRender();
    });
  }, []);
  const bodyRef = (0,external_wp_compose_namespaceObject.useMergeRefs)([contentRef, clearerRef, writingFlowRef]);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (iframeDocument) {
      styleSheetsCompat(iframeDocument);
    }
  }, [iframeDocument]);
  head = (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)("style", null, 'body{margin:0}'), styles.map(_ref4 => {
    let {
      tagName,
      href,
      id,
      rel,
      media,
      textContent
    } = _ref4;
    const TagName = tagName.toLowerCase();

    if (TagName === 'style') {
      return (0,external_wp_element_namespaceObject.createElement)(TagName, {
        id,
        key: id
      }, textContent);
    }

    return (0,external_wp_element_namespaceObject.createElement)(TagName, {
      href,
      id,
      rel,
      media,
      key: id
    });
  }), head);
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, tabIndex >= 0 && before, (0,external_wp_element_namespaceObject.createElement)("iframe", _extends({}, props, {
    ref: (0,external_wp_compose_namespaceObject.useMergeRefs)([ref, setRef]),
    tabIndex: tabIndex,
    title: (0,external_wp_i18n_namespaceObject.__)('Editor canvas')
  }), iframeDocument && (0,external_wp_element_namespaceObject.createPortal)((0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)("head", {
    ref: headRef
  }, head), (0,external_wp_element_namespaceObject.createElement)("body", {
    ref: bodyRef,
    className: classnames_default()(BODY_CLASS_NAME, ...bodyClasses)
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalStyleProvider, {
    document: iframeDocument
  }, children))), iframeDocument.documentElement)), tabIndex >= 0 && after);
}

/* harmony default export */ var iframe = ((0,external_wp_element_namespaceObject.forwardRef)(Iframe));

;// CONCATENATED MODULE: ./packages/block-editor/node_modules/colord/index.mjs
var r={grad:.9,turn:360,rad:360/(2*Math.PI)},t=function(r){return"string"==typeof r?r.length>0:"number"==typeof r},n=function(r,t,n){return void 0===t&&(t=0),void 0===n&&(n=Math.pow(10,t)),Math.round(n*r)/n+0},e=function(r,t,n){return void 0===t&&(t=0),void 0===n&&(n=1),r>n?n:r>t?r:t},u=function(r){return(r=isFinite(r)?r%360:0)>0?r:r+360},a=function(r){return{r:e(r.r,0,255),g:e(r.g,0,255),b:e(r.b,0,255),a:e(r.a)}},o=function(r){return{r:n(r.r),g:n(r.g),b:n(r.b),a:n(r.a,3)}},i=/^#([0-9a-f]{3,8})$/i,s=function(r){var t=r.toString(16);return t.length<2?"0"+t:t},h=function(r){var t=r.r,n=r.g,e=r.b,u=r.a,a=Math.max(t,n,e),o=a-Math.min(t,n,e),i=o?a===t?(n-e)/o:a===n?2+(e-t)/o:4+(t-n)/o:0;return{h:60*(i<0?i+6:i),s:a?o/a*100:0,v:a/255*100,a:u}},b=function(r){var t=r.h,n=r.s,e=r.v,u=r.a;t=t/360*6,n/=100,e/=100;var a=Math.floor(t),o=e*(1-n),i=e*(1-(t-a)*n),s=e*(1-(1-t+a)*n),h=a%6;return{r:255*[e,i,o,o,s,e][h],g:255*[s,e,e,i,o,o][h],b:255*[o,o,s,e,e,i][h],a:u}},g=function(r){return{h:u(r.h),s:e(r.s,0,100),l:e(r.l,0,100),a:e(r.a)}},d=function(r){return{h:n(r.h),s:n(r.s),l:n(r.l),a:n(r.a,3)}},f=function(r){return b((n=(t=r).s,{h:t.h,s:(n*=((e=t.l)<50?e:100-e)/100)>0?2*n/(e+n)*100:0,v:e+n,a:t.a}));var t,n,e},c=function(r){return{h:(t=h(r)).h,s:(u=(200-(n=t.s))*(e=t.v)/100)>0&&u<200?n*e/100/(u<=100?u:200-u)*100:0,l:u/2,a:t.a};var t,n,e,u},l=/^hsla?\(\s*([+-]?\d*\.?\d+)(deg|rad|grad|turn)?\s*,\s*([+-]?\d*\.?\d+)%\s*,\s*([+-]?\d*\.?\d+)%\s*(?:,\s*([+-]?\d*\.?\d+)(%)?\s*)?\)$/i,p=/^hsla?\(\s*([+-]?\d*\.?\d+)(deg|rad|grad|turn)?\s+([+-]?\d*\.?\d+)%\s+([+-]?\d*\.?\d+)%\s*(?:\/\s*([+-]?\d*\.?\d+)(%)?\s*)?\)$/i,v=/^rgba?\(\s*([+-]?\d*\.?\d+)(%)?\s*,\s*([+-]?\d*\.?\d+)(%)?\s*,\s*([+-]?\d*\.?\d+)(%)?\s*(?:,\s*([+-]?\d*\.?\d+)(%)?\s*)?\)$/i,m=/^rgba?\(\s*([+-]?\d*\.?\d+)(%)?\s+([+-]?\d*\.?\d+)(%)?\s+([+-]?\d*\.?\d+)(%)?\s*(?:\/\s*([+-]?\d*\.?\d+)(%)?\s*)?\)$/i,y={string:[[function(r){var t=i.exec(r);return t?(r=t[1]).length<=4?{r:parseInt(r[0]+r[0],16),g:parseInt(r[1]+r[1],16),b:parseInt(r[2]+r[2],16),a:4===r.length?n(parseInt(r[3]+r[3],16)/255,2):1}:6===r.length||8===r.length?{r:parseInt(r.substr(0,2),16),g:parseInt(r.substr(2,2),16),b:parseInt(r.substr(4,2),16),a:8===r.length?n(parseInt(r.substr(6,2),16)/255,2):1}:null:null},"hex"],[function(r){var t=v.exec(r)||m.exec(r);return t?t[2]!==t[4]||t[4]!==t[6]?null:a({r:Number(t[1])/(t[2]?100/255:1),g:Number(t[3])/(t[4]?100/255:1),b:Number(t[5])/(t[6]?100/255:1),a:void 0===t[7]?1:Number(t[7])/(t[8]?100:1)}):null},"rgb"],[function(t){var n=l.exec(t)||p.exec(t);if(!n)return null;var e,u,a=g({h:(e=n[1],u=n[2],void 0===u&&(u="deg"),Number(e)*(r[u]||1)),s:Number(n[3]),l:Number(n[4]),a:void 0===n[5]?1:Number(n[5])/(n[6]?100:1)});return f(a)},"hsl"]],object:[[function(r){var n=r.r,e=r.g,u=r.b,o=r.a,i=void 0===o?1:o;return t(n)&&t(e)&&t(u)?a({r:Number(n),g:Number(e),b:Number(u),a:Number(i)}):null},"rgb"],[function(r){var n=r.h,e=r.s,u=r.l,a=r.a,o=void 0===a?1:a;if(!t(n)||!t(e)||!t(u))return null;var i=g({h:Number(n),s:Number(e),l:Number(u),a:Number(o)});return f(i)},"hsl"],[function(r){var n=r.h,a=r.s,o=r.v,i=r.a,s=void 0===i?1:i;if(!t(n)||!t(a)||!t(o))return null;var h=function(r){return{h:u(r.h),s:e(r.s,0,100),v:e(r.v,0,100),a:e(r.a)}}({h:Number(n),s:Number(a),v:Number(o),a:Number(s)});return b(h)},"hsv"]]},N=function(r,t){for(var n=0;n<t.length;n++){var e=t[n][0](r);if(e)return[e,t[n][1]]}return[null,void 0]},x=function(r){return"string"==typeof r?N(r.trim(),y.string):"object"==typeof r&&null!==r?N(r,y.object):[null,void 0]},I=function(r){return x(r)[1]},M=function(r,t){var n=c(r);return{h:n.h,s:e(n.s+100*t,0,100),l:n.l,a:n.a}},H=function(r){return(299*r.r+587*r.g+114*r.b)/1e3/255},$=function(r,t){var n=c(r);return{h:n.h,s:n.s,l:e(n.l+100*t,0,100),a:n.a}},j=function(){function r(r){this.parsed=x(r)[0],this.rgba=this.parsed||{r:0,g:0,b:0,a:1}}return r.prototype.isValid=function(){return null!==this.parsed},r.prototype.brightness=function(){return n(H(this.rgba),2)},r.prototype.isDark=function(){return H(this.rgba)<.5},r.prototype.isLight=function(){return H(this.rgba)>=.5},r.prototype.toHex=function(){return r=o(this.rgba),t=r.r,e=r.g,u=r.b,i=(a=r.a)<1?s(n(255*a)):"","#"+s(t)+s(e)+s(u)+i;var r,t,e,u,a,i},r.prototype.toRgb=function(){return o(this.rgba)},r.prototype.toRgbString=function(){return r=o(this.rgba),t=r.r,n=r.g,e=r.b,(u=r.a)<1?"rgba("+t+", "+n+", "+e+", "+u+")":"rgb("+t+", "+n+", "+e+")";var r,t,n,e,u},r.prototype.toHsl=function(){return d(c(this.rgba))},r.prototype.toHslString=function(){return r=d(c(this.rgba)),t=r.h,n=r.s,e=r.l,(u=r.a)<1?"hsla("+t+", "+n+"%, "+e+"%, "+u+")":"hsl("+t+", "+n+"%, "+e+"%)";var r,t,n,e,u},r.prototype.toHsv=function(){return r=h(this.rgba),{h:n(r.h),s:n(r.s),v:n(r.v),a:n(r.a,3)};var r},r.prototype.invert=function(){return w({r:255-(r=this.rgba).r,g:255-r.g,b:255-r.b,a:r.a});var r},r.prototype.saturate=function(r){return void 0===r&&(r=.1),w(M(this.rgba,r))},r.prototype.desaturate=function(r){return void 0===r&&(r=.1),w(M(this.rgba,-r))},r.prototype.grayscale=function(){return w(M(this.rgba,-1))},r.prototype.lighten=function(r){return void 0===r&&(r=.1),w($(this.rgba,r))},r.prototype.darken=function(r){return void 0===r&&(r=.1),w($(this.rgba,-r))},r.prototype.rotate=function(r){return void 0===r&&(r=15),this.hue(this.hue()+r)},r.prototype.alpha=function(r){return"number"==typeof r?w({r:(t=this.rgba).r,g:t.g,b:t.b,a:r}):n(this.rgba.a,3);var t},r.prototype.hue=function(r){var t=c(this.rgba);return"number"==typeof r?w({h:r,s:t.s,l:t.l,a:t.a}):n(t.h)},r.prototype.isEqual=function(r){return this.toHex()===w(r).toHex()},r}(),w=function(r){return r instanceof j?r:new j(r)},S=[],k=function(r){r.forEach(function(r){S.indexOf(r)<0&&(r(j,y),S.push(r))})},E=function(){return new j({r:255*Math.random(),g:255*Math.random(),b:255*Math.random()})};

;// CONCATENATED MODULE: ./packages/block-editor/node_modules/colord/plugins/names.mjs
/* harmony default export */ function names(e,f){var a={white:"#ffffff",bisque:"#ffe4c4",blue:"#0000ff",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",antiquewhite:"#faebd7",aqua:"#00ffff",azure:"#f0ffff",whitesmoke:"#f5f5f5",papayawhip:"#ffefd5",plum:"#dda0dd",blanchedalmond:"#ffebcd",black:"#000000",gold:"#ffd700",goldenrod:"#daa520",gainsboro:"#dcdcdc",cornsilk:"#fff8dc",cornflowerblue:"#6495ed",burlywood:"#deb887",aquamarine:"#7fffd4",beige:"#f5f5dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkkhaki:"#bdb76b",darkgray:"#a9a9a9",darkgreen:"#006400",darkgrey:"#a9a9a9",peachpuff:"#ffdab9",darkmagenta:"#8b008b",darkred:"#8b0000",darkorchid:"#9932cc",darkorange:"#ff8c00",darkslateblue:"#483d8b",gray:"#808080",darkslategray:"#2f4f4f",darkslategrey:"#2f4f4f",deeppink:"#ff1493",deepskyblue:"#00bfff",wheat:"#f5deb3",firebrick:"#b22222",floralwhite:"#fffaf0",ghostwhite:"#f8f8ff",darkviolet:"#9400d3",magenta:"#ff00ff",green:"#008000",dodgerblue:"#1e90ff",grey:"#808080",honeydew:"#f0fff0",hotpink:"#ff69b4",blueviolet:"#8a2be2",forestgreen:"#228b22",lawngreen:"#7cfc00",indianred:"#cd5c5c",indigo:"#4b0082",fuchsia:"#ff00ff",brown:"#a52a2a",maroon:"#800000",mediumblue:"#0000cd",lightcoral:"#f08080",darkturquoise:"#00ced1",lightcyan:"#e0ffff",ivory:"#fffff0",lightyellow:"#ffffe0",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",linen:"#faf0e6",mediumaquamarine:"#66cdaa",lemonchiffon:"#fffacd",lime:"#00ff00",khaki:"#f0e68c",mediumseagreen:"#3cb371",limegreen:"#32cd32",mediumspringgreen:"#00fa9a",lightskyblue:"#87cefa",lightblue:"#add8e6",midnightblue:"#191970",lightpink:"#ffb6c1",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",mintcream:"#f5fffa",lightslategray:"#778899",lightslategrey:"#778899",navajowhite:"#ffdead",navy:"#000080",mediumvioletred:"#c71585",powderblue:"#b0e0e6",palegoldenrod:"#eee8aa",oldlace:"#fdf5e6",paleturquoise:"#afeeee",mediumturquoise:"#48d1cc",mediumorchid:"#ba55d3",rebeccapurple:"#663399",lightsteelblue:"#b0c4de",mediumslateblue:"#7b68ee",thistle:"#d8bfd8",tan:"#d2b48c",orchid:"#da70d6",mediumpurple:"#9370db",purple:"#800080",pink:"#ffc0cb",skyblue:"#87ceeb",springgreen:"#00ff7f",palegreen:"#98fb98",red:"#ff0000",yellow:"#ffff00",slateblue:"#6a5acd",lavenderblush:"#fff0f5",peru:"#cd853f",palevioletred:"#db7093",violet:"#ee82ee",teal:"#008080",slategray:"#708090",slategrey:"#708090",aliceblue:"#f0f8ff",darkseagreen:"#8fbc8f",darkolivegreen:"#556b2f",greenyellow:"#adff2f",seagreen:"#2e8b57",seashell:"#fff5ee",tomato:"#ff6347",silver:"#c0c0c0",sienna:"#a0522d",lavender:"#e6e6fa",lightgreen:"#90ee90",orange:"#ffa500",orangered:"#ff4500",steelblue:"#4682b4",royalblue:"#4169e1",turquoise:"#40e0d0",yellowgreen:"#9acd32",salmon:"#fa8072",saddlebrown:"#8b4513",sandybrown:"#f4a460",rosybrown:"#bc8f8f",darksalmon:"#e9967a",lightgoldenrodyellow:"#fafad2",snow:"#fffafa",lightgrey:"#d3d3d3",lightgray:"#d3d3d3",dimgray:"#696969",dimgrey:"#696969",olivedrab:"#6b8e23",olive:"#808000"},r={};for(var d in a)r[a[d]]=d;var l={};e.prototype.toName=function(f){if(!(this.rgba.a||this.rgba.r||this.rgba.g||this.rgba.b))return"transparent";var d,i,n=r[this.toHex()];if(n)return n;if(null==f?void 0:f.closest){var o=this.toRgb(),t=1/0,b="black";if(!l.length)for(var c in a)l[c]=new e(a[c]).toRgb();for(var g in a){var u=(d=o,i=l[g],Math.pow(d.r-i.r,2)+Math.pow(d.g-i.g,2)+Math.pow(d.b-i.b,2));u<t&&(t=u,b=g)}return b}};f.string.push([function(f){var r=f.toLowerCase(),d="transparent"===r?"#0000":a[r];return d?new e(d).toRgb():null},"name"])}

;// CONCATENATED MODULE: ./packages/block-editor/node_modules/colord/plugins/a11y.mjs
var a11y_o=function(o){var t=o/255;return t<.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)},a11y_t=function(t){return.2126*a11y_o(t.r)+.7152*a11y_o(t.g)+.0722*a11y_o(t.b)};/* harmony default export */ function a11y(o){o.prototype.luminance=function(){return o=a11y_t(this.rgba),void 0===(r=2)&&(r=0),void 0===n&&(n=Math.pow(10,r)),Math.round(n*o)/n+0;var o,r,n},o.prototype.contrast=function(r){void 0===r&&(r="#FFF");var n,a,i,e,v,u,d,c=r instanceof o?r:new o(r);return e=this.rgba,v=c.toRgb(),u=a11y_t(e),d=a11y_t(v),n=u>d?(u+.05)/(d+.05):(d+.05)/(u+.05),void 0===(a=2)&&(a=0),void 0===i&&(i=Math.pow(10,a)),Math.floor(i*n)/i+0},o.prototype.isReadable=function(o,t){return void 0===o&&(o="#FFF"),void 0===t&&(t={}),this.contrast(o)>=(e=void 0===(i=(r=t).size)?"normal":i,"AAA"===(a=void 0===(n=r.level)?"AA":n)&&"normal"===e?7:"AA"===a&&"large"===e?3:4.5);var r,n,a,i,e}}

// EXTERNAL MODULE: ./node_modules/traverse/index.js
var traverse = __webpack_require__(3124);
var traverse_default = /*#__PURE__*/__webpack_require__.n(traverse);
;// CONCATENATED MODULE: ./packages/block-editor/build-module/utils/transform-styles/ast/parse.js
/* eslint-disable @wordpress/no-unused-vars-before-return */
// Adapted from https://github.com/reworkcss/css
// because we needed to remove source map support.
// http://www.w3.org/TR/CSS21/grammar.htm
// https://github.com/visionmedia/css-parse/pull/49#issuecomment-30088027
const commentre = /\/\*[^*]*\*+([^/*][^*]*\*+)*\//g;
/* harmony default export */ function parse(css, options) {
  options = options || {};
  /**
   * Positional.
   */

  let lineno = 1;
  let column = 1;
  /**
   * Update lineno and column based on `str`.
   */

  function updatePosition(str) {
    const lines = str.match(/\n/g);

    if (lines) {
      lineno += lines.length;
    }

    const i = str.lastIndexOf('\n'); // eslint-disable-next-line no-bitwise

    column = ~i ? str.length - i : column + str.length;
  }
  /**
   * Mark position and patch `node.position`.
   */


  function position() {
    const start = {
      line: lineno,
      column
    };
    return function (node) {
      node.position = new Position(start);
      whitespace();
      return node;
    };
  }
  /**
   * Store position information for a node
   */


  function Position(start) {
    this.start = start;
    this.end = {
      line: lineno,
      column
    };
    this.source = options.source;
  }
  /**
   * Non-enumerable source string
   */


  Position.prototype.content = css;
  /**
   * Error `msg`.
   */

  const errorsList = [];

  function error(msg) {
    const err = new Error(options.source + ':' + lineno + ':' + column + ': ' + msg);
    err.reason = msg;
    err.filename = options.source;
    err.line = lineno;
    err.column = column;
    err.source = css;

    if (options.silent) {
      errorsList.push(err);
    } else {
      throw err;
    }
  }
  /**
   * Parse stylesheet.
   */


  function stylesheet() {
    const rulesList = rules();
    return {
      type: 'stylesheet',
      stylesheet: {
        source: options.source,
        rules: rulesList,
        parsingErrors: errorsList
      }
    };
  }
  /**
   * Opening brace.
   */


  function open() {
    return match(/^{\s*/);
  }
  /**
   * Closing brace.
   */


  function close() {
    return match(/^}/);
  }
  /**
   * Parse ruleset.
   */


  function rules() {
    let node;
    const accumulator = [];
    whitespace();
    comments(accumulator);

    while (css.length && css.charAt(0) !== '}' && (node = atrule() || rule())) {
      if (node !== false) {
        accumulator.push(node);
        comments(accumulator);
      }
    }

    return accumulator;
  }
  /**
   * Match `re` and return captures.
   */


  function match(re) {
    const m = re.exec(css);

    if (!m) {
      return;
    }

    const str = m[0];
    updatePosition(str);
    css = css.slice(str.length);
    return m;
  }
  /**
   * Parse whitespace.
   */


  function whitespace() {
    match(/^\s*/);
  }
  /**
   * Parse comments;
   */


  function comments(accumulator) {
    let c;
    accumulator = accumulator || []; // eslint-disable-next-line no-cond-assign

    while (c = comment()) {
      if (c !== false) {
        accumulator.push(c);
      }
    }

    return accumulator;
  }
  /**
   * Parse comment.
   */


  function comment() {
    const pos = position();

    if ('/' !== css.charAt(0) || '*' !== css.charAt(1)) {
      return;
    }

    let i = 2;

    while ('' !== css.charAt(i) && ('*' !== css.charAt(i) || '/' !== css.charAt(i + 1))) {
      ++i;
    }

    i += 2;

    if ('' === css.charAt(i - 1)) {
      return error('End of comment missing');
    }

    const str = css.slice(2, i - 2);
    column += 2;
    updatePosition(str);
    css = css.slice(i);
    column += 2;
    return pos({
      type: 'comment',
      comment: str
    });
  }
  /**
   * Parse selector.
   */


  function selector() {
    const m = match(/^([^{]+)/);

    if (!m) {
      return;
    } // FIXME: Remove all comments from selectors http://ostermiller.org/findcomment.html


    return trim(m[0]).replace(/\/\*([^*]|[\r\n]|(\*+([^*/]|[\r\n])))*\*\/+/g, '').replace(/"(?:\\"|[^"])*"|'(?:\\'|[^'])*'/g, function (matched) {
      return matched.replace(/,/g, '\u200C');
    }).split(/\s*(?![^(]*\)),\s*/).map(function (s) {
      return s.replace(/\u200C/g, ',');
    });
  }
  /**
   * Parse declaration.
   */


  function declaration() {
    const pos = position(); // prop.

    let prop = match(/^(\*?[-#\/\*\\\w]+(\[[0-9a-z_-]+\])?)\s*/);

    if (!prop) {
      return;
    }

    prop = trim(prop[0]); // :

    if (!match(/^:\s*/)) {
      return error("property missing ':'");
    } // val.


    const val = match(/^((?:'(?:\\'|.)*?'|"(?:\\"|.)*?"|\([^\)]*?\)|[^};])+)/);
    const ret = pos({
      type: 'declaration',
      property: prop.replace(commentre, ''),
      value: val ? trim(val[0]).replace(commentre, '') : ''
    }); // ;

    match(/^[;\s]*/);
    return ret;
  }
  /**
   * Parse declarations.
   */


  function declarations() {
    const decls = [];

    if (!open()) {
      return error("missing '{'");
    }

    comments(decls); // declarations.

    let decl; // eslint-disable-next-line no-cond-assign

    while (decl = declaration()) {
      if (decl !== false) {
        decls.push(decl);
        comments(decls);
      }
    }

    if (!close()) {
      return error("missing '}'");
    }

    return decls;
  }
  /**
   * Parse keyframe.
   */


  function keyframe() {
    let m;
    const vals = [];
    const pos = position(); // eslint-disable-next-line no-cond-assign

    while (m = match(/^((\d+\.\d+|\.\d+|\d+)%?|[a-z]+)\s*/)) {
      vals.push(m[1]);
      match(/^,\s*/);
    }

    if (!vals.length) {
      return;
    }

    return pos({
      type: 'keyframe',
      values: vals,
      declarations: declarations()
    });
  }
  /**
   * Parse keyframes.
   */


  function atkeyframes() {
    const pos = position();
    let m = match(/^@([-\w]+)?keyframes\s*/);

    if (!m) {
      return;
    }

    const vendor = m[1]; // identifier

    m = match(/^([-\w]+)\s*/);

    if (!m) {
      return error('@keyframes missing name');
    }

    const name = m[1];

    if (!open()) {
      return error("@keyframes missing '{'");
    }

    let frame;
    let frames = comments(); // eslint-disable-next-line no-cond-assign

    while (frame = keyframe()) {
      frames.push(frame);
      frames = frames.concat(comments());
    }

    if (!close()) {
      return error("@keyframes missing '}'");
    }

    return pos({
      type: 'keyframes',
      name,
      vendor,
      keyframes: frames
    });
  }
  /**
   * Parse supports.
   */


  function atsupports() {
    const pos = position();
    const m = match(/^@supports *([^{]+)/);

    if (!m) {
      return;
    }

    const supports = trim(m[1]);

    if (!open()) {
      return error("@supports missing '{'");
    }

    const style = comments().concat(rules());

    if (!close()) {
      return error("@supports missing '}'");
    }

    return pos({
      type: 'supports',
      supports,
      rules: style
    });
  }
  /**
   * Parse host.
   */


  function athost() {
    const pos = position();
    const m = match(/^@host\s*/);

    if (!m) {
      return;
    }

    if (!open()) {
      return error("@host missing '{'");
    }

    const style = comments().concat(rules());

    if (!close()) {
      return error("@host missing '}'");
    }

    return pos({
      type: 'host',
      rules: style
    });
  }
  /**
   * Parse media.
   */


  function atmedia() {
    const pos = position();
    const m = match(/^@media *([^{]+)/);

    if (!m) {
      return;
    }

    const media = trim(m[1]);

    if (!open()) {
      return error("@media missing '{'");
    }

    const style = comments().concat(rules());

    if (!close()) {
      return error("@media missing '}'");
    }

    return pos({
      type: 'media',
      media,
      rules: style
    });
  }
  /**
   * Parse custom-media.
   */


  function atcustommedia() {
    const pos = position();
    const m = match(/^@custom-media\s+(--[^\s]+)\s*([^{;]+);/);

    if (!m) {
      return;
    }

    return pos({
      type: 'custom-media',
      name: trim(m[1]),
      media: trim(m[2])
    });
  }
  /**
   * Parse paged media.
   */


  function atpage() {
    const pos = position();
    const m = match(/^@page */);

    if (!m) {
      return;
    }

    const sel = selector() || [];

    if (!open()) {
      return error("@page missing '{'");
    }

    let decls = comments(); // declarations.

    let decl; // eslint-disable-next-line no-cond-assign

    while (decl = declaration()) {
      decls.push(decl);
      decls = decls.concat(comments());
    }

    if (!close()) {
      return error("@page missing '}'");
    }

    return pos({
      type: 'page',
      selectors: sel,
      declarations: decls
    });
  }
  /**
   * Parse document.
   */


  function atdocument() {
    const pos = position();
    const m = match(/^@([-\w]+)?document *([^{]+)/);

    if (!m) {
      return;
    }

    const vendor = trim(m[1]);
    const doc = trim(m[2]);

    if (!open()) {
      return error("@document missing '{'");
    }

    const style = comments().concat(rules());

    if (!close()) {
      return error("@document missing '}'");
    }

    return pos({
      type: 'document',
      document: doc,
      vendor,
      rules: style
    });
  }
  /**
   * Parse font-face.
   */


  function atfontface() {
    const pos = position();
    const m = match(/^@font-face\s*/);

    if (!m) {
      return;
    }

    if (!open()) {
      return error("@font-face missing '{'");
    }

    let decls = comments(); // declarations.

    let decl; // eslint-disable-next-line no-cond-assign

    while (decl = declaration()) {
      decls.push(decl);
      decls = decls.concat(comments());
    }

    if (!close()) {
      return error("@font-face missing '}'");
    }

    return pos({
      type: 'font-face',
      declarations: decls
    });
  }
  /**
   * Parse import
   */


  const atimport = _compileAtrule('import');
  /**
   * Parse charset
   */


  const atcharset = _compileAtrule('charset');
  /**
   * Parse namespace
   */


  const atnamespace = _compileAtrule('namespace');
  /**
   * Parse non-block at-rules
   */


  function _compileAtrule(name) {
    const re = new RegExp('^@' + name + '\\s*([^;]+);');
    return function () {
      const pos = position();
      const m = match(re);

      if (!m) {
        return;
      }

      const ret = {
        type: name
      };
      ret[name] = m[1].trim();
      return pos(ret);
    };
  }
  /**
   * Parse at rule.
   */


  function atrule() {
    if (css[0] !== '@') {
      return;
    }

    return atkeyframes() || atmedia() || atcustommedia() || atsupports() || atimport() || atcharset() || atnamespace() || atdocument() || atpage() || athost() || atfontface();
  }
  /**
   * Parse rule.
   */


  function rule() {
    const pos = position();
    const sel = selector();

    if (!sel) {
      return error('selector missing');
    }

    comments();
    return pos({
      type: 'rule',
      selectors: sel,
      declarations: declarations()
    });
  }

  return addParent(stylesheet());
}
/**
 * Trim `str`.
 */

function trim(str) {
  return str ? str.replace(/^\s+|\s+$/g, '') : '';
}
/**
 * Adds non-enumerable parent node reference to each node.
 */


function addParent(obj, parent) {
  const isNode = obj && typeof obj.type === 'string';
  const childParent = isNode ? obj : parent;

  for (const k in obj) {
    const value = obj[k];

    if (Array.isArray(value)) {
      value.forEach(function (v) {
        addParent(v, childParent);
      });
    } else if (value && typeof value === 'object') {
      addParent(value, childParent);
    }
  }

  if (isNode) {
    Object.defineProperty(obj, 'parent', {
      configurable: true,
      writable: true,
      enumerable: false,
      value: parent || null
    });
  }

  return obj;
}
/* eslint-enable @wordpress/no-unused-vars-before-return */

// EXTERNAL MODULE: ./node_modules/inherits/inherits_browser.js
var inherits_browser = __webpack_require__(8575);
var inherits_browser_default = /*#__PURE__*/__webpack_require__.n(inherits_browser);
;// CONCATENATED MODULE: ./packages/block-editor/build-module/utils/transform-styles/ast/stringify/compiler.js
// Adapted from https://github.com/reworkcss/css
// because we needed to remove source map support.

/**
 * Expose `Compiler`.
 */
/* harmony default export */ var compiler = (Compiler);
/**
 * Initialize a compiler.
 */

function Compiler(opts) {
  this.options = opts || {};
}
/**
 * Emit `str`
 */


Compiler.prototype.emit = function (str) {
  return str;
};
/**
 * Visit `node`.
 */


Compiler.prototype.visit = function (node) {
  return this[node.type](node);
};
/**
 * Map visit over array of `nodes`, optionally using a `delim`
 */


Compiler.prototype.mapVisit = function (nodes, delim) {
  let buf = '';
  delim = delim || '';

  for (let i = 0, length = nodes.length; i < length; i++) {
    buf += this.visit(nodes[i]);

    if (delim && i < length - 1) {
      buf += this.emit(delim);
    }
  }

  return buf;
};

;// CONCATENATED MODULE: ./packages/block-editor/build-module/utils/transform-styles/ast/stringify/compress.js
// Adapted from https://github.com/reworkcss/css
// because we needed to remove source map support.

/**
 * External dependencies
 */

/**
 * Internal dependencies
 */


/**
 * Expose compiler.
 */

/* harmony default export */ var compress = (compress_Compiler);
/**
 * Initialize a new `Compiler`.
 */

function compress_Compiler(options) {
  compiler.call(this, options);
}
/**
 * Inherit from `Base.prototype`.
 */


inherits_browser_default()(compress_Compiler, compiler);
/**
 * Compile `node`.
 */

compress_Compiler.prototype.compile = function (node) {
  return node.stylesheet.rules.map(this.visit, this).join('');
};
/**
 * Visit comment node.
 */


compress_Compiler.prototype.comment = function (node) {
  return this.emit('', node.position);
};
/**
 * Visit import node.
 */


compress_Compiler.prototype.import = function (node) {
  return this.emit('@import ' + node.import + ';', node.position);
};
/**
 * Visit media node.
 */


compress_Compiler.prototype.media = function (node) {
  return this.emit('@media ' + node.media, node.position) + this.emit('{') + this.mapVisit(node.rules) + this.emit('}');
};
/**
 * Visit document node.
 */


compress_Compiler.prototype.document = function (node) {
  const doc = '@' + (node.vendor || '') + 'document ' + node.document;
  return this.emit(doc, node.position) + this.emit('{') + this.mapVisit(node.rules) + this.emit('}');
};
/**
 * Visit charset node.
 */


compress_Compiler.prototype.charset = function (node) {
  return this.emit('@charset ' + node.charset + ';', node.position);
};
/**
 * Visit namespace node.
 */


compress_Compiler.prototype.namespace = function (node) {
  return this.emit('@namespace ' + node.namespace + ';', node.position);
};
/**
 * Visit supports node.
 */


compress_Compiler.prototype.supports = function (node) {
  return this.emit('@supports ' + node.supports, node.position) + this.emit('{') + this.mapVisit(node.rules) + this.emit('}');
};
/**
 * Visit keyframes node.
 */


compress_Compiler.prototype.keyframes = function (node) {
  return this.emit('@' + (node.vendor || '') + 'keyframes ' + node.name, node.position) + this.emit('{') + this.mapVisit(node.keyframes) + this.emit('}');
};
/**
 * Visit keyframe node.
 */


compress_Compiler.prototype.keyframe = function (node) {
  const decls = node.declarations;
  return this.emit(node.values.join(','), node.position) + this.emit('{') + this.mapVisit(decls) + this.emit('}');
};
/**
 * Visit page node.
 */


compress_Compiler.prototype.page = function (node) {
  const sel = node.selectors.length ? node.selectors.join(', ') : '';
  return this.emit('@page ' + sel, node.position) + this.emit('{') + this.mapVisit(node.declarations) + this.emit('}');
};
/**
 * Visit font-face node.
 */


compress_Compiler.prototype['font-face'] = function (node) {
  return this.emit('@font-face', node.position) + this.emit('{') + this.mapVisit(node.declarations) + this.emit('}');
};
/**
 * Visit host node.
 */


compress_Compiler.prototype.host = function (node) {
  return this.emit('@host', node.position) + this.emit('{') + this.mapVisit(node.rules) + this.emit('}');
};
/**
 * Visit custom-media node.
 */


compress_Compiler.prototype['custom-media'] = function (node) {
  return this.emit('@custom-media ' + node.name + ' ' + node.media + ';', node.position);
};
/**
 * Visit rule node.
 */


compress_Compiler.prototype.rule = function (node) {
  const decls = node.declarations;

  if (!decls.length) {
    return '';
  }

  return this.emit(node.selectors.join(','), node.position) + this.emit('{') + this.mapVisit(decls) + this.emit('}');
};
/**
 * Visit declaration node.
 */


compress_Compiler.prototype.declaration = function (node) {
  return this.emit(node.property + ':' + node.value, node.position) + this.emit(';');
};

;// CONCATENATED MODULE: ./packages/block-editor/build-module/utils/transform-styles/ast/stringify/identity.js
/* eslint-disable @wordpress/no-unused-vars-before-return */
// Adapted from https://github.com/reworkcss/css
// because we needed to remove source map support.

/**
 * External dependencies
 */

/**
 * Internal dependencies
 */


/**
 * Expose compiler.
 */

/* harmony default export */ var identity = (identity_Compiler);
/**
 * Initialize a new `Compiler`.
 */

function identity_Compiler(options) {
  options = options || {};
  compiler.call(this, options);
  this.indentation = options.indent;
}
/**
 * Inherit from `Base.prototype`.
 */


inherits_browser_default()(identity_Compiler, compiler);
/**
 * Compile `node`.
 */

identity_Compiler.prototype.compile = function (node) {
  return this.stylesheet(node);
};
/**
 * Visit stylesheet node.
 */


identity_Compiler.prototype.stylesheet = function (node) {
  return this.mapVisit(node.stylesheet.rules, '\n\n');
};
/**
 * Visit comment node.
 */


identity_Compiler.prototype.comment = function (node) {
  return this.emit(this.indent() + '/*' + node.comment + '*/', node.position);
};
/**
 * Visit import node.
 */


identity_Compiler.prototype.import = function (node) {
  return this.emit('@import ' + node.import + ';', node.position);
};
/**
 * Visit media node.
 */


identity_Compiler.prototype.media = function (node) {
  return this.emit('@media ' + node.media, node.position) + this.emit(' {\n' + this.indent(1)) + this.mapVisit(node.rules, '\n\n') + this.emit(this.indent(-1) + '\n}');
};
/**
 * Visit document node.
 */


identity_Compiler.prototype.document = function (node) {
  const doc = '@' + (node.vendor || '') + 'document ' + node.document;
  return this.emit(doc, node.position) + this.emit(' ' + ' {\n' + this.indent(1)) + this.mapVisit(node.rules, '\n\n') + this.emit(this.indent(-1) + '\n}');
};
/**
 * Visit charset node.
 */


identity_Compiler.prototype.charset = function (node) {
  return this.emit('@charset ' + node.charset + ';', node.position);
};
/**
 * Visit namespace node.
 */


identity_Compiler.prototype.namespace = function (node) {
  return this.emit('@namespace ' + node.namespace + ';', node.position);
};
/**
 * Visit supports node.
 */


identity_Compiler.prototype.supports = function (node) {
  return this.emit('@supports ' + node.supports, node.position) + this.emit(' {\n' + this.indent(1)) + this.mapVisit(node.rules, '\n\n') + this.emit(this.indent(-1) + '\n}');
};
/**
 * Visit keyframes node.
 */


identity_Compiler.prototype.keyframes = function (node) {
  return this.emit('@' + (node.vendor || '') + 'keyframes ' + node.name, node.position) + this.emit(' {\n' + this.indent(1)) + this.mapVisit(node.keyframes, '\n') + this.emit(this.indent(-1) + '}');
};
/**
 * Visit keyframe node.
 */


identity_Compiler.prototype.keyframe = function (node) {
  const decls = node.declarations;
  return this.emit(this.indent()) + this.emit(node.values.join(', '), node.position) + this.emit(' {\n' + this.indent(1)) + this.mapVisit(decls, '\n') + this.emit(this.indent(-1) + '\n' + this.indent() + '}\n');
};
/**
 * Visit page node.
 */


identity_Compiler.prototype.page = function (node) {
  const sel = node.selectors.length ? node.selectors.join(', ') + ' ' : '';
  return this.emit('@page ' + sel, node.position) + this.emit('{\n') + this.emit(this.indent(1)) + this.mapVisit(node.declarations, '\n') + this.emit(this.indent(-1)) + this.emit('\n}');
};
/**
 * Visit font-face node.
 */


identity_Compiler.prototype['font-face'] = function (node) {
  return this.emit('@font-face ', node.position) + this.emit('{\n') + this.emit(this.indent(1)) + this.mapVisit(node.declarations, '\n') + this.emit(this.indent(-1)) + this.emit('\n}');
};
/**
 * Visit host node.
 */


identity_Compiler.prototype.host = function (node) {
  return this.emit('@host', node.position) + this.emit(' {\n' + this.indent(1)) + this.mapVisit(node.rules, '\n\n') + this.emit(this.indent(-1) + '\n}');
};
/**
 * Visit custom-media node.
 */


identity_Compiler.prototype['custom-media'] = function (node) {
  return this.emit('@custom-media ' + node.name + ' ' + node.media + ';', node.position);
};
/**
 * Visit rule node.
 */


identity_Compiler.prototype.rule = function (node) {
  const indent = this.indent();
  const decls = node.declarations;

  if (!decls.length) {
    return '';
  }

  return this.emit(node.selectors.map(function (s) {
    return indent + s;
  }).join(',\n'), node.position) + this.emit(' {\n') + this.emit(this.indent(1)) + this.mapVisit(decls, '\n') + this.emit(this.indent(-1)) + this.emit('\n' + this.indent() + '}');
};
/**
 * Visit declaration node.
 */


identity_Compiler.prototype.declaration = function (node) {
  return this.emit(this.indent()) + this.emit(node.property + ': ' + node.value, node.position) + this.emit(';');
};
/**
 * Increase, decrease or return current indentation.
 */


identity_Compiler.prototype.indent = function (level) {
  this.level = this.level || 1;

  if (null !== level) {
    this.level += level;
    return '';
  }

  return Array(this.level).join(this.indentation || '  ');
};
/* eslint-enable @wordpress/no-unused-vars-before-return */

;// CONCATENATED MODULE: ./packages/block-editor/build-module/utils/transform-styles/ast/stringify/index.js
// Adapted from https://github.com/reworkcss/css
// because we needed to remove source map support.

/**
 * Internal dependencies
 */


/**
 * Stringfy the given AST `node`.
 *
 * Options:
 *
 *  - `compress` space-optimized output
 *  - `sourcemap` return an object with `.code` and `.map`
 *
 * @param {Object} node
 * @param {Object} [options]
 * @return {string}
 */

/* harmony default export */ function stringify(node, options) {
  options = options || {};
  const compiler = options.compress ? new compress(options) : new identity(options);
  const code = compiler.compile(node);
  return code;
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/utils/transform-styles/traverse.js
/**
 * External dependencies
 */

/**
 * Internal dependencies
 */



function traverseCSS(css, callback) {
  try {
    const parsed = parse(css);
    const updated = traverse_default().map(parsed, function (node) {
      if (!node) {
        return node;
      }

      const updatedNode = callback(node);
      return this.update(updatedNode);
    });
    return stringify(updated);
  } catch (err) {
    // eslint-disable-next-line no-console
    console.warn('Error while traversing the CSS: ' + err);
    return null;
  }
}

/* harmony default export */ var transform_styles_traverse = (traverseCSS);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/utils/transform-styles/transforms/url-rewrite.js
/**
 * Return `true` if the given path is http/https.
 *
 * @param {string} filePath path
 *
 * @return {boolean} is remote path.
 */
function isRemotePath(filePath) {
  return /^(?:https?:)?\/\//.test(filePath);
}
/**
 * Return `true` if the given filePath is an absolute url.
 *
 * @param {string} filePath path
 *
 * @return {boolean} is absolute path.
 */


function isAbsolutePath(filePath) {
  return /^\/(?!\/)/.test(filePath);
}
/**
 * Whether or not the url should be inluded.
 *
 * @param {Object} meta url meta info
 *
 * @return {boolean} is valid.
 */


function isValidURL(meta) {
  // Ignore hashes or data uris.
  if (meta.value.indexOf('data:') === 0 || meta.value.indexOf('#') === 0) {
    return false;
  }

  if (isAbsolutePath(meta.value)) {
    return false;
  } // Do not handle the http/https urls if `includeRemote` is false.


  if (isRemotePath(meta.value)) {
    return false;
  }

  return true;
}
/**
 * Get the absolute path of the url, relative to the basePath
 *
 * @param {string} str     the url
 * @param {string} baseURL base URL
 *
 * @return {string} the full path to the file
 */


function getResourcePath(str, baseURL) {
  return new URL(str, baseURL).toString();
}
/**
 * Process the single `url()` pattern
 *
 * @param {string} baseURL the base URL for relative URLs.
 *
 * @return {Promise} the Promise.
 */


function processURL(baseURL) {
  return meta => ({ ...meta,
    newUrl: 'url(' + meta.before + meta.quote + getResourcePath(meta.value, baseURL) + meta.quote + meta.after + ')'
  });
}
/**
 * Get all `url()`s, and return the meta info
 *
 * @param {string} value decl.value.
 *
 * @return {Array} the urls.
 */


function getURLs(value) {
  const reg = /url\((\s*)(['"]?)(.+?)\2(\s*)\)/g;
  let match;
  const URLs = [];

  while ((match = reg.exec(value)) !== null) {
    const meta = {
      source: match[0],
      before: match[1],
      quote: match[2],
      value: match[3],
      after: match[4]
    };

    if (isValidURL(meta)) {
      URLs.push(meta);
    }
  }

  return URLs;
}
/**
 * Replace the raw value's `url()` segment to the new value
 *
 * @param {string} raw  the raw value.
 * @param {Array}  URLs the URLs to replace.
 *
 * @return {string} the new value.
 */


function replaceURLs(raw, URLs) {
  URLs.forEach(item => {
    raw = raw.replace(item.source, item.newUrl);
  });
  return raw;
}

const rewrite = rootURL => node => {
  if (node.type === 'declaration') {
    const updatedURLs = getURLs(node.value).map(processURL(rootURL));
    return { ...node,
      value: replaceURLs(node.value, updatedURLs)
    };
  }

  return node;
};

/* harmony default export */ var url_rewrite = (rewrite);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/utils/transform-styles/transforms/wrap.js
/**
 * @constant string IS_ROOT_TAG Regex to check if the selector is a root tag selector.
 */
const IS_ROOT_TAG = /^(body|html|:root).*$/;
/**
 * Creates a callback to modify selectors so they only apply within a certain
 * namespace.
 *
 * @param {string}   namespace Namespace to prefix selectors with.
 * @param {string[]} ignore    Selectors to not prefix.
 *
 * @return {(node: Object) => Object} Callback to wrap selectors.
 */

const wrap = function (namespace) {
  let ignore = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
  return node => {
    /**
     * Updates selector if necessary.
     *
     * @param {string} selector Selector to modify.
     *
     * @return {string} Updated selector.
     */
    const updateSelector = selector => {
      if (ignore.includes(selector.trim())) {
        return selector;
      } // Anything other than a root tag is always prefixed.


      {
        if (!selector.match(IS_ROOT_TAG)) {
          return namespace + ' ' + selector;
        }
      } // HTML and Body elements cannot be contained within our container so lets extract their styles.

      return selector.replace(/^(body|html|:root)/, namespace);
    };

    if (node.type === 'rule') {
      return { ...node,
        selectors: node.selectors.map(updateSelector)
      };
    }

    return node;
  };
};

/* harmony default export */ var transforms_wrap = (wrap);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/utils/transform-styles/index.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




/**
 * Applies a series of CSS rule transforms to wrap selectors inside a given class and/or rewrite URLs depending on the parameters passed.
 *
 * @param {Array}  styles           CSS rules.
 * @param {string} wrapperClassName Wrapper Class Name.
 * @return {Array} converted rules.
 */

const transform_styles_transformStyles = function (styles) {
  let wrapperClassName = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  return (0,external_lodash_namespaceObject.map)(styles, _ref => {
    let {
      css,
      baseURL
    } = _ref;
    const transforms = [];

    if (wrapperClassName) {
      transforms.push(transforms_wrap(wrapperClassName));
    }

    if (baseURL) {
      transforms.push(url_rewrite(baseURL));
    }

    if (transforms.length) {
      return transform_styles_traverse(css, (0,external_wp_compose_namespaceObject.compose)(transforms));
    }

    return css;
  });
};

/* harmony default export */ var transform_styles = (transform_styles_transformStyles);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/editor-styles/index.js


/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


const EDITOR_STYLES_SELECTOR = '.editor-styles-wrapper';
k([names, a11y]);

function useDarkThemeBodyClassName(styles) {
  return (0,external_wp_element_namespaceObject.useCallback)(node => {
    if (!node) {
      return;
    }

    const {
      ownerDocument
    } = node;
    const {
      defaultView,
      body
    } = ownerDocument;
    const canvas = ownerDocument.querySelector(EDITOR_STYLES_SELECTOR);
    let backgroundColor;

    if (!canvas) {
      // The real .editor-styles-wrapper element might not exist in the
      // DOM, so calculate the background color by creating a fake
      // wrapper.
      const tempCanvas = ownerDocument.createElement('div');
      tempCanvas.classList.add('editor-styles-wrapper');
      body.appendChild(tempCanvas);
      backgroundColor = defaultView.getComputedStyle(tempCanvas, null).getPropertyValue('background-color');
      body.removeChild(tempCanvas);
    } else {
      backgroundColor = defaultView.getComputedStyle(canvas, null).getPropertyValue('background-color');
    }

    const colordBackgroundColor = w(backgroundColor); // If background is transparent, it should be treated as light color.

    if (colordBackgroundColor.luminance() > 0.5 || colordBackgroundColor.alpha() === 0) {
      body.classList.remove('is-dark-theme');
    } else {
      body.classList.add('is-dark-theme');
    }
  }, [styles]);
}

function EditorStyles(_ref) {
  let {
    styles
  } = _ref;
  const transformedStyles = (0,external_wp_element_namespaceObject.useMemo)(() => transform_styles(styles, EDITOR_STYLES_SELECTOR), [styles]);
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)("style", {
    ref: useDarkThemeBodyClassName(styles)
  }), transformedStyles.map((css, index) => (0,external_wp_element_namespaceObject.createElement)("style", {
    key: index
  }, css)));
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-preview/auto.js


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */




 // This is used to avoid rendering the block list if the sizes change.

let MemoizedBlockList;
const MAX_HEIGHT = 2000;

function AutoBlockPreview(_ref) {
  let {
    viewportWidth,
    __experimentalPadding
  } = _ref;
  const [containerResizeListener, {
    width: containerWidth
  }] = (0,external_wp_compose_namespaceObject.useResizeObserver)();
  const [contentResizeListener, {
    height: contentHeight
  }] = (0,external_wp_compose_namespaceObject.useResizeObserver)();
  const {
    styles,
    assets
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const settings = select(store).getSettings();
    return {
      styles: settings.styles,
      assets: settings.__unstableResolvedAssets
    };
  }, []); // Avoid scrollbars for pattern previews.

  const editorStyles = (0,external_wp_element_namespaceObject.useMemo)(() => {
    if (styles) {
      return [...styles, {
        css: 'body{height:auto;overflow:hidden;}',
        __unstableType: 'presets'
      }];
    }

    return styles;
  }, [styles]); // Initialize on render instead of module top level, to avoid circular dependency issues.

  MemoizedBlockList = MemoizedBlockList || (0,external_wp_compose_namespaceObject.pure)(BlockList);
  const scale = containerWidth / viewportWidth;
  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-block-preview__container"
  }, containerResizeListener, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Disabled, {
    className: "block-editor-block-preview__content",
    style: {
      transform: `scale(${scale})`,
      height: contentHeight * scale,
      maxHeight: contentHeight > MAX_HEIGHT ? MAX_HEIGHT * scale : undefined
    }
  }, (0,external_wp_element_namespaceObject.createElement)(iframe, {
    head: (0,external_wp_element_namespaceObject.createElement)(EditorStyles, {
      styles: editorStyles
    }),
    assets: assets,
    contentRef: (0,external_wp_compose_namespaceObject.useRefEffect)(bodyElement => {
      const {
        ownerDocument: {
          documentElement
        }
      } = bodyElement;
      documentElement.classList.add('block-editor-block-preview__content-iframe');
      documentElement.style.position = 'absolute';
      documentElement.style.width = '100%';
      bodyElement.style.padding = __experimentalPadding + 'px'; // necessary for contentResizeListener to work.

      bodyElement.style.position = 'relative';
    }, []),
    "aria-hidden": true,
    tabIndex: -1,
    style: {
      position: 'absolute',
      width: viewportWidth,
      height: contentHeight,
      pointerEvents: 'none',
      // This is a catch-all max-height for patterns.
      // See: https://github.com/WordPress/gutenberg/pull/38175.
      maxHeight: MAX_HEIGHT
    }
  }, contentResizeListener, (0,external_wp_element_namespaceObject.createElement)(MemoizedBlockList, {
    renderAppender: false
  }))));
}

/* harmony default export */ var auto = (AutoBlockPreview);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-preview/index.js


/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */






function BlockPreview(_ref) {
  let {
    blocks,
    __experimentalPadding = 0,
    viewportWidth = 1200,
    __experimentalLive = false,
    __experimentalOnClick
  } = _ref;
  const originalSettings = (0,external_wp_data_namespaceObject.useSelect)(select => select(store).getSettings(), []);
  const settings = (0,external_wp_element_namespaceObject.useMemo)(() => {
    const _settings = { ...originalSettings
    };
    _settings.__experimentalBlockPatterns = [];
    return _settings;
  }, [originalSettings]);
  const renderedBlocks = (0,external_wp_element_namespaceObject.useMemo)(() => (0,external_lodash_namespaceObject.castArray)(blocks), [blocks]);

  if (!blocks || blocks.length === 0) {
    return null;
  }

  return (0,external_wp_element_namespaceObject.createElement)(provider, {
    value: renderedBlocks,
    settings: settings
  }, __experimentalLive ? (0,external_wp_element_namespaceObject.createElement)(LiveBlockPreview, {
    onClick: __experimentalOnClick
  }) : (0,external_wp_element_namespaceObject.createElement)(auto, {
    viewportWidth: viewportWidth,
    __experimentalPadding: __experimentalPadding
  }));
}
/**
 * BlockPreview renders a preview of a block or array of blocks.
 *
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/block-preview/README.md
 *
 * @param {Object}       preview               options for how the preview should be shown
 * @param {Array|Object} preview.blocks        A block instance (object) or an array of blocks to be previewed.
 * @param {number}       preview.viewportWidth Width of the preview container in pixels. Controls at what size the blocks will be rendered inside the preview. Default: 700.
 *
 * @return {WPComponent} The component to be rendered.
 */

/* harmony default export */ var block_preview = ((0,external_wp_element_namespaceObject.memo)(BlockPreview));
/**
 * This hook is used to lightly mark an element as a block preview wrapper
 * element. Call this hook and pass the returned props to the element to mark as
 * a block preview wrapper, automatically rendering inner blocks as children. If
 * you define a ref for the element, it is important to pass the ref to this
 * hook, which the hook in turn will pass to the component through the props it
 * returns. Optionally, you can also pass any other props through this hook, and
 * they will be merged and returned.
 *
 * @param {Object}    options                      Preview options.
 * @param {WPBlock[]} options.blocks               Block objects.
 * @param {Object}    options.props                Optional. Props to pass to the element. Must contain
 *                                                 the ref if one is defined.
 * @param {Object}    options.__experimentalLayout Layout settings to be used in the preview.
 *
 */

function useBlockPreview(_ref2) {
  let {
    blocks,
    props = {},
    __experimentalLayout
  } = _ref2;
  const originalSettings = (0,external_wp_data_namespaceObject.useSelect)(select => select(store).getSettings(), []);
  const disabledRef = (0,external_wp_compose_namespaceObject.__experimentalUseDisabled)();
  const ref = (0,external_wp_compose_namespaceObject.useMergeRefs)([props.ref, disabledRef]);
  const settings = (0,external_wp_element_namespaceObject.useMemo)(() => ({ ...originalSettings,
    __experimentalBlockPatterns: []
  }), [originalSettings]);
  const renderedBlocks = (0,external_wp_element_namespaceObject.useMemo)(() => (0,external_lodash_namespaceObject.castArray)(blocks), [blocks]);
  const children = (0,external_wp_element_namespaceObject.createElement)(provider, {
    value: renderedBlocks,
    settings: settings
  }, (0,external_wp_element_namespaceObject.createElement)(BlockListItems, {
    renderAppender: false,
    __experimentalLayout: __experimentalLayout
  }));
  return { ...props,
    ref,
    className: classnames_default()(props.className, 'block-editor-block-preview__live-content', 'components-disabled'),
    children: blocks !== null && blocks !== void 0 && blocks.length ? children : null
  };
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inserter/preview-panel.js


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function InserterPreviewPanel(_ref) {
  var _hoveredItemBlockType, _hoveredItemBlockType2;

  let {
    item
  } = _ref;
  const {
    name,
    title,
    icon,
    description,
    initialAttributes
  } = item;
  const hoveredItemBlockType = (0,external_wp_blocks_namespaceObject.getBlockType)(name);
  const isReusable = (0,external_wp_blocks_namespaceObject.isReusableBlock)(item);
  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-inserter__preview-container"
  }, (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-inserter__preview"
  }, isReusable || hoveredItemBlockType !== null && hoveredItemBlockType !== void 0 && hoveredItemBlockType.example ? (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-inserter__preview-content"
  }, (0,external_wp_element_namespaceObject.createElement)(block_preview, {
    __experimentalPadding: 16,
    viewportWidth: (_hoveredItemBlockType = (_hoveredItemBlockType2 = hoveredItemBlockType.example) === null || _hoveredItemBlockType2 === void 0 ? void 0 : _hoveredItemBlockType2.viewportWidth) !== null && _hoveredItemBlockType !== void 0 ? _hoveredItemBlockType : 500,
    blocks: hoveredItemBlockType.example ? (0,external_wp_blocks_namespaceObject.getBlockFromExample)(item.name, {
      attributes: { ...hoveredItemBlockType.example.attributes,
        ...initialAttributes
      },
      innerBlocks: hoveredItemBlockType.example.innerBlocks
    }) : (0,external_wp_blocks_namespaceObject.createBlock)(name, initialAttributes)
  })) : (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-inserter__preview-content-missing"
  }, (0,external_wp_i18n_namespaceObject.__)('No Preview Available.'))), !isReusable && (0,external_wp_element_namespaceObject.createElement)(block_card, {
    title: title,
    icon: icon,
    description: description
  }));
}

/* harmony default export */ var preview_panel = (InserterPreviewPanel);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inserter-listbox/context.js
/**
 * WordPress dependencies
 */

const InserterListboxContext = (0,external_wp_element_namespaceObject.createContext)();
/* harmony default export */ var context = (InserterListboxContext);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inserter-listbox/item.js



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function InserterListboxItem(_ref, ref) {
  let {
    isFirst,
    as: Component,
    children,
    ...props
  } = _ref;
  const state = (0,external_wp_element_namespaceObject.useContext)(context);
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__unstableCompositeItem, _extends({
    ref: ref,
    state: state,
    role: "option" // Use the CompositeItem `focusable` prop over Button's
    // isFocusable. The latter was shown to cause an issue
    // with tab order in the inserter list.
    ,
    focusable: true
  }, props), htmlProps => {
    const propsWithTabIndex = { ...htmlProps,
      tabIndex: isFirst ? 0 : htmlProps.tabIndex
    };

    if (Component) {
      return (0,external_wp_element_namespaceObject.createElement)(Component, propsWithTabIndex, children);
    }

    if (typeof children === 'function') {
      return children(propsWithTabIndex);
    }

    return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, propsWithTabIndex, children);
  });
}

/* harmony default export */ var inserter_listbox_item = ((0,external_wp_element_namespaceObject.forwardRef)(InserterListboxItem));

;// CONCATENATED MODULE: ./packages/icons/build-module/library/drag-handle.js


/**
 * WordPress dependencies
 */

const dragHandle = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  width: "24",
  height: "24",
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M8 7h2V5H8v2zm0 6h2v-2H8v2zm0 6h2v-2H8v2zm6-14v2h2V5h-2zm0 8h2v-2h-2v2zm0 6h2v-2h-2v2z"
}));
/* harmony default export */ var drag_handle = (dragHandle);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-draggable/draggable-chip.js


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


function BlockDraggableChip(_ref) {
  let {
    count,
    icon
  } = _ref;
  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-block-draggable-chip-wrapper"
  }, (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-block-draggable-chip"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Flex, {
    justify: "center",
    className: "block-editor-block-draggable-chip__content"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.FlexItem, null, icon ? (0,external_wp_element_namespaceObject.createElement)(block_icon, {
    icon: icon
  }) : (0,external_wp_i18n_namespaceObject.sprintf)(
  /* translators: %d: Number of blocks. */
  (0,external_wp_i18n_namespaceObject._n)('%d block', '%d blocks', count), count)), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.FlexItem, null, (0,external_wp_element_namespaceObject.createElement)(block_icon, {
    icon: drag_handle
  })))));
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inserter-draggable-blocks/index.js


/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */



const InserterDraggableBlocks = _ref => {
  let {
    isEnabled,
    blocks,
    icon,
    children
  } = _ref;
  const transferData = {
    type: 'inserter',
    blocks
  };
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Draggable, {
    __experimentalTransferDataType: "wp-blocks",
    transferData: transferData,
    __experimentalDragComponent: (0,external_wp_element_namespaceObject.createElement)(BlockDraggableChip, {
      count: blocks.length,
      icon: icon
    })
  }, _ref2 => {
    let {
      onDraggableStart,
      onDraggableEnd
    } = _ref2;
    return children({
      draggable: isEnabled,
      onDragStart: isEnabled ? onDraggableStart : undefined,
      onDragEnd: isEnabled ? onDraggableEnd : undefined
    });
  });
};

/* harmony default export */ var inserter_draggable_blocks = (InserterDraggableBlocks);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inserter-list-item/index.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */




/**
 * Return true if platform is MacOS.
 *
 * @param {Object} _window window object by default; used for DI testing.
 *
 * @return {boolean} True if MacOS; false otherwise.
 */

function isAppleOS() {
  let _window = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : window;

  const {
    platform
  } = _window.navigator;
  return platform.indexOf('Mac') !== -1 || ['iPad', 'iPhone'].includes(platform);
}

function InserterListItem(_ref) {
  let {
    className,
    isFirst,
    item,
    onSelect,
    onHover,
    isDraggable,
    ...props
  } = _ref;
  const isDragging = (0,external_wp_element_namespaceObject.useRef)(false);
  const itemIconStyle = item.icon ? {
    backgroundColor: item.icon.background,
    color: item.icon.foreground
  } : {};
  const blocks = (0,external_wp_element_namespaceObject.useMemo)(() => {
    return [(0,external_wp_blocks_namespaceObject.createBlock)(item.name, item.initialAttributes, (0,external_wp_blocks_namespaceObject.createBlocksFromInnerBlocksTemplate)(item.innerBlocks))];
  }, [item.name, item.initialAttributes, item.initialAttributes]);
  return (0,external_wp_element_namespaceObject.createElement)(inserter_draggable_blocks, {
    isEnabled: isDraggable && !item.disabled,
    blocks: blocks,
    icon: item.icon
  }, _ref2 => {
    let {
      draggable,
      onDragStart,
      onDragEnd
    } = _ref2;
    return (0,external_wp_element_namespaceObject.createElement)("div", {
      className: "block-editor-block-types-list__list-item",
      draggable: draggable,
      onDragStart: event => {
        isDragging.current = true;

        if (onDragStart) {
          onHover(null);
          onDragStart(event);
        }
      },
      onDragEnd: event => {
        isDragging.current = false;

        if (onDragEnd) {
          onDragEnd(event);
        }
      }
    }, (0,external_wp_element_namespaceObject.createElement)(inserter_listbox_item, _extends({
      isFirst: isFirst,
      className: classnames_default()('block-editor-block-types-list__item', className),
      disabled: item.isDisabled,
      onClick: event => {
        event.preventDefault();
        onSelect(item, isAppleOS() ? event.metaKey : event.ctrlKey);
        onHover(null);
      },
      onKeyDown: event => {
        const {
          keyCode
        } = event;

        if (keyCode === external_wp_keycodes_namespaceObject.ENTER) {
          event.preventDefault();
          onSelect(item, isAppleOS() ? event.metaKey : event.ctrlKey);
          onHover(null);
        }
      },
      onFocus: () => {
        if (isDragging.current) {
          return;
        }

        onHover(item);
      },
      onMouseEnter: () => {
        if (isDragging.current) {
          return;
        }

        onHover(item);
      },
      onMouseLeave: () => onHover(null),
      onBlur: () => onHover(null)
    }, props), (0,external_wp_element_namespaceObject.createElement)("span", {
      className: "block-editor-block-types-list__item-icon",
      style: itemIconStyle
    }, (0,external_wp_element_namespaceObject.createElement)(block_icon, {
      icon: item.icon,
      showColors: true
    })), (0,external_wp_element_namespaceObject.createElement)("span", {
      className: "block-editor-block-types-list__item-title"
    }, item.title)));
  });
}

/* harmony default export */ var inserter_list_item = ((0,external_wp_element_namespaceObject.memo)(InserterListItem));

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inserter-listbox/group.js



/**
 * WordPress dependencies
 */




function InserterListboxGroup(props, ref) {
  const [shouldSpeak, setShouldSpeak] = (0,external_wp_element_namespaceObject.useState)(false);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (shouldSpeak) {
      (0,external_wp_a11y_namespaceObject.speak)((0,external_wp_i18n_namespaceObject.__)('Use left and right arrow keys to move through blocks'));
    }
  }, [shouldSpeak]);
  return (0,external_wp_element_namespaceObject.createElement)("div", _extends({
    ref: ref,
    role: "listbox",
    "aria-orientation": "horizontal",
    onFocus: () => {
      setShouldSpeak(true);
    },
    onBlur: event => {
      const focusingOutsideGroup = !event.currentTarget.contains(event.relatedTarget);

      if (focusingOutsideGroup) {
        setShouldSpeak(false);
      }
    }
  }, props));
}

/* harmony default export */ var group = ((0,external_wp_element_namespaceObject.forwardRef)(InserterListboxGroup));

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inserter-listbox/row.js



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function InserterListboxRow(props, ref) {
  const state = (0,external_wp_element_namespaceObject.useContext)(context);
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__unstableCompositeGroup, _extends({
    state: state,
    role: "presentation",
    ref: ref
  }, props));
}

/* harmony default export */ var inserter_listbox_row = ((0,external_wp_element_namespaceObject.forwardRef)(InserterListboxRow));

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-types-list/index.js


/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */




function chunk(array, size) {
  const chunks = [];

  for (let i = 0, j = array.length; i < j; i += size) {
    chunks.push(array.slice(i, i + size));
  }

  return chunks;
}

function BlockTypesList(_ref) {
  let {
    items = [],
    onSelect,
    onHover = () => {},
    children,
    label,
    isDraggable = true
  } = _ref;
  return (0,external_wp_element_namespaceObject.createElement)(group, {
    className: "block-editor-block-types-list",
    "aria-label": label
  }, chunk(items, 3).map((row, i) => (0,external_wp_element_namespaceObject.createElement)(inserter_listbox_row, {
    key: i
  }, row.map((item, j) => (0,external_wp_element_namespaceObject.createElement)(inserter_list_item, {
    key: item.id,
    item: item,
    className: (0,external_wp_blocks_namespaceObject.getBlockMenuDefaultClassName)(item.id),
    onSelect: onSelect,
    onHover: onHover,
    isDraggable: isDraggable,
    isFirst: i === 0 && j === 0
  })))), children);
}

/* harmony default export */ var block_types_list = (BlockTypesList);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inserter/panel.js


/**
 * WordPress dependencies
 */


function InserterPanel(_ref) {
  let {
    title,
    icon,
    children
  } = _ref;
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-inserter__panel-header"
  }, (0,external_wp_element_namespaceObject.createElement)("h2", {
    className: "block-editor-inserter__panel-title"
  }, title), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Icon, {
    icon: icon
  })), (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-inserter__panel-content"
  }, children));
}

/* harmony default export */ var panel = (InserterPanel);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inserter/hooks/use-block-types-state.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


/**
 * Retrieves the block types inserter state.
 *
 * @param {string=}  rootClientId Insertion's root client ID.
 * @param {Function} onInsert     function called when inserter a list of blocks.
 * @return {Array} Returns the block types state. (block types, categories, collections, onSelect handler)
 */

const useBlockTypesState = (rootClientId, onInsert) => {
  const {
    categories,
    collections,
    items
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getInserterItems
    } = select(store);
    const {
      getCategories,
      getCollections
    } = select(external_wp_blocks_namespaceObject.store);
    return {
      categories: getCategories(),
      collections: getCollections(),
      items: getInserterItems(rootClientId)
    };
  }, [rootClientId]);
  const onSelectItem = (0,external_wp_element_namespaceObject.useCallback)((_ref, shouldFocusBlock) => {
    let {
      name,
      initialAttributes,
      innerBlocks
    } = _ref;
    const insertedBlock = (0,external_wp_blocks_namespaceObject.createBlock)(name, initialAttributes, (0,external_wp_blocks_namespaceObject.createBlocksFromInnerBlocksTemplate)(innerBlocks));
    onInsert(insertedBlock, undefined, shouldFocusBlock);
  }, [onInsert]);
  return [items, categories, collections, onSelectItem];
};

/* harmony default export */ var use_block_types_state = (useBlockTypesState);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inserter-listbox/index.js


/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */






function InserterListbox(_ref) {
  let {
    children
  } = _ref;
  const compositeState = (0,external_wp_components_namespaceObject.__unstableUseCompositeState)({
    shift: true,
    wrap: 'horizontal'
  });
  return (0,external_wp_element_namespaceObject.createElement)(context.Provider, {
    value: compositeState
  }, children);
}

/* harmony default export */ var inserter_listbox = (InserterListbox);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inserter/block-types-tab.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */






const getBlockNamespace = item => item.name.split('/')[0];

const MAX_SUGGESTED_ITEMS = 6;
/**
 * Shared reference to an empty array for cases where it is important to avoid
 * returning a new array reference on every invocation and rerendering the component.
 *
 * @type {Array}
 */

const block_types_tab_EMPTY_ARRAY = [];
function BlockTypesTab(_ref) {
  let {
    rootClientId,
    onInsert,
    onHover,
    showMostUsedBlocks
  } = _ref;
  const [items, categories, collections, onSelectItem] = use_block_types_state(rootClientId, onInsert);
  const suggestedItems = (0,external_wp_element_namespaceObject.useMemo)(() => {
    return (0,external_lodash_namespaceObject.orderBy)(items, ['frecency'], ['desc']).slice(0, MAX_SUGGESTED_ITEMS);
  }, [items]);
  const uncategorizedItems = (0,external_wp_element_namespaceObject.useMemo)(() => {
    return items.filter(item => !item.category);
  }, [items]);
  const itemsPerCategory = (0,external_wp_element_namespaceObject.useMemo)(() => {
    return (0,external_lodash_namespaceObject.flow)(itemList => itemList.filter(item => item.category && item.category !== 'reusable'), itemList => (0,external_lodash_namespaceObject.groupBy)(itemList, 'category'))(items);
  }, [items]);
  const itemsPerCollection = (0,external_wp_element_namespaceObject.useMemo)(() => {
    // Create a new Object to avoid mutating collection.
    const result = { ...collections
    };
    Object.keys(collections).forEach(namespace => {
      result[namespace] = items.filter(item => getBlockNamespace(item) === namespace);

      if (result[namespace].length === 0) {
        delete result[namespace];
      }
    });
    return result;
  }, [items, collections]); // Hide block preview on unmount.

  (0,external_wp_element_namespaceObject.useEffect)(() => () => onHover(null), []);
  /**
   * The inserter contains a big number of blocks and opening it is a costful operation.
   * The rendering is the most costful part of it, in order to improve the responsiveness
   * of the "opening" action, these lazy lists allow us to render the inserter category per category,
   * once all the categories are rendered, we start rendering the collections and the uncategorized block types.
   */

  const currentlyRenderedCategories = (0,external_wp_compose_namespaceObject.useAsyncList)(categories);
  const didRenderAllCategories = categories.length === currentlyRenderedCategories.length; // Async List requires an array.

  const collectionEntries = (0,external_wp_element_namespaceObject.useMemo)(() => {
    return Object.entries(collections);
  }, [collections]);
  const currentlyRenderedCollections = (0,external_wp_compose_namespaceObject.useAsyncList)(didRenderAllCategories ? collectionEntries : block_types_tab_EMPTY_ARRAY);
  return (0,external_wp_element_namespaceObject.createElement)(inserter_listbox, null, (0,external_wp_element_namespaceObject.createElement)("div", null, showMostUsedBlocks && !!suggestedItems.length && (0,external_wp_element_namespaceObject.createElement)(panel, {
    title: (0,external_wp_i18n_namespaceObject._x)('Most used', 'blocks')
  }, (0,external_wp_element_namespaceObject.createElement)(block_types_list, {
    items: suggestedItems,
    onSelect: onSelectItem,
    onHover: onHover,
    label: (0,external_wp_i18n_namespaceObject._x)('Most used', 'blocks')
  })), (0,external_lodash_namespaceObject.map)(currentlyRenderedCategories, category => {
    const categoryItems = itemsPerCategory[category.slug];

    if (!categoryItems || !categoryItems.length) {
      return null;
    }

    return (0,external_wp_element_namespaceObject.createElement)(panel, {
      key: category.slug,
      title: category.title,
      icon: category.icon
    }, (0,external_wp_element_namespaceObject.createElement)(block_types_list, {
      items: categoryItems,
      onSelect: onSelectItem,
      onHover: onHover,
      label: category.title
    }));
  }), didRenderAllCategories && uncategorizedItems.length > 0 && (0,external_wp_element_namespaceObject.createElement)(panel, {
    className: "block-editor-inserter__uncategorized-blocks-panel",
    title: (0,external_wp_i18n_namespaceObject.__)('Uncategorized')
  }, (0,external_wp_element_namespaceObject.createElement)(block_types_list, {
    items: uncategorizedItems,
    onSelect: onSelectItem,
    onHover: onHover,
    label: (0,external_wp_i18n_namespaceObject.__)('Uncategorized')
  })), (0,external_lodash_namespaceObject.map)(currentlyRenderedCollections, _ref2 => {
    let [namespace, collection] = _ref2;
    const collectionItems = itemsPerCollection[namespace];

    if (!collectionItems || !collectionItems.length) {
      return null;
    }

    return (0,external_wp_element_namespaceObject.createElement)(panel, {
      key: namespace,
      title: collection.title,
      icon: collection.icon
    }, (0,external_wp_element_namespaceObject.createElement)(block_types_list, {
      items: collectionItems,
      onSelect: onSelectItem,
      onHover: onHover,
      label: collection.title
    }));
  })));
}
/* harmony default export */ var block_types_tab = (BlockTypesTab);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inserter/pattern-panel.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */





function PatternInserterPanel(_ref) {
  let {
    selectedCategory,
    patternCategories,
    onClickCategory,
    openPatternExplorer
  } = _ref;
  const isMobile = (0,external_wp_compose_namespaceObject.useViewportMatch)('medium', '<');

  const categoryOptions = () => {
    const options = [];
    patternCategories.map(patternCategory => {
      return options.push({
        value: patternCategory.name,
        label: patternCategory.label
      });
    });
    return options;
  };

  const onChangeSelect = selected => {
    onClickCategory(patternCategories.find(patternCategory => selected === patternCategory.name));
  };

  const className = classnames_default()('block-editor-inserter__panel-header', 'block-editor-inserter__panel-header-patterns'); // In iOS-based mobile devices, the onBlur will fire when selecting an option
  // from a Select element. To prevent closing the useDialog on iOS devices, we
  // stop propagating the onBlur event if there is no relatedTarget, which means
  // that the user most likely did not click on an element within the editor canvas.

  const onBlur = event => {
    if (!(event !== null && event !== void 0 && event.relatedTarget)) {
      event.stopPropagation();
    }
  };

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Flex, {
    justify: "space-between",
    align: "start",
    gap: "4",
    className: className
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.FlexItem, {
    isBlock: true
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SelectControl, {
    className: "block-editor-inserter__panel-dropdown",
    label: (0,external_wp_i18n_namespaceObject.__)('Filter patterns'),
    hideLabelFromVision: true,
    value: selectedCategory.name,
    onChange: onChangeSelect,
    onBlur: onBlur,
    options: categoryOptions()
  })), !isMobile && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.FlexItem, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
    variant: "secondary",
    className: "block-editor-inserter__patterns-explorer-expand",
    label: (0,external_wp_i18n_namespaceObject.__)('Explore all patterns'),
    onClick: () => openPatternExplorer()
  }, (0,external_wp_i18n_namespaceObject._x)('Explore', 'Label for showing all block patterns'))));
}

/* harmony default export */ var pattern_panel = (PatternInserterPanel);

;// CONCATENATED MODULE: external ["wp","notices"]
var external_wp_notices_namespaceObject = window["wp"]["notices"];
;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inserter/hooks/use-patterns-state.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */


/**
 * Retrieves the block patterns inserter state.
 *
 * @param {Function} onInsert     function called when inserter a list of blocks.
 * @param {string=}  rootClientId Insertion's root client ID.
 *
 * @return {Array} Returns the patterns state. (patterns, categories, onSelect handler)
 */

const usePatternsState = (onInsert, rootClientId) => {
  const {
    patternCategories,
    patterns
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      __experimentalGetAllowedPatterns,
      getSettings
    } = select(store);
    return {
      patterns: __experimentalGetAllowedPatterns(rootClientId),
      patternCategories: getSettings().__experimentalBlockPatternCategories
    };
  }, [rootClientId]);
  const {
    createSuccessNotice
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
  const onClickPattern = (0,external_wp_element_namespaceObject.useCallback)((pattern, blocks) => {
    onInsert((0,external_lodash_namespaceObject.map)(blocks, block => (0,external_wp_blocks_namespaceObject.cloneBlock)(block)), pattern.name);
    createSuccessNotice((0,external_wp_i18n_namespaceObject.sprintf)(
    /* translators: %s: block pattern title. */
    (0,external_wp_i18n_namespaceObject.__)('Block pattern "%s" inserted.'), pattern.title), {
      type: 'snackbar'
    });
  }, []);
  return [patterns, patternCategories, onClickPattern];
};

/* harmony default export */ var use_patterns_state = (usePatternsState);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-patterns-list/index.js



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function BlockPattern(_ref) {
  let {
    isDraggable,
    pattern,
    onClick,
    composite
  } = _ref;
  const {
    blocks,
    viewportWidth
  } = pattern;
  const instanceId = (0,external_wp_compose_namespaceObject.useInstanceId)(BlockPattern);
  const descriptionId = `block-editor-block-patterns-list__item-description-${instanceId}`;
  return (0,external_wp_element_namespaceObject.createElement)(inserter_draggable_blocks, {
    isEnabled: isDraggable,
    blocks: blocks
  }, _ref2 => {
    let {
      draggable,
      onDragStart,
      onDragEnd
    } = _ref2;
    return (0,external_wp_element_namespaceObject.createElement)("div", {
      className: "block-editor-block-patterns-list__list-item",
      "aria-label": pattern.title,
      "aria-describedby": pattern.description ? descriptionId : undefined,
      draggable: draggable,
      onDragStart: onDragStart,
      onDragEnd: onDragEnd
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__unstableCompositeItem, _extends({
      role: "option",
      as: "div"
    }, composite, {
      className: "block-editor-block-patterns-list__item",
      onClick: () => onClick(pattern, blocks)
    }), (0,external_wp_element_namespaceObject.createElement)(block_preview, {
      blocks: blocks,
      viewportWidth: viewportWidth
    }), (0,external_wp_element_namespaceObject.createElement)("div", {
      className: "block-editor-block-patterns-list__item-title"
    }, pattern.title), !!pattern.description && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.VisuallyHidden, {
      id: descriptionId
    }, pattern.description)));
  });
}

function BlockPatternPlaceholder() {
  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-block-patterns-list__item is-placeholder"
  });
}

function BlockPatternList(_ref3) {
  let {
    isDraggable,
    blockPatterns,
    shownPatterns,
    onClickPattern,
    orientation,
    label = (0,external_wp_i18n_namespaceObject.__)('Block Patterns')
  } = _ref3;
  const composite = (0,external_wp_components_namespaceObject.__unstableUseCompositeState)({
    orientation
  });
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__unstableComposite, _extends({}, composite, {
    role: "listbox",
    className: "block-editor-block-patterns-list",
    "aria-label": label
  }), blockPatterns.map(pattern => {
    const isShown = shownPatterns.includes(pattern);
    return isShown ? (0,external_wp_element_namespaceObject.createElement)(BlockPattern, {
      key: pattern.name,
      pattern: pattern,
      onClick: onClickPattern,
      isDraggable: isDraggable,
      composite: composite
    }) : (0,external_wp_element_namespaceObject.createElement)(BlockPatternPlaceholder, {
      key: pattern.name
    });
  }));
}

/* harmony default export */ var block_patterns_list = (BlockPatternList);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inserter/block-patterns-explorer/sidebar.js


/**
 * WordPress dependencies
 */



function PatternCategoriesList(_ref) {
  let {
    selectedCategory,
    patternCategories,
    onClickCategory
  } = _ref;
  const baseClassName = 'block-editor-block-patterns-explorer__sidebar';
  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: `${baseClassName}__categories-list`
  }, patternCategories.map(_ref2 => {
    let {
      name,
      label
    } = _ref2;
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
      key: name,
      label: label,
      className: `${baseClassName}__categories-list__item`,
      isPressed: selectedCategory === name,
      onClick: () => {
        onClickCategory(name);
      }
    }, label);
  }));
}

function PatternsExplorerSearch(_ref3) {
  let {
    filterValue,
    setFilterValue
  } = _ref3;
  const baseClassName = 'block-editor-block-patterns-explorer__search';
  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: baseClassName
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SearchControl, {
    onChange: setFilterValue,
    value: filterValue,
    label: (0,external_wp_i18n_namespaceObject.__)('Search for patterns'),
    placeholder: (0,external_wp_i18n_namespaceObject.__)('Search')
  }));
}

function PatternExplorerSidebar(_ref4) {
  let {
    selectedCategory,
    patternCategories,
    onClickCategory,
    filterValue,
    setFilterValue
  } = _ref4;
  const baseClassName = 'block-editor-block-patterns-explorer__sidebar';
  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: baseClassName
  }, (0,external_wp_element_namespaceObject.createElement)(PatternsExplorerSearch, {
    filterValue: filterValue,
    setFilterValue: setFilterValue
  }), !filterValue && (0,external_wp_element_namespaceObject.createElement)(PatternCategoriesList, {
    selectedCategory: selectedCategory,
    patternCategories: patternCategories,
    onClickCategory: onClickCategory
  }));
}

/* harmony default export */ var sidebar = (PatternExplorerSidebar);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inserter/no-results.js


/**
 * WordPress dependencies
 */



function InserterNoResults() {
  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-inserter__no-results"
  }, (0,external_wp_element_namespaceObject.createElement)(build_module_icon, {
    className: "block-editor-inserter__no-results-icon",
    icon: block_default
  }), (0,external_wp_element_namespaceObject.createElement)("p", null, (0,external_wp_i18n_namespaceObject.__)('No results found.')));
}

/* harmony default export */ var no_results = (InserterNoResults);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inserter/hooks/use-insertion-point.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */


/**
 * @typedef WPInserterConfig
 *
 * @property {string=}   rootClientId   If set, insertion will be into the
 *                                      block with this ID.
 * @property {number=}   insertionIndex If set, insertion will be into this
 *                                      explicit position.
 * @property {string=}   clientId       If set, insertion will be after the
 *                                      block with this ID.
 * @property {boolean=}  isAppender     Whether the inserter is an appender
 *                                      or not.
 * @property {Function=} onSelect       Called after insertion.
 */

/**
 * Returns the insertion point state given the inserter config.
 *
 * @param {WPInserterConfig} config Inserter Config.
 * @return {Array} Insertion Point State (rootClientID, onInsertBlocks and onToggle).
 */

function useInsertionPoint(_ref) {
  let {
    rootClientId = '',
    insertionIndex,
    clientId,
    isAppender,
    onSelect,
    shouldFocusBlock = true
  } = _ref;
  const {
    getSelectedBlock
  } = (0,external_wp_data_namespaceObject.useSelect)(store);
  const {
    destinationRootClientId,
    destinationIndex
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getSelectedBlockClientId,
      getBlockRootClientId,
      getBlockIndex,
      getBlockOrder
    } = select(store);
    const selectedBlockClientId = getSelectedBlockClientId();
    let _destinationRootClientId = rootClientId;

    let _destinationIndex;

    if (insertionIndex !== undefined) {
      // Insert into a specific index.
      _destinationIndex = insertionIndex;
    } else if (clientId) {
      // Insert after a specific client ID.
      _destinationIndex = getBlockIndex(clientId);
    } else if (!isAppender && selectedBlockClientId) {
      _destinationRootClientId = getBlockRootClientId(selectedBlockClientId);
      _destinationIndex = getBlockIndex(selectedBlockClientId) + 1;
    } else {
      // Insert at the end of the list.
      _destinationIndex = getBlockOrder(_destinationRootClientId).length;
    }

    return {
      destinationRootClientId: _destinationRootClientId,
      destinationIndex: _destinationIndex
    };
  }, [rootClientId, insertionIndex, clientId, isAppender]);
  const {
    replaceBlocks,
    insertBlocks,
    showInsertionPoint,
    hideInsertionPoint
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const onInsertBlocks = (0,external_wp_element_namespaceObject.useCallback)(function (blocks, meta) {
    let shouldForceFocusBlock = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    const selectedBlock = getSelectedBlock();

    if (!isAppender && selectedBlock && (0,external_wp_blocks_namespaceObject.isUnmodifiedDefaultBlock)(selectedBlock)) {
      replaceBlocks(selectedBlock.clientId, blocks, null, shouldFocusBlock || shouldForceFocusBlock ? 0 : null, meta);
    } else {
      insertBlocks(blocks, destinationIndex, destinationRootClientId, true, shouldFocusBlock || shouldForceFocusBlock ? 0 : null, meta);
    }

    const message = (0,external_wp_i18n_namespaceObject.sprintf)( // translators: %d: the name of the block that has been added
    (0,external_wp_i18n_namespaceObject._n)('%d block added.', '%d blocks added.', (0,external_lodash_namespaceObject.castArray)(blocks).length), (0,external_lodash_namespaceObject.castArray)(blocks).length);
    (0,external_wp_a11y_namespaceObject.speak)(message);

    if (onSelect) {
      onSelect();
    }
  }, [isAppender, getSelectedBlock, replaceBlocks, insertBlocks, destinationRootClientId, destinationIndex, onSelect, shouldFocusBlock]);
  const onToggleInsertionPoint = (0,external_wp_element_namespaceObject.useCallback)(show => {
    if (show) {
      showInsertionPoint(destinationRootClientId, destinationIndex);
    } else {
      hideInsertionPoint();
    }
  }, [showInsertionPoint, hideInsertionPoint, destinationRootClientId, destinationIndex]);
  return [destinationRootClientId, onInsertBlocks, onToggleInsertionPoint];
}

/* harmony default export */ var use_insertion_point = (useInsertionPoint);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inserter/search-items.js
/**
 * External dependencies
 */
 // Default search helpers.

const defaultGetName = item => item.name || '';

const defaultGetTitle = item => item.title;

const defaultGetDescription = item => item.description || '';

const defaultGetKeywords = item => item.keywords || [];

const defaultGetCategory = item => item.category;

const defaultGetCollection = () => null;
/**
 * Sanitizes the search input string.
 *
 * @param {string} input The search input to normalize.
 *
 * @return {string} The normalized search input.
 */


function normalizeSearchInput() {
  let input = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
  // Disregard diacritics.
  //  Input: "média"
  input = (0,external_lodash_namespaceObject.deburr)(input); // Accommodate leading slash, matching autocomplete expectations.
  //  Input: "/media"

  input = input.replace(/^\//, ''); // Lowercase.
  //  Input: "MEDIA"

  input = input.toLowerCase();
  return input;
}
/**
 * Converts the search term into a list of normalized terms.
 *
 * @param {string} input The search term to normalize.
 *
 * @return {string[]} The normalized list of search terms.
 */


const getNormalizedSearchTerms = function () {
  let input = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
  // Extract words.
  return (0,external_lodash_namespaceObject.words)(normalizeSearchInput(input));
};

const removeMatchingTerms = (unmatchedTerms, unprocessedTerms) => {
  return (0,external_lodash_namespaceObject.differenceWith)(unmatchedTerms, getNormalizedSearchTerms(unprocessedTerms), (unmatchedTerm, unprocessedTerm) => unprocessedTerm.includes(unmatchedTerm));
};

const searchBlockItems = (items, categories, collections, searchInput) => {
  const normalizedSearchTerms = getNormalizedSearchTerms(searchInput);

  if (normalizedSearchTerms.length === 0) {
    return items;
  }

  const config = {
    getCategory: item => {
      var _find;

      return (_find = (0,external_lodash_namespaceObject.find)(categories, {
        slug: item.category
      })) === null || _find === void 0 ? void 0 : _find.title;
    },
    getCollection: item => {
      var _collections$item$nam;

      return (_collections$item$nam = collections[item.name.split('/')[0]]) === null || _collections$item$nam === void 0 ? void 0 : _collections$item$nam.title;
    }
  };
  return searchItems(items, searchInput, config);
};
/**
 * Filters an item list given a search term.
 *
 * @param {Array}  items       Item list
 * @param {string} searchInput Search input.
 * @param {Object} config      Search Config.
 *
 * @return {Array} Filtered item list.
 */

const searchItems = function () {
  let items = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  let searchInput = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  let config = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  const normalizedSearchTerms = getNormalizedSearchTerms(searchInput);

  if (normalizedSearchTerms.length === 0) {
    return items;
  }

  const rankedItems = items.map(item => {
    return [item, getItemSearchRank(item, searchInput, config)];
  }).filter(_ref => {
    let [, rank] = _ref;
    return rank > 0;
  });
  rankedItems.sort((_ref2, _ref3) => {
    let [, rank1] = _ref2;
    let [, rank2] = _ref3;
    return rank2 - rank1;
  });
  return rankedItems.map(_ref4 => {
    let [item] = _ref4;
    return item;
  });
};
/**
 * Get the search rank for a given item and a specific search term.
 * The better the match, the higher the rank.
 * If the rank equals 0, it should be excluded from the results.
 *
 * @param {Object} item       Item to filter.
 * @param {string} searchTerm Search term.
 * @param {Object} config     Search Config.
 *
 * @return {number} Search Rank.
 */

function getItemSearchRank(item, searchTerm) {
  let config = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  const {
    getName = defaultGetName,
    getTitle = defaultGetTitle,
    getDescription = defaultGetDescription,
    getKeywords = defaultGetKeywords,
    getCategory = defaultGetCategory,
    getCollection = defaultGetCollection
  } = config;
  const name = getName(item);
  const title = getTitle(item);
  const description = getDescription(item);
  const keywords = getKeywords(item);
  const category = getCategory(item);
  const collection = getCollection(item);
  const normalizedSearchInput = normalizeSearchInput(searchTerm);
  const normalizedTitle = normalizeSearchInput(title);
  let rank = 0; // Prefers exact matches
  // Then prefers if the beginning of the title matches the search term
  // name, keywords, categories, collection, variations match come later.

  if (normalizedSearchInput === normalizedTitle) {
    rank += 30;
  } else if (normalizedTitle.startsWith(normalizedSearchInput)) {
    rank += 20;
  } else {
    const terms = [name, title, description, ...keywords, category, collection].join(' ');
    const normalizedSearchTerms = (0,external_lodash_namespaceObject.words)(normalizedSearchInput);
    const unmatchedTerms = removeMatchingTerms(normalizedSearchTerms, terms);

    if (unmatchedTerms.length === 0) {
      rank += 10;
    }
  } // Give a better rank to "core" namespaced items.


  if (rank !== 0 && name.startsWith('core/')) {
    const isCoreBlockVariation = name !== item.id; // Give a bit better rank to "core" blocks over "core" block variations.

    rank += isCoreBlockVariation ? 1 : 2;
  }

  return rank;
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inserter/block-patterns-explorer/patterns-list.js


/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */







const INITIAL_INSERTER_RESULTS = 2;

function PatternsListHeader(_ref) {
  let {
    filterValue,
    filteredBlockPatternsLength
  } = _ref;

  if (!filterValue) {
    return null;
  }

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalHeading, {
    level: 2,
    lineHeight: '48px',
    className: "block-editor-block-patterns-explorer__search-results-count"
  }, (0,external_wp_i18n_namespaceObject.sprintf)(
  /* translators: %d: number of patterns. %s: block pattern search query */
  (0,external_wp_i18n_namespaceObject._n)('%1$d pattern found for "%2$s"', '%1$d patterns found for "%2$s"', filteredBlockPatternsLength), filteredBlockPatternsLength, filterValue));
}

function PatternList(_ref2) {
  let {
    filterValue,
    selectedCategory,
    patternCategories
  } = _ref2;
  const debouncedSpeak = (0,external_wp_compose_namespaceObject.useDebounce)(external_wp_a11y_namespaceObject.speak, 500);
  const [destinationRootClientId, onInsertBlocks] = use_insertion_point({
    shouldFocusBlock: true
  });
  const [allPatterns,, onSelectBlockPattern] = use_patterns_state(onInsertBlocks, destinationRootClientId);
  const registeredPatternCategories = (0,external_wp_element_namespaceObject.useMemo)(() => patternCategories.map(patternCategory => patternCategory.name), [patternCategories]);
  const filteredBlockPatterns = (0,external_wp_element_namespaceObject.useMemo)(() => {
    if (!filterValue) {
      return allPatterns.filter(pattern => {
        var _pattern$categories, _pattern$categories2;

        return selectedCategory === 'uncategorized' ? !((_pattern$categories = pattern.categories) !== null && _pattern$categories !== void 0 && _pattern$categories.length) || pattern.categories.every(category => !registeredPatternCategories.includes(category)) : (_pattern$categories2 = pattern.categories) === null || _pattern$categories2 === void 0 ? void 0 : _pattern$categories2.includes(selectedCategory);
      });
    }

    return searchItems(allPatterns, filterValue);
  }, [filterValue, selectedCategory, allPatterns]); // Announce search results on change.

  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (!filterValue) {
      return;
    }

    const count = filteredBlockPatterns.length;
    const resultsFoundMessage = (0,external_wp_i18n_namespaceObject.sprintf)(
    /* translators: %d: number of results. */
    (0,external_wp_i18n_namespaceObject._n)('%d result found.', '%d results found.', count), count);
    debouncedSpeak(resultsFoundMessage);
  }, [filterValue, debouncedSpeak]);
  const currentShownPatterns = (0,external_wp_compose_namespaceObject.useAsyncList)(filteredBlockPatterns, {
    step: INITIAL_INSERTER_RESULTS
  });
  const hasItems = !!(filteredBlockPatterns !== null && filteredBlockPatterns !== void 0 && filteredBlockPatterns.length);
  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-block-patterns-explorer__list"
  }, hasItems && (0,external_wp_element_namespaceObject.createElement)(PatternsListHeader, {
    filterValue: filterValue,
    filteredBlockPatternsLength: filteredBlockPatterns.length
  }), (0,external_wp_element_namespaceObject.createElement)(inserter_listbox, null, !hasItems && (0,external_wp_element_namespaceObject.createElement)(no_results, null), hasItems && (0,external_wp_element_namespaceObject.createElement)(block_patterns_list, {
    shownPatterns: currentShownPatterns,
    blockPatterns: filteredBlockPatterns,
    onClickPattern: onSelectBlockPattern,
    isDraggable: false
  })));
}

/* harmony default export */ var patterns_list = (PatternList);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inserter/block-patterns-explorer/explorer.js


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function PatternsExplorer(_ref) {
  let {
    initialCategory,
    patternCategories
  } = _ref;
  const [filterValue, setFilterValue] = (0,external_wp_element_namespaceObject.useState)('');
  const [selectedCategory, setSelectedCategory] = (0,external_wp_element_namespaceObject.useState)(initialCategory === null || initialCategory === void 0 ? void 0 : initialCategory.name);
  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-block-patterns-explorer"
  }, (0,external_wp_element_namespaceObject.createElement)(sidebar, {
    selectedCategory: selectedCategory,
    patternCategories: patternCategories,
    onClickCategory: setSelectedCategory,
    filterValue: filterValue,
    setFilterValue: setFilterValue
  }), (0,external_wp_element_namespaceObject.createElement)(patterns_list, {
    filterValue: filterValue,
    selectedCategory: selectedCategory,
    patternCategories: patternCategories
  }));
}

function PatternsExplorerModal(_ref2) {
  let {
    onModalClose,
    ...restProps
  } = _ref2;
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Modal, {
    title: (0,external_wp_i18n_namespaceObject.__)('Patterns'),
    closeLabel: (0,external_wp_i18n_namespaceObject.__)('Close'),
    onRequestClose: onModalClose,
    isFullScreen: true
  }, (0,external_wp_element_namespaceObject.createElement)(PatternsExplorer, restProps));
}

/* harmony default export */ var explorer = (PatternsExplorerModal);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inserter/block-patterns-tab.js


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






function BlockPatternsCategory(_ref) {
  let {
    rootClientId,
    onInsert,
    selectedCategory,
    populatedCategories
  } = _ref;
  const [allPatterns,, onClick] = use_patterns_state(onInsert, rootClientId);
  const getPatternIndex = (0,external_wp_element_namespaceObject.useCallback)(pattern => {
    var _pattern$categories;

    if (!((_pattern$categories = pattern.categories) !== null && _pattern$categories !== void 0 && _pattern$categories.length)) {
      return Infinity;
    }

    const indexedCategories = populatedCategories.reduce((accumulator, _ref2, index) => {
      let {
        name
      } = _ref2;
      accumulator[name] = index;
      return accumulator;
    }, {});
    return Math.min(...pattern.categories.map(cat => indexedCategories[cat] !== undefined ? indexedCategories[cat] : Infinity));
  }, [populatedCategories]);
  const currentCategoryPatterns = (0,external_wp_element_namespaceObject.useMemo)(() => allPatterns.filter(pattern => {
    var _pattern$categories2;

    return selectedCategory.name === 'uncategorized' ? getPatternIndex(pattern) === Infinity : (_pattern$categories2 = pattern.categories) === null || _pattern$categories2 === void 0 ? void 0 : _pattern$categories2.includes(selectedCategory.name);
  }), [allPatterns, selectedCategory]); // Ordering the patterns is important for the async rendering.

  const orderedPatterns = (0,external_wp_element_namespaceObject.useMemo)(() => {
    return currentCategoryPatterns.sort((a, b) => {
      return getPatternIndex(a) - getPatternIndex(b);
    });
  }, [currentCategoryPatterns, getPatternIndex]);
  const currentShownPatterns = (0,external_wp_compose_namespaceObject.useAsyncList)(orderedPatterns);

  if (!currentCategoryPatterns.length) {
    return null;
  }

  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-inserter__panel-content"
  }, (0,external_wp_element_namespaceObject.createElement)(block_patterns_list, {
    shownPatterns: currentShownPatterns,
    blockPatterns: currentCategoryPatterns,
    onClickPattern: onClick,
    label: selectedCategory.label,
    orientation: "vertical",
    isDraggable: true
  }));
}

function BlockPatternsTabs(_ref3) {
  let {
    rootClientId,
    onInsert,
    onClickCategory,
    selectedCategory
  } = _ref3;
  const [showPatternsExplorer, setShowPatternsExplorer] = (0,external_wp_element_namespaceObject.useState)(false);
  const [allPatterns, allCategories] = use_patterns_state();
  const hasRegisteredCategory = (0,external_wp_element_namespaceObject.useCallback)(pattern => {
    if (!pattern.categories || !pattern.categories.length) {
      return false;
    }

    return pattern.categories.some(cat => allCategories.some(category => category.name === cat));
  }, [allCategories]); // Remove any empty categories.

  const populatedCategories = (0,external_wp_element_namespaceObject.useMemo)(() => {
    const categories = allCategories.filter(category => allPatterns.some(pattern => {
      var _pattern$categories3;

      return (_pattern$categories3 = pattern.categories) === null || _pattern$categories3 === void 0 ? void 0 : _pattern$categories3.includes(category.name);
    })).sort((_ref4, _ref5) => {
      let {
        name: currentName
      } = _ref4;
      let {
        name: nextName
      } = _ref5;

      if (![currentName, nextName].includes('featured')) {
        return 0;
      }

      return currentName === 'featured' ? -1 : 1;
    });

    if (allPatterns.some(pattern => !hasRegisteredCategory(pattern)) && !categories.find(category => category.name === 'uncategorized')) {
      categories.push({
        name: 'uncategorized',
        label: (0,external_wp_i18n_namespaceObject._x)('Uncategorized')
      });
    }

    return categories;
  }, [allPatterns, allCategories]);
  const patternCategory = selectedCategory ? selectedCategory : populatedCategories[0];
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(pattern_panel, {
    selectedCategory: patternCategory,
    patternCategories: populatedCategories,
    onClickCategory: onClickCategory,
    openPatternExplorer: () => setShowPatternsExplorer(true)
  }), !showPatternsExplorer && (0,external_wp_element_namespaceObject.createElement)(BlockPatternsCategory, {
    rootClientId: rootClientId,
    onInsert: onInsert,
    selectedCategory: patternCategory,
    populatedCategories: populatedCategories
  }), showPatternsExplorer && (0,external_wp_element_namespaceObject.createElement)(explorer, {
    initialCategory: patternCategory,
    patternCategories: populatedCategories,
    onModalClose: () => setShowPatternsExplorer(false)
  }));
}

/* harmony default export */ var block_patterns_tab = (BlockPatternsTabs);

;// CONCATENATED MODULE: external ["wp","url"]
var external_wp_url_namespaceObject = window["wp"]["url"];
;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inserter/reusable-blocks-tab.js


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






function ReusableBlocksList(_ref) {
  let {
    onHover,
    onInsert,
    rootClientId
  } = _ref;
  const [items,,, onSelectItem] = use_block_types_state(rootClientId, onInsert);
  const filteredItems = (0,external_wp_element_namespaceObject.useMemo)(() => {
    return items.filter(_ref2 => {
      let {
        category
      } = _ref2;
      return category === 'reusable';
    });
  }, [items]);

  if (filteredItems.length === 0) {
    return (0,external_wp_element_namespaceObject.createElement)(no_results, null);
  }

  return (0,external_wp_element_namespaceObject.createElement)(panel, {
    title: (0,external_wp_i18n_namespaceObject.__)('Reusable blocks')
  }, (0,external_wp_element_namespaceObject.createElement)(block_types_list, {
    items: filteredItems,
    onSelect: onSelectItem,
    onHover: onHover,
    label: (0,external_wp_i18n_namespaceObject.__)('Reusable blocks')
  }));
} // The unwrapped component is only exported for use by unit tests.

/**
 * List of reusable blocks shown in the "Reusable" tab of the inserter.
 *
 * @param {Object}   props              Component props.
 * @param {?string}  props.rootClientId Client id of block to insert into.
 * @param {Function} props.onInsert     Callback to run when item is inserted.
 * @param {Function} props.onHover      Callback to run when item is hovered.
 *
 * @return {WPComponent} The component.
 */


function ReusableBlocksTab(_ref3) {
  let {
    rootClientId,
    onInsert,
    onHover
  } = _ref3;
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(ReusableBlocksList, {
    onHover: onHover,
    onInsert: onInsert,
    rootClientId: rootClientId
  }), (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-inserter__manage-reusable-blocks-container"
  }, (0,external_wp_element_namespaceObject.createElement)("a", {
    className: "block-editor-inserter__manage-reusable-blocks",
    href: (0,external_wp_url_namespaceObject.addQueryArgs)('edit.php', {
      post_type: 'wp_block'
    })
  }, (0,external_wp_i18n_namespaceObject.__)('Manage Reusable blocks'))));
}
/* harmony default export */ var reusable_blocks_tab = (ReusableBlocksTab);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inserter-menu-extension/index.js
/**
 * WordPress dependencies
 */

const {
  Fill: __unstableInserterMenuExtension,
  Slot
} = (0,external_wp_components_namespaceObject.createSlotFill)('__unstableInserterMenuExtension');
__unstableInserterMenuExtension.Slot = Slot;
/* harmony default export */ var inserter_menu_extension = (__unstableInserterMenuExtension);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inserter/search-results.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */











const search_results_INITIAL_INSERTER_RESULTS = 9;
/**
 * Shared reference to an empty array for cases where it is important to avoid
 * returning a new array reference on every invocation and rerendering the component.
 *
 * @type {Array}
 */

const search_results_EMPTY_ARRAY = [];

function InserterSearchResults(_ref) {
  let {
    filterValue,
    onSelect,
    onHover,
    rootClientId,
    clientId,
    isAppender,
    __experimentalInsertionIndex,
    maxBlockPatterns,
    maxBlockTypes,
    showBlockDirectory = false,
    isDraggable = true,
    shouldFocusBlock = true,
    prioritizePatterns
  } = _ref;
  const debouncedSpeak = (0,external_wp_compose_namespaceObject.useDebounce)(external_wp_a11y_namespaceObject.speak, 500);
  const [destinationRootClientId, onInsertBlocks] = use_insertion_point({
    onSelect,
    rootClientId,
    clientId,
    isAppender,
    insertionIndex: __experimentalInsertionIndex,
    shouldFocusBlock
  });
  const [blockTypes, blockTypeCategories, blockTypeCollections, onSelectBlockType] = use_block_types_state(destinationRootClientId, onInsertBlocks);
  const [patterns,, onSelectBlockPattern] = use_patterns_state(onInsertBlocks, destinationRootClientId);
  const filteredBlockPatterns = (0,external_wp_element_namespaceObject.useMemo)(() => {
    if (maxBlockPatterns === 0) {
      return [];
    }

    const results = searchItems(patterns, filterValue);
    return maxBlockPatterns !== undefined ? results.slice(0, maxBlockPatterns) : results;
  }, [filterValue, patterns, maxBlockPatterns]);
  let maxBlockTypesToShow = maxBlockTypes;

  if (prioritizePatterns && filteredBlockPatterns.length > 2) {
    maxBlockTypesToShow = 0;
  }

  const filteredBlockTypes = (0,external_wp_element_namespaceObject.useMemo)(() => {
    if (maxBlockTypesToShow === 0) {
      return [];
    }

    const results = searchBlockItems((0,external_lodash_namespaceObject.orderBy)(blockTypes, ['frecency'], ['desc']), blockTypeCategories, blockTypeCollections, filterValue);
    return maxBlockTypesToShow !== undefined ? results.slice(0, maxBlockTypesToShow) : results;
  }, [filterValue, blockTypes, blockTypeCategories, blockTypeCollections, maxBlockTypes]); // Announce search results on change.

  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (!filterValue) {
      return;
    }

    const count = filteredBlockTypes.length + filteredBlockPatterns.length;
    const resultsFoundMessage = (0,external_wp_i18n_namespaceObject.sprintf)(
    /* translators: %d: number of results. */
    (0,external_wp_i18n_namespaceObject._n)('%d result found.', '%d results found.', count), count);
    debouncedSpeak(resultsFoundMessage);
  }, [filterValue, debouncedSpeak]);
  const currentShownBlockTypes = (0,external_wp_compose_namespaceObject.useAsyncList)(filteredBlockTypes, {
    step: search_results_INITIAL_INSERTER_RESULTS
  });
  const currentShownPatterns = (0,external_wp_compose_namespaceObject.useAsyncList)(currentShownBlockTypes.length === filteredBlockTypes.length ? filteredBlockPatterns : search_results_EMPTY_ARRAY);
  const hasItems = !(0,external_lodash_namespaceObject.isEmpty)(filteredBlockTypes) || !(0,external_lodash_namespaceObject.isEmpty)(filteredBlockPatterns);
  const blocksUI = !!filteredBlockTypes.length && (0,external_wp_element_namespaceObject.createElement)(panel, {
    title: (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.VisuallyHidden, null, (0,external_wp_i18n_namespaceObject.__)('Blocks'))
  }, (0,external_wp_element_namespaceObject.createElement)(block_types_list, {
    items: currentShownBlockTypes,
    onSelect: onSelectBlockType,
    onHover: onHover,
    label: (0,external_wp_i18n_namespaceObject.__)('Blocks'),
    isDraggable: isDraggable
  }));
  const patternsUI = !!filteredBlockPatterns.length && (0,external_wp_element_namespaceObject.createElement)(panel, {
    title: (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.VisuallyHidden, null, (0,external_wp_i18n_namespaceObject.__)('Block Patterns'))
  }, (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-inserter__quick-inserter-patterns"
  }, (0,external_wp_element_namespaceObject.createElement)(block_patterns_list, {
    shownPatterns: currentShownPatterns,
    blockPatterns: filteredBlockPatterns,
    onClickPattern: onSelectBlockPattern,
    isDraggable: isDraggable
  })));
  return (0,external_wp_element_namespaceObject.createElement)(inserter_listbox, null, !showBlockDirectory && !hasItems && (0,external_wp_element_namespaceObject.createElement)(no_results, null), prioritizePatterns ? patternsUI : blocksUI, !!filteredBlockTypes.length && !!filteredBlockPatterns.length && (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-inserter__quick-inserter-separator"
  }), prioritizePatterns ? blocksUI : patternsUI, showBlockDirectory && (0,external_wp_element_namespaceObject.createElement)(inserter_menu_extension.Slot, {
    fillProps: {
      onSelect: onSelectBlockType,
      onHover,
      filterValue,
      hasItems,
      rootClientId: destinationRootClientId
    }
  }, fills => {
    if (fills.length) {
      return fills;
    }

    if (!hasItems) {
      return (0,external_wp_element_namespaceObject.createElement)(no_results, null);
    }

    return null;
  }));
}

/* harmony default export */ var search_results = (InserterSearchResults);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inserter/tabs.js


/**
 * WordPress dependencies
 */



const blocksTab = {
  name: 'blocks',

  /* translators: Blocks tab title in the block inserter. */
  title: (0,external_wp_i18n_namespaceObject.__)('Blocks')
};
const patternsTab = {
  name: 'patterns',

  /* translators: Patterns tab title in the block inserter. */
  title: (0,external_wp_i18n_namespaceObject.__)('Patterns')
};
const reusableBlocksTab = {
  name: 'reusable',

  /* translators: Reusable blocks tab title in the block inserter. */
  title: (0,external_wp_i18n_namespaceObject.__)('Reusable')
};

function InserterTabs(_ref) {
  let {
    children,
    showPatterns = false,
    showReusableBlocks = false,
    onSelect
  } = _ref;
  const tabs = (0,external_wp_element_namespaceObject.useMemo)(() => {
    const tempTabs = [blocksTab];

    if (showPatterns) {
      tempTabs.push(patternsTab);
    }

    if (showReusableBlocks) {
      tempTabs.push(reusableBlocksTab);
    }

    return tempTabs;
  }, [blocksTab, showPatterns, patternsTab, showReusableBlocks, reusableBlocksTab]);
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.TabPanel, {
    className: "block-editor-inserter__tabs",
    tabs: tabs,
    onSelect: onSelect
  }, children);
}

/* harmony default export */ var tabs = (InserterTabs);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inserter/menu.js


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */











function InserterMenu(_ref, ref) {
  let {
    rootClientId,
    clientId,
    isAppender,
    __experimentalInsertionIndex,
    onSelect,
    showInserterHelpPanel,
    showMostUsedBlocks,
    __experimentalFilterValue = '',
    shouldFocusBlock = true
  } = _ref;
  const [filterValue, setFilterValue] = (0,external_wp_element_namespaceObject.useState)(__experimentalFilterValue);
  const [hoveredItem, setHoveredItem] = (0,external_wp_element_namespaceObject.useState)(null);
  const [selectedPatternCategory, setSelectedPatternCategory] = (0,external_wp_element_namespaceObject.useState)(null);
  const [destinationRootClientId, onInsertBlocks, onToggleInsertionPoint] = use_insertion_point({
    rootClientId,
    clientId,
    isAppender,
    insertionIndex: __experimentalInsertionIndex,
    shouldFocusBlock
  });
  const {
    showPatterns,
    hasReusableBlocks
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    var _getSettings$__experi;

    const {
      __experimentalGetAllowedPatterns,
      getSettings
    } = select(store);
    return {
      showPatterns: !!__experimentalGetAllowedPatterns(destinationRootClientId).length,
      hasReusableBlocks: !!((_getSettings$__experi = getSettings().__experimentalReusableBlocks) !== null && _getSettings$__experi !== void 0 && _getSettings$__experi.length)
    };
  }, [destinationRootClientId]);
  const onInsert = (0,external_wp_element_namespaceObject.useCallback)((blocks, meta, shouldForceFocusBlock) => {
    onInsertBlocks(blocks, meta, shouldForceFocusBlock);
    onSelect();
  }, [onInsertBlocks, onSelect]);
  const onInsertPattern = (0,external_wp_element_namespaceObject.useCallback)((blocks, patternName) => {
    onInsertBlocks(blocks, {
      patternName
    });
    onSelect();
  }, [onInsertBlocks, onSelect]);
  const onHover = (0,external_wp_element_namespaceObject.useCallback)(item => {
    onToggleInsertionPoint(!!item);
    setHoveredItem(item);
  }, [onToggleInsertionPoint, setHoveredItem]);
  const onClickPatternCategory = (0,external_wp_element_namespaceObject.useCallback)(patternCategory => {
    setSelectedPatternCategory(patternCategory);
  }, [setSelectedPatternCategory]);
  const blocksTab = (0,external_wp_element_namespaceObject.useMemo)(() => (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-inserter__block-list"
  }, (0,external_wp_element_namespaceObject.createElement)(block_types_tab, {
    rootClientId: destinationRootClientId,
    onInsert: onInsert,
    onHover: onHover,
    showMostUsedBlocks: showMostUsedBlocks
  })), showInserterHelpPanel && (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-inserter__tips"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.VisuallyHidden, {
    as: "h2"
  }, (0,external_wp_i18n_namespaceObject.__)('A tip for using the block editor')), (0,external_wp_element_namespaceObject.createElement)(tips, null))), [destinationRootClientId, onInsert, onHover, filterValue, showMostUsedBlocks, showInserterHelpPanel]);
  const patternsTab = (0,external_wp_element_namespaceObject.useMemo)(() => (0,external_wp_element_namespaceObject.createElement)(block_patterns_tab, {
    rootClientId: destinationRootClientId,
    onInsert: onInsertPattern,
    onClickCategory: onClickPatternCategory,
    selectedCategory: selectedPatternCategory
  }), [destinationRootClientId, onInsertPattern, onClickPatternCategory, selectedPatternCategory]);
  const reusableBlocksTab = (0,external_wp_element_namespaceObject.useMemo)(() => (0,external_wp_element_namespaceObject.createElement)(reusable_blocks_tab, {
    rootClientId: destinationRootClientId,
    onInsert: onInsert,
    onHover: onHover
  }), [destinationRootClientId, onInsert, onHover]);
  const getCurrentTab = (0,external_wp_element_namespaceObject.useCallback)(tab => {
    if (tab.name === 'blocks') {
      return blocksTab;
    } else if (tab.name === 'patterns') {
      return patternsTab;
    }

    return reusableBlocksTab;
  }, [blocksTab, patternsTab, reusableBlocksTab]);
  const searchRef = (0,external_wp_element_namespaceObject.useRef)();
  (0,external_wp_element_namespaceObject.useImperativeHandle)(ref, () => ({
    focusSearch: () => {
      searchRef.current.focus();
    }
  }));
  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-inserter__menu"
  }, (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-inserter__main-area"
  }, (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-inserter__content"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SearchControl, {
    className: "block-editor-inserter__search",
    onChange: value => {
      if (hoveredItem) setHoveredItem(null);
      setFilterValue(value);
    },
    value: filterValue,
    label: (0,external_wp_i18n_namespaceObject.__)('Search for blocks and patterns'),
    placeholder: (0,external_wp_i18n_namespaceObject.__)('Search'),
    ref: searchRef
  }), !!filterValue && (0,external_wp_element_namespaceObject.createElement)(search_results, {
    filterValue: filterValue,
    onSelect: onSelect,
    onHover: onHover,
    rootClientId: rootClientId,
    clientId: clientId,
    isAppender: isAppender,
    __experimentalInsertionIndex: __experimentalInsertionIndex,
    showBlockDirectory: true,
    shouldFocusBlock: shouldFocusBlock
  }), !filterValue && (showPatterns || hasReusableBlocks) && (0,external_wp_element_namespaceObject.createElement)(tabs, {
    showPatterns: showPatterns,
    showReusableBlocks: hasReusableBlocks
  }, getCurrentTab), !filterValue && !showPatterns && !hasReusableBlocks && blocksTab)), showInserterHelpPanel && hoveredItem && (0,external_wp_element_namespaceObject.createElement)(preview_panel, {
    item: hoveredItem
  }));
}

/* harmony default export */ var menu = ((0,external_wp_element_namespaceObject.forwardRef)(InserterMenu));

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inserter/quick-inserter.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */






const SEARCH_THRESHOLD = 6;
const SHOWN_BLOCK_TYPES = 6;
const SHOWN_BLOCK_PATTERNS = 2;
const SHOWN_BLOCK_PATTERNS_WITH_PRIORITIZATION = 4;
function QuickInserter(_ref) {
  let {
    onSelect,
    rootClientId,
    clientId,
    isAppender
  } = _ref;
  const [filterValue, setFilterValue] = (0,external_wp_element_namespaceObject.useState)('');
  const [destinationRootClientId, onInsertBlocks] = use_insertion_point({
    onSelect,
    rootClientId,
    clientId,
    isAppender
  });
  const [blockTypes] = use_block_types_state(destinationRootClientId, onInsertBlocks);
  const [patterns] = use_patterns_state(onInsertBlocks, destinationRootClientId);
  const {
    setInserterIsOpened,
    insertionIndex,
    prioritizePatterns
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getSettings,
      getBlockIndex,
      getBlockCount
    } = select(store);
    const settings = getSettings();
    const index = getBlockIndex(clientId);
    const blockCount = getBlockCount();
    return {
      setInserterIsOpened: settings.__experimentalSetIsInserterOpened,
      prioritizePatterns: settings.__experimentalPreferPatternsOnRoot && !rootClientId && index > 0 && (index < blockCount || blockCount === 0),
      insertionIndex: index === -1 ? blockCount : index
    };
  }, [clientId, rootClientId]);
  const showPatterns = patterns.length && (!!filterValue || prioritizePatterns);
  const showSearch = showPatterns && patterns.length > SEARCH_THRESHOLD || blockTypes.length > SEARCH_THRESHOLD;
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (setInserterIsOpened) {
      setInserterIsOpened(false);
    }
  }, [setInserterIsOpened]); // When clicking Browse All select the appropriate block so as
  // the insertion point can work as expected.

  const onBrowseAll = () => {
    setInserterIsOpened({
      rootClientId,
      insertionIndex,
      filterValue
    });
  };

  let maxBlockPatterns = 0;

  if (showPatterns) {
    maxBlockPatterns = prioritizePatterns ? SHOWN_BLOCK_PATTERNS_WITH_PRIORITIZATION : SHOWN_BLOCK_PATTERNS;
  }

  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: classnames_default()('block-editor-inserter__quick-inserter', {
      'has-search': showSearch,
      'has-expand': setInserterIsOpened
    })
  }, showSearch && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SearchControl, {
    className: "block-editor-inserter__search",
    value: filterValue,
    onChange: value => {
      setFilterValue(value);
    },
    label: (0,external_wp_i18n_namespaceObject.__)('Search for blocks and patterns'),
    placeholder: (0,external_wp_i18n_namespaceObject.__)('Search')
  }), (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-inserter__quick-inserter-results"
  }, (0,external_wp_element_namespaceObject.createElement)(search_results, {
    filterValue: filterValue,
    onSelect: onSelect,
    rootClientId: rootClientId,
    clientId: clientId,
    isAppender: isAppender,
    maxBlockPatterns: maxBlockPatterns,
    maxBlockTypes: SHOWN_BLOCK_TYPES,
    isDraggable: false,
    prioritizePatterns: prioritizePatterns
  })), setInserterIsOpened && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
    className: "block-editor-inserter__quick-inserter-expand",
    onClick: onBrowseAll,
    "aria-label": (0,external_wp_i18n_namespaceObject.__)('Browse all. This will open the main inserter panel in the editor toolbar.')
  }, (0,external_wp_i18n_namespaceObject.__)('Browse all')));
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inserter/index.js



/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */









/**
 * Internal dependencies
 */





const defaultRenderToggle = _ref => {
  let {
    onToggle,
    disabled,
    isOpen,
    blockTitle,
    hasSingleBlockType,
    toggleProps = {}
  } = _ref;
  let label;

  if (hasSingleBlockType) {
    label = (0,external_wp_i18n_namespaceObject.sprintf)( // translators: %s: the name of the block when there is only one
    (0,external_wp_i18n_namespaceObject._x)('Add %s', 'directly add the only allowed block'), blockTitle);
  } else {
    label = (0,external_wp_i18n_namespaceObject._x)('Add block', 'Generic label for block inserter button');
  }

  const {
    onClick,
    ...rest
  } = toggleProps; // Handle both onClick functions from the toggle and the parent component.

  function handleClick(event) {
    if (onToggle) {
      onToggle(event);
    }

    if (onClick) {
      onClick(event);
    }
  }

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, _extends({
    icon: library_plus,
    label: label,
    tooltipPosition: "bottom",
    onClick: handleClick,
    className: "block-editor-inserter__toggle",
    "aria-haspopup": !hasSingleBlockType ? 'true' : false,
    "aria-expanded": !hasSingleBlockType ? isOpen : false,
    disabled: disabled
  }, rest));
};

class Inserter extends external_wp_element_namespaceObject.Component {
  constructor() {
    super(...arguments);
    this.onToggle = this.onToggle.bind(this);
    this.renderToggle = this.renderToggle.bind(this);
    this.renderContent = this.renderContent.bind(this);
  }

  onToggle(isOpen) {
    const {
      onToggle
    } = this.props; // Surface toggle callback to parent component.

    if (onToggle) {
      onToggle(isOpen);
    }
  }
  /**
   * Render callback to display Dropdown toggle element.
   *
   * @param {Object}   options
   * @param {Function} options.onToggle Callback to invoke when toggle is
   *                                    pressed.
   * @param {boolean}  options.isOpen   Whether dropdown is currently open.
   *
   * @return {WPElement} Dropdown toggle element.
   */


  renderToggle(_ref2) {
    let {
      onToggle,
      isOpen
    } = _ref2;
    const {
      disabled,
      blockTitle,
      hasSingleBlockType,
      directInsertBlock,
      toggleProps,
      hasItems,
      renderToggle = defaultRenderToggle
    } = this.props;
    return renderToggle({
      onToggle,
      isOpen,
      disabled: disabled || !hasItems,
      blockTitle,
      hasSingleBlockType,
      directInsertBlock,
      toggleProps
    });
  }
  /**
   * Render callback to display Dropdown content element.
   *
   * @param {Object}   options
   * @param {Function} options.onClose Callback to invoke when dropdown is
   *                                   closed.
   *
   * @return {WPElement} Dropdown content element.
   */


  renderContent(_ref3) {
    let {
      onClose
    } = _ref3;
    const {
      rootClientId,
      clientId,
      isAppender,
      showInserterHelpPanel,
      // This prop is experimental to give some time for the quick inserter to mature
      // Feel free to make them stable after a few releases.
      __experimentalIsQuick: isQuick
    } = this.props;

    if (isQuick) {
      return (0,external_wp_element_namespaceObject.createElement)(QuickInserter, {
        onSelect: () => {
          onClose();
        },
        rootClientId: rootClientId,
        clientId: clientId,
        isAppender: isAppender
      });
    }

    return (0,external_wp_element_namespaceObject.createElement)(menu, {
      onSelect: () => {
        onClose();
      },
      rootClientId: rootClientId,
      clientId: clientId,
      isAppender: isAppender,
      showInserterHelpPanel: showInserterHelpPanel
    });
  }

  render() {
    const {
      position,
      hasSingleBlockType,
      directInsertBlock,
      insertOnlyAllowedBlock,
      __experimentalIsQuick: isQuick,
      onSelectOrClose
    } = this.props;

    if (hasSingleBlockType || directInsertBlock) {
      return this.renderToggle({
        onToggle: insertOnlyAllowedBlock
      });
    }

    return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Dropdown, {
      className: "block-editor-inserter",
      contentClassName: classnames_default()('block-editor-inserter__popover', {
        'is-quick': isQuick
      }),
      position: position,
      onToggle: this.onToggle,
      expandOnMobile: true,
      headerTitle: (0,external_wp_i18n_namespaceObject.__)('Add a block'),
      renderToggle: this.renderToggle,
      renderContent: this.renderContent,
      onClose: onSelectOrClose
    });
  }

}

/* harmony default export */ var inserter = ((0,external_wp_compose_namespaceObject.compose)([(0,external_wp_data_namespaceObject.withSelect)((select, _ref4) => {
  let {
    clientId,
    rootClientId
  } = _ref4;
  const {
    getBlockRootClientId,
    hasInserterItems,
    __experimentalGetAllowedBlocks,
    __experimentalGetDirectInsertBlock
  } = select(store);
  const {
    getBlockVariations
  } = select(external_wp_blocks_namespaceObject.store);
  rootClientId = rootClientId || getBlockRootClientId(clientId) || undefined;

  const allowedBlocks = __experimentalGetAllowedBlocks(rootClientId);

  const directInsertBlock = __experimentalGetDirectInsertBlock(rootClientId);

  const hasSingleBlockType = (0,external_lodash_namespaceObject.size)(allowedBlocks) === 1 && (0,external_lodash_namespaceObject.size)(getBlockVariations(allowedBlocks[0].name, 'inserter')) === 0;
  let allowedBlockType = false;

  if (hasSingleBlockType) {
    allowedBlockType = allowedBlocks[0];
  }

  return {
    hasItems: hasInserterItems(rootClientId),
    hasSingleBlockType,
    blockTitle: allowedBlockType ? allowedBlockType.title : '',
    allowedBlockType,
    directInsertBlock,
    rootClientId
  };
}), (0,external_wp_data_namespaceObject.withDispatch)((dispatch, ownProps, _ref5) => {
  let {
    select
  } = _ref5;
  return {
    insertOnlyAllowedBlock() {
      const {
        rootClientId,
        clientId,
        isAppender,
        hasSingleBlockType,
        allowedBlockType,
        directInsertBlock,
        onSelectOrClose
      } = ownProps;

      if (!hasSingleBlockType && !directInsertBlock) {
        return;
      }

      function getAdjacentBlockAttributes(attributesToCopy) {
        const {
          getBlock,
          getPreviousBlockClientId
        } = select(store);

        if (!attributesToCopy || !clientId && !rootClientId) {
          return {};
        }

        const result = {};
        let adjacentAttributes = {}; // If there is no clientId, then attempt to get attributes
        // from the last block within innerBlocks of the root block.

        if (!clientId) {
          var _parentBlock$innerBlo;

          const parentBlock = getBlock(rootClientId);

          if (parentBlock !== null && parentBlock !== void 0 && (_parentBlock$innerBlo = parentBlock.innerBlocks) !== null && _parentBlock$innerBlo !== void 0 && _parentBlock$innerBlo.length) {
            const lastInnerBlock = parentBlock.innerBlocks[parentBlock.innerBlocks.length - 1];

            if (directInsertBlock && (directInsertBlock === null || directInsertBlock === void 0 ? void 0 : directInsertBlock.name) === lastInnerBlock.name) {
              adjacentAttributes = lastInnerBlock.attributes;
            }
          }
        } else {
          // Otherwise, attempt to get attributes from the
          // previous block relative to the current clientId.
          const currentBlock = getBlock(clientId);
          const previousBlock = getBlock(getPreviousBlockClientId(clientId));

          if ((currentBlock === null || currentBlock === void 0 ? void 0 : currentBlock.name) === (previousBlock === null || previousBlock === void 0 ? void 0 : previousBlock.name)) {
            adjacentAttributes = (previousBlock === null || previousBlock === void 0 ? void 0 : previousBlock.attributes) || {};
          }
        } // Copy over only those attributes flagged to be copied.


        attributesToCopy.forEach(attribute => {
          if (adjacentAttributes.hasOwnProperty(attribute)) {
            result[attribute] = adjacentAttributes[attribute];
          }
        });
        return result;
      }

      function getInsertionIndex() {
        const {
          getBlockIndex,
          getBlockSelectionEnd,
          getBlockOrder,
          getBlockRootClientId
        } = select(store); // If the clientId is defined, we insert at the position of the block.

        if (clientId) {
          return getBlockIndex(clientId);
        } // If there a selected block, we insert after the selected block.


        const end = getBlockSelectionEnd();

        if (!isAppender && end && getBlockRootClientId(end) === rootClientId) {
          return getBlockIndex(end) + 1;
        } // Otherwise, we insert at the end of the current rootClientId.


        return getBlockOrder(rootClientId).length;
      }

      const {
        insertBlock
      } = dispatch(store);
      let blockToInsert; // Attempt to augment the directInsertBlock with attributes from an adjacent block.
      // This ensures styling from nearby blocks is preserved in the newly inserted block.
      // See: https://github.com/WordPress/gutenberg/issues/37904

      if (directInsertBlock) {
        const newAttributes = getAdjacentBlockAttributes(directInsertBlock.attributesToCopy);
        blockToInsert = (0,external_wp_blocks_namespaceObject.createBlock)(directInsertBlock.name, { ...(directInsertBlock.attributes || {}),
          ...newAttributes
        });
      } else {
        blockToInsert = (0,external_wp_blocks_namespaceObject.createBlock)(allowedBlockType.name);
      }

      insertBlock(blockToInsert, getInsertionIndex(), rootClientId);

      if (onSelectOrClose) {
        onSelectOrClose();
      }

      const message = (0,external_wp_i18n_namespaceObject.sprintf)( // translators: %s: the name of the block that has been added
      (0,external_wp_i18n_namespaceObject.__)('%s block added'), allowedBlockType.title);
      (0,external_wp_a11y_namespaceObject.speak)(message);
    }

  };
}), // The global inserter should always be visible, we are using ( ! isAppender && ! rootClientId && ! clientId ) as
// a way to detect the global Inserter.
(0,external_wp_compose_namespaceObject.ifCondition)(_ref6 => {
  let {
    hasItems,
    isAppender,
    rootClientId,
    clientId
  } = _ref6;
  return hasItems || !isAppender && !rootClientId && !clientId;
})])(Inserter));

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/default-block-appender/index.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */



/**
 * Zero width non-breaking space, used as padding for the paragraph when it is
 * empty.
 */

const ZWNBSP = '\ufeff';
function DefaultBlockAppender(_ref) {
  let {
    isLocked,
    onAppend,
    showPrompt,
    placeholder,
    rootClientId
  } = _ref;

  if (isLocked) {
    return null;
  }

  const value = (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(placeholder) || (0,external_wp_i18n_namespaceObject.__)('Type / to choose a block');

  return (0,external_wp_element_namespaceObject.createElement)("div", {
    "data-root-client-id": rootClientId || '',
    className: classnames_default()('block-editor-default-block-appender', {
      'has-visible-prompt': showPrompt
    })
  }, (0,external_wp_element_namespaceObject.createElement)("p", {
    tabIndex: "0" // We want this element to be styled as a paragraph by themes.
    // eslint-disable-next-line jsx-a11y/no-noninteractive-element-to-interactive-role
    ,
    role: "button",
    "aria-label": (0,external_wp_i18n_namespaceObject.__)('Add default block') // A wrapping container for this one already has the wp-block className.
    ,
    className: "block-editor-default-block-appender__content",
    onKeyDown: event => {
      if (external_wp_keycodes_namespaceObject.ENTER === event.keyCode || external_wp_keycodes_namespaceObject.SPACE === event.keyCode) {
        onAppend();
      }
    },
    onClick: () => onAppend(),
    onFocus: () => {
      if (showPrompt) {
        onAppend();
      }
    }
  }, showPrompt ? value : ZWNBSP), (0,external_wp_element_namespaceObject.createElement)(inserter, {
    rootClientId: rootClientId,
    position: "bottom right",
    isAppender: true,
    __experimentalIsQuick: true
  }));
}
/* harmony default export */ var default_block_appender = ((0,external_wp_compose_namespaceObject.compose)((0,external_wp_data_namespaceObject.withSelect)((select, ownProps) => {
  const {
    getBlockCount,
    getSettings,
    getTemplateLock
  } = select(store);
  const isEmpty = !getBlockCount(ownProps.rootClientId);
  const {
    bodyPlaceholder
  } = getSettings();
  return {
    showPrompt: isEmpty,
    isLocked: !!getTemplateLock(ownProps.rootClientId),
    placeholder: bodyPlaceholder
  };
}), (0,external_wp_data_namespaceObject.withDispatch)((dispatch, ownProps) => {
  const {
    insertDefaultBlock,
    startTyping
  } = dispatch(store);
  return {
    onAppend() {
      const {
        rootClientId
      } = ownProps;
      insertDefaultBlock(undefined, rootClientId);
      startTyping();
    }

  };
}))(DefaultBlockAppender));

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/button-block-appender/index.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */



function ButtonBlockAppender(_ref, ref) {
  let {
    rootClientId,
    className,
    onFocus,
    tabIndex
  } = _ref;
  return (0,external_wp_element_namespaceObject.createElement)(inserter, {
    position: "bottom center",
    rootClientId: rootClientId,
    __experimentalIsQuick: true,
    renderToggle: _ref2 => {
      let {
        onToggle,
        disabled,
        isOpen,
        blockTitle,
        hasSingleBlockType
      } = _ref2;
      let label;

      if (hasSingleBlockType) {
        label = (0,external_wp_i18n_namespaceObject.sprintf)( // translators: %s: the name of the block when there is only one
        (0,external_wp_i18n_namespaceObject._x)('Add %s', 'directly add the only allowed block'), blockTitle);
      } else {
        label = (0,external_wp_i18n_namespaceObject._x)('Add block', 'Generic label for block inserter button');
      }

      const isToggleButton = !hasSingleBlockType;
      let inserterButton = (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
        ref: ref,
        onFocus: onFocus,
        tabIndex: tabIndex,
        className: classnames_default()(className, 'block-editor-button-block-appender'),
        onClick: onToggle,
        "aria-haspopup": isToggleButton ? 'true' : undefined,
        "aria-expanded": isToggleButton ? isOpen : undefined,
        disabled: disabled,
        label: label
      }, !hasSingleBlockType && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.VisuallyHidden, {
        as: "span"
      }, label), (0,external_wp_element_namespaceObject.createElement)(build_module_icon, {
        icon: library_plus
      }));

      if (isToggleButton || hasSingleBlockType) {
        inserterButton = (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Tooltip, {
          text: label
        }, inserterButton);
      }

      return inserterButton;
    },
    isAppender: true
  });
}
/**
 * Use `ButtonBlockAppender` instead.
 *
 * @deprecated
 */


const ButtonBlockerAppender = (0,external_wp_element_namespaceObject.forwardRef)((props, ref) => {
  external_wp_deprecated_default()(`wp.blockEditor.ButtonBlockerAppender`, {
    alternative: 'wp.blockEditor.ButtonBlockAppender',
    since: '5.9'
  });
  return ButtonBlockAppender(props, ref);
});
/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/button-block-appender/README.md
 */

/* harmony default export */ var button_block_appender = ((0,external_wp_element_namespaceObject.forwardRef)(ButtonBlockAppender));

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-list-appender/index.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */





function BlockListAppender(_ref) {
  let {
    rootClientId,
    canInsertDefaultBlock,
    isLocked,
    renderAppender: CustomAppender,
    className,
    selectedBlockClientId,
    tagName: TagName = 'div'
  } = _ref;

  if (isLocked || CustomAppender === false) {
    return null;
  }

  let appender;

  if (CustomAppender) {
    // Prefer custom render prop if provided.
    appender = (0,external_wp_element_namespaceObject.createElement)(CustomAppender, null);
  } else {
    const isParentSelected = selectedBlockClientId === rootClientId || !rootClientId && !selectedBlockClientId;

    if (!isParentSelected) {
      return null;
    }

    if (canInsertDefaultBlock) {
      // Render the default block appender when renderAppender has not been
      // provided and the context supports use of the default appender.
      appender = (0,external_wp_element_namespaceObject.createElement)(default_block_appender, {
        rootClientId: rootClientId
      });
    } else {
      // Fallback in the case no renderAppender has been provided and the
      // default block can't be inserted.
      appender = (0,external_wp_element_namespaceObject.createElement)(button_block_appender, {
        rootClientId: rootClientId,
        className: "block-list-appender__toggle"
      });
    }
  }

  return (0,external_wp_element_namespaceObject.createElement)(TagName // A `tabIndex` is used on the wrapping `div` element in order to
  // force a focus event to occur when an appender `button` element
  // is clicked. In some browsers (Firefox, Safari), button clicks do
  // not emit a focus event, which could cause this event to propagate
  // unexpectedly. The `tabIndex` ensures that the interaction is
  // captured as a focus, without also adding an extra tab stop.
  //
  // See: https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button#Clicking_and_focus
  , {
    tabIndex: -1,
    className: classnames_default()('block-list-appender wp-block', className) // The appender exists to let you add the first Paragraph before
    // any is inserted. To that end, this appender should visually be
    // presented as a block. That means theme CSS should style it as if
    // it were an empty paragraph block. That means a `wp-block` class to
    // ensure the width is correct, and a [data-block] attribute to ensure
    // the correct margin is applied, especially for classic themes which
    // have commonly targeted that attribute for margins.
    ,
    "data-block": true
  }, appender);
}

/* harmony default export */ var block_list_appender = ((0,external_wp_data_namespaceObject.withSelect)((select, _ref2) => {
  let {
    rootClientId
  } = _ref2;
  const {
    canInsertBlockType,
    getTemplateLock,
    getSelectedBlockClientId
  } = select(store);
  return {
    isLocked: !!getTemplateLock(rootClientId),
    canInsertDefaultBlock: canInsertBlockType((0,external_wp_blocks_namespaceObject.getDefaultBlockName)(), rootClientId),
    selectedBlockClientId: getSelectedBlockClientId()
  };
})(BlockListAppender));

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-tools/use-popover-scroll.js
/**
 * WordPress dependencies
 */

/**
 * Allow scrolling "through" popovers over the canvas. This is only called for
 * as long as the pointer is over a popover. Do not use React events because it
 * will bubble through portals.
 *
 * @param {Object} scrollableRef
 */

function usePopoverScroll(scrollableRef) {
  return (0,external_wp_compose_namespaceObject.useRefEffect)(node => {
    if (!scrollableRef) {
      return;
    }

    function onWheel(event) {
      const {
        deltaX,
        deltaY
      } = event;
      scrollableRef.current.scrollBy(deltaX, deltaY);
    } // Tell the browser that we do not call event.preventDefault
    // See https://developer.mozilla.org/en-US/docs/Web/API/EventTarget/addEventListener#improving_scrolling_performance_with_passive_listeners


    const options = {
      passive: true
    };
    node.addEventListener('wheel', onWheel, options);
    return () => {
      node.removeEventListener('wheel', onWheel, options);
    };
  }, [scrollableRef]);
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-tools/insertion-point.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */





const InsertionPointOpenRef = (0,external_wp_element_namespaceObject.createContext)();

function InsertionPointPopover(_ref) {
  let {
    __unstablePopoverSlot,
    __unstableContentRef
  } = _ref;
  const {
    selectBlock,
    hideInsertionPoint
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const openRef = (0,external_wp_element_namespaceObject.useContext)(InsertionPointOpenRef);
  const ref = (0,external_wp_element_namespaceObject.useRef)();
  const {
    orientation,
    previousClientId,
    nextClientId,
    rootClientId,
    isInserterShown
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    var _getBlockListSettings;

    const {
      getBlockOrder,
      getBlockListSettings,
      getBlockInsertionPoint,
      isBlockBeingDragged,
      getPreviousBlockClientId,
      getNextBlockClientId
    } = select(store);
    const insertionPoint = getBlockInsertionPoint();
    const order = getBlockOrder(insertionPoint.rootClientId);

    if (!order.length) {
      return {};
    }

    let _previousClientId = order[insertionPoint.index - 1];
    let _nextClientId = order[insertionPoint.index];

    while (isBlockBeingDragged(_previousClientId)) {
      _previousClientId = getPreviousBlockClientId(_previousClientId);
    }

    while (isBlockBeingDragged(_nextClientId)) {
      _nextClientId = getNextBlockClientId(_nextClientId);
    }

    return {
      previousClientId: _previousClientId,
      nextClientId: _nextClientId,
      orientation: ((_getBlockListSettings = getBlockListSettings(insertionPoint.rootClientId)) === null || _getBlockListSettings === void 0 ? void 0 : _getBlockListSettings.orientation) || 'vertical',
      rootClientId: insertionPoint.rootClientId,
      isInserterShown: insertionPoint === null || insertionPoint === void 0 ? void 0 : insertionPoint.__unstableWithInserter
    };
  }, []);
  const previousElement = useBlockElement(previousClientId);
  const nextElement = useBlockElement(nextClientId);
  const isVertical = orientation === 'vertical';
  const style = (0,external_wp_element_namespaceObject.useMemo)(() => {
    if (!previousElement && !nextElement) {
      return {};
    }

    const previousRect = previousElement ? previousElement.getBoundingClientRect() : null;
    const nextRect = nextElement ? nextElement.getBoundingClientRect() : null;

    if (isVertical) {
      return {
        width: previousElement ? previousElement.offsetWidth : nextElement.offsetWidth,
        height: nextRect && previousRect ? nextRect.top - previousRect.bottom : 0
      };
    }

    let width = 0;

    if (previousRect && nextRect) {
      width = (0,external_wp_i18n_namespaceObject.isRTL)() ? previousRect.left - nextRect.right : nextRect.left - previousRect.right;
    }

    return {
      width,
      height: previousElement ? previousElement.offsetHeight : nextElement.offsetHeight
    };
  }, [previousElement, nextElement]);
  const getAnchorRect = (0,external_wp_element_namespaceObject.useCallback)(() => {
    if (!previousElement && !nextElement) {
      return {};
    }

    const {
      ownerDocument
    } = previousElement || nextElement;
    const previousRect = previousElement ? previousElement.getBoundingClientRect() : null;
    const nextRect = nextElement ? nextElement.getBoundingClientRect() : null;

    if (isVertical) {
      if ((0,external_wp_i18n_namespaceObject.isRTL)()) {
        return {
          top: previousRect ? previousRect.bottom : nextRect.top,
          left: previousRect ? previousRect.right : nextRect.right,
          right: previousRect ? previousRect.left : nextRect.left,
          bottom: nextRect ? nextRect.top : previousRect.bottom,
          ownerDocument
        };
      }

      return {
        top: previousRect ? previousRect.bottom : nextRect.top,
        left: previousRect ? previousRect.left : nextRect.left,
        right: previousRect ? previousRect.right : nextRect.right,
        bottom: nextRect ? nextRect.top : previousRect.bottom,
        ownerDocument
      };
    }

    if ((0,external_wp_i18n_namespaceObject.isRTL)()) {
      return {
        top: previousRect ? previousRect.top : nextRect.top,
        left: previousRect ? previousRect.left : nextRect.right,
        right: nextRect ? nextRect.right : previousRect.left,
        bottom: previousRect ? previousRect.bottom : nextRect.bottom,
        ownerDocument
      };
    }

    return {
      top: previousRect ? previousRect.top : nextRect.top,
      left: previousRect ? previousRect.right : nextRect.left,
      right: nextRect ? nextRect.left : previousRect.right,
      bottom: previousRect ? previousRect.bottom : nextRect.bottom,
      ownerDocument
    };
  }, [previousElement, nextElement]);
  const popoverScrollRef = usePopoverScroll(__unstableContentRef);
  const disableMotion = (0,external_wp_compose_namespaceObject.useReducedMotion)();
  const className = classnames_default()('block-editor-block-list__insertion-point', 'is-' + orientation);

  function onClick(event) {
    if (event.target === ref.current && nextClientId) {
      selectBlock(nextClientId, -1);
    }
  }

  function onFocus(event) {
    // Only handle click on the wrapper specifically, and not an event
    // bubbled from the inserter itself.
    if (event.target !== ref.current) {
      openRef.current = true;
    }
  }

  function maybeHideInserterPoint(event) {
    // Only hide the inserter if it's triggered on the wrapper,
    // and the inserter is not open.
    if (event.target === ref.current && !openRef.current) {
      hideInsertionPoint();
    }
  } // Only show the in-between inserter between blocks, so when there's a
  // previous and a next element.


  const showInsertionPointInserter = previousElement && nextElement && isInserterShown; // Define animation variants for the line element.

  const horizontalLine = {
    start: {
      width: 0,
      top: '50%',
      bottom: '50%',
      x: 0
    },
    rest: {
      width: 4,
      top: 0,
      bottom: 0,
      x: -2
    },
    hover: {
      width: 4,
      top: 0,
      bottom: 0,
      x: -2
    }
  };
  const verticalLine = {
    start: {
      height: 0,
      left: '50%',
      right: '50%',
      y: 0
    },
    rest: {
      height: 4,
      left: 0,
      right: 0,
      y: -2
    },
    hover: {
      height: 4,
      left: 0,
      right: 0,
      y: -2
    }
  };
  const lineVariants = {
    // Initial position starts from the center and invisible.
    start: { ...(!isVertical ? horizontalLine.start : verticalLine.start),
      opacity: 0
    },
    // The line expands to fill the container. If the inserter is visible it
    // is delayed so it appears orchestrated.
    rest: { ...(!isVertical ? horizontalLine.rest : verticalLine.rest),
      opacity: 1,
      borderRadius: '2px',
      transition: {
        delay: showInsertionPointInserter ? 0.4 : 0
      }
    },
    hover: { ...(!isVertical ? horizontalLine.hover : verticalLine.hover),
      opacity: 1,
      borderRadius: '2px',
      transition: {
        delay: 0.4
      }
    }
  };
  const inserterVariants = {
    start: {
      scale: disableMotion ? 1 : 0
    },
    rest: {
      scale: 1,
      transition: {
        delay: 0.2
      }
    }
  };
  /* eslint-disable jsx-a11y/no-static-element-interactions, jsx-a11y/click-events-have-key-events */
  // While ideally it would be enough to capture the
  // bubbling focus event from the Inserter, due to the
  // characteristics of click focusing of `button`s in
  // Firefox and Safari, it is not reliable.
  //
  // See: https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button#Clicking_and_focus

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Popover, {
    ref: popoverScrollRef,
    noArrow: true,
    animate: false,
    getAnchorRect: getAnchorRect,
    focusOnMount: false,
    className: "block-editor-block-list__insertion-point-popover" // Render in the old slot if needed for backward compatibility,
    // otherwise render in place (not in the the default popover slot).
    ,
    __unstableSlotName: __unstablePopoverSlot || null // Forces a remount of the popover when its position changes
    // This makes sure the popover doesn't animate from its previous position.
    ,
    key: nextClientId + '--' + rootClientId
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__unstableMotion.div, {
    layout: !disableMotion,
    initial: disableMotion ? 'rest' : 'start',
    animate: "rest",
    whileHover: "hover",
    whileTap: "pressed",
    exit: "start",
    ref: ref,
    tabIndex: -1,
    onClick: onClick,
    onFocus: onFocus,
    className: classnames_default()(className, {
      'is-with-inserter': showInsertionPointInserter
    }),
    onHoverEnd: maybeHideInserterPoint,
    style: style
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__unstableMotion.div, {
    variants: lineVariants,
    className: "block-editor-block-list__insertion-point-indicator"
  }), showInsertionPointInserter && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__unstableMotion.div, {
    variants: inserterVariants,
    className: classnames_default()('block-editor-block-list__insertion-point-inserter')
  }, (0,external_wp_element_namespaceObject.createElement)(inserter, {
    position: "bottom center",
    clientId: nextClientId,
    rootClientId: rootClientId,
    __experimentalIsQuick: true,
    onToggle: isOpen => {
      openRef.current = isOpen;
    },
    onSelectOrClose: () => {
      openRef.current = false;
    }
  }))));
  /* eslint-enable jsx-a11y/no-static-element-interactions, jsx-a11y/click-events-have-key-events */
}

function InsertionPoint(_ref2) {
  let {
    children,
    __unstablePopoverSlot,
    __unstableContentRef
  } = _ref2;
  const isVisible = (0,external_wp_data_namespaceObject.useSelect)(select => {
    return select(store).isBlockInsertionPointVisible();
  }, []);
  return (0,external_wp_element_namespaceObject.createElement)(InsertionPointOpenRef.Provider, {
    value: (0,external_wp_element_namespaceObject.useRef)(false)
  }, isVisible && (0,external_wp_element_namespaceObject.createElement)(InsertionPointPopover, {
    __unstablePopoverSlot: __unstablePopoverSlot,
    __unstableContentRef: __unstableContentRef
  }), children);
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-list/use-in-between-inserter.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



function useInBetweenInserter() {
  const openRef = (0,external_wp_element_namespaceObject.useContext)(InsertionPointOpenRef);
  const hasReducedUI = (0,external_wp_data_namespaceObject.useSelect)(select => select(store).getSettings().hasReducedUI, []);
  const {
    getBlockListSettings,
    getBlockRootClientId,
    getBlockIndex,
    isBlockInsertionPointVisible,
    isMultiSelecting,
    getSelectedBlockClientIds,
    getTemplateLock
  } = (0,external_wp_data_namespaceObject.useSelect)(store);
  const {
    showInsertionPoint,
    hideInsertionPoint
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  return (0,external_wp_compose_namespaceObject.useRefEffect)(node => {
    if (hasReducedUI) {
      return;
    }

    function onMouseMove(event) {
      var _getBlockListSettings, _element$parentElemen;

      if (openRef.current) {
        return;
      }

      if (isMultiSelecting()) {
        return;
      }

      if (!event.target.classList.contains('block-editor-block-list__layout')) {
        if (isBlockInsertionPointVisible()) {
          hideInsertionPoint();
        }

        return;
      }

      let rootClientId;

      if (!event.target.classList.contains('is-root-container')) {
        const blockElement = !!event.target.getAttribute('data-block') ? event.target : event.target.closest('[data-block]');
        rootClientId = blockElement.getAttribute('data-block');
      } // Don't set the insertion point if the template is locked.


      if (getTemplateLock(rootClientId)) {
        return;
      }

      const orientation = ((_getBlockListSettings = getBlockListSettings(rootClientId)) === null || _getBlockListSettings === void 0 ? void 0 : _getBlockListSettings.orientation) || 'vertical';
      const rect = event.target.getBoundingClientRect();
      const offsetTop = event.clientY - rect.top;
      const offsetLeft = event.clientX - rect.left;
      const children = Array.from(event.target.children);
      let element = children.find(blockEl => {
        return blockEl.classList.contains('wp-block') && orientation === 'vertical' && blockEl.offsetTop > offsetTop || blockEl.classList.contains('wp-block') && orientation === 'horizontal' && blockEl.offsetLeft > offsetLeft;
      });

      if (!element) {
        return;
      } // The block may be in an alignment wrapper, so check the first direct
      // child if the element has no ID.


      if (!element.id) {
        element = element.firstElementChild;

        if (!element) {
          return;
        }
      } // Don't show the insertion point if a parent block has an "overlay"
      // See https://github.com/WordPress/gutenberg/pull/34012#pullrequestreview-727762337


      const parentOverlay = (_element$parentElemen = element.parentElement) === null || _element$parentElemen === void 0 ? void 0 : _element$parentElemen.closest('.block-editor-block-content-overlay.overlay-active');

      if (parentOverlay) {
        return;
      }

      const clientId = element.id.slice('block-'.length);

      if (!clientId) {
        return;
      } // Don't show the inserter when hovering above (conflicts with
      // block toolbar) or inside selected block(s).


      if (getSelectedBlockClientIds().includes(clientId)) {
        return;
      }

      const elementRect = element.getBoundingClientRect();

      if (orientation === 'horizontal' && (event.clientY > elementRect.bottom || event.clientY < elementRect.top) || orientation === 'vertical' && (event.clientX > elementRect.right || event.clientX < elementRect.left)) {
        if (isBlockInsertionPointVisible()) {
          hideInsertionPoint();
        }

        return;
      }

      const index = getBlockIndex(clientId); // Don't show the in-between inserter before the first block in
      // the list (preserves the original behaviour).

      if (index === 0) {
        if (isBlockInsertionPointVisible()) {
          hideInsertionPoint();
        }

        return;
      }

      showInsertionPoint(rootClientId, index, {
        __unstableWithInserter: true
      });
    }

    node.addEventListener('mousemove', onMouseMove);
    return () => {
      node.removeEventListener('mousemove', onMouseMove);
    };
  }, [openRef, getBlockListSettings, getBlockRootClientId, getBlockIndex, isBlockInsertionPointVisible, isMultiSelecting, showInsertionPoint, hideInsertionPoint, getSelectedBlockClientIds]);
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/utils/pre-parse-patterns.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



const requestIdleCallback = (() => {
  if (typeof window === 'undefined') {
    return callback => {
      setTimeout(() => callback(Date.now()), 0);
    };
  }

  return window.requestIdleCallback || window.requestAnimationFrame;
})();

const cancelIdleCallback = (() => {
  if (typeof window === 'undefined') {
    return clearTimeout;
  }

  return window.cancelIdleCallback || window.cancelAnimationFrame;
})();

function usePreParsePatterns() {
  const patterns = (0,external_wp_data_namespaceObject.useSelect)(_select => _select(store).getSettings().__experimentalBlockPatterns, []);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (!(patterns !== null && patterns !== void 0 && patterns.length)) {
      return;
    }

    let handle;
    let index = -1;

    const callback = () => {
      index++;

      if (index >= patterns.length) {
        return;
      }

      (0,external_wp_data_namespaceObject.select)(store).__experimentalGetParsedPattern(patterns[index].name);

      handle = requestIdleCallback(callback);
    };

    handle = requestIdleCallback(callback);
    return () => cancelIdleCallback(handle);
  }, [patterns]);
  return null;
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/use-block-display-information/index.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/** @typedef {import('@wordpress/blocks').WPIcon} WPIcon */

/**
 * Contains basic block's information for display reasons.
 *
 * @typedef {Object} WPBlockDisplayInformation
 *
 * @property {string} title       Human-readable block type label.
 * @property {WPIcon} icon        Block type icon.
 * @property {string} description A detailed block type description.
 */

/**
 * Hook used to try to find a matching block variation and return
 * the appropriate information for display reasons. In order to
 * to try to find a match we need to things:
 * 1. Block's client id to extract it's current attributes.
 * 2. A block variation should have set `isActive` prop to a proper function.
 *
 * If for any reason a block variaton match cannot be found,
 * the returned information come from the Block Type.
 * If no blockType is found with the provided clientId, returns null.
 *
 * @param {string} clientId Block's client id.
 * @return {?WPBlockDisplayInformation} Block's display information, or `null` when the block or its type not found.
 */

function useBlockDisplayInformation(clientId) {
  return (0,external_wp_data_namespaceObject.useSelect)(select => {
    if (!clientId) return null;
    const {
      getBlockName,
      getBlockAttributes
    } = select(store);
    const {
      getBlockType,
      getActiveBlockVariation
    } = select(external_wp_blocks_namespaceObject.store);
    const blockName = getBlockName(clientId);
    const blockType = getBlockType(blockName);
    if (!blockType) return null;
    const attributes = getBlockAttributes(clientId);
    const match = getActiveBlockVariation(blockName, attributes);
    const blockTypeInfo = {
      title: blockType.title,
      icon: blockType.icon,
      description: blockType.description,
      anchor: attributes === null || attributes === void 0 ? void 0 : attributes.anchor
    };
    if (!match) return blockTypeInfo;
    return {
      title: match.title || blockType.title,
      icon: match.icon || blockType.icon,
      description: match.description || blockType.description
    };
  }, [clientId]);
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-title/use-block-display-title.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



/**
 * Returns the block's configured title as a string, or empty if the title
 * cannot be determined.
 *
 * @example
 *
 * ```js
 * useBlockDisplayTitle( 'afd1cb17-2c08-4e7a-91be-007ba7ddc3a1', 17 );
 * ```
 *
 * @param {string} clientId Client ID of block.
 * @param {number|undefined} maximumLength The maximum length that the block title string may be before truncated.
 * @return {?string} Block title.
 */

function useBlockDisplayTitle(clientId, maximumLength) {
  const {
    attributes,
    name,
    reusableBlockTitle
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    if (!clientId) {
      return {};
    }

    const {
      getBlockName,
      getBlockAttributes,
      __experimentalGetReusableBlockTitle
    } = select(store);
    const blockName = getBlockName(clientId);

    if (!blockName) {
      return {};
    }

    const isReusable = (0,external_wp_blocks_namespaceObject.isReusableBlock)((0,external_wp_blocks_namespaceObject.getBlockType)(blockName));
    return {
      attributes: getBlockAttributes(clientId),
      name: blockName,
      reusableBlockTitle: isReusable && __experimentalGetReusableBlockTitle(getBlockAttributes(clientId).ref)
    };
  }, [clientId]);
  const blockInformation = useBlockDisplayInformation(clientId);

  if (!name || !blockInformation) {
    return null;
  }

  const blockType = (0,external_wp_blocks_namespaceObject.getBlockType)(name);
  const blockLabel = blockType ? (0,external_wp_blocks_namespaceObject.__experimentalGetBlockLabel)(blockType, attributes) : null;
  const label = reusableBlockTitle || blockLabel; // Label will fallback to the title if no label is defined for the current
  // label context. If the label is defined we prioritize it over possible
  // possible block variation title match.

  if (label && label !== blockType.title) {
    return maximumLength && maximumLength > 0 ? (0,external_lodash_namespaceObject.truncate)(label, {
      length: maximumLength
    }) : label;
  }

  return blockInformation.title;
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-title/index.js
/**
 * Internal dependencies
 */

/**
 * Renders the block's configured title as a string, or empty if the title
 * cannot be determined.
 *
 * @example
 *
 * ```jsx
 * <BlockTitle clientId="afd1cb17-2c08-4e7a-91be-007ba7ddc3a1" maximumLength={ 17 }/>
 * ```
 *
 * @param {Object} props
 * @param {string} props.clientId Client ID of block.
 * @param {number|undefined} props.maximumLength The maximum length that the block title string may be before truncated.
 *
 * @return {JSX.Element} Block title.
 */

function BlockTitle(_ref) {
  let {
    clientId,
    maximumLength
  } = _ref;
  return useBlockDisplayTitle(clientId, maximumLength);
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-draggable/use-scroll-when-dragging.js
/**
 * WordPress dependencies
 */


const SCROLL_INACTIVE_DISTANCE_PX = 50;
const SCROLL_INTERVAL_MS = 25;
const PIXELS_PER_SECOND_PER_PERCENTAGE = 1000;
const VELOCITY_MULTIPLIER = PIXELS_PER_SECOND_PER_PERCENTAGE * (SCROLL_INTERVAL_MS / 1000);
/**
 * React hook that scrolls the scroll container when a block is being dragged.
 *
 * @return {Function[]} `startScrolling`, `scrollOnDragOver`, `stopScrolling`
 *                      functions to be called in `onDragStart`, `onDragOver`
 *                      and `onDragEnd` events respectively.
 */

function useScrollWhenDragging() {
  const dragStartY = (0,external_wp_element_namespaceObject.useRef)(null);
  const velocityY = (0,external_wp_element_namespaceObject.useRef)(null);
  const scrollParentY = (0,external_wp_element_namespaceObject.useRef)(null);
  const scrollEditorInterval = (0,external_wp_element_namespaceObject.useRef)(null); // Clear interval when unmounting.

  (0,external_wp_element_namespaceObject.useEffect)(() => () => {
    if (scrollEditorInterval.current) {
      clearInterval(scrollEditorInterval.current);
      scrollEditorInterval.current = null;
    }
  }, []);
  const startScrolling = (0,external_wp_element_namespaceObject.useCallback)(event => {
    dragStartY.current = event.clientY; // Find nearest parent(s) to scroll.

    scrollParentY.current = (0,external_wp_dom_namespaceObject.getScrollContainer)(event.target);
    scrollEditorInterval.current = setInterval(() => {
      if (scrollParentY.current && velocityY.current) {
        const newTop = scrollParentY.current.scrollTop + velocityY.current; // Setting `behavior: 'smooth'` as a scroll property seems to hurt performance.
        // Better to use a small scroll interval.

        scrollParentY.current.scroll({
          top: newTop
        });
      }
    }, SCROLL_INTERVAL_MS);
  }, []);
  const scrollOnDragOver = (0,external_wp_element_namespaceObject.useCallback)(event => {
    if (!scrollParentY.current) {
      return;
    }

    const scrollParentHeight = scrollParentY.current.offsetHeight;
    const offsetDragStartPosition = dragStartY.current - scrollParentY.current.offsetTop;
    const offsetDragPosition = event.clientY - scrollParentY.current.offsetTop;

    if (event.clientY > offsetDragStartPosition) {
      // User is dragging downwards.
      const moveableDistance = Math.max(scrollParentHeight - offsetDragStartPosition - SCROLL_INACTIVE_DISTANCE_PX, 0);
      const dragDistance = Math.max(offsetDragPosition - offsetDragStartPosition - SCROLL_INACTIVE_DISTANCE_PX, 0);
      const distancePercentage = dragDistance / moveableDistance;
      velocityY.current = VELOCITY_MULTIPLIER * distancePercentage;
    } else if (event.clientY < offsetDragStartPosition) {
      // User is dragging upwards.
      const moveableDistance = Math.max(offsetDragStartPosition - SCROLL_INACTIVE_DISTANCE_PX, 0);
      const dragDistance = Math.max(offsetDragStartPosition - offsetDragPosition - SCROLL_INACTIVE_DISTANCE_PX, 0);
      const distancePercentage = dragDistance / moveableDistance;
      velocityY.current = -VELOCITY_MULTIPLIER * distancePercentage;
    } else {
      velocityY.current = 0;
    }
  }, []);

  const stopScrolling = () => {
    dragStartY.current = null;
    scrollParentY.current = null;

    if (scrollEditorInterval.current) {
      clearInterval(scrollEditorInterval.current);
      scrollEditorInterval.current = null;
    }
  };

  return [startScrolling, scrollOnDragOver, stopScrolling];
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-draggable/index.js


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */





const BlockDraggable = _ref => {
  let {
    children,
    clientIds,
    cloneClassname,
    onDragStart,
    onDragEnd
  } = _ref;
  const {
    srcRootClientId,
    isDraggable,
    icon
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    var _getBlockType;

    const {
      getBlockRootClientId,
      getTemplateLock,
      getBlockName
    } = select(store);
    const rootClientId = getBlockRootClientId(clientIds[0]);
    const templateLock = rootClientId ? getTemplateLock(rootClientId) : null;
    const blockName = getBlockName(clientIds[0]);
    return {
      srcRootClientId: rootClientId,
      isDraggable: 'all' !== templateLock,
      icon: (_getBlockType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockName)) === null || _getBlockType === void 0 ? void 0 : _getBlockType.icon
    };
  }, [clientIds]);
  const isDragging = (0,external_wp_element_namespaceObject.useRef)(false);
  const [startScrolling, scrollOnDragOver, stopScrolling] = useScrollWhenDragging();
  const {
    startDraggingBlocks,
    stopDraggingBlocks
  } = (0,external_wp_data_namespaceObject.useDispatch)(store); // Stop dragging blocks if the block draggable is unmounted.

  (0,external_wp_element_namespaceObject.useEffect)(() => {
    return () => {
      if (isDragging.current) {
        stopDraggingBlocks();
      }
    };
  }, []);

  if (!isDraggable) {
    return children({
      isDraggable: false
    });
  }

  const transferData = {
    type: 'block',
    srcClientIds: clientIds,
    srcRootClientId
  };
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Draggable, {
    cloneClassname: cloneClassname,
    __experimentalTransferDataType: "wp-blocks",
    transferData: transferData,
    onDragStart: event => {
      startDraggingBlocks(clientIds);
      isDragging.current = true;
      startScrolling(event);

      if (onDragStart) {
        onDragStart();
      }
    },
    onDragOver: scrollOnDragOver,
    onDragEnd: () => {
      stopDraggingBlocks();
      isDragging.current = false;
      stopScrolling();

      if (onDragEnd) {
        onDragEnd();
      }
    },
    __experimentalDragComponent: (0,external_wp_element_namespaceObject.createElement)(BlockDraggableChip, {
      count: clientIds.length,
      icon: icon
    })
  }, _ref2 => {
    let {
      onDraggableStart,
      onDraggableEnd
    } = _ref2;
    return children({
      draggable: true,
      onDragStart: onDraggableStart,
      onDragEnd: onDraggableEnd
    });
  });
};

/* harmony default export */ var block_draggable = (BlockDraggable);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-tools/block-selection-button.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */










/**
 * Internal dependencies
 */






/**
 * Block selection button component, displaying the label of the block. If the block
 * descends from a root block, a button is displayed enabling the user to select
 * the root block.
 *
 * @param {string} props          Component props.
 * @param {string} props.clientId Client ID of block.
 *
 * @return {WPComponent} The component to be rendered.
 */

function BlockSelectionButton(_ref) {
  let {
    clientId,
    rootClientId,
    blockElement
  } = _ref;
  const blockInformation = useBlockDisplayInformation(clientId);
  const selected = (0,external_wp_data_namespaceObject.useSelect)(select => {
    var _getBlockListSettings;

    const {
      getBlock,
      getBlockIndex,
      hasBlockMovingClientId,
      getBlockListSettings
    } = select(store);
    const index = getBlockIndex(clientId);
    const {
      name,
      attributes
    } = getBlock(clientId);
    const blockMovingMode = hasBlockMovingClientId();
    return {
      index,
      name,
      attributes,
      blockMovingMode,
      orientation: (_getBlockListSettings = getBlockListSettings(rootClientId)) === null || _getBlockListSettings === void 0 ? void 0 : _getBlockListSettings.orientation
    };
  }, [clientId, rootClientId]);
  const {
    index,
    name,
    attributes,
    blockMovingMode,
    orientation
  } = selected;
  const {
    setNavigationMode,
    removeBlock
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const ref = (0,external_wp_element_namespaceObject.useRef)();
  const blockType = (0,external_wp_blocks_namespaceObject.getBlockType)(name);
  const label = (0,external_wp_blocks_namespaceObject.__experimentalGetAccessibleBlockLabel)(blockType, attributes, index + 1, orientation); // Focus the breadcrumb in navigation mode.

  (0,external_wp_element_namespaceObject.useEffect)(() => {
    ref.current.focus();
    (0,external_wp_a11y_namespaceObject.speak)(label);
  }, [label]);
  const {
    hasBlockMovingClientId,
    getBlockIndex,
    getBlockRootClientId,
    getClientIdsOfDescendants,
    getSelectedBlockClientId,
    getMultiSelectedBlocksEndClientId,
    getPreviousBlockClientId,
    getNextBlockClientId,
    isNavigationMode
  } = (0,external_wp_data_namespaceObject.useSelect)(store);
  const {
    selectBlock,
    clearSelectedBlock,
    setBlockMovingClientId,
    moveBlockToPosition
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);

  function onKeyDown(event) {
    const {
      keyCode
    } = event;
    const isUp = keyCode === external_wp_keycodes_namespaceObject.UP;
    const isDown = keyCode === external_wp_keycodes_namespaceObject.DOWN;
    const isLeft = keyCode === external_wp_keycodes_namespaceObject.LEFT;
    const isRight = keyCode === external_wp_keycodes_namespaceObject.RIGHT;
    const isTab = keyCode === external_wp_keycodes_namespaceObject.TAB;
    const isEscape = keyCode === external_wp_keycodes_namespaceObject.ESCAPE;
    const isEnter = keyCode === external_wp_keycodes_namespaceObject.ENTER;
    const isSpace = keyCode === external_wp_keycodes_namespaceObject.SPACE;
    const isShift = event.shiftKey;

    if (keyCode === external_wp_keycodes_namespaceObject.BACKSPACE || keyCode === external_wp_keycodes_namespaceObject.DELETE) {
      removeBlock(clientId);
      event.preventDefault();
      return;
    }

    const selectedBlockClientId = getSelectedBlockClientId();
    const selectionEndClientId = getMultiSelectedBlocksEndClientId();
    const selectionBeforeEndClientId = getPreviousBlockClientId(selectionEndClientId || selectedBlockClientId);
    const selectionAfterEndClientId = getNextBlockClientId(selectionEndClientId || selectedBlockClientId);
    const navigateUp = isTab && isShift || isUp;
    const navigateDown = isTab && !isShift || isDown; // Move out of current nesting level (no effect if at root level).

    const navigateOut = isLeft; // Move into next nesting level (no effect if the current block has no innerBlocks).

    const navigateIn = isRight;
    let focusedBlockUid;

    if (navigateUp) {
      focusedBlockUid = selectionBeforeEndClientId;
    } else if (navigateDown) {
      focusedBlockUid = selectionAfterEndClientId;
    } else if (navigateOut) {
      var _getBlockRootClientId;

      focusedBlockUid = (_getBlockRootClientId = getBlockRootClientId(selectedBlockClientId)) !== null && _getBlockRootClientId !== void 0 ? _getBlockRootClientId : selectedBlockClientId;
    } else if (navigateIn) {
      var _getClientIdsOfDescen;

      focusedBlockUid = (_getClientIdsOfDescen = getClientIdsOfDescendants([selectedBlockClientId])[0]) !== null && _getClientIdsOfDescen !== void 0 ? _getClientIdsOfDescen : selectedBlockClientId;
    }

    const startingBlockClientId = hasBlockMovingClientId();

    if (isEscape && isNavigationMode()) {
      clearSelectedBlock();
      event.preventDefault();
    }

    if (isEscape && startingBlockClientId && !event.defaultPrevented) {
      setBlockMovingClientId(null);
      event.preventDefault();
    }

    if ((isEnter || isSpace) && startingBlockClientId) {
      const sourceRoot = getBlockRootClientId(startingBlockClientId);
      const destRoot = getBlockRootClientId(selectedBlockClientId);
      const sourceBlockIndex = getBlockIndex(startingBlockClientId);
      let destinationBlockIndex = getBlockIndex(selectedBlockClientId);

      if (sourceBlockIndex < destinationBlockIndex && sourceRoot === destRoot) {
        destinationBlockIndex -= 1;
      }

      moveBlockToPosition(startingBlockClientId, sourceRoot, destRoot, destinationBlockIndex);
      selectBlock(startingBlockClientId);
      setBlockMovingClientId(null);
    }

    if (navigateDown || navigateUp || navigateOut || navigateIn) {
      if (focusedBlockUid) {
        event.preventDefault();
        selectBlock(focusedBlockUid);
      } else if (isTab && selectedBlockClientId) {
        let nextTabbable;

        if (navigateDown) {
          nextTabbable = blockElement;

          do {
            nextTabbable = external_wp_dom_namespaceObject.focus.tabbable.findNext(nextTabbable);
          } while (nextTabbable && blockElement.contains(nextTabbable));

          if (!nextTabbable) {
            nextTabbable = blockElement.ownerDocument.defaultView.frameElement;
            nextTabbable = external_wp_dom_namespaceObject.focus.tabbable.findNext(nextTabbable);
          }
        } else {
          nextTabbable = external_wp_dom_namespaceObject.focus.tabbable.findPrevious(blockElement);
        }

        if (nextTabbable) {
          event.preventDefault();
          nextTabbable.focus();
          clearSelectedBlock();
        }
      }
    }
  }

  const classNames = classnames_default()('block-editor-block-list__block-selection-button', {
    'is-block-moving-mode': !!blockMovingMode
  });

  const dragHandleLabel = (0,external_wp_i18n_namespaceObject.__)('Drag');

  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: classNames
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Flex, {
    justify: "center",
    className: "block-editor-block-list__block-selection-button__content"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.FlexItem, null, (0,external_wp_element_namespaceObject.createElement)(block_icon, {
    icon: blockInformation === null || blockInformation === void 0 ? void 0 : blockInformation.icon,
    showColors: true
  })), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.FlexItem, null, (0,external_wp_element_namespaceObject.createElement)(block_draggable, {
    clientIds: [clientId]
  }, draggableProps => (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, _extends({
    icon: drag_handle,
    className: "block-selection-button_drag-handle",
    "aria-hidden": "true",
    label: dragHandleLabel // Should not be able to tab to drag handle as this
    // button can only be used with a pointer device.
    ,
    tabIndex: "-1"
  }, draggableProps)))), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.FlexItem, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
    ref: ref,
    onClick: () => setNavigationMode(false),
    onKeyDown: onKeyDown,
    label: label,
    className: "block-selection-button_select-button"
  }, (0,external_wp_element_namespaceObject.createElement)(BlockTitle, {
    clientId: clientId,
    maximumLength: 35
  })))));
}

/* harmony default export */ var block_selection_button = (BlockSelectionButton);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/navigable-toolbar/index.js



/**
 * WordPress dependencies
 */






function hasOnlyToolbarItem(elements) {
  const dataProp = 'toolbarItem';
  return !elements.some(element => !(dataProp in element.dataset));
}

function getAllToolbarItemsIn(container) {
  return Array.from(container.querySelectorAll('[data-toolbar-item]'));
}

function hasFocusWithin(container) {
  return container.contains(container.ownerDocument.activeElement);
}

function focusFirstTabbableIn(container) {
  const [firstTabbable] = external_wp_dom_namespaceObject.focus.tabbable.find(container);

  if (firstTabbable) {
    firstTabbable.focus();
  }
}

function useIsAccessibleToolbar(ref) {
  /*
   * By default, we'll assume the starting accessible state of the Toolbar
   * is true, as it seems to be the most common case.
   *
   * Transitioning from an (initial) false to true state causes the
   * <Toolbar /> component to mount twice, which is causing undesired
   * side-effects. These side-effects appear to only affect certain
   * E2E tests.
   *
   * This was initial discovered in this pull-request:
   * https://github.com/WordPress/gutenberg/pull/23425
   */
  const initialAccessibleToolbarState = true; // By default, it's gonna render NavigableMenu. If all the tabbable elements
  // inside the toolbar are ToolbarItem components (or derived components like
  // ToolbarButton), then we can wrap them with the accessible Toolbar
  // component.

  const [isAccessibleToolbar, setIsAccessibleToolbar] = (0,external_wp_element_namespaceObject.useState)(initialAccessibleToolbarState);
  const determineIsAccessibleToolbar = (0,external_wp_element_namespaceObject.useCallback)(() => {
    const tabbables = external_wp_dom_namespaceObject.focus.tabbable.find(ref.current);
    const onlyToolbarItem = hasOnlyToolbarItem(tabbables);

    if (!onlyToolbarItem) {
      external_wp_deprecated_default()('Using custom components as toolbar controls', {
        since: '5.6',
        alternative: 'ToolbarItem, ToolbarButton or ToolbarDropdownMenu components',
        link: 'https://developer.wordpress.org/block-editor/components/toolbar-button/#inside-blockcontrols'
      });
    }

    setIsAccessibleToolbar(onlyToolbarItem);
  }, []);
  (0,external_wp_element_namespaceObject.useLayoutEffect)(() => {
    // Toolbar buttons may be rendered asynchronously, so we use
    // MutationObserver to check if the toolbar subtree has been modified.
    const observer = new window.MutationObserver(determineIsAccessibleToolbar);
    observer.observe(ref.current, {
      childList: true,
      subtree: true
    });
    return () => observer.disconnect();
  }, [isAccessibleToolbar]);
  return isAccessibleToolbar;
}

function useToolbarFocus(ref, focusOnMount, isAccessibleToolbar, defaultIndex, onIndexChange) {
  // Make sure we don't use modified versions of this prop.
  const [initialFocusOnMount] = (0,external_wp_element_namespaceObject.useState)(focusOnMount);
  const [initialIndex] = (0,external_wp_element_namespaceObject.useState)(defaultIndex);
  const focusToolbar = (0,external_wp_element_namespaceObject.useCallback)(() => {
    focusFirstTabbableIn(ref.current);
  }, []); // Focus on toolbar when pressing alt+F10 when the toolbar is visible.

  (0,external_wp_keyboardShortcuts_namespaceObject.useShortcut)('core/block-editor/focus-toolbar', focusToolbar);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (initialFocusOnMount) {
      focusToolbar();
    }
  }, [isAccessibleToolbar, initialFocusOnMount, focusToolbar]);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    // If initialIndex is passed, we focus on that toolbar item when the
    // toolbar gets mounted and initial focus is not forced.
    // We have to wait for the next browser paint because block controls aren't
    // rendered right away when the toolbar gets mounted.
    let raf = 0;

    if (initialIndex && !initialFocusOnMount) {
      raf = window.requestAnimationFrame(() => {
        const items = getAllToolbarItemsIn(ref.current);
        const index = initialIndex || 0;

        if (items[index] && hasFocusWithin(ref.current)) {
          items[index].focus();
        }
      });
    }

    return () => {
      window.cancelAnimationFrame(raf);
      if (!onIndexChange || !ref.current) return; // When the toolbar element is unmounted and onIndexChange is passed, we
      // pass the focused toolbar item index so it can be hydrated later.

      const items = getAllToolbarItemsIn(ref.current);
      const index = items.findIndex(item => item.tabIndex === 0);
      onIndexChange(index);
    };
  }, [initialIndex, initialFocusOnMount]);
}

function NavigableToolbar(_ref) {
  let {
    children,
    focusOnMount,
    __experimentalInitialIndex: initialIndex,
    __experimentalOnIndexChange: onIndexChange,
    ...props
  } = _ref;
  const ref = (0,external_wp_element_namespaceObject.useRef)();
  const isAccessibleToolbar = useIsAccessibleToolbar(ref);
  useToolbarFocus(ref, focusOnMount, isAccessibleToolbar, initialIndex, onIndexChange);

  if (isAccessibleToolbar) {
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Toolbar, _extends({
      label: props['aria-label'],
      ref: ref
    }, props), children);
  }

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.NavigableMenu, _extends({
    orientation: "horizontal",
    role: "toolbar",
    ref: ref
  }, props), children);
}

/* harmony default export */ var navigable_toolbar = (NavigableToolbar);

;// CONCATENATED MODULE: ./packages/icons/build-module/library/chevron-right.js


/**
 * WordPress dependencies
 */

const chevronRight = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M10.6 6L9.4 7l4.6 5-4.6 5 1.2 1 5.4-6z"
}));
/* harmony default export */ var chevron_right = (chevronRight);

;// CONCATENATED MODULE: ./packages/icons/build-module/library/chevron-left.js


/**
 * WordPress dependencies
 */

const chevronLeft = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M14.6 7l-1.2-1L8 12l5.4 6 1.2-1-4.6-5z"
}));
/* harmony default export */ var chevron_left = (chevronLeft);

;// CONCATENATED MODULE: ./packages/icons/build-module/library/chevron-up.js


/**
 * WordPress dependencies
 */

const chevronUp = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M6.5 12.4L12 8l5.5 4.4-.9 1.2L12 10l-4.5 3.6-1-1.2z"
}));
/* harmony default export */ var chevron_up = (chevronUp);

;// CONCATENATED MODULE: ./packages/icons/build-module/library/chevron-down.js


/**
 * WordPress dependencies
 */

const chevronDown = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M17.5 11.6L12 16l-5.5-4.4.9-1.2L12 14l4.5-3.6 1 1.2z"
}));
/* harmony default export */ var chevron_down = (chevronDown);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-mover/mover-description.js
/**
 * WordPress dependencies
 */

/**
 * Return a label for the block movement controls depending on block position.
 *
 * @param {number}  selectedCount Number of blocks selected.
 * @param {string}  type          Block type - in the case of a single block, should
 *                                define its 'type'. I.e. 'Text', 'Heading', 'Image' etc.
 * @param {number}  firstIndex    The index (position - 1) of the first block selected.
 * @param {boolean} isFirst       This is the first block.
 * @param {boolean} isLast        This is the last block.
 * @param {number}  dir           Direction of movement (> 0 is considered to be going
 *                                down, < 0 is up).
 * @param {string}  orientation   The orientation of the block movers, vertical or
 *                                horizontal.
 *
 * @return {string} Label for the block movement controls.
 */

function getBlockMoverDescription(selectedCount, type, firstIndex, isFirst, isLast, dir, orientation) {
  const position = firstIndex + 1;

  const getMovementDirection = moveDirection => {
    if (moveDirection === 'up') {
      if (orientation === 'horizontal') {
        return (0,external_wp_i18n_namespaceObject.isRTL)() ? 'right' : 'left';
      }

      return 'up';
    } else if (moveDirection === 'down') {
      if (orientation === 'horizontal') {
        return (0,external_wp_i18n_namespaceObject.isRTL)() ? 'left' : 'right';
      }

      return 'down';
    }

    return null;
  };

  if (selectedCount > 1) {
    return getMultiBlockMoverDescription(selectedCount, firstIndex, isFirst, isLast, dir);
  }

  if (isFirst && isLast) {
    return (0,external_wp_i18n_namespaceObject.sprintf)( // translators: %s: Type of block (i.e. Text, Image etc)
    (0,external_wp_i18n_namespaceObject.__)('Block %s is the only block, and cannot be moved'), type);
  }

  if (dir > 0 && !isLast) {
    // Moving down.
    const movementDirection = getMovementDirection('down');

    if (movementDirection === 'down') {
      return (0,external_wp_i18n_namespaceObject.sprintf)( // translators: 1: Type of block (i.e. Text, Image etc), 2: Position of selected block, 3: New position
      (0,external_wp_i18n_namespaceObject.__)('Move %1$s block from position %2$d down to position %3$d'), type, position, position + 1);
    }

    if (movementDirection === 'left') {
      return (0,external_wp_i18n_namespaceObject.sprintf)( // translators: 1: Type of block (i.e. Text, Image etc), 2: Position of selected block, 3: New position
      (0,external_wp_i18n_namespaceObject.__)('Move %1$s block from position %2$d left to position %3$d'), type, position, position + 1);
    }

    if (movementDirection === 'right') {
      return (0,external_wp_i18n_namespaceObject.sprintf)( // translators: 1: Type of block (i.e. Text, Image etc), 2: Position of selected block, 3: New position
      (0,external_wp_i18n_namespaceObject.__)('Move %1$s block from position %2$d right to position %3$d'), type, position, position + 1);
    }
  }

  if (dir > 0 && isLast) {
    // Moving down, and is the last item.
    const movementDirection = getMovementDirection('down');

    if (movementDirection === 'down') {
      return (0,external_wp_i18n_namespaceObject.sprintf)( // translators: 1: Type of block (i.e. Text, Image etc)
      (0,external_wp_i18n_namespaceObject.__)('Block %1$s is at the end of the content and can’t be moved down'), type);
    }

    if (movementDirection === 'left') {
      return (0,external_wp_i18n_namespaceObject.sprintf)( // translators: 1: Type of block (i.e. Text, Image etc)
      (0,external_wp_i18n_namespaceObject.__)('Block %1$s is at the end of the content and can’t be moved left'), type);
    }

    if (movementDirection === 'right') {
      return (0,external_wp_i18n_namespaceObject.sprintf)( // translators: 1: Type of block (i.e. Text, Image etc)
      (0,external_wp_i18n_namespaceObject.__)('Block %1$s is at the end of the content and can’t be moved right'), type);
    }
  }

  if (dir < 0 && !isFirst) {
    // Moving up.
    const movementDirection = getMovementDirection('up');

    if (movementDirection === 'up') {
      return (0,external_wp_i18n_namespaceObject.sprintf)( // translators: 1: Type of block (i.e. Text, Image etc), 2: Position of selected block, 3: New position
      (0,external_wp_i18n_namespaceObject.__)('Move %1$s block from position %2$d up to position %3$d'), type, position, position - 1);
    }

    if (movementDirection === 'left') {
      return (0,external_wp_i18n_namespaceObject.sprintf)( // translators: 1: Type of block (i.e. Text, Image etc), 2: Position of selected block, 3: New position
      (0,external_wp_i18n_namespaceObject.__)('Move %1$s block from position %2$d left to position %3$d'), type, position, position - 1);
    }

    if (movementDirection === 'right') {
      return (0,external_wp_i18n_namespaceObject.sprintf)( // translators: 1: Type of block (i.e. Text, Image etc), 2: Position of selected block, 3: New position
      (0,external_wp_i18n_namespaceObject.__)('Move %1$s block from position %2$d right to position %3$d'), type, position, position - 1);
    }
  }

  if (dir < 0 && isFirst) {
    // Moving up, and is the first item.
    const movementDirection = getMovementDirection('up');

    if (movementDirection === 'up') {
      return (0,external_wp_i18n_namespaceObject.sprintf)( // translators: 1: Type of block (i.e. Text, Image etc)
      (0,external_wp_i18n_namespaceObject.__)('Block %1$s is at the beginning of the content and can’t be moved up'), type);
    }

    if (movementDirection === 'left') {
      return (0,external_wp_i18n_namespaceObject.sprintf)( // translators: 1: Type of block (i.e. Text, Image etc)
      (0,external_wp_i18n_namespaceObject.__)('Block %1$s is at the beginning of the content and can’t be moved left'), type);
    }

    if (movementDirection === 'right') {
      return (0,external_wp_i18n_namespaceObject.sprintf)( // translators: 1: Type of block (i.e. Text, Image etc)
      (0,external_wp_i18n_namespaceObject.__)('Block %1$s is at the beginning of the content and can’t be moved right'), type);
    }
  }
}
/**
 * Return a label for the block movement controls depending on block position.
 *
 * @param {number}  selectedCount Number of blocks selected.
 * @param {number}  firstIndex    The index (position - 1) of the first block selected.
 * @param {boolean} isFirst       This is the first block.
 * @param {boolean} isLast        This is the last block.
 * @param {number}  dir           Direction of movement (> 0 is considered to be going
 *                                down, < 0 is up).
 *
 * @return {string} Label for the block movement controls.
 */

function getMultiBlockMoverDescription(selectedCount, firstIndex, isFirst, isLast, dir) {
  const position = firstIndex + 1;

  if (dir < 0 && isFirst) {
    return (0,external_wp_i18n_namespaceObject.__)('Blocks cannot be moved up as they are already at the top');
  }

  if (dir > 0 && isLast) {
    return (0,external_wp_i18n_namespaceObject.__)('Blocks cannot be moved down as they are already at the bottom');
  }

  if (dir < 0 && !isFirst) {
    return (0,external_wp_i18n_namespaceObject.sprintf)( // translators: 1: Number of selected blocks, 2: Position of selected blocks
    (0,external_wp_i18n_namespaceObject._n)('Move %1$d block from position %2$d up by one place', 'Move %1$d blocks from position %2$d up by one place', selectedCount), selectedCount, position);
  }

  if (dir > 0 && !isLast) {
    return (0,external_wp_i18n_namespaceObject.sprintf)( // translators: 1: Number of selected blocks, 2: Position of selected blocks
    (0,external_wp_i18n_namespaceObject._n)('Move %1$d block from position %2$d down by one place', 'Move %1$d blocks from position %2$d down by one place', selectedCount), selectedCount, position);
  }
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-mover/button.js



/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */







/**
 * Internal dependencies
 */





const getArrowIcon = (direction, orientation) => {
  if (direction === 'up') {
    if (orientation === 'horizontal') {
      return (0,external_wp_i18n_namespaceObject.isRTL)() ? chevron_right : chevron_left;
    }

    return chevron_up;
  } else if (direction === 'down') {
    if (orientation === 'horizontal') {
      return (0,external_wp_i18n_namespaceObject.isRTL)() ? chevron_left : chevron_right;
    }

    return chevron_down;
  }

  return null;
};

const getMovementDirectionLabel = (moveDirection, orientation) => {
  if (moveDirection === 'up') {
    if (orientation === 'horizontal') {
      return (0,external_wp_i18n_namespaceObject.isRTL)() ? (0,external_wp_i18n_namespaceObject.__)('Move right') : (0,external_wp_i18n_namespaceObject.__)('Move left');
    }

    return (0,external_wp_i18n_namespaceObject.__)('Move up');
  } else if (moveDirection === 'down') {
    if (orientation === 'horizontal') {
      return (0,external_wp_i18n_namespaceObject.isRTL)() ? (0,external_wp_i18n_namespaceObject.__)('Move left') : (0,external_wp_i18n_namespaceObject.__)('Move right');
    }

    return (0,external_wp_i18n_namespaceObject.__)('Move down');
  }

  return null;
};

const BlockMoverButton = (0,external_wp_element_namespaceObject.forwardRef)((_ref, ref) => {
  let {
    clientIds,
    direction,
    orientation: moverOrientation,
    ...props
  } = _ref;
  const instanceId = (0,external_wp_compose_namespaceObject.useInstanceId)(BlockMoverButton);
  const blocksCount = (0,external_lodash_namespaceObject.castArray)(clientIds).length;
  const {
    blockType,
    isDisabled,
    rootClientId,
    isFirst,
    isLast,
    firstIndex,
    orientation = 'vertical'
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getBlockIndex,
      getBlockRootClientId,
      getBlockOrder,
      getBlock,
      getBlockListSettings
    } = select(store);
    const normalizedClientIds = (0,external_lodash_namespaceObject.castArray)(clientIds);
    const firstClientId = (0,external_lodash_namespaceObject.first)(normalizedClientIds);
    const blockRootClientId = getBlockRootClientId(firstClientId);
    const firstBlockIndex = getBlockIndex(firstClientId);
    const lastBlockIndex = getBlockIndex((0,external_lodash_namespaceObject.last)(normalizedClientIds));
    const blockOrder = getBlockOrder(blockRootClientId);
    const block = getBlock(firstClientId);
    const isFirstBlock = firstBlockIndex === 0;
    const isLastBlock = lastBlockIndex === blockOrder.length - 1;
    const {
      orientation: blockListOrientation
    } = getBlockListSettings(blockRootClientId) || {};
    return {
      blockType: block ? (0,external_wp_blocks_namespaceObject.getBlockType)(block.name) : null,
      isDisabled: direction === 'up' ? isFirstBlock : isLastBlock,
      rootClientId: blockRootClientId,
      firstIndex: firstBlockIndex,
      isFirst: isFirstBlock,
      isLast: isLastBlock,
      orientation: moverOrientation || blockListOrientation
    };
  }, [clientIds, direction]);
  const {
    moveBlocksDown,
    moveBlocksUp
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const moverFunction = direction === 'up' ? moveBlocksUp : moveBlocksDown;

  const onClick = event => {
    moverFunction(clientIds, rootClientId);

    if (props.onClick) {
      props.onClick(event);
    }
  };

  const descriptionId = `block-editor-block-mover-button__description-${instanceId}`;
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, _extends({
    ref: ref,
    className: classnames_default()('block-editor-block-mover-button', `is-${direction}-button`),
    icon: getArrowIcon(direction, orientation),
    label: getMovementDirectionLabel(direction, orientation),
    "aria-describedby": descriptionId
  }, props, {
    onClick: isDisabled ? null : onClick,
    "aria-disabled": isDisabled
  })), (0,external_wp_element_namespaceObject.createElement)("span", {
    id: descriptionId,
    className: "block-editor-block-mover-button__description"
  }, getBlockMoverDescription(blocksCount, blockType && blockType.title, firstIndex, isFirst, isLast, direction === 'up' ? -1 : 1, orientation)));
});
const BlockMoverUpButton = (0,external_wp_element_namespaceObject.forwardRef)((props, ref) => {
  return (0,external_wp_element_namespaceObject.createElement)(BlockMoverButton, _extends({
    direction: "up",
    ref: ref
  }, props));
});
const BlockMoverDownButton = (0,external_wp_element_namespaceObject.forwardRef)((props, ref) => {
  return (0,external_wp_element_namespaceObject.createElement)(BlockMoverButton, _extends({
    direction: "down",
    ref: ref
  }, props));
});

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-mover/index.js



/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */







/**
 * Internal dependencies
 */





function BlockMover(_ref) {
  let {
    isFirst,
    isLast,
    clientIds,
    canMove,
    isHidden,
    rootClientId,
    orientation,
    hideDragHandle
  } = _ref;
  const [isFocused, setIsFocused] = (0,external_wp_element_namespaceObject.useState)(false);

  const onFocus = () => setIsFocused(true);

  const onBlur = () => setIsFocused(false);

  if (!canMove || isFirst && isLast && !rootClientId) {
    return null;
  }

  const dragHandleLabel = (0,external_wp_i18n_namespaceObject.__)('Drag'); // We emulate a disabled state because forcefully applying the `disabled`
  // attribute on the buttons while it has focus causes the screen to change
  // to an unfocused state (body as active element) without firing blur on,
  // the rendering parent, leaving it unable to react to focus out.


  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: classnames_default()('block-editor-block-mover', {
      'is-visible': isFocused || !isHidden,
      'is-horizontal': orientation === 'horizontal'
    })
  }, !hideDragHandle && (0,external_wp_element_namespaceObject.createElement)(block_draggable, {
    clientIds: clientIds,
    cloneClassname: "block-editor-block-mover__drag-clone"
  }, draggableProps => (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, _extends({
    icon: drag_handle,
    className: "block-editor-block-mover__drag-handle",
    "aria-hidden": "true",
    label: dragHandleLabel // Should not be able to tab to drag handle as this
    // button can only be used with a pointer device.
    ,
    tabIndex: "-1"
  }, draggableProps))), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarGroup, {
    className: "block-editor-block-mover__move-button-container"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarItem, {
    onFocus: onFocus,
    onBlur: onBlur
  }, itemProps => (0,external_wp_element_namespaceObject.createElement)(BlockMoverUpButton, _extends({
    clientIds: clientIds
  }, itemProps))), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarItem, {
    onFocus: onFocus,
    onBlur: onBlur
  }, itemProps => (0,external_wp_element_namespaceObject.createElement)(BlockMoverDownButton, _extends({
    clientIds: clientIds
  }, itemProps)))));
}

/* harmony default export */ var block_mover = ((0,external_wp_data_namespaceObject.withSelect)((select, _ref2) => {
  var _getBlockListSettings;

  let {
    clientIds
  } = _ref2;
  const {
    getBlock,
    getBlockIndex,
    getBlockListSettings,
    canMoveBlocks,
    getBlockOrder,
    getBlockRootClientId
  } = select(store);
  const normalizedClientIds = (0,external_lodash_namespaceObject.castArray)(clientIds);
  const firstClientId = (0,external_lodash_namespaceObject.first)(normalizedClientIds);
  const block = getBlock(firstClientId);
  const rootClientId = getBlockRootClientId((0,external_lodash_namespaceObject.first)(normalizedClientIds));
  const firstIndex = getBlockIndex(firstClientId);
  const lastIndex = getBlockIndex((0,external_lodash_namespaceObject.last)(normalizedClientIds));
  const blockOrder = getBlockOrder(rootClientId);
  const isFirst = firstIndex === 0;
  const isLast = lastIndex === blockOrder.length - 1;
  return {
    blockType: block ? (0,external_wp_blocks_namespaceObject.getBlockType)(block.name) : null,
    canMove: canMoveBlocks(clientIds, rootClientId),
    rootClientId,
    firstIndex,
    isFirst,
    isLast,
    orientation: (_getBlockListSettings = getBlockListSettings(rootClientId)) === null || _getBlockListSettings === void 0 ? void 0 : _getBlockListSettings.orientation
  };
})(BlockMover));

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-toolbar/utils.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


const {
  clearTimeout: utils_clearTimeout,
  setTimeout: utils_setTimeout
} = window;
const DEBOUNCE_TIMEOUT = 200;
/**
 * Hook that creates a showMover state, as well as debounced show/hide callbacks.
 *
 * @param {Object}   props                       Component props.
 * @param {Object}   props.ref                   Element reference.
 * @param {boolean}  props.isFocused             Whether the component has current focus.
 * @param {number}   [props.debounceTimeout=250] Debounce timeout in milliseconds.
 * @param {Function} [props.onChange=noop]       Callback function.
 */

function useDebouncedShowMovers(_ref) {
  let {
    ref,
    isFocused,
    debounceTimeout = DEBOUNCE_TIMEOUT,
    onChange = external_lodash_namespaceObject.noop
  } = _ref;
  const [showMovers, setShowMovers] = (0,external_wp_element_namespaceObject.useState)(false);
  const timeoutRef = (0,external_wp_element_namespaceObject.useRef)();

  const handleOnChange = nextIsFocused => {
    if (ref !== null && ref !== void 0 && ref.current) {
      setShowMovers(nextIsFocused);
    }

    onChange(nextIsFocused);
  };

  const getIsHovered = () => {
    return (ref === null || ref === void 0 ? void 0 : ref.current) && ref.current.matches(':hover');
  };

  const shouldHideMovers = () => {
    const isHovered = getIsHovered();
    return !isFocused && !isHovered;
  };

  const clearTimeoutRef = () => {
    const timeout = timeoutRef.current;

    if (timeout && utils_clearTimeout) {
      utils_clearTimeout(timeout);
    }
  };

  const debouncedShowMovers = event => {
    if (event) {
      event.stopPropagation();
    }

    clearTimeoutRef();

    if (!showMovers) {
      handleOnChange(true);
    }
  };

  const debouncedHideMovers = event => {
    if (event) {
      event.stopPropagation();
    }

    clearTimeoutRef();
    timeoutRef.current = utils_setTimeout(() => {
      if (shouldHideMovers()) {
        handleOnChange(false);
      }
    }, debounceTimeout);
  };

  (0,external_wp_element_namespaceObject.useEffect)(() => () => {
    /**
     * We need to call the change handler with `isFocused`
     * set to false on unmount because we also clear the
     * timeout that would handle that.
     */
    handleOnChange(false);
    clearTimeoutRef();
  }, []);
  return {
    showMovers,
    debouncedShowMovers,
    debouncedHideMovers
  };
}
/**
 * Hook that provides a showMovers state and gesture events for DOM elements
 * that interact with the showMovers state.
 *
 * @param {Object}   props                       Component props.
 * @param {Object}   props.ref                   Element reference.
 * @param {number}   [props.debounceTimeout=250] Debounce timeout in milliseconds.
 * @param {Function} [props.onChange=noop]       Callback function.
 */

function useShowMoversGestures(_ref2) {
  let {
    ref,
    debounceTimeout = DEBOUNCE_TIMEOUT,
    onChange = external_lodash_namespaceObject.noop
  } = _ref2;
  const [isFocused, setIsFocused] = (0,external_wp_element_namespaceObject.useState)(false);
  const {
    showMovers,
    debouncedShowMovers,
    debouncedHideMovers
  } = useDebouncedShowMovers({
    ref,
    debounceTimeout,
    isFocused,
    onChange
  });
  const registerRef = (0,external_wp_element_namespaceObject.useRef)(false);

  const isFocusedWithin = () => {
    return (ref === null || ref === void 0 ? void 0 : ref.current) && ref.current.contains(ref.current.ownerDocument.activeElement);
  };

  (0,external_wp_element_namespaceObject.useEffect)(() => {
    const node = ref.current;

    const handleOnFocus = () => {
      if (isFocusedWithin()) {
        setIsFocused(true);
        debouncedShowMovers();
      }
    };

    const handleOnBlur = () => {
      if (!isFocusedWithin()) {
        setIsFocused(false);
        debouncedHideMovers();
      }
    };
    /**
     * Events are added via DOM events (vs. React synthetic events),
     * as the child React components swallow mouse events.
     */


    if (node && !registerRef.current) {
      node.addEventListener('focus', handleOnFocus, true);
      node.addEventListener('blur', handleOnBlur, true);
      registerRef.current = true;
    }

    return () => {
      if (node) {
        node.removeEventListener('focus', handleOnFocus);
        node.removeEventListener('blur', handleOnBlur);
      }
    };
  }, [ref, registerRef, setIsFocused, debouncedShowMovers, debouncedHideMovers]);
  return {
    showMovers,
    gestures: {
      onMouseMove: debouncedShowMovers,
      onMouseLeave: debouncedHideMovers
    }
  };
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-parent-selector/index.js



/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */





/**
 * Block parent selector component, displaying the hierarchy of the
 * current block selection as a single icon to "go up" a level.
 *
 * @return {WPComponent} Parent block selector.
 */

function BlockParentSelector() {
  const {
    selectBlock,
    toggleBlockHighlight
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const {
    firstParentClientId,
    shouldHide,
    hasReducedUI
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getBlockName,
      getBlockParents,
      getSelectedBlockClientId,
      getSettings
    } = select(store);
    const {
      hasBlockSupport
    } = select(external_wp_blocks_namespaceObject.store);
    const selectedBlockClientId = getSelectedBlockClientId();
    const parents = getBlockParents(selectedBlockClientId);
    const _firstParentClientId = parents[parents.length - 1];
    const parentBlockName = getBlockName(_firstParentClientId);

    const _parentBlockType = (0,external_wp_blocks_namespaceObject.getBlockType)(parentBlockName);

    const settings = getSettings();
    return {
      firstParentClientId: _firstParentClientId,
      shouldHide: !hasBlockSupport(_parentBlockType, '__experimentalParentSelector', true),
      hasReducedUI: settings.hasReducedUI
    };
  }, []);
  const blockInformation = useBlockDisplayInformation(firstParentClientId); // Allows highlighting the parent block outline when focusing or hovering
  // the parent block selector within the child.

  const nodeRef = (0,external_wp_element_namespaceObject.useRef)();
  const {
    gestures: showMoversGestures
  } = useShowMoversGestures({
    ref: nodeRef,

    onChange(isFocused) {
      if (isFocused && hasReducedUI) {
        return;
      }

      toggleBlockHighlight(firstParentClientId, isFocused);
    }

  });

  if (shouldHide || firstParentClientId === undefined) {
    return null;
  }

  return (0,external_wp_element_namespaceObject.createElement)("div", _extends({
    className: "block-editor-block-parent-selector",
    key: firstParentClientId,
    ref: nodeRef
  }, showMoversGestures), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarButton, {
    className: "block-editor-block-parent-selector__button",
    onClick: () => selectBlock(firstParentClientId),
    label: (0,external_wp_i18n_namespaceObject.sprintf)(
    /* translators: %s: Name of the block's parent. */
    (0,external_wp_i18n_namespaceObject.__)('Select %s'), blockInformation.title),
    showTooltip: true,
    icon: (0,external_wp_element_namespaceObject.createElement)(block_icon, {
      icon: blockInformation.icon
    })
  }));
}

;// CONCATENATED MODULE: ./packages/icons/build-module/library/stack.js


/**
 * WordPress dependencies
 */

const stack = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M20.2 8v11c0 .7-.6 1.2-1.2 1.2H6v1.5h13c1.5 0 2.7-1.2 2.7-2.8V8zM18 16.4V4.6c0-.9-.7-1.6-1.6-1.6H4.6C3.7 3 3 3.7 3 4.6v11.8c0 .9.7 1.6 1.6 1.6h11.8c.9 0 1.6-.7 1.6-1.6zm-13.5 0V4.6c0-.1.1-.1.1-.1h11.8c.1 0 .1.1.1.1v11.8c0 .1-.1.1-.1.1H4.6l-.1-.1z"
}));
/* harmony default export */ var library_stack = (stack);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-switcher/preview-block-popover.js


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function PreviewBlockPopover(_ref) {
  let {
    blocks
  } = _ref;
  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-block-switcher__popover__preview__parent"
  }, (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-block-switcher__popover__preview__container"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Popover, {
    className: "block-editor-block-switcher__preview__popover",
    position: "bottom right",
    focusOnMount: false
  }, (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-block-switcher__preview"
  }, (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-block-switcher__preview-title"
  }, (0,external_wp_i18n_namespaceObject.__)('Preview')), (0,external_wp_element_namespaceObject.createElement)(block_preview, {
    viewportWidth: 500,
    blocks: blocks
  })))));
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-switcher/block-transformations-menu.js


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */




const BlockTransformationsMenu = _ref => {
  let {
    className,
    possibleBlockTransformations,
    onSelect,
    blocks
  } = _ref;
  const [hoveredTransformItemName, setHoveredTransformItemName] = (0,external_wp_element_namespaceObject.useState)();
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuGroup, {
    label: (0,external_wp_i18n_namespaceObject.__)('Transform to'),
    className: className
  }, hoveredTransformItemName && (0,external_wp_element_namespaceObject.createElement)(PreviewBlockPopover, {
    blocks: (0,external_wp_blocks_namespaceObject.switchToBlockType)(blocks, hoveredTransformItemName)
  }), possibleBlockTransformations.map(item => {
    const {
      name,
      icon,
      title,
      isDisabled
    } = item;
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuItem, {
      key: name,
      className: (0,external_wp_blocks_namespaceObject.getBlockMenuDefaultClassName)(name),
      onClick: event => {
        event.preventDefault();
        onSelect(name);
      },
      disabled: isDisabled,
      onMouseLeave: () => setHoveredTransformItemName(null),
      onMouseEnter: () => setHoveredTransformItemName(name)
    }, (0,external_wp_element_namespaceObject.createElement)(block_icon, {
      icon: icon,
      showColors: true
    }), title);
  }));
};

/* harmony default export */ var block_transformations_menu = (BlockTransformationsMenu);

;// CONCATENATED MODULE: ./packages/icons/build-module/library/check.js


/**
 * WordPress dependencies
 */

const check = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M16.7 7.1l-6.3 8.5-3.3-2.5-.9 1.2 4.5 3.4L17.9 8z"
}));
/* harmony default export */ var library_check = (check);

;// CONCATENATED MODULE: external ["wp","tokenList"]
var external_wp_tokenList_namespaceObject = window["wp"]["tokenList"];
var external_wp_tokenList_default = /*#__PURE__*/__webpack_require__.n(external_wp_tokenList_namespaceObject);
;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-styles/utils.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Returns the active style from the given className.
 *
 * @param {Array}  styles    Block style variations.
 * @param {string} className Class name
 *
 * @return {Object?} The active style.
 */

function getActiveStyle(styles, className) {
  for (const style of new (external_wp_tokenList_default())(className).values()) {
    if (style.indexOf('is-style-') === -1) {
      continue;
    }

    const potentialStyleName = style.substring(9);
    const activeStyle = (0,external_lodash_namespaceObject.find)(styles, {
      name: potentialStyleName
    });

    if (activeStyle) {
      return activeStyle;
    }
  }

  return (0,external_lodash_namespaceObject.find)(styles, 'isDefault');
}
/**
 * Replaces the active style in the block's className.
 *
 * @param {string}  className   Class name.
 * @param {Object?} activeStyle The replaced style.
 * @param {Object}  newStyle    The replacing style.
 *
 * @return {string} The updated className.
 */

function replaceActiveStyle(className, activeStyle, newStyle) {
  const list = new (external_wp_tokenList_default())(className);

  if (activeStyle) {
    list.remove('is-style-' + activeStyle.name);
  }

  list.add('is-style-' + newStyle.name);
  return list.value;
}
/**
 * Returns a collection of styles that can be represented on the frontend.
 * The function checks a style collection for a default style. If none is found, it adds one to
 * act as a fallback for when there is no active style applied to a block. The default item also serves
 * as a switch on the frontend to deactivate non-default styles.
 *
 * @param {Array} styles Block style variations.
 *
 * @return {Array<Object?>}        The style collection.
 */

function getRenderedStyles(styles) {
  if (!styles || styles.length === 0) {
    return [];
  }

  return getDefaultStyle(styles) ? styles : [{
    name: 'default',
    label: (0,external_wp_i18n_namespaceObject._x)('Default', 'block style'),
    isDefault: true
  }, ...styles];
}
/**
 * Returns a style object from a collection of styles where that style object is the default block style.
 *
 * @param {Array} styles Block style variations.
 *
 * @return {Object?}        The default style object, if found.
 */

function getDefaultStyle(styles) {
  return (0,external_lodash_namespaceObject.find)(styles, 'isDefault');
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-styles/use-styles-for-block.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



/**
 *
 * @param {WPBlock}     block Block object.
 * @param {WPBlockType} type  Block type settings.
 * @return {WPBlock}          A generic block ready for styles preview.
 */

function useGenericPreviewBlock(block, type) {
  return (0,external_wp_element_namespaceObject.useMemo)(() => {
    const example = type === null || type === void 0 ? void 0 : type.example;
    const blockName = type === null || type === void 0 ? void 0 : type.name;

    if (example && blockName) {
      return (0,external_wp_blocks_namespaceObject.getBlockFromExample)(blockName, {
        attributes: example.attributes,
        innerBlocks: example.innerBlocks
      });
    }

    if (block) {
      return (0,external_wp_blocks_namespaceObject.cloneBlock)(block);
    }
  }, [type !== null && type !== void 0 && type.example ? block === null || block === void 0 ? void 0 : block.name : block, type]);
}
/**
 * @typedef useStylesForBlocksArguments
 * @property {string}     clientId Block client ID.
 * @property {() => void} onSwitch Block style switch callback function.
 */

/**
 *
 * @param {useStylesForBlocksArguments} useStylesForBlocks arguments.
 * @return {Object}                                         Results of the select methods.
 */


function useStylesForBlocks(_ref) {
  let {
    clientId,
    onSwitch
  } = _ref;

  const selector = select => {
    const {
      getBlock
    } = select(store);
    const block = getBlock(clientId);

    if (!block) {
      return {};
    }

    const blockType = (0,external_wp_blocks_namespaceObject.getBlockType)(block.name);
    const {
      getBlockStyles
    } = select(external_wp_blocks_namespaceObject.store);
    return {
      block,
      blockType,
      styles: getBlockStyles(block.name),
      className: block.attributes.className || ''
    };
  };

  const {
    styles,
    block,
    blockType,
    className
  } = (0,external_wp_data_namespaceObject.useSelect)(selector, [clientId]);
  const {
    updateBlockAttributes
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const stylesToRender = getRenderedStyles(styles);
  const activeStyle = getActiveStyle(stylesToRender, className);
  const genericPreviewBlock = useGenericPreviewBlock(block, blockType);

  const onSelect = style => {
    const styleClassName = replaceActiveStyle(className, activeStyle, style);
    updateBlockAttributes(clientId, {
      className: styleClassName
    });
    onSwitch();
  };

  return {
    onSelect,
    stylesToRender,
    activeStyle,
    genericPreviewBlock,
    className
  };
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-styles/menu-items.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


function BlockStylesMenuItems(_ref) {
  let {
    clientId,
    onSwitch = external_lodash_namespaceObject.noop
  } = _ref;
  const {
    onSelect,
    stylesToRender,
    activeStyle
  } = useStylesForBlocks({
    clientId,
    onSwitch
  });

  if (!stylesToRender || stylesToRender.length === 0) {
    return null;
  }

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, stylesToRender.map(style => {
    const menuItemText = style.label || style.name;
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuItem, {
      key: style.name,
      icon: activeStyle.name === style.name ? library_check : null,
      onClick: () => onSelect(style)
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalText, {
      as: "span",
      limit: 18,
      ellipsizeMode: "tail",
      truncate: true
    }, menuItemText));
  }));
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-switcher/block-styles-menu.js


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function BlockStylesMenu(_ref) {
  let {
    hoveredBlock,
    onSwitch
  } = _ref;
  const {
    clientId
  } = hoveredBlock;
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuGroup, {
    label: (0,external_wp_i18n_namespaceObject.__)('Styles'),
    className: "block-editor-block-switcher__styles__menugroup"
  }, (0,external_wp_element_namespaceObject.createElement)(BlockStylesMenuItems, {
    clientId: clientId,
    onSwitch: onSwitch
  }));
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-switcher/utils.js
/**
 * WordPress dependencies
 */

/**
 * Try to find a matching block by a block's name in a provided
 * block. We recurse through InnerBlocks and return the reference
 * of the matched block (it could be an InnerBlock).
 * If no match is found return nothing.
 *
 * @param {WPBlock} block             The block to try to find a match.
 * @param {string}  selectedBlockName The block's name to use for matching condition.
 * @param {Set}     consumedBlocks    A set holding the previously matched/consumed blocks.
 *
 * @return {WPBlock?} The matched block if found or nothing(`undefined`).
 */

const getMatchingBlockByName = function (block, selectedBlockName) {
  let consumedBlocks = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : new Set();
  const {
    clientId,
    name,
    innerBlocks = []
  } = block; // Check if block has been consumed already.

  if (consumedBlocks.has(clientId)) return;
  if (name === selectedBlockName) return block; // Try to find a matching block from InnerBlocks recursively.

  for (const innerBlock of innerBlocks) {
    const match = getMatchingBlockByName(innerBlock, selectedBlockName, consumedBlocks);
    if (match) return match;
  }
};
/**
 * Find and return the block attributes to retain through
 * the transformation, based on Block Type's `role:content`
 * attributes. If no `role:content` attributes exist,
 * return selected block's attributes.
 *
 * @param {string} name       Block type's namespaced name.
 * @param {Object} attributes Selected block's attributes.
 * @return {Object} The block's attributes to retain.
 */

const getRetainedBlockAttributes = (name, attributes) => {
  const contentAttributes = (0,external_wp_blocks_namespaceObject.__experimentalGetBlockAttributesNamesByRole)(name, 'content');
  if (!(contentAttributes !== null && contentAttributes !== void 0 && contentAttributes.length)) return attributes;
  return contentAttributes.reduce((_accumulator, attribute) => {
    if (attributes[attribute]) _accumulator[attribute] = attributes[attribute];
    return _accumulator;
  }, {});
};

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-switcher/use-transformed-patterns.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Mutate the matched block's attributes by getting
 * which block type's attributes to retain and prioritize
 * them in the merging of the attributes.
 *
 * @param {WPBlock} match         The matched block.
 * @param {WPBlock} selectedBlock The selected block.
 * @return {void}
 */

const transformMatchingBlock = (match, selectedBlock) => {
  // Get the block attributes to retain through the transformation.
  const retainedBlockAttributes = getRetainedBlockAttributes(selectedBlock.name, selectedBlock.attributes);
  match.attributes = { ...match.attributes,
    ...retainedBlockAttributes
  };
};
/**
 * By providing the selected blocks and pattern's blocks
 * find the matching blocks, transform them and return them.
 * If not all selected blocks are matched, return nothing.
 *
 * @param {WPBlock[]} selectedBlocks The selected blocks.
 * @param {WPBlock[]} patternBlocks  The pattern's blocks.
 * @return {WPBlock[]|void} The transformed pattern's blocks or undefined if not all selected blocks have been matched.
 */

const getPatternTransformedBlocks = (selectedBlocks, patternBlocks) => {
  // Clone Pattern's blocks to produce new clientIds and be able to mutate the matches.
  const _patternBlocks = patternBlocks.map(block => (0,external_wp_blocks_namespaceObject.cloneBlock)(block));
  /**
   * Keep track of the consumed pattern blocks.
   * This is needed because we loop the selected blocks
   * and for example we may have selected two paragraphs and
   * the pattern's blocks could have more `paragraphs`.
   */


  const consumedBlocks = new Set();

  for (const selectedBlock of selectedBlocks) {
    let isMatch = false;

    for (const patternBlock of _patternBlocks) {
      const match = getMatchingBlockByName(patternBlock, selectedBlock.name, consumedBlocks);
      if (!match) continue;
      isMatch = true;
      consumedBlocks.add(match.clientId); // We update (mutate) the matching pattern block.

      transformMatchingBlock(match, selectedBlock); // No need to loop through other pattern's blocks.

      break;
    } // Bail eary if a selected block has not been matched.


    if (!isMatch) return;
  }

  return _patternBlocks;
};
/**
 * @typedef {WPBlockPattern & {transformedBlocks: WPBlock[]}} TransformedBlockPattern
 */

/**
 * Custom hook that accepts patterns from state and the selected
 * blocks and tries to match these with the pattern's blocks.
 * If all selected blocks are matched with a Pattern's block,
 * we transform them by retaining block's attributes with `role:content`.
 * The transformed pattern's blocks are set to a new pattern
 * property `transformedBlocks`.
 *
 * @param {WPBlockPattern[]} patterns       Patterns from state.
 * @param {WPBlock[]}        selectedBlocks The currently selected blocks.
 * @return {TransformedBlockPattern[]} Returns the eligible matched patterns with all the selected blocks.
 */

const useTransformedPatterns = (patterns, selectedBlocks) => {
  return (0,external_wp_element_namespaceObject.useMemo)(() => patterns.reduce((accumulator, _pattern) => {
    const transformedBlocks = getPatternTransformedBlocks(selectedBlocks, _pattern.blocks);

    if (transformedBlocks) {
      accumulator.push({ ..._pattern,
        transformedBlocks
      });
    }

    return accumulator;
  }, []), [patterns, selectedBlocks]);
};

/* harmony default export */ var use_transformed_patterns = (useTransformedPatterns);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-switcher/pattern-transformations-menu.js



/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */




function PatternTransformationsMenu(_ref) {
  let {
    blocks,
    patterns: statePatterns,
    onSelect
  } = _ref;
  const [showTransforms, setShowTransforms] = (0,external_wp_element_namespaceObject.useState)(false);
  const patterns = use_transformed_patterns(statePatterns, blocks);
  if (!patterns.length) return null;
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuGroup, {
    className: "block-editor-block-switcher__pattern__transforms__menugroup"
  }, showTransforms && (0,external_wp_element_namespaceObject.createElement)(PreviewPatternsPopover, {
    patterns: patterns,
    onSelect: onSelect
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuItem, {
    onClick: event => {
      event.preventDefault();
      setShowTransforms(!showTransforms);
    },
    icon: chevron_right
  }, (0,external_wp_i18n_namespaceObject.__)('Patterns')));
}

function PreviewPatternsPopover(_ref2) {
  let {
    patterns,
    onSelect
  } = _ref2;
  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-block-switcher__popover__preview__parent"
  }, (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-block-switcher__popover__preview__container"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Popover, {
    className: "block-editor-block-switcher__preview__popover",
    position: "bottom right"
  }, (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-block-switcher__preview"
  }, (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-block-switcher__preview-title"
  }, (0,external_wp_i18n_namespaceObject.__)('Preview')), (0,external_wp_element_namespaceObject.createElement)(BlockPatternsList, {
    patterns: patterns,
    onSelect: onSelect
  })))));
}

function BlockPatternsList(_ref3) {
  let {
    patterns,
    onSelect
  } = _ref3;
  const composite = (0,external_wp_components_namespaceObject.__unstableUseCompositeState)();
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__unstableComposite, _extends({}, composite, {
    role: "listbox",
    className: "block-editor-block-switcher__preview-patterns-container",
    "aria-label": (0,external_wp_i18n_namespaceObject.__)('Patterns list')
  }), patterns.map(pattern => (0,external_wp_element_namespaceObject.createElement)(pattern_transformations_menu_BlockPattern, {
    key: pattern.name,
    pattern: pattern,
    onSelect: onSelect,
    composite: composite
  })));
}

function pattern_transformations_menu_BlockPattern(_ref4) {
  let {
    pattern,
    onSelect,
    composite
  } = _ref4;
  // TODO check pattern/preview width...
  const baseClassName = 'block-editor-block-switcher__preview-patterns-container';
  const descriptionId = (0,external_wp_compose_namespaceObject.useInstanceId)(pattern_transformations_menu_BlockPattern, `${baseClassName}-list__item-description`);
  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: `${baseClassName}-list__list-item`,
    "aria-label": pattern.title,
    "aria-describedby": pattern.description ? descriptionId : undefined
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__unstableCompositeItem, _extends({
    role: "option",
    as: "div"
  }, composite, {
    className: `${baseClassName}-list__item`,
    onClick: () => onSelect(pattern.transformedBlocks)
  }), (0,external_wp_element_namespaceObject.createElement)(block_preview, {
    blocks: pattern.transformedBlocks,
    viewportWidth: pattern.viewportWidth || 500
  }), (0,external_wp_element_namespaceObject.createElement)("div", {
    className: `${baseClassName}-list__item-title`
  }, pattern.title)), !!pattern.description && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.VisuallyHidden, {
    id: descriptionId
  }, pattern.description));
}

/* harmony default export */ var pattern_transformations_menu = (PatternTransformationsMenu);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-switcher/index.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */








const BlockSwitcherDropdownMenu = _ref => {
  let {
    clientIds,
    blocks
  } = _ref;
  const {
    replaceBlocks
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const blockInformation = useBlockDisplayInformation(blocks[0].clientId);
  const {
    possibleBlockTransformations,
    canRemove,
    hasBlockStyles,
    icon,
    blockTitle,
    patterns
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    var _getBlockType2;

    const {
      getBlockRootClientId,
      getBlockTransformItems,
      __experimentalGetPatternTransformItems
    } = select(store);
    const {
      getBlockStyles,
      getBlockType
    } = select(external_wp_blocks_namespaceObject.store);
    const {
      canRemoveBlocks
    } = select(store);
    const rootClientId = getBlockRootClientId((0,external_lodash_namespaceObject.castArray)(clientIds)[0]);
    const [{
      name: firstBlockName
    }] = blocks;

    const _isSingleBlockSelected = blocks.length === 1;

    const styles = _isSingleBlockSelected && getBlockStyles(firstBlockName);

    let _icon;

    if (_isSingleBlockSelected) {
      _icon = blockInformation === null || blockInformation === void 0 ? void 0 : blockInformation.icon; // Take into account active block variations.
    } else {
      var _getBlockType;

      const isSelectionOfSameType = (0,external_lodash_namespaceObject.uniq)(blocks.map(_ref2 => {
        let {
          name
        } = _ref2;
        return name;
      })).length === 1; // When selection consists of blocks of multiple types, display an
      // appropriate icon to communicate the non-uniformity.

      _icon = isSelectionOfSameType ? (_getBlockType = getBlockType(firstBlockName)) === null || _getBlockType === void 0 ? void 0 : _getBlockType.icon : library_stack;
    }

    return {
      possibleBlockTransformations: getBlockTransformItems(blocks, rootClientId),
      canRemove: canRemoveBlocks(clientIds, rootClientId),
      hasBlockStyles: !!(styles !== null && styles !== void 0 && styles.length),
      icon: _icon,
      blockTitle: (_getBlockType2 = getBlockType(firstBlockName)) === null || _getBlockType2 === void 0 ? void 0 : _getBlockType2.title,
      patterns: __experimentalGetPatternTransformItems(blocks, rootClientId)
    };
  }, [clientIds, blocks, blockInformation === null || blockInformation === void 0 ? void 0 : blockInformation.icon]);
  const isReusable = blocks.length === 1 && (0,external_wp_blocks_namespaceObject.isReusableBlock)(blocks[0]);
  const isTemplate = blocks.length === 1 && (0,external_wp_blocks_namespaceObject.isTemplatePart)(blocks[0]); // Simple block tranformation based on the `Block Transforms` API.

  const onBlockTransform = name => replaceBlocks(clientIds, (0,external_wp_blocks_namespaceObject.switchToBlockType)(blocks, name)); // Pattern transformation through the `Patterns` API.


  const onPatternTransform = transformedBlocks => replaceBlocks(clientIds, transformedBlocks);

  const hasPossibleBlockTransformations = !!possibleBlockTransformations.length && canRemove;
  const hasPatternTransformation = !!(patterns !== null && patterns !== void 0 && patterns.length) && canRemove;

  if (!hasBlockStyles && !hasPossibleBlockTransformations) {
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarGroup, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarButton, {
      disabled: true,
      className: "block-editor-block-switcher__no-switcher-icon",
      title: blockTitle,
      icon: (0,external_wp_element_namespaceObject.createElement)(block_icon, {
        icon: icon,
        showColors: true
      })
    }));
  }

  const blockSwitcherLabel = blockTitle;
  const blockSwitcherDescription = 1 === blocks.length ? (0,external_wp_i18n_namespaceObject.sprintf)(
  /* translators: %s: block title. */
  (0,external_wp_i18n_namespaceObject.__)('%s: Change block type or style'), blockTitle) : (0,external_wp_i18n_namespaceObject.sprintf)(
  /* translators: %d: number of blocks. */
  (0,external_wp_i18n_namespaceObject._n)('Change type of %d block', 'Change type of %d blocks', blocks.length), blocks.length);
  const showDropDown = hasBlockStyles || hasPossibleBlockTransformations || hasPatternTransformation;
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarGroup, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarItem, null, toggleProps => (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.DropdownMenu, {
    className: "block-editor-block-switcher",
    label: blockSwitcherLabel,
    popoverProps: {
      position: 'bottom right',
      isAlternate: true,
      className: 'block-editor-block-switcher__popover'
    },
    icon: (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(block_icon, {
      icon: icon,
      className: "block-editor-block-switcher__toggle",
      showColors: true
    }), (isReusable || isTemplate) && (0,external_wp_element_namespaceObject.createElement)("span", {
      className: "block-editor-block-switcher__toggle-text"
    }, (0,external_wp_element_namespaceObject.createElement)(BlockTitle, {
      clientId: clientIds,
      maximumLength: 35
    }))),
    toggleProps: {
      describedBy: blockSwitcherDescription,
      ...toggleProps
    },
    menuProps: {
      orientation: 'both'
    }
  }, _ref3 => {
    let {
      onClose
    } = _ref3;
    return showDropDown && (0,external_wp_element_namespaceObject.createElement)("div", {
      className: "block-editor-block-switcher__container"
    }, hasPatternTransformation && (0,external_wp_element_namespaceObject.createElement)(pattern_transformations_menu, {
      blocks: blocks,
      patterns: patterns,
      onSelect: transformedBlocks => {
        onPatternTransform(transformedBlocks);
        onClose();
      }
    }), hasPossibleBlockTransformations && (0,external_wp_element_namespaceObject.createElement)(block_transformations_menu, {
      className: "block-editor-block-switcher__transforms__menugroup",
      possibleBlockTransformations: possibleBlockTransformations,
      blocks: blocks,
      onSelect: name => {
        onBlockTransform(name);
        onClose();
      }
    }), hasBlockStyles && (0,external_wp_element_namespaceObject.createElement)(BlockStylesMenu, {
      hoveredBlock: blocks[0],
      onSwitch: onClose
    }));
  })));
};
const BlockSwitcher = _ref4 => {
  let {
    clientIds
  } = _ref4;
  const blocks = (0,external_wp_data_namespaceObject.useSelect)(select => select(store).getBlocksByClientId(clientIds), [clientIds]);

  if (!blocks.length || blocks.some(block => !block)) {
    return null;
  }

  return (0,external_wp_element_namespaceObject.createElement)(BlockSwitcherDropdownMenu, {
    clientIds: clientIds,
    blocks: blocks
  });
};
/* harmony default export */ var block_switcher = (BlockSwitcher);

;// CONCATENATED MODULE: ./packages/icons/build-module/library/more-vertical.js


/**
 * WordPress dependencies
 */

const moreVertical = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M13 19h-2v-2h2v2zm0-6h-2v-2h2v2zm0-6h-2V5h2v2z"
}));
/* harmony default export */ var more_vertical = (moreVertical);

;// CONCATENATED MODULE: external ["wp","blob"]
var external_wp_blob_namespaceObject = window["wp"]["blob"];
;// CONCATENATED MODULE: ./packages/block-editor/build-module/utils/pasting.js
/**
 * WordPress dependencies
 */


function getPasteEventData(_ref) {
  let {
    clipboardData
  } = _ref;
  let plainText = '';
  let html = ''; // IE11 only supports `Text` as an argument for `getData` and will
  // otherwise throw an invalid argument error, so we try the standard
  // arguments first, then fallback to `Text` if they fail.

  try {
    plainText = clipboardData.getData('text/plain');
    html = clipboardData.getData('text/html');
  } catch (error1) {
    try {
      html = clipboardData.getData('Text');
    } catch (error2) {
      // Some browsers like UC Browser paste plain text by default and
      // don't support clipboardData at all, so allow default
      // behaviour.
      return;
    }
  }

  const files = (0,external_wp_dom_namespaceObject.getFilesFromDataTransfer)(clipboardData).filter(_ref2 => {
    let {
      type
    } = _ref2;
    return /^image\/(?:jpe?g|png|gif|webp)$/.test(type);
  });

  if (files.length && !shouldDismissPastedFiles(files, html, plainText)) {
    html = files.map(file => `<img src="${(0,external_wp_blob_namespaceObject.createBlobURL)(file)}">`).join('');
    plainText = '';
  }

  return {
    html,
    plainText
  };
}
/**
 * Given a collection of DataTransfer files and HTML and plain text strings,
 * determine whether the files are to be dismissed in favor of the HTML.
 *
 * Certain office-type programs, like Microsoft Word or Apple Numbers,
 * will, upon copy, generate a screenshot of the content being copied and
 * attach it to the clipboard alongside the actual rich text that the user
 * sought to copy. In those cases, we should let Gutenberg handle the rich text
 * content and not the screenshot, since this allows Gutenberg to insert
 * meaningful blocks, like paragraphs, lists or even tables.
 *
 * @param {File[]} files File objects obtained from a paste event
 * @param {string} html  HTML content obtained from a paste event
 * @return {boolean}     True if the files should be dismissed
 */

function shouldDismissPastedFiles(files, html
/*, plainText */
) {
  // The question is only relevant when there is actual HTML content and when
  // there is exactly one image file.
  if (html && (files === null || files === void 0 ? void 0 : files.length) === 1 && files[0].type.indexOf('image/') === 0) {
    var _html$match;

    // A single <img> tag found in the HTML source suggests that the
    // content being pasted revolves around an image. Sometimes there are
    // other elements found, like <figure>, but we assume that the user's
    // intention is to paste the actual image file.
    const IMAGE_TAG = /<\s*img\b/gi;
    return ((_html$match = html.match(IMAGE_TAG)) === null || _html$match === void 0 ? void 0 : _html$match.length) !== 1;
  }

  return false;
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/copy-handler/index.js


/**
 * WordPress dependencies
 */







/**
 * Internal dependencies
 */



function useNotifyCopy() {
  const {
    getBlockName
  } = (0,external_wp_data_namespaceObject.useSelect)(store);
  const {
    getBlockType
  } = (0,external_wp_data_namespaceObject.useSelect)(external_wp_blocks_namespaceObject.store);
  const {
    createSuccessNotice
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
  return (0,external_wp_element_namespaceObject.useCallback)((eventType, selectedBlockClientIds) => {
    let notice = '';

    if (selectedBlockClientIds.length === 1) {
      var _getBlockType;

      const clientId = selectedBlockClientIds[0];
      const title = (_getBlockType = getBlockType(getBlockName(clientId))) === null || _getBlockType === void 0 ? void 0 : _getBlockType.title;
      notice = eventType === 'copy' ? (0,external_wp_i18n_namespaceObject.sprintf)( // Translators: Name of the block being copied, e.g. "Paragraph".
      (0,external_wp_i18n_namespaceObject.__)('Copied "%s" to clipboard.'), title) : (0,external_wp_i18n_namespaceObject.sprintf)( // Translators: Name of the block being cut, e.g. "Paragraph".
      (0,external_wp_i18n_namespaceObject.__)('Moved "%s" to clipboard.'), title);
    } else {
      notice = eventType === 'copy' ? (0,external_wp_i18n_namespaceObject.sprintf)( // Translators: %d: Number of blocks being copied.
      (0,external_wp_i18n_namespaceObject._n)('Copied %d block to clipboard.', 'Copied %d blocks to clipboard.', selectedBlockClientIds.length), selectedBlockClientIds.length) : (0,external_wp_i18n_namespaceObject.sprintf)( // Translators: %d: Number of blocks being cut.
      (0,external_wp_i18n_namespaceObject._n)('Moved %d block to clipboard.', 'Moved %d blocks to clipboard.', selectedBlockClientIds.length), selectedBlockClientIds.length);
    }

    createSuccessNotice(notice, {
      type: 'snackbar'
    });
  }, []);
}
function useClipboardHandler() {
  const {
    getBlocksByClientId,
    getSelectedBlockClientIds,
    hasMultiSelection,
    getSettings
  } = (0,external_wp_data_namespaceObject.useSelect)(store);
  const {
    flashBlock,
    removeBlocks,
    replaceBlocks
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const notifyCopy = useNotifyCopy();
  return (0,external_wp_compose_namespaceObject.useRefEffect)(node => {
    function handler(event) {
      const selectedBlockClientIds = getSelectedBlockClientIds();

      if (selectedBlockClientIds.length === 0) {
        return;
      } // Always handle multiple selected blocks.


      if (!hasMultiSelection()) {
        const {
          target
        } = event;
        const {
          ownerDocument
        } = target; // If copying, only consider actual text selection as selection.
        // Otherwise, any focus on an input field is considered.

        const hasSelection = event.type === 'copy' || event.type === 'cut' ? (0,external_wp_dom_namespaceObject.documentHasUncollapsedSelection)(ownerDocument) : (0,external_wp_dom_namespaceObject.documentHasSelection)(ownerDocument); // Let native copy behaviour take over in input fields.

        if (hasSelection) {
          return;
        }
      }

      if (!node.contains(event.target.ownerDocument.activeElement)) {
        return;
      }

      const eventDefaultPrevented = event.defaultPrevented;
      event.preventDefault();

      if (event.type === 'copy' || event.type === 'cut') {
        if (selectedBlockClientIds.length === 1) {
          flashBlock(selectedBlockClientIds[0]);
        }

        notifyCopy(event.type, selectedBlockClientIds);
        const blocks = getBlocksByClientId(selectedBlockClientIds);
        const serialized = (0,external_wp_blocks_namespaceObject.serialize)(blocks);
        event.clipboardData.setData('text/plain', serialized);
        event.clipboardData.setData('text/html', serialized);
      }

      if (event.type === 'cut') {
        removeBlocks(selectedBlockClientIds);
      } else if (event.type === 'paste') {
        if (eventDefaultPrevented) {
          // This was likely already handled in rich-text/use-paste-handler.js.
          return;
        }

        const {
          __experimentalCanUserUseUnfilteredHTML: canUserUseUnfilteredHTML
        } = getSettings();
        const {
          plainText,
          html
        } = getPasteEventData(event);
        const blocks = (0,external_wp_blocks_namespaceObject.pasteHandler)({
          HTML: html,
          plainText,
          mode: 'BLOCKS',
          canUserUseUnfilteredHTML
        });
        replaceBlocks(selectedBlockClientIds, blocks, blocks.length - 1, -1);
      }
    }

    node.ownerDocument.addEventListener('copy', handler);
    node.ownerDocument.addEventListener('cut', handler);
    node.ownerDocument.addEventListener('paste', handler);
    return () => {
      node.ownerDocument.removeEventListener('copy', handler);
      node.ownerDocument.removeEventListener('cut', handler);
      node.ownerDocument.removeEventListener('paste', handler);
    };
  }, []);
}

function CopyHandler(_ref) {
  let {
    children
  } = _ref;
  return (0,external_wp_element_namespaceObject.createElement)("div", {
    ref: useClipboardHandler()
  }, children);
}

/* harmony default export */ var copy_handler = (CopyHandler);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-actions/index.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



function BlockActions(_ref) {
  let {
    clientIds,
    children,
    __experimentalUpdateSelection: updateSelection
  } = _ref;
  const {
    canInsertBlockType,
    getBlockRootClientId,
    getBlocksByClientId,
    canMoveBlocks,
    canRemoveBlocks
  } = (0,external_wp_data_namespaceObject.useSelect)(store);
  const {
    getDefaultBlockName,
    getGroupingBlockName
  } = (0,external_wp_data_namespaceObject.useSelect)(external_wp_blocks_namespaceObject.store);
  const blocks = getBlocksByClientId(clientIds);
  const rootClientId = getBlockRootClientId(clientIds[0]);
  const canDuplicate = (0,external_lodash_namespaceObject.every)(blocks, block => {
    return !!block && (0,external_wp_blocks_namespaceObject.hasBlockSupport)(block.name, 'multiple', true) && canInsertBlockType(block.name, rootClientId);
  });
  const canInsertDefaultBlock = canInsertBlockType(getDefaultBlockName(), rootClientId);
  const canMove = canMoveBlocks(clientIds, rootClientId);
  const canRemove = canRemoveBlocks(clientIds, rootClientId);
  const {
    removeBlocks,
    replaceBlocks,
    duplicateBlocks,
    insertAfterBlock,
    insertBeforeBlock,
    flashBlock,
    setBlockMovingClientId,
    setNavigationMode,
    selectBlock
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const notifyCopy = useNotifyCopy();
  return children({
    canDuplicate,
    canInsertDefaultBlock,
    canMove,
    canRemove,
    rootClientId,
    blocks,

    onDuplicate() {
      return duplicateBlocks(clientIds, updateSelection);
    },

    onRemove() {
      return removeBlocks(clientIds, updateSelection);
    },

    onInsertBefore() {
      insertBeforeBlock((0,external_lodash_namespaceObject.first)((0,external_lodash_namespaceObject.castArray)(clientIds)));
    },

    onInsertAfter() {
      insertAfterBlock((0,external_lodash_namespaceObject.last)((0,external_lodash_namespaceObject.castArray)(clientIds)));
    },

    onMoveTo() {
      setNavigationMode(true);
      selectBlock(clientIds[0]);
      setBlockMovingClientId(clientIds[0]);
    },

    onGroup() {
      if (!blocks.length) {
        return;
      }

      const groupingBlockName = getGroupingBlockName(); // Activate the `transform` on `core/group` which does the conversion.

      const newBlocks = (0,external_wp_blocks_namespaceObject.switchToBlockType)(blocks, groupingBlockName);

      if (!newBlocks) {
        return;
      }

      replaceBlocks(clientIds, newBlocks);
    },

    onUngroup() {
      if (!blocks.length) {
        return;
      }

      const innerBlocks = blocks[0].innerBlocks;

      if (!innerBlocks.length) {
        return;
      }

      replaceBlocks(clientIds, innerBlocks);
    },

    onCopy() {
      const selectedBlockClientIds = blocks.map(_ref2 => {
        let {
          clientId
        } = _ref2;
        return clientId;
      });

      if (blocks.length === 1) {
        flashBlock(selectedBlockClientIds[0]);
      }

      notifyCopy('copy', selectedBlockClientIds);
    }

  });
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-settings-menu/block-mode-toggle.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */


function BlockModeToggle(_ref) {
  let {
    blockType,
    mode,
    onToggleMode,
    small = false,
    isCodeEditingEnabled = true
  } = _ref;

  if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, 'html', true) || !isCodeEditingEnabled) {
    return null;
  }

  const label = mode === 'visual' ? (0,external_wp_i18n_namespaceObject.__)('Edit as HTML') : (0,external_wp_i18n_namespaceObject.__)('Edit visually');
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuItem, {
    onClick: onToggleMode
  }, !small && label);
}
/* harmony default export */ var block_mode_toggle = ((0,external_wp_compose_namespaceObject.compose)([(0,external_wp_data_namespaceObject.withSelect)((select, _ref2) => {
  let {
    clientId
  } = _ref2;
  const {
    getBlock,
    getBlockMode,
    getSettings
  } = select(store);
  const block = getBlock(clientId);
  const isCodeEditingEnabled = getSettings().codeEditingEnabled;
  return {
    mode: getBlockMode(clientId),
    blockType: block ? (0,external_wp_blocks_namespaceObject.getBlockType)(block.name) : null,
    isCodeEditingEnabled
  };
}), (0,external_wp_data_namespaceObject.withDispatch)((dispatch, _ref3) => {
  let {
    onToggle = external_lodash_namespaceObject.noop,
    clientId
  } = _ref3;
  return {
    onToggleMode() {
      dispatch(store).toggleBlockMode(clientId);
      onToggle();
    }

  };
})])(BlockModeToggle));

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-settings-menu/block-convert-button.js


/**
 * WordPress dependencies
 */


function BlockConvertButton(_ref) {
  let {
    shouldRender,
    onClick,
    small
  } = _ref;

  if (!shouldRender) {
    return null;
  }

  const label = (0,external_wp_i18n_namespaceObject.__)('Convert to Blocks');

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuItem, {
    onClick: onClick
  }, !small && label);
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-settings-menu/block-html-convert-button.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



/* harmony default export */ var block_html_convert_button = ((0,external_wp_compose_namespaceObject.compose)((0,external_wp_data_namespaceObject.withSelect)((select, _ref) => {
  let {
    clientId
  } = _ref;
  const block = select(store).getBlock(clientId);
  return {
    block,
    shouldRender: block && block.name === 'core/html'
  };
}), (0,external_wp_data_namespaceObject.withDispatch)((dispatch, _ref2) => {
  let {
    block
  } = _ref2;
  return {
    onClick: () => dispatch(store).replaceBlocks(block.clientId, (0,external_wp_blocks_namespaceObject.rawHandler)({
      HTML: (0,external_wp_blocks_namespaceObject.getBlockContent)(block)
    }))
  };
}))(BlockConvertButton));

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-settings-menu/block-settings-menu-first-item.js
/**
 * WordPress dependencies
 */

const {
  Fill: __unstableBlockSettingsMenuFirstItem,
  Slot: block_settings_menu_first_item_Slot
} = (0,external_wp_components_namespaceObject.createSlotFill)('__unstableBlockSettingsMenuFirstItem');
__unstableBlockSettingsMenuFirstItem.Slot = block_settings_menu_first_item_Slot;
/* harmony default export */ var block_settings_menu_first_item = (__unstableBlockSettingsMenuFirstItem);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/convert-to-group-buttons/index.js


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */




function ConvertToGroupButton(_ref) {
  let {
    clientIds,
    isGroupable,
    isUngroupable,
    blocksSelection,
    groupingBlockName,
    onClose = () => {}
  } = _ref;
  const {
    replaceBlocks
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);

  const onConvertToGroup = () => {
    // Activate the `transform` on the Grouping Block which does the conversion.
    const newBlocks = (0,external_wp_blocks_namespaceObject.switchToBlockType)(blocksSelection, groupingBlockName);

    if (newBlocks) {
      replaceBlocks(clientIds, newBlocks);
    }
  };

  const onConvertFromGroup = () => {
    const innerBlocks = blocksSelection[0].innerBlocks;

    if (!innerBlocks.length) {
      return;
    }

    replaceBlocks(clientIds, innerBlocks);
  };

  if (!isGroupable && !isUngroupable) {
    return null;
  }

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, isGroupable && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuItem, {
    onClick: () => {
      onConvertToGroup();
      onClose();
    }
  }, (0,external_wp_i18n_namespaceObject._x)('Group', 'verb')), isUngroupable && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuItem, {
    onClick: () => {
      onConvertFromGroup();
      onClose();
    }
  }, (0,external_wp_i18n_namespaceObject._x)('Ungroup', 'Ungrouping blocks from within a Group block back into individual blocks within the Editor ')));
}



;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/convert-to-group-buttons/use-convert-to-group-button-props.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Contains the properties `ConvertToGroupButton` component needs.
 *
 * @typedef {Object} ConvertToGroupButtonProps
 * @property {string[]}  clientIds         An array of the selected client ids.
 * @property {boolean}   isGroupable       Indicates if the selected blocks can be grouped.
 * @property {boolean}   isUngroupable     Indicates if the selected blocks can be ungrouped.
 * @property {WPBlock[]} blocksSelection   An array of the selected blocks.
 * @property {string}    groupingBlockName The name of block used for handling grouping interactions.
 */

/**
 * Returns the properties `ConvertToGroupButton` component needs to work properly.
 * It is used in `BlockSettingsMenuControls` to know if `ConvertToGroupButton`
 * should be rendered, to avoid ending up with an empty MenuGroup.
 *
 * @return {ConvertToGroupButtonProps} Returns the properties needed by `ConvertToGroupButton`.
 */

function useConvertToGroupButtonProps() {
  const {
    clientIds,
    isGroupable,
    isUngroupable,
    blocksSelection,
    groupingBlockName
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    var _blocksSelection$;

    const {
      getBlockRootClientId,
      getBlocksByClientId,
      canInsertBlockType,
      getSelectedBlockClientIds
    } = select(store);
    const {
      getGroupingBlockName
    } = select(external_wp_blocks_namespaceObject.store);

    const _clientIds = getSelectedBlockClientIds();

    const _groupingBlockName = getGroupingBlockName();

    const rootClientId = !!(_clientIds !== null && _clientIds !== void 0 && _clientIds.length) ? getBlockRootClientId(_clientIds[0]) : undefined;
    const groupingBlockAvailable = canInsertBlockType(_groupingBlockName, rootClientId);

    const _blocksSelection = getBlocksByClientId(_clientIds);

    const isSingleGroupingBlock = _blocksSelection.length === 1 && ((_blocksSelection$ = _blocksSelection[0]) === null || _blocksSelection$ === void 0 ? void 0 : _blocksSelection$.name) === _groupingBlockName; // Do we have
    // 1. Grouping block available to be inserted?
    // 2. One or more blocks selected

    const _isGroupable = groupingBlockAvailable && _blocksSelection.length; // Do we have a single Group Block selected and does that group have inner blocks?


    const _isUngroupable = isSingleGroupingBlock && !!_blocksSelection[0].innerBlocks.length;

    return {
      clientIds: _clientIds,
      isGroupable: _isGroupable,
      isUngroupable: _isUngroupable,
      blocksSelection: _blocksSelection,
      groupingBlockName: _groupingBlockName
    };
  }, []);
  return {
    clientIds,
    isGroupable,
    isUngroupable,
    blocksSelection,
    groupingBlockName
  };
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-settings-menu-controls/index.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



const {
  Fill,
  Slot: block_settings_menu_controls_Slot
} = (0,external_wp_components_namespaceObject.createSlotFill)('BlockSettingsMenuControls');

const BlockSettingsMenuControlsSlot = _ref => {
  let {
    fillProps,
    clientIds = null
  } = _ref;
  const {
    selectedBlocks,
    selectedClientIds
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getBlocksByClientId,
      getSelectedBlockClientIds
    } = select(store);
    const ids = clientIds !== null ? clientIds : getSelectedBlockClientIds();
    return {
      selectedBlocks: (0,external_lodash_namespaceObject.map)((0,external_lodash_namespaceObject.compact)(getBlocksByClientId(ids)), block => block.name),
      selectedClientIds: ids
    };
  }, [clientIds]); // Check if current selection of blocks is Groupable or Ungroupable
  // and pass this props down to ConvertToGroupButton.

  const convertToGroupButtonProps = useConvertToGroupButtonProps();
  const {
    isGroupable,
    isUngroupable
  } = convertToGroupButtonProps;
  const showConvertToGroupButton = isGroupable || isUngroupable;
  return (0,external_wp_element_namespaceObject.createElement)(block_settings_menu_controls_Slot, {
    fillProps: { ...fillProps,
      selectedBlocks,
      selectedClientIds
    }
  }, fills => {
    if ((fills === null || fills === void 0 ? void 0 : fills.length) > 0 || showConvertToGroupButton) {
      return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuGroup, null, fills, (0,external_wp_element_namespaceObject.createElement)(ConvertToGroupButton, _extends({}, convertToGroupButtonProps, {
        onClose: fillProps === null || fillProps === void 0 ? void 0 : fillProps.onClose
      })));
    }
  });
};
/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/block-settings-menu-controls/README.md
 *
 * @param {Object} props Fill props.
 * @return {WPElement} Element.
 */


function BlockSettingsMenuControls(_ref2) {
  let { ...props
  } = _ref2;
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalStyleProvider, {
    document: document
  }, (0,external_wp_element_namespaceObject.createElement)(Fill, props));
}

BlockSettingsMenuControls.Slot = BlockSettingsMenuControlsSlot;
/* harmony default export */ var block_settings_menu_controls = (BlockSettingsMenuControls);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-settings-menu/block-settings-dropdown.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */









/**
 * Internal dependencies
 */








const block_settings_dropdown_POPOVER_PROPS = {
  className: 'block-editor-block-settings-menu__popover',
  position: 'bottom right',
  isAlternate: true
};

function CopyMenuItem(_ref) {
  let {
    blocks,
    onCopy
  } = _ref;
  const ref = (0,external_wp_compose_namespaceObject.useCopyToClipboard)(() => (0,external_wp_blocks_namespaceObject.serialize)(blocks), onCopy);
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuItem, {
    ref: ref
  }, (0,external_wp_i18n_namespaceObject.__)('Copy'));
}

function BlockSettingsDropdown(_ref2) {
  let {
    clientIds,
    __experimentalSelectBlock,
    children,
    ...props
  } = _ref2;
  const blockClientIds = (0,external_lodash_namespaceObject.castArray)(clientIds);
  const count = blockClientIds.length;
  const firstBlockClientId = blockClientIds[0];
  const {
    onlyBlock
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getBlockCount
    } = select(store);
    return {
      onlyBlock: 1 === getBlockCount()
    };
  }, [firstBlockClientId]);
  const shortcuts = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getShortcutRepresentation
    } = select(external_wp_keyboardShortcuts_namespaceObject.store);
    return {
      duplicate: getShortcutRepresentation('core/block-editor/duplicate'),
      remove: getShortcutRepresentation('core/block-editor/remove'),
      insertAfter: getShortcutRepresentation('core/block-editor/insert-after'),
      insertBefore: getShortcutRepresentation('core/block-editor/insert-before')
    };
  }, []);
  const updateSelection = (0,external_wp_element_namespaceObject.useCallback)(__experimentalSelectBlock ? async clientIdsPromise => {
    const ids = await clientIdsPromise;

    if (ids && ids[0]) {
      __experimentalSelectBlock(ids[0]);
    }
  } : external_lodash_namespaceObject.noop, [__experimentalSelectBlock]);
  const blockTitle = useBlockDisplayTitle(firstBlockClientId, 25);
  const label = (0,external_wp_i18n_namespaceObject.sprintf)(
  /* translators: %s: block name */
  (0,external_wp_i18n_namespaceObject.__)('Remove %s'), blockTitle);
  const removeBlockLabel = count === 1 ? label : (0,external_wp_i18n_namespaceObject.__)('Remove blocks');
  return (0,external_wp_element_namespaceObject.createElement)(BlockActions, {
    clientIds: clientIds,
    __experimentalUpdateSelection: !__experimentalSelectBlock
  }, _ref3 => {
    let {
      canDuplicate,
      canInsertDefaultBlock,
      canMove,
      canRemove,
      onDuplicate,
      onInsertAfter,
      onInsertBefore,
      onRemove,
      onCopy,
      onMoveTo,
      blocks
    } = _ref3;
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.DropdownMenu, _extends({
      icon: more_vertical,
      label: (0,external_wp_i18n_namespaceObject.__)('Options'),
      className: "block-editor-block-settings-menu",
      popoverProps: block_settings_dropdown_POPOVER_PROPS,
      noIcons: true
    }, props), _ref4 => {
      let {
        onClose
      } = _ref4;
      return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuGroup, null, (0,external_wp_element_namespaceObject.createElement)(block_settings_menu_first_item.Slot, {
        fillProps: {
          onClose
        }
      }), count === 1 && (0,external_wp_element_namespaceObject.createElement)(block_html_convert_button, {
        clientId: firstBlockClientId
      }), (0,external_wp_element_namespaceObject.createElement)(CopyMenuItem, {
        blocks: blocks,
        onCopy: onCopy
      }), canDuplicate && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuItem, {
        onClick: (0,external_lodash_namespaceObject.flow)(onClose, onDuplicate, updateSelection),
        shortcut: shortcuts.duplicate
      }, (0,external_wp_i18n_namespaceObject.__)('Duplicate')), canInsertDefaultBlock && (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuItem, {
        onClick: (0,external_lodash_namespaceObject.flow)(onClose, onInsertBefore),
        shortcut: shortcuts.insertBefore
      }, (0,external_wp_i18n_namespaceObject.__)('Insert before')), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuItem, {
        onClick: (0,external_lodash_namespaceObject.flow)(onClose, onInsertAfter),
        shortcut: shortcuts.insertAfter
      }, (0,external_wp_i18n_namespaceObject.__)('Insert after'))), canMove && !onlyBlock && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuItem, {
        onClick: (0,external_lodash_namespaceObject.flow)(onClose, onMoveTo)
      }, (0,external_wp_i18n_namespaceObject.__)('Move to')), count === 1 && (0,external_wp_element_namespaceObject.createElement)(block_mode_toggle, {
        clientId: firstBlockClientId,
        onToggle: onClose
      })), (0,external_wp_element_namespaceObject.createElement)(block_settings_menu_controls.Slot, {
        fillProps: {
          onClose
        },
        clientIds: clientIds
      }), typeof children === 'function' ? children({
        onClose
      }) : external_wp_element_namespaceObject.Children.map(child => (0,external_wp_element_namespaceObject.cloneElement)(child, {
        onClose
      })), canRemove && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuGroup, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuItem, {
        onClick: (0,external_lodash_namespaceObject.flow)(onClose, onRemove, updateSelection),
        shortcut: shortcuts.remove
      }, removeBlockLabel)));
    });
  });
}
/* harmony default export */ var block_settings_dropdown = (BlockSettingsDropdown);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-settings-menu/index.js



/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


function BlockSettingsMenu(_ref) {
  let {
    clientIds,
    ...props
  } = _ref;
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarGroup, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarItem, null, toggleProps => (0,external_wp_element_namespaceObject.createElement)(block_settings_dropdown, _extends({
    clientIds: clientIds,
    toggleProps: toggleProps
  }, props))));
}
/* harmony default export */ var block_settings_menu = (BlockSettingsMenu);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-toolbar/index.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */








function BlockToolbar(_ref) {
  let {
    hideDragHandle
  } = _ref;
  const {
    blockClientIds,
    blockClientId,
    blockType,
    hasFixedToolbar,
    hasReducedUI,
    isValid,
    isVisual
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getBlockName,
      getBlockMode,
      getSelectedBlockClientIds,
      isBlockValid,
      getBlockRootClientId,
      getSettings
    } = select(store);
    const selectedBlockClientIds = getSelectedBlockClientIds();
    const selectedBlockClientId = selectedBlockClientIds[0];
    const blockRootClientId = getBlockRootClientId(selectedBlockClientId);
    const settings = getSettings();
    return {
      blockClientIds: selectedBlockClientIds,
      blockClientId: selectedBlockClientId,
      blockType: selectedBlockClientId && (0,external_wp_blocks_namespaceObject.getBlockType)(getBlockName(selectedBlockClientId)),
      hasFixedToolbar: settings.hasFixedToolbar,
      hasReducedUI: settings.hasReducedUI,
      rootClientId: blockRootClientId,
      isValid: selectedBlockClientIds.every(id => isBlockValid(id)),
      isVisual: selectedBlockClientIds.every(id => getBlockMode(id) === 'visual')
    };
  }, []); // Handles highlighting the current block outline on hover or focus of the
  // block type toolbar area.

  const {
    toggleBlockHighlight
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const nodeRef = (0,external_wp_element_namespaceObject.useRef)();
  const {
    showMovers,
    gestures: showMoversGestures
  } = useShowMoversGestures({
    ref: nodeRef,

    onChange(isFocused) {
      if (isFocused && hasReducedUI) {
        return;
      }

      toggleBlockHighlight(blockClientId, isFocused);
    }

  }); // Account for the cases where the block toolbar is rendered within the
  // header area and not contextually to the block.

  const displayHeaderToolbar = (0,external_wp_compose_namespaceObject.useViewportMatch)('medium', '<') || hasFixedToolbar;

  if (blockType) {
    if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, '__experimentalToolbar', true)) {
      return null;
    }
  }

  const shouldShowMovers = displayHeaderToolbar || showMovers;

  if (blockClientIds.length === 0) {
    return null;
  }

  const shouldShowVisualToolbar = isValid && isVisual;
  const isMultiToolbar = blockClientIds.length > 1;
  const classes = classnames_default()('block-editor-block-toolbar', shouldShowMovers && 'is-showing-movers');
  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: classes
  }, !isMultiToolbar && !displayHeaderToolbar && (0,external_wp_element_namespaceObject.createElement)(BlockParentSelector, {
    clientIds: blockClientIds
  }), (0,external_wp_element_namespaceObject.createElement)("div", _extends({
    ref: nodeRef
  }, showMoversGestures), (shouldShowVisualToolbar || isMultiToolbar) && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarGroup, {
    className: "block-editor-block-toolbar__block-controls"
  }, (0,external_wp_element_namespaceObject.createElement)(block_switcher, {
    clientIds: blockClientIds
  }), (0,external_wp_element_namespaceObject.createElement)(block_mover, {
    clientIds: blockClientIds,
    hideDragHandle: hideDragHandle || hasReducedUI
  }))), shouldShowVisualToolbar && (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(block_controls.Slot, {
    group: "parent",
    className: "block-editor-block-toolbar__slot"
  }), (0,external_wp_element_namespaceObject.createElement)(block_controls.Slot, {
    group: "block",
    className: "block-editor-block-toolbar__slot"
  }), (0,external_wp_element_namespaceObject.createElement)(block_controls.Slot, {
    className: "block-editor-block-toolbar__slot"
  }), (0,external_wp_element_namespaceObject.createElement)(block_controls.Slot, {
    group: "inline",
    className: "block-editor-block-toolbar__slot"
  }), (0,external_wp_element_namespaceObject.createElement)(block_controls.Slot, {
    group: "other",
    className: "block-editor-block-toolbar__slot"
  })), (0,external_wp_element_namespaceObject.createElement)(block_settings_menu, {
    clientIds: blockClientIds
  }));
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-tools/block-contextual-toolbar.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */





function BlockContextualToolbar(_ref) {
  let {
    focusOnMount,
    isFixed,
    ...props
  } = _ref;
  const {
    blockType,
    hasParents,
    showParentSelector
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getBlockName,
      getBlockParents,
      getSelectedBlockClientIds
    } = select(store);
    const {
      getBlockType
    } = select(external_wp_blocks_namespaceObject.store);
    const selectedBlockClientIds = getSelectedBlockClientIds();
    const selectedBlockClientId = selectedBlockClientIds[0];
    const parents = getBlockParents(selectedBlockClientId);
    const firstParentClientId = parents[parents.length - 1];
    const parentBlockName = getBlockName(firstParentClientId);
    const parentBlockType = getBlockType(parentBlockName);
    return {
      blockType: selectedBlockClientId && getBlockType(getBlockName(selectedBlockClientId)),
      hasParents: parents.length,
      showParentSelector: (0,external_wp_blocks_namespaceObject.hasBlockSupport)(parentBlockType, '__experimentalParentSelector', true) && selectedBlockClientIds.length <= 1
    };
  }, []);

  if (blockType) {
    if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, '__experimentalToolbar', true)) {
      return null;
    }
  } // Shifts the toolbar to make room for the parent block selector.


  const classes = classnames_default()('block-editor-block-contextual-toolbar', {
    'has-parent': hasParents && showParentSelector,
    'is-fixed': isFixed
  });
  return (0,external_wp_element_namespaceObject.createElement)(navigable_toolbar, _extends({
    focusOnMount: focusOnMount,
    className: classes
    /* translators: accessibility text for the block toolbar */
    ,
    "aria-label": (0,external_wp_i18n_namespaceObject.__)('Block tools')
  }, props), (0,external_wp_element_namespaceObject.createElement)(BlockToolbar, {
    hideDragHandle: isFixed
  }));
}

/* harmony default export */ var block_contextual_toolbar = (BlockContextualToolbar);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-tools/block-popover.js


/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */








/**
 * Internal dependencies
 */








function block_popover_selector(select) {
  const {
    isNavigationMode,
    isMultiSelecting,
    hasMultiSelection,
    isTyping,
    isCaretWithinFormattedText,
    getSettings,
    getLastMultiSelectedBlockClientId
  } = select(store);
  return {
    isNavigationMode: isNavigationMode(),
    isMultiSelecting: isMultiSelecting(),
    isTyping: isTyping(),
    isCaretWithinFormattedText: isCaretWithinFormattedText(),
    hasMultiSelection: hasMultiSelection(),
    hasFixedToolbar: getSettings().hasFixedToolbar,
    lastClientId: getLastMultiSelectedBlockClientId()
  };
}

function BlockPopover(_ref) {
  let {
    clientId,
    rootClientId,
    isValid,
    isEmptyDefaultBlock,
    capturingClientId,
    __unstablePopoverSlot,
    __unstableContentRef
  } = _ref;
  const {
    isNavigationMode,
    isMultiSelecting,
    isTyping,
    isCaretWithinFormattedText,
    hasMultiSelection,
    hasFixedToolbar,
    lastClientId
  } = (0,external_wp_data_namespaceObject.useSelect)(block_popover_selector, []);
  const isInsertionPointVisible = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      isBlockInsertionPointVisible,
      getBlockInsertionPoint,
      getBlockOrder
    } = select(store);

    if (!isBlockInsertionPointVisible()) {
      return false;
    }

    const insertionPoint = getBlockInsertionPoint();
    const order = getBlockOrder(insertionPoint.rootClientId);
    return order[insertionPoint.index] === clientId;
  }, [clientId]);
  const isLargeViewport = (0,external_wp_compose_namespaceObject.useViewportMatch)('medium');
  const [isToolbarForced, setIsToolbarForced] = (0,external_wp_element_namespaceObject.useState)(false);
  const [isInserterShown, setIsInserterShown] = (0,external_wp_element_namespaceObject.useState)(false);
  const {
    stopTyping
  } = (0,external_wp_data_namespaceObject.useDispatch)(store); // Controls when the side inserter on empty lines should
  // be shown, including writing and selection modes.

  const showEmptyBlockSideInserter = !isTyping && !isNavigationMode && isEmptyDefaultBlock && isValid;
  const shouldShowBreadcrumb = isNavigationMode;
  const shouldShowContextualToolbar = !isNavigationMode && !hasFixedToolbar && isLargeViewport && !showEmptyBlockSideInserter && !isMultiSelecting && (!isTyping || isCaretWithinFormattedText);
  const canFocusHiddenToolbar = !isNavigationMode && !shouldShowContextualToolbar && !hasFixedToolbar && !isEmptyDefaultBlock;
  (0,external_wp_keyboardShortcuts_namespaceObject.useShortcut)('core/block-editor/focus-toolbar', () => {
    setIsToolbarForced(true);
    stopTyping(true);
  }, {
    isDisabled: !canFocusHiddenToolbar
  });
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (!shouldShowContextualToolbar) {
      setIsToolbarForced(false);
    }
  }, [shouldShowContextualToolbar]); // Stores the active toolbar item index so the block toolbar can return focus
  // to it when re-mounting.

  const initialToolbarItemIndexRef = (0,external_wp_element_namespaceObject.useRef)();
  const selectedElement = useBlockElement(clientId);
  const lastSelectedElement = useBlockElement(lastClientId);
  const capturingElement = useBlockElement(capturingClientId);
  const popoverScrollRef = usePopoverScroll(__unstableContentRef);

  if (!shouldShowBreadcrumb && !shouldShowContextualToolbar && !isToolbarForced && !showEmptyBlockSideInserter) {
    return null;
  }

  let node = selectedElement;

  if (!node) {
    return null;
  }

  if (capturingClientId) {
    node = capturingElement;
  }

  let anchorRef = node;

  if (hasMultiSelection) {
    // Wait to render the popover until the bottom reference is available
    // as well.
    if (!lastSelectedElement) {
      return null;
    }

    anchorRef = {
      top: node,
      bottom: lastSelectedElement
    };
  }

  function onFocus() {
    setIsInserterShown(true);
  }

  function onBlur() {
    setIsInserterShown(false);
  } // Position above the anchor, pop out towards the right, and position in the
  // left corner. For the side inserter, pop out towards the left, and
  // position in the right corner.
  // To do: refactor `Popover` to make this prop clearer.


  const popoverPosition = showEmptyBlockSideInserter ? 'top left right' : 'top right left';
  const {
    ownerDocument
  } = node;
  const stickyBoundaryElement = showEmptyBlockSideInserter ? undefined : // The sticky boundary element should be the boundary at which the
  // the block toolbar becomes sticky when the block scolls out of view.
  // In case of an iframe, this should be the iframe boundary, otherwise
  // the scroll container.
  ownerDocument.defaultView.frameElement || (0,external_wp_dom_namespaceObject.getScrollContainer)(node) || ownerDocument.body;
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Popover, {
    ref: popoverScrollRef,
    noArrow: true,
    animate: false,
    position: popoverPosition,
    focusOnMount: false,
    anchorRef: anchorRef,
    className: classnames_default()('block-editor-block-list__block-popover', {
      'is-insertion-point-visible': isInsertionPointVisible
    }),
    __unstableStickyBoundaryElement: stickyBoundaryElement // Render in the old slot if needed for backward compatibility,
    // otherwise render in place (not in the the default popover slot).
    ,
    __unstableSlotName: __unstablePopoverSlot || null,
    __unstableBoundaryParent: true // Observe movement for block animations (especially horizontal).
    ,
    __unstableObserveElement: node,
    shouldAnchorIncludePadding: true // Used to safeguard sticky position behavior against cases where it would permanently
    // obscure specific sections of a block.
    ,
    __unstableEditorCanvasWrapper: __unstableContentRef === null || __unstableContentRef === void 0 ? void 0 : __unstableContentRef.current
  }, (shouldShowContextualToolbar || isToolbarForced) && (0,external_wp_element_namespaceObject.createElement)("div", {
    onFocus: onFocus,
    onBlur: onBlur // While ideally it would be enough to capture the
    // bubbling focus event from the Inserter, due to the
    // characteristics of click focusing of `button`s in
    // Firefox and Safari, it is not reliable.
    //
    // See: https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button#Clicking_and_focus
    ,
    tabIndex: -1,
    className: classnames_default()('block-editor-block-list__block-popover-inserter', {
      'is-visible': isInserterShown
    })
  }, (0,external_wp_element_namespaceObject.createElement)(inserter, {
    clientId: clientId,
    rootClientId: rootClientId,
    __experimentalIsQuick: true
  })), (shouldShowContextualToolbar || isToolbarForced) && (0,external_wp_element_namespaceObject.createElement)(block_contextual_toolbar // If the toolbar is being shown because of being forced
  // it should focus the toolbar right after the mount.
  , {
    focusOnMount: isToolbarForced,
    __experimentalInitialIndex: initialToolbarItemIndexRef.current,
    __experimentalOnIndexChange: index => {
      initialToolbarItemIndexRef.current = index;
    } // Resets the index whenever the active block changes so
    // this is not persisted. See https://github.com/WordPress/gutenberg/pull/25760#issuecomment-717906169
    ,
    key: clientId
  }), shouldShowBreadcrumb && (0,external_wp_element_namespaceObject.createElement)(block_selection_button, {
    clientId: clientId,
    rootClientId: rootClientId,
    blockElement: node
  }), showEmptyBlockSideInserter && (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-block-list__empty-block-inserter"
  }, (0,external_wp_element_namespaceObject.createElement)(inserter, {
    position: "bottom right",
    rootClientId: rootClientId,
    clientId: clientId,
    __experimentalIsQuick: true
  })));
}

function wrapperSelector(select) {
  const {
    getSelectedBlockClientId,
    getFirstMultiSelectedBlockClientId,
    getBlockRootClientId,
    getBlock,
    getBlockParents,
    __experimentalGetBlockListSettingsForBlocks
  } = select(store);
  const clientId = getSelectedBlockClientId() || getFirstMultiSelectedBlockClientId();

  if (!clientId) {
    return;
  }

  const {
    name,
    attributes = {},
    isValid
  } = getBlock(clientId) || {};
  const blockParentsClientIds = getBlockParents(clientId); // Get Block List Settings for all ancestors of the current Block clientId.

  const parentBlockListSettings = __experimentalGetBlockListSettingsForBlocks(blockParentsClientIds); // Get the clientId of the topmost parent with the capture toolbars setting.


  const capturingClientId = (0,external_lodash_namespaceObject.find)(blockParentsClientIds, parentClientId => {
    var _parentBlockListSetti;

    return (_parentBlockListSetti = parentBlockListSettings[parentClientId]) === null || _parentBlockListSetti === void 0 ? void 0 : _parentBlockListSetti.__experimentalCaptureToolbars;
  });
  return {
    clientId,
    rootClientId: getBlockRootClientId(clientId),
    name,
    isValid,
    isEmptyDefaultBlock: name && (0,external_wp_blocks_namespaceObject.isUnmodifiedDefaultBlock)({
      name,
      attributes
    }),
    capturingClientId
  };
}

function WrappedBlockPopover(_ref2) {
  let {
    __unstablePopoverSlot,
    __unstableContentRef
  } = _ref2;
  const selected = (0,external_wp_data_namespaceObject.useSelect)(wrapperSelector, []);

  if (!selected) {
    return null;
  }

  const {
    clientId,
    rootClientId,
    name,
    isValid,
    isEmptyDefaultBlock,
    capturingClientId
  } = selected;

  if (!name) {
    return null;
  }

  return (0,external_wp_element_namespaceObject.createElement)(BlockPopover, {
    clientId: clientId,
    rootClientId: rootClientId,
    isValid: isValid,
    isEmptyDefaultBlock: isEmptyDefaultBlock,
    capturingClientId: capturingClientId,
    __unstablePopoverSlot: __unstablePopoverSlot,
    __unstableContentRef: __unstableContentRef
  });
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-tools/back-compat.js


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



function BlockToolsBackCompat(_ref) {
  let {
    children
  } = _ref;
  const openRef = (0,external_wp_element_namespaceObject.useContext)(InsertionPointOpenRef);
  const isDisabled = (0,external_wp_element_namespaceObject.useContext)(external_wp_components_namespaceObject.Disabled.Context); // If context is set, `BlockTools` is a parent component.

  if (openRef || isDisabled) {
    return children;
  }

  external_wp_deprecated_default()('wp.components.Popover.Slot name="block-toolbar"', {
    alternative: 'wp.blockEditor.BlockTools',
    since: '5.8'
  });
  return (0,external_wp_element_namespaceObject.createElement)(InsertionPoint, {
    __unstablePopoverSlot: "block-toolbar"
  }, (0,external_wp_element_namespaceObject.createElement)(WrappedBlockPopover, {
    __unstablePopoverSlot: "block-toolbar"
  }), children);
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inner-blocks/with-client-id.js



/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


const withClientId = (0,external_wp_compose_namespaceObject.createHigherOrderComponent)(WrappedComponent => props => {
  const {
    clientId
  } = useBlockEditContext();
  return (0,external_wp_element_namespaceObject.createElement)(WrappedComponent, _extends({}, props, {
    clientId: clientId
  }));
}, 'withClientId');
/* harmony default export */ var with_client_id = (withClientId);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inner-blocks/button-block-appender.js


/**
 * External dependencies
 */

/**
 * Internal dependencies
 */



const button_block_appender_ButtonBlockAppender = _ref => {
  let {
    clientId,
    showSeparator,
    isFloating,
    onAddBlock,
    isToggle
  } = _ref;
  return (0,external_wp_element_namespaceObject.createElement)(button_block_appender, {
    className: classnames_default()({
      'block-list-appender__toggle': isToggle
    }),
    rootClientId: clientId,
    showSeparator: showSeparator,
    isFloating: isFloating,
    onAddBlock: onAddBlock
  });
};
/* harmony default export */ var inner_blocks_button_block_appender = (with_client_id(button_block_appender_ButtonBlockAppender));

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inner-blocks/default-block-appender.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




const default_block_appender_DefaultBlockAppender = _ref => {
  let {
    clientId
  } = _ref;
  return (0,external_wp_element_namespaceObject.createElement)(default_block_appender, {
    rootClientId: clientId
  });
};
/* harmony default export */ var inner_blocks_default_block_appender = ((0,external_wp_compose_namespaceObject.compose)([with_client_id, (0,external_wp_data_namespaceObject.withSelect)((select, _ref2) => {
  let {
    clientId
  } = _ref2;
  const {
    getBlockOrder
  } = select(store);
  const blockClientIds = getBlockOrder(clientId);
  return {
    lastBlockClientId: (0,external_lodash_namespaceObject.last)(blockClientIds)
  };
})])(default_block_appender_DefaultBlockAppender));

;// CONCATENATED MODULE: external ["wp","isShallowEqual"]
var external_wp_isShallowEqual_namespaceObject = window["wp"]["isShallowEqual"];
var external_wp_isShallowEqual_default = /*#__PURE__*/__webpack_require__.n(external_wp_isShallowEqual_namespaceObject);
;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inner-blocks/use-nested-settings-update.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



/** @typedef {import('../../selectors').WPDirectInsertBlock } WPDirectInsertBlock */

/**
 * This hook is a side effect which updates the block-editor store when changes
 * happen to inner block settings. The given props are transformed into a
 * settings object, and if that is different from the current settings object in
 * the block-editor store, then the store is updated with the new settings which
 * came from props.
 *
 * @param {string}               clientId                   The client ID of the block to update.
 * @param {string[]}             allowedBlocks              An array of block names which are permitted
 *                                                          in inner blocks.
 * @param {?WPDirectInsertBlock} __experimentalDefaultBlock The default block to insert: [ blockName, { blockAttributes } ].
 * @param {?Function|boolean}    __experimentalDirectInsert If a default block should be inserted directly by the
 *                                                          appender.
 * @param {string}               [templateLock]             The template lock specified for the inner
 *                                                          blocks component. (e.g. "all")
 * @param {boolean}              captureToolbars            Whether or children toolbars should be shown
 *                                                          in the inner blocks component rather than on
 *                                                          the child block.
 * @param {string}               orientation                The direction in which the block
 *                                                          should face.
 * @param {Object}               layout                     The layout object for the block container.
 */

function useNestedSettingsUpdate(clientId, allowedBlocks, __experimentalDefaultBlock, __experimentalDirectInsert, templateLock, captureToolbars, orientation, layout) {
  const {
    updateBlockListSettings
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const {
    blockListSettings,
    parentLock
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const rootClientId = select(store).getBlockRootClientId(clientId);
    return {
      blockListSettings: select(store).getBlockListSettings(clientId),
      parentLock: select(store).getTemplateLock(rootClientId)
    };
  }, [clientId]); // Memoize as inner blocks implementors often pass a new array on every
  // render.

  const _allowedBlocks = (0,external_wp_element_namespaceObject.useMemo)(() => allowedBlocks, allowedBlocks);

  (0,external_wp_element_namespaceObject.useLayoutEffect)(() => {
    const newSettings = {
      allowedBlocks: _allowedBlocks,
      templateLock: templateLock === undefined ? parentLock : templateLock
    }; // These values are not defined for RN, so only include them if they
    // are defined.

    if (captureToolbars !== undefined) {
      newSettings.__experimentalCaptureToolbars = captureToolbars;
    } // Orientation depends on layout,
    // ideally the separate orientation prop should be deprecated.


    if (orientation !== undefined) {
      newSettings.orientation = orientation;
    } else {
      const layoutType = getLayoutType(layout === null || layout === void 0 ? void 0 : layout.type);
      newSettings.orientation = layoutType.getOrientation(layout);
    }

    if (__experimentalDefaultBlock !== undefined) {
      newSettings.__experimentalDefaultBlock = __experimentalDefaultBlock;
    }

    if (__experimentalDirectInsert !== undefined) {
      newSettings.__experimentalDirectInsert = __experimentalDirectInsert;
    }

    if (!external_wp_isShallowEqual_default()(blockListSettings, newSettings)) {
      updateBlockListSettings(clientId, newSettings);
    }
  }, [clientId, blockListSettings, _allowedBlocks, __experimentalDefaultBlock, __experimentalDirectInsert, templateLock, parentLock, captureToolbars, orientation, updateBlockListSettings, layout]);
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inner-blocks/use-inner-block-template-sync.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


/**
 * This hook makes sure that a block's inner blocks stay in sync with the given
 * block "template". The template is a block hierarchy to which inner blocks must
 * conform. If the blocks get "out of sync" with the template and the template
 * is meant to be locked (e.g. templateLock = "all"), then we replace the inner
 * blocks with the correct value after synchronizing it with the template.
 *
 * @param {string}  clientId                       The block client ID.
 * @param {Object}  template                       The template to match.
 * @param {string}  templateLock                   The template lock state for the inner blocks. For
 *                                                 example, if the template lock is set to "all",
 *                                                 then the inner blocks will stay in sync with the
 *                                                 template. If not defined or set to false, then
 *                                                 the inner blocks will not be synchronized with
 *                                                 the given template.
 * @param {boolean} templateInsertUpdatesSelection Whether or not to update the
 *                                                 block-editor selection state when inner blocks
 *                                                 are replaced after template synchronization.
 */

function useInnerBlockTemplateSync(clientId, template, templateLock, templateInsertUpdatesSelection) {
  const {
    getSelectedBlocksInitialCaretPosition
  } = (0,external_wp_data_namespaceObject.useSelect)(store);
  const {
    replaceInnerBlocks
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const innerBlocks = (0,external_wp_data_namespaceObject.useSelect)(select => select(store).getBlocks(clientId), [clientId]); // Maintain a reference to the previous value so we can do a deep equality check.

  const existingTemplate = (0,external_wp_element_namespaceObject.useRef)(null);
  (0,external_wp_element_namespaceObject.useLayoutEffect)(() => {
    // Only synchronize innerBlocks with template if innerBlocks are empty or
    // a locking all exists directly on the block.
    if (innerBlocks.length === 0 || templateLock === 'all') {
      const hasTemplateChanged = !(0,external_lodash_namespaceObject.isEqual)(template, existingTemplate.current);

      if (hasTemplateChanged) {
        existingTemplate.current = template;
        const nextBlocks = (0,external_wp_blocks_namespaceObject.synchronizeBlocksWithTemplate)(innerBlocks, template);

        if (!(0,external_lodash_namespaceObject.isEqual)(nextBlocks, innerBlocks)) {
          replaceInnerBlocks(clientId, nextBlocks, innerBlocks.length === 0 && templateInsertUpdatesSelection && nextBlocks.length !== 0, // This ensures the "initialPosition" doesn't change when applying the template
          // If we're supposed to focus the block, we'll focus the first inner block
          // otherwise, we won't apply any auto-focus.
          // This ensures for instance that the focus stays in the inserter when inserting the "buttons" block.
          getSelectedBlocksInitialCaretPosition());
        }
      }
    }
  }, [innerBlocks, template, templateLock, clientId]);
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inner-blocks/get-block-context.js
/**
 * External dependencies
 */

/**
 * Block context cache, implemented as a WeakMap mapping block types to a
 * WeakMap mapping attributes object to context value.
 *
 * @type {WeakMap<string,WeakMap<string,*>>}
 */

const BLOCK_CONTEXT_CACHE = new WeakMap();
/**
 * Returns a cached context object value for a given set of attributes for the
 * block type.
 *
 * @param {Record<string,*>} attributes Block attributes object.
 * @param {WPBlockType}      blockType  Block type settings.
 *
 * @return {Record<string,*>} Context value.
 */

function getBlockContext(attributes, blockType) {
  if (!BLOCK_CONTEXT_CACHE.has(blockType)) {
    BLOCK_CONTEXT_CACHE.set(blockType, new WeakMap());
  }

  const blockTypeCache = BLOCK_CONTEXT_CACHE.get(blockType);

  if (!blockTypeCache.has(attributes)) {
    const context = (0,external_lodash_namespaceObject.mapValues)(blockType.providesContext, attributeName => attributes[attributeName]);
    blockTypeCache.set(attributes, context);
  }

  return blockTypeCache.get(attributes);
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/use-on-block-drop/index.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


/** @typedef {import('@wordpress/element').WPSyntheticEvent} WPSyntheticEvent */

/**
 * Retrieve the data for a block drop event.
 *
 * @param {WPSyntheticEvent} event The drop event.
 *
 * @return {Object} An object with block drag and drop data.
 */

function parseDropEvent(event) {
  let result = {
    srcRootClientId: null,
    srcClientIds: null,
    srcIndex: null,
    type: null,
    blocks: null
  };

  if (!event.dataTransfer) {
    return result;
  }

  try {
    result = Object.assign(result, JSON.parse(event.dataTransfer.getData('wp-blocks')));
  } catch (err) {
    return result;
  }

  return result;
}
/**
 * A function that returns an event handler function for block drop events.
 *
 * @param {string}   targetRootClientId        The root client id where the block(s) will be inserted.
 * @param {number}   targetBlockIndex          The index where the block(s) will be inserted.
 * @param {Function} getBlockIndex             A function that gets the index of a block.
 * @param {Function} getClientIdsOfDescendants A function that gets the client ids of descendant blocks.
 * @param {Function} moveBlocksToPosition      A function that moves blocks.
 * @param {Function} insertBlocks              A function that inserts blocks.
 * @param {Function} clearSelectedBlock        A function that clears block selection.
 * @return {Function} The event handler for a block drop event.
 */

function onBlockDrop(targetRootClientId, targetBlockIndex, getBlockIndex, getClientIdsOfDescendants, moveBlocksToPosition, insertBlocks, clearSelectedBlock) {
  return event => {
    const {
      srcRootClientId: sourceRootClientId,
      srcClientIds: sourceClientIds,
      type: dropType,
      blocks
    } = parseDropEvent(event); // If the user is inserting a block.

    if (dropType === 'inserter') {
      clearSelectedBlock();
      const blocksToInsert = blocks.map(block => (0,external_wp_blocks_namespaceObject.cloneBlock)(block));
      insertBlocks(blocksToInsert, targetBlockIndex, targetRootClientId, true, null);
    } // If the user is moving a block.


    if (dropType === 'block') {
      const sourceBlockIndex = getBlockIndex(sourceClientIds[0]); // If the user is dropping to the same position, return early.

      if (sourceRootClientId === targetRootClientId && sourceBlockIndex === targetBlockIndex) {
        return;
      } // If the user is attempting to drop a block within its own
      // nested blocks, return early as this would create infinite
      // recursion.


      if (sourceClientIds.includes(targetRootClientId) || getClientIdsOfDescendants(sourceClientIds).some(id => id === targetRootClientId)) {
        return;
      }

      const isAtSameLevel = sourceRootClientId === targetRootClientId;
      const draggedBlockCount = sourceClientIds.length; // If the block is kept at the same level and moved downwards,
      // subtract to take into account that the blocks being dragged
      // were removed from the block list above the insertion point.

      const insertIndex = isAtSameLevel && sourceBlockIndex < targetBlockIndex ? targetBlockIndex - draggedBlockCount : targetBlockIndex;
      moveBlocksToPosition(sourceClientIds, sourceRootClientId, targetRootClientId, insertIndex);
    }
  };
}
/**
 * A function that returns an event handler function for block-related file drop events.
 *
 * @param {string}   targetRootClientId    The root client id where the block(s) will be inserted.
 * @param {number}   targetBlockIndex      The index where the block(s) will be inserted.
 * @param {boolean}  hasUploadPermissions  Whether the user has upload permissions.
 * @param {Function} updateBlockAttributes A function that updates a block's attributes.
 * @param {Function} canInsertBlockType    A function that returns checks whether a block type can be inserted.
 * @param {Function} insertBlocks          A function that inserts blocks.
 *
 * @return {Function} The event handler for a block-related file drop event.
 */

function onFilesDrop(targetRootClientId, targetBlockIndex, hasUploadPermissions, updateBlockAttributes, canInsertBlockType, insertBlocks) {
  return files => {
    if (!hasUploadPermissions) {
      return;
    }

    const transformation = (0,external_wp_blocks_namespaceObject.findTransform)((0,external_wp_blocks_namespaceObject.getBlockTransforms)('from'), transform => transform.type === 'files' && canInsertBlockType(transform.blockName, targetRootClientId) && transform.isMatch(files));

    if (transformation) {
      const blocks = transformation.transform(files, updateBlockAttributes);
      insertBlocks(blocks, targetBlockIndex, targetRootClientId);
    }
  };
}
/**
 * A function that returns an event handler function for block-related HTML drop events.
 *
 * @param {string}   targetRootClientId The root client id where the block(s) will be inserted.
 * @param {number}   targetBlockIndex   The index where the block(s) will be inserted.
 * @param {Function} insertBlocks       A function that inserts blocks.
 *
 * @return {Function} The event handler for a block-related HTML drop event.
 */

function onHTMLDrop(targetRootClientId, targetBlockIndex, insertBlocks) {
  return HTML => {
    const blocks = (0,external_wp_blocks_namespaceObject.pasteHandler)({
      HTML,
      mode: 'BLOCKS'
    });

    if (blocks.length) {
      insertBlocks(blocks, targetBlockIndex, targetRootClientId);
    }
  };
}
/**
 * A React hook for handling block drop events.
 *
 * @param {string} targetRootClientId The root client id where the block(s) will be inserted.
 * @param {number} targetBlockIndex   The index where the block(s) will be inserted.
 *
 * @return {Object} An object that contains the event handlers `onDrop`, `onFilesDrop` and `onHTMLDrop`.
 */

function useOnBlockDrop(targetRootClientId, targetBlockIndex) {
  const hasUploadPermissions = (0,external_wp_data_namespaceObject.useSelect)(select => select(store).getSettings().mediaUpload, []);
  const {
    canInsertBlockType,
    getBlockIndex,
    getClientIdsOfDescendants
  } = (0,external_wp_data_namespaceObject.useSelect)(store);
  const {
    insertBlocks,
    moveBlocksToPosition,
    updateBlockAttributes,
    clearSelectedBlock
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);

  const _onDrop = onBlockDrop(targetRootClientId, targetBlockIndex, getBlockIndex, getClientIdsOfDescendants, moveBlocksToPosition, insertBlocks, clearSelectedBlock);

  const _onFilesDrop = onFilesDrop(targetRootClientId, targetBlockIndex, hasUploadPermissions, updateBlockAttributes, canInsertBlockType, insertBlocks);

  const _onHTMLDrop = onHTMLDrop(targetRootClientId, targetBlockIndex, insertBlocks);

  return event => {
    const files = (0,external_wp_dom_namespaceObject.getFilesFromDataTransfer)(event.dataTransfer);
    const html = event.dataTransfer.getData('text/html');
    /**
     * From Windows Chrome 96, the `event.dataTransfer` returns both file object and HTML.
     * The order of the checks is important to recognise the HTML drop.
     */

    if (html) {
      _onHTMLDrop(html);
    } else if (files.length) {
      _onFilesDrop(files);
    } else {
      _onDrop(event);
    }
  };
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/utils/math.js
/**
 * A string representing the name of an edge.
 *
 * @typedef {'top'|'right'|'bottom'|'left'} WPEdgeName
 */

/**
 * @typedef  {Object} WPPoint
 * @property {number} x The horizontal position.
 * @property {number} y The vertical position.
 */

/**
 * Given a point, a DOMRect and the name of an edge, returns the distance to
 * that edge of the rect.
 *
 * This function works for edges that are horizontal or vertical (e.g. not
 * rotated), the following terms are used so that the function works in both
 * orientations:
 *
 * - Forward, meaning the axis running horizontally when an edge is vertical
 *   and vertically when an edge is horizontal.
 * - Lateral, meaning the axis running vertically when an edge is vertical
 *   and horizontally when an edge is horizontal.
 *
 * @param {WPPoint}    point The point to measure distance from.
 * @param {DOMRect}    rect  A DOM Rect containing edge positions.
 * @param {WPEdgeName} edge  The edge to measure to.
 */
function getDistanceFromPointToEdge(point, rect, edge) {
  const isHorizontal = edge === 'top' || edge === 'bottom';
  const {
    x,
    y
  } = point;
  const pointLateralPosition = isHorizontal ? x : y;
  const pointForwardPosition = isHorizontal ? y : x;
  const edgeStart = isHorizontal ? rect.left : rect.top;
  const edgeEnd = isHorizontal ? rect.right : rect.bottom;
  const edgeForwardPosition = rect[edge]; // Measure the straight line distance to the edge of the rect, when the
  // point is adjacent to the edge.
  // Else, if the point is positioned diagonally to the edge of the rect,
  // measure diagonally to the nearest corner that the edge meets.

  let edgeLateralPosition;

  if (pointLateralPosition >= edgeStart && pointLateralPosition <= edgeEnd) {
    edgeLateralPosition = pointLateralPosition;
  } else if (pointLateralPosition < edgeEnd) {
    edgeLateralPosition = edgeStart;
  } else {
    edgeLateralPosition = edgeEnd;
  }

  return Math.sqrt((pointLateralPosition - edgeLateralPosition) ** 2 + (pointForwardPosition - edgeForwardPosition) ** 2);
}
/**
 * Given a point, a DOMRect and a list of allowed edges returns the name of and
 * distance to the nearest edge.
 *
 * @param {WPPoint}      point        The point to measure distance from.
 * @param {DOMRect}      rect         A DOM Rect containing edge positions.
 * @param {WPEdgeName[]} allowedEdges A list of the edges included in the
 *                                    calculation. Defaults to all edges.
 *
 * @return {[number, string]} An array where the first value is the distance
 *                              and a second is the edge name.
 */

function getDistanceToNearestEdge(point, rect) {
  let allowedEdges = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : ['top', 'bottom', 'left', 'right'];
  let candidateDistance;
  let candidateEdge;
  allowedEdges.forEach(edge => {
    const distance = getDistanceFromPointToEdge(point, rect, edge);

    if (candidateDistance === undefined || distance < candidateDistance) {
      candidateDistance = distance;
      candidateEdge = edge;
    }
  });
  return [candidateDistance, candidateEdge];
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/use-block-drop-zone/index.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */




/** @typedef {import('../../utils/math').WPPoint} WPPoint */

/**
 * The orientation of a block list.
 *
 * @typedef {'horizontal'|'vertical'|undefined} WPBlockListOrientation
 */

/**
 * Given a list of block DOM elements finds the index that a block should be dropped
 * at.
 *
 * @param {Element[]}              elements    Array of DOM elements that represent each block in a block list.
 * @param {WPPoint}                position    The position of the item being dragged.
 * @param {WPBlockListOrientation} orientation The orientation of a block list.
 *
 * @return {number|undefined} The block index that's closest to the drag position.
 */

function getNearestBlockIndex(elements, position, orientation) {
  const allowedEdges = orientation === 'horizontal' ? ['left', 'right'] : ['top', 'bottom'];
  const isRightToLeft = (0,external_wp_i18n_namespaceObject.isRTL)();
  let candidateIndex;
  let candidateDistance;
  elements.forEach((element, index) => {
    const rect = element.getBoundingClientRect();
    const [distance, edge] = getDistanceToNearestEdge(position, rect, allowedEdges);

    if (candidateDistance === undefined || distance < candidateDistance) {
      // If the user is dropping to the trailing edge of the block
      // add 1 to the index to represent dragging after.
      // Take RTL languages into account where the left edge is
      // the trailing edge.
      const isTrailingEdge = edge === 'bottom' || !isRightToLeft && edge === 'right' || isRightToLeft && edge === 'left';
      const offset = isTrailingEdge ? 1 : 0; // Update the currently known best candidate.

      candidateDistance = distance;
      candidateIndex = index + offset;
    }
  });
  return candidateIndex;
}
/**
 * @typedef  {Object} WPBlockDropZoneConfig
 * @property {string} rootClientId The root client id for the block list.
 */

/**
 * A React hook that can be used to make a block list handle drag and drop.
 *
 * @param {WPBlockDropZoneConfig} dropZoneConfig configuration data for the drop zone.
 */

function useBlockDropZone() {
  let {
    // An undefined value represents a top-level block. Default to an empty
    // string for this so that `targetRootClientId` can be easily compared to
    // values returned by the `getRootBlockClientId` selector, which also uses
    // an empty string to represent top-level blocks.
    rootClientId: targetRootClientId = ''
  } = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  const [targetBlockIndex, setTargetBlockIndex] = (0,external_wp_element_namespaceObject.useState)(null);
  const isLockedAll = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getTemplateLock
    } = select(store);
    return getTemplateLock(targetRootClientId) === 'all';
  }, [targetRootClientId]);
  const {
    getBlockListSettings
  } = (0,external_wp_data_namespaceObject.useSelect)(store);
  const {
    showInsertionPoint,
    hideInsertionPoint
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const onBlockDrop = useOnBlockDrop(targetRootClientId, targetBlockIndex);
  const throttled = (0,external_wp_compose_namespaceObject.useThrottle)((0,external_wp_element_namespaceObject.useCallback)((event, currentTarget) => {
    var _getBlockListSettings;

    const blockElements = Array.from(currentTarget.children).filter( // Ensure the element is a block. It should have the `wp-block` class.
    element => element.classList.contains('wp-block'));
    const targetIndex = getNearestBlockIndex(blockElements, {
      x: event.clientX,
      y: event.clientY
    }, (_getBlockListSettings = getBlockListSettings(targetRootClientId)) === null || _getBlockListSettings === void 0 ? void 0 : _getBlockListSettings.orientation);
    setTargetBlockIndex(targetIndex === undefined ? 0 : targetIndex);

    if (targetIndex !== null) {
      showInsertionPoint(targetRootClientId, targetIndex);
    }
  }, []), 200);
  return (0,external_wp_compose_namespaceObject.__experimentalUseDropZone)({
    isDisabled: isLockedAll,
    onDrop: onBlockDrop,

    onDragOver(event) {
      // `currentTarget` is only available while the event is being
      // handled, so get it now and pass it to the thottled function.
      // https://developer.mozilla.org/en-US/docs/Web/API/Event/currentTarget
      throttled(event, event.currentTarget);
    },

    onDragLeave() {
      throttled.cancel();
      hideInsertionPoint();
      setTargetBlockIndex(null);
    },

    onDragEnd() {
      throttled.cancel();
      hideInsertionPoint();
      setTargetBlockIndex(null);
    }

  });
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/inner-blocks/index.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */












/**
 * InnerBlocks is a component which allows a single block to have multiple blocks
 * as children. The UncontrolledInnerBlocks component is used whenever the inner
 * blocks are not controlled by another entity. In other words, it is normally
 * used for inner blocks in the post editor
 *
 * @param {Object} props The component props.
 */

function UncontrolledInnerBlocks(props) {
  const {
    clientId,
    allowedBlocks,
    __experimentalDefaultBlock,
    __experimentalDirectInsert,
    template,
    templateLock,
    wrapperRef,
    templateInsertUpdatesSelection,
    __experimentalCaptureToolbars: captureToolbars,
    __experimentalAppenderTagName,
    renderAppender,
    orientation,
    placeholder,
    __experimentalLayout
  } = props;
  useNestedSettingsUpdate(clientId, allowedBlocks, __experimentalDefaultBlock, __experimentalDirectInsert, templateLock, captureToolbars, orientation, __experimentalLayout);
  useInnerBlockTemplateSync(clientId, template, templateLock, templateInsertUpdatesSelection);
  const context = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const block = select(store).getBlock(clientId);
    const blockType = (0,external_wp_blocks_namespaceObject.getBlockType)(block.name);

    if (!blockType || !blockType.providesContext) {
      return;
    }

    return getBlockContext(block.attributes, blockType);
  }, [clientId]); // This component needs to always be synchronous as it's the one changing
  // the async mode depending on the block selection.

  return (0,external_wp_element_namespaceObject.createElement)(BlockContextProvider, {
    value: context
  }, (0,external_wp_element_namespaceObject.createElement)(BlockListItems, {
    rootClientId: clientId,
    renderAppender: renderAppender,
    __experimentalAppenderTagName: __experimentalAppenderTagName,
    __experimentalLayout: __experimentalLayout,
    wrapperRef: wrapperRef,
    placeholder: placeholder
  }));
}
/**
 * The controlled inner blocks component wraps the uncontrolled inner blocks
 * component with the blockSync hook. This keeps the innerBlocks of the block in
 * the block-editor store in sync with the blocks of the controlling entity. An
 * example of an inner block controller is a template part block, which provides
 * its own blocks from the template part entity data source.
 *
 * @param {Object} props The component props.
 */


function ControlledInnerBlocks(props) {
  useBlockSync(props);
  return (0,external_wp_element_namespaceObject.createElement)(UncontrolledInnerBlocks, props);
}

const ForwardedInnerBlocks = (0,external_wp_element_namespaceObject.forwardRef)((props, ref) => {
  const innerBlocksProps = useInnerBlocksProps({
    ref
  }, props);
  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-inner-blocks"
  }, (0,external_wp_element_namespaceObject.createElement)("div", innerBlocksProps));
});
/**
 * This hook is used to lightly mark an element as an inner blocks wrapper
 * element. Call this hook and pass the returned props to the element to mark as
 * an inner blocks wrapper, automatically rendering inner blocks as children. If
 * you define a ref for the element, it is important to pass the ref to this
 * hook, which the hook in turn will pass to the component through the props it
 * returns. Optionally, you can also pass any other props through this hook, and
 * they will be merged and returned.
 *
 * @param {Object} props   Optional. Props to pass to the element. Must contain
 *                         the ref if one is defined.
 * @param {Object} options Optional. Inner blocks options.
 *
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/inner-blocks/README.md
 */

function useInnerBlocksProps() {
  let props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  const {
    clientId
  } = useBlockEditContext();
  const isSmallScreen = (0,external_wp_compose_namespaceObject.useViewportMatch)('medium', '<');
  const {
    __experimentalCaptureToolbars,
    hasOverlay
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    if (!clientId) {
      return {};
    }

    const {
      getBlockName,
      isBlockSelected,
      hasSelectedInnerBlock,
      isNavigationMode
    } = select(store);
    const blockName = getBlockName(clientId);
    const enableClickThrough = isNavigationMode() || isSmallScreen;
    return {
      __experimentalCaptureToolbars: select(external_wp_blocks_namespaceObject.store).hasBlockSupport(blockName, '__experimentalExposeControlsToChildren', false),
      hasOverlay: blockName !== 'core/template' && !isBlockSelected(clientId) && !hasSelectedInnerBlock(clientId, true) && enableClickThrough
    };
  }, [clientId, isSmallScreen]);
  const ref = (0,external_wp_compose_namespaceObject.useMergeRefs)([props.ref, useBlockDropZone({
    rootClientId: clientId
  })]);
  const innerBlocksProps = {
    __experimentalCaptureToolbars,
    ...options
  };
  const InnerBlocks = innerBlocksProps.value && innerBlocksProps.onChange ? ControlledInnerBlocks : UncontrolledInnerBlocks;
  return { ...props,
    ref,
    className: classnames_default()(props.className, 'block-editor-block-list__layout', {
      'has-overlay': hasOverlay
    }),
    children: clientId ? (0,external_wp_element_namespaceObject.createElement)(InnerBlocks, _extends({}, innerBlocksProps, {
      clientId: clientId
    })) : (0,external_wp_element_namespaceObject.createElement)(BlockListItems, options)
  };
}
useInnerBlocksProps.save = external_wp_blocks_namespaceObject.__unstableGetInnerBlocksProps; // Expose default appender placeholders as components.

ForwardedInnerBlocks.DefaultBlockAppender = inner_blocks_default_block_appender;
ForwardedInnerBlocks.ButtonBlockAppender = inner_blocks_button_block_appender;

ForwardedInnerBlocks.Content = () => useInnerBlocksProps.save().children;
/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/inner-blocks/README.md
 */


/* harmony default export */ var inner_blocks = (ForwardedInnerBlocks);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/block-list/index.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */











const elementContext = (0,external_wp_element_namespaceObject.createContext)();
const IntersectionObserver = (0,external_wp_element_namespaceObject.createContext)();

function Root(_ref) {
  let {
    className,
    ...settings
  } = _ref;
  const [element, setElement] = (0,external_wp_element_namespaceObject.useState)();
  const isLargeViewport = (0,external_wp_compose_namespaceObject.useViewportMatch)('medium');
  const {
    isOutlineMode,
    isFocusMode,
    isNavigationMode
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getSettings,
      isNavigationMode: _isNavigationMode
    } = select(store);
    const {
      outlineMode,
      focusMode
    } = getSettings();
    return {
      isOutlineMode: outlineMode,
      isFocusMode: focusMode,
      isNavigationMode: _isNavigationMode()
    };
  }, []);
  const innerBlocksProps = useInnerBlocksProps({
    ref: (0,external_wp_compose_namespaceObject.useMergeRefs)([useBlockSelectionClearer(), useInBetweenInserter(), setElement]),
    className: classnames_default()('is-root-container', className, {
      'is-outline-mode': isOutlineMode,
      'is-focus-mode': isFocusMode && isLargeViewport,
      'is-navigate-mode': isNavigationMode
    })
  }, settings);
  return (0,external_wp_element_namespaceObject.createElement)(elementContext.Provider, {
    value: element
  }, (0,external_wp_element_namespaceObject.createElement)("div", innerBlocksProps));
}

function BlockList(settings) {
  usePreParsePatterns();
  return (0,external_wp_element_namespaceObject.createElement)(BlockToolsBackCompat, null, (0,external_wp_element_namespaceObject.createElement)(Provider, {
    value: DEFAULT_BLOCK_EDIT_CONTEXT
  }, (0,external_wp_element_namespaceObject.createElement)(Root, settings)));
}
BlockList.__unstableElementContext = elementContext;

function Items(_ref2) {
  let {
    placeholder,
    rootClientId,
    renderAppender,
    __experimentalAppenderTagName,
    __experimentalLayout: layout = defaultLayout
  } = _ref2;
  const [intersectingBlocks, setIntersectingBlocks] = (0,external_wp_element_namespaceObject.useState)(new Set());
  const intersectionObserver = (0,external_wp_element_namespaceObject.useMemo)(() => {
    const {
      IntersectionObserver: Observer
    } = window;

    if (!Observer) {
      return;
    }

    return new Observer(entries => {
      setIntersectingBlocks(oldIntersectingBlocks => {
        const newIntersectingBlocks = new Set(oldIntersectingBlocks);

        for (const entry of entries) {
          const clientId = entry.target.getAttribute('data-block');
          const action = entry.isIntersecting ? 'add' : 'delete';
          newIntersectingBlocks[action](clientId);
        }

        return newIntersectingBlocks;
      });
    });
  }, [setIntersectingBlocks]);
  const {
    order,
    selectedBlocks
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getBlockOrder,
      getSelectedBlockClientIds
    } = select(store);
    return {
      order: getBlockOrder(rootClientId),
      selectedBlocks: getSelectedBlockClientIds()
    };
  }, [rootClientId]);
  return (0,external_wp_element_namespaceObject.createElement)(LayoutProvider, {
    value: layout
  }, (0,external_wp_element_namespaceObject.createElement)(IntersectionObserver.Provider, {
    value: intersectionObserver
  }, order.map(clientId => (0,external_wp_element_namespaceObject.createElement)(external_wp_data_namespaceObject.AsyncModeProvider, {
    key: clientId,
    value: // Only provide data asynchronously if the block is
    // not visible and not selected.
    !intersectingBlocks.has(clientId) && !selectedBlocks.includes(clientId)
  }, (0,external_wp_element_namespaceObject.createElement)(block, {
    rootClientId: rootClientId,
    clientId: clientId
  })))), order.length < 1 && placeholder, (0,external_wp_element_namespaceObject.createElement)(block_list_appender, {
    tagName: __experimentalAppenderTagName,
    rootClientId: rootClientId,
    renderAppender: renderAppender
  }));
}

function BlockListItems(props) {
  // This component needs to always be synchronous as it's the one changing
  // the async mode depending on the block selection.
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_data_namespaceObject.AsyncModeProvider, {
    value: false
  }, (0,external_wp_element_namespaceObject.createElement)(Items, props));
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/colors-gradients/control.js



/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


const colorsAndGradientKeys = ['colors', 'disableCustomColors', 'gradients', 'disableCustomGradients'];

function ColorGradientControlInner(_ref) {
  let {
    colors,
    gradients,
    disableCustomColors,
    disableCustomGradients,
    __experimentalHasMultipleOrigins,
    __experimentalIsRenderedInSidebar,
    className,
    label,
    onColorChange,
    onGradientChange,
    colorValue,
    gradientValue,
    clearable,
    showTitle = true,
    enableAlpha
  } = _ref;
  const canChooseAColor = onColorChange && (!(0,external_lodash_namespaceObject.isEmpty)(colors) || !disableCustomColors);
  const canChooseAGradient = onGradientChange && (!(0,external_lodash_namespaceObject.isEmpty)(gradients) || !disableCustomGradients);
  const [currentTab, setCurrentTab] = (0,external_wp_element_namespaceObject.useState)(gradientValue ? 'gradient' : !!canChooseAColor && 'color');

  if (!canChooseAColor && !canChooseAGradient) {
    return null;
  }

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.BaseControl, {
    className: classnames_default()('block-editor-color-gradient-control', className)
  }, (0,external_wp_element_namespaceObject.createElement)("fieldset", null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalVStack, {
    spacing: 1
  }, showTitle && (0,external_wp_element_namespaceObject.createElement)("legend", null, (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-color-gradient-control__color-indicator"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.BaseControl.VisualLabel, null, label))), canChooseAColor && canChooseAGradient && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToggleGroupControl, {
    value: currentTab,
    onChange: setCurrentTab,
    label: (0,external_wp_i18n_namespaceObject.__)('Select color type'),
    hideLabelFromVision: true,
    isBlock: true
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToggleGroupControlOption, {
    value: "color",
    label: (0,external_wp_i18n_namespaceObject.__)('Solid')
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToggleGroupControlOption, {
    value: "gradient",
    label: (0,external_wp_i18n_namespaceObject.__)('Gradient')
  })), (currentTab === 'color' || !canChooseAGradient) && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ColorPalette, {
    value: colorValue,
    onChange: canChooseAGradient ? newColor => {
      onColorChange(newColor);
      onGradientChange();
    } : onColorChange,
    colors,
    disableCustomColors,
    __experimentalHasMultipleOrigins: __experimentalHasMultipleOrigins,
    __experimentalIsRenderedInSidebar: __experimentalIsRenderedInSidebar,
    clearable: clearable,
    enableAlpha: enableAlpha
  }), (currentTab === 'gradient' || !canChooseAColor) && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.GradientPicker, {
    value: gradientValue,
    onChange: canChooseAColor ? newGradient => {
      onGradientChange(newGradient);
      onColorChange();
    } : onGradientChange,
    gradients,
    disableCustomGradients,
    __experimentalHasMultipleOrigins: __experimentalHasMultipleOrigins,
    __experimentalIsRenderedInSidebar: __experimentalIsRenderedInSidebar,
    clearable: clearable
  }))));
}

function ColorGradientControlSelect(props) {
  const colorGradientSettings = {};
  colorGradientSettings.colors = useSetting('color.palette');
  colorGradientSettings.gradients = useSetting('color.gradients');
  colorGradientSettings.disableCustomColors = !useSetting('color.custom');
  colorGradientSettings.disableCustomGradients = !useSetting('color.customGradient');
  return (0,external_wp_element_namespaceObject.createElement)(ColorGradientControlInner, _extends({}, colorGradientSettings, props));
}

function ColorGradientControl(props) {
  if ((0,external_lodash_namespaceObject.every)(colorsAndGradientKeys, key => props.hasOwnProperty(key))) {
    return (0,external_wp_element_namespaceObject.createElement)(ColorGradientControlInner, props);
  }

  return (0,external_wp_element_namespaceObject.createElement)(ColorGradientControlSelect, props);
}

/* harmony default export */ var control = (ColorGradientControl);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/colors-gradients/dropdown.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function ColorGradientSettingsDropdown(_ref) {
  let {
    colors,
    gradients,
    disableCustomColors,
    disableCustomGradients,
    __experimentalHasMultipleOrigins,
    __experimentalIsRenderedInSidebar,
    enableAlpha,
    settings
  } = _ref;
  let dropdownPosition;

  if (__experimentalIsRenderedInSidebar) {
    dropdownPosition = 'bottom left';
  }

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalItemGroup, {
    isBordered: true,
    isSeparated: true,
    className: "block-editor-panel-color-gradient-settings__item-group"
  }, settings.map((setting, index) => setting && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Dropdown, {
    key: index,
    position: dropdownPosition,
    className: "block-editor-panel-color-gradient-settings__dropdown",
    contentClassName: "block-editor-panel-color-gradient-settings__dropdown-content",
    renderToggle: _ref2 => {
      var _setting$gradientValu;

      let {
        isOpen,
        onToggle
      } = _ref2;
      return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalItem, {
        onClick: onToggle,
        className: classnames_default()('block-editor-panel-color-gradient-settings__item', {
          'is-open': isOpen
        })
      }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalHStack, {
        justify: "flex-start"
      }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ColorIndicator, {
        className: "block-editor-panel-color-gradient-settings__color-indicator",
        colorValue: (_setting$gradientValu = setting.gradientValue) !== null && _setting$gradientValu !== void 0 ? _setting$gradientValu : setting.colorValue
      }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.FlexItem, null, setting.label)));
    },
    renderContent: () => (0,external_wp_element_namespaceObject.createElement)(control, _extends({
      showTitle: false,
      colors,
      gradients,
      disableCustomColors,
      disableCustomGradients,
      __experimentalHasMultipleOrigins,
      __experimentalIsRenderedInSidebar,
      enableAlpha
    }, setting))
  })));
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/colors-gradients/use-common-single-multiple-selects.js
/**
 * Internal dependencies
 */

function useCommonSingleMultipleSelects() {
  return {
    disableCustomColors: !useSetting('color.custom'),
    disableCustomGradients: !useSetting('color.customGradient')
  };
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/colors-gradients/use-multiple-origin-colors-and-gradients.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



/**
 * Retrieves color and gradient related settings.
 *
 * The arrays for colors and gradients are made up of color palettes from each
 * origin i.e. "Core", "Theme", and "User".
 *
 * @return {Object} Color and gradient related settings.
 */

function useMultipleOriginColorsAndGradients() {
  const colorGradientSettings = useCommonSingleMultipleSelects();
  const customColors = useSetting('color.palette.custom');
  const themeColors = useSetting('color.palette.theme');
  const defaultColors = useSetting('color.palette.default');
  const shouldDisplayDefaultColors = useSetting('color.defaultPalette');
  colorGradientSettings.colors = (0,external_wp_element_namespaceObject.useMemo)(() => {
    const result = [];

    if (themeColors && themeColors.length) {
      result.push({
        name: (0,external_wp_i18n_namespaceObject._x)('Theme', 'Indicates this palette comes from the theme.'),
        colors: themeColors
      });
    }

    if (shouldDisplayDefaultColors && defaultColors && defaultColors.length) {
      result.push({
        name: (0,external_wp_i18n_namespaceObject._x)('Default', 'Indicates this palette comes from WordPress.'),
        colors: defaultColors
      });
    }

    if (customColors && customColors.length) {
      result.push({
        name: (0,external_wp_i18n_namespaceObject._x)('Custom', 'Indicates this palette comes from the theme.'),
        colors: customColors
      });
    }

    return result;
  }, [defaultColors, themeColors, customColors]);
  const customGradients = useSetting('color.gradients.custom');
  const themeGradients = useSetting('color.gradients.theme');
  const defaultGradients = useSetting('color.gradients.default');
  const shouldDisplayDefaultGradients = useSetting('color.defaultGradients');
  colorGradientSettings.gradients = (0,external_wp_element_namespaceObject.useMemo)(() => {
    const result = [];

    if (themeGradients && themeGradients.length) {
      result.push({
        name: (0,external_wp_i18n_namespaceObject._x)('Theme', 'Indicates this palette comes from the theme.'),
        gradients: themeGradients
      });
    }

    if (shouldDisplayDefaultGradients && defaultGradients && defaultGradients.length) {
      result.push({
        name: (0,external_wp_i18n_namespaceObject._x)('Default', 'Indicates this palette comes from WordPress.'),
        gradients: defaultGradients
      });
    }

    if (customGradients && customGradients.length) {
      result.push({
        name: (0,external_wp_i18n_namespaceObject._x)('Custom', 'Indicates this palette is created by the user.'),
        gradients: customGradients
      });
    }

    return result;
  }, [customGradients, themeGradients, defaultGradients]);
  return colorGradientSettings;
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/colors/utils.js
/**
 * External dependencies
 */




k([names, a11y]);
/**
 * Provided an array of color objects as set by the theme or by the editor defaults,
 * and the values of the defined color or custom color returns a color object describing the color.
 *
 * @param {Array}   colors       Array of color objects as set by the theme or by the editor defaults.
 * @param {?string} definedColor A string containing the color slug.
 * @param {?string} customColor  A string containing the customColor value.
 *
 * @return {?Object} If definedColor is passed and the name is found in colors,
 *                   the color object exactly as set by the theme or editor defaults is returned.
 *                   Otherwise, an object that just sets the color is defined.
 */

const getColorObjectByAttributeValues = (colors, definedColor, customColor) => {
  if (definedColor) {
    const colorObj = (0,external_lodash_namespaceObject.find)(colors, {
      slug: definedColor
    });

    if (colorObj) {
      return colorObj;
    }
  }

  return {
    color: customColor
  };
};
/**
 * Provided an array of color objects as set by the theme or by the editor defaults, and a color value returns the color object matching that value or undefined.
 *
 * @param {Array}   colors     Array of color objects as set by the theme or by the editor defaults.
 * @param {?string} colorValue A string containing the color value.
 *
 * @return {?Object} Color object included in the colors array whose color property equals colorValue.
 *                   Returns undefined if no color object matches this requirement.
 */

const getColorObjectByColorValue = (colors, colorValue) => {
  return (0,external_lodash_namespaceObject.find)(colors, {
    color: colorValue
  });
};
/**
 * Returns a class based on the context a color is being used and its slug.
 *
 * @param {string} colorContextName Context/place where color is being used e.g: background, text etc...
 * @param {string} colorSlug        Slug of the color.
 *
 * @return {?string} String with the class corresponding to the color in the provided context.
 *                   Returns undefined if either colorContextName or colorSlug are not provided.
 */

function getColorClassName(colorContextName, colorSlug) {
  if (!colorContextName || !colorSlug) {
    return undefined;
  }

  return `has-${(0,external_lodash_namespaceObject.kebabCase)(colorSlug)}-${colorContextName}`;
}
/**
 * Given an array of color objects and a color value returns the color value of the most readable color in the array.
 *
 * @param {Array}   colors     Array of color objects as set by the theme or by the editor defaults.
 * @param {?string} colorValue A string containing the color value.
 *
 * @return {string} String with the color value of the most readable color.
 */

function getMostReadableColor(colors, colorValue) {
  const colordColor = w(colorValue);
  return (0,external_lodash_namespaceObject.maxBy)(colors, _ref => {
    let {
      color
    } = _ref;
    return colordColor.contrast(color);
  }).color;
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/hooks/border-color.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */






 // Defining empty array here instead of inline avoids unnecessary re-renders of
// color control.

const border_color_EMPTY_ARRAY = [];
/**
 * Inspector control panel containing the border color related configuration.
 *
 * There is deliberate overlap between the colors and borders block supports
 * relating to border color. It can be argued the border color controls could
 * be included within either, or both, the colors and borders panels in the
 * inspector controls. If they share the same block attributes it should not
 * matter.
 *
 * @param {Object} props Block properties.
 *
 * @return {WPElement} Border color edit element.
 */

function BorderColorEdit(props) {
  const {
    attributes: {
      borderColor,
      style
    },
    setAttributes
  } = props;
  const colorGradientSettings = useMultipleOriginColorsAndGradients();
  const availableColors = colorGradientSettings.colors.reduce((colors, origin) => colors.concat(origin.colors), []);
  const {
    color: customBorderColor
  } = (style === null || style === void 0 ? void 0 : style.border) || {};
  const [colorValue, setColorValue] = (0,external_wp_element_namespaceObject.useState)(() => {
    var _getColorObjectByAttr;

    return (_getColorObjectByAttr = getColorObjectByAttributeValues(availableColors, borderColor, customBorderColor)) === null || _getColorObjectByAttr === void 0 ? void 0 : _getColorObjectByAttr.color;
  }); // Detect changes in the color attributes and update the colorValue to keep the
  // UI in sync. This is necessary for situations when border controls interact with
  // each other: eg, setting the border width to zero causes the color and style
  // selections to be cleared.

  (0,external_wp_element_namespaceObject.useEffect)(() => {
    var _getColorObjectByAttr2;

    setColorValue((_getColorObjectByAttr2 = getColorObjectByAttributeValues(availableColors, borderColor, customBorderColor)) === null || _getColorObjectByAttr2 === void 0 ? void 0 : _getColorObjectByAttr2.color);
  }, [borderColor, customBorderColor, availableColors]);

  const onChangeColor = value => {
    setColorValue(value);
    const colorObject = getColorObjectByColorValue(availableColors, value);
    const newStyle = { ...style,
      border: { ...(style === null || style === void 0 ? void 0 : style.border),
        color: colorObject !== null && colorObject !== void 0 && colorObject.slug ? undefined : value
      }
    }; // If empty slug, ensure undefined to remove attribute.

    const newNamedColor = colorObject !== null && colorObject !== void 0 && colorObject.slug ? colorObject.slug : undefined;
    setAttributes({
      style: cleanEmptyObject(newStyle),
      borderColor: newNamedColor
    });
  };

  const settings = [{
    label: (0,external_wp_i18n_namespaceObject.__)('Color'),
    onColorChange: onChangeColor,
    colorValue,
    clearable: false
  }];
  return (0,external_wp_element_namespaceObject.createElement)(ColorGradientSettingsDropdown, _extends({
    settings: settings,
    disableCustomColors: true,
    disableCustomGradients: true,
    __experimentalHasMultipleOrigins: true,
    __experimentalIsRenderedInSidebar: true,
    enableAlpha: true
  }, colorGradientSettings));
}
/**
 * Checks if there is a current value in the border color block support
 * attributes.
 *
 * @param {Object} props Block props.
 * @return {boolean}     Whether or not the block has a border color value set.
 */

function hasBorderColorValue(props) {
  var _style$border;

  const {
    attributes: {
      borderColor,
      style
    }
  } = props;
  return !!borderColor || !!(style !== null && style !== void 0 && (_style$border = style.border) !== null && _style$border !== void 0 && _style$border.color);
}
/**
 * Resets the border color block support attributes. This can be used when
 * disabling the border color support controls for a block via a progressive
 * discovery panel.
 *
 * @param {Object} props               Block props.
 * @param {Object} props.attributes    Block's attributes.
 * @param {Object} props.setAttributes Function to set block's attributes.
 */

function resetBorderColor(_ref) {
  let {
    attributes = {},
    setAttributes
  } = _ref;
  const {
    style
  } = attributes;
  setAttributes({
    borderColor: undefined,
    style: removeBorderAttribute(style, 'color')
  });
}
/**
 * Filters registered block settings, extending attributes to include
 * `borderColor` if needed.
 *
 * @param {Object} settings Original block settings.
 *
 * @return {Object} Updated block settings.
 */

function addAttributes(settings) {
  if (!hasBorderSupport(settings, 'color')) {
    return settings;
  } // Allow blocks to specify default value if needed.


  if (settings.attributes.borderColor) {
    return settings;
  } // Add new borderColor attribute to block settings.


  return { ...settings,
    attributes: { ...settings.attributes,
      borderColor: {
        type: 'string'
      }
    }
  };
}
/**
 * Override props assigned to save component to inject border color.
 *
 * @param {Object} props      Additional props applied to save element.
 * @param {Object} blockType  Block type definition.
 * @param {Object} attributes Block's attributes.
 *
 * @return {Object} Filtered props to apply to save element.
 */


function border_color_addSaveProps(props, blockType, attributes) {
  var _style$border2;

  if (!hasBorderSupport(blockType, 'color') || shouldSkipSerialization(blockType)) {
    return props;
  }

  const {
    borderColor,
    style
  } = attributes;
  const borderColorClass = getColorClassName('border-color', borderColor);
  const newClassName = classnames_default()(props.className, {
    'has-border-color': borderColor || (style === null || style === void 0 ? void 0 : (_style$border2 = style.border) === null || _style$border2 === void 0 ? void 0 : _style$border2.color),
    [borderColorClass]: !!borderColorClass
  }); // If we are clearing the last of the previous classes in `className`
  // set it to `undefined` to avoid rendering empty DOM attributes.

  props.className = newClassName ? newClassName : undefined;
  return props;
}
/**
 * Filters the registered block settings to apply border color styles and
 * classnames to the block edit wrapper.
 *
 * @param {Object} settings Original block settings.
 *
 * @return {Object} Filtered block settings.
 */


function addEditProps(settings) {
  if (!hasBorderSupport(settings, 'color') || shouldSkipSerialization(settings)) {
    return settings;
  }

  const existingGetEditWrapperProps = settings.getEditWrapperProps;

  settings.getEditWrapperProps = attributes => {
    let props = {};

    if (existingGetEditWrapperProps) {
      props = existingGetEditWrapperProps(attributes);
    }

    return border_color_addSaveProps(props, settings, attributes);
  };

  return settings;
}
/**
 * This adds inline styles for color palette colors.
 * Ideally, this is not needed and themes should load their palettes on the editor.
 *
 * @param {Function} BlockListBlock Original component.
 *
 * @return {Function} Wrapped component.
 */


const withBorderColorPaletteStyles = (0,external_wp_compose_namespaceObject.createHigherOrderComponent)(BlockListBlock => props => {
  var _getColorObjectByAttr3, _props$wrapperProps;

  const {
    name,
    attributes
  } = props;
  const {
    borderColor
  } = attributes;
  const colors = useSetting('color.palette') || border_color_EMPTY_ARRAY;

  if (!hasBorderSupport(name, 'color') || shouldSkipSerialization(name)) {
    return (0,external_wp_element_namespaceObject.createElement)(BlockListBlock, props);
  }

  const extraStyles = {
    borderColor: borderColor ? (_getColorObjectByAttr3 = getColorObjectByAttributeValues(colors, borderColor)) === null || _getColorObjectByAttr3 === void 0 ? void 0 : _getColorObjectByAttr3.color : undefined
  };
  let wrapperProps = props.wrapperProps;
  wrapperProps = { ...props.wrapperProps,
    style: { ...extraStyles,
      ...((_props$wrapperProps = props.wrapperProps) === null || _props$wrapperProps === void 0 ? void 0 : _props$wrapperProps.style)
    }
  };
  return (0,external_wp_element_namespaceObject.createElement)(BlockListBlock, _extends({}, props, {
    wrapperProps: wrapperProps
  }));
});
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.registerBlockType', 'core/border/addAttributes', addAttributes);
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.getSaveContent.extraProps', 'core/border/addSaveProps', border_color_addSaveProps);
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.registerBlockType', 'core/border/addEditProps', addEditProps);
(0,external_wp_hooks_namespaceObject.addFilter)('editor.BlockListBlock', 'core/border/with-border-color-palette-styles', withBorderColorPaletteStyles);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/border-radius-control/utils.js
/**
 * WordPress dependencies
 */

/**
 * Gets the (non-undefined) item with the highest occurrence within an array
 * Based in part on: https://stackoverflow.com/a/20762713
 *
 * Undefined values are always sorted to the end by `sort`, so this function
 * returns the first element, to always prioritize real values over undefined
 * values.
 *
 * See: https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/sort#description
 *
 * @param {Array<any>} inputArray Array of items to check.
 * @return {any}                  The item with the most occurrences.
 */

function mode(inputArray) {
  const arr = [...inputArray];
  return arr.sort((a, b) => inputArray.filter(v => v === b).length - inputArray.filter(v => v === a).length).shift();
}
/**
 * Returns the most common CSS unit in the radius values.
 * Falls back to `px` as a default unit.
 *
 * @param {Object|string} values Radius values.
 * @return {string}              Most common CSS unit in values. Default: `px`.
 */

function getAllUnit() {
  let values = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

  if (typeof values === 'string') {
    const [, unit] = (0,external_wp_components_namespaceObject.__experimentalParseQuantityAndUnitFromRawValue)(values);
    return unit || 'px';
  }

  const allUnits = Object.values(values).map(value => {
    const [, unit] = (0,external_wp_components_namespaceObject.__experimentalParseQuantityAndUnitFromRawValue)(value);
    return unit;
  });
  return mode(allUnits) || 'px';
}
/**
 * Gets the 'all' input value and unit from values data.
 *
 * @param {Object|string} values Radius values.
 * @return {string}              A value + unit for the 'all' input.
 */

function getAllValue() {
  let values = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

  /**
   * Border radius support was originally a single pixel value.
   *
   * To maintain backwards compatibility treat this case as the all value.
   */
  if (typeof values === 'string') {
    return values;
  }

  const parsedQuantitiesAndUnits = Object.values(values).map(value => (0,external_wp_components_namespaceObject.__experimentalParseQuantityAndUnitFromRawValue)(value));
  const allValues = parsedQuantitiesAndUnits.map(value => {
    var _value$;

    return (_value$ = value[0]) !== null && _value$ !== void 0 ? _value$ : '';
  });
  const allUnits = parsedQuantitiesAndUnits.map(value => value[1]);
  const value = allValues.every(v => v === allValues[0]) ? allValues[0] : '';
  const unit = mode(allUnits);
  const allValue = value === 0 || value ? `${value}${unit}` : undefined;
  return allValue;
}
/**
 * Checks to determine if values are mixed.
 *
 * @param {Object} values Radius values.
 * @return {boolean}      Whether values are mixed.
 */

function hasMixedValues() {
  let values = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  const allValue = getAllValue(values);
  const isMixed = isNaN(parseFloat(allValue));
  return isMixed;
}
/**
 * Checks to determine if values are defined.
 *
 * @param {Object} values Radius values.
 * @return {boolean}      Whether values are mixed.
 */

function hasDefinedValues(values) {
  if (!values) {
    return false;
  } // A string value represents a shorthand value.


  if (typeof values === 'string') {
    return true;
  } // An object represents longhand border radius values, if any are set
  // flag values as being defined.


  const filteredValues = Object.values(values).filter(value => {
    return !!value || value === 0;
  });
  return !!filteredValues.length;
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/border-radius-control/all-input-control.js



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function AllInputControl(_ref) {
  let {
    onChange,
    values,
    ...props
  } = _ref;
  const allValue = getAllValue(values);
  const hasValues = hasDefinedValues(values);
  const isMixed = hasValues && hasMixedValues(values);
  const allPlaceholder = isMixed ? (0,external_wp_i18n_namespaceObject.__)('Mixed') : null;
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalUnitControl, _extends({}, props, {
    "aria-label": (0,external_wp_i18n_namespaceObject.__)('Border radius'),
    disableUnits: isMixed,
    isOnly: true,
    value: allValue,
    onChange: onChange,
    placeholder: allPlaceholder
  }));
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/border-radius-control/input-controls.js



/**
 * WordPress dependencies
 */


const CORNERS = {
  topLeft: (0,external_wp_i18n_namespaceObject.__)('Top left'),
  topRight: (0,external_wp_i18n_namespaceObject.__)('Top right'),
  bottomLeft: (0,external_wp_i18n_namespaceObject.__)('Bottom left'),
  bottomRight: (0,external_wp_i18n_namespaceObject.__)('Bottom right')
};
function BoxInputControls(_ref) {
  let {
    onChange,
    values: valuesProp,
    ...props
  } = _ref;

  const createHandleOnChange = corner => next => {
    if (!onChange) {
      return;
    }

    onChange({ ...values,
      [corner]: next ? next : undefined
    });
  }; // For shorthand style & backwards compatibility, handle flat string value.


  const values = typeof valuesProp !== 'string' ? valuesProp : {
    topLeft: valuesProp,
    topRight: valuesProp,
    bottomLeft: valuesProp,
    bottomRight: valuesProp
  }; // Controls are wrapped in tooltips as visible labels aren't desired here.

  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "components-border-radius-control__input-controls-wrapper"
  }, Object.entries(CORNERS).map(_ref2 => {
    let [key, label] = _ref2;
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalUnitControl, _extends({}, props, {
      key: key,
      "aria-label": label,
      value: values[key],
      onChange: createHandleOnChange(key)
    }));
  }));
}

;// CONCATENATED MODULE: ./packages/icons/build-module/library/link.js


/**
 * WordPress dependencies
 */

const link_link = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M15.6 7.2H14v1.5h1.6c2 0 3.7 1.7 3.7 3.7s-1.7 3.7-3.7 3.7H14v1.5h1.6c2.8 0 5.2-2.3 5.2-5.2 0-2.9-2.3-5.2-5.2-5.2zM4.7 12.4c0-2 1.7-3.7 3.7-3.7H10V7.2H8.4c-2.9 0-5.2 2.3-5.2 5.2 0 2.9 2.3 5.2 5.2 5.2H10v-1.5H8.4c-2 0-3.7-1.7-3.7-3.7zm4.6.9h5.3v-1.5H9.3v1.5z"
}));
/* harmony default export */ var library_link = (link_link);

;// CONCATENATED MODULE: ./packages/icons/build-module/library/link-off.js


/**
 * WordPress dependencies
 */

const linkOff = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M15.6 7.3h-.7l1.6-3.5-.9-.4-3.9 8.5H9v1.5h2l-1.3 2.8H8.4c-2 0-3.7-1.7-3.7-3.7s1.7-3.7 3.7-3.7H10V7.3H8.4c-2.9 0-5.2 2.3-5.2 5.2 0 2.9 2.3 5.2 5.2 5.2H9l-1.4 3.2.9.4 5.7-12.5h1.4c2 0 3.7 1.7 3.7 3.7s-1.7 3.7-3.7 3.7H14v1.5h1.6c2.9 0 5.2-2.3 5.2-5.2 0-2.9-2.4-5.2-5.2-5.2z"
}));
/* harmony default export */ var link_off = (linkOff);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/border-radius-control/linked-button.js



/**
 * WordPress dependencies
 */



function LinkedButton(_ref) {
  let {
    isLinked,
    ...props
  } = _ref;
  const label = isLinked ? (0,external_wp_i18n_namespaceObject.__)('Unlink Radii') : (0,external_wp_i18n_namespaceObject.__)('Link Radii');
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Tooltip, {
    text: label
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, _extends({}, props, {
    className: "component-border-radius-control__linked-button",
    isPrimary: isLinked,
    isSecondary: !isLinked,
    isSmall: true,
    icon: isLinked ? library_link : link_off,
    iconSize: 16,
    "aria-label": label
  })));
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/border-radius-control/index.js


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






const DEFAULT_VALUES = {
  topLeft: null,
  topRight: null,
  bottomLeft: null,
  bottomRight: null
};
const MIN_BORDER_RADIUS_VALUE = 0;
const MAX_BORDER_RADIUS_VALUES = {
  px: 100,
  em: 20,
  rem: 20
};
/**
 * Control to display border radius options.
 *
 * @param {Object}   props          Component props.
 * @param {Function} props.onChange Callback to handle onChange.
 * @param {Object}   props.values   Border radius values.
 *
 * @return {WPElement}              Custom border radius control.
 */

function BorderRadiusControl(_ref) {
  let {
    onChange,
    values
  } = _ref;
  const [isLinked, setIsLinked] = (0,external_wp_element_namespaceObject.useState)(!hasDefinedValues(values) || !hasMixedValues(values));
  const units = (0,external_wp_components_namespaceObject.__experimentalUseCustomUnits)({
    availableUnits: useSetting('spacing.units') || ['px', 'em', 'rem']
  });
  const unit = getAllUnit(values);
  const unitConfig = units && units.find(item => item.value === unit);
  const step = (unitConfig === null || unitConfig === void 0 ? void 0 : unitConfig.step) || 1;
  const [allValue] = (0,external_wp_components_namespaceObject.__experimentalParseQuantityAndUnitFromRawValue)(getAllValue(values));

  const toggleLinked = () => setIsLinked(!isLinked);

  const handleSliderChange = next => {
    onChange(next !== undefined ? `${next}${unit}` : undefined);
  };

  return (0,external_wp_element_namespaceObject.createElement)("fieldset", {
    className: "components-border-radius-control"
  }, (0,external_wp_element_namespaceObject.createElement)("legend", null, (0,external_wp_i18n_namespaceObject.__)('Radius')), (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "components-border-radius-control__wrapper"
  }, isLinked ? (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(AllInputControl, {
    className: "components-border-radius-control__unit-control",
    values: values,
    min: MIN_BORDER_RADIUS_VALUE,
    onChange: onChange,
    unit: unit,
    units: units
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.RangeControl, {
    className: "components-border-radius-control__range-control",
    value: allValue !== null && allValue !== void 0 ? allValue : '',
    min: MIN_BORDER_RADIUS_VALUE,
    max: MAX_BORDER_RADIUS_VALUES[unit],
    initialPosition: 0,
    withInputField: false,
    onChange: handleSliderChange,
    step: step
  })) : (0,external_wp_element_namespaceObject.createElement)(BoxInputControls, {
    min: MIN_BORDER_RADIUS_VALUE,
    onChange: onChange,
    values: values || DEFAULT_VALUES,
    units: units
  }), (0,external_wp_element_namespaceObject.createElement)(LinkedButton, {
    onClick: toggleLinked,
    isLinked: isLinked
  })));
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/hooks/border-radius.js


/**
 * Internal dependencies
 */



/**
 * Inspector control panel containing the border radius related configuration.
 *
 * @param {Object} props Block properties.
 *
 * @return {WPElement} Border radius edit element.
 */

function BorderRadiusEdit(props) {
  var _style$border;

  const {
    attributes: {
      style
    },
    setAttributes
  } = props;

  const onChange = newRadius => {
    let newStyle = { ...style,
      border: { ...(style === null || style === void 0 ? void 0 : style.border),
        radius: newRadius
      }
    };

    if (newRadius === undefined || newRadius === '') {
      newStyle = cleanEmptyObject(newStyle);
    }

    setAttributes({
      style: newStyle
    });
  };

  return (0,external_wp_element_namespaceObject.createElement)(BorderRadiusControl, {
    values: style === null || style === void 0 ? void 0 : (_style$border = style.border) === null || _style$border === void 0 ? void 0 : _style$border.radius,
    onChange: onChange
  });
}
/**
 * Checks if there is a current value in the border radius block support
 * attributes.
 *
 * @param {Object} props Block props.
 * @return {boolean}     Whether or not the block has a border radius value set.
 */

function hasBorderRadiusValue(props) {
  var _props$attributes$sty, _props$attributes$sty2;

  const borderRadius = (_props$attributes$sty = props.attributes.style) === null || _props$attributes$sty === void 0 ? void 0 : (_props$attributes$sty2 = _props$attributes$sty.border) === null || _props$attributes$sty2 === void 0 ? void 0 : _props$attributes$sty2.radius;

  if (typeof borderRadius === 'object') {
    return Object.entries(borderRadius).some(Boolean);
  }

  return !!borderRadius;
}
/**
 * Resets the border radius block support attributes. This can be used when
 * disabling the border radius support controls for a block via a progressive
 * discovery panel.
 *
 * @param {Object} props               Block props.
 * @param {Object} props.attributes    Block's attributes.
 * @param {Object} props.setAttributes Function to set block's attributes.
 */

function resetBorderRadius(_ref) {
  let {
    attributes = {},
    setAttributes
  } = _ref;
  const {
    style
  } = attributes;
  setAttributes({
    style: removeBorderAttribute(style, 'radius')
  });
}

;// CONCATENATED MODULE: ./packages/icons/build-module/library/line-solid.js


/**
 * WordPress dependencies
 */

const lineSolid = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  width: "24",
  height: "24",
  fill: "none"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M5 11.25h14v1.5H5z"
}));
/* harmony default export */ var line_solid = (lineSolid);

;// CONCATENATED MODULE: ./packages/icons/build-module/library/line-dashed.js


/**
 * WordPress dependencies
 */

const lineDashed = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  width: "24",
  height: "24",
  fill: "none"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  fillRule: "evenodd",
  d: "M5 11.25h3v1.5H5v-1.5zm5.5 0h3v1.5h-3v-1.5zm8.5 0h-3v1.5h3v-1.5z",
  clipRule: "evenodd"
}));
/* harmony default export */ var line_dashed = (lineDashed);

;// CONCATENATED MODULE: ./packages/icons/build-module/library/line-dotted.js


/**
 * WordPress dependencies
 */

const lineDotted = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  width: "24",
  height: "24",
  fill: "none"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  fillRule: "evenodd",
  d: "M5.25 11.25h1.5v1.5h-1.5v-1.5zm3 0h1.5v1.5h-1.5v-1.5zm4.5 0h-1.5v1.5h1.5v-1.5zm1.5 0h1.5v1.5h-1.5v-1.5zm4.5 0h-1.5v1.5h1.5v-1.5z",
  clipRule: "evenodd"
}));
/* harmony default export */ var line_dotted = (lineDotted);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/border-style-control/index.js


/**
 * WordPress dependencies
 */



const BORDER_STYLES = [{
  label: (0,external_wp_i18n_namespaceObject.__)('Solid'),
  icon: line_solid,
  value: 'solid'
}, {
  label: (0,external_wp_i18n_namespaceObject.__)('Dashed'),
  icon: line_dashed,
  value: 'dashed'
}, {
  label: (0,external_wp_i18n_namespaceObject.__)('Dotted'),
  icon: line_dotted,
  value: 'dotted'
}];
/**
 * Control to display border style options.
 *
 * @param {Object}   props          Component props.
 * @param {Function} props.onChange Handler for changing border style selection.
 * @param {string}   props.value    Currently selected border style value.
 *
 * @return {WPElement} Custom border style segmented control.
 */

function BorderStyleControl(_ref) {
  let {
    onChange,
    value
  } = _ref;
  return (0,external_wp_element_namespaceObject.createElement)("fieldset", {
    className: "components-border-style-control"
  }, (0,external_wp_element_namespaceObject.createElement)("legend", null, (0,external_wp_i18n_namespaceObject.__)('Style')), (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "components-border-style-control__buttons"
  }, BORDER_STYLES.map(borderStyle => (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
    key: borderStyle.value,
    icon: borderStyle.icon,
    isSmall: true,
    isPressed: borderStyle.value === value,
    onClick: () => onChange(borderStyle.value === value ? undefined : borderStyle.value),
    "aria-label": borderStyle.label
  }))));
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/hooks/border-style.js


/**
 * Internal dependencies
 */



/**
 * Inspector control for configuring border style property.
 *
 * @param {Object} props Block properties.
 *
 * @return {WPElement} Border style edit element.
 */

const BorderStyleEdit = props => {
  var _style$border;

  const {
    attributes: {
      style
    },
    setAttributes
  } = props;

  const onChange = newBorderStyle => {
    const newStyleAttributes = { ...style,
      border: { ...(style === null || style === void 0 ? void 0 : style.border),
        style: newBorderStyle
      }
    };
    setAttributes({
      style: cleanEmptyObject(newStyleAttributes)
    });
  };

  return (0,external_wp_element_namespaceObject.createElement)(BorderStyleControl, {
    value: style === null || style === void 0 ? void 0 : (_style$border = style.border) === null || _style$border === void 0 ? void 0 : _style$border.style,
    onChange: onChange
  });
};
/**
 * Checks if there is a current value in the border style block support
 * attributes.
 *
 * @param {Object} props Block props.
 * @return {boolean}     Whether or not the block has a border style value set.
 */

function hasBorderStyleValue(props) {
  var _props$attributes$sty, _props$attributes$sty2;

  return !!((_props$attributes$sty = props.attributes.style) !== null && _props$attributes$sty !== void 0 && (_props$attributes$sty2 = _props$attributes$sty.border) !== null && _props$attributes$sty2 !== void 0 && _props$attributes$sty2.style);
}
/**
 * Resets the border style block support attribute. This can be used when
 * disabling the border style support control for a block via a progressive
 * discovery panel.
 *
 * @param {Object} props               Block props.
 * @param {Object} props.attributes    Block's attributes.
 * @param {Object} props.setAttributes Function to set block's attributes.
 */

function resetBorderStyle(_ref) {
  let {
    attributes = {},
    setAttributes
  } = _ref;
  const {
    style
  } = attributes;
  setAttributes({
    style: removeBorderAttribute(style, 'style')
  });
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/hooks/border-width.js


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




const MIN_BORDER_WIDTH = 0;
/**
 * Inspector control for configuring border width property.
 *
 * @param {Object} props Block properties.
 *
 * @return {WPElement} Border width edit element.
 */

const BorderWidthEdit = props => {
  const {
    attributes: {
      borderColor,
      style
    },
    setAttributes
  } = props;
  const {
    width,
    color: customBorderColor,
    style: borderStyle
  } = (style === null || style === void 0 ? void 0 : style.border) || {}; // Used to temporarily track previous border color & style selections to be
  // able to restore them when border width changes from zero value.

  const [styleSelection, setStyleSelection] = (0,external_wp_element_namespaceObject.useState)();
  const [colorSelection, setColorSelection] = (0,external_wp_element_namespaceObject.useState)();
  const [customColorSelection, setCustomColorSelection] = (0,external_wp_element_namespaceObject.useState)();

  const onChange = newWidth => {
    let newStyle = { ...style,
      border: { ...(style === null || style === void 0 ? void 0 : style.border),
        width: newWidth
      }
    }; // Used to clear named border color attribute.

    let borderPaletteColor = borderColor;
    const hasZeroWidth = parseFloat(newWidth) === 0;
    const hadPreviousZeroWidth = parseFloat(width) === 0; // Setting the border width explicitly to zero will also set the
    // border style to `none` and clear border color attributes.

    if (hasZeroWidth && !hadPreviousZeroWidth) {
      // Before clearing color and style selections, keep track of
      // the current selections so they can be restored when the width
      // changes to a non-zero value.
      setColorSelection(borderColor);
      setCustomColorSelection(customBorderColor);
      setStyleSelection(borderStyle); // Clear style and color attributes.

      borderPaletteColor = undefined;
      newStyle.border.color = undefined;
      newStyle.border.style = 'none';
    }

    if (!hasZeroWidth && hadPreviousZeroWidth) {
      // Restore previous border style selection if width is now not zero and
      // border style was 'none'. This is to support changes to the UI which
      // change the border style UI to a segmented control without a "none"
      // option.
      if (borderStyle === 'none') {
        newStyle.border.style = styleSelection;
      } // Restore previous border color selection if width is no longer zero
      // and current border color is undefined.


      if (borderColor === undefined) {
        borderPaletteColor = colorSelection;
        newStyle.border.color = customColorSelection;
      }
    } // If width was reset, clean out undefined styles.


    if (newWidth === undefined || newWidth === '') {
      newStyle = cleanEmptyObject(newStyle);
    }

    setAttributes({
      borderColor: borderPaletteColor,
      style: newStyle
    });
  };

  const units = (0,external_wp_components_namespaceObject.__experimentalUseCustomUnits)({
    availableUnits: useSetting('spacing.units') || ['px', 'em', 'rem']
  });
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalUnitControl, {
    value: width,
    label: (0,external_wp_i18n_namespaceObject.__)('Width'),
    min: MIN_BORDER_WIDTH,
    onChange: onChange,
    units: units
  });
};
/**
 * Checks if there is a current value in the border width block support
 * attributes.
 *
 * @param {Object} props Block props.
 * @return {boolean}     Whether or not the block has a border width value set.
 */

function hasBorderWidthValue(props) {
  var _props$attributes$sty, _props$attributes$sty2;

  return !!((_props$attributes$sty = props.attributes.style) !== null && _props$attributes$sty !== void 0 && (_props$attributes$sty2 = _props$attributes$sty.border) !== null && _props$attributes$sty2 !== void 0 && _props$attributes$sty2.width);
}
/**
 * Resets the border width block support attribute. This can be used when
 * disabling the border width support control for a block via a progressive
 * discovery panel.
 *
 * @param {Object} props               Block props.
 * @param {Object} props.attributes    Block's attributes.
 * @param {Object} props.setAttributes Function to set block's attributes.
 */

function resetBorderWidth(_ref) {
  let {
    attributes = {},
    setAttributes
  } = _ref;
  const {
    style
  } = attributes;
  setAttributes({
    style: removeBorderAttribute(style, 'width')
  });
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/hooks/border.js


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */








const BORDER_SUPPORT_KEY = '__experimentalBorder';
function BorderPanel(props) {
  const {
    clientId
  } = props;
  const isColorSupported = useSetting('border.color') && hasBorderSupport(props.name, 'color');
  const isRadiusSupported = useSetting('border.radius') && hasBorderSupport(props.name, 'radius');
  const isStyleSupported = useSetting('border.style') && hasBorderSupport(props.name, 'style');
  const isWidthSupported = useSetting('border.width') && hasBorderSupport(props.name, 'width');
  const isDisabled = [!isColorSupported, !isRadiusSupported, !isStyleSupported, !isWidthSupported].every(Boolean);

  if (isDisabled) {
    return null;
  }

  const defaultBorderControls = (0,external_wp_blocks_namespaceObject.getBlockSupport)(props.name, [BORDER_SUPPORT_KEY, '__experimentalDefaultControls']);

  const createResetAllFilter = function (borderAttribute) {
    let topLevelAttributes = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    return newAttributes => {
      var _newAttributes$style;

      return { ...newAttributes,
        ...topLevelAttributes,
        style: { ...newAttributes.style,
          border: { ...((_newAttributes$style = newAttributes.style) === null || _newAttributes$style === void 0 ? void 0 : _newAttributes$style.border),
            [borderAttribute]: undefined
          }
        }
      };
    };
  };

  return (0,external_wp_element_namespaceObject.createElement)(inspector_controls, {
    __experimentalGroup: "border"
  }, isWidthSupported && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToolsPanelItem, {
    className: "single-column",
    hasValue: () => hasBorderWidthValue(props),
    label: (0,external_wp_i18n_namespaceObject.__)('Width'),
    onDeselect: () => resetBorderWidth(props),
    isShownByDefault: defaultBorderControls === null || defaultBorderControls === void 0 ? void 0 : defaultBorderControls.width,
    resetAllFilter: createResetAllFilter('width'),
    panelId: clientId
  }, (0,external_wp_element_namespaceObject.createElement)(BorderWidthEdit, props)), isStyleSupported && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToolsPanelItem, {
    className: "single-column",
    hasValue: () => hasBorderStyleValue(props),
    label: (0,external_wp_i18n_namespaceObject.__)('Style'),
    onDeselect: () => resetBorderStyle(props),
    isShownByDefault: defaultBorderControls === null || defaultBorderControls === void 0 ? void 0 : defaultBorderControls.style,
    resetAllFilter: createResetAllFilter('style'),
    panelId: clientId
  }, (0,external_wp_element_namespaceObject.createElement)(BorderStyleEdit, props)), isColorSupported && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToolsPanelItem, {
    hasValue: () => hasBorderColorValue(props),
    label: (0,external_wp_i18n_namespaceObject.__)('Color'),
    onDeselect: () => resetBorderColor(props),
    isShownByDefault: defaultBorderControls === null || defaultBorderControls === void 0 ? void 0 : defaultBorderControls.color,
    resetAllFilter: createResetAllFilter('color', {
      borderColor: undefined
    }),
    panelId: clientId
  }, (0,external_wp_element_namespaceObject.createElement)(BorderColorEdit, props)), isRadiusSupported && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToolsPanelItem, {
    hasValue: () => hasBorderRadiusValue(props),
    label: (0,external_wp_i18n_namespaceObject.__)('Radius'),
    onDeselect: () => resetBorderRadius(props),
    isShownByDefault: defaultBorderControls === null || defaultBorderControls === void 0 ? void 0 : defaultBorderControls.radius,
    resetAllFilter: createResetAllFilter('radius'),
    panelId: clientId
  }, (0,external_wp_element_namespaceObject.createElement)(BorderRadiusEdit, props)));
}
/**
 * Determine whether there is block support for border properties.
 *
 * @param {string} blockName Block name.
 * @param {string} feature   Border feature to check support for.
 *
 * @return {boolean} Whether there is support.
 */

function hasBorderSupport(blockName) {
  let feature = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'any';

  if (external_wp_element_namespaceObject.Platform.OS !== 'web') {
    return false;
  }

  const support = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockName, BORDER_SUPPORT_KEY);

  if (support === true) {
    return true;
  }

  if (feature === 'any') {
    return !!(support !== null && support !== void 0 && support.color || support !== null && support !== void 0 && support.radius || support !== null && support !== void 0 && support.width || support !== null && support !== void 0 && support.style);
  }

  return !!(support !== null && support !== void 0 && support[feature]);
}
/**
 * Check whether serialization of border classes and styles should be skipped.
 *
 * @param {string|Object} blockType Block name or block type object.
 *
 * @return {boolean} Whether serialization of border properties should occur.
 */

function shouldSkipSerialization(blockType) {
  const support = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockType, BORDER_SUPPORT_KEY);
  return support === null || support === void 0 ? void 0 : support.__experimentalSkipSerialization;
}
/**
 * Returns a new style object where the specified border attribute has been
 * removed.
 *
 * @param {Object} style     Styles from block attributes.
 * @param {string} attribute The border style attribute to clear.
 *
 * @return {Object} Style object with the specified attribute removed.
 */

function removeBorderAttribute(style, attribute) {
  return cleanEmptyObject({ ...style,
    border: { ...(style === null || style === void 0 ? void 0 : style.border),
      [attribute]: undefined
    }
  });
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/gradients/use-gradient.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function __experimentalGetGradientClass(gradientSlug) {
  if (!gradientSlug) {
    return undefined;
  }

  return `has-${gradientSlug}-gradient-background`;
}
/**
 * Retrieves the gradient value per slug.
 *
 * @param {Array}  gradients Gradient Palette
 * @param {string} slug      Gradient slug
 *
 * @return {string} Gradient value.
 */

function getGradientValueBySlug(gradients, slug) {
  const gradient = (0,external_lodash_namespaceObject.find)(gradients, ['slug', slug]);
  return gradient && gradient.gradient;
}
function __experimentalGetGradientObjectByGradientValue(gradients, value) {
  const gradient = (0,external_lodash_namespaceObject.find)(gradients, ['gradient', value]);
  return gradient;
}
/**
 * Retrieves the gradient slug per slug.
 *
 * @param {Array}  gradients Gradient Palette
 * @param {string} value     Gradient value
 * @return {string} Gradient slug.
 */

function getGradientSlugByValue(gradients, value) {
  const gradient = __experimentalGetGradientObjectByGradientValue(gradients, value);

  return gradient && gradient.slug;
}
function __experimentalUseGradient() {
  let {
    gradientAttribute = 'gradient',
    customGradientAttribute = 'customGradient'
  } = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  const {
    clientId
  } = useBlockEditContext();
  const userGradientPalette = useSetting('color.gradients.custom');
  const themeGradientPalette = useSetting('color.gradients.theme');
  const defaultGradientPalette = useSetting('color.gradients.default');
  const allGradients = (0,external_wp_element_namespaceObject.useMemo)(() => [...(userGradientPalette || []), ...(themeGradientPalette || []), ...(defaultGradientPalette || [])], [userGradientPalette, themeGradientPalette, defaultGradientPalette]);
  const {
    gradient,
    customGradient
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getBlockAttributes
    } = select(store);
    const attributes = getBlockAttributes(clientId) || {};
    return {
      customGradient: attributes[customGradientAttribute],
      gradient: attributes[gradientAttribute]
    };
  }, [clientId, gradientAttribute, customGradientAttribute]);
  const {
    updateBlockAttributes
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const setGradient = (0,external_wp_element_namespaceObject.useCallback)(newGradientValue => {
    const slug = getGradientSlugByValue(allGradients, newGradientValue);

    if (slug) {
      updateBlockAttributes(clientId, {
        [gradientAttribute]: slug,
        [customGradientAttribute]: undefined
      });
      return;
    }

    updateBlockAttributes(clientId, {
      [gradientAttribute]: undefined,
      [customGradientAttribute]: newGradientValue
    });
  }, [allGradients, clientId, updateBlockAttributes]);

  const gradientClass = __experimentalGetGradientClass(gradient);

  let gradientValue;

  if (gradient) {
    gradientValue = getGradientValueBySlug(allGradients, gradient);
  } else {
    gradientValue = customGradient;
  }

  return {
    gradientClass,
    gradientValue,
    setGradient
  };
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/contrast-checker/index.js


/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */




k([names, a11y]);

function ContrastChecker(_ref) {
  let {
    backgroundColor,
    fallbackBackgroundColor,
    fallbackTextColor,
    fallbackLinkColor,
    fontSize,
    // Font size value in pixels.
    isLargeText,
    textColor,
    linkColor,
    enableAlphaChecker = false
  } = _ref;
  const currentBackgroundColor = backgroundColor || fallbackBackgroundColor; // Must have a background color.

  if (!currentBackgroundColor) {
    return null;
  }

  const currentTextColor = textColor || fallbackTextColor;
  const currentLinkColor = linkColor || fallbackLinkColor; // Must have at least one text color.

  if (!currentTextColor && !currentLinkColor) {
    return null;
  }

  const textColors = [{
    color: currentTextColor,
    description: (0,external_wp_i18n_namespaceObject.__)('text color')
  }, {
    color: currentLinkColor,
    description: (0,external_wp_i18n_namespaceObject.__)('link color')
  }];
  const colordBackgroundColor = w(currentBackgroundColor);
  const backgroundColorHasTransparency = colordBackgroundColor.alpha() < 1;
  const backgroundColorBrightness = colordBackgroundColor.brightness();
  const isReadableOptions = {
    level: 'AA',
    size: isLargeText || isLargeText !== false && fontSize >= 24 ? 'large' : 'small'
  };
  let message = '';
  let speakMessage = '';

  for (const item of textColors) {
    // If there is no color, go no further.
    if (!item.color) {
      continue;
    }

    const colordTextColor = w(item.color);
    const isColordTextReadable = colordTextColor.isReadable(colordBackgroundColor, isReadableOptions);
    const textHasTransparency = colordTextColor.alpha() < 1; // If the contrast is not readable.

    if (!isColordTextReadable) {
      // Don't show the message if the background or text is transparent.
      if (backgroundColorHasTransparency || textHasTransparency) {
        continue;
      }

      message = backgroundColorBrightness < colordTextColor.brightness() ? (0,external_wp_i18n_namespaceObject.sprintf)( // translators: %s is a type of text color, e.g., "text color" or "link color".
      (0,external_wp_i18n_namespaceObject.__)('This color combination may be hard for people to read. Try using a darker background color and/or a brighter %s.'), item.description) : (0,external_wp_i18n_namespaceObject.sprintf)( // translators: %s is a type of text color, e.g., "text color" or "link color".
      (0,external_wp_i18n_namespaceObject.__)('This color combination may be hard for people to read. Try using a brighter background color and/or a darker %s.'), item.description);
      speakMessage = (0,external_wp_i18n_namespaceObject.__)('This color combination may be hard for people to read.'); // Break from the loop when we have a contrast warning.
      // These messages take priority over the transparency warning.

      break;
    } // If there is no contrast warning and the text is transparent,
    // show the transparent warning if alpha check is enabled.


    if (textHasTransparency && enableAlphaChecker) {
      message = (0,external_wp_i18n_namespaceObject.__)('Transparent text may be hard for people to read.');
      speakMessage = (0,external_wp_i18n_namespaceObject.__)('Transparent text may be hard for people to read.');
    }
  }

  if (!message) {
    return null;
  } // Note: The `Notice` component can speak messages via its `spokenMessage`
  // prop, but the contrast checker requires granular control over when the
  // announcements are made. Notably, the message will be re-announced if a
  // new color combination is selected and the contrast is still insufficient.


  (0,external_wp_a11y_namespaceObject.speak)(speakMessage);
  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-contrast-checker"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Notice, {
    spokenMessage: null,
    status: "warning",
    isDismissible: false
  }, message));
}

/* harmony default export */ var contrast_checker = (ContrastChecker);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/colors-gradients/tools-panel-color-dropdown.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function ToolsPanelColorDropdown(_ref) {
  var _settings$gradientVal;

  let {
    settings,
    enableAlpha,
    ...otherProps
  } = _ref;
  const colorGradientSettings = useMultipleOriginColorsAndGradients();
  const controlSettings = { ...colorGradientSettings,
    clearable: false,
    enableAlpha,
    label: settings.label,
    onColorChange: settings.onColorChange,
    onGradientChange: settings.onGradientChange,
    colorValue: settings.colorValue,
    gradientValue: settings.gradientValue
  };
  const selectedColor = (_settings$gradientVal = settings.gradientValue) !== null && _settings$gradientVal !== void 0 ? _settings$gradientVal : settings.colorValue;
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToolsPanelItem, _extends({
    hasValue: settings.hasValue,
    label: settings.label,
    onDeselect: settings.onDeselect,
    isShownByDefault: settings.isShownByDefault,
    resetAllFilter: settings.resetAllFilter
  }, otherProps, {
    className: "block-editor-tools-panel-color-gradient-settings__item"
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Dropdown, {
    className: "block-editor-tools-panel-color-dropdown",
    contentClassName: "block-editor-panel-color-gradient-settings__dropdown-content",
    renderToggle: _ref2 => {
      let {
        isOpen,
        onToggle
      } = _ref2;
      return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
        onClick: onToggle,
        "aria-expanded": isOpen,
        className: classnames_default()('block-editor-panel-color-gradient-settings__dropdown', {
          'is-open': isOpen
        })
      }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalHStack, {
        justify: "flex-start"
      }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ColorIndicator, {
        className: "block-editor-panel-color-gradient-settings__color-indicator",
        colorValue: selectedColor
      }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.FlexItem, null, settings.label)));
    },
    renderContent: () => (0,external_wp_element_namespaceObject.createElement)(control, _extends({
      showTitle: false,
      __experimentalHasMultipleOrigins: true,
      __experimentalIsRenderedInSidebar: true,
      enableAlpha: true
    }, controlSettings))
  }));
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/hooks/color-panel.js


/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */






function getComputedStyle(node) {
  return node.ownerDocument.defaultView.getComputedStyle(node);
}

function ColorPanel(_ref) {
  let {
    enableAlpha = false,
    settings,
    clientId,
    enableContrastChecking = true
  } = _ref;
  const [detectedBackgroundColor, setDetectedBackgroundColor] = (0,external_wp_element_namespaceObject.useState)();
  const [detectedColor, setDetectedColor] = (0,external_wp_element_namespaceObject.useState)();
  const [detectedLinkColor, setDetectedLinkColor] = (0,external_wp_element_namespaceObject.useState)();
  const ref = useBlockRef(clientId);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    var _ref$current;

    if (!enableContrastChecking) {
      return;
    }

    if (!ref.current) {
      return;
    }

    setDetectedColor(getComputedStyle(ref.current).color);
    const firstLinkElement = (_ref$current = ref.current) === null || _ref$current === void 0 ? void 0 : _ref$current.querySelector('a');

    if (firstLinkElement && !!firstLinkElement.innerText) {
      setDetectedLinkColor(getComputedStyle(firstLinkElement).color);
    }

    let backgroundColorNode = ref.current;
    let backgroundColor = getComputedStyle(backgroundColorNode).backgroundColor;

    while (backgroundColor === 'rgba(0, 0, 0, 0)' && backgroundColorNode.parentNode && backgroundColorNode.parentNode.nodeType === backgroundColorNode.parentNode.ELEMENT_NODE) {
      backgroundColorNode = backgroundColorNode.parentNode;
      backgroundColor = getComputedStyle(backgroundColorNode).backgroundColor;
    }

    setDetectedBackgroundColor(backgroundColor);
  });
  return (0,external_wp_element_namespaceObject.createElement)(inspector_controls, {
    __experimentalGroup: "color"
  }, settings.map((setting, index) => (0,external_wp_element_namespaceObject.createElement)(ToolsPanelColorDropdown, {
    key: index,
    settings: setting,
    panelId: clientId,
    enableAlpha: enableAlpha
  })), enableContrastChecking && (0,external_wp_element_namespaceObject.createElement)(contrast_checker, {
    backgroundColor: detectedBackgroundColor,
    textColor: detectedColor,
    enableAlphaChecker: enableAlpha,
    linkColor: detectedLinkColor
  }));
}

;// CONCATENATED MODULE: ./packages/block-editor/build-module/hooks/color.js



/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */






const COLOR_SUPPORT_KEY = 'color';

const hasColorSupport = blockType => {
  const colorSupport = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockType, COLOR_SUPPORT_KEY);
  return colorSupport && (colorSupport.link === true || colorSupport.gradient === true || colorSupport.background !== false || colorSupport.text !== false);
};

const color_shouldSkipSerialization = blockType => {
  const colorSupport = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockType, COLOR_SUPPORT_KEY);
  return colorSupport === null || colorSupport === void 0 ? void 0 : colorSupport.__experimentalSkipSerialization;
};

const hasLinkColorSupport = blockType => {
  if (external_wp_element_namespaceObject.Platform.OS !== 'web') {
    return false;
  }

  const colorSupport = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockType, COLOR_SUPPORT_KEY);
  return (0,external_lodash_namespaceObject.isObject)(colorSupport) && !!colorSupport.link;
};

const hasGradientSupport = blockType => {
  const colorSupport = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockType, COLOR_SUPPORT_KEY);
  return (0,external_lodash_namespaceObject.isObject)(colorSupport) && !!colorSupport.gradients;
};

const hasBackgroundColorSupport = blockType => {
  const colorSupport = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockType, COLOR_SUPPORT_KEY);
  return colorSupport && colorSupport.background !== false;
};

const hasTextColorSupport = blockType => {
  const colorSupport = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockType, COLOR_SUPPORT_KEY);
  return colorSupport && colorSupport.text !== false;
};
/**
 * Checks whether a color has been set either with a named preset color in
 * a top level block attribute or as a custom value within the style attribute
 * object.
 *
 * @param {string} name Name of the color to check.
 * @return {boolean} Whether or not a color has a value.
 */


const hasColor = name => props => {
  var _props$attributes$sty9, _props$attributes$sty10;

  if (name === 'background') {
    var _props$attributes$sty, _props$attributes$sty2, _props$attributes$sty3, _props$attributes$sty4;

    return !!props.attributes.backgroundColor || !!((_props$attributes$sty = props.attributes.style) !== null && _props$attributes$sty !== void 0 && (_props$attributes$sty2 = _props$attributes$sty.color) !== null && _props$attributes$sty2 !== void 0 && _props$attributes$sty2.background) || !!props.attributes.gradient || !!((_props$attributes$sty3 = props.attributes.style) !== null && _props$attributes$sty3 !== void 0 && (_props$attributes$sty4 = _props$attributes$sty3.color) !== null && _props$attributes$sty4 !== void 0 && _props$attributes$sty4.gradient);
  }

  if (name === 'link') {
    var _props$attributes$sty5, _props$attributes$sty6, _props$attributes$sty7, _props$attributes$sty8;

    return !!((_props$attributes$sty5 = props.attributes.style) !== null && _props$attributes$sty5 !== void 0 && (_props$attributes$sty6 = _props$attributes$sty5.elements) !== null && _props$attributes$sty6 !== void 0 && (_props$attributes$sty7 = _props$attributes$sty6.link) !== null && _props$attributes$sty7 !== void 0 && (_props$attributes$sty8 = _props$attributes$sty7.color) !== null && _props$attributes$sty8 !== void 0 && _props$attributes$sty8.text);
  }

  return !!props.attributes[`${name}Color`] || !!((_props$attributes$sty9 = props.attributes.style) !== null && _props$attributes$sty9 !== void 0 && (_props$attributes$sty10 = _props$attributes$sty9.color) !== null && _props$attributes$sty10 !== void 0 && _props$attributes$sty10[name]);
};
/**
 * Clears a single color property from a style object.
 *
 * @param {Array}  path  Path to color property to clear within styles object.
 * @param {Object} style Block attributes style object.
 * @return {Object} Styles with the color property omitted.
 */


const clearColorFromStyles = (path, style) => cleanEmptyObject(immutableSet(style, path, undefined));
/**
 * Resets the block attributes for text color.
 *
 * @param {Object}   props               Current block props.
 * @param {Object}   props.attributes    Block attributes.
 * @param {Function} props.setAttributes Block's setAttributes prop used to apply reset.
 */


const resetTextColor = _ref => {
  let {
    attributes,
    setAttributes
  } = _ref;
  setAttributes({
    textColor: undefined,
    style: clearColorFromStyles(['color', 'text'], attributes.style)
  });
};
/**
 * Clears text color related properties from supplied attributes.
 *
 * @param {Object} attributes Block attributes.
 * @return {Object} Update block attributes with text color properties omitted.
 */


const resetAllTextFilter = attributes => ({
  textColor: undefined,
  style: clearColorFromStyles(['color', 'text'], attributes.style)
});
/**
 * Resets the block attributes for link color.
 *
 * @param {Object}   props               Current block props.
 * @param {Object}   props.attributes    Block attributes.
 * @param {Function} props.setAttributes Block's setAttributes prop used to apply reset.
 */


const resetLinkColor = _ref2 => {
  let {
    attributes,
    setAttributes
  } = _ref2;
  const path = ['elements', 'link', 'color', 'text'];
  setAttributes({
    style: clearColorFromStyles(path, attributes.style)
  });
};
/**
 * Clears link color related properties from supplied attributes.
 *
 * @param {Object} attributes Block attributes.
 * @return {Object} Update block attributes with link color properties omitted.
 */


const resetAllLinkFilter = attributes => ({
  style: clearColorFromStyles(['elements', 'link', 'color', 'text'], attributes.style)
});
/**
 * Clears all background color related properties including gradients from
 * supplied block attributes.
 *
 * @param {Object} attributes Block attributes.
 * @return {Object} Block attributes with background and gradient omitted.
 */


const clearBackgroundAndGradient = attributes => {
  var _attributes$style;

  return {
    backgroundColor: undefined,
    gradient: undefined,
    style: { ...attributes.style,
      color: { ...((_attributes$style = attributes.style) === null || _attributes$style === void 0 ? void 0 : _attributes$style.color),
        background: undefined,
        gradient: undefined
      }
    }
  };
};
/**
 * Resets the block attributes for both background color and gradient.
 *
 * @param {Object}   props               Current block props.
 * @param {Object}   props.attributes    Block attributes.
 * @param {Function} props.setAttributes Block's setAttributes prop used to apply reset.
 */


const resetBackgroundAndGradient = _ref3 => {
  let {
    attributes,
    setAttributes
  } = _ref3;
  setAttributes(clearBackgroundAndGradient(attributes));
};
/**
 * Filters registered block settings, extending attributes to include
 * `backgroundColor` and `textColor` attribute.
 *
 * @param {Object} settings Original block settings.
 *
 * @return {Object} Filtered block settings.
 */


function color_addAttributes(settings) {
  if (!hasColorSupport(settings)) {
    return settings;
  } // Allow blocks to specify their own attribute definition with default values if needed.


  if (!settings.attributes.backgroundColor) {
    Object.assign(settings.attributes, {
      backgroundColor: {
        type: 'string'
      }
    });
  }

  if (!settings.attributes.textColor) {
    Object.assign(settings.attributes, {
      textColor: {
        type: 'string'
      }
    });
  }

  if (hasGradientSupport(settings) && !settings.attributes.gradient) {
    Object.assign(settings.attributes, {
      gradient: {
        type: 'string'
      }
    });
  }

  return settings;
}
/**
 * Override props assigned to save component to inject colors classnames.
 *
 * @param {Object} props      Additional props applied to save element.
 * @param {Object} blockType  Block type.
 * @param {Object} attributes Block attributes.
 *
 * @return {Object} Filtered props applied to save element.
 */


function color_addSaveProps(props, blockType, attributes) {
  var _style$color, _style$color2, _style$color3, _style$color4, _style$elements, _style$elements$link;

  if (!hasColorSupport(blockType) || color_shouldSkipSerialization(blockType)) {
    return props;
  }

  const hasGradient = hasGradientSupport(blockType); // I'd have preferred to avoid the "style" attribute usage here

  const {
    backgroundColor,
    textColor,
    gradient,
    style
  } = attributes;
  const backgroundClass = getColorClassName('background-color', backgroundColor);

  const gradientClass = __experimentalGetGradientClass(gradient);

  const textClass = getColorClassName('color', textColor);
  const newClassName = classnames_default()(props.className, textClass, gradientClass, {
    // Don't apply the background class if there's a custom gradient.
    [backgroundClass]: (!hasGradient || !(style !== null && style !== void 0 && (_style$color = style.color) !== null && _style$color !== void 0 && _style$color.gradient)) && !!backgroundClass,
    'has-text-color': textColor || (style === null || style === void 0 ? void 0 : (_style$color2 = style.color) === null || _style$color2 === void 0 ? void 0 : _style$color2.text),
    'has-background': backgroundColor || (style === null || style === void 0 ? void 0 : (_style$color3 = style.color) === null || _style$color3 === void 0 ? void 0 : _style$color3.background) || hasGradient && (gradient || (style === null || style === void 0 ? void 0 : (_style$color4 = style.color) === null || _style$color4 === void 0 ? void 0 : _style$color4.gradient)),
    'has-link-color': style === null || style === void 0 ? void 0 : (_style$elements = style.elements) === null || _style$elements === void 0 ? void 0 : (_style$elements$link = _style$elements.link) === null || _style$elements$link === void 0 ? void 0 : _style$elements$link.color
  });
  props.className = newClassName ? newClassName : undefined;
  return props;
}
/**
 * Filters registered block settings to extend the block edit wrapper
 * to apply the desired styles and classnames properly.
 *
 * @param {Object} settings Original block settings.
 *
 * @return {Object} Filtered block settings.
 */

function color_addEditProps(settings) {
  if (!hasColorSupport(settings) || color_shouldSkipSerialization(settings)) {
    return settings;
  }

  const existingGetEditWrapperProps = settings.getEditWrapperProps;

  settings.getEditWrapperProps = attributes => {
    let props = {};

    if (existingGetEditWrapperProps) {
      props = existingGetEditWrapperProps(attributes);
    }

    return color_addSaveProps(props, settings, attributes);
  };

  return settings;
}

const getLinkColorFromAttributeValue = (colors, value) => {
  const attributeParsed = /var:preset\|color\|(.+)/.exec(value);

  if (attributeParsed && attributeParsed[1]) {
    return getColorObjectByAttributeValues(colors, attributeParsed[1]).color;
  }

  return value;
};
/**
 * Inspector control panel containing the color related configuration
 *
 * @param {Object} props
 *
 * @return {WPElement} Color edit element.
 */


function ColorEdit(props) {
  var _style$color6, _style$color7, _style$color8, _style$elements2, _style$elements2$link, _style$elements2$link2, _style$elements3, _style$elements3$link, _style$elements3$link2;

  const {
    name: blockName,
    attributes
  } = props; // Some color settings have a special handling for deprecated flags in `useSetting`,
  // so we can't unwrap them by doing const { ... } = useSetting('color')
  // until https://github.com/WordPress/gutenberg/issues/37094 is fixed.

  const userPalette = useSetting('color.palette.custom');
  const themePalette = useSetting('color.palette.theme');
  const defaultPalette = useSetting('color.palette.default');
  const allSolids = (0,external_wp_element_namespaceObject.useMemo)(() => [...(userPalette || []), ...(themePalette || []), ...(defaultPalette || [])], [userPalette, themePalette, defaultPalette]);
  const userGradientPalette = useSetting('color.gradients.custom');
  const themeGradientPalette = useSetting('color.gradients.theme');
  const defaultGradientPalette = useSetting('color.gradients.default');
  const allGradients = (0,external_wp_element_namespaceObject.useMemo)(() => [...(userGradientPalette || []), ...(themeGradientPalette || []), ...(defaultGradientPalette || [])], [userGradientPalette, themeGradientPalette, defaultGradientPalette]);
  const areCustomSolidsEnabled = useSetting('color.custom');
  const areCustomGradientsEnabled = useSetting('color.customGradient');
  const isBackgroundEnabled = useSetting('color.background');
  const isLinkEnabled = useSetting('color.link');
  const isTextEnabled = useSetting('color.text');
  const solidsEnabled = areCustomSolidsEnabled || !themePalette || (themePalette === null || themePalette === void 0 ? void 0 : themePalette.length) > 0;
  const gradientsEnabled = areCustomGradientsEnabled || !themeGradientPalette || (themeGradientPalette === null || themeGradientPalette === void 0 ? void 0 : themeGradientPalette.length) > 0; // Shouldn't be needed but right now the ColorGradientsPanel
  // can trigger both onChangeColor and onChangeBackground
  // synchronously causing our two callbacks to override changes
  // from each other.

  const localAttributes = (0,external_wp_element_namespaceObject.useRef)(attributes);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    localAttributes.current = attributes;
  }, [attributes]);

  if (!hasColorSupport(blockName)) {
    return null;
  }

  const hasLinkColor = hasLinkColorSupport(blockName) && isLinkEnabled && solidsEnabled;
  const hasTextColor = hasTextColorSupport(blockName) && isTextEnabled && solidsEnabled;
  const hasBackgroundColor = hasBackgroundColorSupport(blockName) && isBackgroundEnabled && solidsEnabled;
  const hasGradientColor = hasGradientSupport(blockName) && gradientsEnabled;

  if (!hasLinkColor && !hasTextColor && !hasBackgroundColor && !hasGradientColor) {
    return null;
  }

  const {
    style,
    textColor,
    backgroundColor,
    gradient
  } = attributes;
  let gradientValue;

  if (hasGradientColor && gradient) {
    gradientValue = getGradientValueBySlug(allGradients, gradient);
  } else if (hasGradientColor) {
    var _style$color5;

    gradientValue = style === null || style === void 0 ? void 0 : (_style$color5 = style.color) === null || _style$color5 === void 0 ? void 0 : _style$color5.gradient;
  }

  const onChangeColor = name => value => {
    var _localAttributes$curr, _localAttributes$curr2;

    const colorObject = getColorObjectByColorValue(allSolids, value);
    const attributeName = name + 'Color';
    const newStyle = { ...localAttributes.current.style,
      color: { ...((_localAttributes$curr = localAttributes.current) === null || _localAttributes$curr === void 0 ? void 0 : (_localAttributes$curr2 = _localAttributes$curr.style) === null || _localAttributes$curr2 === void 0 ? void 0 : _localAttributes$curr2.color),
        [name]: colorObject !== null && colorObject !== void 0 && colorObject.slug ? undefined : value
      }
    };
    const newNamedColor = colorObject !== null && colorObject !== void 0 && colorObject.slug ? colorObject.slug : undefined;
    const newAttributes = {
      style: cleanEmptyObject(newStyle),
      [attributeName]: newNamedColor
    };
    props.setAttributes(newAttributes);
    localAttributes.current = { ...localAttributes.current,
      ...newAttributes
    };
  };

  const onChangeGradient = value => {
    const slug = getGradientSlugByValue(allGradients, value);
    let newAttributes;

    if (slug) {
      var _localAttributes$curr3, _localAttributes$curr4, _localAttributes$curr5;

      const newStyle = { ...((_localAttributes$curr3 = localAttributes.current) === null || _localAttributes$curr3 === void 0 ? void 0 : _localAttributes$curr3.style),
        color: { ...((_localAttributes$curr4 = localAttributes.current) === null || _localAttributes$curr4 === void 0 ? void 0 : (_localAttributes$curr5 = _localAttributes$curr4.style) === null || _localAttributes$curr5 === void 0 ? void 0 : _localAttributes$curr5.color),
          gradient: undefined
        }
      };
      newAttributes = {
        style: cleanEmptyObject(newStyle),
        gradient: slug
      };
    } else {
      var _localAttributes$curr6, _localAttributes$curr7, _localAttributes$curr8;

      const newStyle = { ...((_localAttributes$curr6 = localAttributes.current) === null || _localAttributes$curr6 === void 0 ? void 0 : _localAttributes$curr6.style),
        color: { ...((_localAttributes$curr7 = localAttributes.current) === null || _localAttributes$curr7 === void 0 ? void 0 : (_localAttributes$curr8 = _localAttributes$curr7.style) === null || _localAttributes$curr8 === void 0 ? void 0 : _localAttributes$curr8.color),
          gradient: value
        }
      };
      newAttributes = {
        style: cleanEmptyObject(newStyle),
        gradient: undefined
      };
    }

    props.setAttributes(newAttributes);
    localAttributes.current = { ...localAttributes.current,
      ...newAttributes
    };
  };

  const onChangeLinkColor = value => {
    const colorObject = getColorObjectByColorValue(allSolids, value);
    const newLinkColorValue = colorObject !== null && colorObject !== void 0 && colorObject.slug ? `var:preset|color|${colorObject.slug}` : value;
    const newStyle = cleanEmptyObject(immutableSet(style, ['elements', 'link', 'color', 'text'], newLinkColorValue));
    props.setAttributes({
      style: newStyle
    });
  };

  const enableContrastChecking = external_wp_element_namespaceObject.Platform.OS === 'web' && !gradient && !(style !== null && style !== void 0 && (_style$color6 = style.color) !== null && _style$color6 !== void 0 && _style$color6.gradient);
  const defaultColorControls = (0,external_wp_blocks_namespaceObject.getBlockSupport)(props.name, [COLOR_SUPPORT_KEY, '__experimentalDefaultControls']);
  return (0,external_wp_element_namespaceObject.createElement)(ColorPanel, {
    enableContrastChecking: enableContrastChecking,
    clientId: props.clientId,
    enableAlpha: true,
    settings: [...(hasTextColor ? [{
      label: (0,external_wp_i18n_namespaceObject.__)('Text'),
      onColorChange: onChangeColor('text'),
      colorValue: getColorObjectByAttributeValues(allSolids, textColor, style === null || style === void 0 ? void 0 : (_style$color7 = style.color) === null || _style$color7 === void 0 ? void 0 : _style$color7.text).color,
      isShownByDefault: defaultColorControls === null || defaultColorControls === void 0 ? void 0 : defaultColorControls.text,
      hasValue: () => hasColor('text')(props),
      onDeselect: () => resetTextColor(props),
      resetAllFilter: resetAllTextFilter
    }] : []), ...(hasBackgroundColor || hasGradientColor ? [{
      label: (0,external_wp_i18n_namespaceObject.__)('Background'),
      onColorChange: hasBackgroundColor ? onChangeColor('background') : undefined,
      colorValue: getColorObjectByAttributeValues(allSolids, backgroundColor, style === null || style === void 0 ? void 0 : (_style$color8 = style.color) === null || _style$color8 === void 0 ? void 0 : _style$color8.background).color,
      gradientValue,
      onGradientChange: hasGradientColor ? onChangeGradient : undefined,
      isShownByDefault: defaultColorControls === null || defaultColorControls === void 0 ? void 0 : defaultColorControls.background,
      hasValue: () => hasColor('background')(props),
      onDeselect: () => resetBackgroundAndGradient(props),
      resetAllFilter: clearBackgroundAndGradient
    }] : []), ...(hasLinkColor ? [{
      label: (0,external_wp_i18n_namespaceObject.__)('Link'),
      onColorChange: onChangeLinkColor,
      colorValue: getLinkColorFromAttributeValue(allSolids, style === null || style === void 0 ? void 0 : (_style$elements2 = style.elements) === null || _style$elements2 === void 0 ? void 0 : (_style$elements2$link = _style$elements2.link) === null || _style$elements2$link === void 0 ? void 0 : (_style$elements2$link2 = _style$elements2$link.color) === null || _style$elements2$link2 === void 0 ? void 0 : _style$elements2$link2.text),
      clearable: !!(style !== null && style !== void 0 && (_style$elements3 = style.elements) !== null && _style$elements3 !== void 0 && (_style$elements3$link = _style$elements3.link) !== null && _style$elements3$link !== void 0 && (_style$elements3$link2 = _style$elements3$link.color) !== null && _style$elements3$link2 !== void 0 && _style$elements3$link2.text),
      isShownByDefault: defaultColorControls === null || defaultColorControls === void 0 ? void 0 : defaultColorControls.link,
      hasValue: () => hasColor('link')(props),
      onDeselect: () => resetLinkColor(props),
      resetAllFilter: resetAllLinkFilter
    }] : [])]
  });
}
/**
 * This adds inline styles for color palette colors.
 * Ideally, this is not needed and themes should load their palettes on the editor.
 *
 * @param {Function} BlockListBlock Original component.
 *
 * @return {Function} Wrapped component.
 */

const withColorPaletteStyles = (0,external_wp_compose_namespaceObject.createHigherOrderComponent)(BlockListBlock => props => {
  var _props$wrapperProps;

  const {
    name,
    attributes
  } = props;
  const {
    backgroundColor,
    textColor
  } = attributes;
  const userPalette = useSetting('color.palette.custom') || [];
  const themePalette = useSetting('color.palette.theme') || [];
  const defaultPalette = useSetting('color.palette.default') || [];
  const colors = (0,external_wp_element_namespaceObject.useMemo)(() => [...(userPalette || []), ...(themePalette || []), ...(defaultPalette || [])], [userPalette, themePalette, defaultPalette]);

  if (!hasColorSupport(name) || color_shouldSkipSerialization(name)) {
    return (0,external_wp_element_namespaceObject.createElement)(BlockListBlock, props);
  }

  const extraStyles = {};

  if (textColor) {
    var _getColorObjectByAttr;

    extraStyles.color = (_getColorObjectByAttr = getColorObjectByAttributeValues(colors, textColor)) === null || _getColorObjectByAttr === void 0 ? void 0 : _getColorObjectByAttr.color;
  }

  if (backgroundColor) {
    var _getColorObjectByAttr2;

    extraStyles.backgroundColor = (_getColorObjectByAttr2 = getColorObjectByAttributeValues(colors, backgroundColor)) === null || _getColorObjectByAttr2 === void 0 ? void 0 : _getColorObjectByAttr2.color;
  }

  let wrapperProps = props.wrapperProps;
  wrapperProps = { ...props.wrapperProps,
    style: { ...extraStyles,
      ...((_props$wrapperProps = props.wrapperProps) === null || _props$wrapperProps === void 0 ? void 0 : _props$wrapperProps.style)
    }
  };
  return (0,external_wp_element_namespaceObject.createElement)(BlockListBlock, _extends({}, props, {
    wrapperProps: wrapperProps
  }));
});
const MIGRATION_PATHS = {
  linkColor: [['style', 'elements', 'link', 'color', 'text']],
  textColor: [['textColor'], ['style', 'color', 'text']],
  backgroundColor: [['backgroundColor'], ['style', 'color', 'background']],
  gradient: [['gradient'], ['style', 'color', 'gradient']]
};
function color_addTransforms(result, source, index, results) {
  const destinationBlockType = result.name;
  const activeSupports = {
    linkColor: hasLinkColorSupport(destinationBlockType),
    textColor: hasTextColorSupport(destinationBlockType),
    backgroundColor: hasBackgroundColorSupport(destinationBlockType),
    gradient: hasGradientSupport(destinationBlockType)
  };
  return transformStyles(activeSupports, MIGRATION_PATHS, result, source, index, results);
}
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.registerBlockType', 'core/color/addAttribute', color_addAttributes);
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.getSaveContent.extraProps', 'core/color/addSaveProps', color_addSaveProps);
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.registerBlockType', 'core/color/addEditProps', color_addEditProps);
(0,external_wp_hooks_namespaceObject.addFilter)('editor.BlockListBlock', 'core/color/with-color-palette-styles', withColorPaletteStyles);
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.switchToBlockType.transformedBlock', 'core/color/addTransforms', color_addTransforms);

;// CONCATENATED MODULE: ./packages/block-editor/build-module/components/font-appearance-control/index.js


/**
 * WordPress dependencies
 */



const FONT_STYLES = [{
  name: (0,external_wp_i18n_namespaceObject._x)('Regular', 'font style'),
  value: 'normal'
}, {
  name: (0,external_wp_i18n_namespaceObject._x)('Italic', 'font style'),
  value: 'italic'
}];
const FONT_WEIGHTS = [{
  name: (0,external_wp_i18n_namespaceObject._x)('Thin', 'font weight'),
  value: '100'
}, {
  name: (0,external_wp_i18n_namespaceObject._x)('Extra Light', 'font weight'),
  value: '200'
}, {
  name: (0,external_wp_i18n_namespaceObject._x)('Light', 'font weight'),
  value: '300'
}, {
  name: (0,external_wp_i18n_namespaceObject._x)('Regular', 'font weight'),
  value: '400'
}, {
  name: (0,external_wp_i18n_namespaceObject._x)('Medium', 'font weight'),
  value: '500'
}, {
  name: (0,external_wp_i18n_namespaceObject._x)('Semi Bold', 'font weight'),
  value: '600'
}, {
  name: (0,external_wp_i18n_namespaceObject._x)('Bold', 'font weight'),
  value: '700'
}, {
  name: (0,external_wp_i18n_namespaceObject._x)('Extra Bold', 'font weight'),
  value: '800'
}, {
  name: (0,external_wp_i18n_namespaceObject._x)('Black', 'font weight'),
  value: '900'
}];
/**
 * Adjusts font appearance field label in case either font styles or weights
 * are disabled.
 *
 * @param {boolean} hasFontStyles  Whether font styles are enabled and present.
 * @param {boolean} hasFontWeights Whether font weights are enabled and present.
 * @return {string} A label representing what font appearance is being edited.
 */

const getFontAppearanceLabel = (hasFontStyles, hasFontWeights) => {
  if (!hasFontStyles) {
    return (0,external_wp_i18n_namespaceObject.__)('Font weight');
  }

  if (!hasFontWeights) {
    return (0,external_wp_i18n_namespaceObject.__)('Font style');
  }

  return (0,external_wp_i18n_namespaceObject.__)('Appearance');
};
/**
 * Control to display unified font style and weight options.
 *
 * @param {Object} props Component props.
 *
 * @return {WPElement} Font appearance control.
 */

function FontAppearanceControl(props) {
  const {
    onChange,
    hasFontStyles = true,
    hasFontWeights = true,
    value: {
      fontStyle,
      fontWeight
    }
  } = props;
  const hasStylesOrWeights = hasFontStyles || hasFontWeights;
  const label = getFontAppearanceLabel(hasFontStyles, hasFontWeights);
  const defaultOption = {
    key: 'default',
    name: (0,external_wp_i18n_namespaceObject.__)('Default'),
    style: {
      fontStyle: undefined,
      fontWeight: undefined
    }
  }; // Combines both font style and weight options into a single dropdown.

  const combineOptions = () => {
    const combinedOptions = [defaultOption];
    FONT_STYLES.forEach(_ref => {
      let {
        name: styleName,
        value: styleValue
      } = _ref;
      FONT_WEIGHTS.forEach(_ref2 => {
        let {
          name: weightName,
          value: weightValue
        } = _ref2;
        const optionName = styleValue === 'normal' ? weightName : (0,external_wp_i18n_namespaceObject.sprintf)(
        /* translators: 1: Font weight name. 2: Font style name. */
        (0,external_wp_i18n_namespaceObject.__)('%1$s %2$s'), weightName, styleName);
        combinedOptions.push({
          key: `${styleValue}-${weightValue}`,
          name: optionName,
          style: {
            fontStyle: styleValue,
            fontWeight: weightValue
          }
        });
      });
    });
    return combinedOptions;
  }; // Generates select options for font styles only.


  const styleOptions = () => {
    const combinedOptions = [defaultOption];
    FONT_STYLES.forEach(_ref3 => {
      let {
        name,
        value
      } = _ref3;
      combinedOptions.push({
        key: value,
        name,
        style: {
          fontStyle: value,
          fontWeight: undefined
        }
      });
    });
    return combinedOptions;
  }; // Generates select options for font weights only.


  const weightOptions = () => {
    const combinedOptions = [defaultOption];
    FONT_WEIGHTS.forEach(_ref4 => {
      let {
        name,
        value
      } = _ref4;
      combinedOptions.push({
        key: value,
        name,
        style: {
          fontStyle: undefined,
          fontWeight: value
        }
      });
    });
    return combinedOptions;
  }; // Map font styles and weights to select options.


  const selectOptions = (0,external_wp_element_namespaceObject.useMemo)(() => {
    if (hasFontStyles && hasFontWeights) {
      return combineOptions();
    }

    return hasFontStyles ? styleOptions() : weightOptions();
  }, [props.options]); // Find current selection by comparing font style & weight against options,
  // and fall back to the Default option if there is no matching option.

  const currentSelection = selectOptions.find(option => option.style.fontStyle === fontStyle && option.style.fontWeight === fontWeight) || selectOptions[0]; // Adjusts screen reader description based on styles or weights.

  const getDescribedBy = () => {
    if (!currentSelection) {
      return (0,external_wp_i18n_namespaceObject.__)('No selected font appearance');
    }

    if (!hasFontStyles) {
      return (0,external_wp_i18n_namespaceObject.sprintf)( // translators: %s: Currently selected font weight.
      (0,external_wp_i18n_namespaceObject.__)('Currently selected font weight: %s'), currentSelection.name);
    }

    if (!hasFontWeights) {
      return (0,external_wp_i18n_namespaceObject.sprintf)( // translators: %s: Currently selected font style.
      (0,external_wp_i18n_namespaceObject.__)('Currently selected font style: %s'), currentSelection.name);
    }