<?php
/**
 * Order details
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/order/order-details.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.5.2
 */


if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
if ( ! $order = wc_get_order( $order_id ) ) {
	return;
}

$order_items           = $order->get_items( apply_filters( 'woocommerce_purchase_order_item_types', 'line_item' ) );
$show_purchase_note    = $order->has_status( apply_filters( 'woocommerce_purchase_note_order_statuses', array( 'completed', 'processing' ) ) );
$show_customer_details = is_user_logged_in() && $order->get_user_id() === get_current_user_id();
$downloads             = $order->get_downloadable_items();
$show_downloads        = $order->has_downloadable_item() && $order->is_download_permitted();

if ( $show_downloads ) {
	wc_get_template( 'order/order-downloads.php', array( 'downloads' => $downloads, 'show_title' => true ) );
}
?>


<section class="woocommerce-order-details">
	<?php do_action( 'woocommerce_order_details_before_order_table', $order ); ?>

	<h2 class="woocommerce-order-details__title"><?php _e( 'Order details', 'woocommerce' ); ?></h2>

<div style="margin-bottom: 40px;">
	<table class="td" cellspacing="0" cellpadding="6" style="width: 100%; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif;" border="1">
		<thead>
			<tr>
				<th class="td" scope="col" style="text-align:left;"><?php esc_html_e( 'Product', 'woocommerce' ); ?></th>
				<th class="td" scope="col" style="text-align:left;"><?php esc_html_e( 'Quantity', 'woocommerce' ); ?></th>
				<th class="td" scope="col" style="text-align:left;"><?php esc_html_e( 'Price', 'woocommerce' ); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			echo wc_get_email_order_items( $order, array( // WPCS: XSS ok.
				'show_sku'      => $sent_to_admin,
				'show_image'    => false,
				'image_size'    => array( 32, 32 ),
				'plain_text'    => $plain_text,
				'sent_to_admin' => $sent_to_admin,
			) );
			?>
		</tbody>
            <?php
            global $woocommerce;
            
    //       echo '<pre>';
		  // print_r($woocommerce->cart->get_cart());
		  // echo '</pre>';
            ?>
	<tfoot class="t_class">
			<?php
			$totals = $order->get_order_item_totals();
			
			if ( $totals ) {
				$i = 0;
				foreach ( $totals as $total ) {
					$i++;
					
					?>
					<tr <?php
			if(($total['label']=="Totalt:")||($total['label']=="Delsumma:") || ($total['label']=="Frakt:")){?>
					    style="display:none !important;"
				<?php	}
					
					?>>
						<th class="td" scope="row" colspan="2" style="text-align:left; text-transform:uppercase; <?php echo ( 1 === $i ) ? 'border-top-width: 4px;' : '';  ?>"><?php echo wp_kses_post( $total['label'] ); ?></th>
						
						<td class="td" style="text-align:left;text-transform:uppercase;color:#949494; <?php echo ( 1 === $i ) ? 'border-top-width: 4px;' : ''; ?>"><?php echo wp_kses_post( $total['value'] ); ?></td>
					</tr>
					<?php
				}
			}
			if ( $order->get_customer_note() ) {
				?>
				<tr>
					<th class="td" scope="row" colspan="2" style="text-align:left;text-transform:uppercase;"><?php esc_html_e( 'Note:', 'woocommerce' ); ?></th>
					<td class="td" style="text-align:left; color:#949494;"><?php echo wp_kses_post( wptexturize( $order->get_customer_note() ) ); ?></td>
				</tr>
				<?php
			}
			?>
			
			   <tr>
                <th class="td" scope="row" colspan="2" style="text-align:left;text-transform:uppercase;">Total Summa</th>
                <td class="td" style="text-align:left;">
                    <?php
                    // echo "<pre>";
                    // print_r($order->get_items());
                    // echo "</pre>";
                    $odd_charge=0;
                    $sum_qty=0;
                    foreach ($order->get_items() as $item_key => $item ){
                       $total_amt+= $item->get_total();
                       $quantity=$item->get_quantity();
                       $sum_qty+=$quantity;
                        $product_id   = $item->get_product_id();
                         if ($quantity % 2 != 0) {
                                    $odd_charge += get_field("odd_charge", $product_id);
                                    //return;
                                } else {
                                  // return;
                                }
                    }
                    // echo "Total Amount ".$total_amt."</br>";
                    // echo "Odd Charge ".$odd_charge;
                    $t_summa=$total_amt+$odd_charge;
                    echo wc_price($t_summa);
                    
                    
            //         global $woocommerce;
            //          $cart_object = $order->get_data();
            //         global $custom_cart_total;
            //         echo 'Total Amt'.$custom_cart_total;
            //             $odd_charge=0;
            //             foreach ( $cart_object as $hash => $value ) {
            //                     $a_product_id = $value['product_id'];
            //                     $quantity = $value["quantity"];
                    
            //                     //echo 'Quantity '.$quantity;
            //                     if ($quantity % 2 != 0) {
            //                         $odd_charge += get_field("odd_charge", $a_product_id);
            //                         //return;
            //                     } else {
            //                       // return;
            //                     }
            //             }
            //             $fee = $odd_charge;
      
            // $total_summa=(WC()->cart->cart_contents_total)+$fee;
            //         echo wc_price($total_summa);
                    ?>
                </td>
            </tr>
            
            <tr style="background-color: #f8f8f8;">
                <th  class="td" scope="row" colspan="2" style="text-align:left;text-transform:uppercase;">Anmälningsavgift</th>
                <td class="td" style="text-align:left;">
                    <?php
                    //  $qty=0;
                    //  foreach ( WC()->cart->get_cart() as $cart_item ) {
                    //                 $qty+=  $cart_item['quantity'];
                    //         }
                    $registration_fee= ot_get_option('registration_fee')*$sum_qty;
                    echo wc_price($registration_fee);
                    ?>
                </td>
                
            </tr>
            
            <tr>
                 <th class="td" scope="row" colspan="2" style="text-align:left;text-transform:uppercase;">Resterande belopp</th>
                 <td class="td" style="text-align:left;">
                     <?php
                    //  $anmal_p=(ot_get_option('registration_fee')*$qty);
                    //  echo wc_price($total_summa-$anmal_p);
                     $payable=$t_summa-$registration_fee;
                    //  echo $t_summa.'<br/>';
                    //  echo $registration_fee;
                     
                     echo wc_price($payable);
                     ?>
                 </td>
            </tr>
			
			
		</tfoot>
		
		
		
	</table>
</div>

 <script>
        jQuery(document).ready(function(){
            setTimeout(function(){ 
                jQuery("#klarna-checkout-container").hide();
                },800);
        });
</script>
	
	
	

	<?php do_action( 'woocommerce_order_details_after_order_table', $order ); ?>
</section>

<?php
if ( $show_customer_details ) {
	wc_get_template( 'order/order-details-customer.php', array( 'order' => $order ) );
}
