<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

//WC 3.4
$post_class = 'post_class';
if ( function_exists( 'WC' ) && WC()->version >= '3.4' ) {
	$post_class = 'wc_product_class';
}

?>
<style>
.Tours_Html_Block,.container.related-and-upsells{ display: none; }
</style>

<script>
    jQuery(document).ready(function(){

      // jQuery('.qty_select').click(function(){
      //    // GET CURRENT VALUES
      //     var product_qty=jQuery(".qty").val();
      //     var cur_price_tag=jQuery(".single_variation_wrap>.woocommerce-variation>.woocommerce-variation-price>.price >.woocommerce-Price-amount").attr("id");
      //     //calculate single product value
      //     console.log(product_qty+' '+cur_price_tag);
      //     var single_product_val=parseFloat(cur_price_tag)*parseFloat(product_qty);
      //     console.log('single product value '+single_product_val);
      //     //update the price label
      //     jQuery(".single_variation_wrap>.woocommerce-variation>.woocommerce-variation-price>.price >.woocommerce-Price-amount").text('');
      //     jQuery(".single_variation_wrap>.woocommerce-variation>.woocommerce-variation-price>.price >.woocommerce-Price-amount").append(single_product_val);
      // });

        // var product_qty=jQuery(".qty").val();

        setTimeout(function(){
            var product_qty=2;
            var cur_price_tag=jQuery(".single_variation_wrap>.woocommerce-variation>.woocommerce-variation-price>.price >.woocommerce-Price-amount").attr("id");
            var single_product_val=parseFloat(cur_price_tag)*parseFloat(product_qty);
            console.log(product_qty+' '+cur_price_tag+' '+single_product_val);
            jQuery(".single_variation_wrap>.woocommerce-variation>.woocommerce-variation-price>.price >.woocommerce-Price-amount").text('');
            jQuery(".single_variation_wrap>.woocommerce-variation>.woocommerce-variation-price>.price >.woocommerce-Price-amount").append(single_product_val);
        },1000);

        jQuery('.qty').change(function(){
            // GET CURRENT VALUES
            var product_qty=jQuery(".qty").val();
            var cur_price_tag=jQuery(".single_variation_wrap>.woocommerce-variation>.woocommerce-variation-price>.price >.woocommerce-Price-amount").attr("id");
            //calculate single product value
            var single_product_val=parseFloat(cur_price_tag)*parseFloat(product_qty);
            //update the price label
            jQuery(".single_variation_wrap>.woocommerce-variation>.woocommerce-variation-price>.price >.woocommerce-Price-amount").text('');
            jQuery(".single_variation_wrap>.woocommerce-variation>.woocommerce-variation-price>.price >.woocommerce-Price-amount").append(single_product_val);
        });
    });
</script>


<div class="Single_product_Begining">
<div class="single-breadcrumbs-wrapper">
	<div class="container">
		<?php basel_current_breadcrumbs( 'shop' ); ?>
		<?php if ( ! basel_get_opt( 'hide_products_nav' ) ): ?>
			<?php basel_products_nav(); ?>
		<?php endif ?>
	</div>
</div>

<div class="container">
	<?php
		/**
		 * Hook: woocommerce_before_single_product.
		 *
		 * @hooked wc_print_notices - 10
		 */
		 do_action( 'woocommerce_before_single_product' );

		 if ( post_password_required() ) {
		 	echo get_the_password_form();
		 	return;
		 }

		$product_images_class  	= basel_product_images_class();
		$product_summary_class 	= basel_product_summary_class();
		$single_product_class  	= basel_single_product_class();
		$content_class 			= basel_get_content_class();
		$product_design 		= basel_product_design();

		$container_summary = 'container';

		if( $product_design == 'sticky' ) {
			$container_summary = 'container-fluid';
		}

	?>
</div>
<div id="product-<?php the_ID(); ?>" <?php $post_class( $single_product_class ); ?>>

	<div class="<?php echo esc_attr( $container_summary ); ?>">

		<div class="row">
			<div class="product-image-summary <?php echo esc_attr( $content_class ); ?>">
				<div class="row">
					<div class="<?php echo esc_attr( $product_images_class ); ?> product-images Single_Left_column">
						<?php
							/**
							 * woocommerce_before_single_product_summary hook
							 *
							 * @hooked woocommerce_show_product_sale_flash - 10
							 * @hooked woocommerce_show_product_images - 20
							 */
							do_action( 'woocommerce_before_single_product_summary' );
						?>
            <?php global $product; ?>
					</div>
					<div class="<?php echo esc_attr( $product_summary_class ); ?> summary entry-summary">
						<div class="summary-inner <?php if( $product_design == 'compact' ) echo 'basel-scroll'; ?>">
							<div class="basel-scroll-content">
								<?php
									/**
									 * Hook: woocommerce_single_product_summary.
									 *
									 * @hooked woocommerce_template_single_title - 5
									 * @hooked woocommerce_template_single_rating - 10
									 * @hooked woocommerce_template_single_price - 10
									 * @hooked woocommerce_template_single_excerpt - 20
									 * @hooked woocommerce_template_single_add_to_cart - 30
									 * @hooked woocommerce_template_single_meta - 40
									 * @hooked woocommerce_template_single_sharing - 50
									 */
                      $producent = $product->get_attribute( 'producent' );
                      $region = $product->get_attribute( 'region' );
                      $img_url = '';
                      //echo "Hello";
                      echo $product->get_attribute( 'name' );;
                      //echo $region;

//                      echo '<h1>'.$product->get_attribute('id').'</h1>';


//                      echo '<pre>';
//                      print_r($product->get_available_variations());
//                      echo '</pre>';

                      ?>
                <div class="Single_Right_column_tours">
									<div class="col-sm-12">
			              <?php do_action( 'woocommerce_single_product_summary' ); ?>
			            </div>
                </div>
								<?php if ( $product_design != 'alt' && $product_design != 'sticky' && basel_get_opt( 'product_share' ) ): ?>
									<div class="product-share">
										<span class="share-title"><?php _e('Share', 'basel'); ?></span>
										<?php echo basel_shortcode_social( array( 'type' => basel_get_opt( 'product_share_type' ), 'size' => 'small', 'align' => 'left' ) ); ?>
									</div>
								<?php endif ?>
							</div>
						</div>
					</div>
					<div class="col-sm-12 Single_Tours_Content">
						<?php the_content(); ?>
					</div>
				</div><!-- .summary -->
			</div>

			<?php
				/**
				 * woocommerce_sidebar hook
				 *
				 * @hooked woocommerce_get_sidebar - 10
				 */
				do_action( 'woocommerce_sidebar' );
			?>

		</div>
	</div>

	<?php if ( ( $product_design == 'alt' || $product_design == 'sticky' ) && basel_get_opt( 'product_share' ) ): ?>
		<div class="product-share">
			<?php echo basel_shortcode_social( array( 'type' => basel_get_opt( 'product_share_type' ), 'style' => 'colored' ) ); ?>
		</div>
	<?php endif ?>

	<div class="container">
		<?php
			/**
			 * basel_after_product_content hook
			 *
			 * @hooked basel_product_extra_content - 20
			 */
			do_action( 'basel_after_product_content' );
		?>
	</div>

	<?php if( $product_design != 'compact' ): ?>

		<div class="product-tabs-wrapper">
			<div class="container">
				<div class="row">
					<div class="col-sm-12">
						<?php
							/**
							 * woocommerce_after_single_product_summary hook
							 *
							 * @hooked woocommerce_output_product_data_tabs - 10
							 * @hooked woocommerce_upsell_display - 15
							 * @hooked woocommerce_output_related_products - 20
							 */
							do_action( 'woocommerce_after_single_product_summary' );
						?>
					</div>
				</div>
			</div>
		</div>

	<?php endif ?>

</div><!-- #product-<?php the_ID(); ?> -->
</div>
<script>
jQuery( document ).ready(function() {
	//jQuery(".Single_Right_column_tours .quantity input.input-text.qty").attr("min" : 2);
	setTimeout(function(){
		jQuery(".Single_Right_column_tours .quantity input.input-text.qty").attr({
			"min" : 1,          // values (or variables) here
			"value" : 2,
            "max": ''
		});
	}, 500),

    jQuery('.basel-swatch').click(function(){
        setTimeout(function () {
            jQuery(".Single_Right_column_tours .quantity input.input-text.qty").attr({
                "min" : 1,          // values (or variables) here
                "value" : 2,
                "max": ''
            });
        },100);
    });
	});
</script>
<?php do_action( 'woocommerce_after_single_product' ); ?>
