<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

include dirname(__FILE__). '/header/plugin-header.php';
global $wpdb;
$current_user = wp_get_current_user();
?>
<div class="wcpfc-main-table res-cl">
    <h2><?php esc_html_e('Quick info', 'woocommerce-conditional-product-fees-for-checkout'); ?></h2>
    <table class="table-outer">
        <tbody>
            <tr>
                <td class="fr-1"><?php esc_html_e('Product Type', 'woocommerce-conditional-product-fees-for-checkout'); ?></td>
                <td class="fr-2"><?php esc_html_e('WooCommerce Plugin', 'woocommerce-conditional-product-fees-for-checkout'); ?></td>
            </tr>
            <tr>
                <td class="fr-1"><?php esc_html_e('Product Name', 'woocommerce-conditional-product-fees-for-checkout'); ?></td>
                <td class="fr-2"><?php esc_html_e($plugin_name, 'woocommerce-conditional-product-fees-for-checkout'); ?></td>
            </tr>
            <tr>
                <td class="fr-1"><?php esc_html_e('Installed Version', 'woocommerce-conditional-product-fees-for-checkout'); ?></td>
                <td class="fr-2"><?php esc_html_e('Free Version ', 'woocommerce-conditional-product-fees-for-checkout'); ?> <?php esc_html_e($plugin_version); ?></td>
            </tr>
            <tr>
                <td class="fr-1"><?php esc_html_e('License & Terms of use', 'woocommerce-conditional-product-fees-for-checkout'); ?></td>
                <td class="fr-2">
                    <a target="_blank"  href="<?php echo esc_url("http://t.signauxdeux.com/e1t/c/5/f18dQhb0SmZ58dDMPbW2n0x6l2B9nMJW7sM9dn7dK_MMdBzM2-04?t=https%3A%2F%2Fstore.multidots.com%2Fterms-conditions%2F&si=4973901068632064&pi=61378fda-f5e5-4125-c521-28a4597b13d6"); ?>">
                        <?php esc_html_e('Click here', 'woocommerce-conditional-product-fees-for-checkout'); ?>
                    </a> 
                    <?php esc_html_e('to view license and terms of use.', 'woocommerce-conditional-product-fees-for-checkout'); ?>
                </td>
            </tr>
            <tr>
                <td class="fr-1"><?php esc_html_e('Help & Support', 'woocommerce-conditional-product-fees-for-checkout'); ?></td>
                <td class="fr-2 wcpfc-information">
                    <ul>
                        <li><a href="<?php echo esc_url(home_url('wp-admin/admin.php?page=wcpfc-get-started')); ?>"><?php esc_html_e('Quick Start', 'woocommerce-conditional-product-fees-for-checkout'); ?></a></li>
                        <li><a target="_blank" href="<?php echo esc_url("https://store.multidots.com/docs/plugins/woocommerce-conditional-product-fees-checkout/"); ?>"><?php esc_html_e('Guide Documentation', 'woocommerce-conditional-product-fees-for-checkout'); ?></a></li>
                        <li><a target="_blank" href="<?php echo esc_url("http://t.signauxdeux.com/e1t/c/5/f18dQhb0SmZ58dDMPbW2n0x6l2B9nMJW7sM9dn7dK_MMdBzM2-04?t=https%3A%2F%2Fstore.multidots.com%2Fdotstore-support-panel%2F&si=4973901068632064&pi=61378fda-f5e5-4125-c521-28a4597b13d6"); ?>"><?php esc_html_e('Support Forum', 'woocommerce-conditional-product-fees-for-checkout'); ?></a></li>
                    </ul>
                </td>
            </tr>
            <tr>
                <td class="fr-1"><?php esc_html_e('Localization', 'woocommerce-conditional-product-fees-for-checkout'); ?></td>
                <td class="fr-2"><?php esc_html_e('English', 'woocommerce-conditional-product-fees-for-checkout'); ?>, <?php esc_html_e('Spanish', 'woocommerce-conditional-product-fees-for-checkout'); ?></td>
            </tr>

        </tbody>
    </table>
</div>
<?php include dirname(__FILE__). '/header/plugin-sidebar.php'; ?>