<?php

add_action( 'wp_enqueue_scripts', 'basel_child_enqueue_styles', 1000 );

function basel_child_enqueue_styles() {
	$version = basel_get_theme_info( 'Version' );

	if( basel_get_opt( 'minified_css' ) ) {
		wp_enqueue_style( 'basel-style', get_template_directory_uri() . '/style.min.css', array('bootstrap'), $version );
	} else {
		wp_enqueue_style( 'basel-style', get_template_directory_uri() . '/style.css', array('bootstrap'), $version );
	}

    wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', array('bootstrap'), $version );
}


if( function_exists( 'YITH_WCAN' ) ){
    add_filter( 'yit_get_terms_args', 'yit_get_terms_args' );
    add_filter( 'yith_wcan_skip_no_products_in_category', '__return_false' );
    add_filter( 'yith_wcan_force_show_count_in_category', '__return_true' );
    if( ! function_exists( 'yit_get_terms_args' ) ){
        function yit_get_terms_args( $args ){
            if( ! empty( $args['taxonomy'] ) && 'product_cat' == $args['taxonomy'] ){
                $args['hide_empty'] = false;
            }
            return $args;
        }
    }
}


function wooc_extra_register_fields() {?>
    <div class="">
        <h3>Personuppgifter</h3>
    </div>
    <p class="form-row form-row-first">
        <label for="reg_billing_first_name"><?php _e( 'First name', 'woocommerce' ); ?><span class="required">*</span></label>
        <input type="text" class="input-text" name="billing_first_name" id="reg_billing_first_name" value="<?php if ( ! empty( $_POST['billing_first_name'] ) ) esc_attr_e( $_POST['billing_first_name'] ); ?>" />
    </p>
    <p class="form-row form-row-last">
        <label for="reg_billing_last_name"><?php _e( 'Last name', 'woocommerce' ); ?><span class="required">*</span></label>
        <input type="text" class="input-text" name="billing_last_name" id="reg_billing_last_name" value="<?php if ( ! empty( $_POST['billing_last_name'] ) ) esc_attr_e( $_POST['billing_last_name'] ); ?>" />
    </p>
    <p class="form-row form-row-wide">
        <label for="reg_billing_phone"><?php _e( 'Phone', 'woocommerce' ); ?></label>
        <input type="text" class="input-text" name="billing_phone" id="reg_billing_phone" value="<?php esc_attr_e( $_POST['billing_phone'] ); ?>" />
    </p>
    <p class="form-row form-row-wide">
        <label for="reg_billing_phone"><?php _e( 'Land', 'woocommerce' ); ?></label>
        <input type="text" class="input-text" name="billing_phone" id="reg_billing_phone" value="<?php esc_attr_e( $_POST['billing_phone'] ); ?>" />
    </p>

    <div class="">
        <h3>Adress</h3>
    </div>

    <p class="form-row form-row-wide">
        <label for="reg_billing_phone"><?php _e( 'Phone', 'woocommerce' ); ?></label>
        <input type="text" class="input-text" name="billing_phone" id="reg_billing_phone" value="<?php esc_attr_e( $_POST['billing_phone'] ); ?>" />
    </p>

    <p class="form-row form-row-first">
        <label for="reg_billing_first_name"><?php _e( 'First name', 'woocommerce' ); ?><span class="required">*</span></label>
        <input type="text" class="input-text" name="billing_first_name" id="reg_billing_first_name" value="<?php if ( ! empty( $_POST['billing_first_name'] ) ) esc_attr_e( $_POST['billing_first_name'] ); ?>" />
    </p>
    <p class="form-row form-row-last">
        <label for="reg_billing_last_name"><?php _e( 'Last name', 'woocommerce' ); ?><span class="required">*</span></label>
        <input type="text" class="input-text" name="billing_last_name" id="reg_billing_last_name" value="<?php if ( ! empty( $_POST['billing_last_name'] ) ) esc_attr_e( $_POST['billing_last_name'] ); ?>" />
    </p>




    <div class="">
        <h3>Kontaktuppgifter</h3>
    </div>

    <p class="form-row form-row-wide">
        <label for="reg_billing_phone"><?php _e( 'Phone', 'woocommerce' ); ?></label>
        <input type="text" class="input-text" name="billing_phone" id="reg_billing_phone" value="<?php esc_attr_e( $_POST['billing_phone'] ); ?>" />
    </p>

    <p class="form-row form-row-wide">
        <label for="reg_billing_phone"><?php _e( 'Phone', 'woocommerce' ); ?></label>
        <input type="text" class="input-text" name="billing_phone" id="reg_billing_phone" value="<?php esc_attr_e( $_POST['billing_phone'] ); ?>" />
    </p>


    <div class="">
        <h3>Lösenord</h3>
    </div>

    <p class="form-row form-row-wide">
        <label for="reg_billing_phone"><?php _e( 'Phone', 'woocommerce' ); ?></label>
        <input type="text" class="input-text" name="billing_phone" id="reg_billing_phone" value="<?php esc_attr_e( $_POST['billing_phone'] ); ?>" />
    </p>

    <p class="form-row form-row-wide">
        <label for="reg_billing_phone"><?php _e( 'Phone', 'woocommerce' ); ?></label>
        <input type="text" class="input-text" name="billing_phone" id="reg_billing_phone" value="<?php esc_attr_e( $_POST['billing_phone'] ); ?>" />
    </p>

    <p class="form-row form-row-wide" style="display: block;float: left;">
        <input type="checkbox" class="input-text" name="billing_phone" id="reg_billing_phone" value="<?php esc_attr_e( $_POST['billing_phone'] ); ?>" />
        <label for="reg_billing_phone"><?php _e( 'Jag vill ha nyhetsmail från Vinupplevelser', 'woocommerce' ); ?></label>
    </p>


    <div class="clear"></div>
    <?php
}


add_action( 'woocommerce_register_form_start', 'wooc_extra_register_fields' );

// 
// add_action( ‘wp_enqueue_scripts’, ‘wdm_enqueue_scripts’ );
//
// function wdm_enqueue_scripts()
//
// {
//
// wp_register_script( ‘example-script’, get_stylesheet_directory_uri() . ‘/js/example.js’ );
// $passedValues = array( ‘value1’ => ‘xyz’, ‘value2′ => ’23’ );
//
// wp_localize_script( ‘example-script’, ‘passed_object’, $passedValues );
//
// wp_enqueue_script( ‘example-script’);
//
// }

// **********************************************************************//
// ! Header block mobile nav
// **********************************************************************//

if( ! function_exists( 'basel_header_block_mobile_nav' ) ) {
	function basel_header_block_mobile_nav() {

		$menu_locations = get_nav_menu_locations();

		$location = apply_filters( 'basel_main_menu_location', 'main-menu' );

		if(isset($menu_locations['mobile-menu']) && $menu_locations['mobile-menu'] != 0) {
			$location = apply_filters( 'basel_mobile_menu_location', 'mobile-menu' );
		}

		$ajax_args = apply_filters( 'basel_ajax_search_args', array( 'thumbnail' => 1, 'price' => 1 ) );
		$mobile_search_form = basel_get_opt( 'mobile_search_form' ) != '' ? basel_get_opt( 'mobile_search_form' ) : true;

		?>
			<div class="mobile-nav">
				<div class="Close_BTN"></div>
				<?php
					if ( $mobile_search_form ) {
						basel_header_block_search_extended( false, true, $ajax_args, false );
					}

					if( has_nav_menu( $location ) ) {
						wp_nav_menu(
							array(
								'theme_location' => $location,
								'menu_class' => 'site-mobile-menu',
								'walker' => new BASEL_Mega_Menu_Walker()
							)
						);
					}

					basel_header_block_header_links( 'mobile' );

				 ?>
			</div><!--END MOBILE-NAV-->
		<?php
	}
}
