<?php
/**
 * Block template functions.
 *
 * This is a temporary compatibility fix for WordPress 5.8.x, which is missing
 * some features for templates that are present in 5.9.
 *
 * Once 5.9 is the minimum supported WordPress version for the Gutenberg
 * plugin, this shim can be removed.
 *
 * @package gutenberg
 */

// Only run any of the code in this file if the version is less than 5.9.
// wp_list_users was introduced in 5.9.
if ( ! function_exists( 'wp_list_users' ) ) {
	/**
	 * Registers block editor 'wp_template' post type.
	 */
	function gutenberg_register_template_post_type() {
		$labels = array(
			'name'                  => __( 'Templates', 'gutenberg' ),
			'singular_name'         => __( 'Template', 'gutenberg' ),
			'menu_name'             => _x( 'Templates', 'Admin Menu text', 'gutenberg' ),
			'add_new'               => _x( 'Add New', 'Template', 'gutenberg' ),
			'add_new_item'          => __( 'Add New Template', 'gutenberg' ),
			'new_item'              => __( 'New Template', 'gutenberg' ),
			'edit_item'             => __( 'Edit Template', 'gutenberg' ),
			'view_item'             => __( 'View Template', 'gutenberg' ),
			'view_items'            => __( 'View Templates', 'gutenberg' ),
			'all_items'             => __( 'All Templates', 'gutenberg' ),
			'search_items'          => __( 'Search Templates', 'gutenberg' ),
			'parent_item_colon'     => __( 'Parent Template:', 'gutenberg' ),
			'not_found'             => __( 'No templates found.', 'gutenberg' ),
			'not_found_in_trash'    => __( 'No templates found in Trash.', 'gutenberg' ),
			'archives'              => __( 'Template archives', 'gutenberg' ),
			'insert_into_item'      => __( 'Insert into template', 'gutenberg' ),
			'uploaded_to_this_item' => __( 'Uploaded to this template', 'gutenberg' ),
			'filter_items_list'     => __( 'Filter templates list', 'gutenberg' ),
			'items_list_navigation' => __( 'Templates list navigation', 'gutenberg' ),
			'items_list'            => __( 'Templates list', 'gutenberg' ),
		);

		$args = array(
			'labels'                => $labels,
			'description'           => __( 'Templates to include in your theme.', 'gutenberg' ),
			'public'                => false,
			'has_archive'           => false,
			'show_ui'               => true,
			'show_in_menu'          => false,
			'show_in_admin_bar'     => false,
			'show_in_rest'          => true,
			'rest_base'             => 'templates',
			'rest_controller_class' => 'Gutenberg_REST_Templates_Controller',
			'capability_type'       => array( 'template', 'templates' ),
			'map_meta_cap'          => true,
			'supports'              => array(
				'title',
				'slug',
				'excerpt',
				'editor',
				'revisions',
				'author',
			),
		);

		register_post_type( 'wp_template', $args );
	}
	add_action( 'init', 'gutenberg_register_template_post_type' );

	/**
	 * Registers block editor 'wp_theme' taxonomy.
	 */
	function gutenberg_register_wp_theme_taxonomy() {
		register_taxonomy(
			'wp_theme',
			array( 'wp_template', 'wp_template_part', 'wp_global_styles' ),
			array(
				'public'            => false,
				'hierarchical'      => false,
				'labels'            => array(
					'name'          => __( 'Themes', 'gutenberg' ),
					'singular_name' => __( 'Theme', 'gutenberg' ),
				),
				'query_var'         => false,
				'rewrite'           => false,
				'show_ui'           => false,
				'_builtin'          => true,
				'show_in_nav_menus' => false,
				'show_in_rest'      => false,
			)
		);
	}
	add_action( 'init', 'gutenberg_register_wp_theme_taxonomy' );

	/**
	 * Filters the capabilities of a user to conditionally grant them capabilities for managing 'wp_template' posts.
	 *
	 * Any user who can 'edit_theme_options' will have access.
	 *
	 * @param array $allcaps A user's capabilities.
	 * @return array Filtered $allcaps.
	 */
	function gutenberg_grant_template_caps( array $allcaps ) {
		if ( isset( $allcaps['edit_theme_options'] ) ) {
			$allcaps['edit_templates']             = $allcaps['edit_theme_options'];
			$allcaps['edit_others_templates']      = $allcaps['edit_theme_options'];
			$allcaps['edit_published_templates']   = $allcaps['edit_theme_options'];
			$allcaps['edit_private_templates']     = $allcaps['edit_theme_options'];
			$allcaps['delete_templates']           = $allcaps['edit_theme_options'];
			$allcaps['delete_others_templates']    = $allcaps['edit_theme_options'];
			$allcaps['delete_published_templates'] = $allcaps['edit_theme_options'];
			$allcaps['delete_private_templates']   = $allcaps['edit_theme_options'];
			$allcaps['publish_templates']          = $allcaps['edit_theme_options'];
			$allcaps['read_private_templates']     = $allcaps['edit_theme_options'];
		}

		return $allcaps;
	}
	add_filter( 'user_has_cap', 'gutenberg_grant_template_caps' );

	/**
	 * Sets a custom slug when creating auto-draft templates.
	 * This is only needed for auto-drafts created by the regular WP editor.
	 * If this page is to be removed, this won't be necessary.
	 *
	 * @param int $post_id Post ID.
	 */
	function set_unique_slug_on_create_template( $post_id ) {
		$post = get_post( $post_id );
		if ( 'auto-draft' !== $post->post_status ) {
			return;
		}

		if ( ! $post->post_name ) {
			wp_update_post(
				array(
					'ID'        => $post_id,
					'post_name' => 'custom_slug_' . uniqid(),
				)
			);
		}

		$terms = get_the_terms( $post_id, 'wp_theme' );
		if ( ! $terms || ! count( $terms ) ) {
			wp_set_post_terms( $post_id, wp_get_theme()->get_stylesheet(), 'wp_theme' );
		}
	}
	add_action( 'save_post_wp_template', 'set_unique_slug_on_create_template' );

	/**
	 * Print the skip-link script & styles.
	 *
	 * @todo Remove this when WP 5.8 is the minimum required version.
	 *
	 * @return void
	 */
	function gutenberg_the_skip_link() {
		// Early exit if not a block theme.
		if ( ! current_theme_supports( 'block-templates' ) ) {
			return;
		}

		// Early exit if not a block template.
		global $_wp_current_template_content;
		if ( ! $_wp_current_template_content ) {
			return;
		}
		?>

		<?php
		/**
		 * Print the skip-link styles.
		 */
		?>
		<style id="skip-link-styles">
			.skip-link.screen-reader-text {
				border: 0;
				clip: rect(1px,1px,1px,1px);
				clip-path: inset(50%);
				height: 1px;
				margin: -1px;
				overflow: hidden;
				padding: 0;
				position: absolute !important;
				width: 1px;
				word-wrap: normal !important;
			}

			.skip-link.screen-reader-text:focus {
				background-color: #eee;
				clip: auto !important;
				clip-path: none;
				color: #444;
				display: block;
				font-size: 1em;
				height: auto;
				left: 5px;
				line-height: normal;
				padding: 15px 23px 14px;
				text-decoration: none;
				top: 5px;
				width: auto;
				z-index: 100000;
			}
		</style>
		<?php
		/**
		 * Print the skip-link script.
		 */
		?>
		<script>
		( function() {
			var skipLinkTarget = document.querySelector( 'main' ),
				sibling,
				skipLinkTargetID,
				skipLink;

			// Early exit if a skip-link target can't be located.
			if ( ! skipLinkTarget ) {
				return;
			}

			// Get the site wrapper.
			// The skip-link will be injected in the beginning of it.
			sibling = document.querySelector( '.wp-site-blocks' );

			// Early exit if the root element was not found.
			if ( ! sibling ) {
				return;
			}

			// Get the skip-link target's ID, and generate one if it doesn't exist.
			skipLinkTargetID = skipLinkTarget.id;
			if ( ! skipLinkTargetID ) {
				skipLinkTargetID = 'wp--skip-link--target';
				skipLinkTarget.id = skipLinkTargetID;
			}

			// Create the skip link.
			skipLink = document.createElement( 'a' );
			skipLink.classList.add( 'skip-link', 'screen-reader-text' );
			skipLink.href = '#' + skipLinkTargetID;
			skipLink.innerHTML = '<?php esc_html_e( 'Skip to content', 'gutenberg' ); ?>';

			// Inject the skip link.
			sibling.parentElement.insertBefore( skipLink, sibling );
		}() );
		</script>
		<?php
	}

	remove_action( 'wp_footer', 'the_block_template_skip_link' );
	add_action( 'wp_footer', 'gutenberg_the_skip_link' );
}
