<?php
/**
 * Order details table shown in emails.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/email-order-details.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates/Emails
 * @version 3.3.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$text_align = is_rtl() ? 'right' : 'left';

do_action( 'woocommerce_email_before_order_table', $order, $sent_to_admin, $plain_text, $email ); ?>

<h2>
	<?php
	if ( $sent_to_admin ) {
		$before = '<a class="link" href="' . esc_url( $order->get_edit_order_url() ) . '">';
		$after  = '</a>';
	} else {
		$before = '';
		$after  = '';
	}
	/* translators: %s: Order ID. */
	echo wp_kses_post( $before . sprintf( __( '[Order #%s]', 'woocommerce' ) . $after . ' (<time datetime="%s">%s</time>)', $order->get_order_number(), $order->get_date_created()->format( 'c' ), wc_format_datetime( $order->get_date_created() ) ) );
	?>
</h2>

<div style="margin-bottom: 40px;">
	<table class="td" cellspacing="0" cellpadding="6" style="width: 100%; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif;" border="1">
		<thead>
			<tr>
				<th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'Product', 'woocommerce' ); ?></th>
				<th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'Quantity', 'woocommerce' ); ?></th>
				<th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'Price', 'woocommerce' ); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			echo wc_get_email_order_items( $order, array( // WPCS: XSS ok.
				'show_sku'      => $sent_to_admin,
				'show_image'    => false,
				'image_size'    => array( 32, 32 ),
				'plain_text'    => $plain_text,
				'sent_to_admin' => $sent_to_admin,
			) );
			?>
		</tbody>
            <?php
            global $woocommerce;
            
    //       echo '<pre>';
		  // print_r($woocommerce->cart->get_cart());
		  // echo '</pre>';
            ?>
	<tfoot class="t_class">
			<?php
			$totals = $order->get_order_item_totals();
			if ( $totals ) {
				$i = 0;
				foreach ( $totals as $total ) {
					$i++;
					
					?>
					<tr <?php
					if($total['label']=="Totalt:"){?>
					    style="display:none !important;"
				<?php	}
					
					?>>
						<th class="td" scope="row" colspan="2" style="text-align:<?php echo esc_attr( $text_align ); ?>; <?php echo ( 1 === $i ) ? 'border-top-width: 4px;' : ''; ?>"><?php echo wp_kses_post( $total['label'] ); ?></th>
						
						<td class="td" style="text-align:<?php echo esc_attr( $text_align ); ?>; <?php echo ( 1 === $i ) ? 'border-top-width: 4px;' : ''; ?>"><?php echo wp_kses_post( $total['value'] ); ?></td>
					</tr>
					<?php
				}
			}
			if ( $order->get_customer_note() ) {
				?>
				<tr>
					<th class="td" scope="row" colspan="2" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'Note:', 'woocommerce' ); ?></th>
					<td class="td" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php echo wp_kses_post( wptexturize( $order->get_customer_note() ) ); ?></td>
				</tr>
				<?php
			}
			?>
			
			   <tr>
                <th class="td" scope="row" colspan="2" style="text-align:left;">Total Summa</th>
                <td class="td">
                    <?php
                    global $woocommerce;
                     $cart_object = $woocommerce->cart->get_cart();
                        $odd_charge=0;
                        foreach ( $cart_object as $hash => $value ) {
                                $a_product_id = $value['product_id'];
                                $quantity = $value["quantity"];
                    
                                //echo 'Quantity '.$quantity;
                                if ($quantity % 2 != 0) {
                                    $odd_charge += get_field("odd_charge", $a_product_id);
                                    //return;
                                } else {
                                  // return;
                                }
                        }
                        $fee = $odd_charge;
      
            $total_summa=(WC()->cart->cart_contents_total)+$fee;
                    echo wc_price($total_summa);
                    // echo ($order->get_shipping_total().''.get_woocommerce_currency_symbol());
                    ?>
                </td>
            </tr>
            
            <tr style="background-color: #f8f8f8;">
                <th  class="td" scope="row" colspan="2" style="text-align:left;">Anmälningsavgift</th>
                <td class="td">
                    <?php
                     $qty=0;
                     foreach ( WC()->cart->get_cart() as $cart_item ) {
                                    $qty+=  $cart_item['quantity'];
                            }
                    echo wc_price(ot_get_option('registration_fee')*$qty);
                    ?>
                </td>
                
            </tr>
            
            <tr>
                 <th  class="td" scope="row" colspan="2" style="text-align:left;">Resterande belopp</th>
                 <td class="td">
                     <?php
                     $anmal_p=(ot_get_option('registration_fee')*$qty);
                     echo wc_price($total_summa-$anmal_p);
                     
                     ?>
                 </td>
            </tr>
			
			
		</tfoot>
		
		
		
	</table>
</div>

<style>
    .t_class >tr:first-child{
        display: none !important;
    }
    .t_class>tr:nth-child(2){
        display: none !important;
    }
</style>

<?php do_action( 'woocommerce_email_after_order_table', $order, $sent_to_admin, $plain_text, $email ); ?>
