<?php

add_action( 'wp_enqueue_scripts', 'basel_child_enqueue_styles', 1000 );

function basel_child_enqueue_styles() {
	$version = basel_get_theme_info( 'Version' );

	if( basel_get_opt( 'minified_css' ) ) {
		wp_enqueue_style( 'basel-style', get_template_directory_uri() . '/style.min.css', array('bootstrap'), $version );
	} else {
		wp_enqueue_style( 'basel-style', get_template_directory_uri() . '/style.css', array('bootstrap'), $version );
	}

    wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', array('bootstrap'), $version );
}

/*
Disable Variable Product Price Range:
*/

add_filter( 'woocommerce_variable_sale_price_html', 'my_variation_price_format', 10, 2 );

add_filter( 'woocommerce_variable_price_html', 'my_variation_price_format', 10, 2 );

function my_variation_price_format( $price, $product ) {

// Main Price
$prices = array( $product->get_variation_price( 'min', true ), $product->get_variation_price( 'max', true ) );
//$price = $prices[0] !== $prices[1] ? sprintf( __( 'pris från %1$s', 'woocommerce' ), wc_price( $prices[0] ) ) : wc_price( $prices[0] );
 if(is_product()){
        $price_from='pris från %1$s';
    }else{
        $price_from='från %1$s';
    }



$price = sprintf( __( $price_from, 'woocommerce' ), wc_price( $prices[0] ) );

// Sale Price
$prices = array( $product->get_variation_regular_price( 'min', true ), $product->get_variation_regular_price( 'max', true ) );
sort( $prices );
//$saleprice = $prices[0] !== $prices[1] ? sprintf( __( 'pris från %1$s', 'woocommerce' ), wc_price( $prices[0] ) ) : wc_price( $prices[0] );

$saleprice =  sprintf( __( $price_from, 'woocommerce' ),wc_price( $prices[0] ));

if ( $price !== $saleprice ) {
$price = '<del>' . $saleprice . '</del> <ins>' . $price . '</ins>';
}
return $price;
}

/* Lakshan Html block after Shop page */
add_shortcode('ws_frame', 'ws_frontend_product_page_validate');
function ws_frontend_product_page_validate() {
//echo '<iframe src="http://www.example.com/" style="width: 100%; height: 100%;" scrolling="no" frameBorder="0"></iframe>';
	echo '<div class="Tours_Html_Block">';
  echo do_shortcode('[html_block id="1512"]');
	echo do_shortcode('[html_block id="1710"]');
	echo '</div>';


}

add_action( 'woocommerce_after_main_content', 'action_woocommerce_after_main_content', 10);

function action_woocommerce_after_main_content(){


    do_shortcode('[ws_frame]');
}
add_filter('woocommerce_product_single_add_to_cart_text', 'woo_custom_cart_button_text');

function woo_custom_cart_button_text() {
return __('boka', 'woocommerce');
}


/**
 * ------------------------------------------------------------------------------------------------
 * Show attribute swatches list
 * ------------------------------------------------------------------------------------------------
 */
if( ! function_exists( 'basel_swatches_list' ) ) {
    function basel_swatches_list( $attribute_name = false ) {
        global $product;

        $id = $product->get_id();

        if( empty( $id ) || ! $product->is_type( 'variable' ) ) return;

        if( ! $attribute_name ) {
            $attribute_name = basel_grid_swatches_attribute();
        }

        if( empty( $attribute_name ) ) return false;

        // Swatches cache
        $cache = apply_filters( 'basel_swatches_cache', true );
        $transient_name = 'basel_swatches_cache_' . $id;

        if ( $cache ) {
            $available_variations = get_transient( $transient_name );
        } else {
            $available_variations = array();
        }

        if ( ! $available_variations ) {
            $available_variations = $product->get_available_variations();
            if ( $cache ) {
                set_transient( $transient_name, $available_variations, apply_filters( 'basel_swatches_cache_time', WEEK_IN_SECONDS ) );
            }
        }

        if( empty( $available_variations ) ) return;

        $swatches_to_show = basel_get_option_variations(  $attribute_name, $available_variations, false, $id );

        if( empty( $swatches_to_show ) ) return;

        echo '<div class="swatches-on-grid">';

        $swatch_size = basel_wc_get_attribute_term( $attribute_name, 'swatch_size' );

        if( apply_filters( 'basel_swatches_on_grid_right_order', true ) ) {
            $terms = wc_get_product_terms( $product->get_id(), $attribute_name, array( 'fields' => 'slugs' ) );

            $swatches_to_show_tmp = $swatches_to_show;

            $swatches_to_show = array();

            foreach ($terms as $id => $slug) {
                if( ! isset( $swatches_to_show_tmp[$slug] ) ) continue;
                $swatches_to_show[$slug] = $swatches_to_show_tmp[$slug];
            }
        }

//        echo '<pre>';
//        print_r($product->get_available_variations());
//        echo '</pre>';
        $new_array=array();
        $avail_variations=$product->get_available_variations();

//        echo '<pre>';
//        print_r($avail_variations);
//        echo '</pre>';

        //CREATE TEMPORY VALUES
        $date_temp='';


        foreach ($avail_variations as $avail_variations){


            $x=array($avail_variations['attributes']['attribute_pa_datum']=>$avail_variations['is_in_stock']);
            array_push($new_array,$x);

            // $new_array[$avail_variations['attributes']['attribute_pa_datum']]=$avail_variations['is_in_stock'];

        }

//        echo '<pre>';
//        print_r($new_array);
//        echo '</pre>';
//
//        echo '---------------------';

//        echo '<pre>';
//        print_r($swatches_to_show);
//        echo '</pre>';

//        $vx=0;
//        $narry=array();
        foreach ($swatches_to_show as $key => $swatch){
          //  echo $key;

//            foreach($new_array as $new_array){
//                //echo $new_array[$key];
//                if($new_array[$key]==1){
//                    array_push($narry,1);
//                }else{
//                }
//            }

          //  print_r($narry);

            $style = $class = '';

            if( ! empty( $swatch['color'] )) {
                $style = 'background-color:' .  $swatch['color'];
            } else if( ! empty( $swatch['image'] ) ) {
                $style = 'background-image: url(' . $swatch['image'] . ')';
            } else if( ! empty( $swatch['not_dropdown'] ) ) {
                $class .= 'text-only ';
            }

            $style .= ';';

            $data = '';

            if( isset( $swatch['image_src'] ) ) {
                $class .= 'swatch-has-image';
                $data .= 'data-image-src="' . $swatch['image_src'] . '"';
                $data .= ' data-image-srcset="' . $swatch['image_srcset'] . '"';
                $data .= ' data-image-sizes="' . $swatch['image_sizes'] . '"';
                if( basel_get_opt( 'swatches_use_variation_images' ) ) {
                    $thumb = wp_get_attachment_image_src( get_post_thumbnail_id( $swatch['variation_id'] ), 'woocommerce_thumbnail');
                    if ( !empty( $thumb ) ) {
                        $style = 'background-image: url(' . $thumb[0] . ')';
                        $class .= ' variation-image-used';
                    }
                }

                if( ! $swatch['is_in_stock'] ) {
                    $class .= ' variation-out-of-stock';
                }
            }

            $class .= ' swatch-size-' . $swatch_size;

            $term = get_term_by( 'slug', $key, $attribute_name );

           // print_r($term);

            // SET ALL ARE BOOKED MESSAGE

            global $product;

            $product_variations=$product->get_available_variations();
//            echo '<pre>';
//            print_r($product_variations);
//            echo '</pre>';
            $fx=0;
            foreach ($product_variations as $variation)  {
                $var_data = $variation['attributes'];
                $var_data['is_in_stock']=$variation['is_in_stock'];

                if($variation['attributes']['attribute_pa_datum']==$key){
                    $fx+= $variation['is_in_stock'];
                }

            }

           // echo $fx;

            // print_r($var_data);

            //List all attributes with stock available or not array..
//        echo '<pre>';
//        echo('is in stock'.$var_data['is_in_stock']);
//        echo '</pre>';

//            if(($var_data['is_in_stock'] ==1) || ($var_data['is_in_stock'] =='1')){
//                $str_variable="";
//            }else{
//                $str_variable="FULLBOKAD";
//            }

            if($fx>0){
                $str_variable="";
            }else{
                $str_variable="FULLBOKAD";
            }
           // print_r($product->get_available_variations());
            //is_in_stock

//            echo "<pre>";
//              print_r($swatch);
//            echo "<pre>";
//            if($x==0){
          //  print_r($term);


                echo '<div class="swatch-on-grid basel-tooltip ' . esc_attr( $class ) . '" style="' . esc_attr( $style ) .'" ' . $data . '><div class="book_date book_date_w_book">' . $term->name . '</div><div class="is_full_booked">'.$str_variable.'</div></div>';
//            }else{
//                echo '<div class="swatch-on-grid basel-tooltip ' . esc_attr( $class ) . '" style="' . esc_attr( $style ) .'" ' . $data . '><div class="book_date">' . $term->name . '</div></div>';
//            }
//            $x++;
        }

        echo '</div>';

    }
}



//ADD PLACEHOLDERS TO CHECKOUT PAGE

function override_billing_checkout_fields( $fields ) {
    $fields['billing']['billing_phone']['placeholder'] = 'Telefon';
    $fields['billing']['billing_email']['placeholder'] = 'Email';
    return $fields;
}
add_filter( 'woocommerce_checkout_fields' , 'override_billing_checkout_fields', 20, 1 );


function override_default_address_checkout_fields( $address_fields ) {
    $address_fields['first_name']['placeholder'] = 'Förnamn';
    $address_fields['last_name']['placeholder'] = 'Efternamn';
    $address_fields['company']['placeholder'] = 'Förnamn';
    $address_fields['address_1']['placeholder'] = 'Adresse';
    $address_fields['state']['placeholder'] = 'Stat';
    $address_fields['postcode']['placeholder'] = 'Postnummer';
    $address_fields['city']['placeholder'] = 'stad';
    return $address_fields;
}
add_filter('woocommerce_default_address_fields', 'override_default_address_checkout_fields', 20, 1);


add_filter( 'woocommerce_currencies', 'add_custom_currency' );
function add_custom_currency( $custom_currency ) {
    $custom_currency['CUSTOM'] = __( 'CUSTOM CURRECY', 'woocommerce' );
    return $custom_currency;
}

add_filter('woocommerce_currency_symbol', 'add_custom_currency_symbol', 10, 2);
function add_custom_currency_symbol( $custom_currency_symbol, $custom_currency ) {
    switch( $custom_currency ) {
        case 'CUSTOM': $custom_currency_symbol = ':-'; break;
    }
    return $custom_currency_symbol;
}


add_action( 'woocommerce_cart_calculate_fees','endo_handling_fee' );

function endo_handling_fee() {
    global $woocommerce;
    if ( is_admin() && ! defined( 'DOING_AJAX' ) ){
        return;
    }
    global $woocommerce;
    $cart_object = $woocommerce->cart->get_cart();
    $odd_charge=0;
    foreach ( $cart_object as $hash => $value ) {
            $a_product_id = $value['product_id'];
            $quantity = $value["quantity"];

            //echo 'Quantity '.$quantity;
            if ($quantity % 2 != 0) {
                $odd_charge += get_field("odd_charge", $a_product_id);
                //return;
            } else {
              // return;
            }
    }
    $fee = $odd_charge;
    $woocommerce->cart->add_fee( 'Enkelrumstillägg', $fee, true, 'standard' );
   //return;
}

add_action( 'woocommerce_after_calculate_totals', 'woocommerce_before_calculate_totals', 10 );
function woocommerce_before_calculate_totals( $cart ) {
    global $custom_cart_total;
    global $woocommerce;
   // $custom_cart_total=WC()->cart->total;
     $cart_object = $woocommerce->cart->get_cart();
    $odd_charge=0;
    foreach ( $cart_object as $hash => $value ) {
            $a_product_id = $value['product_id'];
            $quantity = $value["quantity"];
            //echo 'Quantity '.$quantity;
            if ($quantity % 2 != 0) {
                $odd_charge += get_field("odd_charge", $a_product_id);
                //return;
            } else {
              // return;
            }
    }
    $custom_cart_total= ($woocommerce->cart->cart_contents_total+$odd_charge);
    
    //ASSIGN DETAILS FOR EMAIL BODY
    global $custom_fee;
 foreach ( WC()->cart->get_fees() as $fee ) :
			$custom_fee=$fee;
		endforeach;

//ASSIGN REGISTRATION FEE
    global $custom_registration_fee;
    $qty=0;
    foreach ( WC()->cart->get_cart() as $cart_item ) {
        $qty+=  $cart_item['quantity'];
    }
    $custom_registration_fee= wc_price(ot_get_option('registration_fee')*$qty);

    //ASSIGN TOTAL PAYABLE
    global $custom_total_payable;
    $custom_total_payable=$custom_cart_total-$custom_registration_fee;
    
    
    
}


add_action( 'woocommerce_after_calculate_totals', 'woocommerce_after_calculate_totals', 10 );
function woocommerce_after_calculate_totals( $cart ) {
    // make magic happen here... 
    // use $cart object to set or calculate anything.

    // if ( 'excl' === $cart->tax_display_cart ) {
    //     $cart->subtotal_ex_tax  = 400;
    // } else {
    //     $cart->subtotal = 350;
    // }
    //     global $woocommerce;
    foreach ( WC()->cart->get_cart() as $cart_item ) {
                $qty+=  $cart_item['quantity'];
        }
    
    $cart->total = (ot_get_option('registration_fee')*$qty);
}


// add_filter('woocommerce_currency_symbol', 'change_existing_currency_symbol', 10, 2);

// function change_existing_currency_symbol( $currency_symbol, $currency ) {
//      switch( $currency ) {
//           case 'kr': $currency_symbol = 'KR';
//           break;
//           case 'KR': $currency_symbol = 'KR';
//           break;
          
//      }
//      return $currency_symbol;
// }


function wpb_password_post_filter( $where = '' ) {
    if (!is_single() && !is_admin()) {
        $where .= " AND post_password = ''";
    }
    return $where;
}
add_filter( 'posts_where', 'wpb_password_post_filter' );


function the_title_trim($title) {

	$title = attribute_escape($title);

	$findthese = array(
		'#Lösenordsskyddad:#',
		'#Lösenordsskyddad:#'
	);

	$replacewith = array(
		'', // What to replace "Protected:" with
		'' // What to replace "Private:" with
	);

	$title = preg_replace($findthese, $replacewith, $title);
	return $title;
}
add_filter('the_title', 'the_title_trim');

