<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

include dirname(__FILE__). '/header/plugin-header.php';

$currency_symbol = get_woocommerce_currency_symbol();
$action = filter_input( INPUT_GET, 'action', FILTER_SANITIZE_STRING );
$p_id = filter_input( INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT );
$nonce = filter_input( INPUT_GET, '_wpnonce', FILTER_SANITIZE_STRING );

if (isset($action) && $action === 'delete') {
    $post_id = $p_id;
    $retrieved_nonce = $nonce;
    if (!wp_verify_nonce($retrieved_nonce, 'wppfcnonce'))
        die('Failed security check');
    wp_delete_post($post_id);
    wp_redirect(home_url('/wp-admin/admin.php?page=wcpfc-list'));
    exit;
}
$get_all_fees = new WP_Query( array(
    'post_type' => 'wc_conditional_fee',
    'post_status' => 'publish',
    'posts_per_page' => 500,
        ));
wp_nonce_field('delete');
?>
<div class="wcpfc-main-table res-cl">
    <div class="product_header_title">
        <h2>
            <?php esc_html_e('Product Fees', 'woocommerce-conditional-product-fees-for-checkout'); ?>
            <a class="add-new-btn"  href="<?php echo esc_url(home_url('/wp-admin/admin.php?page=wcpfc-add-new')); ?>"><?php esc_html_e('Add Product Fees', 'woocommerce-conditional-product-fees-for-checkout'); ?></a>
            <a id="detete-conditional-fee" class="detete-conditional-fee button-primary"><?php esc_html_e('Delete (Selected)', 'woocommerce-conditional-product-fees-for-checkout'); ?></a>
        </h2>
    </div>
    <table id="conditional-fee-listing" class="table-outer form-table conditional-fee-listing tablesorter">
        <thead>
            <tr class="wcpfc-head">

                <th><input type="checkbox" name="check_all" class="condition-check-all"></th>
                <th><?php esc_html_e('Name', 'woocommerce-conditional-product-fees-for-checkout'); ?></th>
                <th><?php esc_html_e('Amount', 'woocommerce-conditional-product-fees-for-checkout'); ?></th>
                <th><?php esc_html_e('Status', 'woocommerce-conditional-product-fees-for-checkout'); ?></th>
                <th><?php esc_html_e('Action', 'woocommerce-conditional-product-fees-for-checkout'); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php
            if (!empty($get_all_fees->posts)) {
                $i = 1;
                foreach ($get_all_fees->posts as $fees) {
                    $title = get_the_title($fees->ID) ? get_the_title($fees->ID) : 'Fee';
                    $getFeesCost = get_post_meta($fees->ID, 'fee_settings_product_cost', true);
                    $getFeesStatus = get_post_meta($fees->ID, 'fee_settings_status', true);
                    $wcpfcnonce = wp_create_nonce('wppfcnonce');
                    ?>
                    <tr>
                        <td width="10%">
                            <input type="checkbox" name="multiple_delete_fee[]" class="multiple_delete_fee" value="<?php echo esc_attr($fees->ID) ?>">
                        </td>
                        <td>
                            <a href="<?php echo esc_url(home_url('/wp-admin/admin.php?page=wcpfc-edit-fee&id=' . esc_attr($fees->ID) . '&action=edit' . '&_wpnonce=' . esc_attr($wcpfcnonce))); ?>"><?php esc_html_e($title, 'woocommerce-conditional-product-fees-for-checkout'); ?></a>
                        </td>
                        <td>
                            <?php echo esc_html( "{$currency_symbol}&nbsp;{$getFeesCost}" );?>
                        </td>
                        <td>
                            <?php echo (isset($getFeesStatus) && $getFeesStatus === 'on') ? '<span class="active-status">' . esc_html_e('Enabled', 'woocommerce-conditional-product-fees-for-checkout') . '</span>' : '<span class="inactive-status">' . esc_html_e('Disabled', 'woocommerce-conditional-product-fees-for-checkout') . '</span>'; ?>
                        </td>
                        <td>
                            <a class="fee-action-button button-primary" href="<?php echo esc_url(home_url('/wp-admin/admin.php?page=wcpfc-edit-fee&id=' . esc_attr($fees->ID) . '&action=edit' . '&_wpnonce=' . esc_attr($wcpfcnonce))); ?>"><?php esc_html_e('Edit', 'woocommerce-conditional-product-fees-for-checkout'); ?></a>
                            <a class="fee-action-button button-primary" href="<?php echo esc_url(home_url('/wp-admin/admin.php?page=wcpfc-list&id=' . esc_attr($fees->ID) . '&action=delete' . '&_wpnonce=' . esc_attr($wcpfcnonce))); ?>"><?php esc_html_e('Delete', 'woocommerce-conditional-product-fees-for-checkout'); ?></a>
                        </td>
                    </tr>
                    <?php
                    $i++;
                }
            }
            ?>
        </tbody>
    </table>
</div>
<?php include dirname(__FILE__). '/header/plugin-sidebar.php';