<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       http://www.multidots.com
 * @since      1.0.0
 *
 * @package    Woocommerce_Conditional_Product_Fees_For_Checkout
 * @subpackage Woocommerce_Conditional_Product_Fees_For_Checkout/admin
 */
/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Woocommerce_Conditional_Product_Fees_For_Checkout
 * @subpackage Woocommerce_Conditional_Product_Fees_For_Checkout/admin
 * @author     Multidots <inquiry@multidots.in>
 */
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Woocommerce_Conditional_Product_Fees_For_Checkout_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string $plugin_name The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string $version The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 *
	 * @param      string $plugin_name The name of this plugin.
	 * @param      string $version The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version     = $version;
	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */

	public function enqueue_styles() {
		$page_var = filter_input( INPUT_GET, 'page', FILTER_SANITIZE_STRING );
		if ( isset( $page_var ) && ! empty( $page_var ) && ( $page_var === 'wcpfc-list' || $page_var === 'wcpfc-add-new' || $page_var === 'wcpfc-premium' || $page_var === 'wcpfc-get-started' || $page_var === 'wcpfc-information' || $page_var === 'wcpfc-edit-fee' ) ) {
			wp_enqueue_style( $this->plugin_name . '-choose-css', plugin_dir_url( __FILE__ ) . 'css/chosen.min.css', array(), $this->version, 'all' );
			wp_enqueue_style( $this->plugin_name . '-jquery-ui-css', plugin_dir_url( __FILE__ ) . 'css/jquery-ui.min.css', array(), $this->version, 'all' );
			wp_enqueue_style( $this->plugin_name . 'font-awesome', plugin_dir_url( __FILE__ ) . 'css/font-awesome.min.css', array(), $this->version, 'all' );
			wp_enqueue_style( $this->plugin_name . '-webkit-css', plugin_dir_url( __FILE__ ) . 'css/webkit.css', array(), $this->version, 'all' );
			wp_enqueue_style( $this->plugin_name . 'main-style', plugin_dir_url( __FILE__ ) . 'css/style.css', array(), 'all' );
			wp_enqueue_style( $this->plugin_name . 'media-css', plugin_dir_url( __FILE__ ) . 'css/media.css', array(), 'all' );
		}
	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {
		$page_var = filter_input( INPUT_GET, 'page', FILTER_SANITIZE_STRING );
		if ( isset( $page_var ) && ! empty( $page_var ) && ( $page_var === 'wcpfc-list' || $page_var === 'wcpfc-add-new' || $page_var === 'wcpfc-premium' || $page_var === 'wcpfc-get-started' || $page_var === 'wcpfc-information' || $page_var === 'wcpfc-edit-fee' ) ) {
			wp_enqueue_style( 'wp-jquery-ui-dialog' );
			wp_enqueue_script( 'jquery-ui-accordion' );
			wp_enqueue_script( $this->plugin_name . '-choose-js', plugin_dir_url( __FILE__ ) . 'js/chosen.jquery.min.js', array(
				'jquery',
				'jquery-ui-datepicker'
			), $this->version, false );
			wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/woocommerce-conditional-product-fees-for-checkout-admin.js', array(
				'jquery',
				'jquery-ui-dialog',
				'jquery-ui-accordion',
				'jquery-ui-sortable'
			), $this->version, false );
			wp_localize_script( $this->plugin_name, 'coditional_vars', array( 'plugin_url' => plugin_dir_url( __FILE__ ) ) );
			wp_enqueue_script( $this->plugin_name . '-tablesorter-js', plugin_dir_url( __FILE__ ) . 'js/jquery.tablesorter.js', array( 'jquery' ), $this->version, false );
		}
	}

	public function dot_store_menu_conditional_fee() {
		global $GLOBALS;
		if ( empty( $GLOBALS['admin_page_hooks']['dots_store'] ) ) {
			add_menu_page(
				'DotStore Plugins', __( 'DotStore Plugins' ), 'manage_option', 'dots_store', array(
				$this,
				'dot_store_menu_page'
			), WCPFC_PLUGIN_URL . 'admin/images/menu-icon.png', 25
			);
		}
		add_submenu_page( 'dots_store', 'Get Started', 'Get Started', 'manage_options', 'wcpfc-get-started', array(
			$this,
			'wcpfc_get_started_page'
		) );
		add_submenu_page( 'dots_store', 'Premium Version', 'Premium Version', 'manage_options', 'wcpfc-premium', array(
			$this,
			'premium_version_wcpfc_page'
		) );
		add_submenu_page( 'dots_store', 'Introduction', 'Introduction', 'manage_options', 'wcpfc-information', array(
			$this,
			'wcpfc_information_page'
		) );
		add_submenu_page( 'dots_store', 'WooCommerce Conditional Product Fees for Checkout', __( 'WooCommerce Conditional Product Fees for Checkout' ), 'manage_options', 'wcpfc-list', array(
			$this,
			'wcpfc_fee_list_page'
		) );
		add_submenu_page( 'dots_store', 'Add New', 'Add New', 'manage_options', 'wcpfc-add-new', array(
			$this,
			'wcpfc_add_new_fee_page'
		) );
		add_submenu_page( 'dots_store', 'Edit Fee', 'Edit Fee', 'manage_options', 'wcpfc-edit-fee', array(
			$this,
			'wcpfc_edit_fee_page'
		) );
	}

	public function dot_store_menu_page() {

	}

	public function wcpfc_information_page() {
		include dirname( __FILE__ ) . '/partials/wcpfc-information-page.php';
	}

	public function premium_version_wcpfc_page() {
		include dirname( __FILE__ ) . '/partials/wcpfc-premium-version-page.php';
	}

	public function wcpfc_fee_list_page() {
		include dirname( __FILE__ ) . '/partials/wcpfc-list-page.php';
	}

	public function wcpfc_add_new_fee_page() {
		include dirname( __FILE__ ) . '/partials/wcpfc-add-new-page.php';
	}

	public function wcpfc_edit_fee_page() {
		include dirname( __FILE__ ) . '/partials/wcpfc-add-new-page.php';
	}

	public function wcpfc_get_started_page() {
		include dirname( __FILE__ ) . '/partials/wcpfc-get-started-page.php';
	}

	function fee_settings_get_meta( $value ) {
		global $post;
		$field = get_post_meta( $post->ID, $value, true );
		if ( ! empty( $field ) ) {
			return is_array( $field ) ? stripslashes_deep( $field ) : stripslashes( wp_kses_decode_entities( $field ) );
		} else {
			return false;
		}
	}

	function wcpfc_fees_conditions_save( $post, $retrieved_nonce, $action ) {
		if ( empty( $post ) ) {
			return false;
		}
		$post_type   = filter_input( INPUT_POST, 'post_type', FILTER_SANITIZE_STRING );
		$fee_post_id = filter_input( INPUT_POST, 'fee_post_id', FILTER_SANITIZE_NUMBER_INT );
		if ( isset( $post_type ) && $post_type === 'wc_conditional_fee' ) {
			if ( $fee_post_id === '' ) {
				$fee_post = array(
					'post_title'  => $post['fee_settings_product_fee_title'],
					'post_status' => 'publish',
					'post_type'   => 'wc_conditional_fee',
				);
				$post_id  = wp_insert_post( $fee_post );
			} else {
				$fee_post = array(
					'ID'          => $post['fee_post_id'],
					'post_title'  => $post['fee_settings_product_fee_title'],
					'post_status' => 'publish'
				);
				$post_id  = wp_update_post( $fee_post );
			}
			if ( isset( $post['fee_settings_product_cost'] ) ) {
				update_post_meta( $post_id, 'fee_settings_product_cost', sanitize_text_field( $post['fee_settings_product_cost'] ) );
			}
			if ( isset( $post['fee_chk_qty_price'] ) ) {
				update_post_meta( $post_id, 'fee_chk_qty_price', 'on' );
			} else {
				update_post_meta( $post_id, 'fee_chk_qty_price', 'off' );
			}
			if ( isset( $post['fee_settings_select_fee_type'] ) ) {
				update_post_meta( $post_id, 'fee_settings_select_fee_type', sanitize_text_field( $post['fee_settings_select_fee_type'] ) );
			}
			if ( isset( $post['fee_settings_start_date'] ) ) {
				update_post_meta( $post_id, 'fee_settings_start_date', sanitize_text_field( $post['fee_settings_start_date'] ) );
			}
			if ( isset( $post['fee_settings_end_date'] ) ) {
				update_post_meta( $post_id, 'fee_settings_end_date', sanitize_text_field( $post['fee_settings_end_date'] ) );
			}
			if ( isset( $post['fee_settings_status'] ) ) {
				update_post_meta( $post_id, 'fee_settings_status', 'on' );
			} else {
				update_post_meta( $post_id, 'fee_settings_status', 'off' );
			}
			if ( isset( $post['fee_settings_select_taxable'] ) ) {
				update_post_meta( $post_id, 'fee_settings_select_taxable', sanitize_text_field( $post['fee_settings_select_taxable'] ) );
			}
			if ( isset( $post['fee_settings_optional_gift'] ) ) {
				update_post_meta( $post_id, 'fee_settings_optional_gift', sanitize_text_field( $post['fee_settings_optional_gift'] ) );
			}
			if ( isset( $post['by_default_checkbox_checked'] ) ) {
				update_post_meta( $post_id, 'by_default_checkbox_checked', 'on' );
			} else {
				update_post_meta( $post_id, 'by_default_checkbox_checked', 'off' );
			}
			$feesArray         = array();
			$fees              = isset( $post['fees'] ) ? $post['fees'] : array();
			$condition_key     = isset( $post['condition_key'] ) ? $post['condition_key'] : array();
			$fees_conditions   = $fees['product_fees_conditions_condition'];
			$conditions_is     = $fees['product_fees_conditions_is'];
			$conditions_values = isset( $fees['product_fees_conditions_values'] ) && ! empty( $fees['product_fees_conditions_values'] ) ? $fees['product_fees_conditions_values'] : array();
			$size              = count( $fees_conditions );
			foreach ( $condition_key as $key => $value ) {
				if ( ! array_key_exists( $key, $conditions_values ) ) {
					$conditions_values[ $key ] = array();
				}
			}
			uksort( $conditions_values, 'strnatcmp' );
			$conditionsValuesArray = array();
			foreach ( $conditions_values as $k => $v ) {
				$conditionsValuesArray[] = $v;
			}

			for ( $i = 0; $i < $size; $i ++ ) {
				$feesArray[] = array(
					'product_fees_conditions_condition' => $fees_conditions[ $i ],
					'product_fees_conditions_is'        => $conditions_is[ $i ],
					'product_fees_conditions_values'    => $conditionsValuesArray[ $i ]
				);
			}
			update_post_meta( $post_id, 'product_fees_metabox', $feesArray );
			$complete_url = wp_nonce_url( esc_url( home_url( '/wp-admin/admin.php?page=wcpfc-list&' ) ), '_wpnonce=' . esc_attr( $retrieved_nonce ), '_wpnonce' );
			wp_redirect( $complete_url );
			exit();
		}
	}

	/**
	 * Product spesifict starts
	 */
	function product_fees_conditions_get_meta( $value ) {
		global $post;
		$field = get_post_meta( $post->ID, $value, true );
		if ( isset( $field ) && ! empty( $field ) ) {
			return is_array( $field ) ? stripslashes_deep( $field ) : stripslashes( wp_kses_decode_entities( $field ) );
		} else {
			return false;
		}
	}

	public function product_fees_conditions_values_ajax() {
		/* prevent XSS. */
		$var_post_condition = filter_input( INPUT_POST, 'condition', FILTER_SANITIZE_STRING );
		$var_post_count     = filter_input( INPUT_POST, 'count', FILTER_SANITIZE_NUMBER_INT );
		$condition          = ( isset( $var_post_condition ) && ! empty( $var_post_condition ) ) ? $var_post_condition : '';
		$count              = ( isset( $var_post_count ) && ! empty( $var_post_count ) ) ? $var_post_count : '';
		if ( $condition === 'country' ) {
			$countries_obj = new WC_Countries();
			$getCountries  = $countries_obj->__get( 'countries' );
			$i             = 0;
			?>
            <select name="fees[product_fees_conditions_values][value_<?php echo esc_attr( $i ); ?>][]"
                    class="product_fees_conditions_values multiselect2 product_fees_conditions_values_country"
                    multiple="multiple">
				<?php
				if ( ! empty( $getCountries ) ) {
					foreach ( $getCountries as $code => $country ) {
						$condtion_value = '';
						$selectedVal    = ! empty( $condtion_value ) && in_array( $code, $condtion_value ) ? 'selected=selected' : '';
						?>
                        <option value="<?php echo esc_attr( $code ); ?>" <?php echo esc_attr( $selectedVal ); ?>><?php echo esc_html( $country ); ?></option>
						<?php
					}
				}
				?>
            </select>
			<?php
		} elseif ( $condition === 'product' ) {
			$get_all_products = new WP_Query( array(
				'post_type'      => 'product',
				'post_status'    => 'publish',
				'posts_per_page' => 500,
			) );
			?>
            <select id="product-filter" rel-id="<?php echo esc_attr( $count ); ?>"
                    name="fees[product_fees_conditions_values][value_<?php echo esc_attr( $count ); ?>][]"
                    class="product_fees_conditions_values multiselect2" multiple="multiple">
				<?php
				if ( isset( $get_all_products->posts ) && ! empty( $get_all_products->posts ) ) {
					foreach ( $get_all_products->posts as $get_all_product ) {
						$selectedVal = ! empty( $condtion_value ) && in_array( $get_all_product->ID, $condtion_value ) ? 'selected=selected' : '';
						if ( $selectedVal !== '' ) { ?>
                            <option value="<?php echo esc_attr( $get_all_product->ID ) ?>" <?php echo esc_attr( $selectedVal ); ?><?php echo esc_attr( $get_all_product->ID ); ?><?php esc_html_e( $get_all_product->post_title ) ?> ></option>
						<?php }
					}
				}
				?>
            </select>
			<?php
		}
		wp_die(); // this is required to terminate immediately and return a proper response
	}

	/**
	 * Function for select country list
	 *
	 */
	public function get_country_list( $count = '', $selected = array() ) {
		$countries_obj = new WC_Countries();
		$getCountries  = $countries_obj->__get( 'countries' );
		$html          = '<select name="fees[product_fees_conditions_values][value_' . $count . '][]"
                             class="product_fees_conditions_values multiselect2 product_fees_conditions_values_country"
                             multiple="multiple">';
		if ( ! empty( $getCountries ) ) {
			foreach ( $getCountries as $code => $country ) {
				$selectedVal = is_array( $selected ) && ! empty( $selected ) && in_array( $code, $selected ) ?
					'selected=selected' : '';
				$html        .= '
                <option value="' . esc_attr( $code ) . '"
                ' . esc_attr( $selectedVal ) . '>' . esc_html( $country ) . '</option>';
			}
		}
		$html .= '</select>';

		return $html;
	}

	/**
	 * Function for select product list
	 *
	 */
	public function get_product_list( $count = '', $selected = array() ) {
		$get_all_products = new WP_Query( array(
			'post_type'      => 'product',
			'post_status'    => 'publish',
			'posts_per_page' => 500,
		) );
		$html             = '<select id="product-filter" rel-id="' . $count . '" name="fees[product_fees_conditions_values][value_' . $count . '][]" class="product_fees_conditions_values multiselect2" multiple="multiple">';
		if ( isset( $get_all_products->posts ) && ! empty( $get_all_products->posts ) ) {

			foreach ( $get_all_products->posts as $get_all_product ) {
				$selectedVal = is_array( $selected ) && ! empty( $selected ) && in_array( $get_all_product->ID, $selected ) ? 'selected=selected' : '';
				if ( $selectedVal !== '' ) {
					$html .= '<option value="' . esc_attr( $get_all_product->ID ) . '" ' . esc_attr( $selectedVal ) . '>' . '#' . esc_attr( $get_all_product->ID ) . ' - ' . esc_html( $get_all_product->post_title ) . '</option>';
				}
			}
		}
		$html .= '</select>';

		return $html;
	}

	public function wc_multiple_delete_conditional_fee() {
		$result = 0;
		/* prevent XSS. */
		$all_post_values = filter_input_array( INPUT_POST );
		$allVals         = ( isset( $all_post_values['allVals'] ) && ! empty( $all_post_values['allVals'] ) ) ? $all_post_values['allVals'] : '';
		if ( ! empty( $allVals ) ) {
			foreach ( $allVals as $val ) {
				wp_delete_post( $val );
				$result = 1;
			}
		}
		esc_html_e( $result );
		wp_die();
	}

	public function welcome_conditional_fee_screen_do_activation_redirect() {
		// if no activation redirect
		if ( ! get_transient( '_welcome_screen_activation_redirect_data' ) ) {
			return;
		}
		// Delete the redirect transient
		delete_transient( '_welcome_screen_activation_redirect_data' );

		$activate_multi = filter_input( INPUT_GET, 'activate-multi', FILTER_SANITIZE_STRING );

		// if activating from network, or bulk
		if ( is_network_admin() || isset( $activate_multi ) ) {
			return;
		}
		// Redirect to extra cost welcome  page

		wp_safe_redirect( add_query_arg( array( 'page' => 'wcpfc-get-started' ), admin_url( 'admin.php' ) ) );
		exit();
	}

	/**
	 * Set Active menu
	 */
	public function wcpfc_free_active_menu() {
		$screen = get_current_screen();

		//DotStore Menu Submenu based conditions
		if ( ! empty( $screen ) && ( $screen->id === 'dotstore-plugins_page_wcpfc-add-new' || $screen->id === 'dotstore-plugins_page_wcpfc-edit-fee' || $screen->id === 'dotstore-plugins_page_wcpfc-premium' || $screen->id === 'dotstore-plugins_page_wcpfc-get-started' || $screen->id === 'dotstore-plugins_page_wcpfc-information' ) ) {
			?>
            <script type="text/javascript">
                jQuery(document).ready(function ($) {
                    $('a[href="admin.php?page=wcpfc-list"]').parent().addClass('current');
                    $('a[href="admin.php?page=wcpfc-list"]').addClass('current');
                });
            </script>
			<?php
		}
	}

	public function wcpfc_remove_admin_submenus() {
		remove_submenu_page( 'dots_store', 'wcpfc-information' );
		remove_submenu_page( 'dots_store', 'wcpfc-premium' );
		remove_submenu_page( 'dots_store', 'wcpfc-add-new' );
		remove_submenu_page( 'dots_store', 'wcpfc-edit-fee' );
		remove_submenu_page( 'dots_store', 'wcpfc-get-started' );
	}

	public function product_fees_conditions_values_product_ajax() {
		$fee_value = filter_input( INPUT_POST, 'value', FILTER_SANITIZE_STRING );
		$value     = isset( $fee_value ) ? $fee_value : '';
		function wcpfc_posts_where( $where, &$wp_query ) {
			global $wpdb;
			if ( $search_term = $wp_query->get( 'search_pro_title' ) ) {
				$search_term_like = $wpdb->esc_like( $search_term );
				$where            .= ' AND ' . $wpdb->posts . '.post_title LIKE \'%' . esc_sql( $search_term_like ) . '%\'';
			}
			return $where;
		}

		$product_args = array(
			'post_type'        => 'product',
			'posts_per_page'   => 500,
			'search_pro_title' => $value,
			'post_status'      => 'publish',
			'orderby'          => 'title',
			'order'            => 'ASC'
		);

		add_filter( 'posts_where', 'wcpfc_posts_where', 10, 2 );
		$wp_query = new WP_Query( $product_args );
		remove_filter( 'posts_where', 'wcpfc_posts_where', 10, 2 );

		$get_all_products = $wp_query->posts;

		$html = '';
		if ( isset( $get_all_products ) && ! empty( $get_all_products ) ) {
			foreach ( $get_all_products as $get_all_product ) {
				$html .= '<option value="' . esc_attr( $get_all_product->ID ) . '">' . '#' . esc_attr( $get_all_product->ID ) . ' - ' . esc_html( $get_all_product->post_title ) . '</option>';
			}
		}
		echo $html;  // WPCS: XSS OK.
		wp_die();
	}

	/*
	 * review section
	 */

	function wcpfc_admin_footer_review() {
		echo 'If you like <strong>WooCommerce Conditional Product Fees for Checkout</strong> plugin, please leave us ★★★★★ ratings on <a href="https://wordpress.org/support/plugin/woo-conditional-product-fees-for-checkout/reviews/#new-post" target="_blank">WordPress</a>.';
	}
	function wcpfc_plugin_row_meta( $links, $file ) {

		if ( strpos( $file, 'woocommerce-conditional-product-fees-for-checkout.php' ) !== false ) {
			$new_links = array(
				'support' => '<a href="https://www.thedotstore.com/support/" target="_blank">Support</a>',
			);

			$links = array_merge( $links, $new_links );
		}

		return $links;
	}
}