<?php
/**
 * Cart Page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.5.0
 */

defined( 'ABSPATH' ) || exit;

do_action( 'woocommerce_before_cart' ); ?>

<!-- <h3 class="varukorg_title">Varukorg</h3> -->

<form class="woocommerce-cart-form" action="<?php echo esc_url( wc_get_cart_url() ); ?>" method="post">
	<?php do_action( 'woocommerce_before_cart_table' ); ?>

	<table class="shop_table shop_table_responsive cart woocommerce-cart-form__contents custom_view_cart_tbl" cellspacing="0">
		<thead>
			<tr>
				<th class="product-remove">&nbsp;</th>
				<th class="product-thumbnail">&nbsp;</th>
				<th class="product-name"><?php esc_html_e( 'Vin', 'woocommerce' ); ?></th>
<!--				<th class="product-price">--><?php //esc_html_e( 'Price', 'woocommerce' ); ?><!--</th>-->
				<th class="product-quantity"><?php esc_html_e( 'antal flaskor', 'woocommerce' ); ?></th>
				<th class="product-subtotal"><?php esc_html_e( 'pris', 'woocommerce' ); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php do_action( 'woocommerce_before_cart_contents' ); ?>

			<?php
			foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
				$_product   = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
				$product_id = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );

				if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
					$product_permalink = apply_filters( 'woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink( $cart_item ) : '', $cart_item, $cart_item_key );
					?>
					<tr class="woocommerce-cart-form__cart-item <?php echo esc_attr( apply_filters( 'woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key ) ); ?>">

						<td class="product-remove">
							<?php
								// @codingStandardsIgnoreLine
								echo apply_filters( 'woocommerce_cart_item_remove_link', sprintf(
									'<a href="%s" class="remove" aria-label="%s" data-product_id="%s" data-product_sku="%s">&times;</a>',
									esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
									__( 'Remove this item', 'woocommerce' ),
									esc_attr( $product_id ),
									esc_attr( $_product->get_sku() )
								), $cart_item_key );
							?>
						</td>

						<td class="product-thumbnail">
						<?php
						$thumbnail = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );

						if ( ! $product_permalink ) {
							echo $thumbnail; // PHPCS: XSS ok.
						} else {
							printf( '<a href="%s">%s</a>', esc_url( $product_permalink ), $thumbnail ); // PHPCS: XSS ok.
						}
						?>
						</td>

						<td class="product-name" data-title="<?php esc_attr_e( 'Product', 'woocommerce' ); ?>">
						<?php
						if ( ! $product_permalink ) {
							echo wp_kses_post( apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key ) . '&nbsp;' );
						} else {
							echo wp_kses_post( apply_filters( 'woocommerce_cart_item_name', sprintf( '<a href="%s">%s</a>', esc_url( $product_permalink ), $_product->get_name() ), $cart_item, $cart_item_key ) );
						}

						do_action( 'woocommerce_after_cart_item_name', $cart_item, $cart_item_key );

						// Meta data.
						echo wc_get_formatted_cart_item_data( $cart_item ); // PHPCS: XSS ok.

						// Backorder notification.
						if ( $_product->backorders_require_notification() && $_product->is_on_backorder( $cart_item['quantity'] ) ) {
							echo wp_kses_post( apply_filters( 'woocommerce_cart_item_backorder_notification', '<p class="backorder_notification">' . esc_html__( 'Available on backorder', 'woocommerce' ) . '</p>', $product_id ) );
						}
						?>
						</td>

<!--						<td class="product-price" data-title="--><?php //esc_attr_e( 'Price', 'woocommerce' ); ?><!--">-->
<!--							--><?php
//								echo apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key ); // PHPCS: XSS ok.
//							?>
<!--						</td>-->

						<td class="product-quantity" data-title="<?php esc_attr_e( 'Quantity', 'woocommerce' ); ?>">
						<?php
						if ( $_product->is_sold_individually() ) {
							$product_quantity = sprintf( '1 <input type="hidden" name="cart[%s][qty]" value="1" />', $cart_item_key );
						} else {
							$product_quantity = woocommerce_quantity_input( array(
								'input_name'   => "cart[{$cart_item_key}][qty]",
								'input_value'  => $cart_item['quantity'],
								'max_value'    => $_product->get_max_purchase_quantity(),
								'min_value'    => '0',
								'product_name' => $_product->get_name(),
							), $_product, false );
						}

						echo apply_filters( 'woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item ); // PHPCS: XSS ok.
						?>
						</td>

						<td class="product-subtotal" data-title="<?php esc_attr_e( 'Total', 'woocommerce' ); ?>">
							<?php
								echo apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key ); // PHPCS: XSS ok.
							?>
						</td>
					</tr>
					<?php
				}
			}
			?>

			<?php do_action( 'woocommerce_cart_contents' ); ?>

<!--			<tr>-->
<!--				<td colspan="6" class="actions">-->
<!---->
<!--<!--					--><?php ////if ( wc_coupons_enabled() ) { ?>
<!--<!--						<div class="coupon">-->
<!--<!--							<label for="coupon_code">--><?php ////esc_html_e( 'Coupon:', 'woocommerce' ); ?><!--<!--</label>
 <input type="text" name="coupon_code" class="input-text" id="coupon_code" value="" placeholder="-->
            <?php ////esc_attr_e( 'Coupon code', 'woocommerce' ); ?><!--<!--" /> <button type="submit" class="button" name="apply_coupon" value="-->
            <?php ////esc_attr_e( 'Apply coupon', 'woocommerce' ); ?><!--<!--">--><?php ////esc_attr_e( 'Apply coupon', 'woocommerce' ); ?><!--<!--</button>-->
<!--<!--							--><?php ////do_action( 'woocommerce_cart_coupon' ); ?>
<!--<!--						</div>-->
<!--<!--					--><?php ////} ?>
<!---->
<!--<!--					<button type="submit" class="button" name="update_cart" value="--><?php ////esc_attr_e( 'Update cart', 'woocommerce' ); ?><!--<!--">-->
            <?php ////esc_html_e( 'Update cart', 'woocommerce' ); ?><!--<!--</button>-->
<!---->
<!--					--><?php //do_action( 'woocommerce_cart_actions' ); ?>
<!---->
<!--					--><?php //wp_nonce_field( 'woocommerce-cart', 'woocommerce-cart-nonce' ); ?>
<!--				</td>-->
<!--			</tr>-->

 <tr class="update_cart_row">
                <td colspan="6" class="actions">
                    <button type="submit" class="button update_cart_btn" name="update_cart" value="<?php esc_attr_e( 'Update cart', 'woocommerce' ); ?>">
                        <?php esc_html_e( 'Update cart', 'woocommerce' ); ?></button>
                    <?php do_action( 'woocommerce_cart_actions' ); ?>
                    <?php wp_nonce_field( 'woocommerce-cart', 'woocommerce-cart-nonce' ); ?>
                </td>
            </tr>



			<?php do_action( 'woocommerce_after_cart_contents' ); ?>
		</tbody>
	</table>
	<?php do_action( 'woocommerce_after_cart_table' ); ?>
</form>

<div class="cart-collaterals">
	<?php
		/**
		 * Cart collaterals hook.
		 *
		 * @hooked woocommerce_cross_sell_display
		 * @hooked woocommerce_cart_totals - 10
		 */
		do_action( 'woocommerce_cart_collaterals' );
	?>
</div>

<?php do_action( 'woocommerce_after_cart' ); ?>


<div id="vine_checkout_modal" class="modal">

    <!-- Modal content -->
    <div class="modal-content">
        <span class="vine_checkout_modal_close">&times;</span>
        <p>Av miljö- och transport-skäl levererar vi bara fulla lådor med 6 flaskor i varje. Justera din order så antalet flaskor är delbart med 6.</p>
    </div>

</div>
<style>

    /* The Modal (background) */
    .modal {
        display: none; /* Hidden by default */
        position: fixed; /* Stay in place */
        z-index: 1; /* Sit on top */
        padding-top: 100px; /* Location of the box */
        left: 0;
        top: 0;
        width: 100%; /* Full width */
        height: 100%; /* Full height */
        overflow: auto; /* Enable scroll if needed */
        background-color: rgb(0,0,0); /* Fallback color */
        background-color: rgba(0,0,0,0.4); /* Black w/ opacity */
    }

    /* Modal Content */
    .modal-content {
        background-color: #fefefe;
        margin: auto;
        padding: 20px;
        border: 1px solid #888;
        width: 80%;
    }

    /* The Close Button */
    .close {
        color: #aaaaaa;
        float: right;
        font-size: 28px;
        font-weight: bold;
    }

    .close:hover,
    .close:focus {
        color: #000;
        text-decoration: none;
        cursor: pointer;
    }
</style>

<script>
    jQuery(document).ready(function(){

    var inputs = jQuery(".product-quantity >.quantity>.qty");
    var total_val=0;
    for(var i = 0; i < inputs.length; i++){
        //    console.log('Query Inputs '+jQuery(inputs[i]).val());
        total_val+=parseInt(jQuery(inputs[i]).val());
    }
    // if(total_val<6){
    //     var initialBoxes=1;
    //     jQuery('.container_amount >td').html(initialBoxes);
    // }else{
    //     var initialBoxes=parseInt(parseInt(total_val)/6);
    //     jQuery('.container_amount >td').html(initialBoxes);
    // }


    var NumberOfBottles=total_val;
    var NumberOfBottlesConst=0;
    if(NumberOfBottles < 6){
        jQuery('.checkout-button').css('pointer-events','unset');
    }else{
        if(NumberOfBottles%6==0){
            console.log("Can divisable by Zero");
        }else{
            jQuery('.checkout-button').css('pointer-events','unset');
        }
    }

    jQuery('.woocommerce').on('click','.plus',function(){
        var inputs = jQuery(".product-quantity >.quantity>.qty");
        var total_val=0;
        for(var i = 0; i < inputs.length; i++){
            total_val+=parseInt(jQuery(inputs[i]).val());
        }
        console.log('Total value is '+total_val);
        total_val=total_val+1;
        NumberOfBottlesConst=total_val;
        if(NumberOfBottlesConst>=6){
            if(NumberOfBottlesConst%6==0){
                NumberOfBottles=parseInt(NumberOfBottlesConst)+1;
                var numberOfBoxes=parseInt(NumberOfBottles/6);
                jQuery('.container_amount >td').html(numberOfBoxes);
            }else{
                NumberOfBottles=parseInt(NumberOfBottlesConst)+1;
                var numberOfBoxes=parseInt(NumberOfBottlesConst/6)+1;
                jQuery('.container_amount >td').html(numberOfBoxes);
            }
        }else{
            var numberOfBoxes=1;
            jQuery('.container_amount >td').html(numberOfBoxes);
        }
    });

    jQuery('.woocommerce').on('click','.minus',function(){
        var inputs = jQuery(".product-quantity >.quantity>.qty");
        var total_val=0;
        for(var i = 0; i < inputs.length; i++){
            total_val+=parseInt(jQuery(inputs[i]).val());
        }
        total_val=total_val-1;
        console.log('Total value '+total_val);

        NumberOfBottlesConst=total_val;
        if(NumberOfBottlesConst>=6){
            if(NumberOfBottlesConst%6==0){
                NumberOfBottles=parseInt(NumberOfBottlesConst);
                var numberOfBoxes=parseInt(NumberOfBottles/6);
                jQuery('.container_amount >td').html(numberOfBoxes);
            }else{
                NumberOfBottles=parseInt(NumberOfBottlesConst);
                console.log('Number of bottles '+NumberOfBottles);
                var numberOfBoxes=(parseInt(NumberOfBottles)/6)+1;
                console.log('After divide '+parseInt(numberOfBoxes));
                jQuery('.container_amount >td').html(parseInt(numberOfBoxes));
            }
        }
        else{
            var numberOfBoxes=1;
            jQuery('.container_amount >td').html(numberOfBoxes);
        }
    });

    jQuery('.woocommerce').on('keyup','.qty',function(){
        var inputs = jQuery(".product-quantity >.quantity>.qty");
        var total_val=0;
        for(var i = 0; i < inputs.length; i++){
            total_val+=parseInt(jQuery(inputs[i]).val());
        }

        NumberOfBottlesConst=total_val;
        if(NumberOfBottlesConst>=6){
            if(NumberOfBottlesConst%6==0){
                NumberOfBottles=parseInt(NumberOfBottlesConst);
                var numberOfBoxes=parseInt(NumberOfBottles/6);
                jQuery('.container_amount >td').html(numberOfBoxes);
            }else{
                NumberOfBottles=parseInt(NumberOfBottlesConst);
                console.log('Number of bottles '+NumberOfBottles);
                var numberOfBoxes=(parseInt(NumberOfBottles)/6)+1;
                console.log('After divide '+parseInt(numberOfBoxes));
                jQuery('.container_amount >td').html(parseInt(numberOfBoxes));
            }
        }
        else{
            var numberOfBoxes=1;
            jQuery('.container_amount >td').html(numberOfBoxes);
        }
    });


    jQuery('.woocommerce').on('DOMMouseScroll mousewheel','.qty',function(e){

        var inputs = jQuery(".product-quantity >.quantity>.qty");
        var total_val=0;
        for(var i = 0; i < inputs.length; i++){
            total_val+=parseInt(jQuery(inputs[i]).val());
        }
        if(e.originalEvent.detail < 0 || e.originalEvent.wheelDelta > 0){
            //scroll up
            var inputs = jQuery(".product-quantity >.quantity>.qty");
            var total_val=0;
            for(var i = 0; i < inputs.length; i++){
                total_val+=parseInt(jQuery(inputs[i]).val());
            }
            total_val=total_val+1;
            NumberOfBottlesConst=total_val;
            if(NumberOfBottlesConst>=6){
                if(NumberOfBottlesConst%6==0){
                    NumberOfBottles=parseInt(NumberOfBottlesConst)+1;
                    var numberOfBoxes=parseInt(NumberOfBottles/6);
                    jQuery('.container_amount >td').html(numberOfBoxes);
                }else{
                    NumberOfBottles=parseInt(NumberOfBottlesConst)+1;
                    var numberOfBoxes=parseInt(NumberOfBottlesConst/6)+1;
                    jQuery('.container_amount >td').html(numberOfBoxes);
                }
            }else{
                var numberOfBoxes=1;
                jQuery('.container_amount >td').html(numberOfBoxes);
            }
        }else{
            //scrolled down
            var inputs = jQuery(".product-quantity >.quantity>.qty");
            var total_val=0;
            for(var i = 0; i < inputs.length; i++){
                total_val+=parseInt(jQuery(inputs[i]).val());
            }
            total_val=total_val-1;
            console.log('Total value '+total_val);

            NumberOfBottlesConst=total_val;
            if(NumberOfBottlesConst>=6){
                if(NumberOfBottlesConst%6==0){
                    NumberOfBottles=parseInt(NumberOfBottlesConst);
                    var numberOfBoxes=parseInt(NumberOfBottles/6);
                    jQuery('.container_amount >td').html(numberOfBoxes);
                }else{
                    NumberOfBottles=parseInt(NumberOfBottlesConst);
                    console.log('Number of bottles '+NumberOfBottles);
                    var numberOfBoxes=(parseInt(NumberOfBottles)/6)+1;
                    console.log('After divide '+parseInt(numberOfBoxes));
                    jQuery('.container_amount >td').html(parseInt(numberOfBoxes));
                }
            }
            else{
                var numberOfBoxes=1;
                jQuery('.container_amount >td').html(numberOfBoxes);
            }
        }
    });



    jQuery('.checkout-button').attr('id','myBtn');

    // jQuery('.checkout-button').click(function (e) {
    //      e.preventDefault();
    //     var inputs = jQuery(".product-quantity >.quantity>.qty");
    //     var total_val=0;
    //     for(var i = 0; i < inputs.length; i++){
    //         total_val+=parseInt(jQuery(inputs[i]).val());
    //     }

    //     // return false;

    //     NumberOfBottles=total_val;
    //     if(NumberOfBottles%6==0){
    //         jQuery('.checkout-button').unbind('click');
    //         jQuery('#vine_checkout_modal').css('display','none');
    //         // jQuery('.checkout-button').css('pointer-events','unset');
    //     }else{
    //         jQuery('#vine_checkout_modal').css('display','block');
    //         return false;
    //         // jQuery('.checkout-button').css('pointer-events','none');
    //     }

    // });

    // jQuery('.woocommerce >form >.responsive-table>table>tbody>.update_cart_row>td>.update_cart_btn').click(function (e) {
    //     console.log("Update cart button clicked....");
    //     var inputs = jQuery(".product-quantity >.quantity>.qty");
    //     var total_val=0;
    //     for(var i = 0; i < inputs.length; i++){
    //         total_val+=parseInt(jQuery(inputs[i]).val());
    //     }

    //     NumberOfBottlesConst=total_val;

    //     if(NumberOfBottlesConst%6==0){
    //         // jQuery('.checkout-button').unbind('click');
    //         jQuery('#vine_checkout_modal').css('display','none');
    //         // jQuery('.checkout-button').css('pointer-events','unset');
    //     }else{
    //         jQuery('#vine_checkout_modal').css('display','block');
    //         return false;
    //     }

    //     if(NumberOfBottlesConst>=6){
    //         if(NumberOfBottlesConst%6==0){
    //             NumberOfBottles=parseInt(NumberOfBottlesConst);
    //             var numberOfBoxes=parseInt(NumberOfBottles/6);

    //             jQuery('.cart_total_boxes').html(numberOfBoxes);
    //         }else{
    //             NumberOfBottles=parseInt(NumberOfBottlesConst);
    //             var numberOfBoxes=(parseInt(NumberOfBottles)/6)+1;
    //             jQuery('.cart_total_boxes').html(parseInt(numberOfBoxes));
    //         }
    //     }
    //     else{
    //         var numberOfBoxes=1;
    //         jQuery('.cart_total_boxes').html(numberOfBoxes);
    //     }
    // });

    var checkout_modal=document.getElementById('vine_checkout_modal');
    window.onclick = function(event) {
        if (event.target == checkout_modal){
            checkout_modal.style.display = "none";
        }
    }

    jQuery('.vine_checkout_modal_close').click(function(){
        jQuery('#vine_checkout_modal').css('display','none');
    });
    });
    
      function show_vine_cart_modal(){
        jQuery('#vine_checkout_modal').css('display','block');
    }
    
</script>


