<?php
/**
 * Created by Hemantha.
 * User: PARKWAY
 * Date: 2/14/2019
 * Time: 1:09 PM
 */

/*
Plugin Name: preview_next Plugin
Plugin URI: http://abc.com
description: Plugin for go to previous and next posts
Version: 1.0
Author: Parkway
Author URI: http://abc.com
License: GPL2
*/

class MySettingsPage
{
	/**
	 * Holds the values to be used in the fields callbacks
	 */
	private $options;
	public $errorlist;

	/**
	 * Start up
	 */
	public function __construct()
	{
		add_action( 'admin_menu', array( $this, 'add_plugin_page' ) );
		add_action( 'admin_init', array( $this, 'page_init' ) );
		add_shortcode('preview_next_post_links','create_preview_next_shortCode');
		add_action("admin_enqueue_scripts", array($this, "load_plugin_css"));
        add_action("admin_enqueue_scripts", array($this, "load_plugin_js"));

	}

	function load_plugin_css() {
		$plugin_url = plugin_dir_url( __FILE__ );
		wp_enqueue_style( 'style', plugins_url('/css/style.css', __FILE__ ));
	}

	function load_plugin_js(){
        $plugin_url = plugin_dir_url( __FILE__ );
        wp_enqueue_script( 'script', plugins_url('/js/custom.js', __FILE__ ));
    }


	/**
	 * Add options page
	 */
	public function add_plugin_page()
	{
		// This page will be under "Settings"
		add_options_page(
			'Settings Admin',
			'Simple Post Navigation Settings',
			'manage_options',
			'simple_post_navigation_settings',
			array( $this, 'create_admin_page' )
		);
	}

	/**
	 * Options page callback
	 */
	public function create_admin_page()
	{
		// Set class property
		$this->options = get_option( 'my_option_name' );
		$o=get_option( 'my_option_name' );
        $prev_image_details=parse_url($o['prev_image']);
        $next_image_details=parse_url($o['next_image']);

        $prev_image_path=$_SERVER['DOCUMENT_ROOT'].$prev_image_details['path'];
        $next_image_path=$_SERVER['DOCUMENT_ROOT'].$next_image_details['path'];

		?>
		<div class="wrap">
			<h1>Simple Post Navigation Settings</h1>
			<p><strong>Shortcode: </strong></p>
			<div class="shortCodeRow">
				<div class='copied'></div>
				<input id=navShortCode value='[preview_next_post_links prev="" next="" is_title="true"]' readonly>
				<button id=shortCodeCopyBtn>Copy</button>
			</div>

<div class="navNote">
<p><strong>How to use the shortcode:</strong></p>
<p>1) If <strong>is_title="false"</strong> It will use the text we put in <strong>prev="YOUR TEXT"</strong> and <strong>next="YOUR TEXT"</strong>. </br>
2) If you keep <strong>prev=""</strong> and <strong>next=""</strong> empty it will use "Previous" and "Next" in the frontend.</br>
3) If you use <strong>true</strong> or anyother string in the <strong>is_title</strong>, It will use previous and next post's titles.</p>
</div>
			<form method="post" action="options.php" enctype="multipart/form-data">
				<?php
				// This prints out all hidden setting fields
				settings_fields( 'my_option_group' );
				do_settings_sections( 'my-setting-admin' );
				submit_button();
				?>
			</form>

            <div style="display: none;">
                <input type="text" value="<?php echo admin_url( 'admin-ajax.php' );?>" class="plugin_url_input">
            </div>

            <div class="preview_content_prev">
                <p>Previous Link Image</p>
                <div class="image_block">
                <img src="<?php
                if(@getimagesize($o['prev_image'])){
                    echo $o['prev_image'];
                }else{
                    echo "";
                }
                ?>" class="preview_image_preview">
                </div>
                <div class="row">
                <button class="btn btn-danger" id="delete_prev_image" name="<?php echo $prev_image_path;?>">Delete</button>
                </div>
            </div>

            <div class="preview_content_next">
                <p>Next Link Image</p>
                <div class="image_block">
                <img src="<?php
                    if(@getimagesize($o['next_image'])){
                        echo $o['next_image'];
                    }else{
                        echo "";
                    }

                ?>" class="next_image_preview">
                </div>
                <div class="row">
                    <button class="btn btn-danger" id="delete_next_image" name="<?php echo $next_image_path;?>">Delete</button>
                </div>
            </div>

		</div>
		<?php
	}

	/**
	 * Register and add settings
	 */
	public function page_init()
	{
		register_setting(
			'my_option_group', // Option group
			'my_option_name', // Option name
			array( $this, 'handle_file_upload' ) // Sanitize
		);

		add_settings_section(
			'setting_section_id', // ID
			'Add Image to Previous & Next Links', // Title
			array( $this, 'print_section_info' ), // Callback
			'my-setting-admin' // Page
		);

		add_settings_field(
			'prev_image', // ID
			'Previous Link Image', // Title
			array( $this, 'prev_image_callback' ), // Callback
			'my-setting-admin', // Page
			'setting_section_id' // Section
		);

		add_settings_field(
			'next_image',
			'Next Link Image',
			array( $this, 'next_image_callback' ),
			'my-setting-admin',
			'setting_section_id'
		);
	}

	function handle_file_upload($option)
	{

	    //PRESERVE EARLIER ADDED CONTENT

        $this->options = get_option( 'my_option_name' );
		$o=get_option( 'my_option_name' );
		$previous_prev_image=$o['prev_image'];
		$previous_next_image=$o['next_image'];

	    //PRESERVE EARLIER ADDED CONTENT

		$files = $_FILES['my_option_name'];

		$newarray=array();

		//SAVE PREV IMAGE

        if(empty($files['name']['prev_image']) && empty($files['name']['next_image'])){
            echo "Please add atleast one image";
            exit();
        }


			if(!empty($files['name']['prev_image'])) {
				$file = array(
					'name'     => $files['name']['prev_image'],
					'type'     => $files['type']['prev_image'],
					'tmp_name' => $files['tmp_name']['prev_image'],
					'error'    => $files['error']['prev_image'],
					'size'     => $files['size']['prev_image']
				);

//            BASIC IMAGE VALIDATION
                $valid_types=array('image/jpg','image/jpeg','image/gif','image/png');
                if(!in_array($files['type']['prev_image'],$valid_types)){
                    echo "Added file type is not supported by the plugin";
                    exit();
                }


				$allowed_file_types = array('jpg' =>'image/jpg','jpeg' =>'image/jpeg', 'gif' => 'image/gif', 'png' => 'image/png');
				$uploads=wp_handle_upload($file,array('test_form' => FALSE,'mime'=>$allowed_file_types));

				if(!empty($uploads['error'])){
					echo "Added file type is not supported by the plugin";
					exit();
                }

				$uploads['file_name']=$files['name']['prev_image'];
				$uploads['file_category']='prev_image';
				array_push($newarray,$uploads);
			}else{
                $file = array(
                    'name'     => "unknown1.png",
                    'type'     => "",
                    'tmp_name' => "",
                    'error'    => "",
                    'size'     => ""
                );
                $uploads=wp_handle_upload($file,array('test_form' => FALSE));
            }




		if(!empty($files['name']['next_image'])) {
			$file = array(
				'name'     => $files['name']['next_image'],
				'type'     => $files['type']['next_image'],
				'tmp_name' => $files['tmp_name']['next_image'],
				'error'    => $files['error']['next_image'],
				'size'     => $files['size']['next_image']
			);


            //BASIC IMAGE VALIDATION
            $valid_types=array('image/jpg','image/jpeg','image/gif','image/png');
            if(!in_array($files['type']['next_image'],$valid_types)){
                echo "Added file type is not supported by the plugin";
                exit();
            }


			$allowed_file_types = array('jpg' =>'image/jpg','jpeg' =>'image/jpeg', 'gif' => 'image/gif', 'png' => 'image/png');
			$uploads=wp_handle_upload($file,array('test_form' => FALSE,'mime'=>$allowed_file_types ));
			if(!empty($uploads['error'])){
                echo "Added file type is not supported by the plugin";
                exit();
			}
			$uploads['file_name']=$files['name']['next_image'];
			$uploads['file_category']='next_image';
			array_push($newarray,$uploads);
		}else{
            $file = array(
                'name'     => "unknown2.png",
                'type'     => "",
                'tmp_name' => "",
                'error'    => "",
                'size'     => ""
            );
            $uploads=wp_handle_upload($file,array('test_form' => FALSE));
        }

		$this->options = get_option( 'my_option_name' );
		$o=get_option( 'my_option_name' );

        if(!empty($newarray[0]['file_category'])){

	        if(($newarray[0]['file_category']=="prev_image") && ($newarray[1]['file_category']=="next_image")){
		        $option['prev_image']=$newarray[0]['url'];
		        $option['next_image']=$newarray[1]['url'];
	        }

	        if(($newarray[0]['file_category']=="prev_image") && (empty($newarray[1]['file_category']=="next_image"))){
		        $option['prev_image']=$newarray[0]['url'];
		        $option['next_image']=$previous_next_image;
	        }

	        if($newarray[0]['file_category']=="next_image"){
		        $option['prev_image']=$previous_prev_image;
		        $option['next_image']=$newarray[0]['url'];
	        }
        }

        if((empty($newarray[1]['file_category'])) && (($newarray[0]['file_category'] == "next_image"))){
	        $option['prev_image']=$previous_prev_image;
	        $option['next_image']=$newarray[0]['url'];
        }

        return $option;
	}



	public function sanitize( $input )
	{
		$new_input=$input;
		return $new_input;
	}

	/**
	 * Print the Section text
	 */
	public function print_section_info()
	{
		//print 'Enter your settings below:';
	}

	/**
	 * Get the settings option array and print one of its values
	 */
	public function prev_image_callback()
	{
		$this->options = get_option( 'my_option_name' );
		$o=get_option( 'my_option_name' );

		printf(
			'<div class="add_prev_image"><label>Choose file<input type="file" id="prev_image" name="my_option_name[prev_image]" value="'.$o['prev_image'].'"/></label></div>',
			isset( $this->options['prev_image'] ) ? esc_attr( $this->options['prev_image']) : ''
		);
	}

	/**
	 * Get the settings option array and print one of its values
	 */
	public function next_image_callback()
	{
		$this->options = get_option( 'my_option_name' );
		$o=get_option( 'my_option_name' );

		printf(
			'<div class="add_next_image"><label>Choose file<input type="file" id="title" name="my_option_name[next_image]"  value="'.$o['next_image'].'"/></label></div>',
			isset( $this->options['next_image'] ) ? esc_attr( $this->options['next_image']) : ''
		);
	}
}


function create_preview_next_shortCode($atts=""){

    $value=shortcode_atts(array(
         "prev"=>"prev",
         "next"=>"next",
         "is_title"=>"false"
        ),$atts);

    if($value['prev']=="" || empty($value['prev'])){
        $value['prev']="Previous";
    }

    if($value['next']=="" || empty($value['next'])){
        $value['next']="Next";
    }



	$image_array=get_option('my_option_name');

	if(@getimagesize($image_array['prev_image'])){
	    $pre_prev_image="<img src=".$image_array['prev_image'].">";
    }else{
        $pre_prev_image="";
    }


    if(@getimagesize($image_array['next_image'])){
        $pre_next_image="<img src=".$image_array['next_image'].">";
    }else{
        $pre_next_image="";
    }

    if($value["is_title"]=="" || empty($value["is_title"]) || $value["is_title"]=="false"){
        return "<div class='prevNextRow'><div class='prev_image'><a href='". get_permalink(get_adjacent_post(false, '', true))."'>
	".$pre_prev_image."
	<span>".$value['prev']."</span></a></div>
            <div class='next_image'><a href='".get_permalink(get_adjacent_post(false, '', false))."'><span>".$value['next']."</span>
            ".$pre_next_image."
            </a></div></div>";
    }
    else{
	    //GET PREVIOUS POST HEADER TITLE
        $prev_post = get_adjacent_post(false, '', true);
        if(!empty($prev_post)){
            $previous_post_title="<span>".$prev_post->post_title."</span>";
        }else{
            $previous_post_title="<div>&nbsp;</div>";
        }


//        GET NEXT POST HEADER TITLE
        $next_post = get_adjacent_post(false, '', false);
        if(!empty($next_post)){
            $next_post_title="<span>".$next_post->post_title."</span>";
        }else{
            $next_post_title="<div>&nbsp;</div>";
        }

        return "<div class='prev_image'><a href='". get_permalink(get_adjacent_post(false, '', true))."'>
	".$pre_prev_image."
	".$previous_post_title."</a></div>
            <div class='next_image'><a href='".get_permalink(get_adjacent_post(false, '', false))."'>".$next_post_title."
            ".$pre_next_image."
            </a></div>";
    }
}


add_shortcode('preview_next_post_links','create_preview_next_shortCode');

function wpse_load_plugin_css() {
    $plugin_url = plugin_dir_url( __FILE__ );

    wp_enqueue_style( 'simplePostNavigation', $plugin_url . 'css/frontStyle.css' );
}
add_action( 'wp_enqueue_scripts', 'wpse_load_plugin_css' );

if( is_admin() )
	$my_settings_page = new MySettingsPage();


//CREATE SHORT CODE FOR GET THE DETAILS
