<?php
/**
 * The default template for displaying content
 *
 * Used for both single and index/archive/search.
 */
 // woodmart_setup_loop();

$woodmart_loop 		= woodmart_loop_prop( 'woodmart_loop' );
$blog_design   		= woodmart_loop_prop( 'blog_design' );
$desktop_columns    = woodmart_loop_prop( 'blog_columns' );
$tablet_columns     = woodmart_loop_prop( 'blog_columns_tablet' );
$mobile_columns     = woodmart_loop_prop( 'blog_columns_mobile' );
$is_shortcode  		= woodmart_loop_prop( 'blog_type' ) == 'shortcode';
$is_large_image 	= woodmart_get_opt( 'single_post_design' ) == 'large_image';
$classes       		= array();

if ( is_single() && $is_large_image ) $classes[] = 'post-single-large-image';

if( is_single() && !$is_shortcode ) {
	$classes[] = 'post-single-page';
} else {
	$classes[] = 'blog-design-' . $blog_design;
	$classes[] = 'blog-post-loop';
	if( $blog_design == 'chess' ) {
		$classes[] = 'blog-design-small-images';
	}
}

if( ! is_single() || $is_shortcode && 'meta-image' !== $blog_design ) {
	$classes[] = 'blog-style-' . woodmart_get_opt( 'blog_style' );
}

if( is_single() && !$is_shortcode ) {
	$blog_design = 'default';
}

if( ( $blog_design == 'masonry' || $blog_design == 'mask' ) && ( $is_shortcode || ! is_single() ) ){
	if ( ( 'auto' !== $tablet_columns && ! empty( $tablet_columns ) ) || ( 'auto' !== $mobile_columns && ! empty( $mobile_columns ) ) ) {
		$classes[] = woodmart_get_grid_el_class_new( $woodmart_loop, false, $desktop_columns, $tablet_columns, $mobile_columns );
	} else {
		$classes[] = woodmart_get_grid_el_class( $woodmart_loop, $desktop_columns, false, 12 );
	}
}

if( get_the_title() == '' ){
	$classes[] = 'post-no-title';
}

$gallery_slider = apply_filters( 'woodmart_gallery_slider', true );
$gallery = array();

if( get_post_format() == 'gallery' && $gallery_slider ) {
	$gallery = get_post_gallery( false, false );
}

$random = 'carousel-' . rand(100,999);

?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $classes ); ?>>
	<div class="article-inner">
			<header class="entry-header">
					<div class="col-lg-10" style="margin:0 auto;">
				<figure id="<?php echo esc_attr( $random ); ?>" class="entry-thumbnail" <?php echo $owl_attr; ?>>
						<?php if ( is_single() ): ?>
							<?php the_post_thumbnail(); ?>
						<?php endif ?>
					</figure>
				 </div>
			</header><!-- .entry-header -->
			

		<div class="article-body-container">
			

		
			<?php if( woodmart_loop_prop( 'parts_text' ) ) : ?>
				<div class="entry-content wd-entry-content<?php echo woodmart_get_old_classes( ' woodmart-entry-content' ); ?>">
				    <div class="col-lg-12">
					<?php woodmart_get_content( woodmart_loop_prop( 'parts_btn' ), is_single() && !$is_shortcode ); ?>
					</div>
				</div>
			<?php endif; ?>

		
		</div>
	</div>
</article><!-- #post -->


<?php
// Increase loop count
woodmart_set_loop_prop( 'woodmart_loop', $woodmart_loop + 1 );