<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the "site-content" div.
 *
 * @package WordPress
 * @subpackage Twenty_Fifteen
 * @since Twenty Fifteen 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>

  <META NAME="ROBOTS" CONTENT="NOINDEX, NOFOLLOW">

	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<link rel='Favicon icon' type='image/x-icon' href='<?php echo ot_get_option( 'fav_img'); ?>' />

	<?php wp_head(); ?>
	<link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
	<script src="https://code.jquery.com/jquery-2.2.4.min.js" integrity="sha256-BbhdlvQf/xTY9gja0Dq3HiwQF8LaCRTXxZKRutelT44=" crossorigin="anonymous"></script>
</head>

<body <?php body_class(); ?>>

<div class="my_Header">
<nav>
<div class="container">
	<div class="row">
		<div class="Head_col1"><div class="head_Left_menu"><?php wp_nav_menu( array('menu' => 'LeftMenu') ); ?></div></div>
		<div class="Head_col2"><div id="head_Logo"><a href="<?php echo home_url(); ?>"><img class="head_Logo_img" src="<?php echo ot_get_option( 'header_logo'); ?>"></a></div></div>
		<div class="Head_col3"><div class="head_Right_menu"><?php wp_nav_menu( array('menu' => 'RightMenu') ); ?></div></div>
	</div>
</div>
</nav>
</div>



<div class="mobileHeader">
		<div class="mobileHeaderRow">
			<div class="headerLogo">
	  		<a href="<?php echo home_url(); ?>"><img src="<?php echo ot_get_option( 'header_mobile_logo'); ?>"></a>
	  	</div>
			<div class="MobileBurger">
	  		<a href="#" data-activates="slide-out" class="button-collapse show-on-large"><i class="material-icons" id="mob_menu_hide">menu</i></a>
			</div>
		</div>

		<ul id="slide-out" class="side-nav">
				 <div class="closeDiv">
								<a href="#"><img src="<?php echo get_template_directory_uri(); ?>/img/close.svg" id="closeBtn"></a>
				 </div>
				 <div class="mobileMenu">
						 <div class="mobrowmain">
								 <?php wp_nav_menu(array('menu' => 'MobileMenu')); ?>
						 </div>
				 </div>
		</ul>
</div>
